/*
	Author: Shahu Mali
	Date: 23/11/12
	Reason: For Delet DCR Meeting
*/
package ibase.webitm.ejb.wsfa.transactions;

import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;
import ibase.webitm.ejb.*;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.GenericUtility;
import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.*;

import java.util.*;
import java.sql.*;
import java.io.*;
import java.rmi.RemoteException;

import javax.ejb.*;
import javax.naming.InitialContext;

import java.text.*;

import javax.xml.parsers.*;

import org.w3c.dom.*;

import javax.ejb.Stateless;
//@Stateless	commented by Sagar M [22 Nov 2018].

public class  DeleteMeetingProcess extends ProcessEJB implements DeleteMeetingProcessLocal, DeleteMeetingProcessRemote
{
	SessionContext cSessionContext;
	protected static String database = CommonConstants.DB_NAME;

	public void setSessionContext(SessionContext mSessionContext)
	{
		try
		{
			CommonConstants.setIBASEHOME();
			ProcessEJB.DB_NAME = CommonConstants.DB_NAME;
			this.cSessionContext = mSessionContext;
		}
		catch (Exception e)
		{
			System.out.println("Exception :DeleteMeetingProcessEJB :setSessionContext :==>"+e);
		}
	}

	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom2 = null;
		String errString = "";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString("<Root>"+xmlString+"</Root>");
				System.out.println("dom ["+xmlString+"]");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println("dom2 ["+xmlString2+"]");
			}

			errString = process(dom,dom2,windowName,xtraParams);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
		}
		return errString;
	}


	public String process(Document dom, Document dom2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String returnString = "";
		String userId  =  "";
		Connection conn = null;

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );
			conn.setAutoCommit(false);

			ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			HashMap objDetailMap = null;
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());
			//ITMDBAccessHome itmDBAccessHome = (ITMDBAccessHome)initialContext.lookup("ITMDBAccess");
			//ITMDBAccess itmDBAccess = itmDBAccessHome.create();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			 //ITMDBAccessRemote itmDBAccess = (ITMDBAccessRemote)initialContext.lookup("ibase/ITMDBAccessEJB/remote");
			ITMDBAccessEJB itmDBAccess =  new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			String eventDate = checkNull(genericUtility.getColumnValue( "event_date", dom2 ));
			String salesPers = checkNull(genericUtility.getColumnValue( "sales_pers", dom2 ));
			System.out.println("In process DeleteMeetingProcessEJB ["+eventDate+"]["+salesPers+"]");
			if(eventDate == null || eventDate.trim().length() == 0)
			{
				returnString = itmDBAccess.getErrorString("","EVNTDTBLNK",userId);
				return returnString;
			}
			int countSalesPers = 0;
			String query = "SELECT COUNT(1) AS COUNT FROM SALES_PERS WHERE SALES_PERS = ?";
			pstmt =  conn.prepareStatement(query);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				countSalesPers = rs.getInt("COUNT");
			}
			if(countSalesPers == 0 )
			{
				returnString = itmDBAccess.getErrorString("","INVSLSPERS",userId);
				return returnString;
			}
			// Added By Shahu Mali 30/11/12
			String confirmedVal="";
			String confirmedSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE=?";
			pstmt =  conn.prepareStatement(confirmedSql);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmedVal = rs.getString("CONFIRMED");
			}
			rs.close(); rs = null;
			pstmt.close(); pstmt=null;

			if(  confirmedVal != null && "Y".equalsIgnoreCase(confirmedVal))
			{
				returnString = itmDBAccess.getErrorString("","NODELMEET",userId);
				return returnString;
			}
			else
			{
				//Deleting from new DCR tables
				{
					String dcrID= "";
					String meetSql = "SELECT DCR_ID FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";
					pstmt =  conn.prepareStatement(meetSql);
					pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
					pstmt.setString(2, salesPers);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						dcrID= rs.getString("DCR_ID");
					}
					if(dcrID != null && dcrID.trim().length() > 0)
					{
						String delActTranSql = "DELETE FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS =? ";
						PreparedStatement pstmtDelActTran =  conn.prepareStatement(delActTranSql);
						pstmtDelActTran.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
						pstmtDelActTran.setString(2, salesPers);
						pstmtDelActTran.executeUpdate();
						pstmtDelActTran.close(); pstmtDelActTran = null;
						System.out.println("Data From SPRS_ACT_TRAN is deleted");

						String delTravelSql = "DELETE FROM SPRS_TRAVEL WHERE TRAVEL_DATE = ? AND SALES_PERS = ?";

						PreparedStatement pstmtDelTravel =  conn.prepareStatement(delTravelSql);
						pstmtDelTravel.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
						pstmtDelTravel.setString(2, salesPers);
						pstmtDelTravel.executeUpdate();
						pstmtDelTravel.close(); pstmtDelTravel = null;

						String delMeetSql = "DELETE FROM STRG_MEET WHERE EVENT_DATE = ? AND SALES_PERS = ?";

						PreparedStatement pstmtDelMeet =  conn.prepareStatement(delMeetSql);
						pstmtDelMeet.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
						pstmtDelMeet.setString(2, salesPers);
						pstmtDelMeet.executeUpdate();
						pstmtDelMeet.close(); pstmtDelMeet = null;

						String delMeetItemSql = "DELETE FROM STRG_MEET_ITEMS WHERE DCR_ID = ? ";
						PreparedStatement pstmtDelItem =  conn.prepareStatement(delMeetItemSql);
						pstmtDelItem.setString(1, dcrID);
						pstmtDelItem.executeUpdate();
						pstmtDelItem.close(); pstmtDelItem = null;

						String delMeetTeamSql = "DELETE FROM STRG_MEET_TEAM WHERE DCR_ID = ? ";
						PreparedStatement pstmtDelTeam =  conn.prepareStatement(delMeetTeamSql);
						pstmtDelTeam.setString(1, dcrID);
						pstmtDelTeam.executeUpdate();
						pstmtDelTeam.close(); pstmtDelTeam = null;

						//Deleting from old DCR tables
						//Commented by Gaurav Singh on 08-12-14
						/*{
							String deleteDrMainSql = "DELETE FROM DR_MAIN WHERE SALES_PERS= ? AND WORK_DATE=? ";
							pstmt =  conn.prepareStatement(deleteDrMainSql);
							pstmt.setString(1, salesPers);
							pstmt.setTimestamp(2 ,java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.executeUpdate();

							String deleteTravelDetailSql="DELETE FROM DR_TRAVEL_DETAILS WHERE SALES_PERS= ? AND WORK_DATE=? ";
							pstmt =  conn.prepareStatement(deleteTravelDetailSql);
							pstmt.setString(1, salesPers);
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.executeUpdate();

							// Need to confirmed from vaibhav sir
							//String deleteDrChemistVisitSql="DELETE FROM DR_CHEMIST_VISIT WHERE DCR_ID = ? ";
							String deleteDrDoctorVisitSql="DELETE FROM DR_DOCTOR_VISIT WHERE SALES_PERS= ?  AND WORK_DATE=?  ";
							pstmt =  conn.prepareStatement(deleteDrDoctorVisitSql);
							pstmt.setString(1, salesPers);
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.executeUpdate();

							String deleteDrSampleDistributedSql="DELETE FROM DR_SAMPLE_DISTRIBUTED WHERE SALES_PERS = ?  AND WORK_DATE=? ";
							pstmt =  conn.prepareStatement(deleteDrSampleDistributedSql);
							pstmt.setString(1, salesPers);
							pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							pstmt.executeUpdate();
						}*/
						System.out.println("Old DCR tables has been removed.");
						//Returning the success delete message
						returnString = itmDBAccess.getErrorString("","METATRADLT",userId);
					}
					else
					{
						//Returning the failure delete message
						returnString = itmDBAccess.getErrorString("","NODTTOTDLT",userId);
					}
				}//Deleting from new DCR tables
			}//confirmed != 'Y'

		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception e1){}
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.commit();
					conn.close();conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return returnString;
	}

	private String checkNull( String input )
	{
		if( input == null )
		{
			input = "";
		}
		return input;
	}

}

