
/**
 * Initialize the AttachmentsPlugin for given data and return the
 * plugin ui element.
 *
 * @param data The required data for creating attachments plugin.
 *
 * @returns The generated plugin ui element.
 */

function callDataModel(dmConfig,loadFromDM, loadFromServer) {
	//dataModelName : content_library_dm
	var scopeKey=getScopeKey(dmConfig.scopeKey,dmConfig.scopeParams);
	var scopeParm = dmConfig.scopeParams + '&';
	console.log('dataModelName: ',dmConfig,scopeParm,'startTime',new Date());
	if ( window.datamodel && window.datamodel.getDefaultDataModel )
	{
		window.datamodel.getDefaultDataModel(dmConfig.dataModelName,scopeKey, scopeParm, dmConfig.isRefresh, function(resp) {
			console.log("callDataModel resp", loadFromDM,'endTime',new Date());
			loadFromDM(dmConfig.datasourceKey,resp);
		}, function(err) {
			console.log("callDataModel err", err, loadFromServer);
			loadFromServer();
		});
	}
	else
	{
		console.log("callDataModel err", loadFromServer);
		loadFromServer();
	}
}

function getScopeKey(scopeKey,scopeParams){
    var scopeKeyFinal ='';
    if(scopeKey){

		var scopeKeyArray = scopeKey.split("&");
		var scopeParamsArray = scopeParams.split("&");

		for (var i in scopeParamsArray) {
		  var scopeParam = scopeParamsArray[i];
		  var splitScopeParam =scopeParam.split("=");
		  var key= splitScopeParam[0];
		  for(var j in scopeKeyArray){
		     var scopeKey = scopeKeyArray[j];
		    if(key==scopeKey)
		    {
		      var value= splitScopeParam[1];
		      value=  value.split('/').join('~');
		      console.log('scopeKey:::',scopeKey);
		      console.log('value:::',value);
		      scopeKeyFinal=scopeKeyFinal+key+'='+value+'&';
		    }
		  }
		}
		scopeKeyFinal=scopeKeyFinal.slice(0, -1);
	    console.log('scopeKeyFinal::::::::::',scopeKeyFinal)
    }

	return scopeKeyFinal;

}

function callPresDataModel(isRefresh)
{
   console.log("In callPresDataModel function ::"+isRefresh);
   window.datamodel.getDefaultDataModel('brands_index_dm','', '&', isRefresh, function(resp) {
   console.log("callDataModel resp", resp);

   _downloadFiles(resp);

   var jsonArr = [];
   jsonArr.push(resp);

   plugins.PresentationPlayer.getIndexData(jsonArr);
   }, function(err) {
   console.log("callDataModel err", err);
   });
}

 function openComponentANG(compName, compType)
 {
	 console.log('Print inside openComponentANG compName...',compName);
	 console.log('Print inside openComponentANG compType...',compType);
	 openComponentANG(compName, compType, null);
 }
 
 function openComponentANG(compName,compType,exploreData)
 {
	console.log('Inside openComponentAng 1126!!! ['+compType+']');
	var dashboardFound = false;
	console.log('Inside pluginWrapper js 1149!!!! ');
	var componentData = {};
	var compId = 'ang-popup-'+compName;
	componentData['targetId'] = compId;
	componentData['componentName'] = compName;
	componentData['data'] = exploreData;
	createPopup(componentData, compType);
		
 }
 //Added by shrutika on 13-08-19 [End] for Explore option to be added in home screen and report.
 function createPopup(componentData, compType)
 {
	var index = window.location.pathname.indexOf('E12BROWSER');
	var containerClass='angPopupContainer',contentClass='angPopupContent',closeBtnClass='angPopupclose';
	if(index == -1)
	{
		containerClass='angMobPopupContainer';contentClass='angMobPopupContent';closeBtnClass='angMobPopupclose';
	}
	if(compType == 'explore')
	{
		containerClass='angPopupContainer-explore';
		contentClass='angPopupContent-explore';
		closeBtnClass='angPopupclose-explore';
	}
 
	var popupContainer = document.createElement("div");
	popupContainer.className = containerClass;
	var popupContent = document.createElement("div");
	popupContent.className = contentClass;
	//popupContent.id = componentData.targetId;
	var popupContentTarget = document.createElement("div");
	popupContentTarget.id = componentData.targetId;

	var popupCloseBtn = document.createElement("button");
	popupCloseBtn.innerHTML = '&times;';
	popupCloseBtn.className = closeBtnClass;
	popupCloseBtn.onclick = function() {
	   	popupContainer.remove();
		destroyComponent(componentData.componentName);
	}
 
	if(index == -1)
	{
		var popupCloseBtnCont = document.createElement("div");
		popupCloseBtnCont.className = 'angMobPopupCloseCont';
		popupCloseBtnCont.appendChild(popupCloseBtn);
		popupContainer.appendChild(popupCloseBtnCont);
	}
	else
	{
		//popupContainer.appendChild(popupCloseBtn);
		popupContent.appendChild(popupCloseBtn);
	}
	popupContent.appendChild(popupContentTarget);

	popupContainer.appendChild(popupContent);

	document.getElementsByTagName('body')[0].appendChild(popupContainer);
	console.log("print line no 80:::::",)
	loadAddUserTaskComponent(componentData.targetId, JSON.stringify(componentData), null)
}

// Opne Share // -keep
function openSharePlugin(post_descr, data) 
{
	var SharePlugin = window.e12plugin.plugins.SharePlugin;
	var PopupPanel = window.e12plugin.gwtwidgets.PopupPanel;
	var PluginMetadata = window.e12plugin.metadata.PluginMetadata;
	var MetadataKey = window.e12plugin.enums.MetadataKey;
	var MetadataValue = window.e12plugin.metadata.MetadataValue;

	var sharePlugin = new SharePlugin();
	var metadata = new PluginMetadata();
	var serverIP = getBBHostURL();

	metadata.put(MetadataKey.HOST_URL, new MetadataValue(serverIP));
	metadata.put(MetadataKey.POST_DESCR, new MetadataValue(post_descr));
	metadata.put(MetadataKey.CONTENTS, new MetadataValue(data));
	metadata.put(MetadataKey.IS_CLM, new MetadataValue(true));

	sharePlugin.init(metadata);

	var sharePluginPopup = sharePlugin.getAddUI();

	console.log(sharePluginPopup);
	var sharePluginPopupWrapper = new PopupPanel(sharePluginPopup);
	console.log(sharePluginPopupWrapper);
	setTimeout(function() {
		sharePluginPopupWrapper.center();
	}, 10);
}

// -keep
function onErrorLoadFs(err)
{
    console.log('onErrorLoadFs: ' + err);
}

// keep
function removeClass(parentId,className)
{
	try
	{
		console.log('removeClass: ' , parentId,className);
		$('#'+parentId).parents().find('.'+className).removeClass(className);
	}
	catch(e)
	{
		console.log('Error in removeClass');
	}
}

// keep
function numFormat(val, maxDecimalPoints) 
{
	var numFormatter = new Intl.NumberFormat('en-IN', {
	  maximumFractionDigits: maxDecimalPoints,
	  minimumFractionDigits: 0
	})
    return numFormatter.format(val);
}

// keep
function closeEditor(compName)
{
	console.log("Print inside closeEditor::::", compName);
	window.closePopup();
	destroyComponent(compName);
}
