/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportGenerationServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    E12GenericUtility genericUtility = new E12GenericUtility();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String objName = request.getParameter("objName");
        String attachObjLink = request.getParameter("attachObjLink");
        String userCode = request.getParameter("userCode");
        String tranId = request.getParameter("tranId");
        String attachType = request.getParameter("attachType");
        String result = "";
        CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
        try {
            UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userCode);
            Document currentPkTranDom = this.getCurrentTranDom(tranId, userInfo, objName);
            result = this.getAttachmentPath(objName, attachObjLink, userInfo, currentPkTranDom, tranId, attachType);
        }
        catch (ITMException e) {
            e.printStackTrace();
        }
        catch (BaseException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        response.setContentType("text/html");
        response.getWriter().println("Result: " + result);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private String getAttachmentPath(String objName, String attachObjLink, UserInfoBean userInfo, Document currentPkTranDom, String tranId, String attachType) throws ITMException {
        String attachmentPath = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(userInfo);
        try {
            try {
                String selSql = "";
                String[] attachFormField = attachObjLink.split(":");
                String formNo = attachFormField[0];
                String formField = attachFormField[1];
                String reportFileName = "";
                Object linkArgsArr = null;
                Object detailNodeList = null;
                Object detailNode = null;
                Object detailDom = null;
                String linkAgrs = "";
                String linkTitle = "";
                selSql = "SELECT TARGET_OBJ_NAME,LINK_ARG,LINK_TITLE FROM OBJ_LINKS WHERE OBJ_NAME = ? AND FORM_NO = ? AND FIELD_NAME = ? AND LINK_TYPE = ?";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, objName);
                pstmt.setString(2, formNo);
                pstmt.setString(3, formField);
                pstmt.setString(4, "5");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    reportFileName = this.checkNull(rs.getString("TARGET_OBJ_NAME"));
                    linkAgrs = this.checkNull(rs.getString("LINK_ARG"));
                    linkTitle = this.checkNull(rs.getString("LINK_TITLE"));
                }
                String outputFilename = String.valueOf(objName) + "_" + tranId + "_" + linkTitle;
                XSDParser xsdParser = new XSDParser(reportFileName, userInfo);
                BaseLogger.log("3", userInfo, null, "xsdParser:: [" + xsdParser + "]");
                String argXmlString = xsdParser.getArgumentMetaDataString();
                BaseLogger.log("3", userInfo, null, "xsdParser.getArgumentMetaDataString():: [" + argXmlString + "]");
                String reportArgString = this.genReportArgStr(reportFileName, attachType, argXmlString, currentPkTranDom, linkAgrs, userInfo);
                BaseLogger.log("3", userInfo, null, "ReportArgString[" + reportArgString + "]");
                JasperReportGenerator jasperReport = new JasperReportGenerator(userInfo);
                TreeMap argMap = jasperReport.createArgMap(reportArgString);
                BaseLogger.log("3", userInfo, null, "TreeMap:::->" + argMap);
                jasperReport.createReport(reportFileName, argMap, xsdParser, "TelegramAttachments", outputFilename);
                attachmentPath = String.valueOf(ResourceConstants.REPORTDESTINATION) + File.separator + "TelegramAttachments" + File.separator + outputFilename + "." + attachType;
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        return attachmentPath;
    }

    private Connection getConnection(UserInfoBean userInfo) throws ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        String transDB = userInfo.getTransDB();
        try {
            connDriver = new ConnDriver();
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            conn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input.trim();
    }

    private String genReportArgStr(String reportFileName, String attachType, String xsdString, Document transDom, String linkAgrs, UserInfoBean userInfo) throws Exception {
        StringBuffer reportArgString = new StringBuffer();
        try {
            reportArgString.append("<Arguments>");
            reportArgString.append("<Argument id=\"x_path\" name=\"x_path\"><argType>java.lang.String</argType><value>/DocumentRoot/" + reportFileName + "</value></Argument>");
            reportArgString.append("<Argument id=\"design_source\" name=\"design_source\"><argType>java.lang.String</argType><value>" + reportFileName + ".jrxml</value></Argument>");
            reportArgString.append("<Argument id=\"data_source\" name=\"data_source\"><argType>java.lang.String</argType><value>SQL</value></Argument>");
            reportArgString.append("<Argument id=\"bind_type\" name=\"bind_type\"><argType>java.lang.Integer</argType><value>0</value></Argument>");
            reportArgString.append("<Argument id=\"report_type\" name=\"report_type\"><argType>java.lang.String</argType><value>JASPER</value></Argument>");
            reportArgString.append("<Argument id=\"report_save_type\" name=\"report_save_type\"><argType>java.lang.String</argType><value>" + attachType.toUpperCase() + "</value></Argument>");
            if (xsdString != null && xsdString.length() > 0) {
                HashMap<String, String> formValueMap = this.getFormValueMap(transDom);
                HashMap<String, String> linkArgValueMap = this.getLinkArgValueMap(linkAgrs, formValueMap);
                HashMap<String, String> userInfoMap = this.getUserInfoMap(userInfo);
                Document doc = this.genericUtility.parseString(xsdString);
                NodeList argNodeList = doc.getElementsByTagName("argument");
                if (argNodeList != null) {
                    int argCnt = 0;
                    while (argCnt <= argNodeList.getLength()) {
                        Node argNode = argNodeList.item(argCnt);
                        if (argNode != null) {
                            String argName = "";
                            String argType = "";
                            String argValue = "";
                            Node attribute = null;
                            attribute = argNode.getAttributes().getNamedItem("name");
                            if (attribute != null && attribute.getFirstChild() != null) {
                                argName = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("type")) != null && attribute.getFirstChild() != null) {
                                argType = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("value")) != null && attribute.getFirstChild() != null) {
                                argValue = attribute.getFirstChild().getNodeValue();
                            }
                            if (linkArgValueMap != null && linkArgValueMap.containsKey(argName)) {
                                argValue = linkArgValueMap.get(argName);
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            } else if (userInfoMap != null && userInfoMap.containsKey(argValue.toLowerCase())) {
                                argValue = userInfoMap.get(argValue.toLowerCase());
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            }
                        }
                        ++argCnt;
                    }
                }
            }
            reportArgString.append("</Arguments>");
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :: genReportArgStr : [" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return reportArgString.toString();
    }

    private HashMap<String, String> getFormValueMap(Document transactionDom) throws Exception {
        HashMap<String, String> formValueMap = new HashMap<String, String>();
        if (transactionDom != null) {
            NodeList detailNodeList = transactionDom.getElementsByTagName("Detail1");
            Node parentNode = detailNodeList.item(0);
            NodeList childNodeList = parentNode.getChildNodes();
            int childNodeCtr = 0;
            while (childNodeCtr < childNodeList.getLength()) {
                Node childNode = childNodeList.item(childNodeCtr);
                if (childNode != null && childNode.getNodeType() == 1) {
                    String nodeName = childNode.getNodeName();
                    String nodeValue = "";
                    if (childNode.getFirstChild() != null) {
                        nodeValue = childNode.getFirstChild().getNodeValue();
                    }
                    formValueMap.put(nodeName, nodeValue);
                }
                ++childNodeCtr;
            }
        }
        return formValueMap;
    }

    private HashMap<String, String> getLinkArgValueMap(String linkAgrs, HashMap<String, String> formValueMap) throws Exception {
        HashMap<String, String> linkArgValueMap = new HashMap<String, String>();
        if (linkAgrs.length() > 0) {
            String[] linkArgsArr = linkAgrs.split(",");
            int argCnt = 0;
            while (argCnt < linkArgsArr.length) {
                String arg = linkArgsArr[argCnt];
                String[] argNameType = arg.split("\\.");
                if (argNameType != null) {
                    String fieldName = argNameType[0];
                    String argName = argNameType[1].split(":")[1];
                    String argValue = fieldName;
                    if (formValueMap != null && formValueMap.containsKey(fieldName)) {
                        argValue = formValueMap.get(fieldName);
                    }
                    linkArgValueMap.put(argName, argValue);
                }
                ++argCnt;
            }
        }
        return linkArgValueMap;
    }

    private HashMap<String, String> getUserInfoMap(UserInfoBean userInfo) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            if (userInfo != null) {
                String user = userInfo.getLoginCode();
                String entityCode = userInfo.getEntityCode();
                String profileId = userInfo.getProfileId();
                String empCode = userInfo.getEmpCode();
                String reportTo = userInfo.getReportTo();
                String deptCode = userInfo.getDeptCode();
                String userLev = userInfo.getUserLevel();
                String userType = userInfo.getUserType();
                String loginSite = userInfo.getSiteCode();
                if (entityCode == null) {
                    entityCode = "";
                }
                if (user == null) {
                    user = "";
                }
                userInfoMap.put("login_site", loginSite);
                userInfoMap.put("login_code", user);
                userInfoMap.put("entity_code", entityCode);
                userInfoMap.put("profile_id", profileId);
                userInfoMap.put("report_to", reportTo);
                userInfoMap.put("dept_code", deptCode);
                userInfoMap.put("user_lev", userLev);
                userInfoMap.put("user_type", userType);
                userInfoMap.put("emp_code", empCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userInfoMap;
    }

    private Document getCurrentTranDom(String pkValues, UserInfoBean userInfo, String objName) throws ITMException {
        String tranXml = "";
        try {
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranXml = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", pkValues, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return this.genericUtility.parseString(tranXml);
    }
}

