package ibase.webitm.ejb.wsfa.transactions;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;
//import oracle.jdbc.driver.OraclePreparedStatement; 

@Stateless
public class SprsStockistCopy extends ValidatorEJB implements SprsStockistCopyLocal,SprsStockistCopyRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			System.out.println("xmlString:"+xmlString);
			System.out.println("xmlString1:"+xmlString1);
			System.out.println("xmlString2:"+xmlString2);
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockistCopy: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SprsStockistCopy wfValData");
		return (errString); 
	}
	
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		System.out.println(" Sprs Item in function wfValData(dom,dom1,dom2)");
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		String sql = "";
		Connection connectionObject = null;		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]
		String fldStaffSiteString = "";
		//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

		try
		{
			//Commented by saiprasad G.
			/*InitialContext ctx = getInitialContext();
			ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );*/
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented by vinayak on [08/07/2016] [start]
/*			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [08/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [08/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//Modified by Rupesh on [07/08/2012] [To get Employee Hierarcy of loginEmpCode][Start]
			PreparedStatement pstmt2 = null;
			ResultSet rs2 = null;
			String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			Vector v = new Vector();

			//Modified by Abhishek on [03/09/2012][To check the heirarchy in the login code is a Manager][Start]
			/*
			sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  AND RELIEVE_DATE IS NULL START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL ";
			pstmt2 = connectionObject.prepareStatement(sql);
			pstmt2.setString(1, loginEmpCode);
			System.out.println("[SprsStockistCopy][wfValData]SQL of Hierarchy::"+sql);
			rs2 = pstmt2.executeQuery();
			while(rs2.next())
			{
				String empCodeHierarchy = rs2.getString( 1 ); 
				v.addElement(empCodeHierarchy.trim());
			}
			System.out.println("[SprsStockistCopy][wfValData] Employee report to "+loginEmpCode+" are "+v);
			if (rs2 != null)
			{
				rs2.close();
				rs2 = null;
			}
			if (pstmt2 != null)
			{
				pstmt2.close();
				pstmt2 = null;
			}
			*/
			String mgr = getUserType(loginEmpCode,connectionObject);
			if ( mgr.trim().length() > 0 && mgr.equalsIgnoreCase("M"))
			{

				//Modified by Ramchandra on [13/10/2012][To Validate for sales persons  if other than Hierarcy ][Start]
				//sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  AND RELIEVE_DATE IS NULL START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 AND E.RELIEVE_DATE IS NULL ";

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

				//sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ('SP876','ST876','MP876','SP878','SP895')  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 ";
				
				fldStaffSiteString = getFldStaffSiteList(connectionObject);
				System.out.println("Inside [SprsStockistCopy][wfValData]fldStaffSiteString::["+fldStaffSiteString+"]");

				sql ="SELECT E.EMP_CODE EMP_CODE FROM EMPLOYEE E, GRADE G WHERE E.EMP_CODE IN (SELECT EMP_CODE  FROM EMPLOYEE WHERE EMP_SITE IN ("+getFormattedStringBuff(fldStaffSiteString)+")  START WITH EMP_CODE = ?  CONNECT BY PRIOR emp_code = report_to ) AND G.GRADE_CODE = E.GRADE AND G.LEVEL_NO > 0 AND G.LEVEL_NO <= 4 ";

				//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

				pstmt2 = connectionObject.prepareStatement(sql);
				pstmt2.setString(1, loginEmpCode);
				System.out.println("[SprsStockistCopy][wfValData]SQL of Hierarchy::"+sql);
				rs2 = pstmt2.executeQuery();
				while(rs2.next())
				{
					String empCodeHierarchy = rs2.getString( 1 ); 
					v.addElement(empCodeHierarchy.trim());
				}
				System.out.println("[SprsStockistCopy][wfValData] Employee report to "+loginEmpCode+" are "+v);
				if (rs2 != null)
				{
					rs2.close();
					rs2 = null;
				}
				if (pstmt2 != null)
				{
					pstmt2.close();
					pstmt2 = null;
				}
			}
			//Modified by Abhishek on [03/09/2012][To check the heirarchy in the login code is a Manager][End]


			//Modified by Rupesh on [07/08/2012] [To get Employee Hierarcy of loginEmpCode][End]
			
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("currntFormNo"+currentFormNo);
			parentList = dom2.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						if(childNodeName.equalsIgnoreCase("sales_pers__from"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers__from","NULSLSPER",userId,errString,connectionObject);								
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								// Modified by Rupesh [08/08/2012] [To check empty string]
								//if(columnValue != null)
								if(columnValue != null && columnValue.length() > 0)
								{	
									sql = "SELECT * FROM SALES_PERS WHERE SALES_PERS =? ";
									pstmt = connectionObject.prepareStatement(sql);
									/*--Commented and Changes below - Gulzar - 04/09/08 Req ID :SY89SUN019
									if ( this.database.toUpperCase().startsWith("ORACLE") ) 
									{
										((OraclePreparedStatement)pstmt).setFixedCHAR(1,columnValue);
									}
									else
									{
										pstmt.setString(1, columnValue);
									}*/
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if(!rs.next())
									{
										errString = itmDBAccessLocal.getErrorString("sales_pers__from","SLPNOTEXT",userId,errString,connectionObject);
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][Start]
									else
									{
										//Modified by Abhishek on [03/09/2012][To validate in case of manager only]
										//if (!v.contains(columnValue))
										if (mgr.trim().length() > 0 && mgr.equalsIgnoreCase("M") && !v.contains(columnValue))
										{										
											errString = itmDBAccessLocal.getErrorString("sales_pers__from","INVHIEEMP",userId,errString,connectionObject);
										}
										else
										{
											System.out.println("[SprsStockistCopy][wfValData] Employe in Hierarchy");
										}
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][End]			
								}
								// Modified by Rupesh [08/08/2012] [To check empty string][Start]
								else
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers__from","NULSLSPER",userId,errString,connectionObject);
								}
								// Modified by Rupesh [08/08/2012] [To check empty string][End]
							}							
						}
						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][Start]
						else if(childNodeName.equalsIgnoreCase("sales_pers__to"))
						{
							if(childNode.getFirstChild() == null)				
							{
								errString = itmDBAccessLocal.getErrorString("sales_pers__to","NULSLSPER",userId,errString,connectionObject);			
							}
						    else
							{
								String empRelieveDt = "";
								PreparedStatement pstmt1 = null;
								ResultSet rs1 = null;
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								String  sprsFrom = genericUtility.getColumnValue("sales_pers__from",dom);
								sprsFrom = sprsFrom.trim();
								// Modified by Rupesh [08/08/2012] [To check empty string]
								//if(columnValue != null)							
								if(columnValue != null && columnValue.length() > 0)
								{	
									sql = "SELECT RELIEVE_DATE FROM EMPLOYEE WHERE EMP_CODE =? ";
									pstmt1 = connectionObject.prepareStatement(sql);
									pstmt1.setString(1, columnValue);
									rs1 = pstmt1.executeQuery();
									if(rs1.next())
									{
										empRelieveDt = rs1.getString("RELIEVE_DATE");
									}
									if (rs1 != null)
									{
										rs1.close();
										rs1 = null;
									}
									if (pstmt1 != null)
									{
										pstmt1.close();
										pstmt1 = null;
									}
									
									if (empRelieveDt != null && empRelieveDt.trim().length() > 0 )
									{										
										errString = itmDBAccessLocal.getErrorString("sales_pers__to","INVRELEMP",userId,errString,connectionObject);
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][Start]
									else
									{
										//Modified by Abhishek on [03/09/2012][To validate in case of manager only]
										//if (!v.contains(columnValue))
										if (mgr.trim().length() > 0 && mgr.equalsIgnoreCase("M") && !v.contains(columnValue))
										{											
											errString = itmDBAccessLocal.getErrorString("sales_pers__to","INVHIEEMP",userId,errString,connectionObject);
										}
										//Validation to check duplicate employee 
										else 
										{
											if (sprsFrom.equalsIgnoreCase(columnValue))
											{
												errString = itmDBAccessLocal.getErrorString("sales_pers__to","INVDUPEMP",userId,errString,connectionObject);
											}
										}										
									}
									//Modified by Rupesh on [07/08/2012] [To Validate Employee other than Hierarcy of loginEmpCode][End]
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString("sales_pers__to","NULSLSPER",userId,errString,connectionObject);
								}
							}						 
							
						}
						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][End]
				}
				if (errString != null && errString.trim().length()>0)
				{
					break;
				}
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockistCopy: wfValData(Document dom): " + se.getMessage() + ":");
			errString = genericUtility.createErrorString(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockistCopy: wfValData(Document dom): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e){}					
		}
		return (errString);
	}
	
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{

		
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
				System.out.println ("xmlString ==>>"+xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
				System.out.println ("xmlString 1==>>"+xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
				System.out.println ("xmlString 2==>>"+xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SprsStockistCopy :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SprsStockistCopy itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("ITEMCHANGE is called...............................");
		String columnValue = "";
		String returnString = "";					
		Connection connectionObject = null;		
		Statement stmt = null; 
		ResultSet rs = null;		
		StringBuffer valueXmlString = new StringBuffer();

		String salesPersName = "";
		String selectSql = "";
		String salesPers = "";

		int currentFormNo = 0;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			
			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
            //valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			//valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag><![CDATA[");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag><![CDATA[");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("]]></editFlag>\r\n</Header>\r\n");
			System.out.println("currentFormNo ["+currentFormNo+"] currentColumn ["+currentColumn+"]");
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail>\r\n");
					if (currentColumn.trim().equalsIgnoreCase("itm_default")) 
					{
						salesPers = genericUtility.getColumnValue("sales_pers__to",dom);
						
						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][Start]
						String loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
						String userType = "";
						userType = getUserType(loginEmpCode,connectionObject);
						System.out.println("[SprsStockistCopy][wfValData] userType1 -->> "+userType);

						// Modified by Rupesh [07/08/2012][To validate is employee relieved or not][End]

						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [Start]
						if (salesPers != null && salesPers.trim().length() > 0)
						{
						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [End]							
							selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+salesPers+"'";
							System.out.println("selectSql:: "+selectSql);
							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(selectSql);
							if ( rs.next() )
							{
								salesPersName = rs.getString("SP_NAME");
								
								
								//Modified by Rupesh [08/08/2012] [To disable Emp To]  
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<sales_pers__to protect='1'>").append(salesPers).append("</sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect='1'><![CDATA[").append(salesPers).append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
							}
							else
							{
								
								//Modified by Rupesh [08/08/2012] [To disable Emp To]
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<sales_pers__to protect='1'>").append(salesPers).append("</sales_pers__to>\r\n");
								
								//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								valueXmlString.append("<sales_pers__to protect='1'><![CDATA[").append(salesPers).append("]]></sales_pers__to>\r\n");
								
								valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
							}
							rs.close();
							stmt.close();//Gulzar - 04/09/08 Req ID :SY89SUN019
						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [Start]
						}
						else 
						{										
							salesPers = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
							System.out.println("[SprsStockistCopy][itemChanged()] salesPers :: "+salesPers);																
							// Modified by Rupesh [07/08/2012][TO enables Emp To if login employee is manager or Ho][Start]					//valueXmlString.append("<sales_pers__to>").append("<![CDATA["+salesPers+"]]>").append("</sales_pers__to>\r\n");														
							salesPers = salesPers.trim();
							
							selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+salesPers+"'";
							System.out.println("[SprsStockistCopy][itemChanged()] selectSql :: "+selectSql);
							stmt = connectionObject.createStatement();
							rs = stmt.executeQuery(selectSql);
							if ( rs.next() )
							{								
								salesPersName = rs.getString("SP_NAME");							
								valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
							}
							else
							{	
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
							}
							if (rs != null)
							{
								rs.close();
								rs = null;
							}
							if (stmt != null)
							{
								stmt.close();
								stmt = null;
							}	


							if ( userType != null && (userType.equalsIgnoreCase("M")|| userType.equalsIgnoreCase("H")))
							{													
								System.out.println("In Protect 0 Condition");
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [Start]
								//valueXmlString.append("<sales_pers__to protect='0'>").append(salesPers).append("</sales_pers__to>\r\n");
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml][Start]
								//valueXmlString.append("<sales_pers__to protect='0'>").append("").append("</sales_pers__to>\r\n");

								//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
								
								valueXmlString.append("<sales_pers__to protect='0'><![CDATA[").append("").append("]]></sales_pers__to>\r\n");
								valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml][End]
								//Modified By Rupesh [11/01/2013] [To set blank emp_to] [End]
							}
							else
							{	
								System.out.println("In Protect 1 Condition");
								// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
								//valueXmlString.append("<sales_pers__to protect=\"1\">").append(salesPers).append("</sales_pers__to>\r\n");
								valueXmlString.append("<sales_pers__to protect=\"1\"><![CDATA[").append(salesPers).append("]]></sales_pers__to>\r\n");
								
								//Modified By Rupesh [12/01/2013] [To set name of emp_to] [Start]
								valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
								//Modified By Rupesh [12/01/2013] [To set name of emp_to] [End]
							}
							
							// Modified by Rupesh [07/08/2012][TO enables Emp To if login employee is manager or Ho][End]
																				
						}
						// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [End]						
					}
					else if (currentColumn.trim().equalsIgnoreCase("sales_pers__from")) 
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);	
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+columnValue+"'";
						System.out.println("selectSql:: "+selectSql);
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");
							valueXmlString.append("<name_from>").append("<![CDATA["+salesPersName+"]]>").append("</name_from>\r\n");
						}
						else
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]
							//valueXmlString.append("<name_from>").append("").append("</name_from>\r\n");
							valueXmlString.append("<name_from><![CDATA[").append("").append("]]></name_from>\r\n");
						}
						rs.close();
						stmt.close();//Gulzar - 04/09/08 Req ID :SY89SUN019
					}
					// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [Start]
					else if (currentColumn.trim().equalsIgnoreCase("sales_pers__to")) 
					{						
						columnValue = genericUtility.getColumnValue(currentColumn,dom);								
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+columnValue+"'";
						System.out.println("[SprsStockistCopy][itemChanged()] selectSql ::: "+selectSql);
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");
							valueXmlString.append("<name_to>").append("<![CDATA["+salesPersName+"]]>").append("</name_to>\r\n");
						}
						else
						{
							// Modified by Prashant on [13/05/2013][Request Id : ][To set values in cdata of xml]	
							//valueXmlString.append("<name_to>").append("").append("</name_to>\r\n");
							valueXmlString.append("<name_to><![CDATA[").append("").append("]]></name_to>\r\n");
						}
						if (rs != null)
						{
							rs.close();
							rs = null;
						}
						if (stmt != null)
						{
							stmt.close();
							stmt = null;
						}		
					}
					// Modified by Rupesh [25/07/2012] [Add condition to check sales_pers__to value if Copy Stockist occurs from menu option directly.] [End]
					valueXmlString.append("</Detail>\r\n");
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockistCopy: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsStockistCopy :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally 
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
				}
			}
			catch(Exception e){}
		}
		valueXmlString.append("</Root>\r\n");	
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}

	// Modified by Rupesh [07/08/2012][To identify is employee Manager or Ho][start]
	private String getUserType(String empCode,Connection conn) throws ITMException
	{
		System.out.println("In getUserType() method");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String empCodeHO = "";
		String userType1 = "";
		String selectSql = "";
		boolean isEmpMgr = false;
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.GRADE = B.GRADE_CODE " + 
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			System.out.println("[SprsStockistCopy][getUserType()] selectSql -->> "+selectSql);
			rs = pstmt.executeQuery();	
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));	
				System.out.println();
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if (empCodeMGR != null && empCodeMGR.trim().length() > 0)
			{
				userType1 = "M";
				isEmpMgr = true;
			}
			if (isEmpMgr == false)
			{
				selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " + 
				  "WHERE A.EMP_CODE = ? " + 
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +       
				  "AND B.MENU_COL = 1 " +       
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +        
				  "AND B.LEVEL_5 = 1 " +        
				  "AND B.MENU_NAME = 'MR Online Application' ";

				pstmt = conn.prepareStatement(selectSql);
				pstmt.setString( 1, empCode );
				System.out.println("[SprsStockistCopy][getUserType()] selectSql for HO >> "+selectSql);
				rs = pstmt.executeQuery();	
				if(rs.next())
				{
					empCodeHO = checkNull(rs.getString("EMP_CODE"));	
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (empCodeHO != null && empCodeHO.trim().length() > 0)
				{
					userType1 = "H";				
				}
			}	
			System.out.println("[SprsStockistCopy][getUserType()] userType1 >> "+userType1);
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return userType1;		
	}	
	// Modified by Rupesh [07/08/2012][To identify is employee Manager or Ho][End]
	
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][Start]

	public String getFldStaffSiteList(Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String fldStaffSiteString = "";
		String sql = "";
		try
		{
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'FIELDSTAFF_SITELIST' AND ITEM_SER = 'ALL'";
			 pstmt = conn.prepareStatement(sql);
			 rs = pstmt.executeQuery();
			System.out.println("Inside [SprsStockistCopy][getFldStaffSiteList]sql::>"+sql);

			 if (rs.next())
			 {
				fldStaffSiteString = rs.getString("PROP_VALUE");
				fldStaffSiteString = (fldStaffSiteString == null)? "" : fldStaffSiteString.trim();
				System.out.println("Inside [SprsStockistCopy][getFldStaffSiteList]fldStaffSiteString::["+fldStaffSiteString+"]");
			 }
			 if (rs!=null)
			 {
				 rs.close();
				 rs = null;
			 }
			 if (pstmt!=null)
			 {
				 pstmt.close();
				 pstmt = null;
			 }
			
		}
		catch (Exception exp)
		{
			System.out.println("Inside Exception catch [SprsStockistCopy][getFldStaffSiteList]Exception:>>"+exp.getMessage());
			exp.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!=null)
				{
				 rs.close();
				 rs = null;
				}
				if (pstmt!=null)
				{
				 pstmt.close();
				 pstmt = null;
				}				
			}
			catch (Exception e)
			{
				System.out.println("Inside Exception finally [SprsStockistCopy][getFldStaffSiteList]Exception:>>"+e.getMessage());
				e.printStackTrace();
			}
		}
		System.out.println("Returning from [SprsStockistCopy][getFldStaffSiteList]["+fldStaffSiteString+"]");
		return fldStaffSiteString;
	}

	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;
			
			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{ 
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}										
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}	
		return dataString.toString();
	}

	//Modified by Santosh on [30/07/2013][To parameterize the reporting site code][End]

}
