package ibase.webitm.servlet.wsfa;

import java.sql.*;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EventTrackingServlet extends HttpServlet  {
	
	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		doPost(request,response);
	}
	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		System.out.println("##############EventTrackingServlet#################");
	
		
		UserInfoBean userInfoBean = ( UserInfoBean ) request.getSession().getAttribute( "USER_INFO" );
		System.out.println("userId ["+userInfoBean.getLoginCode()+"]");
		String periodCode = request.getParameter("PERIOD_CODE");
		String columnValue = request.getParameter("COLUMNVALUE");
		String salesPerson = request.getParameter("SALES_PERS");
		System.out.println("periodCode::::"+periodCode);
		System.out.println("columnValue::::"+columnValue);
		String returnStr="";
		try 
		{
			if(columnValue.equalsIgnoreCase("PERIOD_CODE"))
			{	
				returnStr = getPeriod(periodCode , userInfoBean.getTransDB());
			}
			else if(columnValue.equalsIgnoreCase("SALES_PERS"))
			{
				returnStr = getSalesPeronName(salesPerson , userInfoBean.getTransDB() );
			}
		} 
		catch (Exception e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println( returnStr );
		
		response.setContentType( "text/xml" );
		response.setHeader( "Cache-Control", "no-cache" );
		response.getWriter().write( returnStr );
	} 
	
	public String getPeriod( String periodCode ,String transDB  ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		ConnDriver connDriver = new ConnDriver();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try 
		{
		
			connectionObject = connDriver.getConnectDB( transDB );
			//Added By Nilesh for showing the FinancialYear Start :: 17-06-19
			/*sql="SELECT A.CODE AS CODE ,A.DESCR AS DESCR FROM PERIOD A WHERE A.CODE BETWEEN TO_CHAR(ADD_MONTHS(SYSDATE,-12),'YYYYMM') AND TO_CHAR(ADD_MONTHS(SYSDATE,0),'YYYYMM') ORDER BY CODE DESC";*/
			sql="SELECT A.CODE AS CODE ,A.DESCR AS DESCR ,Ap.Descr AS FinancialYear FROM PERIOD A ,ACCTPRD AP WHERE A.CODE BETWEEN TO_CHAR(ADD_MONTHS(SYSDATE,-12),'YYYYMM') AND TO_CHAR(ADD_MONTHS(SYSDATE,0),'YYYYMM') and A.ACCT_PRD=AP.CODE AND A.CODE= ?  ORDER BY CODE DESC";
			//Added By Nilesh for showing the FinancialYear End :: 17-06-19
			System.out.println(" selectteam sql [" + sql + "]");
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next()) 
			{
				
				String finanYear = rs.getString("FinancialYear");
				
				valueXmlString.append("<PERIOD domID='" + num	+ "' >\r\n");
				
				valueXmlString.append("<financial_year><![CDATA[").append(finanYear).append("]]></financial_year>\r\n");
				
				valueXmlString.append("</PERIOD>\r\n");
				
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :StrgEventActBean :getPeriod(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :StrgEventActBean :getPeriod(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	
	public String getSalesPeronName( String SalesPerson ,String transDB ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		ConnDriver connDriver = new ConnDriver();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try 
		{
		
			connectionObject = connDriver.getConnectDB( transDB);
			//Added By Nilesh for showing the FinancialYear Start :: 17-06-19
			/*sql="SELECT A.CODE AS CODE ,A.DESCR AS DESCR FROM PERIOD A WHERE A.CODE BETWEEN TO_CHAR(ADD_MONTHS(SYSDATE,-12),'YYYYMM') AND TO_CHAR(ADD_MONTHS(SYSDATE,0),'YYYYMM') ORDER BY CODE DESC";*/
			sql="SELECT LTRIM(RTRIM(A.EMP_FNAME))||' '||LTRIM(RTRIM(A.EMP_MNAME))||' '||LTRIM(RTRIM(A.EMP_LNAME)) AS SP_NAME FROM employee A WHERE emp_code = ? ";
			//Added By Nilesh for showing the FinancialYear End :: 17-06-19
			System.out.println(" selectteam sql [" + sql + "]");
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, SalesPerson);
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next()) 
			{
				
				String name = rs.getString("SP_NAME");
				
				valueXmlString.append("<SALESPERS domID='" + num	+ "' >\r\n");
				
				valueXmlString.append("<sales_name><![CDATA[").append(name).append("]]></sales_name>\r\n");
				
				valueXmlString.append("</SALESPERS>\r\n");
				
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception :StrgEventActBean :getPeriod(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		} 
		finally 
		{
			try 
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if (connectionObject != null && !connectionObject.isClosed()) 
				{					
					connectionObject.close();
					connectionObject = null;
				}
			} 
			catch (Exception e) 
			{
				System.out.println("Exception :StrgEventActBean :getPeriod(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	
}
