/********************************************************
	Title : deleteMeetingIC
	Date  : 04/12/12
	Developer:Rakesh kumar
 ********************************************************/
package ibase.webitm.ejb.wsfa.transactions;


import ibase.webitm.ejb.ValidatorEJB;
import ibase.system.config.ConnDriver;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless	commented by Sagar M [22 Nov 2018].
public class DeleteMeetingIC extends ValidatorEJB implements DeleteMeetingICLocal,DeleteMeetingICRemote
{
	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

	String winName = null;
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			System.out.println("xmlString ::"+xmlString);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return(errString);
	}
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String sql="";
		String errCode="";
		String errorType = "";
		String errString = "";
		String salesPers="";
		String custType = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		ConnDriver connDriver = new ConnDriver();
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
		try
		{

			conn = connDriver.getConnectDB("DriverITM");
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String objName = checkNullAndTrim(getObjNameFromDom(dom, "objName", objContext ));

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr ++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						String eventDate = genericUtility.getColumnValue("event_date", dom);

                        if(eventDate == null || eventDate.trim().length() == 0 || "null".equalsIgnoreCase(eventDate))
						{
							errCode = "NULLDCRDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}

					}
					else if(childNodeName.equalsIgnoreCase("sales_pers"))
					{

						salesPers = genericUtility.getColumnValue("sales_pers", dom);
						String eventDate = genericUtility.getColumnValue("event_date", dom);


                        if(eventDate == null || eventDate.trim().length() == 0 || "null".equalsIgnoreCase(eventDate))
						{
							errCode = "NULLDCRDT";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
                        else if(salesPers == null || salesPers.trim().length() == 0 || "null".equalsIgnoreCase(salesPers))
                        {
                        	errCode = "NULLSLPRS";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
                        }
                        else
                        {
							int countSalesPers = 0;
							String query = "SELECT COUNT(1) AS COUNT FROM SALES_PERS WHERE SALES_PERS = ?";
							PreparedStatement pstmtCountSlprs =  conn.prepareStatement(query);
							pstmtCountSlprs.setString(1, salesPers);
							ResultSet rsCntSlprs = pstmtCountSlprs.executeQuery();
							if( rsCntSlprs.next() )
							{
								countSalesPers = rsCntSlprs.getInt("COUNT");
							}
							rsCntSlprs.close(); rsCntSlprs = null;
							pstmtCountSlprs.close(); pstmtCountSlprs = null;
							if(countSalesPers == 0 )
							{
								errCode = "INVSLSPERS";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}

							String dcrConfirmVal="";
							String dcrConfirmSql = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE SALES_PERS = ? AND EVENT_DATE=?";
							PreparedStatement pstmtConf =  conn.prepareStatement(dcrConfirmSql);
							pstmtConf.setString(1, salesPers);
							pstmtConf.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(eventDate,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat())));
							ResultSet rsConf = pstmtConf.executeQuery();
							if( rsConf.next() )
							{
								dcrConfirmVal = rsConf.getString("CONFIRMED");
							}
							rsConf.close(); rsConf = null;
							pstmtConf.close(); pstmtConf=null;

							if(  dcrConfirmVal != null && "Y".equalsIgnoreCase(dcrConfirmVal))
							{
								errCode = "NODELMEET";
								errList.add(errCode);
								errFields.add(childNodeName.toLowerCase());
							}
                        }
					}
				}
				break;
			}
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			e.printStackTrace();
			errString = e.getMessage();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null)
				{
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;

					}
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}//end of validation
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			System.out.println("xmlString:::::::::::"+xmlString);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);

			valueXmlString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [sales][itemChanged( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		String sql = "";
		String spName="";
		String profileId="";
		String userId="";
		String salesPers="";
		int currentFormNo = 0;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		StringBuffer valueXmlString = new StringBuffer();
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			//conn.setAutoCommit(false);
			connDriver = null;
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");

			switch ( currentFormNo )
			{
			case 1:
			{
				valueXmlString.append("<Detail1>");
				if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
				{
					userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
					sql="select a.sp_name from sales_pers a, users b where a.sales_pers = b.code and b.code= ? ";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,userId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						spName = checkNull(rs.getString("sp_name"));
					}
					rs.close(); rs = null;
					pstmt.close();  pstmt = null;

					valueXmlString.append("<sales_pers protect=\"1\">").append("<![CDATA["+ userId +"]]>").append("</sales_pers>");
					valueXmlString.append("<sp_name protect=\"1\">").append("<![CDATA["+ spName +"]]>").append("</sp_name>");
				}
				valueXmlString.append("</Detail1>");
			}
			break;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				connDriver = null;
				if(conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		valueXmlString.append("</Root>");
		System.out.println("valueXmlString ::"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		try
		{
			String  sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,errorCode);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return msgType;
	}

	private String checkNull(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value;
	}

	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
			for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		System.out.println("objName =["+objName+"]");
		return objName;
	}

	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}


}


