package ibase.webitm.ejb.wsfa.masters;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;

import org.w3c.dom.Document;
import java.math.BigDecimal;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.wsfa.masters.WsfaStanLocalityRoute;
import ibase.webitm.ejb.wsfa.masters.SprsRouteCreationIc;


public class WsfaStanLocalityRoutePostSave extends ValidatorEJB 
{
	E12GenericUtility genericUtility=new E12GenericUtility();
	WsfaStanLocalityRoute wsfaStanLocalityRoute = new WsfaStanLocalityRoute();	
	SprsRouteCreationIc sprsRouteCreationIc = new SprsRouteCreationIc();

	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}
	
	public String postSave(String tranID, String editFlag, String xtraParams, Connection conn,String xmlStringAll) throws Exception
	{
		System.out.println("Inside post save::"+editFlag);
		Document dom = null;
		PreparedStatement pstmt = null;
		String resString = "",sql = "",salesPers = "",trvDistance = "";
		BigDecimal travelDistance = null;
		UserInfoBean userInfo=null;
		String stanCodeFrom = "",stanCodeTo = "",stanCodeFromDescr = "",stanCodeToDescr = "",stanCode = "",routeId = "",localityCodeFrom = "",localityCodeTo = "",stanTypeFrom = "",stanTypeTo = "",routeTypeFrom = "",routeTypeTo = "",localityCodeFr = "",localityCdTo = "";
		try
		{
			if(userInfo == null)
			{
				userInfo = getUserInfo();
			}
			if(xmlStringAll != null && xmlStringAll.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlStringAll);
			}
			salesPers = checkNullAndTrim(genericUtility.getColumnValue("sales_pers", dom));
			stanCodeFrom = checkNullAndTrim(genericUtility.getColumnValue("stan_code__from", dom));
			stanCodeTo = checkNullAndTrim(genericUtility.getColumnValue("stan_code__to", dom));
			stanCodeFromDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_descr__from", dom));
			stanCodeToDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_descr__to", dom));
			routeTypeFrom = checkNullAndTrim(genericUtility.getColumnValue("route_type__from", dom));
			routeTypeTo = checkNullAndTrim(genericUtility.getColumnValue("route_type__to", dom));
			trvDistance = checkNullAndTrim(genericUtility.getColumnValue("distance", dom));
				
			if(editFlag.equalsIgnoreCase("A") && (stanCodeFrom == null || stanCodeFrom.trim().length() == 0))
			{
				stanCode = checkNullAndTrim(createStanCode(conn));
				stanCodeFrom = stanCode;
				localityCodeFrom = stanCode;
			}
			
			if(editFlag.equalsIgnoreCase("A") && (stanCodeTo == null || stanCodeTo.trim().length() == 0))
			{
				stanCode = checkNullAndTrim(createStanCode(conn));
				stanCodeTo = stanCode;
				localityCodeTo = stanCode;
			}
			
			stanTypeFrom = checkNullAndTrim(sprsRouteCreationIc.getStanType(salesPers, localityCodeFrom, routeTypeFrom, stanCodeFrom, userInfo, conn));
			stanTypeTo = checkNullAndTrim(sprsRouteCreationIc.getStanType(salesPers, localityCodeTo, routeTypeTo, stanCodeTo, userInfo, conn));
			
			System.out.println("stanCodeFrom value is::"+stanCodeFrom);
			
			localityCodeFr = getLocalityCode(stanCodeFrom, stanCodeFromDescr, conn);
			if(localityCodeFr != null && localityCodeFr.trim().length() > 0)
			{
				localityCodeFrom = localityCodeFr;
			}
			else
			{
				localityCodeFrom = stanCodeFrom;
			}
			System.out.println("stanCodeTo value is::"+stanCodeTo);
			
			localityCdTo = getLocalityCode(stanCodeTo, stanCodeToDescr, conn);
			if(localityCdTo != null && localityCdTo.trim().length() > 0)
			{
				localityCodeTo = localityCdTo;
			}
			else 
			{
				localityCodeTo = stanCodeTo;
			}
						
			if(editFlag.equalsIgnoreCase("A") && !wsfaStanLocalityRoute.checkStationExist(stanCodeFromDescr,conn))
			{	
				createStation(stanCodeFrom,stanCodeFromDescr,dom,conn);
				createLocality(stanCodeFrom,localityCodeFrom,stanCodeFromDescr,dom,conn);
				routeId = createRoute(stanCodeFrom,stanCodeFromDescr,localityCodeFrom,stanTypeFrom,routeTypeFrom,salesPers,tranID,dom,conn);

				sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_FROM_NEW = 'Y',IS_LOCALITY_FROM_NEW = 'Y',IS_ROUTE_ID__FROM_NEW = 'Y', "
						+ "STAN_CODE__FROM = ?, LOCALITY_CODE__FROM = ?, ROUTE_ID__FROM = ?,STAN_TYPE__FROM = ? WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stanCodeFrom);
				pstmt.setString(2, localityCodeFrom);
				pstmt.setString(3, routeId);
				pstmt.setString(4, stanTypeFrom);
				pstmt.setString(5, tranID);
				int updateCnt = pstmt.executeUpdate();
				if(updateCnt > 0)
				{
					System.out.println("updateCnt in StationCodeFrom["+updateCnt+"]");
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			
			}
			else if(editFlag.equalsIgnoreCase("A") && wsfaStanLocalityRoute.checkStationExist(stanCodeFromDescr,conn) && !checkRouteEntry(salesPers,stanCodeFrom,localityCodeFrom,conn))
			{	
				if(!checkLocalityExist(localityCodeFrom, conn))
				{
					createLocality(stanCodeFrom,localityCodeFrom,stanCodeFromDescr,dom,conn);
				}
				
				routeId = createRoute(stanCodeFrom,stanCodeFromDescr,localityCodeFrom,stanTypeFrom,routeTypeFrom,salesPers,tranID,dom,conn);
				
				if(!stanCodeFrom.equalsIgnoreCase(localityCodeFrom))
				{
					sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_FROM_NEW = 'N',IS_LOCALITY_FROM_NEW = 'N',IS_ROUTE_ID__FROM_NEW = 'Y',STAN_TYPE__FROM = ?, "
							+ "LOCALITY_CODE__FROM = ?, ROUTE_ID__FROM = ? WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, stanTypeFrom);
					pstmt.setString(2, localityCodeFrom);
					pstmt.setString(3, routeId);
					pstmt.setString(4, tranID);
					int updateCnt = pstmt.executeUpdate();
					if(updateCnt > 0)
					{
						System.out.println("updateCnt in StationCodeFrom when exists["+updateCnt+"]");
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_FROM_NEW = 'N',IS_LOCALITY_FROM_NEW = 'Y',IS_ROUTE_ID__FROM_NEW = 'Y',STAN_TYPE__FROM = ?, "
							+ "LOCALITY_CODE__FROM = ?, ROUTE_ID__FROM = ? WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, stanTypeFrom);
					pstmt.setString(2, localityCodeFrom);
					pstmt.setString(3, routeId);
					pstmt.setString(4, tranID);
					int updateCnt = pstmt.executeUpdate();
					if(updateCnt > 0)
					{
						System.out.println("updateCnt in StationCodeFrom when exists["+updateCnt+"]");
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
				}		
			}
			else if(editFlag.equalsIgnoreCase("A") && wsfaStanLocalityRoute.checkStationExist(stanCodeFromDescr,conn) && checkRouteEntry(salesPers,stanCodeFrom,localityCodeFrom,conn))
			{
				sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_FROM_NEW = 'N',IS_LOCALITY_FROM_NEW = 'N',IS_ROUTE_ID__FROM_NEW = 'N',STAN_TYPE__FROM = ? "
						+ " WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stanTypeFrom);
				pstmt.setString(2, tranID);
				int updateCnt = pstmt.executeUpdate();
				if(updateCnt > 0)
				{
					System.out.println("updateCnt in StationCodeFrom when exists["+updateCnt+"]");
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			}
			
			if(editFlag.equalsIgnoreCase("A") && !wsfaStanLocalityRoute.checkStationExist(stanCodeToDescr,conn))
			{	
				createStation(stanCodeTo,stanCodeToDescr,dom,conn);
				createLocality(stanCodeTo,localityCodeTo,stanCodeToDescr,dom,conn);
				routeId = createRoute(stanCodeTo,stanCodeToDescr,localityCodeTo,stanTypeTo,routeTypeTo,salesPers,tranID,dom,conn);
				
				sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_TO_NEW = 'Y',IS_LOCALITY_TO_NEW = 'Y',IS_ROUTE_ID__TO_NEW = 'Y', "
						+ " STAN_CODE__TO = ?, LOCALITY_CODE__TO = ?, ROUTE_ID__TO = ?, STAN_TYPE__TO = ? WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stanCodeTo);
				pstmt.setString(2, localityCodeTo);
				pstmt.setString(3, routeId);
				pstmt.setString(4, stanTypeTo);
				pstmt.setString(5, tranID);
				int updateCnt = pstmt.executeUpdate();
				if(updateCnt > 0)
				{
					System.out.println("updateCnt in StationCodeTo["+updateCnt+"]");
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			}
			else if(editFlag.equalsIgnoreCase("A") && wsfaStanLocalityRoute.checkStationExist(stanCodeToDescr,conn) && !checkRouteEntry(salesPers,stanCodeTo,localityCodeTo,conn))
			{
				if(!checkLocalityExist(localityCodeTo, conn))
				{
					createLocality(stanCodeTo,localityCodeTo,stanCodeToDescr,dom,conn);
				}
				
				routeId = createRoute(stanCodeTo,stanCodeToDescr,localityCodeTo,stanTypeTo,routeTypeTo,salesPers,tranID,dom,conn);
				
				if(!stanCodeFrom.equalsIgnoreCase(localityCodeFrom))
				{
					sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_TO_NEW = 'N',IS_LOCALITY_TO_NEW = 'N',IS_ROUTE_ID__TO_NEW = 'Y', STAN_TYPE__TO = ?, "
							+ " LOCALITY_CODE__TO = ?, ROUTE_ID__TO = ? WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, stanTypeTo);
					pstmt.setString(2, localityCodeTo);
					pstmt.setString(3, routeId);
					pstmt.setString(4, tranID);
					int updateCnt = pstmt.executeUpdate();
					if(updateCnt > 0)
					{
						System.out.println("updateCnt in StationCodeTo when exists["+updateCnt+"]");
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_TO_NEW = 'N',IS_LOCALITY_TO_NEW = 'Y',IS_ROUTE_ID__TO_NEW = 'Y', STAN_TYPE__TO = ?, "
							+ " LOCALITY_CODE__TO = ?, ROUTE_ID__TO = ? WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, stanTypeTo);
					pstmt.setString(2, localityCodeTo);
					pstmt.setString(3, routeId);
					pstmt.setString(4, tranID);
					int updateCnt = pstmt.executeUpdate();
					if(updateCnt > 0)
					{
						System.out.println("updateCnt in StationCodeTo when exists["+updateCnt+"]");
					}
					if (pstmt != null) 
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			else if(editFlag.equalsIgnoreCase("A") && wsfaStanLocalityRoute.checkStationExist(stanCodeToDescr,conn) && checkRouteEntry(salesPers,stanCodeTo,localityCodeTo,conn))
			{
				sql = "UPDATE STAN_LOCALITY_ROUTE SET IS_STAN_TO_NEW = 'N',IS_LOCALITY_TO_NEW = 'N',IS_ROUTE_ID__TO_NEW = 'N', STAN_TYPE__TO = ? "
						+ " WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, stanTypeTo);
				pstmt.setString(2, tranID);
				int updateCnt = pstmt.executeUpdate();
				if(updateCnt > 0)
				{
					System.out.println("updateCnt in StationCodeTo when exists["+updateCnt+"]");
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			}
			
			
			
			if(editFlag.equalsIgnoreCase("A") && !wsfaStanLocalityRoute.checkTravelDistanceEntry(stanCodeFrom, stanCodeTo, conn))
			{
				insertIntoTravelDistance(tranID,stanCodeFrom,stanCodeTo,salesPers,dom,conn);
			}
			
			if(editFlag.equalsIgnoreCase("E") && (trvDistance != null && trvDistance.trim().length() > 0))
			{
				stanCodeFrom = checkNullAndTrim(genericUtility.getColumnValue("stan_code__from", dom));
				stanCodeTo = checkNullAndTrim(genericUtility.getColumnValue("stan_code__to", dom));
				travelDistance = new BigDecimal(trvDistance);
				sql = "UPDATE TRV_DISTANCE SET DISTANCE = ? WHERE STAN_CODE__FROM = ? AND STAN_CODE__TO = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setBigDecimal(1,travelDistance);
				pstmt.setString(2,stanCodeFrom);
				pstmt.setString(3,stanCodeTo);
				int updateCnt = pstmt.executeUpdate();
				if(updateCnt > 0)
				{
					System.out.println("updateCnt in editMode to update distance["+updateCnt+"]");
				}
				if (pstmt != null) 
				{
					pstmt.close();
					pstmt = null;
				}
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		return resString;
	}
	
	private String checkNullAndTrim(String value)
	{
		if ( value == null )
		{
			value = "";
		}
		return value.trim();
	}
	
	private void createStation(String stanCode,String stanDescr,Document dom,Connection conn) throws Exception
	{
		String shDescrStation = "",stateCode = "",pinCode = "",stateCodeBuffer = "",salesPers = "";
		int updtStationCnt = 0;
		PreparedStatement pstmtInsertStation = null;
		try
		{			
			salesPers = checkNullAndTrim(genericUtility.getColumnValue("sales_pers", dom));
			
			stateCodeBuffer = checkNullAndTrim(wsfaStanLocalityRoute.getStateCode(salesPers,conn));
			if(stateCodeBuffer.indexOf(',') > -1)
			{
				String[] stateCodeList = stateCodeBuffer.split(",");
				if(stateCodeList.length >= 1)
				{
					stateCode = checkNullAndTrim(stateCodeList[0]);
				}
				if(stateCodeList.length >= 3)
				{
					pinCode = checkNullAndTrim(stateCodeList[2]);
				}
				else
				{
					pinCode = "";
				}
			}
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String stationDescr = checkNullAndTrim(stanDescr);
			String stationInsertSql = "INSERT INTO STATION(STAN_CODE,DESCR,STATE_CODE,CITY,DISTRICT,CHG_DATE,CHG_USER,CHG_TERM,SH_DESCR,PIN,RD_PERMIT_REQD,STAN_TYPE,ACTIVE) "
					+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertStation = conn.prepareStatement(stationInsertSql);
			pstmtInsertStation.setString(1, checkNullAndTrim(stanCode));
			pstmtInsertStation.setString(2, checkNullAndTrim(stanDescr));
			pstmtInsertStation.setString(3, checkNullAndTrim(stateCode));
			if (stationDescr.trim().length() > 20 )
			{
				shDescrStation = stationDescr.substring(0,20);
			}
			else
			{
				shDescrStation = stationDescr;
			}
			pstmtInsertStation.setString(4, checkNullAndTrim(stanDescr));
			pstmtInsertStation.setString(5, checkNullAndTrim(stanDescr));
			pstmtInsertStation.setTimestamp(6, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertStation.setString(7, checkNullAndTrim(salesPers));
			pstmtInsertStation.setString(8, "SYSTEM");
			pstmtInsertStation.setString(9, checkNullAndTrim(shDescrStation));
			pstmtInsertStation.setString(10, checkNullAndTrim(pinCode));
			pstmtInsertStation.setString(11, "Y");
			pstmtInsertStation.setString(12, "M");
			pstmtInsertStation.setString(13, "Y");
			
			updtStationCnt = pstmtInsertStation.executeUpdate();
			if(updtStationCnt > 0)
			{
				System.out.println("Inserted Successfully into STATION =["+updtStationCnt+"]");
			}
			
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmtInsertStation != null )
				{
					pstmtInsertStation.close();
					pstmtInsertStation = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
	}
	
	private void createLocality(String stanCode,String localityCode,String stanDescr,Document dom,Connection conn) throws Exception
	{
		int updtLocalityCnt = 0;
		String stateCode = "",pinCode = "",countCode = "",shDescrStation = "",stateCodeBuffer = "",salesPers = "";
		PreparedStatement pstmtInsertLocality = null;
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			salesPers = checkNullAndTrim(genericUtility.getColumnValue("sales_pers", dom));
			
			stateCodeBuffer = checkNullAndTrim(wsfaStanLocalityRoute.getStateCode(salesPers,conn));
			if(stateCodeBuffer.indexOf(',') > -1)
			{
				String[] stateCodeList = stateCodeBuffer.split(",");
				if(stateCodeList.length >= 1)
				{
					stateCode = checkNullAndTrim(stateCodeList[0]);
				}
				if(stateCodeList.length >= 2)
				{
					countCode = checkNullAndTrim(stateCodeList[1]);
				}
				else
				{
					countCode = "";
				}
				if(stateCodeList.length >= 3)
				{
					pinCode = checkNullAndTrim(stateCodeList[2]);
				}
				else
				{
					pinCode = "";
				}
			}
			
			if (stanDescr.trim().length() > 20 )
			{
				shDescrStation = stanDescr.substring(0,20);
			}
			else
			{
				shDescrStation = stanDescr;
			}
			
			String localityInsertSql = "INSERT INTO LOCALITY(LOCALITY_CODE,DESCR,CITY,DISTRICT,STAN_CODE,STATE_CODE,PIN,COUNT_CODE,CHG_DATE,CHG_USER,CHG_TERM,LOCALITY_TYPE,LOCALITY_SUBTYPE,STATUS) "
					+ " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertLocality = conn.prepareStatement(localityInsertSql);
			pstmtInsertLocality.setString(1, checkNullAndTrim(localityCode));
			pstmtInsertLocality.setString(2, checkNullAndTrim(stanDescr));
			pstmtInsertLocality.setString(3, checkNullAndTrim(shDescrStation));
			pstmtInsertLocality.setString(4, checkNullAndTrim(shDescrStation));
			pstmtInsertLocality.setString(5, checkNullAndTrim(stanCode));
			pstmtInsertLocality.setString(6, checkNullAndTrim(stateCode));
			pstmtInsertLocality.setString(7, checkNullAndTrim(pinCode));
			pstmtInsertLocality.setString(8, checkNullAndTrim(countCode));
			pstmtInsertLocality.setTimestamp(9, java.sql.Timestamp.valueOf(currDate));
			pstmtInsertLocality.setString(10, checkNullAndTrim(salesPers));
			pstmtInsertLocality.setString(11, "SYSTEM");
			pstmtInsertLocality.setString(12, "N");
			pstmtInsertLocality.setString(13, "O");
			pstmtInsertLocality.setString(14, "A");

			updtLocalityCnt = pstmtInsertLocality.executeUpdate();
			if(updtLocalityCnt > 0)
			{
				System.out.println("Inserted Successfully into LOCALITY =["+updtLocalityCnt+"]");
			}
		}
		catch(Exception e)
		{	
			throw new ITMException(e);		
		}
		finally
		{
			try
			{
				if( pstmtInsertLocality != null )
				{
					pstmtInsertLocality.close();
					pstmtInsertLocality = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
	}
	
	private String getNewRouteID(String sprsCode, Connection conn) throws Exception
	{
		String newRouteID = "1";
		String maxRoutesql = "SELECT MAX(TO_NUMBER(SPRS_ROUTE.ROUTE_ID))+1 FROM SPRS_ROUTE WHERE SPRS_CODE = ? ";
				
		ResultSet rsMaxRoute = null;
		PreparedStatement pstmtMaxRoute = null;
		try
		{
			pstmtMaxRoute = conn.prepareStatement(maxRoutesql);
					
			pstmtMaxRoute.setString(1,sprsCode);       
	
			rsMaxRoute = pstmtMaxRoute.executeQuery();
			if(rsMaxRoute.next())
			{
				newRouteID =  ""+rsMaxRoute.getInt(1);  
				System.out.println("********** Max Route_Id ******************" + newRouteID);
			}
			if ( rsMaxRoute != null )
			{
				rsMaxRoute.close();
				rsMaxRoute = null;
			}
			if ( pstmtMaxRoute != null )
			{
				pstmtMaxRoute.close();
				pstmtMaxRoute = null;
			}
			if ("0".equals(newRouteID.trim()))
			{
				newRouteID = "1";
			}
		}
		catch( Exception e )
		{
			throw e;
		}
		finally
		{
			try
			{
				if ( rsMaxRoute != null )
				{
					rsMaxRoute.close();
					rsMaxRoute = null;
				}
				if ( pstmtMaxRoute != null )
				{
					pstmtMaxRoute.close();
					pstmtMaxRoute = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		System.out.println("newRouteID =["+newRouteID+"]");
		return newRouteID;
	}
	
	private String createRoute(String stanCode,String stanDescr,String localityCode,String stanType,String routeType,String salesPers,String tranId,Document dom,Connection conn) throws ITMException
	{
		ResultSet selectRouteRS = null;
		PreparedStatement pstmtSelectRoute = null;
		PreparedStatement pstmtInsertSprsRoute = null;
		String routeId = "";
		try
		{
			routeId = getNewRouteID(salesPers, conn);
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
						
			String insertSprsRouteSQL = "INSERT INTO SPRS_ROUTE(SPRS_CODE, ROUTE_ID, DESCR , SH_DESCR,REPLY_STATUS, "
					+ " CHG_DATE, CHG_USER, CHG_TERM , STAN_CODE, STATUS, LOCALITY_CODE ,STATION_TYPE, TRAN_ID__REF,ROUTE_TYPE) " +
					" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
			
			String shDescrStation = "";
			if (stanDescr.trim().length() > 14 )
			{
				shDescrStation = stanDescr.substring(0,14);
			}
			else
			{
				shDescrStation = stanDescr;
			}
			
			pstmtInsertSprsRoute = conn.prepareStatement(insertSprsRouteSQL);
			pstmtInsertSprsRoute.setString(1,checkNullAndTrim(salesPers));
			pstmtInsertSprsRoute.setString(2,checkNullAndTrim(routeId));
			pstmtInsertSprsRoute.setString(3,checkNullAndTrim(stanDescr));
			pstmtInsertSprsRoute.setString(4,checkNullAndTrim(shDescrStation));
			pstmtInsertSprsRoute.setString(5,"0");
			pstmtInsertSprsRoute.setTimestamp(6,java.sql.Timestamp.valueOf(currDate));
			pstmtInsertSprsRoute.setString(7,checkNullAndTrim(salesPers));
			pstmtInsertSprsRoute.setString(8,"SYSTEM");
			pstmtInsertSprsRoute.setString(9,checkNullAndTrim(stanCode));
			pstmtInsertSprsRoute.setString(10,"Y");
			pstmtInsertSprsRoute.setString(11,checkNullAndTrim(localityCode));
			pstmtInsertSprsRoute.setString(12,checkNullAndTrim(stanType));
			pstmtInsertSprsRoute.setString(13,checkNullAndTrim(tranId));
			pstmtInsertSprsRoute.setString(14,checkNullAndTrim(routeType));
			int routeInsertCount = pstmtInsertSprsRoute.executeUpdate();
			
			if( pstmtInsertSprsRoute != null )
			{
				pstmtInsertSprsRoute.close();
				pstmtInsertSprsRoute = null;
			}
			
			if ( routeInsertCount > 0 )
			{
				System.out.println("Inserted Successfully into sprs_route =["+routeInsertCount+"]");
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( selectRouteRS != null )
				{
					selectRouteRS.close();
					selectRouteRS = null;
				}
				if ( pstmtSelectRoute != null )
				{
					pstmtSelectRoute.close();
					pstmtSelectRoute = null;
				}
				if( pstmtInsertSprsRoute != null )
				{
					pstmtInsertSprsRoute.close();
					pstmtInsertSprsRoute = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		
		return routeId;
		
	}
	
	public String createStanCode(Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String stanCode = "",sql = "";
		try
		{
			sql = "SELECT substr( '0000' || stan_code_seq.nextval , -5 ) AS STAN_CODE from dual";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stanCode = checkNullAndTrim(rs.getString("STAN_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (SQLException e) 
			{
				e.printStackTrace();
			}
		}
		return stanCode;
	}
	
	private void insertIntoTravelDistance(String tranId,String stanCodeFrom,String stanCodeTo,String salesPers,Document dom,Connection conn) throws ITMException
	{
		int updtTrvDistCnt = 0;
		String travelDescr = "",itemSer = "";
		BigDecimal trvFare = null, trvDistance = null;
		PreparedStatement pstmtInsertTrvDist = null;
		SimpleDateFormat sdf = null;
		try
		{
			trvDistance = new BigDecimal(checkNullAndTrim(genericUtility.getColumnValue("distance", dom)));
			trvFare = new BigDecimal(0);
			travelDescr = checkNullAndTrim(genericUtility.getColumnValue("stan_descr__from", dom)) + " TO " + checkNullAndTrim(genericUtility.getColumnValue("stan_descr__to", dom));
			itemSer = wsfaStanLocalityRoute.getItemSer(salesPers, conn);
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String trvDistanceInsertSql = "INSERT INTO TRV_DISTANCE (STAN_CODE__FROM, STAN_CODE__TO, EFF_FROM, VALID_UPTO, DISTANCE, DESCR, "
					+ " CHG_DATE, CHG_USER, CHG_TERM, TRV_MODE, TRV_FARE, ENTRY_REF_ID, ITEM_SER) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertTrvDist = conn.prepareStatement(trvDistanceInsertSql);
			pstmtInsertTrvDist.setString(1,checkNullAndTrim(stanCodeFrom));
			pstmtInsertTrvDist.setString(2,checkNullAndTrim(stanCodeTo));
			pstmtInsertTrvDist.setTimestamp(3,java.sql.Timestamp.valueOf(checkNullAndTrim(genericUtility.getValidDateTimeString( checkNullAndTrim(genericUtility.getColumnValue("eff_from", dom)), genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ))));
			pstmtInsertTrvDist.setTimestamp(4,java.sql.Timestamp.valueOf(checkNullAndTrim(genericUtility.getValidDateTimeString( checkNullAndTrim(genericUtility.getColumnValue("valid_upto", dom)), genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ))));
			pstmtInsertTrvDist.setBigDecimal(5,trvDistance);
			pstmtInsertTrvDist.setString(6,checkNullAndTrim(travelDescr));
			pstmtInsertTrvDist.setTimestamp(7,java.sql.Timestamp.valueOf(currDate));
			pstmtInsertTrvDist.setString(8,checkNullAndTrim(genericUtility.getColumnValue("sales_pers", dom)));
			pstmtInsertTrvDist.setString(9,"SYSTEM");
			pstmtInsertTrvDist.setString(10,checkNullAndTrim(genericUtility.getColumnValue("trv_mode", dom)));
			pstmtInsertTrvDist.setBigDecimal(11,trvFare);
			pstmtInsertTrvDist.setString(12,checkNullAndTrim(tranId));
			pstmtInsertTrvDist.setString(13,checkNullAndTrim(itemSer));
			updtTrvDistCnt = pstmtInsertTrvDist.executeUpdate();
			
			if( pstmtInsertTrvDist != null )
			{
				pstmtInsertTrvDist.close();
				pstmtInsertTrvDist = null;
			}
			
			if ( updtTrvDistCnt > 0 )
			{
				System.out.println("Inserted Successfully into trv_distance =["+updtTrvDistCnt+"]");
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmtInsertTrvDist != null )
				{
					pstmtInsertTrvDist.close();
					pstmtInsertTrvDist = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}	
	}
	
	public boolean checkRouteEntry(String salesPers,String stanCode,String localityCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isEntryExist = false;
		String sql = "";
		int dupEntryCnt = 0;
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND STAN_CODE = ? AND LOCALITY_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			pstmt.setString(2,stanCode);
			pstmt.setString(3,localityCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dupEntryCnt = rs.getInt("COUNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(dupEntryCnt == 0)
			{
				isEntryExist = false;
			}
			else
			{
				isEntryExist = true;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return isEntryExist;
	}
	
	public String getLocalityCode(String stanCode,String stanCodeDescr,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",localityCode = "";
		int count = 0;
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM LOCALITY WHERE STAN_CODE = ? AND UPPER(DESCR) = UPPER(?)";
			pstmt = conn.prepareStatement(sql);
	        pstmt.setString(1, stanCode);
	        pstmt.setString(2, stanCodeDescr);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt("COUNT");
				System.out.println("Count is::"+count);
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(count > 0)
			{
				sql = "SELECT LOCALITY_CODE FROM LOCALITY WHERE STAN_CODE = ? AND UPPER(DESCR) = UPPER(?)";
				pstmt = conn.prepareStatement(sql);
	            pstmt.setString(1, stanCode);
	            pstmt.setString(2, stanCodeDescr);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					localityCode = rs.getString("LOCALITY_CODE");
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return localityCode;
	}
	public boolean checkLocalityExist(String localityCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isEntryExist = false;
		String sql = "";
		int dupEntryCnt = 0;
		try
		{
			sql = "SELECT COUNT(*) AS COUNT FROM LOCALITY WHERE LOCALITY_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,localityCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dupEntryCnt = rs.getInt("COUNT");
			}
			if( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			if(dupEntryCnt == 0)
			{
				isEntryExist = false;
			}
			else
			{
				isEntryExist = true;
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.getMessage();
			}
		}
		return isEntryExist;
	}
	
	
}