/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.DashboradComponent;
import ibase.webitm.bean.DashboradPage;
import ibase.webitm.bean.GeolocationBean;
import ibase.webitm.ejb.ProfileServiceRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ParseProfile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Stateless;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ProfileServiceEJB
implements ProfileServiceRemote {
    private boolean duplicateTab = false;
    private HashMap<String, DashboradComponent> dashboardMap = new HashMap();

    @Override
    public String getXMLForTabs(String userId, String defaultProfilePath, String defaultUserId, String transDB, UserInfoBean userInfo) throws IllegalArgumentException {
        StringBuffer tabsXml = new StringBuffer("");
        try {
            List<DashboradPage> tabs = this.getTabs(userId, defaultProfilePath, defaultUserId, transDB, userInfo);
            if (tabs != null && tabs.size() > 0) {
                BaseLogger.log("3", userInfo, null, "Marshall Tabs....");
                tabsXml.append("<root>");
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DashboradPage.class});
                Marshaller m = context.createMarshaller();
                StringWriter sw = null;
                for (DashboradPage t : tabs) {
                    sw = new StringWriter();
                    m.marshal((Object)t, (Writer)sw);
                    tabsXml.append(URLDecoder.decode(sw.getBuffer().toString()));
                    int endIndex = tabsXml.indexOf("?>") + "?>".length();
                    if (tabsXml.indexOf("<?xml") == -1) continue;
                    tabsXml.replace(tabsXml.indexOf("<?xml"), endIndex, "");
                }
                tabsXml.append("</root>");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return tabsXml.toString();
    }

    public JSONObject getJSONForTabs(String userId, String defaultProfilePath, String defaultUserId, String transDB, UserInfoBean userInfo) throws IllegalArgumentException {
        JSONArray tabJSON = new JSONArray();
        try {
            List<DashboradPage> tabs = this.getTabs(userId, defaultProfilePath, defaultUserId, transDB, userInfo);
            if (tabs != null && tabs.size() > 0) {
                BaseLogger.log("3", userInfo, null, "Dashboard Tabs....");
                for (DashboradPage t : tabs) {
                    JSONObject tabObject = new JSONObject();
                    tabObject.put("tabId", t.getTabId());
                    tabObject.put("imageUri", (Object)t.getImageUri());
                    tabObject.put("entityCode", (Object)t.getEntityCode());
                    tabObject.put("compType", (Object)t.getCompType());
                    tabObject.put("entityType", (Object)t.getEntityType());
                    tabObject.put("title", (Object)t.getTitle());
                    tabObject.put("uri", t.getUri().equals("%3C%21%5BCDATA%5Bnull%5D%5D%3E") ? JSONObject.NULL : t.getUri());
                    tabObject.put("userId", (Object)t.getUserId());
                    JSONArray dashboardCompArray = new JSONArray();
                    Set<DashboradComponent> dashboardComp = t.getDashboardComp();
                    if (dashboardComp != null) {
                        for (DashboradComponent comp : dashboardComp) {
                            dashboardCompArray.put((Object)new JSONObject().put("tabId", comp.getTabId()).put("columnNo", comp.getColumnNo()).put("defaultAppl", comp.getDefaultAppl() == null ? JSONObject.NULL : comp.getDefaultAppl()).put("rowNo", comp.getRowNo()).put("entityCode", (Object)comp.getEntityCode()).put("entityType", (Object)comp.getEntityType()).put("title", (Object)comp.getTitle()).put("userId", (Object)comp.getUserId()).put("uri", comp.getUri().equals("%3C%21%5BCDATA%5Bnull%5D%5D%3E") ? JSONObject.NULL : comp.getUri()).put("compName", (Object)comp.getCompName()).put("screenId", comp.getScreenId()).put("dbrResource", (Object)comp.getDbrResource()).put("compType", (Object)comp.getCompType()).put("width", comp.getWidth()).put("height", comp.getHeight()));
                        }
                        tabObject.put("dashboardComp", (Object)dashboardCompArray);
                    }
                    tabJSON.put((Object)tabObject);
                }
                return new JSONObject().put("dashboradPage", (Object)tabJSON);
            }
            return new JSONObject().put("dashboradPage", (Object)tabJSON);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<DashboradPage> getTabs(String userId, String defaultProfilePath, String defaultUserId, String transDB, UserInfoBean userInfo) throws IllegalArgumentException {
        List<Object> tabs = new ArrayList();
        try {
            tabs = this.getTabsFromDB(userId, "U", transDB, userInfo);
            if (tabs == null || tabs.size() <= 0) {
                tabs = this.getTabsFromDB(userId, "R", transDB, userInfo);
                if (tabs == null || tabs.size() <= 0) {
                    tabs = this.getTabsFromDB(userId, "F", transDB, userInfo);
                }
                if (tabs == null || tabs.size() <= 0) {
                    tabs = this.getTabsFromDB(defaultUserId, "", transDB, userInfo);
                    if (tabs == null || tabs.size() <= 0) {
                        BaseLogger.log("3", userInfo, null, "Loading Profile from file :" + defaultProfilePath);
                        tabs = this.loadProfileFromFile(defaultProfilePath, userId);
                        if (tabs != null && tabs.size() > 0) {
                            BaseLogger.log("3", userInfo, null, "Tabs Persisted in DB From Profile.xml..." + this.saveTabs(tabs, userId, transDB));
                        }
                    } else {
                        BaseLogger.log("3", userInfo, null, "Tabs Persisted in DB For Default User..." + this.saveTabs(tabs, userId, transDB));
                    }
                    System.out.println("tab value 136!!!! [" + tabs + "]");
                    if (tabs == null || tabs.size() <= 0) {
                        tabs = this.getTabsFromDB("X", "F", transDB, userInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        return tabs;
    }

    private List<DashboradPage> getTabsFromDB(String userId, String entityType, String transDB, UserInfoBean userInfo) throws RemoteException, Exception {
        ArrayList<DashboradPage> tabs = new ArrayList<DashboradPage>();
        ResultSet rs = null;
        String sql = "";
        Object stmt = null;
        Connection connectionObject = null;
        PreparedStatement pstmtDescr = null;
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB(transDB);
                String profileID = userInfo.getProfileId();
                BaseLogger.log("3", userInfo, null, "profileID:[" + profileID + "]");
                if ("R".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = ? AND ENTITY_CODE IN (SELECT ROLE_CODE FROM WF_ROLE_USERS WHERE USERID = ?) ORDER BY PAGE_ID";
                } else if ("F".equals(entityType) && !"X".equalsIgnoreCase(userId)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = '" + entityType + "' AND ENTITY_CODE IN " + "(SELECT PROFILE_ID FROM USERS WHERE CODE = '" + userId + "') ORDER BY PAGE_ID";
                } else if ("U".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = ? AND ENTITY_CODE = ? ORDER BY PAGE_ID";
                } else if ("99999".equals(userId) || "".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_CODE = '99999' ORDER BY PAGE_ID";
                } else if ("X".equalsIgnoreCase(userId)) {
                    sql = "SELECT * FROM DASHBOARD_PAGES WHERE ENTITY_TYPE = '" + entityType + "' AND USER_ID = '" + userId + "' ";
                }
                pstmtDescr = connectionObject.prepareStatement(sql);
                if ("R".equals(entityType) || "U".equals(entityType)) {
                    pstmtDescr.setString(1, entityType);
                    pstmtDescr.setString(2, userId);
                }
                rs = pstmtDescr.executeQuery();
                this.dashboardMap = new HashMap();
                DashboradPage tab = null;
                while (rs.next()) {
                    tab = new DashboradPage();
                    long tabid = rs.getLong("PAGE_ID");
                    tab.setTabId(tabid);
                    tab.setEntityType(rs.getString("ENTITY_TYPE"));
                    tab.setEntityCode(rs.getString("ENTITY_CODE"));
                    tab.setUserId(rs.getString("USER_ID"));
                    tab.setTitle(rs.getString("TITLE"));
                    String entityCode = rs.getString("ENTITY_CODE");
                    tab.setUri(URLEncoder.encode("<![CDATA[" + rs.getString("URI") + "]]>"));
                    tab.setImageUri(rs.getString("IMAGE_URI"));
                    tab.setCompType(rs.getString("COMP_TYPE"));
                    if ("R".equals(entityType)) {
                        tab.setDashboardComp(this.getScreens(tabid, userId, "R", transDB, userInfo, entityCode));
                    } else if ("F".equals(entityType)) {
                        tab.setDashboardComp(this.getScreens(tabid, userId, "F", transDB, userInfo, entityCode));
                    } else if ("U".equals(entityType)) {
                        tab.setDashboardComp(this.getScreens(tabid, userId, "U", transDB, userInfo, entityCode));
                    } else {
                        tab.setDashboardComp(this.getScreens(tabid, userId, "", transDB, userInfo, entityCode));
                    }
                    BaseLogger.log("3", userInfo, null, "duplicateTab for " + rs.getString("TITLE") + " :[" + this.duplicateTab + "]");
                    if (this.duplicateTab) continue;
                    tabs.add(tab);
                }
                BaseLogger.log("3", userInfo, null, "Tab List Size:" + tabs.size());
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                    pstmtDescr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in getTabsFormDB of ProfileServiceEJB  == >" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ProfileServiceEJB :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return tabs;
    }

    private Set<DashboradComponent> getScreens(long tabId, String userId, String entityType, String transDB, UserInfoBean userInfo, String entityCode) throws Exception, ITMException {
        HashSet<DashboradComponent> dashboardCompSet = null;
        ResultSet rs = null;
        String sql = "";
        Connection connectionObject = null;
        PreparedStatement pstmtDescr = null;
        try {
            try {
                dashboardCompSet = new HashSet<DashboradComponent>();
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                connectionObject = connDriver.getConnectDB(transDB);
                if ("R".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_TYPE = ? AND ENTITY_CODE IN (SELECT ROLE_CODE FROM WF_ROLE_USERS WHERE USERID = ?) ";
                } else if ("F".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_TYPE = ? AND ENTITY_CODE = ? ";
                } else if ("U".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_TYPE = ? AND ENTITY_CODE = ? ";
                } else if ("99999".equals(userId) || "".equals(entityType)) {
                    sql = "SELECT * FROM DASHBOARD_COMP WHERE PAGE_ID = ? AND ENTITY_CODE = '99999' ";
                }
                pstmtDescr = connectionObject.prepareStatement(sql);
                if ("R".equals(entityType) || "U".equals(entityType)) {
                    pstmtDescr.setLong(1, tabId);
                    pstmtDescr.setString(2, entityType);
                    pstmtDescr.setString(3, userId);
                } else if ("F".equals(entityType)) {
                    pstmtDescr.setLong(1, tabId);
                    pstmtDescr.setString(2, entityType);
                    pstmtDescr.setString(3, entityCode);
                } else if ("99999".equals(userId) || "".equals(entityType)) {
                    pstmtDescr.setLong(1, tabId);
                }
                rs = pstmtDescr.executeQuery();
                DashboradComponent dashboardComp = null;
                while (rs.next()) {
                    dashboardComp = new DashboradComponent();
                    dashboardComp.setTabId(tabId);
                    dashboardComp.setScreenId(rs.getLong("COMP_ID"));
                    dashboardComp.setEntityType(rs.getString("ENTITY_TYPE"));
                    dashboardComp.setEntityCode(rs.getString("ENTITY_CODE"));
                    dashboardComp.setUserId(rs.getString("USER_ID"));
                    dashboardComp.setTitle(rs.getString("TITLE"));
                    dashboardComp.setUri(URLEncoder.encode("<![CDATA[" + rs.getString("URI") + "]]>"));
                    dashboardComp.setWidth(rs.getInt("WIDTH"));
                    dashboardComp.setHeight(rs.getInt("HEIGHT"));
                    dashboardComp.setColumnNo(rs.getInt("COLUMN_NO"));
                    dashboardComp.setRowNo(rs.getInt("ROW_NO"));
                    dashboardComp.setCompType(rs.getString("COMP_TYPE"));
                    dashboardComp.setCompName(rs.getString("COMP_NAME"));
                    String dbrResource = rs.getString("DBR_RESOURCE");
                    BaseLogger.log("3", userInfo, null, "dbrResource:::>" + dbrResource);
                    try {
                        if (dbrResource != null && dbrResource.length() > 0) {
                            String metadataPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "dashboard" + File.separator + "metadataxml" + File.separator + dbrResource + ".xml";
                            BaseLogger.log("3", userInfo, null, "metadataPath:::>" + metadataPath);
                            File metadataFile = new File(metadataPath);
                            BaseLogger.log("3", userInfo, null, "metadataFile:::>" + metadataFile.exists());
                            if (metadataFile.exists() && metadataFile.length() > 0L) {
                                Document document = new E12GenericUtility().parseFile(metadataFile);
                                NodeList parentList = document.getElementsByTagName("component");
                                int i = 0;
                                while (i < parentList.getLength()) {
                                    Node parentNode = parentList.item(i);
                                    NodeList childList = parentNode.getChildNodes();
                                    int j = 0;
                                    while (j < childList.getLength()) {
                                        Node childNode = childList.item(j);
                                        if (childNode != null && "default_appl".equalsIgnoreCase(childNode.getNodeName()) && childNode.getFirstChild() != null) {
                                            String defaultApplValue = childNode.getFirstChild().getNodeValue();
                                            BaseLogger.log("3", userInfo, null, "defaultApplValue :::[" + metadataFile.exists() + "]");
                                            dashboardComp.setDefaultAppl(defaultApplValue);
                                        }
                                        ++j;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", userInfo, null, "Exception in ProfileServiceEJB defaultAppl :::>" + e.getMessage());
                        e.printStackTrace();
                    }
                    dashboardComp.setDbrResource(dbrResource);
                    dashboardCompSet.add(dashboardComp);
                    BaseLogger.log("3", userInfo, null, "dbrResource:[" + dbrResource + "]");
                    if (this.dashboardMap.containsKey(dbrResource) && dbrResource != null && dbrResource.trim().length() > 0) {
                        this.duplicateTab = true;
                        continue;
                    }
                    this.duplicateTab = false;
                    this.dashboardMap.put(dbrResource, dashboardComp);
                }
                BaseLogger.log("3", userInfo, null, "Screen List Size:" + dashboardCompSet.size());
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in ProfileServiceEJB  getScreens== >" + e.getMessage());
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ProfileServiceEJB getScreens:==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return dashboardCompSet;
    }

    private boolean updateScreenPositions(String userId, List<DashboradComponent> screens, UserInfoBean userInfo) throws RemoteException, Exception {
        boolean isUpdated = false;
        String sql = "";
        Object stmt = null;
        Connection connectionObject = null;
        PreparedStatement pstmtDescr = null;
        String transDB = "";
        try {
            try {
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                connectionObject = connDriver.getConnectDB(transDB);
                sql = "UPDATE DASHBOARD_COMP SET COLUMN_NO = ?, ROW_NO = ? WHERE COMP_ID = ? AND USER_ID = ? ";
                pstmtDescr = connectionObject.prepareStatement(sql);
                for (DashboradComponent scr : screens) {
                    pstmtDescr.setInt(1, scr.getColumnNo());
                    pstmtDescr.setInt(2, scr.getRowNo());
                    pstmtDescr.setLong(3, scr.getScreenId());
                    pstmtDescr.setString(4, userId);
                    pstmtDescr.executeUpdate();
                }
                if (pstmtDescr != null) {
                    pstmtDescr.close();
                }
                isUpdated = true;
                connectionObject.commit();
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception in ProfileServiceEJB  getScreens== >");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (connectionObject != null && !connectionObject.isClosed()) {
                    connectionObject.close();
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ProfileServiceEJB getScreens:==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return isUpdated;
    }

    private boolean saveTabs(List<DashboradPage> dashboradPages, String userId, String transDB) throws RemoteException, Exception {
        boolean isSaved = false;
        Connection conn = null;
        Statement pstmtPages = null;
        Statement pstmtComp = null;
        try {
            try {
                String dashboardPagesSql = "";
                String dashboardCompSql = "";
                ConnDriver connDriver = null;
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                String sysdateStr = E12GenericUtility.getSysdate();
                dashboardPagesSql = "INSERT INTO DASHBOARD_PAGES(USER_ID,PAGE_ID,TITLE,URI,IMAGE_URI,PAGE_TYPE,ENTITY_TYPE,ENTITY_CODE,CHG_USER,CHG_TERM,COMP_TYPE,CHG_DATE) VALUES(?,?,?,?,?,?,?,?,?,?,?," + sysdateStr + ")";
                dashboardCompSql = "INSERT INTO DASHBOARD_COMP(USER_ID,PAGE_ID,COMP_ID,TITLE,URI,WIDTH,HEIGHT,ROW_NO,COLUMN_NO,ENTITY_TYPE,ENTITY_CODE,COMP_TYPE,COMP_NAME,DBR_RESOURCE ) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                pstmtPages = conn.prepareStatement(dashboardPagesSql);
                pstmtComp = conn.prepareStatement(dashboardCompSql);
                InetAddress ip = InetAddress.getLocalHost();
                if (dashboradPages != null && dashboradPages.size() > 0) {
                    for (DashboradPage dashboardpage : dashboradPages) {
                        long pageId = dashboardpage.getTabId();
                        dashboardpage.setTabId(pageId);
                        pstmtPages.setString(1, userId);
                        pstmtPages.setLong(2, dashboardpage.getTabId());
                        pstmtPages.setString(3, dashboardpage.getTitle());
                        String pageUri = URLDecoder.decode(dashboardpage.getUri());
                        pageUri = pageUri.replace("<![CDATA[", "").replace("]]>", "");
                        pstmtPages.setString(4, pageUri);
                        pstmtPages.setString(5, dashboardpage.getImageUri());
                        pstmtPages.setString(6, "T");
                        pstmtPages.setString(7, "U");
                        pstmtPages.setString(8, userId);
                        pstmtPages.setString(9, userId);
                        pstmtPages.setString(10, ip.getHostAddress());
                        pstmtPages.setString(11, dashboardpage.getCompType());
                        pstmtPages.executeUpdate();
                        if (dashboardpage.getDashboardComp() == null || dashboardpage.getDashboardComp().size() <= 0) continue;
                        for (DashboradComponent dashboardComp : dashboardpage.getDashboardComp()) {
                            long screenId = dashboardComp.getScreenId();
                            dashboardComp.setScreenId(screenId);
                            pstmtComp.setString(1, userId);
                            pstmtComp.setLong(2, dashboardpage.getTabId());
                            pstmtComp.setLong(3, dashboardComp.getScreenId());
                            pstmtComp.setString(4, dashboardComp.getTitle());
                            String compUri = URLDecoder.decode(dashboardComp.getUri());
                            compUri = compUri.replace("<![CDATA[", "").replace("]]>", "");
                            pstmtComp.setString(5, compUri);
                            pstmtComp.setInt(6, dashboardComp.getWidth());
                            pstmtComp.setInt(7, dashboardComp.getHeight());
                            pstmtComp.setInt(8, dashboardComp.getRowNo());
                            pstmtComp.setInt(9, dashboardComp.getColumnNo());
                            pstmtComp.setString(10, "U");
                            pstmtComp.setString(11, userId);
                            pstmtComp.setString(12, dashboardComp.getCompType());
                            pstmtComp.setString(13, dashboardComp.getCompName());
                            pstmtComp.setString(14, dashboardComp.getDbrResource());
                            pstmtComp.executeUpdate();
                        }
                    }
                }
                isSaved = true;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in ProfileServiceEJB  saveTabs== >");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmtComp != null) {
                    pstmtComp.close();
                    pstmtComp = null;
                }
                if (pstmtPages != null) {
                    pstmtPages.close();
                    pstmtPages = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :ProfileServiceEJB saveTabs:==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return isSaved;
    }

    private int getNextSeq(String tableName, String userId, int pageId, Connection conn) throws RemoteException, Exception {
        int sequenceNo = 1;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            try {
                String seqSQL = "";
                if ("DASHBOARD_PAGES".equalsIgnoreCase(tableName)) {
                    seqSQL = "SELECT MAX(PAGE_ID) FROM DASHBOARD_PAGES WHERE USER_ID = '" + userId + "'";
                } else if ("DASHBOARD_COMP".equalsIgnoreCase(tableName)) {
                    seqSQL = "SELECT MAX(COMP_ID) FROM DASHBOARD_COMP WHERE USER_ID = '" + userId + "'" + " AND PAGE_ID = " + pageId;
                }
                stmt = conn.createStatement();
                rs = stmt.executeQuery(seqSQL);
                if (rs.next()) {
                    sequenceNo = rs.getInt(1) + 1;
                }
                BaseLogger.log("3", null, null, "sequenceNo>>" + sequenceNo);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "Exception :ProfileServiceEJB saveTabs:==>\n" + e2.getMessage());
                    throw new ITMException(e2);
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (stmt != null) {
                    stmt.close();
                    stmt = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :ProfileServiceEJB saveTabs:==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        return sequenceNo;
    }

    private List<DashboradPage> loadProfileFromFile(String fileName, String forUserId) {
        List<DashboradPage> tabdaos = null;
        try {
            BaseLogger.log("3", null, null, String.valueOf(fileName) + " a valid Profile file.");
            File profileFile = new File(fileName);
            if (profileFile.isFile()) {
                ParseProfile pp = new ParseProfile(forUserId);
                if (pp.parse(profileFile)) {
                    tabdaos = pp.getTabdaos();
                }
            } else {
                BaseLogger.log("3", null, null, String.valueOf(fileName) + " not a valid Profile file.");
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Unable to load profile from file " + fileName + e.getMessage());
            e.printStackTrace();
        }
        return tabdaos;
    }

    @Override
    public Boolean saveScreenPositions(String userId, String posXmlStr, UserInfoBean userInfo) throws Exception {
        BaseLogger.log("3", userInfo, null, "Unmarshall Screens....");
        ArrayList<DashboradComponent> screens = new ArrayList<DashboradComponent>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(posXmlStr.getBytes()));
        NodeList screenNodeList = doc.getElementsByTagName("screen");
        DashboradComponent screen = null;
        int i = 0;
        while (i < screenNodeList.getLength()) {
            Node s = screenNodeList.item(i);
            screen = new DashboradComponent();
            NodeList spNodeList = s.getChildNodes();
            int j = 0;
            while (j < spNodeList.getLength()) {
                Node sp = spNodeList.item(j);
                if (sp.getNodeName().equals("screenId")) {
                    screen.setScreenId(new Long(sp.getFirstChild().getNodeValue()));
                } else if (sp.getNodeName().equals("columnNo")) {
                    screen.setColumnNo(new Integer(sp.getFirstChild().getNodeValue()));
                } else if (sp.getNodeName().equals("rowNo")) {
                    screen.setRowNo(new Integer(sp.getFirstChild().getNodeValue()));
                }
                ++j;
            }
            screens.add(screen);
            ++i;
        }
        return this.updateScreenPositions(userId, screens, userInfo);
    }

    @Override
    public String getDashboardLocacity(double clientLongitude, double clientLattitude, String userId, UserInfoBean userInfo) throws ITMException {
        String closestLocDescr;
        String closestLocCode;
        block22: {
            closestLocCode = "";
            closestLocDescr = "";
            Connection connection = null;
            Statement statement = null;
            Statement statement1 = null;
            ResultSet resultSet = null;
            ResultSet resultSet1 = null;
            String transDB = "";
            String sql = "SELECT LONGITUDE, LATTITUDE,LOCALITY_CODE, DESCR FROM SPRS_ROUTE WHERE SPRS_CODE='" + userId + "' AND LONGITUDE IS NOT NULL";
            String countSql = "SELECT COUNT(1) FROM SPRS_ROUTE WHERE SPRS_CODE='" + userId + "' AND LONGITUDE IS NOT NULL";
            try {
                try {
                    int cordSize;
                    ConnDriver connDriver = new ConnDriver();
                    transDB = userInfo.getTransDB();
                    connection = connDriver.getConnectDB(transDB);
                    statement1 = connection.createStatement();
                    resultSet1 = statement1.executeQuery(countSql);
                    if (resultSet1.next() && (cordSize = resultSet1.getInt(1)) > 0) {
                        GeolocationBean.TwoDCoordinates[] coordinateArray = new GeolocationBean.TwoDCoordinates[cordSize];
                        statement = connection.createStatement();
                        resultSet = statement.executeQuery(sql);
                        int i = 0;
                        while (resultSet.next()) {
                            GeolocationBean.TwoDCoordinates coordinate;
                            double dBLongitude = Double.parseDouble(resultSet.getString(1));
                            double dBLatitude = Double.parseDouble(resultSet.getString(2));
                            String localityCode = resultSet.getString(3);
                            String localityDescr = resultSet.getString(4);
                            coordinateArray[i] = coordinate = new GeolocationBean.TwoDCoordinates(dBLatitude, dBLongitude, localityCode, localityDescr);
                            ++i;
                        }
                        GeolocationBean geoLocationBean = new GeolocationBean();
                        int index = geoLocationBean.getClosest(clientLongitude, clientLattitude, coordinateArray);
                        GeolocationBean.TwoDCoordinates twoDCoordinates = coordinateArray[index];
                        closestLocCode = twoDCoordinates.getLocalityCode();
                        closestLocDescr = twoDCoordinates.getLocalityDescr();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                        if (resultSet != null && resultSet1 != null) {
                            resultSet.close();
                            resultSet1.close();
                            resultSet = null;
                            resultSet1 = null;
                        }
                        if (statement != null) {
                            statement.close();
                            statement = null;
                        }
                        break block22;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                        throw new ITMException(e2);
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                    if (resultSet != null && resultSet1 != null) {
                        resultSet.close();
                        resultSet1.close();
                        resultSet = null;
                        resultSet1 = null;
                    }
                    if (statement != null) {
                        statement.close();
                        statement = null;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
                throw throwable;
            }
            try {
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
                if (resultSet != null && resultSet1 != null) {
                    resultSet.close();
                    resultSet1.close();
                    resultSet = null;
                    resultSet1 = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return "You are at " + closestLocCode + " [" + closestLocDescr + "]";
    }
}

