/*
 * Decompiled with CFR 0.152.
 */
package ibase.communication;

import ibase.communication.EmailComm;
import ibase.communication.SMSComm;
import ibase.communication.TelegramComm;
import ibase.communication.WhatsAppComm;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.reports.utility.JasperReportGenerator;
import ibase.webitm.reports.utility.ResourceConstants;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Communication {
    E12GenericUtility genericUtility = new E12GenericUtility();
    Document currentPkTranDom = null;

    public String communicate(String commType, String dataXMLString, UserInfoBean userInfo, String objName, String tranId, String formatCode) throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)(" Telegram Communication Type :: sendNotification() : " + commType));
        BaseLogger.log((String)"3", null, null, (Object)(" Telegram Communication Type :: userINFO() : " + userInfo));
        BaseLogger.log((String)"3", null, null, (Object)("dataXMLString: " + dataXMLString));
        this.currentPkTranDom = this.getCurrentTranDom(tranId, userInfo, objName);
        BaseLogger.log((String)"3", null, null, (Object)("currentPkTranDomstr: " + this.domToString(this.currentPkTranDom)));
        String commXml = this.buildCommunicationXML(dataXMLString, formatCode, userInfo, tranId, objName);
        String returnStr = "";
        if ("Email".equalsIgnoreCase(commType)) {
            EmailComm email = new EmailComm();
            returnStr = email.sendMail(commXml, "ITM", userInfo);
        } else if ("Telegram".equalsIgnoreCase(commType)) {
            TelegramComm telegram = new TelegramComm();
            returnStr = telegram.sendTelegramMessage(userInfo, dataXMLString, commXml, formatCode);
            this.writeCommunicationLog(returnStr, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)(" Telegram XMLString :: sendNotification() : " + returnStr));
        } else if ("WhatsApp".equalsIgnoreCase(commType)) {
            WhatsAppComm whatsapp = new WhatsAppComm();
            whatsapp.sendWhatsApp(commXml, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)(" Whatsapp XMLString :: sendNotification() : " + commXml));
        } else if ("SMS".equalsIgnoreCase(commType)) {
            SMSComm sms = new SMSComm();
            String userId = userInfo.getLoginCode();
            String xtraParams = "loginCode=" + userId + "~~loginEmpCode" + userId;
            String result = sms.sendSMS(commXml, formatCode, xtraParams, userInfo);
            BaseLogger.log((String)"3", null, null, (Object)(" Telegram XMLString :: sendNotification() : " + commXml));
        } else {
            BaseLogger.log((String)"3", null, null, (Object)"Unknown Communication Request Request!!");
        }
        return returnStr;
    }

    private void writeCommunicationLog(String returnStr, UserInfoBean userInfo) {
        try {
            boolean isException = false;
            String commType = "";
            String commStatus = "";
            String commErrMsg = "";
            String sendTo = "";
            String sendCC = "";
            String sendBCC = "";
            String subject = "";
            String mailBody = "";
            int attachCount = 0;
            ArrayList<File> attachmentList = new ArrayList<File>();
            String status = "";
            E12GenericUtility utility = new E12GenericUtility();
            Document dom = utility.parseString(returnStr);
            if (dom.getElementsByTagName("COMM_TYPE") != null && dom.getElementsByTagName("COMM_TYPE").item(0) != null && (commType = dom.getElementsByTagName("COMM_TYPE").item(0).getFirstChild().getNodeValue()).equalsIgnoreCase("Telegram")) {
                commType = "T";
            }
            if (dom.getElementsByTagName("COMM_STATUS") != null && dom.getElementsByTagName("COMM_STATUS").item(0) != null) {
                commStatus = dom.getElementsByTagName("COMM_STATUS").item(0).getFirstChild().getNodeValue();
            }
            if (dom.getElementsByTagName("COMM_ERROR_MESSAGE") != null && dom.getElementsByTagName("COMM_ERROR_MESSAGE").item(0) != null) {
                commErrMsg = dom.getElementsByTagName("COMM_ERROR_MESSAGE").item(0).getFirstChild().getNodeValue();
            }
            if (dom.getElementsByTagName("COMM_TO") != null && dom.getElementsByTagName("COMM_TO").item(0) != null) {
                sendTo = dom.getElementsByTagName("COMM_TO").item(0).getFirstChild().getNodeValue();
            }
            if (dom.getElementsByTagName("COMM_SUBJECT") != null && dom.getElementsByTagName("COMM_SUBJECT").item(0) != null) {
                subject = dom.getElementsByTagName("COMM_SUBJECT").item(0).getFirstChild().getNodeValue();
            }
            if (dom.getElementsByTagName("COMM_BODY") != null && dom.getElementsByTagName("COMM_BODY").item(0) != null) {
                mailBody = dom.getElementsByTagName("COMM_BODY").item(0).getFirstChild().getNodeValue();
            }
            if (dom.getElementsByTagName("ATTACHMENT_COUNT") != null && dom.getElementsByTagName("ATTACHMENT_COUNT").item(0) != null) {
                attachCount = Integer.parseInt(dom.getElementsByTagName("ATTACHMENT_COUNT").item(0).getFirstChild().getNodeValue().trim());
            }
            if (dom.getElementsByTagName("COMM_STATUS") != null && dom.getElementsByTagName("COMM_STATUS").item(0) != null) {
                status = dom.getElementsByTagName("COMM_STATUS").item(0).getFirstChild().getNodeValue();
            }
            if (dom.getElementsByTagName("ATTACHMENT") != null && dom.getElementsByTagName("ATTACHMENT").item(0) != null) {
                String attachment = dom.getElementsByTagName("ATTACHMENT").item(0).getFirstChild().getNodeValue();
                attachmentList.add(new File(attachment));
            }
            isException = status.equalsIgnoreCase("E");
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" isException : " + isException));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" commType : " + commType));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" commStatus : " + commStatus));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" commErrMsg : " + commErrMsg));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" sendTo : " + sendTo));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" subject : " + subject));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" mailBody : " + mailBody));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" attachCount : " + attachCount));
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" attachment : " + attachmentList));
            utility.writeCommunicationLog(userInfo, isException, commType, commStatus, commErrMsg, sendTo, sendCC, sendBCC, subject, mailBody, attachCount, attachmentList);
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)" Write Communication Log Done : ");
        }
        catch (Exception e) {
            BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)(" Write Communication Log Error : " + e.getMessage()));
        }
    }

    private boolean verifyLimit(String appId, String tranDB) {
        BaseLogger.log((String)"3", null, null, (Object)"Communication :verifyLimit(): - Verify Limit executed");
        BaseLogger.log((String)"3", null, null, (Object)("Communication :verifyLimit(): -appId: " + appId));
        BaseLogger.log((String)"3", null, null, (Object)("Communication :verifyLimit(): tranDB: " + tranDB));
        boolean isAvailable = true;
        CommonDBAccessEJB genUtility = new CommonDBAccessEJB();
        try {
            int maxLimit = Integer.parseInt(E12GenericUtility.checkNull((String)genUtility.getDBColumnValue("", "Count(maxDayLimit)", "", tranDB)));
            int sentMessageCount = Integer.parseInt(E12GenericUtility.checkNull((String)genUtility.getDBColumnValue("", "Count(maxDayLimit)", "", tranDB)));
            if (maxLimit <= sentMessageCount) {
                isAvailable = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isAvailable;
    }

    private String buildCommunicationXML(String dataXMLString, String formatCode, UserInfoBean userInfo, String tranId, String objName) {
        BaseLogger.log((String)"3", null, null, (Object)"Inside buildCommunicationXML...");
        String commXML = "";
        Statement pstmt = null;
        ResultSet resultSet = null;
        Connection connection = null;
        String result = "";
        String transDB = userInfo.getTransDB();
        String toAddr = "";
        String ccAddr = "";
        String bccAddr = "";
        String subject = "";
        String body = "";
        String templateCode = "";
        String templateName = "";
        String attachmentText = "";
        String attachmentType = "";
        String attachmentObject = "";
        String editFlag = "E";
        String saveFlag = "false";
        String attachmentPath = "";
        StringBuilder XMLString = new StringBuilder("<Root>");
        try {
            try {
                if (dataXMLString == null || dataXMLString != null && dataXMLString.length() == 0) {
                    dataXMLString = this.buildDataXML(tranId, userInfo, objName);
                }
                String tranPKValues = tranId;
                String sql = "SELECT SEND_TO, COPY_TO, BLIND_COPY, SUBJECT, BODY_TEXT, FORMAT_CODE, MAIL_DESCR, ATTACH_OBJECT, ATTACH_TEXT, ATTACH_TYPE FROM MAIL_FORMAT WHERE FORMAT_CODE='" + formatCode + "'";
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(transDB);
                pstmt = connection.prepareStatement(sql);
                resultSet = pstmt.executeQuery();
                while (resultSet.next()) {
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Inside while block----> ");
                    toAddr = E12GenericUtility.checkNull((String)resultSet.getString("SEND_TO"));
                    ccAddr = E12GenericUtility.checkNull((String)resultSet.getString("COPY_TO"));
                    bccAddr = E12GenericUtility.checkNull((String)resultSet.getString("BLIND_COPY"));
                    subject = E12GenericUtility.checkNull((String)resultSet.getString("SUBJECT"));
                    body = E12GenericUtility.checkNull((String)resultSet.getString("BODY_TEXT"));
                    templateCode = E12GenericUtility.checkNull((String)resultSet.getString("FORMAT_CODE"));
                    templateName = E12GenericUtility.checkNull((String)resultSet.getString("MAIL_DESCR"));
                    attachmentText = E12GenericUtility.checkNull((String)resultSet.getString("ATTACH_TEXT"));
                    attachmentType = E12GenericUtility.checkNull((String)resultSet.getString("ATTACH_TYPE"));
                    attachmentObject = E12GenericUtility.checkNull((String)resultSet.getString("ATTACH_OBJECT"));
                    BaseLogger.log((String)"3", null, null, (Object)("Inside buildCommunicationXML...attachmentText gsb:::" + attachmentText));
                    String[] parts = attachmentText.split("~");
                    String attachType = parts[1];
                    attachmentText = attachmentText.substring(0, attachmentText.indexOf("~"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...objName::: [" + objName + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...attachmentText::: [" + attachmentText + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...currentPkTranDom::: [" + this.currentPkTranDom + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...currentPkTranStr::: [" + this.domToString(this.currentPkTranDom) + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...userInfo::: [" + userInfo + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...tranId::: [" + tranId + "]"));
                    BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("Inside buildCommunicationXML...attachType::: [" + attachType + "]"));
                    if ("B".equalsIgnoreCase(attachType)) {
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Inside if buildCommunicationXML attachType = B");
                        attachmentPath = this.getAttachmentPath(objName, attachmentText, userInfo, this.currentPkTranDom, tranId, "html");
                        BaseLogger.log((String)"3", null, null, (Object)("Inside buildCommunicationXML...attachmentPath:::" + attachmentPath));
                    } else {
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Inside else buildCommunicationXML i.e. attachType is not B-->");
                        attachmentPath = this.getAttachmentPath(objName, attachmentText, userInfo, this.currentPkTranDom, tranId, "pdf");
                        BaseLogger.log((String)"3", null, null, (Object)("Inside buildCommunicationXML...attachmentPath:::" + attachmentPath));
                        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("else Attachment Path:" + attachmentPath));
                    }
                    XMLString.append("<SEND_TO><![CDATA[" + toAddr + "]]></SEND_TO>");
                    XMLString.append("<COPY_TO><![CDATA[" + ccAddr + "]]></COPY_TO>");
                    XMLString.append("<BLIND_COPY><![CDATA[" + bccAddr + "]]></BLIND_COPY>");
                    XMLString.append("<SUBJECT><![CDATA[" + subject + "]]></SUBJECT>");
                    XMLString.append("<BODY_TEXT><![CDATA[" + body + "]]></BODY_TEXT>");
                    XMLString.append("<FORMAT_CODE><![CDATA[" + templateCode + "]]></FORMAT_CODE>");
                    XMLString.append("<MAIL_DESCR><![CDATA[" + templateName + "]]></MAIL_DESCR>");
                    XMLString.append("<ATTACH_TEXT><![CDATA[" + attachmentPath + "]]></ATTACH_TEXT>");
                    XMLString.append("<ATTACH_TYPE><![CDATA[" + attachmentType + "]]></ATTACH_TYPE>");
                    XMLString.append("<ATTACH_OBJECT><![CDATA[" + attachmentObject + "]]></ATTACH_OBJECT>");
                    XMLString.append("</Root>");
                    commXML = XMLString.toString();
                    BaseLogger.log((String)"3", null, null, (Object)("Inside buildCommunicationXML...:::" + commXML));
                }
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log((String)"3", null, null, (Object)("Inside catch block ...:::" + commXML));
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String exceptionDetails = sw.toString();
                BaseLogger.log((String)"3", null, null, (Object)("Exception in communication::" + e.getMessage() + "]\n" + exceptionDetails));
                try {
                    if (resultSet != null) {
                        resultSet.close();
                        resultSet = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return commXML;
    }

    private static void appendElement(Document doc, Element parent, String name, String value) {
        Element element = doc.createElement(name);
        Text textNode = doc.createTextNode(value);
        element.appendChild(textNode);
        parent.appendChild(element);
    }

    String buildDataXML(String tranId, UserInfoBean userInfo, String objName) {
        String tranDataXML = "";
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranDataXML = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", tranId, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tranDataXML;
    }

    private String getNodeValue(Document dom, String colName) {
        String retValue = "";
        try {
            if (dom.getElementsByTagName(colName).item(0) != null && dom.getElementsByTagName(colName).item(0).getFirstChild() != null) {
                retValue = dom.getElementsByTagName(colName).item(0).getFirstChild().getNodeValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retValue;
    }

    private String getAttachmentPath(String objName, String attachObjLink, UserInfoBean userInfo, Document currentPkTranDom, String tranId, String attachType) throws ITMException {
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)"Inside getAttachmentPath");
        String attachmentPath = "";
        Statement pstmt = null;
        ResultSet rs = null;
        Connection conn = this.getConnection(userInfo);
        try {
            try {
                String selSql = "";
                String[] attachFormField = attachObjLink.split(":");
                String formNo = attachFormField[0];
                String formField = attachFormField[1];
                String reportFileName = "";
                Object linkArgsArr = null;
                Object detailNodeList = null;
                Object detailNode = null;
                Object detailDom = null;
                String linkAgrs = "";
                String linkTitle = "";
                selSql = "SELECT TARGET_OBJ_NAME,LINK_ARG,LINK_TITLE FROM OBJ_LINKS WHERE OBJ_NAME = ? AND FORM_NO = ? AND FIELD_NAME = ? AND LINK_TYPE = ?";
                pstmt = conn.prepareStatement(selSql);
                pstmt.setString(1, objName);
                pstmt.setString(2, formNo);
                pstmt.setString(3, formField);
                pstmt.setString(4, "5");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    reportFileName = E12GenericUtility.checkNull((String)rs.getString("TARGET_OBJ_NAME"));
                    linkAgrs = E12GenericUtility.checkNull((String)rs.getString("LINK_ARG"));
                    linkTitle = E12GenericUtility.checkNull((String)rs.getString("LINK_TITLE"));
                }
                String outputFilename = String.valueOf(objName) + "_" + tranId + "_" + linkTitle;
                XSDParser xsdParser = new XSDParser(reportFileName, userInfo);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xsdParser:: [" + xsdParser + "]"));
                String argXmlString = xsdParser.getArgumentMetaDataString();
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xsdParser.getArgumentMetaDataString():: [" + argXmlString + "]"));
                String reportArgString = this.genReportArgStr(reportFileName, attachType, argXmlString, currentPkTranDom, linkAgrs, userInfo);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("ReportArgString[" + reportArgString + "]"));
                JasperReportGenerator jasperReport = new JasperReportGenerator(userInfo);
                TreeMap argMap = jasperReport.createArgMap(reportArgString);
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("argMap Communication getAttachmentPath:::->" + argMap));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("reportFileName Communication getAttachmentPath:::->" + reportFileName));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("xsdParser Communication getAttachmentPath:::->" + xsdParser));
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("outputFilename Communication getAttachmentPath:::->" + outputFilename));
                try {
                    jasperReport.createReport(reportFileName, argMap, xsdParser, "TelegramAttachments", outputFilename);
                }
                catch (Throwable exp) {
                    BaseLogger.log((String)"0", null, null, (Object)"Exception in createReport");
                    exp.printStackTrace();
                }
                attachmentPath = String.valueOf(ResourceConstants.REPORTDESTINATION) + File.separator + "TelegramAttachments" + File.separator + outputFilename + "." + attachType;
                BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("a attachmentPath Communication getAttachmentPath:::->" + attachmentPath));
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception exception) {}
        }
        BaseLogger.log((String)"3", (UserInfoBean)userInfo, null, (Object)("attachmentPath Communication getAttachmentPath:::->" + attachmentPath));
        return attachmentPath;
    }

    private Connection getConnection(UserInfoBean userInfo) throws ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        String transDB = userInfo.getTransDB();
        try {
            connDriver = new ConnDriver();
            if (userInfo != null) {
                transDB = userInfo.getTransDB();
            }
            conn = connDriver.getConnectDB(transDB);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return conn;
    }

    public String genReportArgStr(String reportFileName, String attachType, String xsdString, Document transDom, String linkAgrs, UserInfoBean userInfo) throws Exception {
        StringBuffer reportArgString = new StringBuffer();
        try {
            reportArgString.append("<Arguments>");
            reportArgString.append("<Argument id=\"x_path\" name=\"x_path\"><argType>java.lang.String</argType><value>/DocumentRoot/" + reportFileName + "</value></Argument>");
            reportArgString.append("<Argument id=\"design_source\" name=\"design_source\"><argType>java.lang.String</argType><value>" + reportFileName + ".jrxml</value></Argument>");
            reportArgString.append("<Argument id=\"data_source\" name=\"data_source\"><argType>java.lang.String</argType><value>SQL</value></Argument>");
            reportArgString.append("<Argument id=\"bind_type\" name=\"bind_type\"><argType>java.lang.Integer</argType><value>0</value></Argument>");
            reportArgString.append("<Argument id=\"report_type\" name=\"report_type\"><argType>java.lang.String</argType><value>JASPER</value></Argument>");
            reportArgString.append("<Argument id=\"report_save_type\" name=\"report_save_type\"><argType>java.lang.String</argType><value>" + attachType.toUpperCase() + "</value></Argument>");
            if (xsdString != null && xsdString.length() > 0) {
                HashMap<String, String> formValueMap = this.getFormValueMap(transDom);
                HashMap<String, String> linkArgValueMap = this.getLinkArgValueMap(linkAgrs, formValueMap);
                HashMap<String, String> userInfoMap = this.getUserInfoMap(userInfo);
                Document doc = this.genericUtility.parseString(xsdString);
                NodeList argNodeList = doc.getElementsByTagName("argument");
                if (argNodeList != null) {
                    int argCnt = 0;
                    while (argCnt <= argNodeList.getLength()) {
                        Node argNode = argNodeList.item(argCnt);
                        if (argNode != null) {
                            String argName = "";
                            String argType = "";
                            String argValue = "";
                            Node attribute = null;
                            attribute = argNode.getAttributes().getNamedItem("name");
                            if (attribute != null && attribute.getFirstChild() != null) {
                                argName = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("type")) != null && attribute.getFirstChild() != null) {
                                argType = attribute.getFirstChild().getNodeValue();
                            }
                            if ((attribute = argNode.getAttributes().getNamedItem("value")) != null && attribute.getFirstChild() != null) {
                                argValue = attribute.getFirstChild().getNodeValue();
                            }
                            if (linkArgValueMap != null && linkArgValueMap.containsKey(argName)) {
                                argValue = linkArgValueMap.get(argName);
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            } else if (userInfoMap != null && userInfoMap.containsKey(argValue.toLowerCase())) {
                                argValue = userInfoMap.get(argValue.toLowerCase());
                                reportArgString.append("<Argument id=\"" + argName + "\" name=\"" + argName + "\"><argType>" + argType + "</argType><value>" + argValue + "</value></Argument>");
                            }
                        }
                        ++argCnt;
                    }
                }
            }
            reportArgString.append("</Arguments>");
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("Exception :: genReportArgStr : [" + e.getMessage() + "]"));
            e.printStackTrace();
        }
        return reportArgString.toString();
    }

    private HashMap<String, String> getFormValueMap(Document transactionDom) throws Exception {
        HashMap<String, String> formValueMap = new HashMap<String, String>();
        if (transactionDom != null) {
            NodeList detailNodeList = transactionDom.getElementsByTagName("Detail1");
            Node parentNode = detailNodeList.item(0);
            NodeList childNodeList = parentNode.getChildNodes();
            int childNodeCtr = 0;
            while (childNodeCtr < childNodeList.getLength()) {
                Node childNode = childNodeList.item(childNodeCtr);
                if (childNode != null && childNode.getNodeType() == 1) {
                    String nodeName = childNode.getNodeName();
                    String nodeValue = "";
                    if (childNode.getFirstChild() != null) {
                        nodeValue = childNode.getFirstChild().getNodeValue();
                    }
                    formValueMap.put(nodeName, nodeValue);
                }
                ++childNodeCtr;
            }
        }
        return formValueMap;
    }

    private HashMap<String, String> getUserInfoMap(UserInfoBean userInfo) {
        HashMap<String, String> userInfoMap = new HashMap<String, String>();
        try {
            if (userInfo != null) {
                String user = userInfo.getLoginCode();
                String entityCode = userInfo.getEntityCode();
                String profileId = userInfo.getProfileId();
                String empCode = userInfo.getEmpCode();
                String reportTo = userInfo.getReportTo();
                String deptCode = userInfo.getDeptCode();
                String userLev = userInfo.getUserLevel();
                String userType = userInfo.getUserType();
                String loginSite = userInfo.getSiteCode();
                if (entityCode == null) {
                    entityCode = "";
                }
                if (user == null) {
                    user = "";
                }
                userInfoMap.put("login_site", loginSite);
                userInfoMap.put("login_code", user);
                userInfoMap.put("entity_code", entityCode);
                userInfoMap.put("profile_id", profileId);
                userInfoMap.put("report_to", reportTo);
                userInfoMap.put("dept_code", deptCode);
                userInfoMap.put("user_lev", userLev);
                userInfoMap.put("user_type", userType);
                userInfoMap.put("emp_code", empCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userInfoMap;
    }

    private HashMap<String, String> getLinkArgValueMap(String linkAgrs, HashMap<String, String> formValueMap) throws Exception {
        HashMap<String, String> linkArgValueMap = new HashMap<String, String>();
        if (linkAgrs.length() > 0) {
            String[] linkArgsArr = linkAgrs.split(",");
            int argCnt = 0;
            while (argCnt < linkArgsArr.length) {
                String arg = linkArgsArr[argCnt];
                String[] argNameType = arg.split("\\.");
                if (argNameType != null) {
                    String fieldName = argNameType[0];
                    String argName = argNameType[1].split(":")[1];
                    String argValue = fieldName;
                    if (formValueMap != null && formValueMap.containsKey(fieldName)) {
                        argValue = formValueMap.get(fieldName);
                    }
                    linkArgValueMap.put(argName, argValue);
                }
                ++argCnt;
            }
        }
        return linkArgValueMap;
    }

    private String domToString(Document dom) {
        String xmlStr = "";
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            StringWriter stringWriter = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(dom), new StreamResult(stringWriter));
            xmlStr = stringWriter.toString();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)("domToString() Error=[" + e.getMessage() + "]"));
        }
        BaseLogger.log((String)"3", null, null, (Object)("domToString() xmlStr:" + xmlStr));
        return xmlStr;
    }

    private Document getCurrentTranDom(String pkValues, UserInfoBean userInfo, String objName) throws ITMException {
        String tranXml = "";
        try {
            MasterDataEJB masterDataEJB = new MasterDataEJB();
            tranXml = masterDataEJB.getXMLFromDBForBrow(objName, "1", "2", pkValues, null, null, userInfo);
            masterDataEJB = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        return this.genericUtility.parseString(tranXml);
    }
}

