/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.RefSer;
import ibase.hibernate.bean.Task;
import ibase.hibernate.dao.TaskDAO;
import ibase.hibernate.dao.UserTaskDao;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/")
public class TaskPluginService {
    private TaskDAO taskDao = new TaskDAO();
    @Context
    HttpServletRequest request;

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    public Response getTaskList() {
        BaseLogger.log((String)"2", null, null, (Object)"Inside getTaskList of TaskPluginService");
        UserInfoBean userInfo = this.getUserInfo();
        String loginCode = userInfo.getLoginCode();
        List taskList = null;
        taskList = this.taskDao.fetchTasksList(loginCode);
        if (taskList != null && !taskList.isEmpty()) {
            ArrayList<String> refSerList = new ArrayList<String>();
            for (Task task : taskList) {
                if (refSerList.contains(task.getRefSer().trim()) || task.getRefSer().trim() == "TASK") continue;
                refSerList.add(task.getRefSer().trim());
            }
            Map refSerObjMap = this.taskDao.getRefSerMap(refSerList);
            int i = 0;
            while (i < taskList.size()) {
                RefSer refSerObj = (RefSer)refSerObjMap.get(((Task)taskList.get(i)).getRefSer().trim());
                String refSerDescr = refSerObj != null ? refSerObj.getRefSerDescr() : "TASK";
                ((Task)taskList.get(i)).setRefSerDescr(refSerDescr);
                ++i;
            }
        }
        return Response.status((int)200).entity((Object)taskList).build();
    }

    @GET
    @Path(value="/tasks/{REF_ID}/{REF_SER}")
    @Produces(value={"application/json"})
    public List<Task> getTaskList(@PathParam(value="REF_ID") String REF_ID, @PathParam(value="REF_SER") String REF_SER) {
        BaseLogger.log((String)"2", null, null, (Object)"Inside getTaskList of TaskPluginService");
        UserInfoBean userInfo = this.getUserInfo();
        String loginCode = userInfo.getLoginCode();
        List taskList = null;
        taskList = this.taskDao.fetchTasksList(REF_ID, REF_SER, loginCode);
        if (taskList != null && !taskList.isEmpty()) {
            ArrayList<String> refSerList = new ArrayList<String>();
            for (Task task : taskList) {
                if (refSerList.contains(task.getRefSer().trim()) || task.getRefSer().trim() == "TASK") continue;
                refSerList.add(task.getRefSer().trim());
            }
            Map refSerObjMap = this.taskDao.getRefSerMap(refSerList);
            int i = 0;
            while (i < taskList.size()) {
                RefSer refSerObj = (RefSer)refSerObjMap.get(((Task)taskList.get(i)).getRefSer().trim());
                String refSerDescr = refSerObj != null ? refSerObj.getRefSerDescr() : "TASK";
                ((Task)taskList.get(i)).setRefSerDescr(refSerDescr);
                ++i;
            }
        }
        return taskList;
    }

    @GET
    @Path(value="/task/{TASK_ID}")
    @Produces(value={"application/json"})
    public Task getTask(@PathParam(value="TASK_ID") String TASK_ID) {
        Task task = null;
        task = this.taskDao.fetchTask(TASK_ID);
        return task;
    }

    @POST
    @Path(value="/task")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Task addTask(String data) throws JSONException {
        Task task = null;
        JSONObject taskData = new JSONObject(data);
        UserInfoBean userInfo = this.getUserInfo();
        String loginCode = userInfo.getLoginCode();
        task = this.taskDao.addTask(loginCode, taskData);
        ArrayList<String> refSerList = new ArrayList<String>();
        refSerList.add(task.getRefSer());
        Map refSerObjMap = this.taskDao.getRefSerMap(refSerList);
        RefSer refSerObj = (RefSer)refSerObjMap.get(task.getRefSer());
        BaseLogger.log((String)"3", null, null, (Object)("task.getRefSer: [" + task.getRefSer() + "] \n refSerObj:: " + refSerObj + "\n refSerMap::" + refSerObjMap));
        String refSerDescr = refSerObj != null ? refSerObj.getRefSerDescr() : "TASK";
        task.setRefSerDescr(refSerDescr);
        BaseLogger.log((String)"2", null, null, (Object)("addTask response" + task));
        return task;
    }

    @POST
    @Path(value="/task/{TASK_ID}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updateTask(@PathParam(value="TASK_ID") String TASK_ID, String data) throws JSONException {
        JSONObject taskData = new JSONObject(data);
        UserInfoBean userInfo = this.getUserInfo();
        String loginCode = userInfo.getLoginCode();
        this.taskDao.updateTask(TASK_ID, loginCode, taskData);
        return Response.status((int)200).entity((Object)this.getResponseMessage("Updated task successfully", "Success")).build();
    }

    @DELETE
    @Path(value="/task/{TASK_ID}")
    @Produces(value={"application/json"})
    public Response removeTask(@PathParam(value="TASK_ID") String TASK_ID) {
        this.taskDao.removeTask(TASK_ID);
        return Response.status((int)200).entity((Object)this.getResponseMessage("Deleted task successfully", "Success")).build();
    }

    private JSONObject getResponseMessage(String successResponse, String status) {
        JSONObject respMessage = new JSONObject();
        try {
            respMessage.put("message", (Object)successResponse);
            respMessage.put("status", (Object)status);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return respMessage;
    }

    private UserInfoBean getUserInfo() {
        UserInfoBean userInfo = null;
        HttpSession session = this.request.getSession();
        Object userObj = session.getAttribute("USER_INFO");
        BaseLogger.log((String)"2", null, null, (Object)(" ContentLibraryService getUserInfo  userObj >>[" + userObj + "]"));
        if (userObj != null) {
            try {
                userInfo = new UserInfoBean(userObj.toString());
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return userInfo;
    }

    @POST
    @Path(value="/usertask")
    @Produces(value={"application/json"})
    public Response saveUserTaskDetails() throws Exception {
        BaseLogger.log((String)"3", null, null, (Object)"In TaskPluginService :: usertask ");
        String params = E12GenericUtility.readStreamAsString((InputStream)this.request.getInputStream());
        BaseLogger.log((String)"3", null, null, (Object)("params :" + params));
        JSONObject respJsonObject = new JSONObject();
        if (params.length() == 0) {
            StringBuffer paramString = new StringBuffer();
            params = paramString.toString();
        }
        BaseLogger.log((String)"3", null, null, (Object)("params - " + params));
        try {
            HttpSession session = this.request.getSession();
            Object userObj = session.getAttribute("USER_INFO");
            UserInfoBean userInfo = new UserInfoBean(userObj.toString());
            UserTaskDao userTaskDao = new UserTaskDao();
            userTaskDao.setUserInfo(userInfo);
            userTaskDao.saveOrUpdateUserTask(params);
            System.out.println("In TaskPluginService usertask userInfo[" + userInfo + "]");
            respJsonObject.put("status", (Object)"200");
        }
        catch (Exception e) {
            System.out.println("Inside TaskPluginService usertask :::" + e);
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }

    @GET
    @Path(value="/usertask/{TRAN_ID}/{CURR_STATUS}")
    @Produces(value={"application/json"})
    public Response updateUserTaskStatus(@PathParam(value="TRAN_ID") String tranId, @PathParam(value="CURR_STATUS") String currStatus) throws Exception {
        BaseLogger.log((String)"2", null, null, (Object)("Inside updateUserTaskStatus of TaskPluginService:: tranId[" + tranId + "], currStatus[" + currStatus + "]"));
        JSONObject respJsonObject = new JSONObject();
        try {
            HttpSession session = this.request.getSession();
            Object userObj = session.getAttribute("USER_INFO");
            UserInfoBean userInfo = new UserInfoBean(userObj.toString());
            UserTaskDao userTaskDao = new UserTaskDao();
            userTaskDao.setUserInfo(userInfo);
            userTaskDao.updateUserTaskStatus(tranId, currStatus);
            respJsonObject.put("status", (Object)"200");
            System.out.println("In TaskPluginService usertask userInfo[" + userInfo + "]");
        }
        catch (Exception e) {
            System.out.println("Inside TaskPluginService usertask :::" + e);
            respJsonObject.put("result", (Object)"failure");
        }
        return Response.status((int)200).entity((Object)respJsonObject.toString()).build();
    }
}

