/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.bean.EventLogInfoBean;
import ibase.bean.ExtAuthAppAPIBean;
import ibase.ejb.CommonDBAccessEJB;
import ibase.ejb.ExtServiceEJB;
import ibase.ejb.UserEventLogEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.E12TransEditorCoreModel;
import ibase.webitm.bean.ITMTransactionCoreModel;
import ibase.webitm.bean.ITMTransactionHeaderModel;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.E12DataModelComponent;
import ibase.webitm.ejb.MasterDataEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.MasterStatefulRemote;
import ibase.webitm.ejb.PopUpDataAccessEJB;
import ibase.webitm.ejb.PopUpEJB;
import ibase.webitm.reports.utility.XSDParser;
import ibase.webitm.servlet.Messages;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.E12ExtServiceUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.RestAPIServiceUtility;
import ibase.webitm.utility.ViewReport;
import ibase.wrkflw.E12FollowUpActionEJB;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.ejb.NoSuchEJBException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.HttpHeaders;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class VisionOBJServiceUtility
extends RestAPIServiceUtility {
    public UserInfoBean getUserInfo(HttpServletRequest request, String tokenId) {
        UserInfoBean userInfo = null;
        String userInfoStr = "";
        try {
            HttpSession session = request.getSession();
            Enumeration attributeNames = session.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!((String)attributeNames.nextElement()).equals("USER_INFO")) continue;
                userInfoStr = session.getAttribute("USER_INFO").toString();
            }
            if (!userInfoStr.equals("")) {
                userInfo = new UserInfoBean(userInfoStr);
            }
            if (userInfo == null) {
                APIUtility apiUtility = new APIUtility();
                userInfo = apiUtility.createUserInfoUsingJWTToken(tokenId);
            }
            return userInfo;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Error in getting User info from Request [" + e.getMessage() + "]");
            return null;
        }
    }

    public String generateResponse(HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result, UserInfoBean userInfo) {
        return this.generateResponse(request, serviceName, params, tokenId, dataFormat, status, result, "", userInfo);
    }

    public String generateResponse(HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result, String rootKey, UserInfoBean userInfo) {
        String response = "";
        if (rootKey.equals("")) {
            rootKey = "data";
        }
        JSONObject responseJson = new JSONObject();
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            BaseLogger.log("0", null, null, "dataFormat got in generate response2= " + dataFormat);
            result = this.checkNull(result);
            if (dataFormat.equals("JSON")) {
                JSONObject data = new JSONObject();
                BaseLogger.log("0", null, null, "in generate response= in JSON");
                if (this.isJSONValid(result)) {
                    BaseLogger.log("0", null, null, "in generate response= in JSONString is valid");
                    JSONObject resultStringToJSON = new JSONObject(result);
                    data.put("data", (Object)resultStringToJSON);
                    if (resultStringToJSON.has("Warning")) {
                        status = "warning";
                    } else if (resultStringToJSON.has("Errors")) {
                        status = "error";
                    } else if (resultStringToJSON.has("Exception")) {
                        status = "exception";
                    }
                    responseJson.put("data", (Object)resultStringToJSON);
                    responseJson.put("status", (Object)status);
                    responseJson.put("erorr", (Object)new JSONObject());
                } else if (status.equalsIgnoreCase("error") || status.equalsIgnoreCase("exception")) {
                    data.put("data", (Object)result);
                    responseJson.put("data", (Object)new JSONArray());
                    responseJson.put("message", (Object)result);
                    responseJson.put("status", (Object)status);
                } else {
                    responseJson.put("data", (Object)result);
                    responseJson.put("status", (Object)status);
                    responseJson.put("erorr", (Object)new JSONObject());
                }
            } else if (genericUtility.isXMLString(result)) {
                try {
                    Document resultDoc = this.convertStringToDocument(result);
                    if (resultDoc != null) {
                        NodeList warningList = resultDoc.getElementsByTagName("Warning");
                        NodeList errorsList = resultDoc.getElementsByTagName("Errors");
                        NodeList exceptionList = resultDoc.getElementsByTagName("Exception");
                        if (warningList.getLength() > 0) {
                            status = "warning";
                        } else if (errorsList.getLength() > 0) {
                            status = "error";
                        } else if (exceptionList.getLength() > 0) {
                            status = "exception";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "ITMException : generateResponse 5318 : " + e.getMessage());
                    e.printStackTrace();
                }
            }
            try {
                String logResult = this.generateExtServiceLog(request, tokenId, serviceName, params, status, result, userInfo);
                BaseLogger.log("3", null, null, "logResult - [" + logResult + "]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!"JSON".equalsIgnoreCase(dataFormat) && !"JSONString".equalsIgnoreCase(dataFormat)) {
                response = genericUtility.jsonToXMLString(response);
                response = genericUtility.remAllXmlDec(response);
            }
            response = responseJson.toString();
        }
        catch (ITMException e) {
            BaseLogger.log("0", null, null, "ITMException : generateResponse : " + e.getMessage());
            try {
                responseJson.put("message", (Object)this.getStackTrace(e));
                responseJson.put("data", (Object)new JSONArray());
                responseJson.put("status", (Object)"Exception");
                response = responseJson.toString();
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "JSONException : generateResponse : " + e.getMessage());
            try {
                responseJson.put("message", (Object)this.getStackTrace((Exception)((Object)e)));
                responseJson.put("data", (Object)new JSONArray());
                responseJson.put("status", (Object)"Exception");
                response = responseJson.toString();
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        return response;
    }

    private boolean isJSONValid(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }

    private String generateExtServiceLog(HttpServletRequest request, String tokenId, String action, String params, String responseType, String response, UserInfoBean userInfo) throws ITMException {
        String result = "";
        String requestedTerm = "";
        String requestedUser = "";
        try {
            String hostName = "";
            String hostIP = "";
            InetAddress inetAddress = InetAddress.getLocalHost();
            hostName = inetAddress.getHostName();
            hostIP = inetAddress.getHostAddress();
            if (userInfo != null) {
                requestedTerm = this.checkNull(userInfo.getRemoteHost());
                if (requestedTerm.length() > 15) {
                    requestedTerm = requestedTerm.substring(0, 15);
                }
                requestedUser = this.checkNull(userInfo.getLoginCode());
            } else {
                requestedTerm = this.checkNull(request.getRemoteAddr());
                if (requestedTerm.length() > 15) {
                    requestedTerm = requestedTerm.substring(0, 15);
                }
                if (hostName.length() > 10) {
                    requestedUser = hostName.substring(0, 10);
                }
            }
            ExtServiceEJB extServices = new ExtServiceEJB();
            result = extServices.createExtServiceLog(tokenId, action, params, responseType, response, requestedTerm, requestedUser, hostName, hostIP, userInfo);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new ITMException(e);
        }
        if ("error".equals(responseType)) {
            String fileName = String.valueOf(requestedUser) + "_log_" + System.currentTimeMillis() + ".log";
            this.generateErrorLog(response, fileName);
        }
        return result;
    }

    private Document convertStringToDocument(String xmlStr) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlStr)));
            return doc;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void generateErrorLog(String log, String fileName) {
        try {
            String logDir = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "webService_Log" + File.separator + fileName;
            File outFile = new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + "webService_Log");
            if (!outFile.exists()) {
                outFile.mkdir();
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
            out.println(log);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getPageDetails(HttpServletRequest request, HttpHeaders header, String appId, String objName) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block27: {
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            boolean isError = false;
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getPageDetails() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getPageDetails() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getPageDetails() appId=" + appId);
                    params = request.getQueryString();
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("APP_ID=" + appId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getPageDetails() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getPageDetails() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getPageDetails", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getPageDetails() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageDetails");
                            BaseLogger.log("3", null, null, "getPageDetails() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getPageDetails() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        DBAccessEJB dbAccess = new DBAccessEJB();
                        String pageDetails = dbAccess.getObjDetail(objName, "1", null, userInfo, "T");
                        BaseLogger.log("3", null, null, "getPageDetails with pageno API works pageDetails=" + pageDetails);
                        JSONObject jsonObject = XML.toJSONObject((String)pageDetails);
                        BaseLogger.log("3", null, null, "getPageDetails with pageno API works JSON=" + jsonObject.toString());
                        result = jsonObject.toString();
                        status = "success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getPageDetails : " + e.getMessage());
                    status = "exception";
                    result = this.getStackTrace(e, "JSON");
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result, userInfo);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getPageDetails)", status, result, appId, request, userInfo);
        return result;
    }

    public String getListPageData(String appId, String objName, String advQuery, String argFieldNames, String argFieldTypes, String argFieldValues, String searchParam, String objContext, String pageContext, String currentRowNo, String upToRowNo, String dataFormat, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        String status;
        String result;
        E12ExtServiceUtility e12ExtServiceUtility;
        block31: {
            String tokenId;
            String params;
            block30: {
                e12ExtServiceUtility = new E12ExtServiceUtility();
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                result = "";
                params = "";
                status = "error";
                tokenId = "";
                boolean isError = false;
                userInfo = null;
                APIUtility apiUtility = new APIUtility();
                try {
                    try {
                        tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                        if (tokenId.length() == 0) {
                            status = "Reject";
                            result = "Blank Token ID passed.";
                            isError = true;
                        }
                        if (!isError) {
                            userInfo = this.getUserInfo(request, tokenId);
                        }
                        if (!isError && userInfo == null) {
                            status = "Reject";
                            result = "User not allowed.";
                            isError = true;
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            appId = apiUtility.getAppIdFromJWTToken(tokenId);
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            status = "Reject";
                            result = "Blank APPID passed.";
                            isError = true;
                        }
                        BaseLogger.log("3", null, null, "getListPageData() appId=" + appId);
                        BaseLogger.log("3", null, null, "getListPageData() appId=" + appId.length());
                        params = request.getQueryString();
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("APP_ID=" + appId);
                            paramString.append("&OBJ_NAME=" + objName);
                            paramString.append("&ADV_QRY=" + advQuery);
                            paramString.append("&ARG_NAMES=" + argFieldNames);
                            paramString.append("&ARG_TYPES=" + argFieldTypes);
                            paramString.append("&ARG_VALUES=" + argFieldValues);
                            paramString.append("&SEARCH_PARAM=" + searchParam);
                            paramString.append("&OBJ_CONTEXT=" + objContext);
                            paramString.append("&PAGE_CONTEXT=" + pageContext);
                            paramString.append("&CURR_ROW_NUM=" + currentRowNo);
                            paramString.append("&UPTO_ROW_NUM=" + upToRowNo);
                            paramString.append("&DATA_FORMAT=" + dataFormat);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "getListPageData() params=" + params);
                        if (!isError && !appId.equals("FLUTTERAPP")) {
                            ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getListPageData", appId);
                            if (authAppAPIBean == null) {
                                status = "Reject";
                                result = "This service not available for given APPID";
                                isError = true;
                                BaseLogger.log("3", null, null, "getListPageData() none flutter result=" + result);
                            } else {
                                result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getListPageData");
                                BaseLogger.log("3", null, null, "getListPageData() result=" + result);
                                if ("valid".equalsIgnoreCase(result)) {
                                    if (apiUtility.checkDailyAPILimit(userInfo)) {
                                        status = "Reject";
                                        result = "Daily API call limit exceeded";
                                        isError = true;
                                        BaseLogger.log("3", null, null, "getListPageData() none flutter validation result=" + result);
                                    }
                                } else {
                                    status = "Reject";
                                    isError = true;
                                }
                            }
                        }
                        if (isError) break block30;
                        E12GenericUtility genericUtility = new E12GenericUtility();
                        MasterDataEJB masterDataEJB = new MasterDataEJB();
                        boolean isRCP = true;
                        boolean isMaxBrowCheck = true;
                        String[] argValList = argFieldValues.split(":");
                        argFieldValues = "";
                        String[] argFieldName = argFieldNames.split(":");
                        int i = 0;
                        while (i < argFieldName.length) {
                            String argVal = "";
                            argVal = i < argValList.length ? genericUtility.getValidDateString(argValList[i], genericUtility.getApplDateFormat(), genericUtility.getDispDateFormat()) : " ";
                            argFieldValues = String.valueOf(argFieldValues) + argVal + ":";
                            ++i;
                        }
                        HashMap<String, String> incrementalSearchParam = new HashMap<String, String>();
                        incrementalSearchParam.put("CURR_ROW_NUM", currentRowNo == null ? "0" : currentRowNo);
                        incrementalSearchParam.put("UPTO_ROW_NUM", upToRowNo == null ? "0" : upToRowNo);
                        BaseLogger.log("3", null, null, "getListPageData() is UserInfo null?" + (userInfo == null));
                        BaseLogger.log("3", null, null, "getListPageData() Login Code=" + userInfo.getLoginCode());
                        String jsonData = "";
                        try {
                            jsonData = masterDataEJB.getJSONFromDBForBrow(objName, objContext, pageContext, argFieldValues, argFieldTypes, advQuery, userInfo, isRCP, searchParam, incrementalSearchParam, isMaxBrowCheck);
                            BaseLogger.log("3", null, null, "getListPageData() jsonData=" + jsonData);
                        }
                        catch (Exception e) {
                            BaseLogger.log("3", null, null, "Error in getting JSON=" + e.getMessage());
                            jsonData = "";
                        }
                        if (jsonData.equals("") || jsonData.equals("{}")) {
                            result = "No Data Found";
                            status = "error";
                        } else {
                            result = jsonData;
                            status = "success";
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : getListPageData : " + e.getMessage());
                        status = "exception";
                        result = this.getStackTrace(e, "JSON");
                        if (tokenId.length() != 0 && userInfo == null) {
                            JSONObject resultObj = new JSONObject();
                            try {
                                resultObj.put("data", (Object)new JSONObject());
                                resultObj.put("error", (Object)"Invalid TOKEN");
                                resultObj.put("status", (Object)"Reject");
                                return resultObj.toString();
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                                return resultObj.toString();
                            }
                        }
                        result = this.generateResponse(request, "getListPageData", params, tokenId, "JSON", status, result, userInfo);
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getListPageData", params, tokenId, "JSON", status, result, userInfo);
                    throw throwable;
                }
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getListPageData", params, tokenId, "JSON", status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getListPageData)", status, result, appId, request, userInfo);
        return result;
    }

    public Object getPageMetadata(HttpServletRequest request, HttpHeaders header, String appId, String objName, String formName, String objContext, String pageContext) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block28: {
            BaseLogger.log("3", null, null, "Inside getPageMetadata : VisonObjServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            userInfo = null;
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getPageMetadata() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getPageMetadata() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getPageMetadata() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("APP_ID=" + appId);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&FORMA_NAME=" + formName);
                        paramString.append("&OBJ_CONTEXT=" + objContext);
                        paramString.append("&PAGE_CONTEXT=" + pageContext);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getPageMetadata() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getPageMetadata() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getPageMetadata", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getPageMetadata() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageMetadata");
                            BaseLogger.log("3", null, null, "getPageMetadata() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getPageMetadata() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        E12GenericUtility genericUtility = new E12GenericUtility();
                        String transDB = userInfo.getTransDB();
                        HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                        if (userInfo != null) {
                            propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                            propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                            propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
                            propEditorInfoMap.put("PROFILE_ID", this.checkNull(userInfo.getProfileId()));
                        }
                        propEditorInfoMap.put("EDITOR", "WebEditor");
                        String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "", propEditorInfoMap, transDB);
                        BaseLogger.log("3", null, null, "getPageMetadata() FilePath=" + filePath);
                        File metadataFile = new File(filePath);
                        String xmlString = this.readFile(metadataFile);
                        BaseLogger.log("3", null, null, "getPageMetadata() xmlString=" + xmlString);
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)(String.valueOf(objName) + "_" + objContext + "_" + pageContext));
                        jsonObject.put("obj_name", (Object)objName);
                        jsonObject.put("form_title", (Object)formName);
                        jsonObject.put("form_no", (Object)objContext);
                        jsonObject.put("page_context", (Object)pageContext);
                        jsonObject.put("columns", (Object)this.getPageMetadataJSON(xmlString));
                        result = jsonObject.toString();
                        status = "success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getPageMetadata : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getPageMetadata", params, tokenId, dataFormat, status, result, userInfo);
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getPageMetadata", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getPageMetadata", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getPageMetadata )", status, result, appId, request, userInfo);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPageMeta(HttpServletRequest request, HttpHeaders header, String appId, String objName, String formName, String objContext, String pageContext) {
        E12ExtServiceUtility e12ExtServiceUtility = new E12ExtServiceUtility();
        String result = "";
        String params = "";
        String status = "error";
        String tokenId = "";
        try {
            params = request.getQueryString();
            if (this.checkNull(params).length() == 0) {
                StringBuffer paramString = new StringBuffer();
                paramString.append("APP_ID=" + appId);
                paramString.append("&OBJ_NAME=" + objName);
                paramString.append("&FORMA_NAME=" + formName);
                paramString.append("&OBJ_CONTEXT=" + objContext);
                paramString.append("&PAGE_CONTEXT=" + pageContext);
                params = paramString.toString();
            }
            BaseLogger.log("3", null, null, "getPageMeta() params=" + params);
            tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
            BaseLogger.log("3", null, null, "getPageMeta() tokenId=" + tokenId);
            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageMetadata");
            BaseLogger.log("3", null, null, "getPageMeta() result=" + result);
            if ("valid".equalsIgnoreCase(result)) {
                appId = this.checkNull(appId);
                objName = this.checkNull(objName);
                objContext = this.checkNull(objContext);
                pageContext = this.checkNull(pageContext);
                if (objName.length() == 0) {
                    result = "Please enter valid Object Name.";
                    status = "error";
                    return result;
                }
                E12GenericUtility genericUtility = new E12GenericUtility();
                UserInfoBean userInfo = this.getUserInfo(request, tokenId);
                String transDB = userInfo.getTransDB();
                HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
                if (userInfo != null) {
                    propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                    propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                    propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
                    propEditorInfoMap.put("PROFILE_ID", this.checkNull(userInfo.getProfileId()));
                }
                propEditorInfoMap.put("EDITOR", "WebEditor");
                String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "", propEditorInfoMap, transDB);
                BaseLogger.log("3", null, null, "getPageMeta() FilePath=" + filePath);
                File metadataFile = new File(filePath);
                String xmlString = this.readFile(metadataFile);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)(String.valueOf(objName) + "_" + objContext + "_" + pageContext));
                jsonObject.put("obj_name", (Object)objName);
                jsonObject.put("form_title", (Object)formName);
                jsonObject.put("form_no", (Object)objContext);
                jsonObject.put("page_context", (Object)pageContext);
                jsonObject.put("columns", (Object)this.getPageMetadataJSON(xmlString));
                result = jsonObject.toString();
                status = "success";
                String string = result;
                return string;
            }
            status = "error";
            return result;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getPageDetails : " + e.getMessage());
            status = "exception";
            result = this.getStackTrace(e, "JSON");
            return result;
        }
        finally {
            result = e12ExtServiceUtility.generateResponse(request, "getPageDetails", params, tokenId, "JSON", status, result);
        }
    }

    public String getFormalArgs(HttpServletRequest request, HttpHeaders header, String appId, String objName, String pageNo, String formName) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block27: {
            BaseLogger.log("3", null, null, "Inside getFormalArgs : VisonObjServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            boolean isError = false;
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getFormalArgs() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getFormalArgs() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getFormalArgs() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("APP_ID=" + appId);
                        paramString.append("&OBJ_NAME=" + objName);
                        paramString.append("&PAGE_NO=" + pageNo);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getFormalArgs() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getFormalArgs() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getFormalArgs", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getFormalArgs() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getPageDetails");
                            BaseLogger.log("3", null, null, "getFormalArgs() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getFormalArgs() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        DBAccessEJB dbAccess = new DBAccessEJB();
                        String pageDetails = dbAccess.getPageDetails(objName, "1", null, userInfo, "T", pageNo);
                        BaseLogger.log("3", null, null, "getFormalArgs with pageno API works XML=" + pageDetails);
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("columns", (Object)this.getFormalArgs(pageDetails));
                        jsonObject.put("form_title", (Object)("Search in " + formName));
                        jsonObject.put("form_no", (Object)"0");
                        jsonObject.put("obj_name", (Object)objName);
                        jsonObject.put("id", (Object)(String.valueOf(objName) + "_1_2"));
                        BaseLogger.log("3", null, null, "getFormalArgs with pageno API works JSON=" + jsonObject.toString());
                        result = jsonObject.toString();
                        status = "success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result, userInfo);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getFormalArgs", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getFormalArgs )", status, result, appId, request, userInfo);
        return result;
    }

    public String getData(HttpServletRequest request, HttpHeaders header, String objName, String refId, String dataFormat, String appId) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block31: {
            BaseLogger.log("3", null, null, "Inside getData : VisonObjServiceUtility ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            boolean isError = false;
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getData() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getData() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getData() appId=" + appId);
                    if (!isError && appId.equals("FLUTTERAPP") && (dataFormat == null || dataFormat.isEmpty())) {
                        dataFormat = "JSON";
                    } else {
                        status = "Reject";
                        result = "Blank DATA FORMAT passed.";
                        isError = true;
                    }
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&REF_ID=" + refId);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getData() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getData() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getPageDetails", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getData() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getData");
                            BaseLogger.log("3", null, null, "getData() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getData() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        if ("XML".equalsIgnoreCase(dataFormat)) {
                            result = this.getDetailXMLDomString(objName, "1", "V", refId, null, userInfo);
                            BaseLogger.log("3", null, null, " variable: resultinXML length: [" + result.length() + "]" + "method: getData : class: VisionOBJService ");
                            status = "success";
                        }
                        if ("JSON".equalsIgnoreCase(dataFormat)) {
                            result = this.getDetailJSON(objName, "1", "V", refId, null, userInfo).toString();
                            status = "success";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result, userInfo);
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getData", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getData )", status, result, appId, request, userInfo);
        return result;
    }

    public String getReportArgs(String objName, String dataFormat, String appId, String formName, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String status;
        String result;
        block30: {
            BaseLogger.log("3", null, null, "Inside getData : getReportArgs ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getReportArgs() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getReportArgs() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getReportArgs() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getReportArgs() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getReportArgs() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getReportArgs() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getReportArgs", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getReportArgs() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getReportArgs");
                            BaseLogger.log("3", null, null, "getReportArgs() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getReportArgs() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        XSDParser xsdParser = new XSDParser(objName, userInfo);
                        String argXmlString = xsdParser.getArgumentMetaDataString();
                        BaseLogger.log("3", userInfo, null, "argXmlString:: [" + argXmlString + "]");
                        if (argXmlString.length() > 0) {
                            if (dataFormat.equalsIgnoreCase("JSON")) {
                                E12GenericUtility genericUtility = new E12GenericUtility();
                                String xmlString = genericUtility.xmlToJSONString(argXmlString);
                                BaseLogger.log("3", userInfo, null, "argXmlString to json:: [" + xmlString + "]");
                                JSONObject resultJSON = new JSONObject();
                                resultJSON.put("form_title", (Object)formName);
                                resultJSON.put("form_no", (Object)"0");
                                resultJSON.put("obj_name", (Object)objName);
                                resultJSON.put("id", (Object)(String.valueOf(objName) + "_1_2"));
                                JSONObject xsdJSON = new JSONObject(xmlString);
                                BaseLogger.log("3", userInfo, null, "argXmlString to json:: [" + xsdJSON + "]");
                                resultJSON.put("columns", (Object)this.getColumnsArray(xsdJSON));
                                result = resultJSON.toString();
                                status = "success";
                                BaseLogger.log("3", userInfo, null, "getReportArgs() result:: [" + result + "]");
                            }
                        } else {
                            result = "Something went wrong, please check object name!!";
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getReportArgs", params, tokenId, dataFormat, status, result, userInfo);
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getReportArgs", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getReportArgs", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getReportArgs )", status, result, appId, request, userInfo);
        return result;
    }

    public String getReport(String objName, String appId, String dataFormat, String docType, String reportArgument, HttpServletRequest request, HttpHeaders header, HttpServletResponse response) {
        E12ExtServiceUtility e12ExtServiceUtility;
        UserInfoBean userInfo;
        String status;
        String result;
        block31: {
            BaseLogger.log("3", null, null, "Inside getData : getReport ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String filePath = null;
            boolean isError = false;
            userInfo = null;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getReport() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getReport() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getReport() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getReport() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&DATA_FORMAT=" + dataFormat);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getReport() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getReport() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getReport", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getReport() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getReport");
                            BaseLogger.log("3", null, null, "getReport() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getReport() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        String backgrndProcess = "false";
                        String deviceType = "";
                        String fromSqlTimeOut = "";
                        String fromBackgrounServer = "false";
                        String userCode = userInfo.getLoginCode();
                        String isExplore = "";
                        boolean isConfirmReprint = false;
                        String browserType = null;
                        String notifyBy = null;
                        String remoteAddress = request.getRemoteAddr();
                        ViewReport viewReport = new ViewReport();
                        viewReport.getReport(docType, objName, backgrndProcess, deviceType, reportArgument, fromSqlTimeOut, fromBackgrounServer, userCode, isExplore, isConfirmReprint, browserType, notifyBy, remoteAddress);
                        filePath = viewReport.getFilePath();
                        BaseLogger.log("3", userInfo, null, "report filePath:::[" + filePath + "]");
                        if (filePath != null && filePath.length() > 0) {
                            File dir = new File(filePath);
                            if (dir.exists()) {
                                ServletOutputStream outputStream = response.getOutputStream();
                                FileInputStream fis = new FileInputStream(filePath);
                                byte[] buffer = new byte[(int)dir.length()];
                                int length = 0;
                                while ((length = fis.read(buffer)) > 0) {
                                    outputStream.write(buffer, 0, length);
                                }
                                fis.close();
                                outputStream.flush();
                                result = "success";
                                response.setContentType("application/octet-stream");
                                response.setHeader("Content-Disposition", "attachment; filename=\"" + dir.getName() + "\"");
                                response.setBufferSize(buffer.length);
                                result = "Report downloading";
                                status = "success";
                                BaseLogger.log("3", userInfo, null, "getReport() result:: [" + result + "]");
                            }
                        } else {
                            result = "Report Not Found";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "VisionOBJService/getReport", params, tokenId, dataFormat, status, result, userInfo);
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "VisionOBJService/getReport", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "VisionOBJService/getReport", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getReport )", status, result, appId, request, userInfo);
        return result;
    }

    public String getObjPopHelpInfoAll(String objName, String tokenIDfromHeader, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block27: {
            BaseLogger.log("3", null, null, "Inside getObjPopHelpInfoAll : getReportArgs ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("OBJ_NAME=" + objName);
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getObjPopHelpInfoAll", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getObjPopHelpInfoAll");
                            BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getObjPopHelpInfoAll() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        PopUpDataAccessEJB popUpDataAccess = new PopUpDataAccessEJB();
                        JSONObject popUpString = popUpDataAccess.getAllPopUpJSONString(userInfo, objName);
                        result = popUpString.toString();
                        status = "Success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getObjPopHelpInfoAll", params, tokenId, dataFormat, status, result, userInfo);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getObjPopHelpInfoAll", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getObjPopHelpInfoAll", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getObjPopHelpInfoAll)", status, result, appId, request, userInfo);
        return result;
    }

    public String downloadDataModelsList(String applName, String dataModelName, String scopeParameters, String dataModelToDownload, String responseFormat, HttpServletResponse response, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block34: {
            BaseLogger.log("3", null, null, "Inside downloadDataModelsList : getReportArgs ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "downloadDataModelsList() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "downloadDataModelsList() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "downloadDataModelsList() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "downloadDataModelsList() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "downloadDataModelsList() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "downloadDataModelsList() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("downloadDataModelsList", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "downloadDataModelsList() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "downloadDataModelsList");
                            BaseLogger.log("3", null, null, "downloadDataModelsList() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "downloadDataModelsList() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        E12DataModelComponent e12DataModelComponent = new E12DataModelComponent();
                        boolean isMobile = true;
                        String xmlData = e12DataModelComponent.prepareDataModeldetails(userInfo.getLoginCode(), userInfo.getProfileId(), applName, isMobile, userInfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                        BaseLogger.log("3", null, null, "XML data is: [" + xmlData + "]");
                        if (this.isJSONArray(xmlData)) {
                            BaseLogger.log("3", null, null, "XML data is JSON Array:");
                            JSONArray arr = new JSONArray(xmlData);
                            JSONObject obj = new JSONObject();
                            JSONArray dataModelArray = new JSONArray();
                            int i = 0;
                            while (i < arr.length()) {
                                JSONObject object = arr.getJSONObject(i);
                                if (object.has("file_path")) {
                                    String filePath = object.getString("file_path");
                                    if (filePath.contains(".xml")) {
                                        dataModelName = object.getString("data_model");
                                        dataModelToDownload = "";
                                        responseFormat = "JSON";
                                        isMobile = false;
                                        String JsonResult = e12DataModelComponent.prepareDataModelDetailsJSON(userInfo.getLoginCode(), userInfo.getProfileId(), applName, isMobile, userInfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                                        String jsonFilePath = filePath.replace(".xml", ".json");
                                        BaseLogger.log("3", null, null, "Data model JSON File Path= " + jsonFilePath);
                                        String writtenFilePath = this.writeDataToFile(userInfo.getLoginCode(), String.valueOf(dataModelName) + "." + responseFormat.toLowerCase(), JsonResult, dataModelName);
                                        BaseLogger.log("3", null, null, "File .writtenFilePath= " + writtenFilePath);
                                        object.put("file_path", (Object)writtenFilePath);
                                    }
                                    dataModelArray.put((Object)object);
                                }
                                ++i;
                            }
                            obj.put("data_model", (Object)dataModelArray);
                            result = obj.toString();
                        } else if (this.isJSONObject(xmlData)) {
                            JSONObject obj = new JSONObject();
                            obj.put("data_model", (Object)new JSONObject(xmlData));
                        } else {
                            result = xmlData;
                        }
                        status = "Success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "downloadDataModelsList", params, tokenId, dataFormat, status, result, userInfo);
                    break block34;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "downloadDataModelsList", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "downloadDataModelsList", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("VisionOBJService/downloadDataModelsList )", status, result, appId, request, userInfo);
        return result;
    }

    private String writeDataToFile(String loginCode, String fileName, String dataString, String dataModel) {
        String fileURL = "/ibase/";
        boolean isWriteFile = true;
        try {
            if (fileName.contains("/")) {
                fileName = fileName.replaceAll("/", "~");
            }
            BaseLogger.log("3", null, null, "Inside write data to file loginCode [" + loginCode + "] fileName  [" + fileName + "] dataModel [" + dataModel + "] ");
            E12GenericUtility genericUtility = new E12GenericUtility();
            String filePath = String.valueOf(CommonConstants.RIA_HDR_DATA_XMLFILE) + File.separator + "SCOPE_DATA" + File.separator + loginCode + File.separator + fileName;
            if (!new File(String.valueOf(CommonConstants.RIA_HDR_DATA_XMLFILE) + File.separator + "SCOPE_DATA" + File.separator + loginCode).exists()) {
                new File(String.valueOf(CommonConstants.RIA_HDR_DATA_XMLFILE) + File.separator + "SCOPE_DATA" + File.separator + loginCode).mkdir();
            }
            BaseLogger.log("3", null, null, "write data filePath [" + filePath + "]");
            if (isWriteFile) {
                genericUtility.writeToFile(dataString, filePath);
            }
            BaseLogger.log("3", null, null, "Inside write data to file 111");
            fileURL = String.valueOf(fileURL) + filePath.substring(filePath.indexOf("ibase.war") + "ibase.war".length() + 1, filePath.length());
            BaseLogger.log("3", null, null, "Inside write data to file 222");
            if (fileURL.contains("\\")) {
                fileURL = fileURL.replace('\\', '/');
            }
            BaseLogger.log("3", null, null, "RIADataSyncServlet 1502  fileURL====>" + fileURL);
            BaseLogger.log("3", null, null, "Inside write data to file 333");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileURL;
    }

    public String getObjItemChange(String objName, HttpServletResponse response, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block28: {
            BaseLogger.log("3", null, null, "Inside getObjItemChange ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getObjItemChange() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getObjItemChange() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getObjItemChange() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getObjItemChange() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getObjItemChange() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getObjItemChange() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getObjItemChange", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getObjItemChange() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getObjItemChange");
                            BaseLogger.log("3", null, null, "getObjItemChange() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getObjItemChange() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        JSONArray fieldsArray = new JSONArray();
                        Connection conn = null;
                        ConnDriver connDriver = new ConnDriver();
                        Statement statement = null;
                        ResultSet resultSet = null;
                        String jsFolderPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "webitm" + File.separator + "js" + File.separator + "offlinejs";
                        conn = connDriver.getConnectDB(userInfo.getTransDB());
                        String query = "select OBJ_NAME,FORM_NO,FIELD_NAME,MANDATORY,EXEC_AT,JS_ARG from OBJ_ITEMCHANGE WHERE OBJ_NAME='" + objName + "'";
                        statement = conn.createStatement();
                        resultSet = statement.executeQuery(query);
                        while (resultSet.next()) {
                            JSONObject fieldObj = new JSONObject();
                            fieldObj.put("obj_name", (Object)this.checkNull(resultSet.getString("OBJ_NAME")));
                            String formNo = this.checkNull(resultSet.getString("FORM_NO"));
                            fieldObj.put("form_no", (Object)formNo);
                            String fieldName = this.checkNull(resultSet.getString("FIELD_NAME"));
                            fieldObj.put("field_name", (Object)fieldName);
                            fieldObj.put("mandatory", (Object)this.checkNull(resultSet.getString("MANDATORY")));
                            fieldObj.put("exec_at", (Object)this.checkNull(resultSet.getString("EXEC_AT")));
                            fieldObj.put("js_arg", (Object)this.checkNull(resultSet.getString("JS_ARG")));
                            String jsFilePath = String.valueOf(jsFolderPath) + File.separator + objName + "~" + formNo + "~" + fieldName + ".js";
                            String jsData = this.getJSFileData(jsFilePath);
                            fieldObj.put("js_data", (Object)jsData);
                            fieldsArray.put((Object)fieldObj);
                        }
                        JSONObject resultObj = new JSONObject();
                        resultObj.put("fields", (Object)fieldsArray);
                        result = resultObj.toString();
                        status = "Success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getObjItemChange : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getObjItemChange", params, tokenId, dataFormat, status, result, userInfo);
                    break block28;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getObjItemChange", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getObjItemChange", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getObjItemChange)", status, result, appId, request, userInfo);
        return result;
    }

    public String getObjValidations(String objName, HttpServletResponse response, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block27: {
            BaseLogger.log("3", null, null, "Inside getObjValidations ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getObjValidations() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getObjValidations() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getObjValidations() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getObjValidations() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&APP_ID=" + appId);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getObjValidations() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getObjValidations() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getObjValidations", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getObjValidations() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getObjValidations");
                            BaseLogger.log("3", null, null, "getObjValidations() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getObjValidations() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        String jsFolderPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "webitm" + File.separator + "js" + File.separator + "offlinejs" + File.separator + objName.toLowerCase() + "~validations.js";
                        BaseLogger.log("3", null, null, "getObjValidations() JS file path=" + jsFolderPath);
                        JSONObject resultObj = new JSONObject();
                        resultObj.put("js_data", (Object)this.getJSFileData(jsFolderPath));
                        result = resultObj.toString();
                        status = "Success";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getObjValidations : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getObjValidations", params, tokenId, dataFormat, status, result, userInfo);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getObjValidations", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getObjValidations", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getObjItemChange)", status, result, appId, request, userInfo);
        return result;
    }

    public String getPophelpData(String objName, String fieldName, String formNo, Map<String, String> pophelpInput, HttpServletResponse response, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block29: {
            String dataFormat;
            String tokenId;
            String params;
            block28: {
                BaseLogger.log("3", null, null, "Inside getPophelpData ");
                result = "";
                params = "";
                status = "error";
                tokenId = "";
                dataFormat = "JSON";
                appId = "";
                boolean isError = false;
                e12ExtServiceUtility = new E12ExtServiceUtility();
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                APIUtility apiUtility = new APIUtility();
                userInfo = null;
                try {
                    try {
                        tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                        BaseLogger.log("3", null, null, "getPophelpData() TOKENID length=" + tokenId.length());
                        if (tokenId.length() == 0) {
                            status = "Reject";
                            result = "Blank Token ID passed.";
                            isError = true;
                            BaseLogger.log("3", null, null, "getPophelpData() TOKENID length return error" + tokenId.length());
                        }
                        if (!isError) {
                            userInfo = this.getUserInfo(request, tokenId);
                        }
                        if (!isError && userInfo == null) {
                            status = "Reject";
                            result = "User not allowed.";
                            isError = true;
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            appId = apiUtility.getAppIdFromJWTToken(tokenId);
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            status = "Reject";
                            result = "Blank APPID passed.";
                            isError = true;
                        }
                        BaseLogger.log("3", null, null, "getPophelpData() appId=" + appId);
                        params = request.getQueryString();
                        BaseLogger.log("3", null, null, "getPophelpData() request.getQueryString() " + request.getQueryString());
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("&TOKEN_ID=" + tokenId);
                            paramString.append("&APP_ID=" + appId);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "getPophelpData() params=" + params);
                        if (!isError && !appId.equals("FLUTTERAPP")) {
                            BaseLogger.log("3", null, null, "getPophelpData() none flutter APP");
                            ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getPophelpData", appId);
                            if (authAppAPIBean == null) {
                                status = "Reject";
                                result = "This service not available for given APPID";
                                isError = true;
                                BaseLogger.log("3", null, null, "getPophelpData() none flutter result=" + result);
                            } else {
                                result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getObjValidations");
                                BaseLogger.log("3", null, null, "getPophelpData() result=" + result);
                                if ("valid".equalsIgnoreCase(result)) {
                                    if (apiUtility.checkDailyAPILimit(userInfo)) {
                                        status = "Reject";
                                        result = "Daily API call limit exceeded";
                                        isError = true;
                                        BaseLogger.log("3", null, null, "getPophelpData() none flutter validation result=" + result);
                                    }
                                } else {
                                    status = "Reject";
                                    isError = true;
                                }
                            }
                        }
                        if (isError) break block28;
                        Connection conn = null;
                        ConnDriver connDriver = new ConnDriver();
                        conn = connDriver.getConnectDB(userInfo.getTransDB());
                        Map<String, String> pohelpInfo = this.getPophelpInfo(objName, fieldName, conn);
                        JSONObject pophelpData = this.getPophelpDataMap(pohelpInfo, pophelpInput, objName, formNo, fieldName, userInfo);
                        result = pophelpData.toString();
                        pohelpInfo.put("Data", pophelpData.toString());
                        try {
                            JSONObject resultJSON = new JSONObject(pohelpInfo);
                            resultJSON.put("Data", pophelpData.get("Data"));
                            result = resultJSON.toString();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            result = "Error in converting";
                        }
                        if (conn != null) {
                            conn.close();
                        }
                        status = "Success";
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : getPophelpData : " + e.getMessage());
                        result = this.getStackTrace(e, dataFormat);
                        status = "exception";
                        if (tokenId.length() != 0 && userInfo == null) {
                            JSONObject resultObj = new JSONObject();
                            try {
                                resultObj.put("data", (Object)new JSONObject());
                                resultObj.put("error", (Object)"Invalid TOKEN");
                                resultObj.put("status", (Object)"Reject");
                                return resultObj.toString();
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                                return resultObj.toString();
                            }
                        }
                        result = this.generateResponse(request, "getPophelpData", params, tokenId, dataFormat, status, result, userInfo);
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getPophelpData", params, tokenId, dataFormat, status, result, userInfo);
                    throw throwable;
                }
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getPophelpData", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getObjItemChange)", status, result, appId, request, userInfo);
        return result;
    }

    private String readFile(File fileName) throws Exception {
        StringBuffer fileContent = new StringBuffer();
        BufferedReader bfr = null;
        try {
            if (fileName.exists()) {
                FileInputStream fMainIn = new FileInputStream(fileName);
                bfr = new BufferedReader(new InputStreamReader((InputStream)fMainIn, CommonConstants.ENCODING));
                String outTempStr = null;
                while ((outTempStr = bfr.readLine()) != null) {
                    fileContent.append(outTempStr);
                }
                bfr.close();
                bfr = null;
            }
        }
        finally {
            try {
                if (bfr != null) {
                    bfr.close();
                    bfr = null;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception in releasing file resource :[" + fileName + "]");
                e.printStackTrace();
            }
        }
        return fileContent.toString();
    }

    private JSONArray getPageMetadataJSON(String xmlData) {
        try {
            JSONArray columnArray = new JSONArray();
            BaseLogger.log("3", null, null, "getPageMeta() xmlData=" + xmlData.length());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlData.getBytes()));
            NodeList columnObjectList = doc.getElementsByTagName("ColumnObject");
            NodeList textObjectList = doc.getElementsByTagName("TextObject");
            Map<String, String> labelMap = this.getLabelMap(textObjectList);
            BaseLogger.log("3", null, null, "label map " + labelMap);
            NodeList groupboxObjectList = doc.getElementsByTagName("GroupBox");
            JSONArray groupArray = this.getGroupBoxArray(groupboxObjectList);
            BaseLogger.log("3", null, null, "group array = " + groupArray.toString());
            NodeList tableColumnList = doc.getElementsByTagName("table_column");
            Map<String, JSONObject> tableColumnObjectWithValue = this.getValueTableColumn(tableColumnList);
            BaseLogger.log("3", null, null, "table column Map= " + tableColumnObjectWithValue);
            BaseLogger.log("3", null, null, "table column size " + tableColumnList.getLength());
            int i = 0;
            while (i < columnObjectList.getLength()) {
                Element columnObject = (Element)columnObjectList.item(i);
                JSONObject column = new JSONObject();
                column.put("alignment", (Object)this.checkNull(this.getElementValue(columnObject, "alignment")));
                column.put("tabsequence", (Object)this.checkNull(this.getElementValue(columnObject, "tabsequence")));
                column.put("x", (Object)this.checkNull(this.getElementValue(columnObject, "x")));
                column.put("y", (Object)this.checkNull(this.getElementValue(columnObject, "y")));
                column.put("height", (Object)this.checkNull(this.getElementValue(columnObject, "height")));
                column.put("width", (Object)this.checkNull(this.getElementValue(columnObject, "width")));
                column.put("format", (Object)this.checkNull(this.getElementValue(columnObject, "format")));
                column.put("name", (Object)this.checkNull(this.getElementValue(columnObject, "name")));
                column.put("visible", (Object)this.checkNull(this.getElementValue(columnObject, "visible")));
                column.put("tag", (Object)this.checkNull(this.getElementValue(columnObject, "tag")));
                String name = this.checkNull(this.getElementValue(columnObject, "name"));
                BaseLogger.log("3", null, null, "table column name " + name);
                Element editStyle = (Element)columnObject.getElementsByTagName("EditStyle").item(0);
                BaseLogger.log("3", null, null, "table column editStyle is null? " + (editStyle == null));
                if (editStyle != null) {
                    String style = this.checkNull(editStyle.getAttribute("style"));
                    column.put("edit_style", (Object)style);
                    String limit = this.checkNull(this.getElementValue(editStyle, "limit"));
                    column.put("limit", (Object)limit);
                    String required = this.checkNull(this.getElementValue(editStyle, "required"));
                    required = required.equals("") ? "false" : "true";
                    column.put("required", (Object)required);
                    String caseValue = this.checkNull(this.getElementValue(editStyle, "case"));
                    column.put("case", (Object)caseValue);
                    String mask = this.checkNull(this.getElementValue(editStyle, "mask"));
                    column.put("mask", (Object)mask);
                }
                column.put("display_label", (Object)this.checkNull(labelMap.get(name)));
                String x = this.checkNull(this.getElementValue(columnObject, "x"));
                String y = this.checkNull(this.getElementValue(columnObject, "y"));
                String group = this.checkNull(this.findGroup(x, y, groupArray));
                column.put("group", (Object)group);
                BaseLogger.log("3", null, null, "Found groupbox name " + group);
                BaseLogger.log("3", null, null, "getting table cols for  " + name);
                if (tableColumnObjectWithValue.containsKey(name)) {
                    JSONObject obj = tableColumnObjectWithValue.get(name);
                    BaseLogger.log("3", null, null, "Found JSON OBJECT " + name + "=" + obj);
                    Iterator keys = obj.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        column.put(key, obj.get(key));
                    }
                }
                BaseLogger.log("3", null, null, "getting column  " + column);
                columnArray.put((Object)column);
                ++i;
            }
            BaseLogger.log("3", null, null, "getting column  Array " + columnArray);
            return columnArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", null, null, "Error in getting JSON");
            BaseLogger.log("3", null, null, "Error in getting JSON" + e.getMessage());
            BaseLogger.log("3", null, null, "Error in getting JSON" + e);
            return new JSONArray();
        }
    }

    private String getElementValue(Element parentElement, String tagName) {
        NodeList nodeList = parentElement.getElementsByTagName(tagName);
        if (nodeList.getLength() > 0) {
            return nodeList.item(0).getTextContent();
        }
        return "";
    }

    private String findGroup(String x, String y, JSONArray groupArray) {
        String groupName = "";
        try {
            int columnX = Integer.parseInt(x);
            int columnY = Integer.parseInt(y);
            int i = 0;
            while (i < groupArray.length()) {
                JSONObject groupBox = groupArray.getJSONObject(i);
                String name = groupBox.getString("name");
                int groupBoxX = groupBox.getInt("x");
                int groupBoxXMax = groupBox.getInt("x_max");
                int groupBoxY = groupBox.getInt("y");
                int groupBoxYMax = groupBox.getInt("y_max");
                if (columnX >= groupBoxX && columnX <= groupBoxXMax && columnY >= groupBoxY && columnY <= groupBoxYMax) {
                    groupName = name;
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error: " + e.getMessage());
        }
        BaseLogger.log("3", null, null, "Found Groups name " + groupName);
        return groupName;
    }

    Map<String, String> getLabelMap(NodeList textObjectList) {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        int nodeCount = textObjectList.getLength();
        int i = 0;
        while (i < nodeCount) {
            Node node = textObjectList.item(i);
            if (node.getNodeType() == 1) {
                try {
                    Element textObject = (Element)node;
                    String name = this.getElementValue(textObject, "name");
                    String text = this.getElementValue(textObject, "text");
                    if (name != null && !name.isEmpty()) {
                        if (name.endsWith("_t")) {
                            name = name.substring(0, name.length() - 2);
                        }
                        labelMap.put(name, text != null ? text : "");
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Error processing node: " + e.getMessage());
                }
            }
            ++i;
        }
        return labelMap;
    }

    private JSONArray getGroupBoxArray(NodeList groupboxObjectList) {
        JSONArray groupArray = new JSONArray();
        int nodeCount = groupboxObjectList.getLength();
        int i = 0;
        while (i < nodeCount) {
            Node node = groupboxObjectList.item(i);
            if (node.getNodeType() == 1) {
                try {
                    Element textObject = (Element)node;
                    String name = this.getElementValue(textObject, "text");
                    int x = this.parseElementValue(textObject, "x");
                    int y = this.parseElementValue(textObject, "y");
                    int width = this.parseElementValue(textObject, "width");
                    int height = this.parseElementValue(textObject, "height");
                    JSONObject group = new JSONObject().put("x", x).put("y", y).put("width", width).put("height", height).put("x_max", x + width).put("y_max", y + height).put("name", (Object)name);
                    groupArray.put((Object)group);
                }
                catch (NumberFormatException e) {
                    BaseLogger.log("3", null, null, "Invalid number format: " + e.getMessage());
                }
                catch (Exception e) {
                    BaseLogger.log("3", null, null, "Error processing node: " + e.getMessage());
                }
            }
            ++i;
        }
        return groupArray;
    }

    private int parseElementValue(Element element, String tagName) {
        String value = this.getElementValue(element, tagName);
        return value != null && !value.isEmpty() ? Integer.parseInt(value) : 0;
    }

    private Map<String, JSONObject> getValueTableColumn(NodeList tableColumnList) {
        HashMap<String, JSONObject> elementMap = new HashMap<String, JSONObject>();
        try {
            int columnCount = tableColumnList.getLength();
            int i = 0;
            while (i < columnCount) {
                Node node = tableColumnList.item(i);
                if (node.getNodeType() == 1) {
                    NodeList typeNodeList;
                    Element tableColumnElement = (Element)node;
                    String columnName = this.getElementValue(tableColumnElement, "name");
                    String initial = this.getElementValue(tableColumnElement, "initial");
                    JSONObject columnDetails = new JSONObject();
                    NodeList valuesList = tableColumnElement.getElementsByTagName("values");
                    if (valuesList.getLength() > 0) {
                        JSONArray valueArray = new JSONArray();
                        Element valuesElement = (Element)valuesList.item(0);
                        NodeList itemList = valuesElement.getElementsByTagName("item");
                        int j = 0;
                        while (j < itemList.getLength()) {
                            Element itemElement = (Element)itemList.item(j);
                            JSONObject item = new JSONObject().put("display", (Object)itemElement.getAttribute("display")).put("data", (Object)itemElement.getAttribute("data"));
                            valueArray.put((Object)item);
                            ++j;
                        }
                        columnDetails.put("values", (Object)valueArray);
                    }
                    if (initial != null && !initial.isEmpty()) {
                        columnDetails.put("initial", (Object)initial);
                    }
                    if ((typeNodeList = tableColumnElement.getElementsByTagName("type")).getLength() > 0) {
                        Element typeElement = (Element)typeNodeList.item(0);
                        String typeValue = typeElement.getTextContent();
                        columnDetails.put("data_type", (Object)typeValue);
                        NamedNodeMap attributes = typeElement.getAttributes();
                        int j = 0;
                        while (j < attributes.getLength()) {
                            Node attribute = attributes.item(j);
                            columnDetails.put(attribute.getNodeName(), (Object)attribute.getNodeValue());
                            ++j;
                        }
                    }
                    if (columnName != null && !columnName.isEmpty()) {
                        elementMap.put(columnName, columnDetails);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error processing table columns: " + e.getMessage());
        }
        BaseLogger.log("3", null, null, "Final Element Map: " + elementMap);
        return elementMap;
    }

    private Map<String, JSONObject> getValueTableColumn2(NodeList tableColumnList) {
        HashMap<String, JSONObject> elementMap = new HashMap<String, JSONObject>();
        try {
            int i = 0;
            while (i < tableColumnList.getLength()) {
                Element tableColumnElement;
                NodeList valuesList;
                Node node = tableColumnList.item(i);
                if (node.getNodeType() == 1 && (valuesList = (tableColumnElement = (Element)node).getElementsByTagName("values")).getLength() > 0) {
                    String columnName = this.getElementValue(tableColumnElement, "name");
                    String initial = this.getElementValue(tableColumnElement, "initial");
                    Element valuesElement = (Element)valuesList.item(0);
                    NodeList itemList = valuesElement.getElementsByTagName("item");
                    JSONArray valueArray = new JSONArray();
                    int j = 0;
                    while (j < itemList.getLength()) {
                        Element itemElement = (Element)itemList.item(j);
                        String displayValue = itemElement.getAttribute("display");
                        String dataValue = itemElement.getAttribute("data");
                        JSONObject item = new JSONObject();
                        item.put("display", (Object)displayValue);
                        item.put("data", (Object)dataValue);
                        valueArray.put((Object)item);
                        ++j;
                    }
                    JSONObject values = new JSONObject();
                    values.put("values", (Object)valueArray);
                    values.put("initial", (Object)initial);
                    elementMap.put(columnName, values);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elementMap;
    }

    public String getTokenFromHeaders(HttpHeaders headers) {
        BaseLogger.log("0", null, null, "Getting header info: ");
        String tokenId = null;
        List tokenIdList = headers.getRequestHeader("TOKEN_ID");
        if (tokenIdList != null && !tokenIdList.isEmpty()) {
            BaseLogger.log("0", null, null, "GOt token list item=" + tokenIdList);
            tokenId = (String)tokenIdList.get(0);
        }
        return tokenId;
    }

    public JSONArray getFormalArgs(String xmlString) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlString.getBytes()));
            JSONArray formalArgsArray = new JSONArray();
            NodeList formalArgsList = doc.getElementsByTagName("FORMALARGS");
            if (formalArgsList.getLength() > 0) {
                Element formalArgs = (Element)formalArgsList.item(0);
                NodeList formalArgList = formalArgs.getElementsByTagName("FORMALARG");
                int xValue = 10;
                int yValue = 10;
                int tabSeq = 10;
                int i = 0;
                while (i < formalArgList.getLength()) {
                    Element formalArg = (Element)formalArgList.item(i);
                    String fieldName = formalArg.getAttribute("field_name");
                    String name = formalArg.getAttribute("name");
                    String javaType = formalArg.getAttribute("javatype");
                    String value = this.getElementValue(formalArg, "value");
                    if (name != null && !name.isEmpty()) {
                        name = Arrays.stream(name.toLowerCase().replace("_", " ").split("\\s+")).map(word -> word.isEmpty() ? word : String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1)).collect(Collectors.joining(" "));
                    }
                    JSONObject formaArgsObj = new JSONObject();
                    formaArgsObj.put("display_label", (Object)name);
                    formaArgsObj.put("group", (Object)"");
                    formaArgsObj.put("value", (Object)value);
                    formaArgsObj.put("alignment", (Object)"");
                    formaArgsObj.put("tabsequence", (Object)String.valueOf(tabSeq));
                    formaArgsObj.put("x", (Object)String.valueOf(xValue));
                    formaArgsObj.put("y", (Object)String.valueOf(yValue));
                    formaArgsObj.put("height", (Object)"16");
                    formaArgsObj.put("width", (Object)"66");
                    formaArgsObj.put("format", (Object)("[" + javaType + "]"));
                    formaArgsObj.put("name", (Object)fieldName);
                    formaArgsObj.put("tag", (Object)"");
                    formaArgsObj.put("visible", (Object)"1");
                    formaArgsObj.put("edit_style", (Object)"edit");
                    formaArgsObj.put("limit", (Object)"");
                    formaArgsObj.put("case", (Object)"");
                    formaArgsObj.put("mask", (Object)"");
                    yValue += 10;
                    tabSeq += 10;
                    formalArgsArray.put((Object)formaArgsObj);
                    ++i;
                }
                BaseLogger.log("3", null, null, "getFormalArgs formalArgsArray=" + formalArgsArray.toString());
                return formalArgsArray;
            }
            return new JSONArray();
        }
        catch (Exception e) {
            return new JSONArray();
        }
    }

    private String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException {
        String resultString = "";
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(userInfo);
                resultString = masterStateful.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultString;
    }

    private JSONObject getDetailJSON(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException {
        JSONObject resultJSON = new JSONObject();
        MasterStatefulLocal masterStateful = null;
        try {
            try {
                masterStateful = (MasterStatefulLocal)this.getInitialContext().lookup("ibase/MasterStatefulEJB/local");
                int randInt = new Random().nextInt();
                masterStateful.setEditorId("" + randInt);
                masterStateful.setUserInfo(userInfo);
                resultJSON = masterStateful.getDetailJSONString(objName, objContext, editFlag, pkValues, argFieldValues);
            }
            catch (NamingException e) {
                BaseLogger.log("0", null, null, "NamingException :: getDetailXMLDomString() :==>\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            if (masterStateful != null) {
                masterStateful.remove();
                masterStateful = null;
            }
        }
        return resultJSON;
    }

    private InitialContext getInitialContext() throws ITMException {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", null, null, "ITMException : getInitialContext : " + itme.getMessage());
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getInitialContext : " + e.getMessage());
            throw new ITMException(e);
        }
        return ctx;
    }

    private JSONArray getColumnsArray(JSONObject xsdJSON) {
        JSONArray columnArray = new JSONArray();
        BaseLogger.log("3", null, null, "argument creating Array of json= " + xsdJSON);
        try {
            JSONObject argumentsObj = xsdJSON.getJSONObject("arguments");
            Object argumentObj = argumentsObj.get("argument");
            if (argumentObj instanceof JSONArray) {
                BaseLogger.log("3", null, null, "argument is Array");
                JSONArray argumentArray = (JSONArray)argumentObj;
                int tabSequence = 10;
                int xVal = 10;
                int yVal = 10;
                int i = 0;
                while (i < argumentArray.length()) {
                    JSONObject argObj = argumentArray.getJSONObject(i);
                    BaseLogger.log("3", null, null, "argument value=" + argObj);
                    JSONObject column = new JSONObject();
                    column.put("tabsequence", (Object)String.valueOf(tabSequence));
                    tabSequence += 10;
                    String visible = argObj.getJSONObject("attrib").getString("@visible");
                    column.put("visible", (Object)visible);
                    String format = argObj.getJSONObject("attrib").getString("@type");
                    String[] parts = format.split("\\.");
                    String formatVal = parts[parts.length - 1];
                    column.put("format", (Object)("[" + formatVal + "]"));
                    column.put("data_type", (Object)format);
                    column.put("required", (Object)"false");
                    String displayLabel = argObj.getJSONObject("attrib").getString("@label");
                    column.put("display_label", (Object)displayLabel);
                    String editStyle = argObj.getJSONObject("attrib").getString("@inputType");
                    column.put("edit_style", (Object)editStyle);
                    column.put("x", (Object)String.valueOf(xVal));
                    xVal += xVal;
                    column.put("y", (Object)String.valueOf(yVal));
                    yVal += yVal;
                    String width = argObj.getJSONObject("attrib").getString("@width");
                    column.put("width", (Object)width);
                    String name = argObj.getJSONObject("attrib").getString("@name");
                    column.put("name", (Object)name);
                    String limit = argObj.getJSONObject("attrib").getString("@size");
                    column.put("limit", (Object)limit);
                    column.put("tag", (Object)"");
                    String alignment = argObj.getJSONObject("attrib").getString("@alignment");
                    column.put("alignment", (Object)alignment);
                    String caseType = argObj.getJSONObject("attrib").getString("@caseType");
                    column.put("case", (Object)caseType);
                    String height = argObj.getJSONObject("attrib").getString("@height");
                    column.put("height", (Object)height);
                    column.put("mask", (Object)"");
                    column.put("group", (Object)"");
                    columnArray.put((Object)column);
                    ++i;
                }
            } else if (argumentObj instanceof JSONObject) {
                BaseLogger.log("3", null, null, "argument is JSONOBJECT");
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getting column list" + e.getMessage());
        }
        return columnArray;
    }

    public String getObjPopHelpInfoAll_old(String objName, String tokenIDfromHeader) {
        UserInfoBean userInfo = null;
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
        }
        PopUpEJB popUp = new PopUpEJB();
        String popXmlString = popUp.getPopxmlData(objName, userInfo);
        String reqPopxml = "<ROOT>" + popXmlString + "</ROOT>";
        try {
            Document currentDetailNode = new E12GenericUtility().parseString(reqPopxml);
            if (currentDetailNode != null && currentDetailNode.getElementsByTagName("Errors").item(0) == null) {
                E12GenericUtility gn = new E12GenericUtility();
                reqPopxml = gn.xmlToJSONString(reqPopxml);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reqPopxml;
    }

    public boolean isJSONArray(String response) {
        try {
            new JSONArray(response);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isJSONObject(String response) {
        try {
            new JSONObject(response);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getJSFileData(String jsFilePath) {
        StringBuilder contentBuilder;
        block15: {
            contentBuilder = new StringBuilder();
            try {
                File file = new File(jsFilePath);
                if (file.exists() && file.isFile()) {
                    try {
                        Throwable throwable = null;
                        Object var5_8 = null;
                        try (BufferedReader br = new BufferedReader(new FileReader(file));){
                            String currentLine;
                            while ((currentLine = br.readLine()) != null) {
                                contentBuilder.append(currentLine);
                            }
                            break block15;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return "";
                    }
                }
                return "";
            }
            catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }
        return contentBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, String> getPophelpInfo(String objName, String fieldName, Connection conn) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT POPHELP_SOURCE, SQL_STR, SQL_INPUT, DATA_MODEL_NAME FROM POPHELP WHERE MOD_NAME = 'W_" + objName.toUpperCase() + "' and FIELD_NAME='" + fieldName.toUpperCase() + "'";
        BaseLogger.log("3", null, null, "SQL for getting pohelpinfo=" + sql);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try {
                Statement statement = conn.createStatement();
                try {
                    try (ResultSet resultSet = statement.executeQuery(sql);){
                        while (resultSet.next()) {
                            resultMap.put("POPHELP_SOURCE", resultSet.getString("POPHELP_SOURCE"));
                            resultMap.put("SQL_STR", resultSet.getString("SQL_STR"));
                            resultMap.put("SQL_INPUT", resultSet.getString("SQL_INPUT"));
                            resultMap.put("DATA_MODEL_NAME", resultSet.getString("DATA_MODEL_NAME"));
                        }
                    }
                    if (statement == null) return resultMap;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return resultMap;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            BaseLogger.log("0", null, null, "SQLException in getPophelpInfo: " + e.getMessage());
        }
        return resultMap;
    }

    private JSONObject getPophelpDataMap(Map<String, String> pohelpInfo, Map<String, String> pophelpInput, String objName, String formNo, String fieldName, UserInfoBean userinfo) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String dataModelName = this.checkNull(pohelpInfo.get("DATA_MODEL_NAME"));
        if (dataModelName.equalsIgnoreCase("") || dataModelName.length() <= 0) {
            PopUpEJB popUp = new PopUpEJB();
            String paramXmlStr = "<ROOT>";
            for (Map.Entry<String, String> entry : pophelpInput.entrySet()) {
                String tagName = entry.getKey().replaceAll(":", "");
                paramXmlStr = String.valueOf(paramXmlStr) + "<" + tagName + ">" + entry.getValue() + "</" + tagName + ">";
            }
            paramXmlStr = String.valueOf(paramXmlStr) + "</ROOT>";
            BaseLogger.log("3", null, null, "new getPopHelpData objName - [" + objName + "]");
            BaseLogger.log("3", null, null, "fieldName - [" + fieldName + "]");
            BaseLogger.log("3", null, null, "xmlString - [" + paramXmlStr + "]");
            BaseLogger.log("3", null, null, "xmlStringAll - []");
            BaseLogger.log("3", null, null, "reqParams - []");
            BaseLogger.log("3", null, null, "formNo - [" + formNo + "]");
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String allDetailXml = "";
                String xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userinfo, allDetailXml, formNo, "");
                BaseLogger.log("3", null, null, "GOt XML Data - [" + xmlString + "]");
                String jsonString = genericUtility.xmlToJSONString(xmlString);
                JSONObject jsonObject = new JSONObject(jsonString);
                BaseLogger.log("3", null, null, "GOt JSON Data - [" + jsonString + "]");
                JSONObject header0 = jsonObject.getJSONObject("DOCUMENTROOT").getJSONObject("GROUP0").getJSONObject("HEADER0");
                JSONObject detaiDatalObj = new JSONObject();
                Object detailObj = header0.opt("DETAIL");
                if (detailObj instanceof JSONObject) {
                    detaiDatalObj.put("Data", detailObj);
                } else if (detailObj instanceof JSONArray) {
                    detaiDatalObj.put("Data", detailObj);
                }
                BaseLogger.log("3", null, null, "GOt JSON detaiDatalObj - [" + detaiDatalObj.toString() + "]");
                BaseLogger.log("3", null, null, "GOt JSON header0 - [" + header0.toString() + "]");
                resultMap.put("Data", detaiDatalObj.toString());
                return detaiDatalObj;
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "GOt XML Data Error- [" + e.getMessage() + "]");
            }
        } else {
            JSONObject detaiDatalObj = new JSONObject();
            try {
                String format;
                E12DataModelComponent e12DataModelComponent = new E12DataModelComponent();
                String applName = "";
                boolean isMobile = false;
                String scopeParameters = "";
                String responseFormat = format = "JSON";
                String dataModelToDownload = "";
                for (Map.Entry<String, String> entry : pophelpInput.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    scopeParameters = "&" + entry.getKey() + "=" + entry.getValue();
                    BaseLogger.log("3", null, null, "Query parameter: " + key + " = " + value);
                }
                String dataModelValue = e12DataModelComponent.prepareDataModelDetailsJSON(userinfo.getLoginCode(), userinfo.getProfileId(), applName, isMobile, userinfo, dataModelName, scopeParameters, responseFormat, dataModelToDownload);
                JSONObject dataObj = new JSONObject(dataModelValue);
                detaiDatalObj.put("Data", (Object)dataObj);
            }
            catch (Exception e) {
                BaseLogger.log("3", null, null, "Error in getting Data model value: " + e.getMessage());
            }
            return detaiDatalObj;
        }
        return new JSONObject();
    }

    public String getOBJData(String objName, String objType, HttpServletResponse response, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block51: {
            Connection conn;
            String dataFormat;
            String tokenId;
            String params;
            block50: {
                BaseLogger.log("3", null, null, "Inside getOBJData ");
                result = "";
                params = "";
                status = "error";
                tokenId = "";
                dataFormat = "JSON";
                appId = "";
                conn = null;
                boolean isError = false;
                e12ExtServiceUtility = new E12ExtServiceUtility();
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                APIUtility apiUtility = new APIUtility();
                userInfo = null;
                try {
                    try {
                        tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                        BaseLogger.log("3", null, null, "getOBJData() TOKENID length=" + tokenId.length());
                        if (tokenId.length() == 0) {
                            status = "Reject";
                            result = "Blank Token ID passed.";
                            isError = true;
                            BaseLogger.log("3", null, null, "getOBJData() TOKENID length return error" + tokenId.length());
                        }
                        if (!isError) {
                            userInfo = this.getUserInfo(request, tokenId);
                        }
                        if (!isError && userInfo == null) {
                            status = "Reject";
                            result = "User not allowed.";
                            isError = true;
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            appId = apiUtility.getAppIdFromJWTToken(tokenId);
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            status = "Reject";
                            result = "Blank APPID passed.";
                            isError = true;
                        }
                        BaseLogger.log("3", null, null, "getOBJData() appId=" + appId);
                        params = request.getQueryString();
                        BaseLogger.log("3", null, null, "getOBJData() request.getQueryString() " + request.getQueryString());
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("&TOKEN_ID=" + tokenId);
                            paramString.append("&APP_ID=" + appId);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "getOBJData() params=" + params);
                        if (!isError && !appId.equals("FLUTTERAPP")) {
                            BaseLogger.log("3", null, null, "getOBJData() none flutter APP");
                            ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getObjData", appId);
                            if (authAppAPIBean == null) {
                                status = "Reject";
                                result = "This service not available for given APPID";
                                isError = true;
                                BaseLogger.log("3", null, null, "getOBJData() none flutter result=" + result);
                            } else {
                                result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getObjData");
                                BaseLogger.log("3", null, null, "getObjData() result=" + result);
                                if ("valid".equalsIgnoreCase(result)) {
                                    if (apiUtility.checkDailyAPILimit(userInfo)) {
                                        status = "Reject";
                                        result = "Daily API call limit exceeded";
                                        isError = true;
                                        BaseLogger.log("3", null, null, "getOBJData() none flutter validation result=" + result);
                                    }
                                } else {
                                    status = "Reject";
                                    isError = true;
                                }
                            }
                        }
                        if (isError) break block50;
                        ConnDriver connDriver = new ConnDriver();
                        conn = connDriver.getConnectDB(userInfo.getTransDB());
                        JSONObject objBasicInfo = this.getObjBasicInfo(objName, userInfo, conn);
                        BaseLogger.log("3", null, null, "sql_models objBasicInfo= " + objBasicInfo.toString());
                        JSONArray sqlModels = objBasicInfo.getJSONArray("sql_models");
                        if (objType.equalsIgnoreCase("R")) {
                            XSDParser xsdParser = new XSDParser(objName, userInfo);
                            String argXmlString = xsdParser.getArgumentMetaDataString();
                            BaseLogger.log("3", userInfo, null, "argXmlString:: [" + argXmlString + "]");
                            if (argXmlString.length() > 0) {
                                E12GenericUtility genericUtility = new E12GenericUtility();
                                String xmlString = genericUtility.xmlToJSONString(argXmlString);
                                BaseLogger.log("3", userInfo, null, "argXmlString to json:: [" + xmlString + "]");
                                JSONObject xsdJSON = new JSONObject(xmlString);
                                BaseLogger.log("3", userInfo, null, "argXmlString to json:: [" + xsdJSON + "]");
                                JSONArray sqlModelsArray = new JSONArray();
                                int i = 0;
                                while (i < sqlModels.length()) {
                                    JSONObject sqlModel = sqlModels.getJSONObject(i);
                                    BaseLogger.log("3", userInfo, null, "sqlModel:: [" + sqlModel + "]");
                                    sqlModel.put("columns", (Object)this.getReportColumnsArray(xsdJSON, objName, userInfo));
                                    JSONObject model = new JSONObject();
                                    model.put("sql_model", (Object)sqlModel);
                                    sqlModelsArray.put((Object)model);
                                    ++i;
                                }
                                JSONObject sqlModel = new JSONObject();
                                sqlModel.put("sql_models", (Object)sqlModelsArray);
                                result = sqlModel.toString();
                                status = "success";
                                isError = false;
                            } else {
                                isError = true;
                                status = "error";
                                result = "";
                            }
                            break block50;
                        }
                        long startTime = System.currentTimeMillis();
                        String pageDetailsXML = this.getPageDetailsXML(objName, userInfo);
                        JSONObject pageDetails = this.getPageDetailsJSON(pageDetailsXML);
                        BaseLogger.log("3", null, null, "pageDetails JSON duration=" + (System.currentTimeMillis() - startTime));
                        JSONArray actionArray = this.getActions(pageDetails);
                        String firstFormName = "";
                        ArrayList<String> usedFormName = new ArrayList<String>();
                        JSONArray unUsedLinks = new JSONArray();
                        int i = 0;
                        while (i < sqlModels.length()) {
                            JSONObject jsonObject = sqlModels.getJSONObject(i);
                            usedFormName.add(jsonObject.getString("form_no"));
                            if (firstFormName.equals("")) {
                                firstFormName = jsonObject.getString("form_title");
                            }
                            String metadataXML = this.getXMLMetadataFileContent(userInfo, objName, this.checkNull(jsonObject.getString("form_no")), "2");
                            startTime = System.currentTimeMillis();
                            jsonObject.put("columns", (Object)this.getPageColumnMetadata(metadataXML, objName, jsonObject.getString("form_no"), userInfo));
                            BaseLogger.log("3", null, null, "getPageColumnMetadata JSON duration=" + (System.currentTimeMillis() - startTime));
                            if (actionArray != null && actionArray.length() > 0) {
                                startTime = System.currentTimeMillis();
                                JSONArray actions = this.getActions(actionArray, objName, jsonObject.getString("form_no"), userInfo);
                                BaseLogger.log("3", null, null, "getActions JSON duration=" + (System.currentTimeMillis() - startTime));
                                jsonObject.put("actions", (Object)actions);
                            } else {
                                jsonObject.put("actions", (Object)new JSONArray());
                            }
                            startTime = System.currentTimeMillis();
                            JSONArray formItmChange = this.getObjFormItmChange(objName, jsonObject.getString("form_no"), userInfo);
                            BaseLogger.log("3", null, null, "getActions JSON duration=" + (System.currentTimeMillis() - startTime));
                            int in = 0;
                            while (in < formItmChange.length()) {
                                JSONObject obj = formItmChange.getJSONObject(in);
                                String FieldName = obj.getString("fieldName");
                                obj.remove("fieldName");
                                obj.remove("fieldFormNo");
                                jsonObject.put(FieldName, (Object)obj);
                                ++in;
                            }
                            startTime = System.currentTimeMillis();
                            JSONArray linksArray = this.getLinks(pageDetails, jsonObject.getString("form_no"));
                            JSONArray currentFormLinks = new JSONArray();
                            try {
                                int linkIndex = 0;
                                while (linkIndex < linksArray.length()) {
                                    JSONObject link = linksArray.getJSONObject(linkIndex);
                                    if (link.has("form_no") && String.valueOf(link.getInt("form_no")).equals(jsonObject.getString("form_no"))) {
                                        currentFormLinks.put((Object)link);
                                    } else {
                                        unUsedLinks.put((Object)link);
                                    }
                                    ++linkIndex;
                                }
                            }
                            catch (Exception ex) {
                                BaseLogger.log("3", null, null, "Error in getting maxformno+1 links=" + ex.getMessage());
                            }
                            BaseLogger.log("3", null, null, "getLinks JSON duration=" + (System.currentTimeMillis() - startTime));
                            jsonObject.put("links", (Object)currentFormLinks);
                            jsonObject.put("joins", (Object)new JSONObject());
                            if (i == 0) {
                                jsonObject.put("formal_args", (Object)this.getFormFormalArgs(pageDetails, firstFormName, objName));
                            }
                            sqlModels.put(i, (Object)new JSONObject().put("sql_model", (Object)jsonObject));
                            ++i;
                        }
                        startTime = System.currentTimeMillis();
                        JSONArray unformActions = this.getMaxFormActionsAndLinks(actionArray, usedFormName, unUsedLinks);
                        int i2 = 0;
                        while (i2 < unformActions.length()) {
                            sqlModels.put(unformActions.get(i2));
                            ++i2;
                        }
                        BaseLogger.log("3", null, null, "getMaxFormActionsAndLinks JSON duration=" + (System.currentTimeMillis() - startTime));
                        objBasicInfo.put("sql_models", (Object)sqlModels);
                        JSONObject transetup = this.getObjTransetup(objName, conn);
                        objBasicInfo.put("transetup", (Object)transetup);
                        objBasicInfo.put("obj_name", (Object)objName);
                        result = objBasicInfo.toString();
                        status = "success";
                        isError = false;
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : getOBJData : " + e.getMessage());
                        result = this.getStackTrace(e, dataFormat);
                        status = "exception";
                        if (tokenId.length() != 0 && userInfo == null) {
                            JSONObject resultObj = new JSONObject();
                            try {
                                resultObj.put("data", (Object)new JSONObject());
                                resultObj.put("error", (Object)"Invalid TOKEN");
                                resultObj.put("status", (Object)"Reject");
                                return resultObj.toString();
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                                return resultObj.toString();
                            }
                        }
                        result = this.generateResponse(request, "getObjData", params, tokenId, dataFormat, status, result, "transaction", userInfo);
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                            break block51;
                        }
                        catch (Exception resultObj) {}
                        break block51;
                    }
                }
                catch (Throwable throwable) {
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getObjData", params, tokenId, dataFormat, status, result, "transaction", userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (Exception resultObj) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getObjData", params, tokenId, dataFormat, status, result, "transaction", userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getOBJData)", status, result, appId, request, userInfo);
        return result;
    }

    JSONObject getObjTransetup(String objName, Connection conn) {
        JSONObject resultJson = new JSONObject();
        String sql = "SELECT OFFLINE_OPT FROM TRANSETUP WHERE TRAN_WINDOW = ?";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setString(1, "w_" + objName);
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        String offlineOpt = rs.getString("OFFLINE_OPT");
                        if (offlineOpt == null) {
                            resultJson.put("offline_opt", (Object)"0");
                        } else {
                            resultJson.put("offline_opt", (Object)offlineOpt);
                        }
                    } else {
                        BaseLogger.log("0", null, null, "No data found for TRAN_WINDOW='w_" + objName + "'");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception : getObjTransetup : " + ex.getMessage());
            return new JSONObject();
        }
        return resultJson;
    }

    JSONArray getActions(JSONObject pageDetails) {
        try {
            JSONObject transaction = pageDetails.getJSONObject("ROOT").getJSONObject("Transaction");
            if (transaction.has("ACTIONS")) {
                Object actionsObj = transaction.get("ACTIONS");
                if (actionsObj instanceof JSONObject) {
                    return ((JSONObject)actionsObj).getJSONArray("action");
                }
                if (actionsObj instanceof String) {
                    BaseLogger.log("3", null, null, "ACTIONS is a String: " + actionsObj);
                    return new JSONArray();
                }
                BaseLogger.log("3", null, null, "ACTIONS is of unexpected type: " + actionsObj.getClass());
                return new JSONArray();
            }
            BaseLogger.log("3", null, null, "ACTIONS key is missing.");
            return new JSONArray();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getActions()=" + e.getMessage());
            return new JSONArray();
        }
    }

    JSONArray getMaxFormActionsAndLinks(JSONArray actionArray, ArrayList<String> usedFormName, JSONArray linkArray) {
        try {
            JSONArray sqlModels = new JSONArray();
            HashMap<String, JSONArray> actionMap = new HashMap<String, JSONArray>();
            int i = 0;
            while (i < actionArray.length()) {
                JSONObject action = actionArray.getJSONObject(i);
                BaseLogger.log("3", null, null, "Un formed action obj=" + action);
                String existingForm = String.valueOf(action.getInt("formNo"));
                BaseLogger.log("3", null, null, "existingForm=" + existingForm);
                if (!usedFormName.contains(existingForm)) {
                    BaseLogger.log("3", null, null, "formNo used=" + existingForm);
                    if (actionMap.containsKey(existingForm)) {
                        BaseLogger.log("3", null, null, "formNo key exist in actionMap=" + existingForm);
                        JSONArray array = (JSONArray)actionMap.get(existingForm);
                        array.put((Object)action);
                        actionMap.put(existingForm, array);
                    } else {
                        BaseLogger.log("3", null, null, "formNo key not exist in actionMap=" + existingForm);
                        actionMap.put(existingForm, new JSONArray().put((Object)action));
                    }
                }
                ++i;
            }
            BaseLogger.log("3", null, null, "Un formed actions=" + actionMap);
            if (actionMap.size() > 0) {
                for (Map.Entry map : actionMap.entrySet()) {
                    JSONObject sqlModelObj = new JSONObject();
                    sqlModelObj.put("form_no", map.getKey());
                    sqlModelObj.put("actions", map.getValue());
                    sqlModelObj.put("links", (Object)this.getUnusedLinkArray((String)map.getKey(), linkArray));
                    JSONObject sqlModel = new JSONObject();
                    sqlModel.put("sql_model", (Object)sqlModelObj);
                    sqlModels.put((Object)sqlModel);
                }
            }
            return sqlModels;
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getMaxFormActions=" + e.getMessage());
            BaseLogger.log("0", null, null, "Error in getMaxFormActions=" + e.getMessage());
            return new JSONArray();
        }
    }

    JSONArray getUnusedLinkArray(String formNo, JSONArray linkArray) {
        try {
            JSONArray resultLinkArray = new JSONArray();
            int i = 0;
            while (i < linkArray.length()) {
                JSONObject link = linkArray.getJSONObject(i);
                if (String.valueOf(link.getInt("form_no")).equals(formNo)) {
                    resultLinkArray.put((Object)link);
                }
                ++i;
            }
            return resultLinkArray;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getUnusedLinkArray()=" + e.getMessage());
            return new JSONArray();
        }
    }

    /*
     * Loose catch block
     */
    private JSONObject getObjBasicInfo(String objName, UserInfoBean userInfo, Connection conn) {
        String sql = "select TITLE,FORM_NO,DISP_METADATA FROM OBJ_FORMS  WHERE  WIN_NAME='w_" + objName.toLowerCase() + "'";
        BaseLogger.log("0", null, null, "getObjBasicInfo() SQL=" + sql);
        JSONObject sqlModels = new JSONObject();
        JSONArray basicDetails = new JSONArray();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                JSONObject jSONObject;
                ResultSet resultSet;
                Statement statement;
                block19: {
                    block18: {
                        statement = conn.createStatement();
                        resultSet = statement.executeQuery(sql);
                        while (resultSet.next()) {
                            JSONObject details = new JSONObject();
                            details.put("form_title", (Object)this.checkNull(resultSet.getString("TITLE")));
                            details.put("form_no", (Object)this.checkNull(resultSet.getString("FORM_NO")));
                            details.put("disp_metadata", (Object)this.checkNull(resultSet.getString("DISP_METADATA")));
                            details.put("form_descr", (Object)"");
                            basicDetails.put((Object)details);
                        }
                        sqlModels.put("sql_models", (Object)basicDetails);
                        jSONObject = sqlModels;
                        if (resultSet == null) break block18;
                        resultSet.close();
                    }
                    if (statement == null) break block19;
                    statement.close();
                }
                return jSONObject;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (statement != null) {
                                statement.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "SQLException in getObjBasicInfo: " + e.getMessage());
            return sqlModels;
        }
    }

    private JSONObject getPageDetailsJSON(String objName, UserInfoBean userInfo) {
        try {
            String pageDetails = new DBAccessEJB().getObjDetail(objName, "1", null, userInfo, "T");
            JSONObject pageDetailsObj = XML.toJSONObject((String)pageDetails);
            return pageDetailsObj;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getPageDetailsJSOn : " + e.getMessage());
            return new JSONObject();
        }
    }

    private String getXMLMetadataFileContent(UserInfoBean userInfo, String objName, String objContext, String pageContext) {
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            String transDB = userInfo.getTransDB();
            HashMap<String, String> propEditorInfoMap = new HashMap<String, String>();
            if (userInfo != null) {
                propEditorInfoMap.put("PROFILE_ID_RES", userInfo.getProfileIdRes());
                propEditorInfoMap.put("ENTERPRISE_ID_RES", userInfo.getEnterprise());
                propEditorInfoMap.put("USER_ID", this.checkNull(userInfo.getLoginCode()));
                propEditorInfoMap.put("PROFILE_ID", this.checkNull(userInfo.getProfileId()));
            }
            propEditorInfoMap.put("EDITOR", "WebEditor");
            String filePath = genericUtility.getMetaDataFilePath(objName, objContext, pageContext, "", propEditorInfoMap, transDB);
            BaseLogger.log("3", null, null, "getXMLMetadataFileContent() FilePath=" + filePath);
            File metadataFile = new File(filePath);
            String xmlString = this.readFile(metadataFile);
            return xmlString;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getXMLMetadataFileContent: " + e.getMessage());
            return "";
        }
    }

    private JSONArray getPageColumnMetadata(String xmlData, String objName, String formNo, UserInfoBean userInfo) {
        try {
            JSONArray columnArray = new JSONArray();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(xmlData.getBytes()));
            NodeList columnObjectList = doc.getElementsByTagName("ColumnObject");
            NodeList textObjectList = doc.getElementsByTagName("TextObject");
            Map<String, String> labelMap = this.getLabelMap(textObjectList);
            NodeList groupboxObjectList = doc.getElementsByTagName("GroupBox");
            JSONArray groupArray = this.getGroupBoxArray(groupboxObjectList);
            NodeList tableColumnList = doc.getElementsByTagName("table_column");
            Map<String, JSONObject> tableColumnObjectWithValue = this.getValueTableColumn(tableColumnList);
            int i = 0;
            while (i < columnObjectList.getLength()) {
                JSONObject itemChange;
                Element columnObject = (Element)columnObjectList.item(i);
                JSONObject column = new JSONObject();
                column.put("col_id", (Object)this.checkNull(this.getElementValue(columnObject, "id")));
                column.put("width", (Object)this.checkNull(this.getElementValue(columnObject, "width")));
                String name = this.checkNull(this.getElementValue(columnObject, "name"));
                column.put("name", (Object)name);
                JSONObject lookup = this.getLookupInfo(objName, name, userInfo);
                if (lookup.length() != 0) {
                    column.put("lookup", (Object)lookup);
                }
                if ((itemChange = this.getItemChangeInfo(objName, name, formNo, userInfo)).length() != 0) {
                    column.put("item_change", (Object)itemChange);
                }
                String dbName = this.checkNull(this.getTagValueByColumnName(tableColumnList, name, "dbname"));
                column.put("db_name", (Object)dbName);
                String initial = this.checkNull(this.getTagValueByColumnName(tableColumnList, name, "initial"));
                if (initial != null && initial.length() > 0) {
                    column.put("default_value", (Object)initial);
                }
                String tableName = dbName.replaceAll("\\..*$", "");
                column.put("table_name", (Object)tableName);
                String tableDisplayName = this.checkNull(labelMap.get(name));
                column.put("table_display_name", (Object)tableDisplayName);
                column.put("heading", (Object)tableDisplayName);
                column.put("descr", (Object)tableDisplayName);
                String hidden = this.checkNull(this.getElementValue(columnObject, "visible"));
                String invertedValue = "1".equals(hidden) ? "0" : "1";
                column.put("hidden", (Object)invertedValue);
                String Key2 = this.getTagValueByColumnName(tableColumnList, name, "key");
                column.put("key", (Object)("yes".equalsIgnoreCase(Key2) ? "true" : "false"));
                column.put("tabsequence", (Object)this.checkNull(this.getElementValue(columnObject, "tabsequence")));
                column.put("x", (Object)this.checkNull(this.getElementValue(columnObject, "x")));
                column.put("y", (Object)this.checkNull(this.getElementValue(columnObject, "y")));
                column.put("format", (Object)this.checkNull(this.getElementValue(columnObject, "format")));
                BaseLogger.log("3", userInfo, null, "table column name " + name);
                Element editStyle = (Element)columnObject.getElementsByTagName("EditStyle").item(0);
                JSONObject editMask = new JSONObject();
                if (editStyle != null) {
                    String style = this.checkNull(editStyle.getAttribute("style"));
                    editMask.put("mask", (Object)style);
                    String required = this.checkNull(this.getElementValue(editStyle, "required"));
                    required = required.equals("") ? "false" : "true";
                    column.put("mandatory", (Object)required);
                }
                String x = this.checkNull(this.getElementValue(columnObject, "x"));
                String y = this.checkNull(this.getElementValue(columnObject, "y"));
                String group = this.checkNull(this.findGroup(x, y, groupArray));
                column.put("group_name", (Object)group);
                if (tableColumnObjectWithValue.containsKey(name)) {
                    JSONObject obj = tableColumnObjectWithValue.get(name);
                    Iterator keys = obj.keys();
                    JSONObject values = new JSONObject();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        if ("data_type".equalsIgnoreCase(key)) {
                            column.put("col_type", obj.get(key));
                            continue;
                        }
                        if ("size".equalsIgnoreCase(key)) {
                            column.put("db_size", obj.get(key));
                            continue;
                        }
                        if (!"values".equalsIgnoreCase(key)) continue;
                        editMask.put(key, obj.get(key));
                    }
                }
                column.put("edit_mask", (Object)editMask);
                column.put("alignment", (Object)this.checkNull(this.getElementValue(columnObject, "alignment")));
                JSONObject columnObj = new JSONObject();
                columnObj.put("column", (Object)column);
                columnArray.put((Object)columnObj);
                ++i;
            }
            return columnArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaseLogger.log("3", userInfo, null, "Error in getting JSON");
            BaseLogger.log("3", userInfo, null, "Error in getting JSON" + e.getMessage());
            BaseLogger.log("3", userInfo, null, "Error in getting JSON" + e);
            return new JSONArray();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getLookupInfo(String objName, String fieldName, UserInfoBean userInfo) {
        JSONObject lookupJson = new JSONObject();
        String sql = "SELECT DATA_MODEL_NAME, SQL_INPUT, POPHELP_SOURCE FROM POPHELP WHERE mod_name = 'W_" + objName.toUpperCase() + "' AND field_name = '" + fieldName.toUpperCase() + "'";
        ConnDriver connDriver = new ConnDriver();
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                Connection conn = connDriver.getConnectDB(userInfo.getTransDB());
                try {
                    block21: {
                        Statement statement = conn.createStatement();
                        try {
                            try (ResultSet resultSet = statement.executeQuery(sql);){
                                while (resultSet.next()) {
                                    String dataModel = this.checkNull(resultSet.getString("DATA_MODEL_NAME"));
                                    lookupJson.put("model_name", (Object)dataModel);
                                    String lookupType = dataModel.equals("") ? "sql" : "datamodel";
                                    lookupJson.put("lookup_type", (Object)lookupType);
                                    lookupJson.put("input", (Object)this.checkNull(resultSet.getString("SQL_INPUT")));
                                    String cacheOption = this.checkNull(resultSet.getString("POPHELP_SOURCE")).equals("") ? "C" : "S";
                                    lookupJson.put("cache_option", (Object)cacheOption);
                                }
                            }
                            if (statement == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (statement == null) throw throwable;
                            statement.close();
                            throw throwable;
                        }
                        statement.close();
                    }
                    if (conn == null) return lookupJson;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return lookupJson;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "SQLException in getLookupInfo: " + e.getMessage());
            return new JSONObject();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getItemChangeInfo(String objName, String fieldName, String formNo, UserInfoBean userInfo) {
        JSONObject itemChangeJson = new JSONObject();
        String sql = "SELECT EXEC_AT,MANDATORY,JS_ARG FROM OBJ_ITEMCHANGE WHERE OBJ_NAME='" + objName + "' AND FIELD_NAME='" + fieldName + "'";
        ConnDriver connDriver = new ConnDriver();
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try {
                Connection conn = connDriver.getConnectDB(userInfo.getTransDB());
                try {
                    block21: {
                        Statement statement = conn.createStatement();
                        try {
                            try (ResultSet resultSet = statement.executeQuery(sql);){
                                while (resultSet.next()) {
                                    String exeAt = this.checkNull(resultSet.getString("EXEC_AT"));
                                    String exe = exeAt.equalsIgnoreCase("L") ? "local" : "server";
                                    itemChangeJson.put("itemchange_type", (Object)exe);
                                    itemChangeJson.put("js_arg", (Object)this.checkNull(resultSet.getString("JS_ARG")));
                                    String mandatory = this.checkNull(resultSet.getString("MANDATORY"));
                                    itemChangeJson.put("mandatory_server", (Object)(mandatory.equalsIgnoreCase("Y") ? "Yes" : "No"));
                                    itemChangeJson.put("local_file_name", (Object)(String.valueOf(objName) + "~" + formNo + "~" + fieldName + ".js"));
                                }
                            }
                            if (statement == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (statement == null) throw throwable;
                            statement.close();
                            throw throwable;
                        }
                        statement.close();
                    }
                    if (conn == null) return itemChangeJson;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return itemChangeJson;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "SQLException in getItemChangeInfo: " + e.getMessage());
            return new JSONObject();
        }
    }

    public String getTagValueByColumnName(NodeList nodeList, String columnName, String returnTagName) {
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element;
            String nameTagValue;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && (nameTagValue = (element = (Element)node).getElementsByTagName("name").item(0).getTextContent()).equals(columnName)) {
                NodeList returnTagList = element.getElementsByTagName(returnTagName);
                if (returnTagList.getLength() > 0) {
                    return returnTagList.item(0).getTextContent();
                }
                return "";
            }
            ++i;
        }
        return "";
    }

    private JSONArray getActions(JSONArray actionArray, String objName, String targetFormNo, UserInfoBean userInfo) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection conn = new ConnDriver().getConnectDB(userInfo.getTransDB());){
                JSONArray actions = new JSONArray();
                int i = 0;
                while (i < actionArray.length()) {
                    JSONObject action = actionArray.getJSONObject(i);
                    if (action.getInt("formNo") == Integer.parseInt(targetFormNo)) {
                        Object serviceCodeValue;
                        if (action.has("def_NoData")) {
                            action.put("def_no_data", action.get("def_NoData"));
                            action.remove("def_NoData");
                        }
                        if (action.has("multiRowOpt")) {
                            action.put("multi_row_opt", action.get("multiRowOpt"));
                            action.remove("multiRowOpt");
                        }
                        if (action.has("showInPanel")) {
                            action.put("show_in_panel", action.get("showInPanel"));
                            action.remove("showInPanel");
                        }
                        if (action.has("title")) {
                            action.put("js_arg", (Object)this.getJSArgsForAction((String)action.get("title"), objName, targetFormNo, conn));
                        }
                        if (action.has("service_code") && (serviceCodeValue = action.get("service_code")) instanceof JSONObject) {
                            JSONObject serviceCodeObj = (JSONObject)serviceCodeValue;
                            if (serviceCodeObj.has("argVal")) {
                                serviceCodeObj.put("arg_val", serviceCodeObj.get("argVal"));
                                serviceCodeObj.remove("argVal");
                            }
                            if (serviceCodeObj.has("cmpName")) {
                                serviceCodeObj.put("cmp_name", serviceCodeObj.get("cmpName"));
                                serviceCodeObj.remove("cmpName");
                            }
                            if (serviceCodeObj.has("cmpType")) {
                                serviceCodeObj.put("cmp_type", serviceCodeObj.get("cmpType"));
                                serviceCodeObj.remove("cmpType");
                            }
                            if (serviceCodeObj.has("metName")) {
                                serviceCodeObj.put("met_name", serviceCodeObj.get("metName"));
                                serviceCodeObj.remove("metName");
                            }
                            action.put("service_code", (Object)serviceCodeObj);
                        }
                        actions.put((Object)action);
                    }
                    ++i;
                }
                return actions;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getActions : " + e.getMessage());
            return new JSONArray();
        }
    }

    private String getJSArgsForAction(String title, String objName, String formNo, Connection conn) {
        String jsArgs = "";
        String sql = "SELECT JS_ARG FROM OBJ_ITEMCHANGE WHERE OBJ_NAME=? AND FORM_NO=? AND FIELD_NAME=?";
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setString(1, objName);
                pstmt.setString(2, formNo);
                pstmt.setString(3, title);
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        jsArgs = rs.getString("JS_ARG");
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsArgs;
    }

    private JSONArray getLinks(JSONObject pageDetails, String formNo) {
        try {
            JSONObject transactionObj;
            JSONObject rootObj;
            JSONArray linkArray = new JSONArray();
            if (pageDetails.has("ROOT") && (rootObj = pageDetails.getJSONObject("ROOT")).has("Transaction") && (transactionObj = rootObj.getJSONObject("Transaction")).has("Form")) {
                Object form = transactionObj.get("Form");
                JSONArray formsArray = new JSONArray();
                if (form instanceof JSONObject) {
                    JSONObject formObj = transactionObj.getJSONObject("Form");
                    formsArray.put((Object)formObj);
                } else if (form instanceof JSONArray) {
                    formsArray = transactionObj.getJSONArray("Form");
                }
                int i = 0;
                while (i < formsArray.length()) {
                    int no;
                    JSONObject formObj = formsArray.getJSONObject(i);
                    if (formObj.has("no") && (no = formObj.getInt("no")) == Integer.parseInt(formNo) && formObj.has("Links")) {
                        Object linksObj = formObj.get("Links");
                        if (linksObj instanceof JSONObject) {
                            BaseLogger.log("3", null, null, "Links is JSONObject");
                            JSONObject linksJson = formObj.getJSONObject("Links");
                            if (linksJson.has("Link")) {
                                Object link = linksJson.get("Link");
                                if (link instanceof JSONObject) {
                                    JSONObject linkJson = linksJson.getJSONObject("Link");
                                    linkArray.put((Object)linkJson);
                                } else if (link instanceof JSONArray) {
                                    linkArray = linksJson.getJSONArray("Link");
                                }
                            }
                        } else if (linksObj instanceof JSONObject) {
                            BaseLogger.log("3", null, null, "Links is JSONArray");
                            linkArray = formObj.getJSONArray("Links");
                        }
                    }
                    ++i;
                }
            }
            int i = 0;
            while (i < linkArray.length()) {
                JSONObject linkObj = linkArray.getJSONObject(i);
                if (linkObj.has("RecordSpecific")) {
                    linkObj.put("record_specific", linkObj.get("RecordSpecific"));
                    linkObj.remove("RecordSpecific");
                }
                if (linkObj.has("fieldName")) {
                    linkObj.put("field_name", linkObj.get("fieldName"));
                    linkObj.remove("fieldName");
                }
                if (linkObj.has("ShowInPanel")) {
                    linkObj.put("show_in_panel", linkObj.get("ShowInPanel"));
                    linkObj.remove("ShowInPanel");
                }
                if (linkObj.has("Image")) {
                    linkObj.put("image", linkObj.get("Image"));
                    linkObj.remove("Image");
                }
                if (linkObj.has("TargetObject")) {
                    linkObj.put("target_object", linkObj.get("TargetObject"));
                    linkObj.remove("TargetObject");
                }
                if (linkObj.has("DisplayMode")) {
                    linkObj.put("display_mode", linkObj.get("DisplayMode"));
                    linkObj.remove("DisplayMode");
                }
                if (linkObj.has("ShortcutChar")) {
                    linkObj.put("shortcut_char", linkObj.get("ShortcutChar"));
                    linkObj.remove("ShortcutChar");
                }
                if (linkObj.has("UpdateFlag")) {
                    linkObj.put("update_flag", linkObj.get("UpdateFlag"));
                    linkObj.remove("UpdateFlag");
                }
                if (linkObj.has("RightsChar")) {
                    linkObj.put("rights_char", linkObj.get("RightsChar"));
                    linkObj.remove("RightsChar");
                }
                if (linkObj.has("linkId")) {
                    linkObj.put("link_id", linkObj.get("linkId"));
                    linkObj.remove("linkId");
                }
                if (linkObj.has("LinkUri")) {
                    linkObj.put("link_uri", linkObj.get("LinkUri"));
                    linkObj.remove("LinkUri");
                }
                if (linkObj.has("AutoInvoke")) {
                    linkObj.put("auto_invoke", linkObj.get("AutoInvoke"));
                    linkObj.remove("AutoInvoke");
                }
                if (linkObj.has("formNo")) {
                    linkObj.put("form_no", linkObj.get("formNo"));
                    linkObj.remove("formNo");
                }
                if (linkObj.has("LinkArg")) {
                    linkObj.put("link_arg", linkObj.get("LinkArg"));
                    linkObj.remove("LinkArg");
                }
                if (linkObj.has("LinkForm")) {
                    linkObj.put("link_form", linkObj.get("LinkForm"));
                    linkObj.remove("LinkForm");
                }
                if (linkObj.has("LinkType")) {
                    linkObj.put("link_type", linkObj.get("LinkType"));
                    linkObj.remove("LinkType");
                }
                if (linkObj.has("ShowConfirm")) {
                    linkObj.put("show_confirm", linkObj.get("ShowConfirm"));
                    linkObj.remove("ShowConfirm");
                }
                if (linkObj.has("LineNo")) {
                    linkObj.put("line_no", linkObj.get("LineNo"));
                    linkObj.remove("LineNo");
                }
                if (linkObj.has("LinkTitle")) {
                    linkObj.put("link_title", linkObj.get("LinkTitle"));
                    linkObj.remove("LinkTitle");
                }
                linkArray.put(i, (Object)linkObj);
                ++i;
            }
            return linkArray;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getLinks : " + e.getMessage());
            return new JSONArray();
        }
    }

    String getPageDetailsXML(String objName, UserInfoBean userInfo) {
        try {
            return new DBAccessEJB().getObjDetail(objName, "1", null, userInfo, "T");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getPageDetailsXML : " + e.getMessage());
            return "";
        }
    }

    private JSONObject getPageDetailsJSON(String pageDetails) {
        try {
            BaseLogger.log("3", null, null, "PageDetails XML object= " + pageDetails);
            JSONObject pageDetailsObj = XML.toJSONObject((String)pageDetails);
            return pageDetailsObj;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getPageDetailsJSOn : " + e.getMessage());
            return new JSONObject();
        }
    }

    private JSONObject getFormFormalArgs(JSONObject pageDetails, String formName, String objName) {
        try {
            JSONObject jsonObject = new JSONObject();
            BaseLogger.log("3", null, null, "GOt Pagedetails for formal args JSON=" + pageDetails);
            jsonObject.put("form_title", (Object)("Search in " + formName));
            JSONArray formalArgsArray = new JSONArray();
            if (pageDetails.has("ROOT")) {
                BaseLogger.log("3", null, null, "Got Root object");
                JSONObject root = pageDetails.getJSONObject("ROOT");
                if (root.has("Transaction")) {
                    BaseLogger.log("3", null, null, "Got Transaction object");
                    JSONObject transaction = root.getJSONObject("Transaction");
                    BaseLogger.log("3", null, null, "Got Transaction object" + transaction);
                    if (transaction.has("FORMALARGS")) {
                        BaseLogger.log("3", null, null, "Got FORMALARGS object");
                        JSONObject formalArgs = transaction.getJSONObject("FORMALARGS");
                        if (formalArgs.has("FORMALARG")) {
                            BaseLogger.log("3", null, null, "Got FORMALARGS object");
                            Object formalArgsObj = formalArgs.get("FORMALARG");
                            BaseLogger.log("3", null, null, "Got FORMALARG object" + formalArgsObj.toString());
                            if (formalArgsObj instanceof JSONObject) {
                                BaseLogger.log("3", null, null, "Got FORMALARG object");
                                JSONObject fmargs = formalArgs.getJSONObject("FORMALARG");
                                formalArgsArray.put((Object)fmargs);
                            }
                            if (formalArgsObj instanceof JSONArray) {
                                formalArgsArray = formalArgs.getJSONArray("FORMALARG");
                            }
                        }
                    }
                }
            }
            int y = 10;
            JSONArray columnArray = new JSONArray();
            int i = 0;
            while (i < formalArgsArray.length()) {
                JSONObject obj = formalArgsArray.getJSONObject(i);
                JSONObject column = new JSONObject();
                column.put("name", obj.get("field_name"));
                column.put("db_name", (Object)"");
                column.put("table_name", (Object)"");
                column.put("table_display_name", obj.get("field_name"));
                column.put("hidden", (Object)"0");
                column.put("col_type", obj.get("javatype"));
                column.put("db_size", (Object)"");
                column.put("heading", (Object)"");
                column.put("descr", (Object)"");
                column.put("format", obj.get("javatype"));
                column.put("default_function", (Object)"");
                column.put("default_value", obj.get("value"));
                column.put("expression", (Object)"");
                column.put("key", true);
                JSONObject editMask = new JSONObject();
                editMask.put("mask", (Object)"edit");
                column.put("edit_mask", (Object)editMask);
                column.put("protect", obj.get("protect"));
                column.put("mandatory", false);
                column.put("validations", (Object)"");
                column.put("x", (Object)"");
                column.put("y", (Object)("" + y));
                column.put("tabsequence", y += 10);
                column.put("item_change", (Object)"");
                column.put("lookup", (Object)"");
                column.put("group_name", (Object)"");
                JSONObject columnObj = new JSONObject();
                columnObj.put("column", (Object)column);
                columnArray.put((Object)columnObj);
                BaseLogger.log("3", null, null, "GOt Pagedetails for formal args name=" + obj.get("name"));
                ++i;
            }
            if (columnArray.length() > 0) {
                jsonObject.put("columns", (Object)columnArray);
            }
            return jsonObject;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getFormalArgs : " + e.getMessage());
            return new JSONObject();
        }
    }

    private JSONArray getReportColumnsArray(JSONObject xsdJSON, String objName, UserInfoBean userInfo) {
        JSONArray columnArray = new JSONArray();
        BaseLogger.log("3", null, null, "argument creating Array of json= " + xsdJSON);
        try {
            JSONObject argumentsObj = xsdJSON.getJSONObject("arguments");
            Object argumentObj = argumentsObj.get("argument");
            if (argumentObj instanceof JSONArray) {
                BaseLogger.log("3", null, null, "argument is Array");
                JSONArray argumentArray = (JSONArray)argumentObj;
                int tabSequence = 10;
                int xVal = 10;
                int yVal = 10;
                int i = 0;
                while (i < argumentArray.length()) {
                    JSONObject argObj = argumentArray.getJSONObject(i);
                    BaseLogger.log("3", null, null, "argument value=" + argObj);
                    JSONObject column = new JSONObject();
                    column.put("tabsequence", (Object)String.valueOf(tabSequence));
                    tabSequence += 10;
                    String visible = argObj.getJSONObject("attrib").getString("@visible");
                    int hidden = visible.equalsIgnoreCase("Y") ? 0 : 1;
                    column.put("hidden", hidden);
                    String format = argObj.getJSONObject("attrib").getString("@type");
                    String[] parts = format.split("\\.");
                    String formatVal = parts[parts.length - 1];
                    column.put("format", (Object)("[" + formatVal + "]"));
                    column.put("col_type", (Object)format);
                    column.put("mandatory", (Object)"false");
                    String displayLabel = argObj.getJSONObject("attrib").getString("@label");
                    column.put("table_display_name", (Object)displayLabel);
                    column.put("heading", (Object)displayLabel);
                    column.put("descr", (Object)"");
                    JSONObject editMask = new JSONObject();
                    editMask.put("mask", (Object)"edit");
                    column.put("edit_mask", (Object)editMask);
                    column.put("x", (Object)String.valueOf(xVal));
                    xVal += xVal;
                    column.put("y", (Object)String.valueOf(yVal));
                    yVal += yVal;
                    String name = argObj.getJSONObject("attrib").getString("@name");
                    column.put("name", (Object)name);
                    JSONObject lookupJson = this.getLookupInfo(objName, name, userInfo);
                    if (lookupJson.length() != 0) {
                        column.put("lookup", (Object)lookupJson);
                    }
                    String limit = argObj.getJSONObject("attrib").getString("@size");
                    column.put("db_size", (Object)limit);
                    column.put("group_name", (Object)"");
                    column.put("table_name", (Object)"");
                    column.put("db_name", (Object)"");
                    column.put("key", (Object)"");
                    JSONObject columnObj = new JSONObject();
                    columnObj.put("column", (Object)column);
                    columnArray.put((Object)columnObj);
                    ++i;
                }
            } else if (argumentObj instanceof JSONObject) {
                BaseLogger.log("3", null, null, "argument is JSONOBJECT");
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Error in getting column list" + e.getMessage());
        }
        return columnArray;
    }

    /*
     * Exception decompiling
     */
    public JSONArray getObjFormItmChange(String objName, String formNo, UserInfoBean userInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String forgotPassword(String userCode, String appId, String code, String password, HttpServletResponse response, HttpServletRequest request, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String status;
        String result;
        block25: {
            String dataFormat;
            String params;
            block24: {
                BaseLogger.log("3", null, null, "Inside forgotPassword ");
                result = "";
                params = "";
                status = "error";
                dataFormat = "JSON";
                boolean isError = false;
                e12ExtServiceUtility = new E12ExtServiceUtility();
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                APIUtility apiUtility = new APIUtility();
                userInfo = null;
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                try {
                    try {
                        if (!(isError || userCode != null && userCode.length() != 0)) {
                            status = "Reject";
                            result = "Blank user code passed.";
                            isError = true;
                        }
                        if (userInfo == null) {
                            userInfo = commonDBAccessEJB.createUserInfo(userCode);
                        }
                        BaseLogger.log("3", null, null, "forgotPassword() userInfo=" + userInfo);
                        if (!isError && userInfo == null) {
                            status = "Reject";
                            result = "User not allowed.";
                            isError = true;
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            status = "Reject";
                            result = "Blank APPID passed.";
                            isError = true;
                        }
                        BaseLogger.log("3", null, null, "forgotPassword() appId=" + this.checkNull(appId));
                        params = request.getQueryString();
                        BaseLogger.log("3", null, null, "forgotPassword() request.getQueryString() " + request.getQueryString());
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("&USER_CODE=" + userCode);
                            paramString.append("&APP_ID=" + appId);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "forgotPassword() params=" + params);
                        if (!isError && !appId.equals("FLUTTERAPP")) {
                            BaseLogger.log("3", null, null, "forgotPassword() none flutter APP");
                            ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("forgotPassword", appId);
                            if (authAppAPIBean == null) {
                                status = "Reject";
                                result = "This service not available for given APPID";
                                isError = true;
                                BaseLogger.log("3", null, null, "forgotPassword() none flutter result=" + result);
                            }
                        }
                        if (isError) break block24;
                        String clientIP = "";
                        if (this.checkNull(code).equals("") && this.checkNull(password).equals("")) {
                            String empStatus = this.getCommonDBAccess().checkEmpStatus(userCode);
                            Date empDeactDate = this.getCommonDBAccess().checkEmpDeactDate(userCode);
                            BaseLogger.log("3", null, null, "forgotPassword() empStatus=" + empStatus);
                            BaseLogger.log("3", null, null, "forgotPassword() empDeactDate=" + empDeactDate);
                            Date currentDate = new Date();
                            if ("".equals(empStatus) || "A".equalsIgnoreCase(empStatus)) {
                                if (empDeactDate != null && empDeactDate.before(currentDate)) {
                                    result = ibase.servlet.Messages.getString("AuthenticateServlet_notAnActiveUser", this.getUserLangAndCountry(userCode));
                                    status = "error";
                                    break block24;
                                }
                                DBAccessEJB dbAccessEJB = new DBAccessEJB();
                                String condition = " CODE = '" + userCode + "' ";
                                BaseLogger.log("3", null, null, "forgotPassword() condition=" + condition);
                                String emailId = dbAccessEJB.getDBColumnValue("USERS", "EMAIL_ID", condition);
                                BaseLogger.log("3", null, null, "forgotPassword() emailId=" + emailId);
                                dbAccessEJB = null;
                                clientIP = this.checkNull(request.getRemoteAddr());
                                clientIP = clientIP.length() > 0 ? clientIP : "SYSTEM";
                                BaseLogger.log("3", null, null, "forgotPassword() clientIP=" + clientIP);
                                if (this.checkNull(emailId).length() <= 0) {
                                    result = "Email Id Not Found !";
                                    status = "error";
                                    break block24;
                                }
                                String varCode = this.getCommonDBAccess().sendVarificationCode(userCode);
                                if (varCode != null) {
                                    try {
                                        BaseLogger.log("3", null, null, "forgotPassword() transdb =" + userInfo.getTransDB());
                                        this.getCommonDBAccess().updateVerfCode(varCode, userCode);
                                        BaseLogger.log("3", null, null, "forgotPassword() store ver code =");
                                    }
                                    catch (Exception e) {
                                        BaseLogger.log("3", null, null, "forgotPassword() ERROR IN STORING VER CODE=" + e.getMessage());
                                    }
                                }
                                result = "Verification Code send success";
                                status = "success";
                                break block24;
                            }
                            result = ibase.servlet.Messages.getString("AuthenticateServlet_pleaseEnterValidUser", this.getUserLangAndCountry(userCode));
                            status = "error";
                            break block24;
                        }
                        if (this.checkNull(code).length() > 0 && this.checkNull(password).length() > 0) {
                            String serverVerCode = commonDBAccessEJB.getDBColumnValue("USERS", "VER_CODE", " WHERE CODE = '" + userCode + "'", "Driver");
                            boolean updatePass = false;
                            if (serverVerCode.equals(code)) {
                                try {
                                    this.getCommonDBAccess().updatePassword(userCode, password, "", "", "0", userInfo, clientIP, "");
                                    updatePass = true;
                                }
                                catch (Exception e) {
                                    BaseLogger.log("3", null, null, "forgotPassword() error in updating password =" + e.getMessage());
                                    updatePass = false;
                                }
                                if (updatePass) {
                                    result = "Code verified success";
                                    status = "success";
                                } else {
                                    result = "Password not changed";
                                    status = "failed";
                                }
                                break block24;
                            }
                            result = "You are entered wrong verification code.";
                            status = "failed";
                            break block24;
                        }
                        result = "Please enter all values.";
                        status = "failed";
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : forgotPassword : " + e.getMessage());
                        result = this.getStackTrace(e, dataFormat);
                        status = "exception";
                        result = e12ExtServiceUtility.generateResponse(request, "forgotPassword", params, "", dataFormat, status, result);
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    result = e12ExtServiceUtility.generateResponse(request, "forgotPassword", params, "", dataFormat, status, result);
                    throw throwable;
                }
            }
            result = e12ExtServiceUtility.generateResponse(request, "forgotPassword", params, "", dataFormat, status, result);
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/forgotPassword )", status, result, appId, request, userInfo);
        return result;
    }

    private boolean storeVerificationCode(String verCode, UserInfoBean userInfo, Connection conn) {
        String sql = "UPDATE USERS SET ver_code = ? WHERE code = ?";
        BaseLogger.log("0", null, null, "storeVerificationCode :SQL " + sql);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setString(1, verCode);
                pstmt.setString(2, userInfo.getLoginCode());
                int rowsUpdated = pstmt.executeUpdate();
                boolean bl = rowsUpdated > 0;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : storeVerificationCode : " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean storeUserPassword(String password, UserInfoBean userInfo, Connection conn) {
        String sql = "UPDATE USERS SET ver_code = null, pass_wd=? WHERE code = ?";
        BaseLogger.log("0", null, null, "storeVerificationCode :SQL " + sql);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                pstmt.setString(1, password);
                pstmt.setString(2, userInfo.getLoginCode());
                int rowsUpdated = pstmt.executeUpdate();
                boolean bl = rowsUpdated > 0;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : storeVerificationCode : " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private ArrayList<String> getUserLangAndCountry(String userCode) {
        ArrayList<String> langAndCountryList = new ArrayList<String>();
        try {
            String userLanguage = this.getCommonDBAccess().getDBColumnValue("USERS", "USER_LANG", "WHERE CODE = '" + userCode + "'");
            String userCountry = this.getCommonDBAccess().getDBColumnValue("USERS", "USER_COUNTRY", "WHERE CODE = '" + userCode + "'");
            if (userLanguage != null && userCountry != null) {
                langAndCountryList.add(userLanguage);
                langAndCountryList.add(userCountry);
            }
            BaseLogger.log("3", null, null, "User Language[" + userLanguage + "], User Country[" + userCountry + "], List[" + langAndCountryList.toString() + "]");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :: while accessing user country and user language from database. ");
            e.printStackTrace();
        }
        return langAndCountryList;
    }

    public String getOfflinejs(String objName, String jsType, HttpServletRequest request, HttpServletResponse response, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block51: {
            Connection conn;
            String dataFormat;
            String tokenId;
            String params;
            block50: {
                BaseLogger.log("3", null, null, "Inside getOfflinejs ");
                result = "";
                params = "";
                status = "error";
                tokenId = "";
                dataFormat = "JSON";
                appId = "";
                conn = null;
                boolean isError = false;
                e12ExtServiceUtility = new E12ExtServiceUtility();
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                APIUtility apiUtility = new APIUtility();
                userInfo = null;
                try {
                    try {
                        tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                        BaseLogger.log("3", null, null, "getOfflinejs() TOKENID length=" + tokenId.length());
                        if (tokenId.length() == 0) {
                            status = "Reject";
                            result = "Blank Token ID passed.";
                            isError = true;
                            BaseLogger.log("3", null, null, "getOfflinejs() TOKENID length return error" + tokenId.length());
                        }
                        if (!isError) {
                            userInfo = this.getUserInfo(request, tokenId);
                        }
                        if (!isError && userInfo == null) {
                            status = "Reject";
                            result = "User not allowed.";
                            isError = true;
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            appId = apiUtility.getAppIdFromJWTToken(tokenId);
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            status = "Reject";
                            result = "Blank APPID passed.";
                            isError = true;
                        }
                        BaseLogger.log("3", null, null, "getOfflinejs() appId=" + appId);
                        params = request.getQueryString();
                        BaseLogger.log("3", null, null, "getOfflinejs() request.getQueryString() " + request.getQueryString());
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("&TOKEN_ID=" + tokenId);
                            paramString.append("&OBJ_NAME=" + objName);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "getOfflinejs() params=" + params);
                        if (!isError && !appId.equals("FLUTTERAPP")) {
                            BaseLogger.log("3", null, null, "getOfflinejs() none flutter APP");
                            Object authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getOfflinejs", appId);
                            if (authAppAPIBean == null) {
                                status = "Reject";
                                result = "This service not available for given APPID";
                                isError = true;
                                BaseLogger.log("3", null, null, "getOfflinejs() none flutter result=" + result);
                            } else {
                                result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getOfflinejs");
                                BaseLogger.log("3", null, null, "getOfflinejs() result=" + result);
                                if ("valid".equalsIgnoreCase(result)) {
                                    if (apiUtility.checkDailyAPILimit(userInfo)) {
                                        status = "Reject";
                                        result = "Daily API call limit exceeded";
                                        isError = true;
                                        BaseLogger.log("3", null, null, "getOfflinejs() none flutter validation result=" + result);
                                    }
                                } else {
                                    status = "Reject";
                                    isError = true;
                                }
                            }
                        }
                        if (isError) break block50;
                        switch (jsType) {
                            case "itm_change": {
                                result = this.getItmChange(objName, "itm_change", userInfo);
                                status = "Success";
                                break;
                            }
                            case "validation": {
                                result = this.getItmChange(objName, "validation", userInfo);
                                status = "Success";
                                break;
                            }
                            case "action": {
                                result = this.getItmChange(objName, "action", userInfo);
                                status = "Success";
                                break;
                            }
                            case "summary": {
                                result = this.getItmChange(objName, "summary", userInfo);
                                status = "Success";
                                break;
                            }
                            default: {
                                result = "Unknown File Type";
                                status = "error";
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : getOfflinejs : " + e.getMessage());
                        result = this.getStackTrace(e, dataFormat);
                        status = "exception";
                        if (tokenId.length() != 0 && userInfo == null) {
                            JSONObject resultObj = new JSONObject();
                            try {
                                resultObj.put("data", (Object)new JSONObject());
                                resultObj.put("error", (Object)"Invalid TOKEN");
                                resultObj.put("status", (Object)"Reject");
                                return resultObj.toString();
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                                return resultObj.toString();
                            }
                        }
                        result = this.generateResponse(request, "getOfflinejs", params, tokenId, dataFormat, status, result, userInfo);
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                            break block51;
                        }
                        catch (Exception resultObj) {}
                        break block51;
                    }
                }
                catch (Throwable throwable) {
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getOfflinejs", params, tokenId, dataFormat, status, result, userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (Exception resultObj) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getOfflinejs", params, tokenId, dataFormat, status, result, userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("(VisionOBJService/getOfflinejs)", status, result, appId, request, userInfo);
        return result;
    }

    private String getItmChange(String objName, String type, UserInfoBean userInfo) {
        try {
            String jsFolderPath;
            JSONArray fieldsArray;
            block27: {
                fieldsArray = new JSONArray();
                jsFolderPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "webitm" + File.separator + "js" + File.separator + "offlinejs";
                if (type.isEmpty()) break block27;
                switch (type) {
                    case "summary": 
                    case "action": 
                    case "itm_change": 
                    case "validation": {
                        jsFolderPath = String.valueOf(jsFolderPath) + File.separator + objName + File.separator + type;
                        break;
                    }
                }
            }
            JSONObject resultObj = new JSONObject();
            fieldsArray = new JSONArray();
            BaseLogger.log("3", null, null, "got folder path type : " + type);
            BaseLogger.log("3", null, null, "got folder path: " + jsFolderPath);
            File folder = new File(jsFolderPath);
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                File[] fileArray = listOfFiles;
                int n = listOfFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        String fileName = file.getName();
                        String filePath = file.getAbsolutePath();
                        BaseLogger.log("3", null, null, "got File: " + fileName);
                        BaseLogger.log("3", null, null, "got File Path: " + filePath);
                        String[] filedesc = fileName.split("~");
                        String fileObjName = filedesc[0];
                        BaseLogger.log("3", null, null, "got File OBJ: " + fileObjName);
                        BaseLogger.log("3", null, null, "want File OBJ:" + objName);
                        if (objName.equals(fileObjName)) {
                            JSONObject fieldObj = new JSONObject();
                            String fieldName = "";
                            String formNo = "";
                            BaseLogger.log("3", null, null, "want filedesc size:" + filedesc.length);
                            if (filedesc.length == 2) {
                                fieldName = filedesc[1];
                            } else if (filedesc.length == 3) {
                                fieldName = filedesc[2];
                                formNo = filedesc[1];
                            } else {
                                fieldName = "";
                            }
                            BaseLogger.log("3", null, null, "got Field  Name: " + fieldName);
                            fieldObj.put("field_name", (Object)fieldName.replace(".js", ""));
                            fieldObj.put("form_no", (Object)formNo);
                            String jsFilePath = "/ibase/webitm/js/offlinejs/" + objName + File.separator + type + File.separator + fileName;
                            fieldObj.put("js_file", (Object)jsFilePath);
                            fieldsArray.put((Object)fieldObj);
                        } else {
                            BaseLogger.log("3", null, null, "File OBJ not matched:" + objName);
                        }
                    } else if (file.isDirectory()) {
                        BaseLogger.log("3", null, null, "got Directory: " + file.getName());
                    }
                    ++n2;
                }
                resultObj.put("fields", (Object)fieldsArray);
            } else {
                BaseLogger.log("3", null, null, "The folder is empty or does not exist.");
                resultObj.put("fields", (Object)fieldsArray);
            }
            return resultObj.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getItmChange() : " + e.getMessage());
            return "";
        }
    }

    public String getAddData(String objName, String formNo, String objContext, String pkValues, String chgStr, String coreMdlId, int noOfForms, String editorId, HttpServletRequest request, HttpServletResponse response, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block39: {
            BaseLogger.log("3", null, null, "Inside getAddData ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            Connection conn = null;
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getAddData() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getAddData() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getAddData() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getAddData() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getAddData() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getAddData() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getAddData", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getAddData() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getAddData");
                            BaseLogger.log("3", null, null, "getAddData() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getAddData() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        if (coreMdlId == null || coreMdlId.equals(null) || coreMdlId.length() > 0) {
                            coreMdlId = editorId;
                        }
                        String editFlag = "A";
                        String argFieldValues = "";
                        HttpSession sess = request.getSession();
                        String reqParamStr = "";
                        String userId = userInfo.getLoginCode();
                        String action = "ADD";
                        String domId = "1";
                        String deafultEditor = "true";
                        editorId = String.valueOf(editorId) + userId;
                        String tempEditorID = this.getStatefulEditorId(editorId, userId);
                        String responseData = this.getDetailDataForBrowser(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, coreMdlId, reqParamStr, userId, action, domId, noOfForms, request, editorId, deafultEditor, userInfo);
                        BaseLogger.log("3", null, null, "getAddData()  result=" + result);
                        if (responseData.length() > 0) {
                            String event = "get_detail_data";
                            Date startTime = new Date();
                            UserEventLogEJB userEventLogEJB = new UserEventLogEJB();
                            userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action, event, startTime, new Date(), "pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues, "Success", "SA", "");
                            JSONObject jsonObject = XML.toJSONObject((String)responseData);
                            JSONObject detail1 = jsonObject.getJSONObject("DocumentRoot").getJSONObject("group0").getJSONObject("Header0").getJSONObject("Detail1");
                            result = new JSONObject().put("Detail1", (Object)detail1).toString();
                            status = "success";
                        } else {
                            result = new JSONObject().put("error", (Object)"No Data").toString();
                            status = "error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getAddData : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getAddData", params, tokenId, dataFormat, status, result, userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block39;
                    }
                    catch (Exception resultObj) {}
                    break block39;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getAddData", params, tokenId, dataFormat, status, result, userInfo);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception resultObj) {
                    // empty catch block
                }
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getAddData", params, tokenId, dataFormat, status, result, userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("getAddData ( VisionOBJService/getAddData )", status, result, appId, request, userInfo);
        return result;
    }

    protected String getDetailDataForBrowser(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String coreMdlId, String reqParamStr, String user, String action, String domID, int noOfForms, HttpServletRequest request, String editorId, String deafultEditor, UserInfoBean userInfo) throws ITMException {
        String retXMLStr = "";
        String plan_Date = "";
        String Cal_Comp = "";
        try {
            BaseLogger.log("3", null, null, "coreMdlId check session key= " + coreMdlId);
            BaseLogger.log("3", null, null, "coreMdlId from session value= " + sess.getAttribute(coreMdlId));
            BaseLogger.log("3", userInfo, editorId, "ITMTransactionCoreModel can not get from sess");
            ITMTransactionCoreModel itmTransCoreMdl = new ITMTransactionCoreModel();
            itmTransCoreMdl.setObjName(objName);
            itmTransCoreMdl.setUserInfo(userInfo);
            itmTransCoreMdl.setCoreModelId(Integer.parseInt(coreMdlId));
            itmTransCoreMdl.setEditFlag(editFlag);
            itmTransCoreMdl.setEditor(deafultEditor);
            ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel)sess.getAttribute("itmTransHdrMdl");
            if (itmTransHdrMdl != null) {
                itmTransCoreMdl.setITMFilterModel(itmTransHdrMdl.getITMFilterModel());
            }
            BaseLogger.log("3", userInfo, editorId, "coreMdlId = " + coreMdlId);
            itmTransCoreMdl.getMasterStateful().setEditorId(coreMdlId);
            itmTransCoreMdl.setCoreModelId(Integer.parseInt(coreMdlId));
            itmTransCoreMdl.setPKValues(pkValues);
            itmTransCoreMdl.setEditFlag(editFlag);
            itmTransCoreMdl.getMasterStateful().setPlanDate(plan_Date);
            itmTransCoreMdl.getMasterStateful().setCalComp(Cal_Comp);
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            if (transEditorCoreModel == null) {
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setMasterStateful(itmTransCoreMdl.getMasterStateful());
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            int cnt = 0;
            int pos = 0;
            int lastPos = 0;
            String xmlString = "";
            StringBuffer xmlStringBuff = new StringBuffer();
            if ("false".equalsIgnoreCase(deafultEditor)) {
                cnt = 1;
                while (cnt <= noOfForms) {
                    xmlString = !"V".equalsIgnoreCase(editFlag) ? this.checkNull(itmTransCoreMdl.getXMLData("" + cnt, "E", "1", reqParamStr)) : this.checkNull(itmTransCoreMdl.getXMLData("" + cnt, editFlag, "1", reqParamStr));
                    if (cnt == 1) {
                        xmlStringBuff = xmlStringBuff.append(xmlString);
                    } else if (!"".equalsIgnoreCase(xmlString) && (pos = xmlString.indexOf("<Detail")) != -1) {
                        lastPos = xmlString.lastIndexOf("</Header0>");
                        xmlString = xmlString.substring(pos, lastPos);
                        lastPos = xmlStringBuff.lastIndexOf("</Header0>");
                        xmlStringBuff.insert(lastPos, xmlString);
                    }
                    if (xmlStringBuff.indexOf("domID=\"\"") != -1) {
                        pos = xmlStringBuff.indexOf("domID=\"\"");
                        xmlStringBuff.insert(pos + 7, "1");
                    }
                    ++cnt;
                }
                xmlString = xmlStringBuff.toString();
            } else {
                if (reqParamStr != null && reqParamStr.trim().length() > 0) {
                    itmTransCoreMdl.getMasterStateful().setRequestParamStr(reqParamStr.trim());
                }
                xmlString = itmTransCoreMdl.getMasterStateful().getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
                BaseLogger.log("3", userInfo, editorId, "xmlString [" + xmlString + "]");
                itmTransCoreMdl.getMasterStateful().setRequestParamStr(null);
            }
            chgStr = this.checkNull(chgStr);
            BaseLogger.log("3", userInfo, editorId, "chgStr [" + chgStr + "]");
            if (chgStr.length() > 0) {
                xmlString = chgStr;
            }
            if (!"".equalsIgnoreCase(retXMLStr = xmlString) && masterRem != null) {
                itmTransCoreMdl.getMasterStateful().setData(retXMLStr);
                sess.setAttribute("CORE_MDL", (Object)coreMdlId);
                sess.setAttribute(coreMdlId, (Object)itmTransCoreMdl);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
                sess.setMaxInactiveInterval(300);
                BaseLogger.log("3", null, null, "First API - Setting attribute: " + coreMdlId + " | Value: " + itmTransCoreMdl);
                BaseLogger.log("3", null, null, "First API - Setting attribute: " + coreMdlId + " | Value: is null? " + (itmTransCoreMdl == null));
                BaseLogger.log("3", null, null, "First API - Setting attribute: " + editorId + " | Value: is null? " + (transEditorCoreModel == null));
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    protected String getDetailDataForBrowser_old(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String coreMdlId, String reqParamStr, String user, String action, String domID, int noOfForms, HttpServletRequest request, String editorId, String deafultEditor, UserInfoBean userInfo) throws ITMException {
        String retXMLStr = "";
        String plan_Date = "";
        String Cal_Comp = "";
        try {
            ITMTransactionCoreModel itmTransCoreMdl = null;
            if (itmTransCoreMdl == null) {
                BaseLogger.log("3", userInfo, editorId, "ITMTransactionCoreModel can not get from sess");
                itmTransCoreMdl = new ITMTransactionCoreModel();
                itmTransCoreMdl.setObjName(objName);
                itmTransCoreMdl.setUserInfo(userInfo);
                ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel)sess.getAttribute("itmTransHdrMdl");
                if (itmTransHdrMdl != null) {
                    itmTransCoreMdl.setITMFilterModel(itmTransHdrMdl.getITMFilterModel());
                }
                BaseLogger.log("3", userInfo, editorId, "coreMdlId = " + coreMdlId);
                sess.setAttribute(coreMdlId, (Object)itmTransCoreMdl);
            }
            itmTransCoreMdl.getMasterStateful().setEditorId(coreMdlId);
            itmTransCoreMdl.setCoreModelId(Integer.parseInt(coreMdlId));
            itmTransCoreMdl.setPKValues(pkValues);
            itmTransCoreMdl.setEditFlag(editFlag);
            itmTransCoreMdl.getMasterStateful().setPlanDate(plan_Date);
            itmTransCoreMdl.getMasterStateful().setCalComp(Cal_Comp);
            E12TransEditorCoreModel transEditorCoreModel = null;
            if (transEditorCoreModel == null) {
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setMasterStateful(itmTransCoreMdl.getMasterStateful());
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            int cnt = 0;
            int pos = 0;
            int lastPos = 0;
            String xmlString = "";
            StringBuffer xmlStringBuff = new StringBuffer();
            if ("false".equalsIgnoreCase(deafultEditor)) {
                cnt = 1;
                while (cnt <= noOfForms) {
                    xmlString = !"V".equalsIgnoreCase(editFlag) ? this.checkNull(itmTransCoreMdl.getXMLData("" + cnt, "E", "1", reqParamStr)) : this.checkNull(itmTransCoreMdl.getXMLData("" + cnt, editFlag, "1", reqParamStr));
                    if (cnt == 1) {
                        xmlStringBuff = xmlStringBuff.append(xmlString);
                    } else if (!"".equalsIgnoreCase(xmlString) && (pos = xmlString.indexOf("<Detail")) != -1) {
                        lastPos = xmlString.lastIndexOf("</Header0>");
                        xmlString = xmlString.substring(pos, lastPos);
                        lastPos = xmlStringBuff.lastIndexOf("</Header0>");
                        xmlStringBuff.insert(lastPos, xmlString);
                    }
                    if (xmlStringBuff.indexOf("domID=\"\"") != -1) {
                        pos = xmlStringBuff.indexOf("domID=\"\"");
                        xmlStringBuff.insert(pos + 7, "1");
                    }
                    ++cnt;
                }
                xmlString = xmlStringBuff.toString();
            } else {
                if (reqParamStr != null && reqParamStr.trim().length() > 0) {
                    itmTransCoreMdl.getMasterStateful().setRequestParamStr(reqParamStr.trim());
                }
                xmlString = itmTransCoreMdl.getMasterStateful().getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
                BaseLogger.log("3", userInfo, editorId, "xmlString [" + xmlString + "]");
                itmTransCoreMdl.getMasterStateful().setRequestParamStr(null);
            }
            chgStr = this.checkNull(chgStr);
            BaseLogger.log("3", userInfo, editorId, "chgStr [" + chgStr + "]");
            if (chgStr.length() > 0) {
                xmlString = chgStr;
            }
            if (!"".equalsIgnoreCase(retXMLStr = xmlString) && masterRem != null) {
                itmTransCoreMdl.getMasterStateful().setData(retXMLStr);
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    private String getStatefulEditorId(String editorId, String userId) {
        String tempEditorID = editorId;
        if (editorId != null && editorId.indexOf(userId) != -1) {
            tempEditorID = editorId.substring(0, editorId.indexOf(userId));
        }
        return tempEditorID;
    }

    public String validateAndSave(String formData, String objName, String formNo, String saveLavel, String saveDocument, String editFlag, String formType, String editorId, String editor, String isFormChanged, HttpServletRequest request, HttpHeaders header, HttpServletResponse response) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block48: {
            BaseLogger.log("3", null, null, "Inside validateAndSave ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            Connection conn = null;
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "validateAndSave() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "validateAndSave() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "validateAndSave() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "validateAndSave() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "validateAndSave() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "validateAndSave() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("validateAndSave", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "validateAndSave() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "validateAndSave");
                            BaseLogger.log("3", null, null, "validateAndSave() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "validateAndSave() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (formData == null || formData.equals(null) || formData.length() <= 0) {
                        result = new JSONObject().put("Message", (Object)"Please pass form data").toString();
                        status = "Error";
                        isError = true;
                    }
                    JSONObject formDataObj = null;
                    try {
                        formDataObj = new JSONObject(formData);
                    }
                    catch (Exception e) {
                        result = new JSONObject().put("Message", (Object)"Please pass form data in JSON Format").toString();
                        status = "Error";
                        isError = true;
                    }
                    if (!isError) {
                        String objContext = "1";
                        BaseLogger.log("3", null, null, "validateAndSave() formDataObj=" + formDataObj);
                        String chgStr = this.getChg_strForSave(objName, formNo, objContext, editFlag, formDataObj, isFormChanged);
                        BaseLogger.log("3", null, null, "validateAndSave() chg_str=" + chgStr);
                        E12GenericUtility genericutility = new E12GenericUtility();
                        String userId = userInfo.getLoginCode();
                        String coreMdlId = editorId;
                        editorId = String.valueOf(editorId) + userId;
                        editor = "MobEditor";
                        String callerInterface = "BROWSER";
                        String enterprise = userInfo.getEnterprise();
                        HttpSession sess = request.getSession(false);
                        sess.setMaxInactiveInterval(300);
                        String saveLvl = saveLavel;
                        String currentSummaryXsl = new E12GenericUtility().getSummaryXSL(objName, callerInterface, enterprise);
                        BaseLogger.log("3", null, null, "validateAndSave() currentSummaryXsl=" + currentSummaryXsl);
                        E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
                        if (transEditorCoreModel != null) {
                            BaseLogger.log("3", null, null, "Got E12TransEditorCoreModel from session = " + transEditorCoreModel);
                            MasterStatefulRemote masterStatefulEJB = transEditorCoreModel.getMasterStateful();
                            if (masterStatefulEJB != null && masterStatefulEJB.getEditorId() != null) {
                                JSONObject jsonObject;
                                masterStatefulEJB.setIsFormChange(isFormChanged);
                                String tempEditorID = this.getStatefulEditorId(editorId, userId);
                                masterStatefulEJB.setEditorId(tempEditorID);
                                masterStatefulEJB.setEditor(editor);
                                String tranID = "";
                                if (masterStatefulEJB.getTranId() != null) {
                                    tranID = masterStatefulEJB.getTranId().trim();
                                }
                                if (!"V".equals(editFlag)) {
                                    AppConnectParm appConn = new AppConnectParm();
                                    InitialContext ctx = new InitialContext(appConn.getProperty());
                                    Calendar cal = Calendar.getInstance();
                                    SimpleDateFormat formatter = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
                                    String currentDateTime = formatter.format(cal.getTime());
                                    Document chgString = new E12GenericUtility().parseString(chgStr);
                                    if (chgString != null) {
                                        NodeList chgStringchildNode = chgString.getFirstChild().getChildNodes();
                                        objName = chgStringchildNode.item(0).getChildNodes().item(0).getFirstChild().getNodeValue();
                                    }
                                    masterStatefulEJB.setEditorId(tempEditorID);
                                    EventLogInfoBean eventInfoBean = null;
                                    if (userInfo != null) {
                                        eventInfoBean = new EventLogInfoBean(userInfo.getLoginCode());
                                    }
                                }
                                String responseStr = this.validateData(chgStr, sess, editorId, editFlag, saveLvl, objName, tranID, masterStatefulEJB, userInfo);
                                BaseLogger.log("3", userInfo, editorId, "responseStr =[" + responseStr + "]");
                                String tranIDRet = this.getTranIdFromXML(responseStr);
                                BaseLogger.log("3", userInfo, editorId, "responseStr tranIDRet=[" + tranIDRet + "]");
                                if (responseStr.contains("Success") || responseStr.contains("success")) {
                                    this.addFollowUpAction(userId, coreMdlId, tranIDRet, objName, userInfo, request);
                                    jsonObject = XML.toJSONObject((String)responseStr);
                                    result = jsonObject.toString();
                                    status = "success";
                                } else {
                                    jsonObject = XML.toJSONObject((String)responseStr);
                                    result = jsonObject.toString();
                                    status = "Error";
                                }
                            } else {
                                result = new JSONObject().put("data", (Object)new JSONObject()).put("error", (Object)"Editor Id Not found").put("status", (Object)"Reject").toString();
                                status = "Error";
                            }
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : validateAndSave : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "validateAndSave", params, tokenId, dataFormat, status, result, userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block48;
                    }
                    catch (Exception resultObj) {}
                    break block48;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "validateAndSave", params, tokenId, dataFormat, status, result, userInfo);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception resultObj) {
                    // empty catch block
                }
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "validateAndSave", params, tokenId, dataFormat, status, result, userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("validateAndSave ( VisionOBJService/validateAndSave )", status, result, appId, request, userInfo);
        return result;
    }

    public String validateAndSave_old(String formData, String objName, String formNo, String saveLavel, String saveDocument, String editFlag, String formType, String editorId, String editor, String isFormChanged, HttpServletRequest request, HttpHeaders header, HttpServletResponse response) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block45: {
            Connection conn;
            String dataFormat;
            String tokenId;
            String params;
            block44: {
                BaseLogger.log("3", null, null, "Inside validateAndSave ");
                result = "";
                params = "";
                status = "error";
                tokenId = "";
                dataFormat = "JSON";
                appId = "";
                conn = null;
                boolean isError = false;
                e12ExtServiceUtility = new E12ExtServiceUtility();
                RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
                APIUtility apiUtility = new APIUtility();
                userInfo = null;
                try {
                    try {
                        tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                        BaseLogger.log("3", null, null, "validateAndSave() TOKENID length=" + tokenId.length());
                        if (tokenId.length() == 0) {
                            status = "Reject";
                            result = "Blank Token ID passed.";
                            isError = true;
                            BaseLogger.log("3", null, null, "validateAndSave() TOKENID length return error" + tokenId.length());
                        }
                        if (!isError) {
                            userInfo = this.getUserInfo(request, tokenId);
                        }
                        if (!isError && userInfo == null) {
                            status = "Reject";
                            result = "User not allowed.";
                            isError = true;
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            appId = apiUtility.getAppIdFromJWTToken(tokenId);
                        }
                        if (!(isError || appId != null && appId.length() != 0)) {
                            status = "Reject";
                            result = "Blank APPID passed.";
                            isError = true;
                        }
                        BaseLogger.log("3", null, null, "validateAndSave() appId=" + appId);
                        params = request.getQueryString();
                        BaseLogger.log("3", null, null, "validateAndSave() request.getQueryString() " + request.getQueryString());
                        if (this.checkNull(params).length() == 0) {
                            StringBuffer paramString = new StringBuffer();
                            paramString.append("&TOKEN_ID=" + tokenId);
                            paramString.append("&OBJ_NAME=" + objName);
                            params = paramString.toString();
                        }
                        BaseLogger.log("3", null, null, "validateAndSave() params=" + params);
                        if (!isError && !appId.equals("FLUTTERAPP")) {
                            BaseLogger.log("3", null, null, "validateAndSave() none flutter APP");
                            ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("validateAndSave", appId);
                            if (authAppAPIBean == null) {
                                status = "Reject";
                                result = "This service not available for given APPID";
                                isError = true;
                                BaseLogger.log("3", null, null, "validateAndSave() none flutter result=" + result);
                            } else {
                                result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "validateAndSave");
                                BaseLogger.log("3", null, null, "validateAndSave() result=" + result);
                                if ("valid".equalsIgnoreCase(result)) {
                                    if (apiUtility.checkDailyAPILimit(userInfo)) {
                                        status = "Reject";
                                        result = "Daily API call limit exceeded";
                                        isError = true;
                                        BaseLogger.log("3", null, null, "validateAndSave() none flutter validation result=" + result);
                                    }
                                } else {
                                    status = "Reject";
                                    isError = true;
                                }
                            }
                        }
                        if (formData == null || formData.equals(null) || formData.length() <= 0) {
                            result = new JSONObject().put("Message", (Object)"Please pass form data").toString();
                            status = "Error";
                            isError = true;
                        }
                        JSONObject formDataObj = null;
                        try {
                            formDataObj = new JSONObject(formData);
                        }
                        catch (Exception e) {
                            result = new JSONObject().put("Message", (Object)"Please pass form data in JSON Format").toString();
                            status = "Error";
                            isError = true;
                        }
                        if (isError) break block44;
                        String objContext = "1";
                        String chgStr = this.getChg_strForSave(objName, formNo, objContext, editFlag, formDataObj, isFormChanged);
                        BaseLogger.log("3", null, null, "validateAndSave() chg_str=" + chgStr);
                        E12GenericUtility genericutility = new E12GenericUtility();
                        String userId = userInfo.getLoginCode();
                        String coreMdlId = editorId;
                        editorId = String.valueOf(editorId) + userId;
                        editor = "MobEditor";
                        String callerInterface = "BROWSER";
                        String enterprise = userInfo.getEnterprise();
                        HttpSession sess = request.getSession();
                        String saveLvl = saveLavel;
                        String currentSummaryXsl = new E12GenericUtility().getSummaryXSL(objName, callerInterface, enterprise);
                        BaseLogger.log("3", null, null, "validateAndSave() currentSummaryXsl=" + currentSummaryXsl);
                        ITMTransactionCoreModel itmTransCoreMdl = null;
                        itmTransCoreMdl = new ITMTransactionCoreModel();
                        itmTransCoreMdl.setObjName(objName);
                        itmTransCoreMdl.setUserInfo(userInfo);
                        ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel)sess.getAttribute("itmTransHdrMdl");
                        if (itmTransHdrMdl != null) {
                            itmTransCoreMdl.setITMFilterModel(itmTransHdrMdl.getITMFilterModel());
                        }
                        BaseLogger.log("3", userInfo, editorId, "coreMdlId = " + coreMdlId);
                        String plan_Date = "";
                        String Cal_Comp = "";
                        sess.setAttribute(coreMdlId, (Object)itmTransCoreMdl);
                        itmTransCoreMdl.getMasterStateful().setEditorId(coreMdlId);
                        itmTransCoreMdl.setCoreModelId(Integer.parseInt(coreMdlId));
                        String pkValues = "";
                        itmTransCoreMdl.setPKValues(pkValues);
                        itmTransCoreMdl.setEditFlag(editFlag);
                        itmTransCoreMdl.getMasterStateful().setPlanDate(plan_Date);
                        itmTransCoreMdl.getMasterStateful().setCalComp(Cal_Comp);
                        itmTransCoreMdl.getMasterStateful().setObjContext(objContext);
                        itmTransCoreMdl.getMasterStateful().setUserInfo(userInfo);
                        E12TransEditorCoreModel transEditorCoreModel = null;
                        transEditorCoreModel = new E12TransEditorCoreModel(objName);
                        transEditorCoreModel.setUserInfo(userInfo);
                        transEditorCoreModel.setObjName(objName);
                        transEditorCoreModel.setUserInfo(userInfo);
                        transEditorCoreModel.setMasterStateful(itmTransCoreMdl.getMasterStateful());
                        sess.setAttribute(editorId, (Object)transEditorCoreModel);
                        try {
                            if (transEditorCoreModel == null) break block44;
                            BaseLogger.log("3", userInfo, editorId, "transEditorCoreModel is not empty = ");
                            MasterStatefulRemote masterStatefulEJB = transEditorCoreModel.getMasterStateful();
                            if (masterStatefulEJB != null && masterStatefulEJB.getEditorId() != null) {
                                BaseLogger.log("3", userInfo, editorId, "masterStatefulEJB editorId is not empty = ");
                                masterStatefulEJB.setIsFormChange(isFormChanged);
                                String tempEditorID = this.getStatefulEditorId(editorId, userId);
                                masterStatefulEJB.setEditorId(tempEditorID);
                                masterStatefulEJB.setEditor(editor);
                                masterStatefulEJB.setObjContext("1");
                                String detailDomStr = this.createDetailDomStr(objName, formNo, editFlag, formDataObj, isFormChanged);
                                BaseLogger.log("3", userInfo, editorId, "masterStatefulEJB to set detailDomStr = " + detailDomStr);
                                masterStatefulEJB.setData(detailDomStr);
                                String tranID = "";
                                if (masterStatefulEJB.getTranId() != null) {
                                    tranID = masterStatefulEJB.getTranId().trim();
                                }
                                BaseLogger.log("3", userInfo, editorId, "masterStatefulEJB tranID is not empty = " + tranID);
                                String responseStr = this.validateData(chgStr, sess, editorId, editFlag, saveLvl, objName, tranID, masterStatefulEJB, userInfo);
                                BaseLogger.log("3", userInfo, editorId, "responseStr =[" + responseStr + "]");
                                String tranIDRet = this.getTranIdFromXML(responseStr);
                                BaseLogger.log("3", userInfo, editorId, "responseStr tranIDRet=[" + tranIDRet + "]");
                                if (responseStr.contains("Success") || responseStr.contains("success")) {
                                    this.addFollowUpAction(userId, coreMdlId, tranIDRet, objName, userInfo, request);
                                    JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                                    result = jsonObject.toString();
                                    status = "success";
                                } else {
                                    JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                                    result = jsonObject.toString();
                                    status = "Error";
                                }
                                break block44;
                            }
                            result = new JSONObject().put("data", (Object)new JSONObject()).put("error", (Object)"Editor Id Not found").put("status", (Object)"Reject").toString();
                            status = "Error";
                        }
                        catch (NoSuchEJBException e) {
                            BaseLogger.log("0", userInfo, editorId, " validateAndSave :: IN CATCH BLOCK ");
                            result = new JSONObject().put("data", (Object)new JSONObject()).put("error", (Object)"Editor Id Not found").put("status", (Object)"Reject").toString();
                            status = "Error";
                        }
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Exception : validateAndSave : " + e.getMessage());
                        result = this.getStackTrace(e, dataFormat);
                        status = "exception";
                        if (tokenId.length() != 0 && userInfo == null) {
                            JSONObject resultObj = new JSONObject();
                            try {
                                resultObj.put("data", (Object)new JSONObject());
                                resultObj.put("error", (Object)"Invalid TOKEN");
                                resultObj.put("status", (Object)"Reject");
                                return resultObj.toString();
                            }
                            catch (JSONException e2) {
                                e2.printStackTrace();
                                return resultObj.toString();
                            }
                        }
                        result = this.generateResponse(request, "validateAndSave", params, tokenId, dataFormat, status, result, userInfo);
                        try {
                            if (conn != null) {
                                conn.close();
                            }
                            break block45;
                        }
                        catch (Exception resultObj) {}
                        break block45;
                    }
                }
                catch (Throwable throwable) {
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "validateAndSave", params, tokenId, dataFormat, status, result, userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                    }
                    catch (Exception resultObj) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "validateAndSave", params, tokenId, dataFormat, status, result, userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("validateAndSave ( VisionOBJService/validateAndSave )", status, result, appId, request, userInfo);
        return result;
    }

    String getChg_strForSave(String objName, String pageContext, String objContext, String editFlag, JSONObject formData, String isChange) {
        try {
            StringBuilder strgBuilder = new StringBuilder();
            strgBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            strgBuilder.append("<Root>");
            strgBuilder.append("<header>");
            strgBuilder.append("<objName>" + objName + "</objName>");
            strgBuilder.append("<pageContext>" + pageContext + "</pageContext>");
            strgBuilder.append("<objContext>" + objContext + "</objContext>");
            strgBuilder.append("<editFlag>" + editFlag + "</editFlag>");
            strgBuilder.append("<focusedColumn></focusedColumn>");
            strgBuilder.append("<keyValue>1</keyValue>");
            strgBuilder.append("<forcedSave>false</forcedSave>");
            strgBuilder.append("<taxInFocus>false</taxInFocus>");
            strgBuilder.append("<forcedconfirm>false</forcedconfirm>");
            strgBuilder.append("<isSaveNConitinue>false</isSaveNConitinue>");
            strgBuilder.append("<saveLevel>1</saveLevel>");
            strgBuilder.append("</header>");
            BaseLogger.log("3", null, null, "All formData " + formData);
            String key = "Detail" + pageContext;
            JSONObject currentFormData = formData.optJSONObject("Detail" + pageContext);
            if (currentFormData != null) {
                strgBuilder.append("<Detail" + pageContext + " objContext=\"" + objContext + "\" " + "objName = \"" + objName + "\" " + "domID=\"1\" selected=\"Y\" " + ">");
                strgBuilder.append("<attribute IS_CHANGE=\"" + isChange + "\" " + "pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"" + editFlag + "\"/>");
                strgBuilder.append(this.getKeyValueAsXMLFromJSON(currentFormData));
                strgBuilder.append("</Detail" + pageContext + ">");
            } else {
                JSONArray currentFormArray = formData.optJSONArray("Detail" + pageContext);
                if (currentFormArray != null) {
                    int i = 0;
                    while (i < currentFormArray.length()) {
                        JSONObject obj = currentFormArray.getJSONObject(i);
                        strgBuilder.append("<Detail" + pageContext + " objContext=\"" + objContext + "\" " + "objName = \"" + objName + "\" " + "domID=\"1\" selected=\"Y\" " + ">");
                        strgBuilder.append("<attribute IS_CHANGE=\"" + isChange + "\" " + "pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"" + editFlag + "\"/>");
                        strgBuilder.append(this.getKeyValueAsXMLFromJSON(obj));
                        strgBuilder.append("</Detail" + pageContext + ">");
                        ++i;
                    }
                }
            }
            strgBuilder.append("</Root>");
            return strgBuilder.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getChg_strForSave : " + e.getMessage());
            return "";
        }
    }

    String getKeyValueAsXMLFromJSON(JSONObject detail) {
        try {
            StringBuilder strgBuilder = new StringBuilder();
            Iterator keys = detail.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = detail.get(key);
                strgBuilder.append("<" + key + ">" + value + "</" + key + ">");
            }
            return strgBuilder.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    String createDetailDomStr(String objName, String pageContext, String editFlag, JSONObject formData, String isChange) {
        try {
            StringBuilder strgBuilder = new StringBuilder();
            strgBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            strgBuilder.append("<DocumentRoot>");
            strgBuilder.append("<description>Datawindow Root</description>");
            strgBuilder.append("<group0>\t<description>Group0 description</description>\n\t<Header0>");
            strgBuilder.append("<description>Header0 members</description>");
            BaseLogger.log("3", null, null, "All formData " + formData);
            Iterator keys = formData.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                BaseLogger.log("3", null, null, "Current keys " + key);
                JSONObject currentFormData = formData.optJSONObject(key);
                if (currentFormData != null) {
                    strgBuilder.append("<" + key + " objContext=\"" + 1 + "\" " + "objName = \"" + objName + "\" " + "domID=\"1\" selected=\"Y\" " + ">");
                    strgBuilder.append("<attribute IS_CHANGE=\"" + isChange + "\" " + "pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"" + editFlag + "\"/>");
                    strgBuilder.append(this.getKeyValueAsXMLFromJSON(currentFormData));
                    strgBuilder.append("</" + key + ">");
                    continue;
                }
                JSONArray currentFormArray = formData.optJSONArray(key);
                if (currentFormArray == null) continue;
                int i = 0;
                while (i < currentFormArray.length()) {
                    JSONObject obj = currentFormArray.getJSONObject(i);
                    strgBuilder.append("<" + key + " objContext=\"" + 1 + "\" " + "objName = \"" + objName + "\" " + "domID=\"1\" selected=\"Y\" " + ">");
                    strgBuilder.append("<attribute IS_CHANGE=\"" + isChange + "\" " + "pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"" + editFlag + "\"/>");
                    strgBuilder.append(this.getKeyValueAsXMLFromJSON(obj));
                    strgBuilder.append("</" + key + ">");
                    ++i;
                }
            }
            strgBuilder.append("</Header0>");
            strgBuilder.append("</group0>");
            strgBuilder.append("</DocumentRoot>");
            return strgBuilder.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getChg_strForSave : " + e.getMessage());
            return "";
        }
    }

    private String validateData(String chgStr, HttpSession sess, String editorId, String editFlag, String saveLevel, String objName, String tranID, MasterStatefulRemote masterRem, UserInfoBean userInfo) throws ITMException {
        String retXMLStr = null;
        boolean isWriteUserActLog = false;
        try {
            UserEventLogEJB userEventLogEJB = new UserEventLogEJB();
            if (masterRem != null) {
                if (userInfo != null) {
                    Date startTime = new Date();
                    retXMLStr = masterRem.validateAndPerformAction(chgStr, "VAL_DATA");
                    retXMLStr = retXMLStr == null ? "" : retXMLStr;
                    String action1 = "EDIT";
                    String eventAction = "";
                    if ("A".equalsIgnoreCase(editFlag)) {
                        action1 = "ADD";
                    }
                    if ("EDIT".equalsIgnoreCase(action1 = "V".equalsIgnoreCase(editFlag) ? "VIEW" : "EDIT") && (tranID == null || tranID.trim().length() == 0)) {
                        action1 = "ADD";
                        tranID = masterRem.getTranId();
                    }
                    if (retXMLStr.indexOf("<Root><Detail>Success</Detail></Root>") != -1) {
                        eventAction = "Abort";
                        isWriteUserActLog = true;
                    } else if (retXMLStr.indexOf("<MsgOnSave> Transaction is saved. </MsgOnSave>") != -1) {
                        eventAction = "Save";
                        isWriteUserActLog = true;
                    }
                    BaseLogger.log("3", userInfo, editorId, "Dnyaneshwar :: RequestHandlerServlet : validateData : eventAction[" + eventAction + "]");
                    if ("Abort".equalsIgnoreCase(eventAction)) {
                        if (userEventLogEJB != null && userInfo != null) {
                            userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), masterRem.getEditorId(), action1, eventAction, startTime, new Date(), "saveLvl:[" + saveLevel + "]", tranID, "Success", "SA", "");
                        } else {
                            BaseLogger.log("3", userInfo, editorId, " ============ User info is null then never create event log in validateData() method of RequestHandlerServlet.java file, action is 'DEL_TRANS' ");
                        }
                    }
                } else {
                    retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork.");
                }
            } else {
                retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork.");
            }
            if (editFlag == null && saveLevel == null) {
                Document xmlStrDoc = null;
                if (chgStr != null && !chgStr.equalsIgnoreCase("-1")) {
                    xmlStrDoc = new E12GenericUtility().parseString(chgStr);
                    if (xmlStrDoc.getElementsByTagName("saveLevel").item(0) != null && xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild() != null) {
                        saveLevel = xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild().getNodeValue().trim();
                    }
                    if (xmlStrDoc.getElementsByTagName("editFlag").item(0) != null && xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild() != null) {
                        editFlag = xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild().getNodeValue().trim();
                    }
                }
            }
            if (isWriteUserActLog && masterRem != null) {
                if (userInfo != null) {
                    EventLogInfoBean eventInfoBean = new EventLogInfoBean(userInfo.getLoginCode());
                    eventInfoBean.removeEditorActivity(objName, userInfo.getSesstionId(), masterRem.getEditorId(), userInfo.getTransDB());
                } else {
                    BaseLogger.log("3", userInfo, editorId, " ============ User info is null then never created event log in ITMValidatorServlet.java file");
                }
                try {
                    masterRem.remove();
                    masterRem = null;
                }
                catch (NoSuchEJBException exception) {
                    BaseLogger.log("3", userInfo, editorId, " ReuestHandlerServlet :: validateData :  IN CATCH BLOCK ");
                }
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :RequestHandlerServlet :validateData :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :RequestHandlerServlet :validateData :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    String getTranIdFromXML(String responseStr) {
        String tranIDRet = "";
        try {
            Node tranIdNode = new E12GenericUtility().parseString(responseStr).getElementsByTagName("TranID").item(0);
            if (tranIdNode != null && tranIdNode.getFirstChild() != null) {
                tranIDRet = tranIdNode.getFirstChild().getNodeValue();
            }
            BaseLogger.log("3", null, null, "tranIDRet - [" + tranIDRet + "]");
            return tranIDRet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    private void addFollowUpAction(String userId, String editorId, String tranId, String objName, UserInfoBean userInfo, HttpServletRequest request) {
        try {
            ServletContext servletContext = request.getServletContext();
            String pendingWrkflwMapKey = String.valueOf(userId) + "~" + editorId;
            String pendingWrkflwMapValue = String.valueOf(objName) + "~" + tranId;
            Map<String, String> pendingWrkflwMap = new HashMap();
            if (servletContext.getAttribute("pendingWrkflwMap") != null) {
                pendingWrkflwMap = (Map)servletContext.getAttribute("pendingWrkflwMap");
                if (pendingWrkflwMap != null) {
                    pendingWrkflwMap.put(pendingWrkflwMapKey, pendingWrkflwMapValue);
                }
                AppConnectParm appConnect = new AppConnectParm();
                InitialContext ctx = new InitialContext(appConnect.getProperty());
                E12FollowUpActionEJB followUpActionLocal = new E12FollowUpActionEJB();
                followUpActionLocal.followUpAction(pendingWrkflwMapKey, servletContext, userInfo);
            }
            BaseLogger.log("3", userInfo, editorId, "pendingWrkflwMap - " + servletContext.getAttribute("pendingWrkflwMap"));
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, editorId, "Exception addFollowUpAction() - " + e.getMessage());
            e.printStackTrace();
        }
    }

    public String getFieldItemChange(String objName, String formNo, String objContext, String pageContext, String chgStrJson, String fieldName, String editorId, String domId, HttpServletRequest request, HttpServletResponse response, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block41: {
            BaseLogger.log("3", null, null, "Inside getFieldItemChange ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            Connection conn = null;
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getFieldItemChange() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getFieldItemChange() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getFieldItemChange() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getFieldItemChange() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getFieldItemChange() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getFieldItemChange() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getFieldItemChange", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getFieldItemChange() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getFieldItemChange");
                            BaseLogger.log("3", null, null, "getFieldItemChange() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getFieldItemChange() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    JSONObject formDataObj = null;
                    try {
                        formDataObj = new JSONObject(chgStrJson);
                    }
                    catch (Exception e) {
                        result = new JSONObject().put("Message", (Object)"Please pass form data in JSON Format").toString();
                        status = "Error";
                        isError = true;
                    }
                    if (!isError) {
                        String editFlag = "A";
                        String focusedColumn = fieldName;
                        String elementName = "";
                        String keyValue = "1";
                        String taxKeyValue = "";
                        String saveLevel = "0";
                        String forceSave = "false";
                        String taxInFocus = "false";
                        String forcedconfirm = "false";
                        String pkNames = "";
                        formDataObj = new JSONObject(chgStrJson);
                        BaseLogger.log("3", userInfo, editorId, " objContext = " + objContext + "  and pageContext=" + pageContext);
                        String chgStr = this.generateChgXML(formDataObj, objName, "1", objContext, editFlag, focusedColumn, elementName, keyValue, taxKeyValue, saveLevel, forceSave, taxInFocus, forcedconfirm, formNo, domId, "Y", pkNames);
                        BaseLogger.log("3", userInfo, editorId, "ITEM_CHANGE XML chgStr = " + chgStr);
                        BaseLogger.log("3", userInfo, editorId, "ITEM_CHANGE chgStr = " + chgStrJson);
                        BaseLogger.log("3", userInfo, editorId, "ITEM_CHANGE Map = " + chgStr);
                        Date startTime = new Date();
                        String userId = userInfo.getLoginCode();
                        BaseLogger.log("3", userInfo, editorId, "getFieldItemChange ::  ITEM_CHANGE chgStr[" + chgStr + "] \n editFlag[" + editFlag + "] objName[" + objName + "]");
                        UserEventLogEJB userEventLogEJB = new UserEventLogEJB();
                        if (userEventLogEJB != null) {
                            // empty if block
                        }
                        HttpSession sess = request.getSession(false);
                        editorId = String.valueOf(editorId) + userId;
                        String responseStr = this.getChangedData(chgStr, sess, request, editorId, userId, userInfo, objName, objContext);
                        BaseLogger.log("3", null, null, "Got response str = " + responseStr);
                        BaseLogger.log("3", null, null, "check the editorid=" + editorId);
                        BaseLogger.log("3", null, null, "second API - Session ID: " + sess.getId());
                        String coreMdlId = (String)sess.getAttribute("CORE_MDL");
                        BaseLogger.log("3", null, null, "Second API - Retrieved coreMdlId from session: " + coreMdlId);
                        sess.setMaxInactiveInterval(300);
                        BaseLogger.log("3", null, null, "GOt values " + objName + "," + objContext + "," + pageContext + "," + chgStr + "," + fieldName + "," + editorId);
                        if (responseStr.contains("Success") || responseStr.contains("success")) {
                            JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                            result = jsonObject.toString();
                            status = "success";
                        } else {
                            JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                            result = jsonObject.toString();
                            status = "Error";
                        }
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getFieldItemChange : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getFieldItemChange", params, tokenId, dataFormat, status, result, userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block41;
                    }
                    catch (Exception resultObj) {}
                    break block41;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getFieldItemChange", params, tokenId, dataFormat, status, result, userInfo);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception resultObj) {
                    // empty catch block
                }
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getFieldItemChange", params, tokenId, dataFormat, status, result, userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("getFieldItemChange ( VisionOBJService/getFieldItemChange )", status, result, appId, request, userInfo);
        return result;
    }

    private String getChgStrXML(JSONObject formData, String objContext, String objName, String pageContext, String editFlag, String fieldName) {
        try {
            StringBuilder strgBuilder = new StringBuilder();
            strgBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            strgBuilder.append("<Root>");
            strgBuilder.append("<header>");
            strgBuilder.append("<objName>" + objName + "</objName>");
            strgBuilder.append("<pageContext>1</pageContext>");
            strgBuilder.append("<objContext>" + objContext + "</objContext>");
            strgBuilder.append("<editFlag>" + editFlag + "</editFlag>");
            strgBuilder.append("<focusedColumn>" + fieldName + "</focusedColumn>");
            strgBuilder.append("<elementName></elementName>");
            strgBuilder.append("<keyValue>1</keyValue>");
            strgBuilder.append("<taxKeyValue></taxKeyValue>");
            strgBuilder.append("<saveLevel>0</saveLevel>");
            strgBuilder.append("<forcedSave>false</forcedSave>");
            strgBuilder.append("<taxInFocus>false</taxInFocus>");
            strgBuilder.append("</header>");
            strgBuilder.append("<Detail" + pageContext + " objContext=\"" + objContext + "\" " + "objName=\"" + objName + "\" " + "domID=\"1\" " + "dbID=\"\" " + "selected=\"Y\" " + ">");
            strgBuilder.append("<attribute IS_CHANGE=\"Y\" pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"" + editFlag + "\"" + "/>");
            Iterator keys = formData.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = formData.get(key);
                strgBuilder.append("<" + key + ">" + value + "</" + key + ">");
            }
            strgBuilder.append("</Detail" + pageContext + ">");
            strgBuilder.append("</Root>");
            return strgBuilder.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getChgStrXML : " + e.getMessage());
            return "";
        }
    }

    protected String getChangedData(String chgStr, HttpSession sess, HttpServletRequest request, String editorId, String user, UserInfoBean userInfo, String objName, String objContext) throws ITMException {
        String retXMLStr = null;
        String plan_Date = "";
        String Cal_Comp = "";
        try {
            if (sess == null) {
                BaseLogger.log("3", userInfo, editorId, "No existing session found");
            }
            BaseLogger.log("3", null, null, "Find editorid = " + editorId);
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            BaseLogger.log("3", userInfo, editorId, "Session attributes editor id==>" + sess.getAttribute(editorId));
            if (transEditorCoreModel != null) {
                MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
                if (userInfo != null && masterRem != null) {
                    masterRem.setEditorId(editorId);
                    masterRem.setUserInfo(userInfo);
                    BaseLogger.log("3", userInfo, editorId, "chgStr from servlet=" + chgStr);
                    retXMLStr = masterRem.validateAndPerformAction(chgStr, "ITEM_CHANGE");
                    BaseLogger.log("3", userInfo, editorId, "Inside getItemChanged of E12EditorHadler line no 2040==" + retXMLStr);
                } else {
                    retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork");
                }
            } else {
                retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork.");
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :E12EditorHandlerServlet :getChangedData :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :E12EditorHandlerServlet :getChangedData :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    protected String getChangedData_old(String chgStr, HttpSession sess, HttpServletRequest request, String editorId, String user, UserInfoBean userInfo, String objName, String objContext, String detailXML) throws ITMException {
        String retXMLStr = null;
        String plan_Date = "";
        String Cal_Comp = "";
        try {
            ITMTransactionCoreModel itmTransCoreMdl = null;
            if (itmTransCoreMdl == null) {
                BaseLogger.log("3", userInfo, editorId, "ITMTransactionCoreModel can not get from sess");
                itmTransCoreMdl = new ITMTransactionCoreModel();
                itmTransCoreMdl.setObjName(objName);
                itmTransCoreMdl.setUserInfo(userInfo);
                ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel)sess.getAttribute("itmTransHdrMdl");
                if (itmTransHdrMdl != null) {
                    itmTransCoreMdl.setITMFilterModel(itmTransHdrMdl.getITMFilterModel());
                }
                BaseLogger.log("3", userInfo, editorId, "coreMdlId = " + editorId);
                sess.setAttribute(editorId, (Object)itmTransCoreMdl);
            }
            String pkValues = "";
            String editFlag = "A";
            itmTransCoreMdl.getMasterStateful().setEditorId(editorId);
            itmTransCoreMdl.setCoreModelId(Integer.parseInt(editorId));
            itmTransCoreMdl.setPKValues(pkValues);
            itmTransCoreMdl.setEditFlag(editFlag);
            itmTransCoreMdl.getMasterStateful().setPlanDate(plan_Date);
            itmTransCoreMdl.getMasterStateful().setCalComp(Cal_Comp);
            itmTransCoreMdl.getMasterStateful().setObjContext(objContext);
            itmTransCoreMdl.getMasterStateful().setUserInfo(userInfo);
            itmTransCoreMdl.getMasterStateful().setData(detailXML);
            E12TransEditorCoreModel transEditorCoreModel = null;
            transEditorCoreModel = new E12TransEditorCoreModel(objName);
            transEditorCoreModel.setUserInfo(userInfo);
            transEditorCoreModel.setMasterStateful(itmTransCoreMdl.getMasterStateful());
            transEditorCoreModel.setObjName(objName);
            sess.setAttribute(editorId, (Object)transEditorCoreModel);
            if (transEditorCoreModel != null) {
                MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
                if (userInfo != null && masterRem != null) {
                    masterRem.setEditorId(editorId);
                    masterRem.setUserInfo(userInfo);
                    BaseLogger.log("3", userInfo, editorId, "masterRem.getObjContext() = " + masterRem.getObjContext());
                    BaseLogger.log("3", userInfo, editorId, "chgStr from API=" + chgStr);
                    retXMLStr = masterRem.validateAndPerformAction(chgStr, "ITEM_CHANGE");
                    BaseLogger.log("3", userInfo, editorId, "getItemChanged of getChangedData() retXMLStr= " + retXMLStr);
                } else {
                    retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork");
                }
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :E12EditorHandlerServlet :getChangedData :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :E12EditorHandlerServlet :getChangedData :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    public String validateAndNext(String objName, String chgData, String objContext, HttpServletRequest request, String editFlag, String pkValues, String editorId, String action, String formNo, String editor, String domId, HttpHeaders header, HttpServletResponse response) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block60: {
            BaseLogger.log("3", null, null, "Inside validateAndNext ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "validateAndNext() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "validateAndNext() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "validateAndNext() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "validateAndNext() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "validateAndNext() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "validateAndNext() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("validateAndNext", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "validateAndNext() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "validateAndNext");
                            BaseLogger.log("3", null, null, "validateAndNext() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "validateAndNext() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (chgData == null || chgData.equals(null) || chgData.length() <= 0) {
                        result = new JSONObject().put("Message", (Object)"Please pass form data").toString();
                        status = "Error";
                        isError = true;
                    }
                    JSONObject formDataObj = null;
                    try {
                        formDataObj = new JSONObject(chgData);
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Error converting json=  " + e.getMessage());
                        result = new JSONObject().put("Message", (Object)"Please pass form data in JSON Format").toString();
                        status = "Error";
                        isError = true;
                    }
                    if (!isError) {
                        UserEventLogEJB userEventLogEJB;
                        String pageContext = "1";
                        String focusedColumn = "";
                        String elementName = "";
                        String keyValue = "1";
                        String taxKeyValue = "";
                        String saveLevel = "0";
                        String forceSave = "false";
                        String taxInFocus = "false";
                        String forcedconfirm = "false";
                        String isChange = "Y";
                        String pkNames = "";
                        Date startTime = new Date();
                        String fieldName = "";
                        String responseStr = "";
                        HttpSession sess = request.getSession(false);
                        sess.setMaxInactiveInterval(300);
                        String chgStr = this.generateChgXML(formDataObj, objName, pageContext, "1", editFlag, focusedColumn, elementName, keyValue, taxKeyValue, saveLevel, forceSave, taxInFocus, forcedconfirm, formNo, domId, isChange, pkNames);
                        BaseLogger.log("3", null, null, "validate and next chg_xml = " + chgStr);
                        if (this.checkNull(editor).length() == 0) {
                            editor = "MobEditor";
                        }
                        if (this.checkNull(action).length() == 0) {
                            action = "NEXT";
                        }
                        String userId = userInfo.getLoginCode();
                        editorId = String.valueOf(editorId) + userId;
                        String chgIP = request.getHeader("X-Forwarded-For");
                        if (chgIP == null) {
                            chgIP = request.getRemoteAddr();
                        }
                        String action1 = action;
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet FORM_NO[" + formNo + "] objContext[" + objContext + "] editFlag[" + editFlag + "]");
                        action1 = "A".equalsIgnoreCase(editFlag) ? "ADD" : ("V".equalsIgnoreCase(editFlag) ? "VIEW" : "EDIT");
                        if ("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0)) {
                            action1 = "ADD";
                        }
                        String tempEditorID = this.getStatefulEditorId(editorId, userId);
                        String event = "get_detail_data";
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        if ((userEventLogEJB = new UserEventLogEJB()) != null && userInfo != null) {
                            userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1, event, startTime, null, "pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues, "Pending", "SA", "");
                        }
                        if (pkValues == null || pkValues.trim().length() <= 0 || pkValues.equalsIgnoreCase("null") || !"A".equalsIgnoreCase(editFlag) || Integer.parseInt(objContext) != 1) {
                            E12GenericUtility genericutility = new E12GenericUtility();
                            if (forceSave != null && forceSave.equalsIgnoreCase("true")) {
                                chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
                            }
                            String argFieldValues = request.getParameter("ARG_VALUES");
                            String reqParamStr = request.getParameter("REQ_PARAM_STR");
                            responseStr = this.getXMLDataOnDelete(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId, userInfo);
                            BaseLogger.log("3", userInfo, editorId, "responseStr==== [" + responseStr + "]");
                        }
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        if (userEventLogEJB != null && userInfo != null) {
                            userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1, event, startTime, new Date(), "pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues, "Success", "SA", "");
                        }
                        Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
                        int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + formNo).getLength();
                        E12GenericUtility genericutility = new E12GenericUtility();
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet Action [NEXT] totalDetailNodes[" + totalDetailNodes + "]");
                        String finalRespStr = "";
                        if (totalDetailNodes > 0) {
                            int i = 0;
                            while (i < totalDetailNodes) {
                                if (currentDetailNode.getElementsByTagName("Detail" + formNo).item(i) != null) {
                                    responseStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Detail" + formNo).item(i));
                                    finalRespStr = String.valueOf(finalRespStr) + responseStr;
                                }
                                ++i;
                            }
                        } else if (currentDetailNode.getElementsByTagName("Errors").item(0) != null) {
                            NodeList errorNodeList = null;
                            int errorNodeListLen = 0;
                            if (responseStr.indexOf("<Errors>") != -1) {
                                if (responseStr != null && responseStr.length() > 0) {
                                    errorNodeList = genericutility.parseString(responseStr).getElementsByTagName("error");
                                }
                                if (errorNodeList != null) {
                                    errorNodeListLen = errorNodeList.getLength();
                                }
                                int i = 0;
                                while (i < errorNodeListLen) {
                                    Node errorNode = currentDetailNode.getElementsByTagName("error").item(i);
                                    Node typeNode = errorNode.getAttributes().getNamedItem("type");
                                    String typeNodeValue = typeNode.getNodeValue();
                                    BaseLogger.log("3", userInfo, editorId, "inside E12EditorHandler Servlet...934 typeNodeValue[" + typeNodeValue + "]");
                                    Node columnNode = errorNode.getAttributes().getNamedItem("column_name");
                                    String columnVlaue = "";
                                    if (columnNode != null) {
                                        columnVlaue = columnNode.getNodeValue();
                                    }
                                    BaseLogger.log("3", userInfo, editorId, "InE12EditorHandlerServlet columnVlaue[" + columnVlaue + "]");
                                    finalRespStr = String.valueOf(finalRespStr) + "<Errors>" + new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("error").item(i)) + "</Errors>";
                                    ++i;
                                }
                            }
                            responseStr = finalRespStr;
                        }
                        responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
                        BaseLogger.log("3", userInfo, editorId, "with final responseStr [" + responseStr + "]");
                        JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                        result = jsonObject.toString();
                        status = finalRespStr.equals("") ? "success" : "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : validateAndNext : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "validateAndNext", params, tokenId, dataFormat, status, result, userInfo);
                    break block60;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "validateAndNext", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "validateAndNext", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("validateAndNext ( VisionOBJService/validateAndNext )", status, result, appId, request, userInfo);
        return result;
    }

    String generateChgXML(JSONObject formDataObj, String objName, String pageContext, String objContext, String editFlag, String focusedColumn, String elementName, String keyValue, String taxKeyValue, String saveLevel, String forcedSave, String taxInFocus, String forcedconfirm, String formNo, String domId, String isChange, String pkNames) {
        StringBuilder strgXML = new StringBuilder();
        try {
            strgXML.append("<?xml version='1.0' encoding='utf-8'?>").append("<Root>").append("<header>").append("<objName>").append(objName).append("</objName>").append("<pageContext>").append(pageContext).append("</pageContext>").append("<objContext>").append(objContext).append("</objContext>").append("<editFlag>").append(editFlag).append("</editFlag>").append("<focusedColumn>").append(focusedColumn).append("</focusedColumn>").append("<elementName>").append(elementName).append("</elementName>").append("<keyValue>").append(keyValue).append("</keyValue>").append("<taxKeyValue>").append(taxKeyValue).append("</taxKeyValue>").append("<saveLevel>").append(saveLevel).append("</saveLevel>").append("<forcedSave>").append(forcedSave).append("</forcedSave>").append("<taxInFocus>").append(taxInFocus).append("</taxInFocus>").append("<forcedconfirm>").append(forcedconfirm).append("</forcedconfirm>").append("<isSaveNContinue>").append("false").append("</isSaveNContinue>").append("</header>");
            if (formDataObj.length() != 0) {
                Iterator keys = formDataObj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    Object value = formDataObj.get(key);
                    if (!key.contains("Detail")) continue;
                    strgXML.append("<").append(key).append(" objContext=\"").append(objContext).append("\" ").append("objName=\"").append(objName).append("\" ").append("domID=\"").append(domId).append("\" ").append("dbID=\"\" selected=\"Y\">").append("<attribute IS_CHANGE=\"").append(isChange).append("\" pkNames=\"").append(pkNames).append("\" selected=\"N\" status=\"N\" updateFlag=\"").append(editFlag).append("\"/>");
                    if (value instanceof JSONObject) {
                        JSONObject valueObject = (JSONObject)value;
                        Iterator valuekeys = valueObject.keys();
                        while (valuekeys.hasNext()) {
                            String valuekey = (String)valuekeys.next();
                            Object valueObjValue = valueObject.get(valuekey);
                            if (valueObjValue instanceof JSONObject) {
                                JSONObject valueJsonObject = (JSONObject)valueObjValue;
                                String prop = this.getPropString(valueJsonObject);
                                prop = "id=\"" + this.generateIdForField(key, domId, valuekey) + "\" " + prop;
                                strgXML.append("<" + valuekey + " " + prop);
                            }
                            strgXML.append("</" + valuekey + ">");
                        }
                    }
                    strgXML.append("</").append(key).append(">");
                }
            }
            strgXML.append("</Root>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : generateChgXML : " + e.getMessage());
        }
        return strgXML.toString();
    }

    String getPropString(JSONObject valueObjValue) {
        String propString = "";
        String value = "";
        try {
            Iterator valuekeys = valueObjValue.keys();
            while (valuekeys.hasNext()) {
                String valuekey = (String)valuekeys.next();
                Object valueObj = valueObjValue.get(valuekey);
                if (!valuekey.equalsIgnoreCase("content")) {
                    propString = String.valueOf(propString) + valuekey + "=\"" + valueObj + "\" ";
                    continue;
                }
                value = valueObj.toString();
            }
            propString = String.valueOf(propString) + ">" + value;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : getPropString : " + e.getMessage());
        }
        return propString;
    }

    String generateIdForField(String detail, String domId, String fieldName) {
        return String.valueOf(detail) + "_SEP1_" + domId + "_SEP1_" + fieldName;
    }

    protected String getXMLDataOnDelete(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr, String user, String action, String domID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, editorId, "[RequestHandlerServlet]Getting detail xml string on delete for objName :" + objName + ":\n\tpkValues :" + pkValues + ":\n\targFieldValues :" + argFieldValues);
        String retXMLStr = "";
        try {
            BaseLogger.log("3", null, null, "using editorId= " + editorId);
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            if (transEditorCoreModel == null) {
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            if (userInfo != null && masterRem != null) {
                boolean isValid;
                String tempEditorID = this.getStatefulEditorId(editorId, user);
                masterRem.setEditorId(tempEditorID);
                masterRem.setCurrentDetailValidated(true);
                String valXMLStr = chgStr != null && chgStr.length() > 0 ? masterRem.validateAndPerformAction(chgStr, "VAL_DATA") : "";
                boolean bl = isValid = valXMLStr.indexOf("<Errors>") == -1;
                if (isValid) {
                    String string = valXMLStr = valXMLStr.indexOf("<?xml version=") != -1 ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr;
                    if (reqParamStr != null && reqParamStr.trim().length() > 0) {
                        masterRem.setRequestParamStr(reqParamStr.trim());
                    }
                    BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet valXMLStr[" + valXMLStr + "]");
                    if (!"BLANK_DOM_FOR_ADD".equalsIgnoreCase(action) && !"NEXT".equalsIgnoreCase(action)) {
                        retXMLStr = masterRem.getDataXML(objContext, domID, "E", "1");
                        BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]");
                    } else if ("NEXT".equalsIgnoreCase(action)) {
                        "V".equalsIgnoreCase(editFlag);
                        BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]");
                    } else {
                        retXMLStr = masterRem.getDataXML(objContext, "1", "A", "1");
                        BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]");
                    }
                    String string2 = retXMLStr = retXMLStr.indexOf("<?xml version=") != -1 ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr;
                    if (chgStr != null && chgStr.length() > 0) {
                        retXMLStr = "<?xml version='1.0' encoding='" + userInfo.getCharEnc() + "' ?><Data>" + retXMLStr + "</Data>";
                    }
                    masterRem.setRequestParamStr(null);
                } else {
                    retXMLStr = valXMLStr;
                }
            } else {
                retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork");
            }
            if (masterRem != null && editFlag.equals("V")) {
                masterRem.remove();
                masterRem = null;
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    public String getXmlDataDetails(String objName, String objContext, String editFlag, String editorId, String action, String formNo, String pkValues, String formType, String lastDomId, int pageContext, String pgContext, HttpServletRequest request, HttpServletResponse response, HttpHeaders header) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block51: {
            BaseLogger.log("3", null, null, "Inside getXmlDataDetails ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            Connection conn = null;
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "getXmlDataDetails() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "getXmlDataDetails() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "getXmlDataDetails() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "getXmlDataDetails() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "getXmlDataDetails() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "getXmlDataDetails() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("getXmlDataDetails", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "getXmlDataDetails() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "getXmlDataDetails");
                            BaseLogger.log("3", null, null, "getXmlDataDetails() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "getXmlDataDetails() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        UserEventLogEJB userEventLogEJB;
                        String responseStr = "";
                        String editor = this.checkNull(request.getParameter("EDITOR"));
                        HttpSession sess = request.getSession(false);
                        sess.setMaxInactiveInterval(300);
                        if (editor.length() == 0) {
                            editor = "MobEditor";
                        }
                        String userId = userInfo.getLoginCode();
                        editorId = String.valueOf(editorId) + userId;
                        String chgIP = request.getHeader("X-Forwarded-For");
                        if (chgIP == null) {
                            chgIP = request.getRemoteAddr();
                        }
                        String action1 = action;
                        action1 = "A".equalsIgnoreCase(editFlag) ? "ADD" : ("V".equalsIgnoreCase(editFlag) ? "VIEW" : "EDIT");
                        if ("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0)) {
                            action1 = "ADD";
                        }
                        "E".equals(editFlag);
                        String tempEditorID = this.getStatefulEditorId(editorId, userId);
                        if (pkValues != null && pkValues.trim().length() > 0 && !pkValues.equalsIgnoreCase("null") && "A".equalsIgnoreCase(editFlag) && Integer.parseInt(objContext) == 1) {
                            responseStr = this.setActionForDuplicateTransaction(objName, objContext, pkValues, sess, editorId, userId, editor, userInfo);
                        } else {
                            Date startTime = new Date();
                            String chgStr = request.getParameter("CHG_STR");
                            String argFieldValues = request.getParameter("ARG_VALUES");
                            String reqParamStr = request.getParameter("REQ_PARAM_STR");
                            String plan_Date = request.getParameter("PLAN_DATE") != null ? request.getParameter("PLAN_DATE") : "";
                            String Cal_Comp = request.getParameter("CALENDAR_COMP") != null ? request.getParameter("CALENDAR_COMP") : "";
                            BaseLogger.log("3", userInfo, editorId, "** plan_Date [" + plan_Date + "] Cal_Comp [" + Cal_Comp + "]");
                            responseStr = this.getXMLDataForDetail(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, editor, userInfo);
                            BaseLogger.log("3", userInfo, editorId, "response from getXMLDataForDetail responseStr[" + responseStr + "]");
                        }
                        String event = "get_detail_data";
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        if ((userEventLogEJB = new UserEventLogEJB()) != null && userInfo != null) {
                            userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1, event, new Date(), new Date(), "pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues, "Success", "SA", "");
                        }
                        Document currentDetailNode = null;
                        if (responseStr != null && !responseStr.startsWith("Invalid row found") && !responseStr.startsWith("Tax not calculated")) {
                            currentDetailNode = new E12GenericUtility().parseString(responseStr);
                        }
                        if (responseStr.indexOf("<?xml version") == -1 && !responseStr.startsWith("Invalid row found") && !responseStr.startsWith("Tax not calculated")) {
                            responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + responseStr + "</Root>";
                            status = "success";
                        } else {
                            status = "error";
                        }
                        JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                        result = jsonObject.toString();
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : getXmlDataDetails : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "getXmlDataDetails", params, tokenId, dataFormat, status, result, userInfo);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block51;
                    }
                    catch (Exception resultObj) {}
                    break block51;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "getXmlDataDetails", params, tokenId, dataFormat, status, result, userInfo);
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception resultObj) {
                    // empty catch block
                }
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "getXmlDataDetails", params, tokenId, dataFormat, status, result, userInfo);
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        e12ExtServiceUtility.writeAPICallLog("getXmlDataDetails ( VisionOBJService/getXmlDataDetails )", status, result, appId, request, userInfo);
        return result;
    }

    String getXMLDataForDetail(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr, String user, String editor, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, editorId, "[RequestHandlerServlet]Getting detail xml string for objName :" + objName + ":\n\tpkValues :" + pkValues + ":\n\targFieldValues :" + argFieldValues);
        String retXMLStr = "";
        try {
            BaseLogger.log("3", userInfo, editorId, "get masterRem from session for editorId " + editorId);
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            if (transEditorCoreModel == null) {
                BaseLogger.log("3", null, null, "transEditorCoreModel getting null from session");
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            if (userInfo != null && masterRem != null) {
                boolean isValid;
                E12GenericUtility e12GenericUtility;
                Document dom;
                String plan_Date = "";
                String Cal_Comp = "";
                String tempEditorID = this.getStatefulEditorId(editorId, user);
                masterRem.setEditorId(tempEditorID);
                masterRem.setEditor(editor);
                masterRem.setPlanDate(plan_Date);
                masterRem.setCalComp(Cal_Comp);
                String currObjContext = masterRem.getObjContext();
                String currDomId = masterRem.getDetailDomId();
                String headerPKFieldValues = masterRem.getHeaderPKFieldValues();
                String xmlStr = masterRem.getDetailDomData();
                if (currObjContext != null && !currObjContext.equals("1") && objContext != null && objContext.equals(currObjContext) && E12GenericUtility.checkNull(xmlStr).length() > 0 && (dom = (e12GenericUtility = new E12GenericUtility()).parseString(xmlStr)) != null) {
                    Node detailNode = null;
                    String headerPKValues = "";
                    if (headerPKFieldValues != null && headerPKFieldValues.lastIndexOf(":") == headerPKFieldValues.length() - 1) {
                        headerPKValues = headerPKFieldValues.substring(0, headerPKFieldValues.lastIndexOf(":"));
                    }
                    String id = String.valueOf(currObjContext) + ":" + currDomId + ":" + headerPKValues;
                    BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail  detailNode id : [" + id + "]");
                    try {
                        XPathFactory xpf = XPathFactory.newInstance();
                        XPath xpath = xpf.newXPath();
                        XPathExpression expression = xpath.compile("//Detail" + currObjContext + "[@id='" + id + "']");
                        detailNode = (Node)expression.evaluate(dom, XPathConstants.NODE);
                    }
                    catch (Exception e) {
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail Exception in getting detailNode using Xpath : [" + E12GenericUtility.getStackTrace(e) + "]");
                    }
                    if (detailNode != null) {
                        String taxcalcstat;
                        String valdatastat;
                        Node valdatastatNode = detailNode.getAttributes().getNamedItem("valdatastat");
                        if (valdatastatNode != null && ("0".equalsIgnoreCase(valdatastat = E12GenericUtility.checkNull(valdatastatNode.getNodeValue())) || "1".equalsIgnoreCase(valdatastat) || "2".equalsIgnoreCase(valdatastat))) {
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail valdatastat : [" + valdatastat + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail objContext : [" + objContext + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail currObjContext : [" + currObjContext + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail currDomId : [" + currDomId + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail headerPKFieldValues : [" + headerPKFieldValues + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail xmlStr : [" + xmlStr + "]");
                            retXMLStr = "Invalid row found against domId = " + currDomId + ". So please validate the current row and then add a new one.~~" + currDomId;
                            BaseLogger.log("3", userInfo, editorId, "Invalid row found in server side when adding new row :::[" + retXMLStr + "]");
                            return retXMLStr;
                        }
                        Node taxcalcstatNode = detailNode.getAttributes().getNamedItem("taxcalcstat");
                        if (taxcalcstatNode != null && ("1".equalsIgnoreCase(taxcalcstat = E12GenericUtility.checkNull(taxcalcstatNode.getNodeValue())) || "2".equalsIgnoreCase(taxcalcstat) || "3".equalsIgnoreCase(taxcalcstat))) {
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail taxcalcstat : [" + taxcalcstat + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail objContext : [" + objContext + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail currObjContext : [" + currObjContext + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail currDomId : [" + currDomId + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail headerPKFieldValues : [" + headerPKFieldValues + "]");
                            BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet getXMLDataForDetail xmlStr : [" + xmlStr + "]");
                            retXMLStr = "Tax not calculated against domId = " + currDomId + ". So please validate the current row and then add a new one.~~" + currDomId;
                            BaseLogger.log("3", userInfo, editorId, "Invalid row found in server side when adding new row :::[" + retXMLStr + "]");
                            return retXMLStr;
                        }
                    }
                }
                String valXMLStr = chgStr != null && chgStr.length() > 0 ? masterRem.validateAndPerformAction(chgStr, "VAL_DATA") : "";
                boolean bl = isValid = valXMLStr.indexOf("<Errors>") == -1;
                if (isValid) {
                    String string = valXMLStr = valXMLStr.indexOf("<?xml version=") != -1 ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr;
                    if (reqParamStr != null && reqParamStr.trim().length() > 0) {
                        masterRem.setRequestParamStr(reqParamStr.trim());
                    }
                    BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet valXMLStr[" + valXMLStr + "]");
                    retXMLStr = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
                    BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]");
                    String string2 = retXMLStr = retXMLStr.indexOf("<?xml version=") != -1 ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr;
                    if (chgStr != null && chgStr.length() > 0) {
                        retXMLStr = "<?xml version='1.0' encoding='" + userInfo.getCharEnc() + "' ?><Data><ValData>" + valXMLStr + "</ValData>" + retXMLStr + "</Data>";
                    }
                    masterRem.setRequestParamStr(null);
                } else {
                    retXMLStr = valXMLStr;
                }
            } else {
                retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork");
            }
            if (masterRem != null && editFlag.equals("V")) {
                masterRem.remove();
                masterRem = null;
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    String setActionForDuplicateTransaction(String objName, String objContext, String pkValues, HttpSession sess, String editorId, String user, String editor, UserInfoBean userInfo) throws ITMException {
        String retXMLStr = "";
        try {
            String tempEditorID = this.getStatefulEditorId(editorId, user);
            ITMTransactionCoreModel itmTransCoreMdl = (ITMTransactionCoreModel)sess.getAttribute(tempEditorID);
            BaseLogger.log("3", userInfo, editorId, "Session attributes==>" + sess.getAttribute(tempEditorID));
            if (itmTransCoreMdl == null) {
                BaseLogger.log("3", userInfo, editorId, "ITMTransactionCoreModel can not get from sess");
                itmTransCoreMdl = new ITMTransactionCoreModel();
                itmTransCoreMdl.setObjName(objName);
                itmTransCoreMdl.setUserInfo(userInfo);
                ITMTransactionHeaderModel itmTransHdrMdl = (ITMTransactionHeaderModel)sess.getAttribute("itmTransHdrMdl");
                if (itmTransHdrMdl != null) {
                    itmTransCoreMdl.setITMFilterModel(itmTransHdrMdl.getITMFilterModel());
                }
                sess.setAttribute(tempEditorID, (Object)itmTransCoreMdl);
            }
            itmTransCoreMdl.masterStateful.setEditorId(tempEditorID);
            itmTransCoreMdl.setCoreModelId(Integer.parseInt(tempEditorID));
            itmTransCoreMdl.setPKValues(pkValues);
            itmTransCoreMdl.setEditFlag("A");
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            if (transEditorCoreModel == null) {
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setMasterStateful(itmTransCoreMdl.masterStateful);
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            if (userInfo != null && masterRem != null) {
                masterRem.setEditorId(tempEditorID);
                masterRem.setTransCopy(true);
                masterRem.setCurrentDetailValidated(true);
                if (pkValues != null && !itmTransCoreMdl.isTransCopied()) {
                    retXMLStr = masterRem.getTransCopyXMLString(objName, objContext, pkValues, null, false);
                    itmTransCoreMdl.setTransCopied(true);
                } else {
                    retXMLStr = masterRem.getDetailDomData();
                }
                masterRem.setTransCopy(false);
            } else {
                retXMLStr = String.valueOf(Messages.getString("E12EditorHandlerServlet_notLoggedOrSessionHasExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork.");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            BaseLogger.log("0", userInfo, editorId, "Exception :E12EditorHandlerServlet :setActionForDuplicateTransaction :==>");
        }
        return retXMLStr;
    }

    public String validateAndDone(String objName, String formNo, String objContext, String domId, String action, String editor, String chgData, String pkValues, String editFlag, String editorId, HttpServletRequest request, HttpHeaders header, HttpServletResponse response) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block54: {
            BaseLogger.log("3", null, null, "Inside validateAndDone ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "validateAndDone() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "validateAndDone() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "validateAndDone() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "validateAndDone() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "validateAndDone() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "validateAndDone() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("validateAndDone", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "validateAndDone() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "validateAndDone");
                            BaseLogger.log("3", null, null, "validateAndDone() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "validateAndDone() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (chgData == null || chgData.equals(null) || chgData.length() <= 0) {
                        result = new JSONObject().put("Message", (Object)"Please pass form data").toString();
                        status = "Error";
                        isError = true;
                    }
                    JSONObject formDataObj = null;
                    try {
                        formDataObj = new JSONObject(chgData);
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "Error converting json=  " + e.getMessage());
                        result = new JSONObject().put("Message", (Object)"Please pass form data in JSON Format").toString();
                        status = "Error";
                        isError = true;
                    }
                    if (!isError) {
                        Date startTime = new Date();
                        String pageContext = "2";
                        String focusedColumn = "";
                        String elementName = "";
                        String keyValue = "1";
                        String taxKeyValue = "";
                        String saveLevel = "0";
                        String forceSave = "false";
                        String taxInFocus = "false";
                        String forcedconfirm = "false";
                        String isChange = "Y";
                        String pkNames = "";
                        String fieldName = "";
                        String responseStr = "";
                        HttpSession sess = request.getSession(false);
                        sess.setMaxInactiveInterval(300);
                        String userId = userInfo.getLoginCode();
                        editorId = String.valueOf(editorId) + userId;
                        String chgStr = this.generateChgXML(formDataObj, objName, pageContext, objContext, editFlag, focusedColumn, elementName, keyValue, taxKeyValue, saveLevel, forceSave, taxInFocus, forcedconfirm, formNo, domId, isChange, pkNames);
                        BaseLogger.log("3", null, null, "validate and done chg_xml = " + chgStr);
                        String chgIP = request.getHeader("X-Forwarded-For");
                        if (chgIP == null) {
                            chgIP = request.getRemoteAddr();
                        }
                        String action1 = action;
                        E12GenericUtility genericutility = new E12GenericUtility();
                        if (forceSave != null && forceSave.equalsIgnoreCase("true")) {
                            chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
                        }
                        String argFieldValues = request.getParameter("ARG_VALUES");
                        String reqParamStr = request.getParameter("REQ_PARAM_STR");
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet FORM_NO[" + formNo + "] objContext[" + objContext + "] editFlag[" + editFlag + "]");
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet CHG_STR[" + request.getParameter("CHG_STR") + "]");
                        action1 = "A".equalsIgnoreCase(editFlag) ? "ADD" : ("V".equalsIgnoreCase(editFlag) ? "VIEW" : "EDIT");
                        if ("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0)) {
                            action1 = "ADD";
                        }
                        if (pkValues != null && pkValues.trim().length() > 0 && !pkValues.equalsIgnoreCase("null") && "A".equalsIgnoreCase(editFlag) && Integer.parseInt(objContext) == 1) {
                            startTime = new Date();
                            responseStr = this.setActionForDuplicateTransaction(objName, objContext, pkValues, sess, editorId, userId, editor, userInfo);
                        } else {
                            startTime = new Date();
                            responseStr = this.getXMLDataOnDelete(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId, userInfo);
                            BaseLogger.log("3", userInfo, editorId, "response from getXMLDataForDetail responseStr[" + responseStr + "]");
                        }
                        String event = "get_detail_data";
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
                        int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + formNo).getLength();
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet Action [ADD_DETAIL_DOM] totalDetailNodes[" + totalDetailNodes + "]");
                        NodeList errorNodeList = null;
                        int errorNodeListLen = 0;
                        if (responseStr != null && responseStr.length() > 0) {
                            errorNodeList = genericutility.parseString(responseStr).getElementsByTagName("error");
                        }
                        if (errorNodeList != null) {
                            errorNodeListLen = errorNodeList.getLength();
                        }
                        String finalRespStr = "";
                        if (totalDetailNodes > 0) {
                            int i = 0;
                            while (i < totalDetailNodes) {
                                if (currentDetailNode.getElementsByTagName("Detail" + formNo).item(i) != null) {
                                    responseStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Detail" + formNo).item(i));
                                    BaseLogger.log("3", userInfo, editorId, "errorNodeListLen...1610[" + errorNodeListLen + "]");
                                    if (errorNodeListLen == 0) {
                                        finalRespStr = String.valueOf(finalRespStr) + responseStr;
                                    }
                                }
                                ++i;
                            }
                        }
                        String detailXmlString = "";
                        boolean isErrorPresent = false;
                        int j = 0;
                        while (j < errorNodeListLen) {
                            if (currentDetailNode.getElementsByTagName("error").item(j) != null) {
                                Node errorNode = currentDetailNode.getElementsByTagName("error").item(j);
                                Node typeNode = errorNode.getAttributes().getNamedItem("type");
                                String typeNodeValue = typeNode.getNodeValue();
                                Node columnNode = errorNode.getAttributes().getNamedItem("column_name");
                                String columnVlaue = "";
                                if (columnNode != null) {
                                    columnVlaue = columnNode.getNodeValue();
                                }
                                BaseLogger.log("3", userInfo, editorId, "InE12EditorHandlerServlet typeNodeValue..1595[" + typeNodeValue + "] columnVlaue[" + columnVlaue + "]");
                                finalRespStr = String.valueOf(finalRespStr) + "<Errors>" + new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("error").item(j)) + "</Errors>";
                                isErrorPresent = true;
                            }
                            ++j;
                        }
                        BaseLogger.log("3", null, null, "isErrorPresent = " + isErrorPresent);
                        if (!isErrorPresent) {
                            detailXmlString = this.getDetailData(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId, userInfo);
                            BaseLogger.log("3", null, null, "detailXmlString = " + detailXmlString);
                            Document allDetailNode = new E12GenericUtility().parseString(detailXmlString);
                            detailXmlString = "";
                            int detailNodes = allDetailNode.getElementsByTagName("Detail" + formNo).getLength();
                            if (detailNodes > 0) {
                                int i = 0;
                                while (i < detailNodes) {
                                    if (allDetailNode.getElementsByTagName("Detail" + formNo).item(i) != null) {
                                        String singleDetailString = "";
                                        singleDetailString = new E12GenericUtility().serializeDom(allDetailNode.getElementsByTagName("Detail" + formNo).item(i));
                                        detailXmlString = String.valueOf(detailXmlString) + singleDetailString;
                                    }
                                    ++i;
                                }
                            }
                        }
                        finalRespStr = String.valueOf(finalRespStr) + detailXmlString;
                        BaseLogger.log("3", null, null, "finalRespStr = " + finalRespStr);
                        BaseLogger.log("3", null, null, "detailXmlString = " + detailXmlString);
                        responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
                        JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                        result = jsonObject.toString();
                        status = finalRespStr.equals("") ? "success" : "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : validateAndNext : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "validateAndNext", params, tokenId, dataFormat, status, result, userInfo);
                    break block54;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "validateAndNext", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "validateAndNext", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("validateAndNext ( VisionOBJService/validateAndNext )", status, result, appId, request, userInfo);
        return result;
    }

    String getDetailData(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr, String user, String action, String domID, UserInfoBean userInfo) throws ITMException {
        String retXMLStr = "";
        try {
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            if (transEditorCoreModel == null) {
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            if (userInfo != null && masterRem != null) {
                String tempEditorID = this.getStatefulEditorId(editorId, user);
                masterRem.setEditorId(tempEditorID);
                String valXMLStr = "";
                if (reqParamStr != null && reqParamStr.trim().length() > 0) {
                    masterRem.setRequestParamStr(reqParamStr.trim());
                }
                retXMLStr = masterRem.getDataXML(objContext, domID, "E", "1");
                BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]");
                String string = retXMLStr = retXMLStr.indexOf("<?xml version=") != -1 ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr;
                if (chgStr != null && chgStr.length() > 0) {
                    retXMLStr = "<?xml version='1.0' encoding='" + userInfo.getCharEnc() + "' ?><Data>" + retXMLStr + "</Data>";
                }
                masterRem.setRequestParamStr(null);
            } else {
                retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork");
            }
            if (masterRem != null && editFlag.equals("V")) {
                masterRem.remove();
                masterRem = null;
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :RequestHandlerServlet :getXMLDataForDetail :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    public String validateAndPrevious(String objName, String formType, String chgData, String objContext, String editFlag, String pkValues, String editorId, String formNo, String editor, String domId, String action, HttpHeaders header, HttpServletResponse response, HttpServletRequest request) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block56: {
            BaseLogger.log("3", null, null, "Inside validateAndPrevious ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "validateAndPrevious() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "validateAndPrevious() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "validateAndPrevious() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "validateAndPrevious() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "validateAndPrevious() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "validateAndPrevious() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("validateAndPrevious", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "validateAndPrevious() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "validateAndPrevious");
                            BaseLogger.log("3", null, null, "validateAndPrevious() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "validateAndPrevious() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (chgData == null || chgData.equals(null) || chgData.length() <= 0) {
                        result = new JSONObject().put("Message", (Object)"Please pass form data").toString();
                        status = "Error";
                        isError = true;
                    }
                    JSONObject formDataObj = null;
                    try {
                        formDataObj = new JSONObject(chgData);
                    }
                    catch (Exception e) {
                        System.out.println("Error converting json=  " + e.getMessage());
                        result = new JSONObject().put("Message", (Object)"Please pass form data in JSON Format").toString();
                        status = "Error";
                        isError = true;
                    }
                    if (!isError) {
                        UserEventLogEJB userEventLogEJB;
                        String pageContext = "1";
                        String focusedColumn = "";
                        String elementName = "";
                        String keyValue = "1";
                        String taxKeyValue = "";
                        String saveLevel = "0";
                        String forceSave = "false";
                        String taxInFocus = "false";
                        String forcedconfirm = "false";
                        String isChange = "Y";
                        String pkNames = "";
                        Date startTime = new Date();
                        String fieldName = "";
                        String responseStr = "";
                        HttpSession sess = request.getSession(false);
                        sess.setMaxInactiveInterval(300);
                        String chgStr = this.generateChgXML(formDataObj, objName, pageContext, "1", editFlag, focusedColumn, elementName, keyValue, taxKeyValue, saveLevel, forceSave, taxInFocus, forcedconfirm, formNo, domId, isChange, pkNames);
                        BaseLogger.log("3", null, null, "validateAndPrevious chg_xml = " + chgStr);
                        if (this.checkNull(editor).length() == 0) {
                            editor = "MobEditor";
                        }
                        if (this.checkNull(action).length() == 0) {
                            action = "PREVIOUS";
                        }
                        String userId = userInfo.getLoginCode();
                        editorId = String.valueOf(editorId) + userId;
                        String chgIP = request.getHeader("X-Forwarded-For");
                        if (chgIP == null) {
                            chgIP = request.getRemoteAddr();
                        }
                        String action1 = action;
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet FORM_NO[" + formNo + "] objContext[" + objContext + "] editFlag[" + editFlag + "]");
                        action1 = "A".equalsIgnoreCase(editFlag) ? "ADD" : ("V".equalsIgnoreCase(editFlag) ? "VIEW" : "EDIT");
                        if ("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0)) {
                            action1 = "ADD";
                        }
                        String tempEditorID = this.getStatefulEditorId(editorId, userId);
                        String event = "get_detail_data";
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        if ((userEventLogEJB = new UserEventLogEJB()) != null && userInfo != null) {
                            userEventLogEJB.setEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1, event, startTime, null, "pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues, "Pending", "SA", "");
                        }
                        if (pkValues != null && pkValues.trim().length() > 0 && !pkValues.equalsIgnoreCase("null") && "A".equalsIgnoreCase(editFlag) && Integer.parseInt(objContext) == 1) {
                            responseStr = this.setActionForDuplicateTransaction(objName, objContext, pkValues, sess, editorId, userId, editor, userInfo);
                        } else {
                            startTime = new Date();
                            E12GenericUtility genericutility = new E12GenericUtility();
                            if (forceSave != null && forceSave.equalsIgnoreCase("true")) {
                                chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
                            }
                            String argFieldValues = request.getParameter("ARG_VALUES");
                            String reqParamStr = request.getParameter("REQ_PARAM_STR");
                            responseStr = this.getXMLDataOnPrevious(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId, userInfo);
                            BaseLogger.log("3", userInfo, editorId, "response from getXMLDataOnPrevious responseStr[" + responseStr + "]");
                        }
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        if (userEventLogEJB != null && userInfo != null) {
                            userEventLogEJB.updateEventLog(userInfo.getLoginCode(), objName, userInfo.getSesstionId(), tempEditorID, action1, event, startTime, new Date(), "pkValues:[" + pkValues + "], objContext:[" + objContext + "], ", pkValues, "Success", "SA", "");
                        }
                        Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
                        int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + formNo).getLength();
                        E12GenericUtility genericutility = new E12GenericUtility();
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet Action [PREVIOUS] totalDetailNodes[" + totalDetailNodes + "]");
                        String finalRespStr = "";
                        if (totalDetailNodes > 0) {
                            int i = 0;
                            while (i < totalDetailNodes) {
                                if (currentDetailNode.getElementsByTagName("Detail" + formNo).item(i) != null) {
                                    responseStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Detail" + formNo).item(i));
                                    finalRespStr = String.valueOf(finalRespStr) + responseStr;
                                }
                                ++i;
                            }
                        } else if (currentDetailNode.getElementsByTagName("Errors").item(0) != null) {
                            finalRespStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Errors").item(0));
                        }
                        responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
                        BaseLogger.log("3", userInfo, editorId, "with final responseStr [" + responseStr + "]");
                        JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                        result = jsonObject.toString();
                        status = finalRespStr.equals("") ? "success" : "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : validateAndPrevious : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "validateAndPrevious", params, tokenId, dataFormat, status, result, userInfo);
                    break block56;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "validateAndPrevious", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "validateAndPrevious", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("validateAndPrevious ( VisionOBJService/validateAndPrevious )", status, result, appId, request, userInfo);
        return result;
    }

    String getXMLDataOnPrevious(String objName, String objContext, String editFlag, String pkValues, String chgStr, String argFieldValues, HttpSession sess, String editorId, String reqParamStr, String user, String action, String domID, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, editorId, "[getXMLDataOnPrevious]Getting detail xml string on previous for objName :" + objName + ":\n\tpkValues :" + pkValues + ":\n\targFieldValues :" + argFieldValues);
        String retXMLStr = "";
        try {
            E12TransEditorCoreModel transEditorCoreModel = (E12TransEditorCoreModel)sess.getAttribute(editorId);
            if (transEditorCoreModel == null) {
                transEditorCoreModel = new E12TransEditorCoreModel(objName);
                transEditorCoreModel.setUserInfo(userInfo);
                transEditorCoreModel.setObjName(objName);
                sess.setAttribute(editorId, (Object)transEditorCoreModel);
            }
            MasterStatefulRemote masterRem = transEditorCoreModel.getMasterStateful();
            if (userInfo != null && masterRem != null) {
                boolean isValid;
                String tempEditorID = this.getStatefulEditorId(editorId, user);
                masterRem.setEditorId(tempEditorID);
                String valXMLStr = chgStr != null && chgStr.length() > 0 ? masterRem.validateAndPerformAction(chgStr, "VAL_DATA") : "";
                boolean bl = isValid = valXMLStr.indexOf("<Errors>") == -1;
                if (isValid) {
                    String string = valXMLStr = valXMLStr.indexOf("<?xml version=") != -1 ? valXMLStr.substring(valXMLStr.indexOf(">") + 1) : valXMLStr;
                    if (reqParamStr != null && reqParamStr.trim().length() > 0) {
                        masterRem.setRequestParamStr(reqParamStr.trim());
                    }
                    if (!"V".equalsIgnoreCase(editFlag)) {
                        BaseLogger.log("3", userInfo, editorId, "inside getXMLDataOnPrevious... objContext[" + objContext + "]");
                        retXMLStr = masterRem.getCurrentFormDetail(objContext);
                        BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]]]]");
                    } else {
                        retXMLStr = masterRem.getDetailXMLDomString(objName, objContext, editFlag, pkValues, argFieldValues, true);
                        BaseLogger.log("3", userInfo, editorId, "retXMLStr [" + retXMLStr + "]");
                    }
                    String string2 = retXMLStr = retXMLStr.indexOf("<?xml version=") != -1 ? retXMLStr.substring(retXMLStr.indexOf(">") + 1) : retXMLStr;
                    if (chgStr != null && chgStr.length() > 0) {
                        retXMLStr = "<?xml version='1.0' encoding='" + userInfo.getCharEnc() + "' ?><Data>" + retXMLStr + "</Data>";
                    }
                    masterRem.setRequestParamStr(null);
                } else {
                    retXMLStr = valXMLStr;
                }
            } else {
                retXMLStr = String.valueOf(Messages.getString("RequestHandlerServlet_notLoggedOrSessionExpired")) + "\n" + Messages.getString("RequestHandlerServlet_pleaseReconnectToWork");
            }
            if (masterRem != null && editFlag.equals("V")) {
                masterRem.remove();
                masterRem = null;
            }
        }
        catch (ITMException itme) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "ITMException :getXMLDataOnPrevious :getXMLDataOnPrevious :==>");
            throw itme;
        }
        catch (Exception e) {
            sess.setAttribute("ERR_MSG", (Object)"INVALID_DETAIL_DATA");
            BaseLogger.log("0", userInfo, editorId, "Exception :getXMLDataOnPrevious :getXMLDataForDetail :==>");
            throw new ITMException(e);
        }
        return retXMLStr;
    }

    public String validateAndDelete(String objName, String formNo, String objContext, String domId, String action, String editorId, String chgData, String pkValues, String editFlag, String editor, HttpHeaders header, HttpServletResponse response, HttpServletRequest request) {
        UserInfoBean userInfo;
        E12ExtServiceUtility e12ExtServiceUtility;
        String appId;
        String status;
        String result;
        block45: {
            BaseLogger.log("3", null, null, "Inside validateAndDelete ");
            result = "";
            String params = "";
            status = "error";
            String tokenId = "";
            String dataFormat = "JSON";
            appId = "";
            boolean isError = false;
            e12ExtServiceUtility = new E12ExtServiceUtility();
            RestAPIServiceUtility restapiserviceutility = new RestAPIServiceUtility();
            APIUtility apiUtility = new APIUtility();
            userInfo = null;
            try {
                try {
                    tokenId = e12ExtServiceUtility.getTokenFromHeaders(header);
                    BaseLogger.log("3", null, null, "validateAndDelete() TOKENID length=" + tokenId.length());
                    if (tokenId.length() == 0) {
                        status = "Reject";
                        result = "Blank Token ID passed.";
                        isError = true;
                        BaseLogger.log("3", null, null, "validateAndDelete() TOKENID length return error" + tokenId.length());
                    }
                    if (!isError) {
                        userInfo = this.getUserInfo(request, tokenId);
                    }
                    if (!isError && userInfo == null) {
                        status = "Reject";
                        result = "User not allowed.";
                        isError = true;
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        appId = apiUtility.getAppIdFromJWTToken(tokenId);
                    }
                    if (!(isError || appId != null && appId.length() != 0)) {
                        status = "Reject";
                        result = "Blank APPID passed.";
                        isError = true;
                    }
                    BaseLogger.log("3", null, null, "validateAndDelete() appId=" + appId);
                    params = request.getQueryString();
                    BaseLogger.log("3", null, null, "validateAndDelete() request.getQueryString() " + request.getQueryString());
                    if (this.checkNull(params).length() == 0) {
                        StringBuffer paramString = new StringBuffer();
                        paramString.append("&TOKEN_ID=" + tokenId);
                        paramString.append("&OBJ_NAME=" + objName);
                        params = paramString.toString();
                    }
                    BaseLogger.log("3", null, null, "validateAndDelete() params=" + params);
                    if (!isError && !appId.equals("FLUTTERAPP")) {
                        BaseLogger.log("3", null, null, "validateAndDelete() none flutter APP");
                        ExtAuthAppAPIBean authAppAPIBean = restapiserviceutility.getCommonDBAccess().getAuthAppAPIDetails("validateAndDelete", appId);
                        if (authAppAPIBean == null) {
                            status = "Reject";
                            result = "This service not available for given APPID";
                            isError = true;
                            BaseLogger.log("3", null, null, "validateAndDelete() none flutter result=" + result);
                        } else {
                            result = e12ExtServiceUtility.validateRequest(request, "JSON", tokenId, true, appId, "validateAndDelete");
                            BaseLogger.log("3", null, null, "validateAndDelete() result=" + result);
                            if ("valid".equalsIgnoreCase(result)) {
                                if (apiUtility.checkDailyAPILimit(userInfo)) {
                                    status = "Reject";
                                    result = "Daily API call limit exceeded";
                                    isError = true;
                                    BaseLogger.log("3", null, null, "validateAndDelete() none flutter validation result=" + result);
                                }
                            } else {
                                status = "Reject";
                                isError = true;
                            }
                        }
                    }
                    if (!isError) {
                        String pageContext = "1";
                        String focusedColumn = "";
                        String elementName = "";
                        String keyValue = "1";
                        String taxKeyValue = "";
                        String saveLevel = "0";
                        String forceSave = "false";
                        String taxInFocus = "false";
                        String forcedconfirm = "false";
                        String isChange = "Y";
                        String pkNames = "";
                        Date startTime = new Date();
                        String fieldName = "";
                        String responseStr = "";
                        HttpSession sess = request.getSession(false);
                        sess.setMaxInactiveInterval(300);
                        String chgStr = this.generateChgXML(new JSONObject(), objName, pageContext, "2", editFlag, focusedColumn, elementName, keyValue, taxKeyValue, saveLevel, forceSave, taxInFocus, forcedconfirm, formNo, domId, isChange, pkNames);
                        BaseLogger.log("3", null, null, "validateAndDelete() chg_xml = " + chgStr);
                        if (this.checkNull(editor).length() == 0) {
                            editor = "MobEditor";
                        }
                        if (this.checkNull(action).length() == 0) {
                            action = "DESELECT";
                        }
                        String userId = userInfo.getLoginCode();
                        editorId = String.valueOf(editorId) + userId;
                        String chgIP = request.getHeader("X-Forwarded-For");
                        if (chgIP == null) {
                            chgIP = request.getRemoteAddr();
                        }
                        String action1 = action;
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet FORM_NO[" + formNo + "] objContext[" + objContext + "] editFlag[" + editFlag + "]");
                        action1 = "A".equalsIgnoreCase(editFlag) ? "ADD" : ("V".equalsIgnoreCase(editFlag) ? "VIEW" : "EDIT");
                        if ("EDIT".equalsIgnoreCase(action1) && (pkValues == null || pkValues.trim().length() == 0)) {
                            action1 = "ADD";
                        }
                        String tempEditorID = this.getStatefulEditorId(editorId, userId);
                        if (pkValues != null && pkValues.trim().length() > 0 && !pkValues.equalsIgnoreCase("null") && "A".equalsIgnoreCase(editFlag) && Integer.parseInt(objContext) == 1) {
                            responseStr = this.setActionForDuplicateTransaction(objName, objContext, pkValues, sess, editorId, userId, editor, userInfo);
                        } else {
                            startTime = new Date();
                            E12GenericUtility genericutility = new E12GenericUtility();
                            if (forceSave != null && forceSave.equalsIgnoreCase("true")) {
                                chgStr = genericutility.updateDataHeader(chgStr, forceSave, "forcedSave");
                            }
                            String argFieldValues = request.getParameter("ARG_VALUES");
                            String reqParamStr = request.getParameter("REQ_PARAM_STR");
                            responseStr = this.getXMLDataOnDelete(objName, objContext, editFlag, pkValues, chgStr, argFieldValues, sess, editorId, reqParamStr, userId, action, domId, userInfo);
                            BaseLogger.log("3", userInfo, editorId, "response from getXMLDataOnPrevious responseStr[" + responseStr + "]");
                        }
                        String event = "get_detail_data";
                        if (objContext != null && !"null".equalsIgnoreCase(objContext)) {
                            if (pkValues != null && !"null".equalsIgnoreCase(pkValues) && pkValues.trim().length() > 0 && !"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "EDIT";
                            } else if (!"1".equals(objContext)) {
                                if ("A".equalsIgnoreCase(editFlag)) {
                                    event = "ADD";
                                }
                                action1 = "ADD";
                            }
                        }
                        Document currentDetailNode = new E12GenericUtility().parseString(responseStr);
                        int totalDetailNodes = currentDetailNode.getElementsByTagName("Detail" + formNo).getLength();
                        BaseLogger.log("3", userInfo, editorId, "Inside E12EditorHandlerServlet Action [NEXT] totalDetailNodes[" + totalDetailNodes + "]");
                        String finalRespStr = "";
                        if (totalDetailNodes > 0) {
                            int i = 0;
                            while (i < totalDetailNodes) {
                                if (currentDetailNode.getElementsByTagName("Detail" + formNo).item(i) != null) {
                                    responseStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Detail" + formNo).item(i));
                                    finalRespStr = String.valueOf(finalRespStr) + responseStr;
                                }
                                ++i;
                            }
                        } else if (currentDetailNode.getElementsByTagName("Errors").item(0) != null) {
                            finalRespStr = new E12GenericUtility().serializeDom(currentDetailNode.getElementsByTagName("Errors").item(0));
                        }
                        responseStr = "<?xml version='1.0'?><Root><Header><editFlag>null</editFlag></Header><Errors></Errors>" + finalRespStr + "</Root>";
                        System.out.println("validateAndDelete() responseStr = " + responseStr);
                        JSONObject jsonObject = XML.toJSONObject((String)responseStr);
                        result = jsonObject.toString();
                        status = finalRespStr.equals("") ? "success" : "error";
                    }
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception : validateAndDelete : " + e.getMessage());
                    result = this.getStackTrace(e, dataFormat);
                    status = "exception";
                    if (tokenId.length() != 0 && userInfo == null) {
                        JSONObject resultObj = new JSONObject();
                        try {
                            resultObj.put("data", (Object)new JSONObject());
                            resultObj.put("error", (Object)"Invalid TOKEN");
                            resultObj.put("status", (Object)"Reject");
                            return resultObj.toString();
                        }
                        catch (JSONException e2) {
                            e2.printStackTrace();
                            return resultObj.toString();
                        }
                    }
                    result = this.generateResponse(request, "validateAndDelete", params, tokenId, dataFormat, status, result, userInfo);
                    break block45;
                }
            }
            catch (Throwable throwable) {
                if (tokenId.length() != 0 && userInfo == null) {
                    JSONObject resultObj = new JSONObject();
                    try {
                        resultObj.put("data", (Object)new JSONObject());
                        resultObj.put("error", (Object)"Invalid TOKEN");
                        resultObj.put("status", (Object)"Reject");
                        return resultObj.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                        return resultObj.toString();
                    }
                }
                result = this.generateResponse(request, "validateAndDelete", params, tokenId, dataFormat, status, result, userInfo);
                throw throwable;
            }
            if (tokenId.length() != 0 && userInfo == null) {
                JSONObject resultObj = new JSONObject();
                try {
                    resultObj.put("data", (Object)new JSONObject());
                    resultObj.put("error", (Object)"Invalid TOKEN");
                    resultObj.put("status", (Object)"Reject");
                    return resultObj.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return resultObj.toString();
                }
            }
            result = this.generateResponse(request, "validateAndDelete", params, tokenId, dataFormat, status, result, userInfo);
        }
        e12ExtServiceUtility.writeAPICallLog("validateAndDelete ( VisionOBJService/validateAndDelete )", status, result, appId, request, userInfo);
        return result;
    }
}

