package ibase.webitm.utility;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.activemq.artemis.api.jms.ActiveMQJMSConstants;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
 
public class JMSReceiver implements MessageListener 
{
	public final static String JMS_USERNAME=CommonConstants.JMS_USERNAME;       //  The role for this user is "guest" in ApplicationRealm
	public final static String JMS_PASSWORD=CommonConstants.JMS_PASSWORD;  
	public final static String JMS_CONNECTION_FACTORY=CommonConstants.JMS_CONNECTION_FACTORY;
	public final static String JMS_QUEUE=CommonConstants.JMS_QUEUE;
 
	private QueueConnectionFactory qconFactory;
	private QueueConnection qcon;
	private QueueSession qsession;
	private QueueReceiver qReceiver;
	private Queue queue;
	private boolean quit = false;
 
	public JMSReceiver() throws Exception 
	{
		JMSLogger.log("3",null,null,"JMS Ready To Receive Messages" );
	    init();
	    // Waiting until a "quit" message has been received.
	    synchronized( this ) 
	    {
	    	while( !this.quit ) 
	    	{
	    		try 
	    		{
	    			this.wait();
	            }
	            catch( InterruptedException ie ) 
         		{
	            	JMSLogger.log("3",null,null,"JMSReceiver.JMSReceiver() InterruptedException:[ "+ ie +"]" );
	            	ie.printStackTrace();
	            }
	    	}
	    }
		this.close();
	}
   
	public void init( ) throws NamingException, JMSException 
	{
		try 
		{
			JMSLogger.log("3",null,null,"JMSReceiver.init()");
			InitialContext ctx = new InitialContext();
			qconFactory = (QueueConnectionFactory) ctx.lookup( JMS_CONNECTION_FACTORY );
			qcon = qconFactory.createQueueConnection( JMSReceiver.JMS_USERNAME, JMSReceiver.JMS_PASSWORD );
			qsession = qcon.createQueueSession(false, ActiveMQJMSConstants.INDIVIDUAL_ACKNOWLEDGE);
			queue = (Queue) ctx.lookup( JMS_QUEUE );
			qReceiver = qsession.createReceiver( queue );
			qReceiver.setMessageListener( this );
			qcon.start();
		}
		catch (Exception e) 
		{
			JMSLogger.log("3",null,null,"JMSReceiver.init() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
		}
	}
 
	public void onMessage( Message message ) 
	{
		String recvdStatus = "S";
		E12GenericUtility genericUtility = new E12GenericUtility();
		String msgText = "";
		String msgType = "";    // Added by Rahul P. on 16-Jan-24 
		try 
		{
			msgType = ( (TextMessage)message ).getJMSType();	// Added by Rahul P. on 16-Jan-24 
			JMSLogger.log("3",null,null,"JMSReceiver.onMessage() Message Type :["+msgType+"]");
			//String msgText;
			if( message instanceof TextMessage ) 
			{
				JMSLogger.log("3",null,null,"JMSReceiver.onMessage() TextMessage");
				msgText = ( (TextMessage)message ).getText();
			}
			else 
			{
				JMSLogger.log("3",null,null,"JMSReceiver.onMessage() Message");
				msgText = message.toString();
			}
			//JMSLogger.log("3",null,null,"JMSReceiver.onMessage() Message :[ "+ msgText +"]" );
			if( msgText.equalsIgnoreCase("quit") ) 
			{
				JMSLogger.log("3",null,null,"JMSReceiver.onMessage() quit receiver");
				synchronized( this ) 
				{
					quit = true;
					this.notifyAll(); // Notify main thread to quit
				}
			}
			else
			{
				if( "WORKFLOW".equals( ( (TextMessage)message ).getJMSType()) )
				{
					JMSLogger.log("3",null,null,"JMSReceiver.onMessage() WORKFLOW start");
					JMSWorklFlowInvoker jmsWorklFlowInvoker = new JMSWorklFlowInvoker();
					jmsWorklFlowInvoker.invokeWorkFlow( msgText );
					jmsWorklFlowInvoker = null;
					message.acknowledge();
					JMSLogger.log("3",null,null,"JMSReceiver.onMessage() WORKFLOW completed");
				}
				else if( "UPDATE_DIRTY_DATAMODEL".equals(( (TextMessage)message ).getJMSType()) )
				{
					JMSLogger.log("3",null,null,"JMSReceiver.onMessage() UPDATE_DIRTY_DATAMODEL start");
					JMSUpdateDirtyDataModels jmsUpdateDirtyDataModels = new JMSUpdateDirtyDataModels();
					jmsUpdateDirtyDataModels.updateDirtyDataModels( msgText );
					jmsUpdateDirtyDataModels = null;
					message.acknowledge();
					JMSLogger.log("3",null,null,"JMSReceiver.onMessage() UPDATE_DIRTY_DATAMODEL completed");
				}
				else if( "FOLLOWUP_ACTIONS".equals(( (TextMessage)message ).getJMSType()) )
				{
					JMSLogger.log("3",null,null,"JMSReceiver.onMessage() FOLLOWUP_ACTIONS start111");
					JMSFollowupActions jmsFollowupActions = new JMSFollowupActions();
					jmsFollowupActions.executeFollowupactions(msgText); 
					jmsFollowupActions = null;
					message.acknowledge(); 
					JMSLogger.log("3",null,null,"JMSReceiver.onMessage() FOLLOWUP_ACTIONS completed111");
				}
				//Changed by Prasad on 15/02/2021 [Used for EDI data write] START
				else if( "FOLLOWUP_EDI_SERVICE".equals(( (TextMessage)message ).getJMSType()) )
				{
					JMSLogger.log( "3", null, null, "JMSReceiver.onMessage() FOLLOWUP_EDI_SERVICE start" );
					JMSFollowupActions jmsFollowUpEDIService = new JMSFollowupActions();
					jmsFollowUpEDIService.executeFollowUpEDIService( msgText );
					jmsFollowUpEDIService = null;
					message.acknowledge();
					JMSLogger.log( "3", null, null, "JMSReceiver.onMessage() FOLLOWUP_EDI_SERVICE completed" );
				}
				//Changed by Prasad on 15/02/2021 [Used for EDI data write] END
			}
		}
		catch ( ITMException itmException )
		{
			recvdStatus = "E";
			JMSLogger.log("3",null,null,"JMSReceiver.onMessage() ITMException:[ " + itmException.getMessage() + "]");
			try 
			{
				message.acknowledge();
			} 
			catch (JMSException e)
			{
				e.printStackTrace();
			}
		}
		catch (JMSException jmse)
		{
			recvdStatus = "E";
			JMSLogger.log("3",null,null,"JMSReceiver.onMessage() JMSException:[ " + E12GenericUtility.getStackTrace(jmse) + "]");
			try 
			{
				message.acknowledge();
			} 
			catch (JMSException e) 
			{
				e.printStackTrace();
			}
		}
		catch (Exception e) 
		{
			recvdStatus = "E";
			JMSLogger.log("3",null,null,"JMSReceiver.onMessage() Exception:[ " + E12GenericUtility.getStackTrace(e) + "]");
			try 
			{
				message.acknowledge();
			} 
			catch (JMSException e1)
			{
				e1.printStackTrace();
			}
		}
		// Added by Rahul P. on 26-Dec-23 to add Log in JMS_LOGS table -- [START]
		finally {
			try 
			{
				JMSLogger.log("3",null,null,"JMSReceiver.onMessage() => inside finally block");
				genericUtility.jmsLog(msgText, "", recvdStatus, msgType); // changed by Rahul P. on 16-Jan-24 for WORKFLOW and UPDATE_DIRTY_DATAMODEL msgType
			} 
			catch (Exception e) 
			{
				JMSLogger.log("3",null,null,"In JMSReceiver.onMessage() => Exception in finally block :[ "+ E12GenericUtility.getStackTrace(e) +"]" );
			}
		}
		// Added by Rahul P. on 26-Dec-23 to add Log in JMS_LOGS table -- [END]
	}
 
	public void close() throws JMSException 
	{
		JMSLogger.log("3",null,null,"JMSReceiver.close()");
	    qReceiver.close();
	    qsession.close();
	    qcon.close();
	}
}