package ibase.webitm.ejb.wsfa.masters;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;

import java.rmi.RemoteException;
import java.util.*;
import java.text.*;
import java.sql.*;
import org.w3c.dom.*;

import javax.ejb.*;
import javax.naming.InitialContext;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class LocalityPrs extends ValidatorEJB implements LocalityPrsLocal,LocalityPrsRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
    public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

    public String preSave( String xmlString, String editFlag, String xtraParams, Connection conn )throws RemoteException,ITMException
	{

		System.out.println("LocalityPrs called");
		Document dom = null;
		try
		{
			System.out.println("xmlString in LocalityPrs :: preSave \n"+xmlString);
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = new E12GenericUtility().parseString(xmlString);
				executepreSave( dom, editFlag, xtraParams, conn );
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :LocalityPrs ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		String stationCodeDom = "";
		String localityCodeDom = "";
		String stanDescrDom = "";
		String selectSql = "";
		String updateSql = "";
		String oldStationCode = "";
		String oldStationDescr = "";
		String newStationDescr = "";
		String statusOld = "";
		String statusNew = "";
		String userId = "";
		String chgTerm = "";
		java.sql.Timestamp chgDate = null;

		int updCnt = 0;

		Statement stmt = null;
		ResultSet rs = null;
		PreparedStatement pstmtRoute = null;
		PreparedStatement pstmtSeries = null;
		PreparedStatement pstmtStockist = null;
		PreparedStatement pstmtChemist = null;

		try
		{
			conn.setAutoCommit(false);

			//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

			System.out.println("editFlag........::"+editFlag);

			chgDate = new java.sql.Timestamp(System.currentTimeMillis());
			userId	= genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");


			if ( dom != null )
			{
				stationCodeDom	= checkNull(genericUtility.getColumnValue("stan_code",dom));
				localityCodeDom	= checkNull(genericUtility.getColumnValue("locality_code",dom));
				stanDescrDom	= checkNull(genericUtility.getColumnValue("station_descr",dom));
				statusNew		= checkNull(genericUtility.getColumnValue("status",dom));

				System.out.println("stationCodeDom........::"+stationCodeDom);
				System.out.println("localityCodeDom.......::"+localityCodeDom);
				System.out.println("stanDescrDom..........::"+stanDescrDom);
				System.out.println("statusNew..........::"+statusNew);

				stmt = conn.createStatement();

				selectSql = "SELECT STAN_CODE, DESCR, STATUS FROM LOCALITY WHERE LOCALITY_CODE = '"+localityCodeDom+"'";
				System.out.println("selectSql........::"+selectSql);
				rs = stmt.executeQuery(selectSql);
				if ( rs.next() )
				{
					oldStationCode	= checkNull(rs.getString("STAN_CODE"));
					//oldStationDescr = checkNull(rs.getString("DESCR"));
					statusOld	= checkNull(rs.getString("STATUS"));
				}
				rs.close();
				rs = null;
				selectSql = "SELECT DESCR FROM STATION WHERE STAN_CODE = '"+stationCodeDom+"'";
				System.out.println("selectSql........::"+selectSql);
				rs = stmt.executeQuery(selectSql);
				if ( rs.next() )
				{
					newStationDescr = checkNull(rs.getString("DESCR"));
				}
				rs.close();
				rs = null;
				if ( !( oldStationCode.trim().equals(stationCodeDom.trim()) ) )
				{
					updateSql = "UPDATE SPRS_ROUTE SET STAN_CODE = '"+stationCodeDom+"' WHERE LOCALITY_CODE = '"+localityCodeDom+"'";
					System.out.println("updateSql........::"+updateSql);
					updCnt = stmt.executeUpdate(updateSql);
					if ( updCnt > 0 )
					{
						System.out.println("Updated into SPRS_ROUTE successfully.........::"+updCnt);
					}
					updateSql = "UPDATE STRG_CUSTOMER SET STAN_CODE = '"+stationCodeDom+"', CITY = '"+newStationDescr+"' "+
								"WHERE LOCALITY_CODE = '"+localityCodeDom+"'";
					System.out.println("updateSql........::"+updateSql);
					updCnt = stmt.executeUpdate(updateSql);
					if ( updCnt > 0 )
					{
						System.out.println("Updated into STRG_CUSTOMER STRG_CUSTOMER.........::"+updCnt);
					}
					updateSql = "UPDATE STRG_CUSTOMER SET RES_STAN_CODE = '"+stationCodeDom+"', RES_CITY = '"+newStationDescr+"' "+
								"WHERE RES_LOCALITY_CODE = '"+localityCodeDom+"'";
					System.out.println("updateSql........::"+updateSql);
					updCnt = stmt.executeUpdate(updateSql);
					if ( updCnt > 0 )
					{
						System.out.println("Updated into STRG_CUSTOMER successfully.........::"+updCnt);
					}
				}
				if ( (statusOld.trim().equalsIgnoreCase("A") ) && (statusNew.trim().equalsIgnoreCase("N")) )
				{
					String sprsCode = "";
					String routeId = "";
					updateSql = "UPDATE SPRS_ROUTE SET STATUS = 'N', REPLY_STATUS = '0', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? "+
								"WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
					pstmtRoute = conn.prepareStatement(updateSql);
					/* -- Not Required Gulzar - 23/08/10 [WS90SUN049]
					updateSql = "UPDATE STRG_SERIES SET STATUS = 'N', REPLY_STATUS = '0', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? "+
								"WHERE SALES_PERS = ? AND ROUTE_ID = ? ";
					pstmtSeries = conn.prepareStatement(updateSql);
					updateSql = "UPDATE SPRS_STOCKIST SET STATUS = 'N', REPLY_STATUS = '0', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? "+
								"WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
					pstmtStockist = conn.prepareStatement(updateSql);
					updateSql = "UPDATE SPRS_CHEMIST SET STATUS = 'N', REPLY_STATUS = '0', CHG_DATE = ?, CHG_USER = ?, CHG_TERM = ? "+
								"WHERE SPRS_CODE = ? AND ROUTE_ID = ? ";
					pstmtChemist = conn.prepareStatement(updateSql);
					*/
					selectSql = "SELECT SPRS_CODE, ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+localityCodeDom+"' AND STATUS = 'Y' ";
					stmt = conn.createStatement();
					rs = stmt.executeQuery(selectSql);
					while ( rs.next() )
					{
						sprsCode = rs.getString("SPRS_CODE");
						routeId = rs.getString("ROUTE_ID");
						pstmtRoute.setTimestamp( 1, chgDate );
						pstmtRoute.setString( 2, userId );
						pstmtRoute.setString( 3, chgTerm );
						pstmtRoute.setString( 4, sprsCode );
						pstmtRoute.setString( 5, routeId );
						updCnt = pstmtRoute.executeUpdate();
						pstmtRoute.clearParameters();
						if ( updCnt > 0 )
						{
							System.out.println("Updated into SPRS_ROUTE Sucessfully : updCnt : " + updCnt);
						}
						/* -- Not Required Gulzar - 23/08/10 [WS90SUN049]
						pstmtSeries.setTimestamp( 1, chgDate );
						pstmtSeries.setString( 2, userId );
						pstmtSeries.setString( 3, chgTerm );
						pstmtSeries.setString( 4, sprsCode );
						pstmtSeries.setString( 5, routeId );
						updCnt = pstmtSeries.executeUpdate();
						pstmtSeries.clearParameters();
						if ( updCnt > 0 )
						{
							System.out.println("Updated into STRG_SERIES Sucessfully : updCnt : " + updCnt);
						}
						pstmtStockist.setTimestamp( 1, chgDate );
						pstmtStockist.setString( 2, userId );
						pstmtStockist.setString( 3, chgTerm );
						pstmtStockist.setString( 4, sprsCode );
						pstmtStockist.setString( 5, routeId );
						updCnt = pstmtStockist.executeUpdate();
						pstmtStockist.clearParameters();
						if ( updCnt > 0 )
						{
							System.out.println("Updated into SPRS_STOCKIST Sucessfully : updCnt : " + updCnt);
						}
						pstmtChemist.setTimestamp( 1, chgDate );
						pstmtChemist.setString( 2, userId );
						pstmtChemist.setString( 3, chgTerm );
						pstmtChemist.setString( 4, sprsCode );
						pstmtChemist.setString( 5, routeId );
						updCnt = pstmtChemist.executeUpdate();
						pstmtChemist.clearParameters();
						if ( updCnt > 0 )
						{
							System.out.println("Updated into SPRS_CHEMIST Sucessfully : updCnt : " + updCnt);
						}
						*/
					}
					//End Gulzar - 07/06/10
					//Deactivated customer
					updateSql = "UPDATE STRG_CUSTOMER SET STATUS = 'N' WHERE LOCALITY_CODE = '"+localityCodeDom+"'";
					System.out.println("updateSql........::"+updateSql);
					updCnt = stmt.executeUpdate(updateSql);
					if ( updCnt > 0 )
					{
						System.out.println("Updated into STRG_CUSTOMER successfully.........::"+updCnt);
					}
				}//if ( !( statusOld.trim()
			}
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in LocalityPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in LocalityPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( pstmtRoute != null )
				{
					pstmtRoute.close();
					pstmtRoute = null;
				}
				if ( pstmtSeries != null )
				{
					pstmtSeries.close();
					pstmtSeries = null;
				}
				if ( pstmtStockist != null )
				{
					pstmtStockist.close();
					pstmtStockist = null;
				}
				if ( pstmtChemist != null )
				{
					pstmtChemist.close();
					pstmtChemist = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :LocalityPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		return input;
	}
}
