/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webService.MediaStreamer;
import ibase.webitm.ejb.DocumentHandlerEJB;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

@Path(value="/")
public class StreamingService {
    private final int chunk_size = 0x200000;
    @Context
    HttpServletRequest request;

    @HEAD
    @Path(value="/stream/{docId}")
    @Produces(value={"video/mp4"})
    public Response header(@PathParam(value="docId") String docId) {
        BaseLogger.log((String)"3", null, null, (Object)"@HEAD request received");
        File file = this.getFile(docId, this.getUserInfo());
        return Response.ok().status(206).header("Content-Length", (Object)file.length()).header("Accept-Ranges", (Object)"bytes").build();
    }

    @GET
    @Path(value="/stream/{docId}")
    @Produces(value={"video/mp4"})
    public Response stream(@PathParam(value="docId") String docId, @HeaderParam(value="Range") String range) throws Exception {
        File file = this.getFile(docId, this.getUserInfo());
        return this.buildStream(file, range);
    }

    private Response buildStream(File asset, String range) throws Exception {
        if (range == null) {
            BaseLogger.log((String)"3", null, null, (Object)"Request does not contain a range parameter!");
            StreamingOutput streamer = output -> {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try {
                        FileChannel inputChannel = new FileInputStream(asset).getChannel();
                        try {
                            try (WritableByteChannel outputChannel = Channels.newChannel(output);){
                                inputChannel.transferTo(0L, inputChannel.size(), outputChannel);
                            }
                            if (inputChannel == null) return;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputChannel == null) throw throwable;
                            inputChannel.close();
                            throw throwable;
                        }
                        inputChannel.close();
                        return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException io) {
                    BaseLogger.log((String)"3", null, null, (Object)io.getMessage());
                }
            };
            return Response.ok((Object)streamer).status(Response.Status.OK).header("Content-Length", (Object)asset.length()).build();
        }
        BaseLogger.log((String)"3", null, null, (Object)("Requested Range: " + range));
        String[] ranges = range.split("=")[1].split("-");
        int from = Integer.parseInt(ranges[0]);
        int to = 0x200000 + from;
        if ((long)to >= asset.length()) {
            to = (int)(asset.length() - 1L);
        }
        if (ranges.length == 2) {
            to = Integer.parseInt(ranges[1]);
        }
        String responseRange = String.format("bytes %d-%d/%d", from, to, asset.length());
        BaseLogger.log((String)"3", null, null, (Object)("Response Content-Range: " + responseRange + "\n"));
        RandomAccessFile raf = new RandomAccessFile(asset, "r");
        raf.seek(from);
        int len = to - from + 1;
        MediaStreamer mediaStreamer = new MediaStreamer(len, raf);
        return Response.ok((Object)mediaStreamer).status(206).header("Accept-Ranges", (Object)"bytes").header("Content-Range", (Object)responseRange).header("Content-Length", (Object)mediaStreamer.getLenth()).header("Last-Modified", (Object)new Date(asset.lastModified())).build();
    }

    private File getFile(String docId, UserInfoBean userInfo) {
        String dirName = "";
        String fileName = "";
        File file = null;
        try {
            if (CommonConstants.J2EE_VERSION.equals("1")) {
                dirName = String.valueOf(new File(CommonConstants.APPLICATION_CONTEXT).getParentFile().getParent()) + File.separator + "dump";
            } else if (CommonConstants.J2EE_VERSION.equals("2")) {
                dirName = new File(CommonConstants.JBOSSHOME) + File.separator + "dump";
            }
            fileName = String.valueOf(dirName) + File.separator + docId + ".mp4";
            BaseLogger.log((String)"3", null, null, (Object)("StreamingService getFile ::" + fileName));
            file = new File(fileName);
            if (!file.exists()) {
                BaseLogger.log((String)"3", null, null, (Object)("StreamingService file not exists ::" + fileName));
                DocumentHandlerEJB docHandler = new DocumentHandlerEJB();
                docHandler.setUserInfo(userInfo);
                fileName = docHandler.getDocumentFile(docId, userInfo.getTransDB());
                file = new File(fileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    private UserInfoBean getUserInfo() {
        UserInfoBean userInfo = null;
        HttpSession session = this.request.getSession();
        Object userObj = session.getAttribute("USER_INFO");
        BaseLogger.log((String)"3", null, null, (Object)(" StreamingService getUserInfo  userObj >>[" + userObj + "]"));
        if (userObj != null) {
            try {
                userInfo = new UserInfoBean(userObj.toString());
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return userInfo;
    }
}

