/*
 * Decompiled with CFR 0.152.
 */
package ibase.planner.bean;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataProvAdminBean {
    public ArrayList getDataProvidersDispName(Document dataProvider) {
        ArrayList<String> dataProvdrArrList = new ArrayList<String>();
        try {
            NodeList dataProviderNodeList = dataProvider.getElementsByTagName("DATA_PROVIDER");
            int dataProviderLen = dataProviderNodeList.getLength();
            int ctr = 0;
            while (ctr < dataProviderLen) {
                String dpName = dataProviderNodeList.item(ctr).getAttributes().getNamedItem("DISPLAY_NAME").getNodeValue();
                dataProvdrArrList.add(dpName);
                ++ctr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataProvdrArrList;
    }

    public String getNodeValue(Document dataProvider, String nodeName) {
        String defaultAddDP = "";
        try {
            Node defaultAddNode;
            NodeList defaultAddNodeList = dataProvider.getElementsByTagName(nodeName);
            if (defaultAddNodeList != null && (defaultAddNode = defaultAddNodeList.item(0)) != null && defaultAddNode.getFirstChild() != null) {
                defaultAddDP = defaultAddNode.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultAddDP;
    }

    public ArrayList getDataProvidersId(Document dataProvider) {
        ArrayList<String> dataProvdrArrList = new ArrayList<String>();
        try {
            NodeList dataProviderNodeList = dataProvider.getElementsByTagName("DATA_PROVIDER");
            int dataProviderLen = dataProviderNodeList.getLength();
            int ctr = 0;
            while (ctr < dataProviderLen) {
                String dpName = dataProviderNodeList.item(ctr).getAttributes().getNamedItem("PROVIDER_ID").getNodeValue();
                dataProvdrArrList.add(dpName);
                ++ctr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataProvdrArrList;
    }

    public ArrayList getDataProviderInfo(Document dataProvider, String dataPrvdrId) {
        BaseLogger.log("2", null, null, "DataProvAdminBean : getData Called ...");
        ArrayList dataProvdrArrList = new ArrayList();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            HashMap<String, String> dataProviderKeyName = new HashMap<String, String>();
            HashMap<String, String> dataProviderKeyValue = new HashMap<String, String>();
            NodeList dataProviderNodeList = dataProvider.getElementsByTagName("DATA_PROVIDER");
            int dataProviderLen = dataProviderNodeList.getLength();
            int ctr = 0;
            while (ctr < dataProviderLen) {
                String provID = dataProviderNodeList.item(ctr).getAttributes().getNamedItem("PROVIDER_ID").getNodeValue();
                if (dataPrvdrId.equalsIgnoreCase(provID)) {
                    String active = dataProvider.getElementById(String.valueOf(provID) + "_DS_ACTIVE").getFirstChild().getNodeValue();
                    dataProviderKeyName.put(String.valueOf(provID) + "_DS_ACTIVE", "STATUS");
                    dataProviderKeyValue.put(String.valueOf(provID) + "_DS_ACTIVE", active);
                    if (dataProvider.getElementById(String.valueOf(provID) + "_DS_UA") != null) {
                        NodeList userArgsNodeList = dataProvider.getElementById(String.valueOf(provID) + "_DS_UA").getChildNodes();
                        int userArgsNodeListLen = userArgsNodeList.getLength();
                        int innerCtr = 0;
                        while (innerCtr < userArgsNodeListLen) {
                            Node innerNode = userArgsNodeList.item(innerCtr);
                            if (innerNode.getNodeType() == 1) {
                                String usrArgName = innerNode.getAttributes().getNamedItem("DISPLAY_NAME").getNodeValue();
                                String usrArgId = innerNode.getAttributes().getNamedItem("NODE_ID").getNodeValue();
                                String usrArgVal = genericUtility.getColumnValueFromNode("VALUE", innerNode);
                                dataProviderKeyName.put(usrArgId, usrArgName);
                                dataProviderKeyValue.put(usrArgId, usrArgVal);
                            }
                            ++innerCtr;
                        }
                    }
                }
                ++ctr;
            }
            dataProvdrArrList.add(dataProviderKeyName);
            dataProvdrArrList.add(dataProviderKeyValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "dataProvdrArrList [" + dataProvdrArrList + "]");
        return dataProvdrArrList;
    }

    public Document getDataProviderDoc(String user, String calObjName, String dpSuffix) {
        Document dataProvider = null;
        try {
            String filePath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + user + File.separator;
            String fileName = String.valueOf(filePath) + calObjName + dpSuffix;
            BaseLogger.log("3", null, null, "fileName [" + fileName + "]");
            File dataProviderFile = new File(fileName);
            if (!dataProviderFile.exists()) {
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource").exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource").mkdir();
                }
                if (!new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + user).exists()) {
                    new File(String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + user).mkdir();
                }
                BaseLogger.log("3", null, null, "User Specific Data Provider Doesn't exists for the user [" + user + "] ");
                String inpFile = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "setting" + File.separator + calObjName + dpSuffix;
                dataProviderFile = new File(inpFile);
                if (!dataProviderFile.exists()) {
                    throw new Exception("Data Provider File Not Found");
                }
                this.copyFile(inpFile, fileName);
            }
            FileInputStream fMainIn = new FileInputStream(dataProviderFile);
            BufferedReader bfr = new BufferedReader(new InputStreamReader(fMainIn));
            String outTempStr = null;
            StringBuffer fileContent = new StringBuffer();
            while ((outTempStr = bfr.readLine()) != null) {
                fileContent.append(outTempStr);
            }
            dataProvider = new E12GenericUtility().parseString(fileContent.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataProvider;
    }

    public void updateNodeValue(HashMap paramMap, String user, String calObjName, String dpSuffix) {
        try {
            BaseLogger.log("3", null, null, "paramMap [" + paramMap + "]");
            Document dataProvider = this.getDataProviderDoc(user, calObjName, dpSuffix);
            Iterator iter = paramMap.keySet().iterator();
            int noOfValueTag = 0;
            while (iter.hasNext()) {
                String key = (String)iter.next();
                BaseLogger.log("3", null, null, "key[" + key + "]");
                BaseLogger.log("3", null, null, "value =[" + (String)paramMap.get(key) + "]");
                if (dataProvider.getElementById(key) == null || dataProvider.getElementById(key).getFirstChild() == null) continue;
                dataProvider.getElementById(key).getFirstChild().setNodeValue((String)paramMap.get(key));
                NodeList sprsCodeNodeList = dataProvider.getElementsByTagName(dataProvider.getElementById(key).getTagName());
                Node currItemNode = sprsCodeNodeList.item(noOfValueTag);
                if (currItemNode == null || currItemNode.getChildNodes() == null) continue;
                NodeList childNodeList = currItemNode.getChildNodes();
                int i = 0;
                while (i < childNodeList.getLength()) {
                    String childNodeNameStr;
                    Node currChildNode = childNodeList.item(i);
                    if (currChildNode != null && currChildNode.getNodeType() == 1 && currChildNode.getFirstChild() != null && "VALUE".equals(childNodeNameStr = currChildNode.getNodeName())) {
                        currChildNode.getFirstChild().setNodeValue((String)paramMap.get(key));
                        ++noOfValueTag;
                        BaseLogger.log("3", null, null, "DataprovAdminBean ::updateNodeValue ::nodeValueStr[" + currChildNode.getFirstChild().getNodeValue() + "]");
                    }
                    ++i;
                }
            }
            String fileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "resource" + File.separator + user + File.separator + calObjName + dpSuffix;
            BaseLogger.log("3", null, null, " fileName [" + fileName + "]");
            String headerInfo = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><!DOCTYPE DATA_PROVIDERS [\t<!ATTLIST ACTIVE NODE_ID ID #REQUIRED>\t<!ATTLIST ARGUMENTS NODE_ID ID #REQUIRED>\t<!ATTLIST USER_ARGUMENTS NODE_ID ID #REQUIRED>\t<!ATTLIST USER_ARGUMENT NODE_ID ID #REQUIRED>\t<!ATTLIST CHANGE_HANDLER NODE_ID ID #REQUIRED>]>";
            byte[] buffer = (String.valueOf(headerInfo) + this.serializeDom(dataProvider)).getBytes();
            int bytes = buffer.length;
            FileOutputStream fos = new FileOutputStream(fileName);
            fos.write(buffer, 0, bytes);
            fos.flush();
            fos.close();
            fos = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String serializeDom(Node dom) {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(new DOMSource(dom), new StreamResult(out));
            retString = out.toString();
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :  : serializeDom :" + e);
        }
        return retString;
    }

    private void copyFile(String from, String to) throws Exception {
        try {
            FileInputStream fin = new FileInputStream(from);
            FileOutputStream fos = new FileOutputStream(to);
            if (fin != null) {
                int i = -1;
                while ((i = fin.read()) != -1) {
                    fos.write(i);
                }
            }
            fin.close();
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }
}

