/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.hibernate.bean.DoctorForm;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONObject;

public class DoctorFormDAO {
    private String siteTranDB = "DEFAULT";
    List<Integer> lineNoExist = new ArrayList<Integer>();
    List<Integer> daysExist = new ArrayList<Integer>();
    List<DoctorForm> doctorVisitPlaceDetails = new ArrayList<DoctorForm>();
    int maxLineNo = 0;
    JSONArray visitPlacesExists = new JSONArray();

    public DoctorForm addDoctorDetails(String loginCode, String _doctorData) throws Exception {
        DoctorForm doctorForm = new DoctorForm();
        JSONObject doctorData = new JSONObject(_doctorData);
        this.doctorVisitPlaceDetails = this.getVisitPlaceDetails(loginCode);
        String[] weekDays = new String[]{"Sunday", "Monday", "Tuesday", "Wenseday", "Thursday", "Friday", "Saturday"};
        if (this.lineNoExist.size() > 0) {
            this.maxLineNo = Collections.max(this.lineNoExist);
        }
        try {
            JSONArray day = doctorData.getJSONArray("DAYS");
            int numberOfDays = day.length();
            int i = 0;
            while (i < numberOfDays) {
                Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
                Transaction tx = session.beginTransaction();
                doctorForm.setScCode(loginCode);
                String geoPos = doctorData.getString("GEO_POS");
                doctorForm.setGeoPos(geoPos);
                String addr1 = doctorData.getString("ADDR1");
                doctorForm.setAddr1(addr1);
                String addr2 = doctorData.getString("ADDR2");
                if (addr2.length() > 0) {
                    byte[] buffer = addr2.getBytes();
                    int bytes = buffer.length;
                    if (bytes > 120) {
                        char[] addr2Char = new char[120];
                        addr2.getChars(0, 119, addr2Char, 0);
                        doctorForm.setAddr2(String.valueOf(addr2Char));
                        String addr3 = addr2.substring(120);
                        doctorForm.setAddr3(addr3);
                    } else {
                        doctorForm.setAddr2(addr2);
                    }
                } else {
                    doctorForm.setAddr2(addr2);
                }
                String fromTime = doctorData.getString("FROM_TIME");
                BaseLogger.log("3", null, null, "fromTime : [" + fromTime + "]");
                String toTime = doctorData.getString("TO_TIME");
                BaseLogger.log("3", null, null, "toTime : [" + toTime + "]");
                Date frDate1 = new Date();
                fromTime = fromTime.substring(0, fromTime.indexOf(":"));
                int frDt1 = Integer.parseInt(fromTime);
                frDate1.setHours(frDt1);
                frDate1.setMinutes(0);
                Date toDate1 = new Date();
                toTime = toTime.substring(0, toTime.indexOf(":"));
                int toDt1 = Integer.parseInt(toTime);
                toDate1.setHours(toDt1);
                toDate1.setMinutes(0);
                BaseLogger.log("3", null, null, "frDate1 after : [" + frDate1 + "]");
                BaseLogger.log("3", null, null, "frDate1 after : [" + toDate1 + "]");
                doctorForm.setfromTime(frDate1);
                doctorForm.setToTime(toDate1);
                doctorForm.setChgDate(new Date());
                doctorForm.setChgTerm("base");
                doctorForm.setChgUser(loginCode);
                doctorForm.setStatus("Y");
                int dayVal = day.getInt(i);
                doctorForm.setDay(dayVal);
                doctorForm.setLineNo(String.valueOf(this.maxLineNo + (i + 1)));
                String visitPlace = doctorData.getString("VISIT_PLACE");
                doctorForm.setVisitPlace(visitPlace);
                String city = doctorData.getString("CITY");
                doctorForm.setCity(city);
                String state = doctorData.getString("STATE");
                doctorForm.setState(state);
                Query query = session.createQuery("select count(*) from DoctorForm where SC_CODE='" + loginCode + "' AND to_char(from_time,'HH24:MI:SS') BETWEEN '" + fromTime + "' AND '" + toTime + "' AND to_char(to_time,'HH24:MI:SS') BETWEEN '" + fromTime + "' AND '" + toTime + "' AND days = " + dayVal);
                System.out.println("DoctorFormDAO.addDoctorDetails() :: query >>" + query);
                System.out.println("DoctorFormDAO.addDoctorDetails()" + (Long)query.uniqueResult());
                Long count = (Long)query.uniqueResult();
                System.out.println("DoctorFormDAO.addDoctorDetails() :: count >>" + count);
                if (count > 0L) {
                    this.visitPlacesExists.put(dayVal);
                } else {
                    session.save((Object)doctorForm);
                    tx.commit();
                    session.close();
                }
                ++i;
            }
            if (this.visitPlacesExists.length() > 0) {
                String dayListStr = "";
                int i2 = 0;
                while (i2 < this.visitPlacesExists.length()) {
                    int dayExist = (Integer)this.visitPlacesExists.get(i2);
                    if (dayListStr.length() > 0) {
                        dayListStr = String.valueOf(dayListStr) + ",";
                    }
                    dayListStr = String.valueOf(dayListStr) + weekDays[dayExist - 1];
                    ++i2;
                }
                System.out.println("DoctorFormDAO.addDoctorDetails() :: dayListStr >>" + dayListStr);
                throw new Exception("Visit Time Already Exists for day  " + dayListStr);
            }
        }
        catch (HibernateException e) {
            System.out.println("DoctorFormDAO.addDoctorDetails()HibernateException :");
            System.out.println("DoctorFormDAO.addDoctorDetails()" + e.getMessage());
        }
        return doctorForm;
    }

    private List<DoctorForm> getVisitPlaceDetails(String loginCode) throws NumberFormatException {
        ArrayList<DoctorForm> doctorVisitPlaceDetail = new ArrayList<DoctorForm>();
        try {
            Session session = HibernateUtil.getSessionFactory(this.siteTranDB).openSession();
            Query query = session.createQuery("from DoctorForm where SC_CODE='" + loginCode + "'");
            List visitPlacesList = query.getResultList();
            if (visitPlacesList.size() > 0) {
                int i = 0;
                while (i < visitPlacesList.size()) {
                    DoctorForm doctorVisitPlaceDetail_ = (DoctorForm)visitPlacesList.get(i);
                    doctorVisitPlaceDetail.add(doctorVisitPlaceDetail_);
                    this.lineNoExist.add(Integer.parseInt(doctorVisitPlaceDetail_.getLineNo().trim()));
                    ++i;
                }
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException : getVisitPlaceDetails ");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return doctorVisitPlaceDetail;
    }

    public String getLocalityList(UserInfoBean userInfo) throws ITMException {
        System.out.println("in getLoacalityList :" + userInfo);
        JSONArray respJsonArray = new JSONArray();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                String transDB = "";
                if (userInfo != null) {
                    transDB = E12GenericUtility.checkNull(userInfo.getTransDB());
                }
                conn = connDriver.getConnectDB(transDB);
                connDriver = null;
                String sql = "select city from station";
                pstmt = conn.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    JSONObject localityJson = new JSONObject();
                    localityJson.put("LOC_DESCR", (Object)E12GenericUtility.checkNull(rs.getString("city")));
                    respJsonArray.put((Object)localityJson);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                System.out.println("Exception :" + e.getMessage());
                e.printStackTrace();
            }
        }
        return respJsonArray.toString();
    }

    public String byDefaultCity(UserInfoBean userInfoBean) {
        Connection con = null;
        Statement pStmt = null;
        ResultSet rs = null;
        String retStr = "";
        String sql = "";
        String transDB = "";
        String userCode = "";
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                transDB = E12GenericUtility.checkNull(userInfoBean.getTransDB());
                con = connDriver.getConnectDB(transDB);
                userCode = userInfoBean.getLoginCode();
                sql = "SELECT CITY FROM STRG_CUSTOMER WHERE SC_CODE=?";
                pStmt = con.prepareStatement(sql);
                pStmt.setString(1, userCode);
                rs = pStmt.executeQuery();
                if (rs.next()) {
                    retStr = rs.getString("CITY");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
            }
            catch (Exception e) {
                System.out.println("DoctorFormDAO.byDefaultCity()" + e);
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    if (con != null) {
                        con.close();
                        con = null;
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (con != null) {
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retStr;
    }
}

