/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.hibernate.bean.DoctorForm;
import ibase.hibernate.dao.DoctorFormDAO;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.crm.Appointment;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/")
public class DoctorFormService {
    private DoctorFormDAO doctorFormDAO = new DoctorFormDAO();
    private UserInfoBean userInfo = null;
    @Context
    HttpServletRequest request;

    @POST
    @Path(value="/doctorformsubmit")
    @Produces(value={"application/json"})
    public Response addDoctorData() throws IOException {
        String errorMessage = "";
        String params = E12GenericUtility.readStreamAsString((InputStream)this.request.getInputStream());
        UserInfoBean userInfo = (UserInfoBean)this.request.getSession().getAttribute("USER_INFO");
        BaseLogger.log((String)"3", null, null, (Object)("USER_INFO : [" + userInfo + "]"));
        if (params.length() == 0) {
            StringBuffer paramString = new StringBuffer();
            params = paramString.toString();
        }
        DoctorForm doctorForm = null;
        String loginCode = userInfo.getLoginCode();
        try {
            doctorForm = this.doctorFormDAO.addDoctorDetails(loginCode, params);
        }
        catch (Exception e) {
            System.out.println("DoctorFormService.addDoctorData() :: e >>" + e);
            System.out.println("DoctorFormService.addDoctorData()" + e.getMessage());
            errorMessage = e.getMessage();
            return Response.status((int)200).entity((Object)errorMessage).build();
        }
        return Response.status((int)200).entity((Object)errorMessage).build();
    }

    private UserInfoBean getUserInfo() {
        UserInfoBean userInfo = null;
        HttpSession session = this.request.getSession();
        Object userObj = session.getAttribute("USER_INFO");
        if (userObj != null) {
            try {
                userInfo = new UserInfoBean(userObj.toString());
            }
            catch (BaseException e) {
                e.printStackTrace();
            }
        }
        return userInfo;
    }

    @GET
    @Path(value="/getLocalityList")
    @Produces(value={"application/json"})
    public Response getLocalityList(@Context HttpServletRequest request) {
        System.out.println("getLocalityList ");
        System.out.println(">>>>>>>> Inside getLocalityList <<<<<<<<");
        String resultStr = "";
        try {
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            System.out.println("USER_INFO : [" + this.userInfo + "]");
            if (this.userInfo != null) {
                DoctorFormDAO doctorFormDAO = new DoctorFormDAO();
                resultStr = doctorFormDAO.getLocalityList(this.userInfo);
                System.out.println("###resultStr" + resultStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)resultStr).build();
    }

    @GET
    @Path(value="/getByDefaultCity")
    @Produces(value={"application/json"})
    public Response getByDefaultCity(@Context HttpServletRequest request) {
        System.out.println(">>>>>>>> Inside getByDefaultCity <<<<<<<<");
        String retStr = "";
        try {
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            System.out.println("USER_INFO : [" + this.userInfo + "]");
            if (this.userInfo != null) {
                DoctorFormDAO doctorFormDAO = new DoctorFormDAO();
                retStr = doctorFormDAO.byDefaultCity(this.userInfo);
                System.out.println("###retStr::" + retStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)retStr).build();
    }

    @GET
    @Path(value="/getStateList")
    @Produces(value={"application/json"})
    public Response getCountryList(@Context HttpServletRequest request) {
        BaseLogger.log((String)"2", (UserInfoBean)this.userInfo, null, (Object)" -- Inside getCountryList -- ");
        String resultStr = "";
        try {
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            BaseLogger.log((String)"3", (UserInfoBean)this.userInfo, null, (Object)("USER_INFO : [" + this.userInfo + "]"));
            Appointment appt = new Appointment();
            resultStr = appt.getMyVisitDefaultData(this.userInfo);
            System.out.println("StateList..................." + resultStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Response.status((int)200).entity((Object)resultStr).build();
    }
}

