package ibase.webitm.ejb.wsfa.transactions;

import ibase.utility.CommonConstants;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import ibase.scheduler.utility.interfaces.Schedule;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import java.text.*;

public class StrgCustDeactivationSchedule implements Schedule
{
	String scheduleParamXML = "";
	public String schedule(HashMap map) throws Exception
    {
	 	System.out.println(schedule((String) map.get("PROCESS_NAME")));
	 	return schedule((String) map.get("PROCESS_NAME"));
    }

    public String schedule(String schedule) throws Exception
    {
    	System.out.println("^^^^^^^ INSERTING INTO CustomerDeactivation ^^^^^^^");
    	this.scheduleParamXML = schedule;
    	this.deactivateCustomers();
    	return schedule;
    }

    public String schedulePriority(String arg0) throws Exception
    {
    	return null;
    }
	private void deactivateCustomers() throws Exception
    {
		String returnString = "";
		PreparedStatement pstmtUpdateStrgSeries = null;
		PreparedStatement pstmtUpdateCustStatus = null;
		PreparedStatement pstmtSelect = null;
		ResultSet rsSelect = null;
		boolean isError = false;
		Connection conn = null;
		
		String deactivateID = "";
		
		try
        {
			//added by prachi for customer deactivation on 3-feb-22 start::
			UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
			ConnDriver connDriver = new ConnDriver();
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				System.out.println("transDB is:"+transDB);
				connDriver = new ConnDriver();
				conn= connDriver.getConnectDB(transDB);	
			}
			else
			{	
			    conn = connDriver.getConnectDB("DriverITM");
			}//::end    
			connDriver = null;
			conn.setAutoCommit(false);

			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			
			String salesPers="";
            String scCode="";
            String routeId="";
            String status="";
            String itemSer="";
            String sStatus="";
            String effDate="";
            String custType="";
            String deactDate="";
            String tranID = "";
            String xtraParams = "";
            String editFlag = "A";
            String chgUser = "";
            String chgTerm = "";
			
			StrgSerStatusHist strgStatusHist= new StrgSerStatusHist();
			
			String updateStrgSeriesSql = "update strg_series set short_id = null, status ='N', chg_date = ?, chg_user = ?, chg_term = ? "+
											"where sales_pers = ? and sc_code = ? ";
			pstmtUpdateStrgSeries = conn.prepareStatement(updateStrgSeriesSql);
			
			String updateDRChemStatusSql = "update strgcust_deactive set load_status = 'Y' where tran_id = ? ";
			pstmtUpdateCustStatus = conn.prepareStatement(updateDRChemStatusSql);
			
			String selectSql = "select a.tran_id, a.sales_pers, a.sc_code, a.route_id, a.deact_date, a.status, b.item_ser, c.status as series_status, "+
								"c.eff_date, c.cust_type, a.chg_user, a.chg_term "+
								"from strgcust_deactive a, sales_pers b, strg_series c "+
								"where a.sales_pers = b.sales_pers "+
								"and a.sales_pers = c.sales_pers and a.sc_code = c.sc_code and c.item_ser = b.item_ser and a.route_id = c.route_id "+
								"and a.status ='Y' and a.load_status <> 'Y' and a.deact_date <= ? ";
			pstmtSelect = conn.prepareStatement(selectSql);
			
			pstmtSelect.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			rsSelect = pstmtSelect.executeQuery();
			while ( rsSelect.next() )
			{
				tranID = checkNull(rsSelect.getString("tran_id"));
				
				deactivateID = tranID;
				
				salesPers = checkNull(rsSelect.getString("sales_pers"));
                scCode = checkNull(rsSelect.getString("sc_code"));
                routeId = checkNull(rsSelect.getString("route_id"));
                deactDate = checkNull(rsSelect.getString("deact_date"));
                chgUser = checkNull(rsSelect.getString("chg_user"));
                chgTerm = checkNull(rsSelect.getString("chg_term"));
                if (deactDate == null || deactDate.trim().length() == 0)
    			{
                	deactDate = " ";
    			}
    			else
    			{
    				deactDate =  genericUtility.getValidDateString( deactDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());				
    			}
                status = checkNull(rsSelect.getString("status"));
                itemSer = checkNull(rsSelect.getString("item_ser"));
                sStatus = checkNull(rsSelect.getString("series_status"));
                effDate = checkNull(rsSelect.getString("eff_date"));
                if (effDate == null || effDate.trim().length() == 0)
    			{
                	effDate = " ";
    			}
    			else
    			{
    				effDate =  genericUtility.getValidDateString( effDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat());				
    			}
                custType = checkNull(rsSelect.getString("cust_type"));
                
                StringBuffer xtraParamsBuff = new StringBuffer();
                xtraParamsBuff.append("chgUser=").append(chgUser).append("~~");
                xtraParamsBuff.append("loginCode=").append(chgUser).append("~~");
                xtraParamsBuff.append("chgTerm=").append(chgTerm);
                
                xtraParams = xtraParamsBuff.toString();
                
                returnString = strgStatusHist.setDrStatusHistory(salesPers, scCode, custType, routeId, itemSer, "N", deactDate, effDate, xtraParams, editFlag, conn);
                if (returnString != null && returnString.trim().length() > 0 )
                {
                	isError = true;
                	conn.rollback();
                }
                else
                {
                	//Updating the status of strg_series table
                	pstmtUpdateStrgSeries.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
                	pstmtUpdateStrgSeries.setString(2, chgUser);
                	pstmtUpdateStrgSeries.setString(3, chgTerm);
                	pstmtUpdateStrgSeries.setString(4, salesPers);
                	pstmtUpdateStrgSeries.setString(5, scCode);
                	int updSSCount = pstmtUpdateStrgSeries.executeUpdate();
                	pstmtUpdateStrgSeries.clearParameters();
                	
                	//Updating the status of strgcust_deactive table
                	pstmtUpdateCustStatus.setString(1, tranID);
                	int updDRStatCount = pstmtUpdateCustStatus.executeUpdate();
                	pstmtUpdateCustStatus.clearParameters();
                	System.out.println("no of record updated in strg_series =["+updSSCount+"] and strgcust_deactive =["+updDRStatCount+"]");
                	
                	if ( updSSCount > 0 && updDRStatCount > 0 )
                	{
                		conn.commit();
                	}
                }

			}
			
        }
		catch (Exception e)
		{
			isError = true;
			System.out.println("Exception ::" + e.getMessage() + ":");
			generateLog( e, deactivateID );//Gulzar on 06/10/12 for generating the log
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsSelect != null)
				{
					rsSelect.close();
					rsSelect = null;
				}
				if (pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
				if (pstmtUpdateStrgSeries != null)
				{
					pstmtUpdateStrgSeries.close();
					pstmtUpdateStrgSeries = null;
				}
				if (pstmtUpdateCustStatus != null)
				{
					pstmtUpdateCustStatus.close();
					pstmtUpdateCustStatus = null;
				}
				if (conn != null && !conn.isClosed())
				{
					if ( !isError )
					{
						conn.commit();
					}
					else
					{
						conn.rollback();
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e){}
		}
    }
	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}
	public String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private void generateLog( Exception ex, String deactivateID ) throws Exception
	{
		String logFile = "";
		String logDir = "";

		FileWriter fileWriter = null;

		File logFileDir = null;

		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
			String currDate = sdf.format(new java.util.Date( System.currentTimeMillis() ) );
			logDir = CommonConstants.JBOSSHOME  + File.separator + "log" + File.separator + "StrgCustDeactive" + File.separator + currDate;
			logFileDir = new File(logDir);
			if ( !logFileDir.exists())
			{
				logFileDir.mkdirs();
			}
			logFile = logDir + File.separator + deactivateID+ ".log";
			fileWriter = new FileWriter(logFile, true);
			StringWriter writerStr = new StringWriter();
			PrintWriter traceWriter = new PrintWriter(writerStr);
			ex.printStackTrace(traceWriter);
			String stackTraceStr = writerStr.toString();
			fileWriter.write( "-----------------------------------------------------------------------------------------");
			fileWriter.write( "\r\n" );
			fileWriter.write( stackTraceStr );
			fileWriter.write( "\r\n" );
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( fileWriter != null )
				{
					fileWriter.flush();
					fileWriter.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
	
}