package ibase.webitm.ejb.wsfa.transactions;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * Author : Pankaj R 
 * Date : 07-Sep-17
 * Used to auto confirmed the DCR after particular locking period
 * */
public class DCREntrySchedule implements Schedule
{
	String scheduleParamXML = "";
	public String schedule(HashMap map) throws Exception
    {
	 	System.out.println(schedule((String) map.get("PROCESS_NAME")));
	 	return schedule((String) map.get("PROCESS_NAME"));
    }

    public String schedule(String schedule) throws Exception
    {
    	System.out.println("^^^^^^^INSERTING INTO DCREntrySchedule ^^^^^^^"+schedule);
    	this.scheduleParamXML = schedule;
    	this.generateDCR();
    	return schedule;
    }

    public String schedulePriority(String arg0) throws Exception
    {
    	return null;
    }
	private void generateDCR() throws ITMException
    {
		Connection connection = null;
		ConnDriver connDriver = null;
		boolean isError = false;
		Document dom = null;
		NodeList nodeList = null;
		Node node  =null;
		PreparedStatement pstmt= null;
		ResultSet rs=null;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			HashMap< String, String> hashMap = new  HashMap<String, String>();
			genericUtility = new E12GenericUtility();
			// Used to get the formal parameter which we set in BaseApplication.xml 
			dom = genericUtility.parseString(scheduleParamXML);
			nodeList = dom.getElementsByTagName("ACTUALPARAMETER");
			node = nodeList.item(0);
			for(int i = 0 ; i < nodeList.getLength(); i ++)
			{
				Node childNode = nodeList.item(i);
				if(node!=null)
				{
					if(i == 0)
					{
						hashMap.put("lockingPrd", childNode.getFirstChild().getNodeValue());
					}
					else if(i == 1)
					{
						hashMap.put("NotifyPrd", childNode.getFirstChild().getNodeValue());
					}
					else
					{
						hashMap.put("Notify_"+(i), childNode.getFirstChild().getNodeValue());
					}
				}
			}
			
			UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
			String loginCode = userInfo.getLoginCode();
			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			//Added by mrunalini sinkar to remove hard code driver(start)
			//connDriver = new ConnDriver();
			//connection = connDriver.getConnectDB("DriverITM");
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				System.out.println("transDB is:"+transDB);
				connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(transDB);	
			}
			//Added by mrunalini sinkar to remove hard code driver(end)			
			
			String currDate = sdf.format(new java.util.Date());
			
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			// To check existing DCR 
			String checkDCREntry = "SELECT CONFIRMED FROM SPRS_ACT_TRAN WHERE EVENT_DATE = ? AND SALES_PERS = ? ";
			PreparedStatement pstmtCheckDCREntry = connection.prepareStatement(checkDCREntry);
			
			// To get max event date for respective sales_person 
			String getEventDate = "SELECT MAX(EVENT_DATE) AS EVENT_DATE FROM SPRS_ACT_TRAN WHERE SALES_PERS = ?";
			PreparedStatement maxDtpreparedStatement = connection.prepareStatement(getEventDate);
			
			// To insert entry in sprs_act_tran table
			String insertSprsActTranSql = "INSERT INTO SPRS_ACT_TRAN(TRAN_ID, EVENT_DATE, ACTIVITY_CODE, SALES_PERS, SPRS_CODE__WW, CHG_DATE, CHG_USER, CHG_TERM, DCR_ID, CONFIRMED, CONF_DATE) "+
					"VALUES(?,?,?,?,?,?,?,?,?,?,?)";

			PreparedStatement pstmtInsertSprsActTran = connection.prepareStatement(insertSprsActTranSql);
			
			String getOTCSalesPers = "SELECT SP.SALES_PERS,SP.SP_NAME FROM SALES_PERS SP,EMPLOYEE EM "+
	                 " WHERE SP.SALES_PERS = EM.EMP_CODE and SP.ACTIVE_YN = 'Y' ";
			
			PreparedStatement pstmtOTCSalesPers = connection.prepareStatement(getOTCSalesPers);
			ResultSet rsOTCSalesPers = pstmtOTCSalesPers.executeQuery();                 
			ResultSet eventDateRs = null;
			PreparedStatement emailIdPsmt = null;
			ResultSet emailRs = null;
			while(rsOTCSalesPers.next())
			{
				boolean isNull = false;
				String otcSalesPers = rsOTCSalesPers.getString("SALES_PERS");
				//Added by mrunaini sinkar on 10-01-2019 to send mail to report to(start)
				String spName = checkNull(rsOTCSalesPers.getString("SP_NAME"));
				OrgStructure orgStructure = new OrgStructure();
				String reportTo = orgStructure.reportTo(otcSalesPers,currDate,connection);
				//Added by mrunaini sinkar on 10-01-2019 to send mail to report to  (end)
				maxDtpreparedStatement.setString(1, otcSalesPers);
				eventDateRs = maxDtpreparedStatement.executeQuery();
				Timestamp timestamp = null;
				while(eventDateRs.next())
				{
					String str = checkNull(eventDateRs.getString("EVENT_DATE"));
					if("".equals(str))
					{
						isNull = true;
					}
					else
					{
						SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
						Date parsedDate = dateFormat.parse(str);
						timestamp = new Timestamp(parsedDate.getTime());
					}
				}
				if(isNull)
				{
					continue;
				}
				Calendar currentCal = Calendar.getInstance();
				Calendar dateFromDB = Calendar.getInstance();
				String currDtInMillis = dateFromDB.getTimeInMillis()+"";
				String maxDtInMillis = timestamp.getTime()+"";
				
				long currTimeInMillis = Long.parseLong(currDtInMillis, 10);
				long maxTimeInMillis = Long.parseLong(maxDtInMillis, 10);
				long diffTimeInMillis = currTimeInMillis - maxTimeInMillis;
				long actualTimeInMillis = currTimeInMillis - diffTimeInMillis;
				dateFromDB.setTimeInMillis(actualTimeInMillis);
				long getDiff = currentCal.getTimeInMillis() - dateFromDB.getTimeInMillis();
		        // using TimeUnit class from java.util.concurrent package to get number of days
		        long getDaysDiff = TimeUnit.MILLISECONDS.toDays(getDiff);
		        int diffInDate = (int)getDaysDiff;
		        
		        String lockingPrdStr = hashMap.get("lockingPrd");
		        String notifyPrdStr = hashMap.get("NotifyPrd");
		        int lockingPrd = Integer.parseInt(lockingPrdStr);
		        int notifyPrd = Integer.parseInt(notifyPrdStr);
		        
		        Calendar lockingPrdDt = Calendar.getInstance();
		        lockingPrdDt.add(Calendar.DATE, -lockingPrd);
		        Calendar dateForMailSub = lockingPrdDt;
		        System.out.println("date for mail sub B4 ::: "+dateForMailSub.getTime());
		        
		        int intimateDiff = lockingPrd - notifyPrd;
		        dateForMailSub.add(Calendar.DATE, (intimateDiff + 1));
		        Calendar dummyLockPrdDt = Calendar.getInstance();
		        
		        // notify period is equal to difference in days ( 4 == 4 ) 
		        System.out.println("diffInDate :::: "+diffInDate);
		        System.out.println("notifyPrd :::: "+notifyPrd);
		        System.out.println("lockingPrd :::: "+lockingPrd);
		        if(diffInDate == notifyPrd)
		        {
		        	System.out.println("date for mail in notification ::: "+dateForMailSub.getTime());
		        	Date dateEntered = new Date(dateForMailSub.getTimeInMillis());
		        	String eventDateStr1 = sdf.format(dateEntered);
		        	
		        	String getEmailId = "select email_id,mobile_no from users where code = ? ";
		        	emailIdPsmt = connection.prepareStatement(getEmailId);
		        	emailIdPsmt.setString(1, otcSalesPers);
		        	emailRs = emailIdPsmt.executeQuery();
		        	String email = "", mobileNo = "";
		        	if(emailRs.next())
		        	{
		        		email = E12GenericUtility.checkNull(emailRs.getString("email_id"));
		        		mobileNo = E12GenericUtility.checkNull(emailRs.getString("mobile_no"));
		        	}
					//Added by mrunaini sinkar on 10-01-2019 for send mail to report to also (start)
		        	String EmailSql = "select email_id,mobile_no from users where code = ? ";
		        	pstmt = connection.prepareStatement(EmailSql);
		        	pstmt.setString(1, reportTo);
		        	rs = pstmt.executeQuery();
		        	String reportEmail = "", reportMobileNo = "";
		        	if(rs.next())
		        	{
		        		reportEmail = E12GenericUtility.checkNull(rs.getString("email_id"));
		        		reportMobileNo = E12GenericUtility.checkNull(rs.getString("mobile_no"));
		        	}
		        	if ( rs != null )
					{
		        		rs.close();
		        		rs = null;
					}
					if(pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("reportEmail is["+reportEmail+"]");
		        	//Added by mrunaini sinkar on 10-01-2019 for send mail to report to also (end)

					StringBuffer commInfo = new StringBuffer();
					
					//if Notify_2(for Notification) = Y
					if(checkNull(hashMap.get("Notify_2")).equalsIgnoreCase("Y"))
					{
						ArrayList<String> userIdList = new ArrayList<String>();
						userIdList.add(otcSalesPers);
						
						AppConnectParm appConnectParm = null;
						InitialContext context = null;
						PublishPushNotificationEJB notificationRemote = null;//Modified by kailash.
						try
						{
							String postMessage = "Please submit your DCR details.";
							appConnectParm = new AppConnectParm();
							context = new InitialContext(appConnectParm.getProperty());
							//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
							//notificationRemote = (PublishPushNotificationRemote) context.lookup("ibase/PublishPushNotificationEJB/remote");
							notificationRemote = new PublishPushNotificationEJB();
							//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]
							
							notificationRemote.invockPushNotification(postMessage, "", PublishPushNotificationRemote.OPEN_TARGET_TRANSACTION,"", userIdList , "", "", " ", loginCode, 0,userInfo);
						}
						catch(Exception e)
						{
							System.out.println("DCREntrySchedule.generateDCR() in sending notification Notify_2 : "+e);
						}
					}
					//if Notify_3(for EMAIL) = Y
					if (checkNull(hashMap.get("Notify_3")).equalsIgnoreCase("Y"))
					{
						String formatCode = "DCR_NR_CONF";
						if (email != null && email.trim().length()>0 && !email.trim().equalsIgnoreCase("null")) 
						{
							commInfo.append("<ROOT>");
							commInfo.append("<MAIL><EMAIL_TYPE>page</EMAIL_TYPE><ENTITY_CODE>BASE</ENTITY_CODE>");
							commInfo.append("<ENTITY_TYPE></ENTITY_TYPE>");
							commInfo.append("<TO_ADD>"+email+"</TO_ADD>");
							commInfo.append("<BCC_ADD></BCC_ADD>");
							commInfo.append("<FORMAT_CODE>"+formatCode+"</FORMAT_CODE>");							
							commInfo.append("<ATTACHMENT><BODY></BODY><LOCATION></LOCATION></ATTACHMENT>");
							commInfo.append("</MAIL>");
							commInfo.append("<XML_DATA><ROOT><Detail1><email_addr>"+email+"</email_addr>");
							commInfo.append("<report_to_email>"+reportEmail+"</report_to_email>");//added by mrunalini sinkar
							commInfo.append("<sp_name>"+spName+"</sp_name>");//added by mrunalini sinkar
							commInfo.append("<sales_pers>"+otcSalesPers+"</sales_pers>");//added by mrunalini sinkar
							commInfo.append("<cc_to></cc_to><date>"+eventDateStr1+"</date></Detail1></ROOT></XML_DATA>");
							commInfo.append("<EMAIL_TYPE>page</EMAIL_TYPE>");
							commInfo.append("</ROOT>");
							System.out.println("commInfo.toString() P:::: "+commInfo.toString());
							EMail emailObj = new EMail();
							// commentted and added by rupali on 21/12/18 for passing connection [start]
							//emailObj.sendMail(commInfo.toString(), "ITM"); 
							emailObj.sendMail(commInfo.toString(), "ITM", connection); 
							// commentted and added by rupali on 21/12/18 for passing connection [end]
						}
					}
					//if Notify_4(for SMS) = Y
					/*if (checkNull(hashMap.get("Notify_4")).equalsIgnoreCase("YES"))
					{
						if(!("".equals(mobileNo)))
						{
							String smsFormatCode="USER_FORMAT";
							String xtraParams = "loginCode="+otcSalesPers+"~~loginEmpCode"+otcSalesPers;
							StringBuffer valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header></Header>\r\n<Errors></Errors>\r\n" );
							valueXmlString.append( "<Detail1 objName = 'user_authenticate'>\r\n" );
							valueXmlString.append( "<code><![CDATA[" ).append(otcSalesPers).append( "]]></code>\r\n" );
							valueXmlString.append( "<mobileNo><![CDATA[" ).append(mobileNo).append( "]]></mobileNo>\r\n" );
							valueXmlString.append( "</Detail1>\r\n" );
							valueXmlString.append( "</Root>\r\n" );
							E12SMSComp e12smsComp = new E12SMSComp();
							String smsresp = e12smsComp.sendSMS(valueXmlString.toString(), smsFormatCode, xtraParams);
							System.out.println("sms response::::"+smsresp);
						}
					}*/
		        }
		        if(diffInDate >= lockingPrd)
		        {
		        	dummyLockPrdDt.add(Calendar.DATE, -(lockingPrd -1 ));
		        	dummyLockPrdDt.set(Calendar.HOUR_OF_DAY, 0);
					dummyLockPrdDt.set(Calendar.MINUTE,0);
					dummyLockPrdDt.set(Calendar.SECOND,0);
					dummyLockPrdDt.set(Calendar.MILLISECOND,0);
					
		        	isConfirmed(otcSalesPers, connection, pstmtCheckDCREntry, lockingPrdDt);
		        	isInserted(dummyLockPrdDt, otcSalesPers, dateFromDB);
		        }
			}
			if ( rsOTCSalesPers != null )
			{
				rsOTCSalesPers.close();
				rsOTCSalesPers = null;
			}
			if(pstmtOTCSalesPers != null )
			{
				pstmtOTCSalesPers.close();
				pstmtOTCSalesPers = null;
			}
			if ( eventDateRs != null )
			{
				eventDateRs.close();
				eventDateRs = null;
			}
			if(maxDtpreparedStatement != null )
			{
				maxDtpreparedStatement.close();
				maxDtpreparedStatement = null;
			}
			if(pstmtInsertSprsActTran != null )
			{
				pstmtInsertSprsActTran.close();
				pstmtInsertSprsActTran = null;
			}
			if ( emailRs != null )
			{
        		emailRs.close();
        		emailRs = null;
			}
			if(emailIdPsmt != null )
			{
				emailIdPsmt.close();
				emailIdPsmt = null;
			}
			if(pstmtCheckDCREntry != null )
			{
				pstmtCheckDCREntry.close();
				pstmtCheckDCREntry = null;
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("DCREntrySchedule.generateDCR() :: "+e);
		}
		finally
		{
			try
			{
				if (connection != null && !connection.isClosed())
				{
					if ( !isError )
					{
						connection.commit();
					}
					else
					{
						connection.rollback();
					}
					connection.close();
					connection= null;
				}
			}
			catch(Exception e){}
		}
    }
	/**
	 * This method is used to insert entry in sprs_travel table.
	 * @param conn
	 * @param salesPers
	 * @param dcrDate
	 * @param dcrID
	 * @return true or false.
	 * @throws ITMException
	 */
	private boolean insertIntoSprsTravel( Connection conn, String salesPers, String dcrDate, String dcrID ) throws ITMException
	{
		boolean isSuccess = false;
		try
		{
			System.out.println("insertIntoSprsTravel is called...........");
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//Inserting into sprs_travel table
			String insertSprsTravelSql = "INSERT INTO SPRS_TRAVEL(TRAN_ID, SALES_PERS, TRAVEL_DATE, LOCALITY_CODE, STAN_CODE, STAN_CODE__FROM, TRAVEL_MODE," +
					" OVER_NIGHT, ACTIVITY_CODE, CHG_DATE, CHG_USER, CHG_TERM, OTH_PARTICIPANT, SPRS_CODE__WW, ORDER_OF_VISIT, DCR_ID, LINE_NO,ROUTE_ID,ROUTE_ID_FROM) "+
										"VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			
			PreparedStatement pstmtInsertSprsTravel = conn.prepareStatement(insertSprsTravelSql);
			
			java.util.Calendar calendar = java.util.Calendar.getInstance();
			
			System.out.println("dcrDate =["+dcrDate+"]");
			
			calendar.setTime( sdf.parse(dcrDate) );
			
			while(true)
			{
				calendar.add(calendar.DATE, -1);
				String travelDate = sdf.format(calendar.getTime());
				String newDCRDate = travelDate;
				System.out.println("newDCRDate =["+newDCRDate+"]");
				
				calendar.setTime(sdf.parse(newDCRDate));
				
				//Checking for holiday
				boolean isHoliday = isHoliday(conn, travelDate, salesPers );
				System.out.println("isHoliday =["+isHoliday+"]");
				
				if (isHoliday)
				{
					continue;
				}
				//End checking holiday
				int lineNo = 0;
				String getSprsTravelDataSql = "SELECT * FROM SPRS_TRAVEL WHERE SALES_PERS = ? AND TRAVEL_DATE = ?";
				PreparedStatement pstmtSprsTravel = conn.prepareStatement(getSprsTravelDataSql);
				pstmtSprsTravel.setString(1, salesPers);
				pstmtSprsTravel.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( newDCRDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				
				ResultSet rsGetSprsTravel = pstmtSprsTravel.executeQuery();
				while(rsGetSprsTravel.next())
				{
					String routeId=checkNull(rsGetSprsTravel.getString("ROUTE_ID"));
					String routeIdFrom=checkNull(rsGetSprsTravel.getString("ROUTE_ID_FROM"));
					String stanCode=checkNull(rsGetSprsTravel.getString("STAN_CODE"));
					String localityCode=checkNull(rsGetSprsTravel.getString("LOCALITY_CODE"));

					if(routeId==null || routeId.trim().length()==0)
					{
						String sql="SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SALES_PERS=? AND STAN_CODE=? AND LOCALITY_CODE=?";
						PreparedStatement pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, salesPers);
						pstmt.setString(2, stanCode);
						pstmt.setString(3, localityCode);
						ResultSet rs=pstmt.executeQuery();
						if(rs.next())
						{
							routeId=checkNull(rs.getString("ROUTE_ID"));
							routeIdFrom=routeId;

						}
						if ( rs != null )
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}

					}
					lineNo++;
					pstmtInsertSprsTravel.setString(1, "");
					pstmtInsertSprsTravel.setString(2, salesPers);
					pstmtInsertSprsTravel.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					pstmtInsertSprsTravel.setString(4, (rsGetSprsTravel.getString("LOCALITY_CODE") == null) ? "" : rsGetSprsTravel.getString("LOCALITY_CODE").trim());
					pstmtInsertSprsTravel.setString(5, (rsGetSprsTravel.getString("STAN_CODE") == null) ? "" : rsGetSprsTravel.getString("STAN_CODE").trim());
					pstmtInsertSprsTravel.setString(6, (rsGetSprsTravel.getString("STAN_CODE__FROM") == null) ? "" : rsGetSprsTravel.getString("STAN_CODE__FROM").trim());
					pstmtInsertSprsTravel.setString(7, (rsGetSprsTravel.getString("TRAVEL_MODE") == null) ? "" : rsGetSprsTravel.getString("TRAVEL_MODE").trim());
					pstmtInsertSprsTravel.setString(8, (rsGetSprsTravel.getString("OVER_NIGHT") == null) ? "" : rsGetSprsTravel.getString("OVER_NIGHT").trim());
					pstmtInsertSprsTravel.setString(9, "NR");
					pstmtInsertSprsTravel.setTimestamp(10, java.sql.Timestamp.valueOf(currDate));
					pstmtInsertSprsTravel.setString(11, "SYSTEM");
					pstmtInsertSprsTravel.setString(12, "SYSTEM");
					pstmtInsertSprsTravel.setString(13, (rsGetSprsTravel.getString("OTH_PARTICIPANT") == null) ? "" : rsGetSprsTravel.getString("OTH_PARTICIPANT").trim());
					pstmtInsertSprsTravel.setString(14, (rsGetSprsTravel.getString("SPRS_CODE__WW") == null) ? "" : rsGetSprsTravel.getString("SPRS_CODE__WW").trim());
					pstmtInsertSprsTravel.setString(15, (rsGetSprsTravel.getString("ORDER_OF_VISIT") == null) ? "" : rsGetSprsTravel.getString("ORDER_OF_VISIT").trim());
					pstmtInsertSprsTravel.setString(16, dcrID);
					pstmtInsertSprsTravel.setInt(17, lineNo);
					pstmtInsertSprsTravel.setString(18, routeId);
					pstmtInsertSprsTravel.setString(19, routeIdFrom);
					
					int insertSprsTravelCnt = pstmtInsertSprsTravel.executeUpdate();
					System.out.println("insertSprsTravelCnt =["+insertSprsTravelCnt+"]");
					
					pstmtInsertSprsTravel.clearParameters();
					if (insertSprsTravelCnt > 0)
					{
						isSuccess = true;
						System.out.println("inserted successfully into sprs travel =["+insertSprsTravelCnt+"]");
					}
				}
				rsGetSprsTravel.close(); rsGetSprsTravel = null;
				pstmtSprsTravel.close(); pstmtSprsTravel = null;
				if(pstmtInsertSprsTravel != null)
				{
					pstmtInsertSprsTravel.close(); pstmtInsertSprsTravel = null;
				}
				break;
			}
						
		}
		catch(Exception exp)
		{
			System.out.println("Exception : insertIntoSprsTravel :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		return isSuccess;
	}
	
	private String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input;
	}

	/**
	 * This method is used to generate a DCRId.
	 * @param conn
	 * @return String = DCRId
	 * @throws ITMException
	 */
	private String generateDCRId( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{
			System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");
						
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 'w_strg_meet_itm_wiz' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();			
			
			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				String xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
				xmlValues = xmlValues + "<Header></Header>";
				xmlValues = xmlValues + "<Detail1>";
				xmlValues = xmlValues +        "<dcr_id></dcr_id>";
				xmlValues = xmlValues + "</Detail1></Root>";
				TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n"+exp);
			//throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey; 
	}
	/**
	 * This method is used check whether the provided date is a holiday or not.
	 * @param conn
	 * @param eventDate
	 * @param salesPers
	 * @return isHoliday or not
	 * @throws ITMException
	 */
	private boolean isHoliday(Connection conn, String eventDate, String salesPers ) throws ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String checkSQL = "";
		
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		PreparedStatement pstmtHoliday = null;
		ResultSet rsHoliday = null ;
		
		//ArrayList holidayList = new ArrayList();
		boolean isEventDateHoliday = false;
		try
		{
			eventDate = genericUtility.getValidDateString( eventDate , genericUtility.getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			pstmt = conn.prepareStatement(checkSQL);
			pstmt.setString(1,checkNull(eventDate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String code = rs.getString( "CODE" );
				
				checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				System.out.println("sql [" + checkSQL + "] ");

				pstmtHoliday = conn.prepareStatement(checkSQL);
				pstmtHoliday.setString(1,checkNull(salesPers));
				pstmtHoliday.setString(2,checkNull(code));
				pstmtHoliday.setString(3,checkNull(code));
				pstmtHoliday.setString(4,checkNull(eventDate));
				rsHoliday = pstmtHoliday.executeQuery();
				if(rsHoliday.next())
				{
					String holDate = rsHoliday.getString( 1 ); 
					System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null && holDate.trim().length() > 0 )
					{
						isEventDateHoliday = true;
					}											                                   
				}
				if (rsHoliday!= null)
				{
					rsHoliday.close();
					rsHoliday = null;
				}
				if(pstmtHoliday!=null)
				{
					pstmtHoliday.close();
					pstmtHoliday = null;
				}
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (rsHoliday!= null)
				{
					rsHoliday.close();
					rsHoliday = null;
				}
				if(pstmtHoliday!=null)
				{
					pstmtHoliday.close();
					pstmtHoliday = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("isEventDateHoliday in isHoliday() =["+isEventDateHoliday+"]");
		return isEventDateHoliday;
	}
	
	/**
	 * This method is used to confirm all the DCR before the provided date (calendar)
	 * @param salesPers 
	 * @param connection
	 * @param preparedStatement
	 * @param calendar
	 * @return boolean whether confirmed or not.
	 */
	private boolean isConfirmed(String salesPers, Connection connection, PreparedStatement preparedStatement, Calendar calendar)
	{
		boolean isConfirmed = false;
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Date d = new Date(calendar.getTimeInMillis());
	    	String eventDateStr = sdf.format(d);
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			
			String updateDCREntry = "update sprs_act_tran set confirmed = ? , conf_date= ?  where event_date= ? and sales_pers= ? ";
			PreparedStatement updateDCREntryPstmt = connection.prepareStatement(updateDCREntry);
			
			preparedStatement.setTimestamp(1, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
			preparedStatement.setString(2,salesPers);
			
			String confirmed = "";
			ResultSet rsCheckDCREntry = preparedStatement.executeQuery();
			if(rsCheckDCREntry.next())
			{
				confirmed = rsCheckDCREntry.getString("CONFIRMED");
				confirmed = E12GenericUtility.checkNull(confirmed);
			}
			
			if(confirmed.equalsIgnoreCase("Y"))
			{
				isConfirmed = true;
			}
			else
			{
				updateDCREntryPstmt.setString(1, "Y");
				updateDCREntryPstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
				updateDCREntryPstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				updateDCREntryPstmt.setString(4, salesPers);
				int updatedCount = updateDCREntryPstmt.executeUpdate();
				
				System.out.println("updatedCount ::: "+updatedCount);
				if(updatedCount > 0)
				{
					//Added by kailash on 05-02-19 for updating strg_cust_add while executing NR entry schedule[start] 
					String updateUnilistEntry = "update strg_cust_add set confirmed = ? , conf_date= ?  where event_date= ? and sales_pers= ? ";
					PreparedStatement updPstmt = connection.prepareStatement(updateUnilistEntry);
					updPstmt.setString(1, "Y");
					updPstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
					updPstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					updPstmt.setString(4, salesPers);
					int updCount = updPstmt.executeUpdate();
					System.out.println("updCount["+updCount+"]");
					if(updPstmt != null)
					{
						updPstmt.close();
						updPstmt = null;
					}
                    //Added by kailash on 05-02-19 for updating strg_cust_add while executing NR entry schedule[end] 
                    //added by shraddha M to update strg_meet confirmed as Y whie execution NR scheduler[23-sep-2020]START
                    String updateStrgMeet = "update STRG_MEET set confirmed = ? , conf_date= ?  where event_date= ? and sales_pers= ? ";
					PreparedStatement updmeetPstmt = connection.prepareStatement(updateStrgMeet);
					updmeetPstmt.setString(1, "Y");
					updmeetPstmt.setTimestamp(2, java.sql.Timestamp.valueOf(currDate));
					updmeetPstmt.setTimestamp(3, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( eventDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
					updmeetPstmt.setString(4, salesPers);
					 updCount = updmeetPstmt.executeUpdate();
					System.out.println("updCount for Strgmeet["+updCount+"]");
					if(updmeetPstmt != null)
					{
						updmeetPstmt.close();
						updmeetPstmt = null;
                    }
                    //added by shraddha M to update strg_meet confirmed as Y whie execution NR scheduler[23-sep-2020]END
					connection.commit();
				}
				calendar.add(Calendar.DATE, -1);
				isConfirmed = isConfirmed(salesPers, connection, preparedStatement, calendar);
				
			}
			if ( rsCheckDCREntry != null )
			{
				rsCheckDCREntry.close();
				rsCheckDCREntry = null;
			}
			if(updateDCREntryPstmt != null )
			{
				updateDCREntryPstmt.close();
				updateDCREntryPstmt = null;
			}
			
		}
		catch (ITMException e) 
		{
			System.out.println("DCREntrySchedule.isConfirmed() in ITMException : "+e);
		} catch (SQLException e) 
		{
			System.out.println("DCREntrySchedule.isConfirmed() in SQLException : "+e);
		} catch (Exception e) 
		{
			System.out.println("DCREntrySchedule.isConfirmed() in Exception : "+e);
		}
		return isConfirmed;
	}
	
	/**
	 * This method is used to insert data into SPRS_ACT_TRAN recursively if the entry is not upto date. 
	 * @param lockDt
	 * @param salesPerson
	 * @param dateFromDB
	 */
	private void isInserted(Calendar lockDt, String salesPerson, Calendar dateFromDB) 
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		Connection connection = null;
		ConnDriver connDriver = null;
		PreparedStatement pstmtInsertSprsActTran = null;
		try
		{
			//Added by mrunalini sinkar to remove hard code driver(start)	
			//connDriver = new ConnDriver();
			//connection = connDriver.getConnectDB("DriverITM");
			UserInfoBean userInfo = new UserInfoBean(scheduleParamXML);
			if( userInfo != null && userInfo.getTransDB() != null )
			{
				String transDB = E12GenericUtility.checkNull( userInfo.getTransDB() );
				connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(transDB);	
			}
			//Added by mrunalini sinkar to remove hard code driver(end)	
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());
			currDate = genericUtility.getValidDateTimeString( currDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
			String insertSprsActTranSql = "INSERT INTO SPRS_ACT_TRAN(TRAN_ID, EVENT_DATE, ACTIVITY_CODE, SALES_PERS, SPRS_CODE__WW, CHG_DATE, CHG_USER, CHG_TERM, DCR_ID, CONFIRMED, CONF_DATE) "+
					"VALUES(?,?,?,?,?,?,?,?,?,?,?)";
			pstmtInsertSprsActTran = connection.prepareStatement(insertSprsActTranSql);
        	
        	Calendar nextDate = dateFromDB;
        	nextDate.add(Calendar.DATE, 1);
        	Date nextDateEntered = new Date(nextDate.getTimeInMillis());
        	String nextDateStr = sdf.format(nextDateEntered);
			boolean isHoliday = isHoliday(connection, nextDateStr, salesPerson);
			System.out.println("isHoliday :: "+isHoliday);
			System.out.println(" DateFromDB ::: "+dateFromDB.getTime());
			System.out.println(" Locking prd Date ::: "+lockDt.getTime());
			
			if(dateFromDB.getTime().before(lockDt.getTime()) && !isHoliday)
        	{
	        	String dcrID = generateDCRId(connection);
				pstmtInsertSprsActTran.setString(1, dcrID);
				pstmtInsertSprsActTran.setTimestamp(2, java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString( nextDateStr, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() )));
				pstmtInsertSprsActTran.setString(3, "NR");
				pstmtInsertSprsActTran.setString(4, salesPerson);
				pstmtInsertSprsActTran.setString(5, "");
				pstmtInsertSprsActTran.setTimestamp(6, java.sql.Timestamp.valueOf(currDate));
				pstmtInsertSprsActTran.setString(7, "SYSTEM");
				pstmtInsertSprsActTran.setString(8, "SYSTEM");
				pstmtInsertSprsActTran.setString(9, dcrID);
				pstmtInsertSprsActTran.setString(10, "Y");
				pstmtInsertSprsActTran.setTimestamp(11, java.sql.Timestamp.valueOf(currDate));
				int insertSprsActTranCnt = pstmtInsertSprsActTran.executeUpdate();
				if(insertSprsActTranCnt > 0)
				{
					System.out.println("Inserted successfully into sprs_act_tran table =["+insertSprsActTranCnt+"]");
					connection.commit();
				}
				boolean isSuccess = insertIntoSprsTravel( connection, salesPerson, nextDateStr, dcrID );
				if(isSuccess)
				{
					connection.commit();
				}
				else
				{
					connection.rollback();
				}
        	}
			if(dateFromDB.getTime().before(lockDt.getTime()))
        	{
				if(nextDate.getTime().before(lockDt.getTime()))
				{
					isInserted(lockDt, salesPerson, nextDate);
				}
        	}
		}
		catch(Exception e)
		{
			System.out.println("DCREntrySchedule.isInserted() :" +e);
		}
		finally
		{
			try
			{
				
				if(pstmtInsertSprsActTran!=null)
				{
					pstmtInsertSprsActTran.close();
					pstmtInsertSprsActTran = null;
				}		
				if(connection != null)
				{
					connection.close();
					connection= null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
}
