/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.DocumentHandlerServiceUtility;
import ibase.webitm.utility.RestAPIServiceUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Base64;
import org.json.JSONObject;

public class DocumentViewerServiceUtility
extends RestAPIServiceUtility {
    public JSONObject getPreviewImage(String objName, String refId, String tokenIDfromHeader) {
        BaseLogger.log("3", null, null, " getPreviewImage method call: ");
        JSONObject jsonObject = new JSONObject();
        UserInfoBean userInfo = null;
        if (userInfo == null) {
            APIUtility apiUtility = new APIUtility();
            userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
            BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
        }
        DocumentHandlerServiceUtility documentHandlerServiceUtility = new DocumentHandlerServiceUtility();
        String responseData = null;
        String refCol = "";
        Object byteArray = null;
        try {
            responseData = documentHandlerServiceUtility.getDocumentData(objName, refId, tokenIDfromHeader, refCol);
            BaseLogger.log("3", null, null, "responseData ==> " + responseData);
            ArrayList<String> documentIds = new ArrayList<String>();
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode rootNode = objectMapper.readTree(responseData);
                documentIds = new ArrayList();
                JsonNode documentsNode = rootNode.path("Documents");
                if (documentsNode.isArray()) {
                    for (JsonNode documentNode : documentsNode) {
                        JsonNode documentIdNode = documentNode.path("Document_Id");
                        if (!documentIdNode.isTextual()) continue;
                        documentIds.add(documentIdNode.asText());
                    }
                }
                System.out.println("Document IDs: " + documentIds);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (String docId : documentIds) {
                try {
                    BaseLogger.log("3", null, null, "DocumentViewerServlet :: docID [" + docId + "]");
                    byteArray = this.getPreviewImageAgainstDocId(docId, userInfo);
                    String encodedByteArray = Base64.getEncoder().encodeToString((byte[])byteArray);
                    jsonObject.put(docId, (Object)encodedByteArray);
                }
                catch (Exception ex) {
                    BaseLogger.log("3", null, null, "Exception in DocumentViewerServlet :: handleDocument() : " + ex);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("3", null, null, "Exception :: " + e);
            e.printStackTrace();
        }
        BaseLogger.log("3", null, null, "jsonObject with docID and encoded byte array0:: [" + jsonObject + "]");
        BaseLogger.log("3", null, null, "byteArray  of:: [" + byteArray.toString() + "]");
        return jsonObject;
    }

    private byte[] getPreviewImageAgainstDocId(String docId, UserInfoBean userInfo) {
        BaseLogger.log("3", null, null, "getPreviewImageAgainstDocId Service Called");
        byte[] byteArray = null;
        try {
            BaseLogger.log("3", null, null, "DocumentViewerServlet :: handleDocument() : GET_VIDEO_FRAME : docID [" + docId + "]");
            byteArray = docId == null || "".equals(docId.trim()) ? new byte[1] : ((byteArray = this.getVideoFrame(docId, userInfo)) == null ? new byte[1] : byteArray);
        }
        catch (Exception ex) {
            BaseLogger.log("3", null, null, "Exception in DocumentViewerServlet :: handleDocument() : " + ex);
            ex.printStackTrace();
        }
        BaseLogger.log("3", null, null, " getPreviewImageAgainstDocId byteArray:: " + byteArray);
        return byteArray;
    }

    private byte[] getVideoFrame(String docId, UserInfoBean userInfo) {
        byte[] iconByteArray;
        block22: {
            BaseLogger.log("3", null, null, "getVideoFrame() Called");
            Connection conn = null;
            Statement st = null;
            ResultSet rs = null;
            InputStream inputStream = null;
            iconByteArray = new byte[1];
            BaseLogger.log("3", null, null, " getVideoFrame method call: ");
            try {
                try {
                    String sql = "SELECT ICON FROM DOC_CONTENTS WHERE DOC_ID = " + docId;
                    BaseLogger.log("3", userInfo, null, "DocumentViewerServlet :: getVideoFrame() : sql [" + sql + "]");
                    String transDB = userInfo.getTransDB();
                    conn = new ConnDriver().getConnectDB(transDB);
                    st = conn.createStatement();
                    rs = st.executeQuery(sql);
                    if (rs.next() && (inputStream = rs.getBinaryStream(1)) != null) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int i = 0;
                        while ((i = inputStream.read()) != -1) {
                            byteArrayOutputStream.write(i);
                        }
                        iconByteArray = byteArrayOutputStream.toByteArray();
                    }
                }
                catch (Exception ex) {
                    BaseLogger.log("3", userInfo, null, "Exception in DocumentViewerServlet :: getVideoFrame() : " + ex);
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        if (st != null) {
                            st.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        break block22;
                    }
                    catch (Exception exception) {}
                    break block22;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        conn.close();
                    }
                    if (st != null) {
                        st.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                if (st != null) {
                    st.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        BaseLogger.log("3", userInfo, null, "getVideoFrame iconByteArray : " + iconByteArray);
        return iconByteArray;
    }
}

