/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.Excel2XMLMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;

public class XLSReader {
    String objName = null;

    private String getXML(String xlsFile, String metaDataXML) throws Exception {
        StringBuffer masterXmlString = null;
        FileInputStream inStream = null;
        inStream = new FileInputStream(metaDataXML);
        Excel2XMLMapping fldMap = null;
        fldMap = new Excel2XMLMapping();
        fldMap.readXML(inStream);
        ArrayList detailList = new ArrayList();
        detailList = fldMap.getSheetList();
        int detLen = detailList.size();
        String xmlDataStr = new String("");
        this.objName = fldMap.getObjName();
        FileInputStream fileToBeRead = null;
        File excelFile = new File(xlsFile);
        fileToBeRead = new FileInputStream(excelFile);
        HSSFWorkbook workbook = null;
        workbook = new HSSFWorkbook((InputStream)fileToBeRead);
        int detIndex = 0;
        while (detIndex < detLen) {
            ArrayList mappingList = null;
            String objContext = null;
            String sheetName = null;
            String vOffset = null;
            String hOffset = null;
            Excel2XMLMapping.Sheet sheet = (Excel2XMLMapping.Sheet)detailList.get(detIndex);
            mappingList = sheet.mappingList;
            objContext = sheet.objCtx;
            sheetName = sheet.name;
            vOffset = sheet.vOffset;
            hOffset = sheet.hOffset;
            xmlDataStr = String.valueOf(xmlDataStr) + this.getXMLData(workbook, sheet);
            ++detIndex;
        }
        masterXmlString = new StringBuffer();
        masterXmlString.append("<?xml version=\"1.0\" encoding=\"" + CommonConstants.ENCODING + "\"?>");
        masterXmlString.append("<DocumentRoot>");
        masterXmlString.append("<description>").append("Datawindow Root").append("</description>");
        masterXmlString.append("<group0>");
        masterXmlString.append("<description>").append("Group0 description").append("</description>");
        masterXmlString.append("<Header0>");
        masterXmlString.append("<objName><![CDATA[").append(this.objName).append("]]></objName>");
        masterXmlString.append("<pageContext><![CDATA[").append("2").append("]]></pageContext>");
        masterXmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
        masterXmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
        masterXmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
        masterXmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
        masterXmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
        masterXmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
        masterXmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
        masterXmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
        masterXmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
        masterXmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
        masterXmlString.append("<description>").append("Header0 members").append("</description>");
        masterXmlString.append(xmlDataStr);
        masterXmlString.append("\n\t\t</Header0>");
        masterXmlString.append("\n\t</group0>");
        masterXmlString.append("\n</DocumentRoot>");
        Object rec = null;
        ((InputStream)inStream).close();
        inStream = null;
        return masterXmlString.toString();
    }

    private String getXMLData(HSSFWorkbook workbook, Excel2XMLMapping.Sheet sheet) throws Exception {
        int mappingLen;
        ArrayList mappingList = null;
        String objContext = null;
        String sheetName = null;
        int vOffset = 0;
        int hOffset = 0;
        String tagStr = null;
        Object fldName = null;
        String value = null;
        Object xmlDataStr = null;
        StringBuffer rowStrBuff = new StringBuffer();
        boolean colCount = false;
        boolean rowCount = false;
        Object cellValueStr = null;
        mappingList = sheet.mappingList;
        objContext = sheet.objCtx;
        sheetName = sheet.name;
        int n = mappingLen = mappingList != null ? mappingList.size() : 0;
        if (mappingLen == 0) {
            StringBuffer contextBuff = new StringBuffer();
            contextBuff.append("\n\t\t<Detail" + objContext + ">");
            contextBuff.append("\n\t\t</Detail" + objContext + ">");
            return contextBuff.toString();
        }
        vOffset = Integer.parseInt(sheet.vOffset);
        hOffset = Integer.parseInt(sheet.hOffset);
        HSSFSheet xlsSheet = null;
        xlsSheet = workbook.getSheet(sheetName);
        int colIndex = 0;
        int lastRowNo = xlsSheet.getLastRowNum();
        int objCtx = Integer.parseInt(objContext);
        int startRow = hOffset - 1;
        while (startRow <= lastRowNo) {
            StringBuffer contextBuff = new StringBuffer();
            contextBuff.append("\n\t\t<Detail" + objContext + " dbID=\"\" domID=\"" + (startRow - hOffset + 2) + "\" objName=\"" + this.objName + "\" objContext=\"1\">");
            contextBuff.append("<attribute pkNames=\"\" status=\"N\" updateFlag=\"A\" selected=\"N\"/>");
            contextBuff.append("<tran_id/>");
            if (mappingList != null || mappingLen > 0) {
                rowStrBuff.append(contextBuff.toString());
                int mappingIndex = 0;
                while (mappingIndex < mappingLen) {
                    Excel2XMLMapping.MappingRec rec = null;
                    rec = (Excel2XMLMapping.MappingRec)mappingList.get(mappingIndex);
                    int rowNo = 0;
                    String colName = null;
                    String fldDestination = null;
                    if (rec.fldSrc.indexOf(46) == -1) {
                        colName = rec.fldSrc;
                    } else {
                        rowNo = Integer.parseInt(rec.fldSrc.substring(0, rec.fldSrc.indexOf(46))) - 1;
                        colName = rec.fldSrc.substring(rec.fldSrc.indexOf(46) + 1);
                    }
                    fldDestination = rec.fldDest;
                    colIndex = this.getColumnIndex(colName);
                    HSSFRow row = null;
                    row = xlsSheet.getRow(objCtx == 1 ? rowNo : startRow);
                    HSSFCell cell = null;
                    value = null;
                    if (colIndex != -1 && (cell = row.getCell(colIndex)) != null) {
                        switch (cell.getCellType()) {
                            case NUMERIC: {
                                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                    value = XLSReader.getDateInFormat(cell.getDateCellValue(), "dd/MM/yy");
                                    break;
                                }
                                value = Double.toString(cell.getNumericCellValue());
                                break;
                            }
                            case STRING: {
                                value = cell.getStringCellValue();
                                break;
                            }
                            case BLANK: {
                                value = cell.getStringCellValue();
                                BaseLogger.log("3", null, null, "Blank   : " + cell.getStringCellValue());
                                break;
                            }
                            case BOOLEAN: {
                                BaseLogger.log("3", null, null, "Boolean : " + cell.getBooleanCellValue());
                                break;
                            }
                            case ERROR: {
                                BaseLogger.log("3", null, null, "Error   : " + cell.getErrorCellValue());
                                break;
                            }
                            case FORMULA: {
                                value = cell.getCellFormula();
                                break;
                            }
                            default: {
                                if (!HSSFDateUtil.isCellDateFormatted((Cell)cell)) break;
                                value = cell.getDateCellValue().toString();
                            }
                        }
                    }
                    tagStr = "\n\t\t\t<" + fldDestination.toLowerCase() + ">" + (value == null ? "" : value) + "</" + fldDestination.toLowerCase() + ">";
                    rowStrBuff.append(tagStr);
                    ++mappingIndex;
                }
            }
            rowStrBuff.append("\n\t\t</Detail" + objContext + ">");
            if (objCtx == 1) break;
            ++startRow;
        }
        return rowStrBuff.toString();
    }

    public int getColumnIndex(String colName) {
        int colNo = 0;
        if (colName == null || colName.trim().length() == 0) {
            return -1;
        }
        colName = colName.toUpperCase();
        int len = 0;
        len = colName.trim().length();
        if (len == 1) {
            colNo = colName.charAt(0) - 65;
        }
        if (len == 2) {
            char firstChar = colName.charAt(0);
            char secondChar = colName.charAt(1);
            colNo = 26 * (1 + (firstChar - 65)) + (secondChar - 65);
        }
        return colNo;
    }

    public String writeToFile(String xlsFile, String metaDataXML, String fileName) {
        String toBeWrittenStr = null;
        String errCode = null;
        try {
            toBeWrittenStr = this.getXML(xlsFile, metaDataXML);
        }
        catch (Exception ex) {
            errCode = "VTXLSRERR";
            ex.printStackTrace();
        }
        try {
            this.nfFileOpen(fileName, toBeWrittenStr);
        }
        catch (Exception ex) {
            errCode = "VTFLEWERR";
            ex.printStackTrace();
        }
        return errCode == null || errCode.trim().length() == 0 ? "VTFLESUCC" : errCode;
    }

    private String nfFileOpen(String asFilepath, String asString) {
        String lsErrcode = null;
        File ediFile = null;
        OutputStreamWriter ediFileWtr = null;
        try {
            try {
                ediFile = new File(asFilepath);
                ediFileWtr = new FileWriter(ediFile);
                int liLen = asString.length();
                if (ediFile == null) {
                    lsErrcode = "VBFILEOPEN";
                }
                String lsWrite = asString;
                char[] writeCharArr = new char[lsWrite.length()];
                lsWrite.getChars(0, lsWrite.length(), writeCharArr, 0);
                ediFileWtr.write(writeCharArr);
            }
            catch (Exception ex) {
                lsErrcode = "VFLEIOERR";
                ex.printStackTrace();
                try {
                    ediFileWtr.close();
                    ediFileWtr = null;
                    ediFile = null;
                }
                catch (Exception e) {
                    lsErrcode = "VEFCLERR";
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                ediFileWtr.close();
                ediFileWtr = null;
                ediFile = null;
            }
            catch (Exception e) {
                lsErrcode = "VEFCLERR";
                e.printStackTrace();
            }
        }
        return lsErrcode;
    }

    private static String getDateInFormat(Date date, String format) {
        String currDate = null;
        Date dt = null;
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(new E12GenericUtility().getApplDateFormat());
            dt = date;
            sdf = new SimpleDateFormat(format);
            currDate = sdf.format(dt).toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return currDate;
    }
}

