/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.E12ExtServiceLocal;
import ibase.webitm.ejb.ExtServiceEventManagerLocal;
import ibase.webitm.ejb.ExtServiceEventManagerRemote;
import ibase.webitm.utility.Events;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ServiceArg;
import ibase.webitm.utility.Services;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import org.w3c.dom.NodeList;

@Stateless
public class ExtServiceEventManagerEJB
implements ExtServiceEventManagerLocal,
ExtServiceEventManagerRemote {
    HashMap<String, Hashtable<String, Events>> objectEventMap = new HashMap();
    UserInfoBean userInfobean = null;

    @Override
    public String executeSystemEvent(String objName, String eventCode, String serviceParam1, String serviceParam2, String serviceParam3, String serviceParam4, String xtraParams, String userInfo, UserInfoBean userInfoBean) throws RemoteException, ITMException {
        try {
            this.userInfobean = new UserInfoBean(userInfo);
        }
        catch (BaseException e1) {
            e1.printStackTrace();
        }
        BaseLogger.log("2", this.userInfobean, null, "[ExtServiceEventManagerEJB]Executing system events for foll params ..........:\nobjName :[" + objName + "]\neventCode :[" + eventCode + "]\nxtraParams :[" + xtraParams + "]");
        String returnStr = "";
        String compType = "";
        String compName = "";
        try {
            Events currentEvent = this.getEventObject(objName, eventCode, userInfoBean);
            if (currentEvent != null) {
                ServiceArg serviceArg;
                Services services = currentEvent.getPre();
                ArrayList serviceArgsList = services.getServiceArgs();
                int noOfArgs = serviceArgsList.size();
                BaseLogger.log("3", this.userInfobean, null, "[ExtServiceEventManagerEJB]No of arguments to service method :" + noOfArgs + ":");
                boolean serviceParam1Exist = false;
                boolean serviceParam2Exist = false;
                boolean serviceParam3Exist = false;
                boolean serviceParam4Exist = false;
                boolean xtraParamExist = false;
                boolean userInfoExist = false;
                int ctr = 0;
                while (ctr < noOfArgs) {
                    ServiceArg currArg = (ServiceArg)serviceArgsList.get(ctr);
                    String argName = currArg.getArgName().trim();
                    String argType = currArg.getArgType();
                    String argDataType = currArg.getArgDataType();
                    BaseLogger.log("3", this.userInfobean, null, "[ExtServiceEventManagerEJB]Argument name :[" + argName + "] Argument type :[" + argType + "] Argument data type :[" + argDataType + "]");
                    if (argType.equalsIgnoreCase("S")) {
                        if (argName.equalsIgnoreCase("COMPONENT_TYPE")) {
                            compType = this.getValueFromDB(objName, services.getServiceCode(), "COMP_TYPE", userInfoBean);
                            currArg.setArgValue(compType);
                        } else if (argName.equalsIgnoreCase("COMPONENT_NAME")) {
                            compName = this.getValueFromDB(objName, services.getServiceCode(), "COMP_NAME", userInfoBean);
                            currArg.setArgValue(compName);
                        } else if (argName.equalsIgnoreCase("SERVICE_PARAM_1")) {
                            currArg.setArgValue(serviceParam1);
                            serviceParam1Exist = true;
                        } else if (argName.equalsIgnoreCase("SERVICE_PARAM_2")) {
                            currArg.setArgValue(serviceParam2);
                            serviceParam2Exist = true;
                        } else if (argName.equalsIgnoreCase("SERVICE_PARAM_3")) {
                            currArg.setArgValue(serviceParam3);
                            serviceParam3Exist = true;
                        } else if (argName.equalsIgnoreCase("SERVICE_PARAM_4")) {
                            currArg.setArgValue(serviceParam4);
                            serviceParam4Exist = true;
                        } else if (argName.equalsIgnoreCase("XTRA_PARAMS")) {
                            currArg.setArgValue(xtraParams);
                            xtraParamExist = true;
                        } else if (argName.equalsIgnoreCase("USER_INFO")) {
                            currArg.setArgValue(userInfo);
                            userInfoExist = true;
                        }
                    } else if (argType.equalsIgnoreCase("C")) {
                        String currArgValue = (String)currArg.getArgValue();
                        if (argName.equalsIgnoreCase("COMPONENT_TYPE")) {
                            compType = currArgValue;
                        }
                        BaseLogger.log("3", this.userInfobean, null, "For Argument Type 'C' Arg Value :[" + currArgValue + "]");
                        currArg.setArgValue(currArgValue);
                    }
                    BaseLogger.log("3", this.userInfobean, null, "\n\ncurrArg - [" + currArg.getArgName().trim() + "]");
                    currArg = null;
                    ++ctr;
                }
                ArrayList<ServiceArg> newServiceArgsList = new ArrayList<ServiceArg>();
                if (!serviceParam1Exist) {
                    serviceArg = new ServiceArg();
                    serviceArg.setArgName("SERVICE_PARAM_1");
                    serviceArg.setArgType("S");
                    serviceArg.setArgDataType("String");
                    serviceArg.setArgValue(serviceParam1);
                    newServiceArgsList.add(serviceArg);
                }
                if (!serviceParam2Exist) {
                    serviceArg = new ServiceArg();
                    serviceArg.setArgName("SERVICE_PARAM_2");
                    serviceArg.setArgType("S");
                    serviceArg.setArgDataType("String");
                    serviceArg.setArgValue(serviceParam2);
                    newServiceArgsList.add(serviceArg);
                }
                if (!serviceParam3Exist) {
                    serviceArg = new ServiceArg();
                    serviceArg.setArgName("SERVICE_PARAM_3");
                    serviceArg.setArgType("S");
                    serviceArg.setArgDataType("String");
                    serviceArg.setArgValue(serviceParam3);
                    newServiceArgsList.add(serviceArg);
                }
                if (!serviceParam4Exist) {
                    serviceArg = new ServiceArg();
                    serviceArg.setArgName("SERVICE_PARAM_4");
                    serviceArg.setArgType("S");
                    serviceArg.setArgDataType("String");
                    serviceArg.setArgValue(serviceParam4);
                    newServiceArgsList.add(serviceArg);
                }
                if (!xtraParamExist) {
                    serviceArg = new ServiceArg();
                    serviceArg.setArgName("XTRA_PARAMS");
                    serviceArg.setArgType("S");
                    serviceArg.setArgDataType("String");
                    serviceArg.setArgValue(xtraParams);
                    newServiceArgsList.add(serviceArg);
                }
                if (!userInfoExist) {
                    serviceArg = new ServiceArg();
                    serviceArg.setArgName("USER_INFO");
                    serviceArg.setArgType("S");
                    serviceArg.setArgDataType("String");
                    serviceArg.setArgValue(userInfo);
                    newServiceArgsList.add(serviceArg);
                }
                services.setServiceArgs(newServiceArgsList);
                int ctr2 = 0;
                while (ctr2 < services.getServiceArgs().size()) {
                    ServiceArg currArg = (ServiceArg)serviceArgsList.get(ctr2);
                    String argName = currArg.getArgName().trim();
                    BaseLogger.log("3", this.userInfobean, null, "ctr - [" + ctr2 + "] : argName - [" + argName + "]");
                    ++ctr2;
                }
                BaseLogger.log("3", this.userInfobean, null, "Calling component for Comp Type :[" + compType + "]");
                if (compType.equalsIgnoreCase("EJB")) {
                    returnStr = this.callEJB(services, xtraParams);
                }
                if ((returnStr = E12GenericUtility.checkNull(returnStr)).length() >= 0) {
                    returnStr = this.handleReturnStatus(returnStr);
                }
                ctr2 = 0;
                while (returnStr != null && returnStr.indexOf("isNull") != -1) {
                    StringBuffer strBuffer = new StringBuffer(returnStr);
                    int index = strBuffer.toString().indexOf("isNull");
                    strBuffer.replace(index, index + 6, "");
                    returnStr = strBuffer.toString();
                    strBuffer = null;
                    ++ctr2;
                }
                services = null;
            }
            currentEvent = null;
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (Exception e) {
            System.err.println("Exception :ExtServiceEventManagerEJB :executeSystemEvent :==>\n" + e.getMessage());
            throw new ITMException(e);
        }
        return returnStr;
    }

    private String callEJB(Services serviceObj, String xtraParams) throws ITMException {
        BaseLogger.log("2", this.userInfobean, null, "Calling EJB.................");
        String returnValue = null;
        try {
            ArrayList serviceArgsList = serviceObj.getServiceArgs();
            int noOfArgs = serviceArgsList.size();
            String componentName = (String)((ServiceArg)serviceArgsList.get(1)).getArgValue();
            String methodName = serviceObj.getMethodName().trim();
            BaseLogger.log("3", this.userInfobean, null, "componentName :[" + componentName + "], methodName :[" + methodName + "]");
            int arrLen = noOfArgs - 2;
            Class[] paramSpec = new Class[arrLen];
            Object[] params = new Object[arrLen];
            int argCtr = 2;
            while (argCtr < noOfArgs) {
                String argDataType = ((ServiceArg)serviceArgsList.get(argCtr)).getArgDataType();
                if (argDataType.length() == 0 || argDataType.indexOf("String") != -1) {
                    paramSpec[argCtr - 2] = Class.forName("java.lang.String");
                } else if (argDataType.indexOf("Connection") != -1) {
                    paramSpec[argCtr - 2] = Class.forName("java.sql.Connection");
                }
                params[argCtr - 2] = ((ServiceArg)serviceArgsList.get(argCtr)).getArgValue();
                BaseLogger.log("3", this.userInfobean, null, "argCtr - [" + argCtr + "] : value - [" + ((ServiceArg)serviceArgsList.get(argCtr)).getArgValue() + "]");
                ++argCtr;
            }
            BaseLogger.log("3", this.userInfobean, null, "paramSpec length :[" + paramSpec.length + "], params length :[" + params.length + "]");
            Class<?> classObj = null;
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            String lookUpName = "ibase/" + componentName + "/" + "local";
            E12ExtServiceLocal valComp = (E12ExtServiceLocal)ctx.lookup(lookUpName);
            classObj = Class.forName(valComp.getClass().getName());
            BaseLogger.log("3", this.userInfobean, null, "EJB found !!!!!!!!!");
            Method metObj = classObj.getMethod(methodName, paramSpec);
            metObj.setAccessible(true);
            returnValue = (String)metObj.invoke((Object)valComp, params);
        }
        catch (ITMException itme) {
            throw itme;
        }
        catch (InvocationTargetException invTargetExcp) {
            Exception causedBy = (Exception)invTargetExcp.getCause();
            causedBy.printStackTrace();
            throw new ITMException(causedBy);
        }
        catch (Exception e) {
            System.err.println("Exception :ExtServiceEventManagerEJB :callEJB :\n" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfobean, null, "Return String from callEJB :[" + returnValue + "]");
        return returnValue;
    }

    private Events getEventObject(String objName, String eventCode, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "[ExtServiceEventManagerEJB]Looking for event object corresponding to object name :[" + objName + "] FOR event code :[" + eventCode + "]");
        Hashtable<String, Events> currEventTable = null;
        Events currentEvent = null;
        try {
            Events tempEvent;
            if (!this.objectEventMap.containsKey(objName)) {
                this.fillSystemEvents(objName, userInfo);
            }
            if ((tempEvent = (currEventTable = this.objectEventMap.get(objName)).get(eventCode)) != null) {
                currentEvent = new Events();
                currentEvent.setObjName(tempEvent.getObjName());
                currentEvent.setEventCode(tempEvent.getEventCode());
                currentEvent.setEventContext(tempEvent.getEventContext());
                currentEvent.setServiceCode(tempEvent.getServiceCode());
                currentEvent.setMethodRule(tempEvent.getMethodRule());
                currentEvent.setOverwriteCore(tempEvent.getOverwriteCore());
                currentEvent.setResultHandle(tempEvent.getResultHandle());
                currentEvent.setPre(tempEvent.getPre());
            } else {
                BaseLogger.log("3", userInfo, null, "No Such Event " + eventCode + " Found for object [" + objName + "] Check Database Entry (if required)");
            }
            if (tempEvent != null) {
                tempEvent = null;
            }
        }
        catch (ITMException itme) {
            currEventTable = null;
            currentEvent = null;
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", userInfo, null, "Exception :ExtServiceEventManagerEJB :getEventObject :==>" + e);
            currEventTable = null;
            currentEvent = null;
            throw new ITMException(e);
        }
        BaseLogger.log("2", userInfo, null, "[ExtServiceEventManagerEJB]Returning the current event object :" + currentEvent + ": !!!!!!!!");
        return currentEvent;
    }

    private void fillSystemEvents(String objName, UserInfoBean userInfo) throws ITMException {
        BaseLogger.log("2", userInfo, null, "[ExtServiceEventManagerEJB]Filling system events for object name :" + objName + ":");
        Hashtable eventTable = null;
        try {
            Events events = new Events();
            eventTable = events.execute(objName, userInfo);
            this.objectEventMap.put(objName, eventTable);
            events = null;
        }
        catch (ITMException itme) {
            eventTable = null;
            BaseLogger.log("0", userInfo, null, "Exception :ExtServiceEventManagerEJB :fillSystemEvents :ITMException :==>" + itme);
            throw itme;
        }
        catch (Exception e) {
            eventTable = null;
            BaseLogger.log("0", userInfo, null, "Exception :ExtServiceEventManagerEJB :fillSystemEvents :Exception :==>" + e);
            throw new ITMException(e);
        }
    }

    private String getValueFromDB(String objName, String serviceCode, String fieldName, UserInfoBean userInfo) throws ITMException {
        String retValue = null;
        Connection mConnection = null;
        Statement stmt = null;
        ResultSet rs = null;
        String transDB = "";
        try {
            try {
                ConnDriver mConnDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                mConnection = mConnDriver.getConnectDB(transDB);
                mConnDriver = null;
                String selectQuery = "SELECT " + fieldName + " FROM SYSTEM_EVENTS WHERE OBJ_NAME='" + objName + "' AND SERVICE_CODE='" + serviceCode + "'";
                stmt = mConnection.createStatement();
                rs = stmt.executeQuery(selectQuery);
                if (rs.next()) {
                    retValue = rs.getString(1);
                }
                rs.close();
                rs = null;
                stmt.close();
                stmt = null;
            }
            catch (ITMException itme) {
                throw itme;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ExtServiceEventManagerEJB :getValueFromDB :==>");
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :ExtServiceEventManagerEJB :getValueFromDB :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "[ExtServiceEventManagerEJB]Returning value from db :[" + retValue.length() + "]");
        return retValue;
    }

    private String handleReturnStatus(String errorStr) throws ITMException {
        String returnStr = errorStr;
        try {
            if (errorStr.indexOf("error") != -1) {
                E12GenericUtility genericUtility = new E12GenericUtility();
                NodeList errorNodeList = genericUtility.parseString(returnStr).getElementsByTagName("error");
                if (errorNodeList.item(0) != null) {
                    String errorType = errorNodeList.item(0).getAttributes().getNamedItem("type").getNodeValue();
                    if ("E".equals(errorType) || "W".equals(errorType) || "P".equals(errorType) || "F".equals(errorType) || "".equals(errorType)) {
                        return errorStr;
                    }
                    returnStr = "<Root><message>Success</message><statusCode></statusCode><descr></descr><trace></trace></Root>";
                } else {
                    BaseLogger.log("3", null, null, "No error Found");
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception :ExtServiceEventManagerEJB :handleReturnStatus :\n" + e.getMessage());
            throw new ITMException(e);
        }
        return returnStr;
    }
}

