<%@page import="javax.servlet.*, javax.servlet.http.*, java.io.*, ibase.utility.CommonConstants, org.apache.commons.lang.StringEscapeUtils"%>
<%
String fileName = request.getParameter("FileName");
String sep = File.separator;
File file = new File(CommonConstants.JBOSSHOME + sep + "upload_failed" + sep + fileName);
String filePath = file.getAbsolutePath();
%>

<html>
<head> 
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>VisionEDI Log</title> 
    <style>
        input[type="button"] {
            margin: 0px 0px 0px 1100px;
            font-size: 15px;
            text-align: bottom;
            display: inline-block;
            border-radius: 4px;
        }
        h2 {
            font-size: 20px;
            text-align: bottom;
            display: inline-block;
            margin: 0px 0px 0px 0px;
        }

        body {
        font-family: calibri;
        margin: 0;
        padding: 0;
        overflow: hidden;
    }

    .header {
        display: flex;
        align-items: center;
        height: 50px;
        padding: 0 16px;
    }

    .file-info {
        font-size: 1.5em;
        font-weight: 600;
        text-align: left;
        min-height: 50px;
        display: flex;
        align-items: center;
        width: calc(100% - 150px);
        white-space: nowrap;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    .buttons-container {
        display: flex;
        align-items: center;
        position: relative;
    }

    .download-button,
    .return-button {
        border-style: none;
        font-size: 12px;
        border-radius: 4px;
        box-shadow: 1px 1px 5px 2px rgba(0, 0, 0, .2);
        height: 30px;
        padding: 0 12px;
        color: #fff;
        letter-spacing: 1px;
        font-weight: 600;
        text-transform: uppercase;
        cursor: pointer;
    }

    .download-button {
        background-color: #1da51d;
        margin-right: 10px;
    }

    .return-button {
        background-color: #1da51d;
        position: absolute;
        right: 0;
        margin: 0;
    }

    .content-container {
        padding: 16px;
        height: calc(100% - 98px);
        overflow: auto;
        box-shadow: 0px 0px 1px 1px rgba(0, 0, 0, .2);
        margin: 0 16px 16px 16px;
        border-radius: 3px;
    }
    </style>
</head>
<body style="font-family: calibri; margin: 0; padding: 0; overflow: hidden;">

       

                  
            
            <div class="buttons-container">
                <p class="file-info">
                    File Name : <%= fileName %>
                </p> 
                <input type="button" class="download-button" value="Download" onclick="downloadFile()" size="40">
                <input type="button" class="return-button" value="Return" onclick="history.back()" style="margin-left: 10px;">
            </div>
        </form>

    <div id="fileContent" style="padding: 16px; height: calc(100% - 98px); overflow: auto; box-shadow: 0px 0px 1px 1px rgba(0,0,0,.2); margin: 0 16px 16px 16px; border-radius: 3px;">
        <% if (!filePath.endsWith(".log")) {
            file = new File(CommonConstants.JBOSSHOME + sep + "upload_failed" + sep + fileName);
        }
        if (file.exists()) {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String fileContents = "";
            while ((fileContents = br.readLine()) != null) {
                out.println(StringEscapeUtils.escapeXml(fileContents.toString()) + "<br>");
            }
        %>
    </div>

    <!-- Add the styled download button outside the div -->
    <% } else { %>
    <%= fileName + " file not found" %>
    <% } %>    

    <script>
        function downloadFile() {
            var fileContent = document.getElementById('fileContent').innerText;
            var blob = new Blob([fileContent], { type: 'text/plain' });
            var link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = '<%= fileName %>';
            link.click();
        }
    </script>

</body>
</html>