/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import com.itextpdf.text.pdf.PdfReader;
import ibase.ai.entityid.AIEngine;
import ibase.ai.entityid.DocumentProcessTrail;
import ibase.ai.entityid.ItemLookUp;
import ibase.ai.entityid.RasaAIEngine;
import ibase.ai.entityid.WitAIEngine;
import ibase.ejb.CommonDBAccessEJB;
import ibase.hibernate.dao.DocTypeProcDAO;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.InvoiceReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;

public class BulkDocExtraction
extends ProcessEJB {
    E12GenericUtility genericUtility = new E12GenericUtility();
    ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    @Override
    public String process() throws ITMException {
        return "";
    }

    @Override
    public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException, ITMException {
        Document detailDom = null;
        Document headerDom = null;
        E12GenericUtility genericUtility = new E12GenericUtility();
        String retStr = "";
        BaseLogger.log("2", null, null, "04122023 xmlString==" + xmlString);
        BaseLogger.log("2", null, null, "04122023 xmlString2==" + xmlString2);
        try {
            if (xmlString != null && xmlString.trim().length() != 0) {
                headerDom = genericUtility.parseString(xmlString);
            }
            if (xmlString2 != null && xmlString2.trim().length() != 0) {
                detailDom = genericUtility.parseString(xmlString2);
            }
            retStr = this.process(headerDom, detailDom, windowName, xtraParams);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BulkDocExtraction :process(String xmlString, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
            e.printStackTrace();
            retStr = e.getMessage();
        }
        return retStr;
    }

    @Override
    public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException, ITMException {
        Object parentNodeList = null;
        Object childNodeList = null;
        String errString = " ";
        Object parentNode = null;
        Object childNode = null;
        ConnDriver connDriver = new ConnDriver();
        Connection conn = null;
        String userId = "";
        String fromDate = "";
        String toDate = "";
        Object detailNodeList = null;
        boolean nodeListLength = false;
        Object detailNode = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Object url = null;
        Object postDataBytes = null;
        Object con = null;
        String objName = "invoice-transaction";
        try {
            if (conn == null) {
                conn = this.getConnection();
                conn.setAutoCommit(false);
            }
            BaseLogger.log("3", null, null, "BulkDocExtraction ejbCreate called.........");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :BulkDocExtraction :ejbCreate :==>" + e.getMessage());
        }
        try {
            try {
                int counter = 1;
                UserInfoBean userInfo = this.getUserInfo();
                userId = this.checkNull(this.genericUtility.getColumnValue("user_id", detailDom));
                fromDate = this.checkNull(this.genericUtility.getColumnValue("from_date", detailDom));
                toDate = this.checkNull(this.genericUtility.getColumnValue("to_date", detailDom));
                BaseLogger.log("2", null, null, "userId===" + userId);
                BaseLogger.log("2", null, null, "fromDate==" + fromDate);
                BaseLogger.log("2", null, null, "toDate==" + toDate);
                if ("".equalsIgnoreCase(userId)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "NULENTC", "", "", conn);
                } else if ("".equalsIgnoreCase(fromDate)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "NULFRDT", "", "", conn);
                } else if ("".equalsIgnoreCase(toDate)) {
                    errString = this.itmDBAccessEJB.getErrorString("", "NULTODT", "", "", conn);
                } else {
                    String sql = "SELECT DC.OVERVIEW_DATA AS OVERVIEW_DATA, UDC.DOC_ID AS DOC_ID FROM USER_DOC_CONTENTS UDC, DOC_CONTENTS DC\nWHERE UDC.CREA_DATE BETWEEN ? AND ? AND UDC.USER_ID=? AND DC.DOC_ID=UDC.DOC_ID";
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setTimestamp(1, Timestamp.valueOf(this.genericUtility.getValidDateTimeString(fromDate, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat())));
                    pstmt.setTimestamp(2, Timestamp.valueOf(this.genericUtility.getValidDateTimeString(toDate, this.genericUtility.getApplDateFormat(), this.genericUtility.getDBDateFormat())));
                    pstmt.setString(3, userId);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        BaseLogger.log("2", null, null, "count of documents which are refreshed [" + counter + "]");
                        String overviewData = rs.getString("OVERVIEW_DATA");
                        String docId = rs.getString("DOC_ID");
                        try {
                            this.refreshDocument(overviewData, docId, objName, userInfo);
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Something went wrong while refreshing the document with document Id = " + docId + " \n Following is the cause of Exception:::>" + e.getMessage());
                            e.printStackTrace();
                        }
                        ++counter;
                    }
                    errString = counter > 1 ? this.itmDBAccessEJB.getErrorString("", "REFSUC", "", "", conn) : this.itmDBAccessEJB.getErrorString("", "REFAIL", "", "", conn);
                }
                BaseLogger.log("3", null, null, "04122023 errString:::[" + errString + "]");
            }
            catch (Exception e) {
                try {
                    conn.rollback();
                }
                catch (Exception d) {
                    BaseLogger.log("0", null, null, "Exception : BulkDocExtraction =>" + d.toString());
                }
                BaseLogger.log("0", null, null, "Exception :BulkDocExtraction :process(String xmlString2, String xmlString2, String windowName, String xtraParams):" + e.getMessage() + ":");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            BaseLogger.log("3", null, null, "Closing Connection....");
            try {
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                errString = e.getMessage();
                e.printStackTrace();
                return errString;
            }
        }
        return errString;
    }

    private void refreshDocument(String jsonString, String docId, String objName, UserInfoBean userInfo) throws JSONException {
        JSONObject extractedData;
        block51: {
            DocumentHandlerWrapperEJB docHandlerWrpEJB = new DocumentHandlerWrapperEJB();
            DocumentProcessTrail docProcTrail = new DocumentProcessTrail();
            InvoiceReader invoiceReader = new InvoiceReader();
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            DocTypeProcDAO docTypeProcDAO = new DocTypeProcDAO();
            JSONObject procTrailObj = new JSONObject();
            extractedData = new JSONObject();
            JSONObject queryParamObj = new JSONObject();
            String extData = "";
            String currentProcMtd = "";
            String currentReqParamTrail = "";
            String procApiName = "";
            String procStatus = "I";
            String errMessage = "";
            String errorJson = "";
            String indexName = "import-orders";
            JSONObject overviewData = new JSONObject();
            JSONObject jsonObject = new JSONObject();
            try {
                BaseLogger.log("3", userInfo, null, "Inside refreshDocument");
                docHandlerWrpEJB.setUserInfo(userInfo);
                queryParamObj = new JSONObject(jsonString);
                queryParamObj.put("ai_proc_variables", (Object)new JSONObject(queryParamObj.optString("ai_proc_variables")));
                String documentType = queryParamObj.optString("doc_type");
                CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
                String extractTempl = E12GenericUtility.checkNull(commonDBAccessEJB.getDBColumnValue("OBJ_ATTACH_CONFIG", "EXTRACT_TEMPL", "WHERE OBJ_NAME='" + objName + "' AND DOC_TYPE='" + documentType + "'", userInfo.getTransDB()));
                procApiName = this.checkNull(queryParamObj.optString("proc_mtd"));
                String[] procMethods = procApiName.split("-");
                procTrailObj = docProcTrail.createDocTrailJSON(procMethods, procApiName);
                currentProcMtd = procMethods[0];
                docProcTrail.configureProcTrail(docId, procApiName, procMethods[0], userInfo);
                String ocrData = this.checkNull(docProcTrail.getResponseData());
                Object node = null;
                String entType = queryParamObj.optString("ent_type");
                errMessage = docHandlerWrpEJB.validateCustomerDetails(this.checkNull(queryParamObj.optString("ent_type")), this.checkNull(queryParamObj.optString("ent_code")), userInfo);
                if ("".equalsIgnoreCase(this.checkNull(errMessage))) {
                    APIUtility apiUtility = new APIUtility();
                    if ("".equalsIgnoreCase(this.checkNull(queryParamObj.optString("proc_mtd"))) || "".equalsIgnoreCase(this.checkNull(queryParamObj.optString("ai_proc_templ"))) || "".equalsIgnoreCase(this.checkNull(queryParamObj.optString("ai_proc_variables")))) {
                        JSONObject tempObj = docTypeProcDAO.getDocTypeProcParams(userInfo, documentType, queryParamObj.optString("ent_type"), queryParamObj.optString("ent_code"), queryParamObj.optString("file_type"));
                        if ("".equalsIgnoreCase(this.checkNull(queryParamObj.optString("proc_mtd")))) {
                            queryParamObj.put("proc_mtd", (Object)tempObj.optString("proc_mtd"));
                        }
                        if ("".equalsIgnoreCase(this.checkNull(queryParamObj.optString("ai_proc_templ")))) {
                            queryParamObj.put("ai_proc_templ", (Object)tempObj.optString("ai_proc_templ"));
                        }
                        if ("".equalsIgnoreCase(this.checkNull(queryParamObj.optString("ai_proc_variables")))) {
                            queryParamObj.put("ai_proc_variables", (Object)tempObj.optString("ai_proc_variables"));
                        }
                    }
                    queryParamObj.put("extract_templ", (Object)extractTempl);
                    queryParamObj.put("objName", (Object)objName);
                    queryParamObj.put("userId", (Object)userInfo.getLoginCode());
                    queryParamObj.put("enterprise", (Object)userInfo.getEnterprise());
                    ArrayList<String> apiKeyParams = apiUtility.getAPIKey(userInfo, queryParamObj.optString("proc_mtd"));
                    if (!apiKeyParams.isEmpty() && apiKeyParams.size() > 0) {
                        queryParamObj.put("proc_api_key", (Object)apiKeyParams.get(0));
                    }
                    String procApiScope = "";
                    if (!apiKeyParams.isEmpty() && apiKeyParams.size() > 1) {
                        procApiScope = apiKeyParams.get(1);
                    }
                    currentReqParamTrail = queryParamObj.toString();
                    String dataExtractorServiceURL = "";
                    String respString = "";
                    JSONObject responseObj = null;
                    int status = 0;
                    errorJson = E12GenericUtility.checkNull(e12GenericUtility.isRequestLimitExceeded(userInfo.getEnterprise(), "JSON", userInfo));
                    BaseLogger.log("2", null, null, "line no 2395 errMessage: [" + errorJson + "]");
                    if ("".equalsIgnoreCase(errorJson)) {
                        if ("".equalsIgnoreCase(ocrData)) {
                            queryParamObj.put("IS_OCR_EXIST", (Object)"false");
                            String fileName = docHandlerWrpEJB.getDocumentFile(docId, userInfo.getTransDB());
                            String docContentDetails = docHandlerWrpEJB.getDocContentDetails(docId, userInfo);
                            JSONObject jsonObj = new JSONObject(docContentDetails);
                            File file = new File(fileName);
                            BaseLogger.log("3", null, null, "24032023 fileName [" + fileName + "]");
                            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
                            System.out.println("print fileType line no 2445:::::::::" + fileType);
                            Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
                            BaseLogger.log("3", null, null, "InvoiceReader readInvoice() getDataExtractorServiceURL pythonServicesMap::" + pythonServicesMap);
                            if (pythonServicesMap != null) {
                                Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
                                String protocol = proteusSenseServiceDetails.get("PROTOCOL");
                                String host = proteusSenseServiceDetails.get("HOST");
                                String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
                                String path = proteusSenseServiceDetails.get("ENDPOINT");
                                dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
                            }
                            String encodedParams = URLEncoder.encode(queryParamObj.toString(), "UTF-8");
                            String dataExtractorService = String.valueOf(dataExtractorServiceURL) + "?jsonData=" + encodedParams;
                            BaseLogger.log("3", null, null, "2430 makeMultipartRequest START [" + System.currentTimeMillis() + "]");
                            byte[] ocrResponse = E12GenericUtility.makeMultipartRequest(dataExtractorService, file);
                            int noOfPages = 1;
                            if ("pdf".equalsIgnoreCase(fileType) && file != null) {
                                FileInputStream pdfFileStream = new FileInputStream(file);
                                noOfPages = this.getPDFNumberOfPages(pdfFileStream);
                                ((InputStream)pdfFileStream).close();
                            }
                            e12GenericUtility.createAIApiLog(userInfo, noOfPages, objName, "OpenAI");
                            BaseLogger.log("3", null, null, "2432 makeMultipartRequest END [" + System.currentTimeMillis() + "]");
                            respString = new String(ocrResponse);
                            BaseLogger.log("3", null, null, " result [" + respString + "]");
                            responseObj = new JSONObject(respString);
                            status = respString.indexOf("\"Errors\"") != -1 || respString.indexOf("\"error\"") != -1 || respString.indexOf("</Errors>") != -1 || respString.indexOf("</error>") != -1 ? 0 : responseObj.getInt("status");
                            if (status == 1) {
                                JSONObject ocrDataObj = new JSONObject();
                                ocrDataObj = responseObj.optJSONObject("result");
                                if (ocrDataObj.has("OCR_DATA")) {
                                    ocrData = ocrDataObj.optString("OCR_DATA");
                                    procTrailObj.put(procMethods[0], (Object)docProcTrail.setProcTrailJSON(procApiName, ocrData, currentReqParamTrail, ""));
                                } else {
                                    BaseLogger.log("3", null, null, "OCR Data not found in response");
                                }
                            } else {
                                procTrailObj.put(procMethods[0], (Object)docProcTrail.setProcTrailJSON(procApiName, ocrData, currentReqParamTrail, respString));
                            }
                        } else {
                            queryParamObj.put("OCR_DATA", (Object)ocrData);
                            procTrailObj.put(procMethods[0], (Object)"");
                            Map<String, Map<String, String>> pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
                            if (pythonServicesMap != null) {
                                Map<String, String> proteusSenseServiceDetails = pythonServicesMap.get("DATA_EXTRACTOR");
                                String protocol = proteusSenseServiceDetails.get("PROTOCOL");
                                String host = proteusSenseServiceDetails.get("HOST");
                                String port = E12GenericUtility.checkNull(proteusSenseServiceDetails.get("PORT"));
                                String path = "proteusservices/OpenAIDataExtractor/getlayouttextaidata";
                                dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
                            }
                            String fileName = docHandlerWrpEJB.getDocumentFile(docId, userInfo.getTransDB());
                            File file = new File(fileName);
                            BaseLogger.log("3", null, null, "24032023 fileName [" + fileName + "]");
                            String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
                            BaseLogger.log("3", null, null, "callPythonService START [" + System.currentTimeMillis() + "]");
                            respString = e12GenericUtility.callPythonService(dataExtractorServiceURL, queryParamObj, userInfo);
                            int noOfPages = 1;
                            if ("pdf".equalsIgnoreCase(fileType) && file != null) {
                                FileInputStream pdfFileStream = new FileInputStream(file);
                                noOfPages = this.getPDFNumberOfPages(pdfFileStream);
                                ((InputStream)pdfFileStream).close();
                            }
                            e12GenericUtility.createAIApiLog(userInfo, noOfPages, objName, "OpenAI");
                            BaseLogger.log("3", null, null, "callPythonService END [" + System.currentTimeMillis() + "]");
                            responseObj = new JSONObject(respString);
                            status = respString.indexOf("\"Errors\"") != -1 || respString.indexOf("\"error\"") != -1 || respString.indexOf("</Errors>") != -1 || respString.indexOf("</error>") != -1 ? 0 : responseObj.getInt("status");
                        }
                    } else {
                        jsonObject = new JSONObject(errorJson);
                    }
                    apiUtility.writeApiCallLog(userInfo, respString, "" + status, "", "", jsonString, procApiName, dataExtractorServiceURL, procApiScope, "A", "", "");
                    if (status == 1) {
                        ItemLookUp itemLookup;
                        JSONObject jsonItemCodes;
                        String result;
                        AIEngine aiEngine;
                        extractedData = responseObj.optJSONObject("result");
                        if (procMethods.length > 1 && procMethods[1].contains("AI")) {
                            String csvData = extractedData.optString("EXTRACT_LAYOUT_DATA");
                            procTrailObj.put(procMethods[1], (Object)docProcTrail.setProcTrailJSON(procApiName, csvData, currentReqParamTrail, ""));
                            extractedData = e12GenericUtility.convertCSVToJSON(csvData, userInfo);
                            if (procMethods.length > 2 && (E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("VIL") || E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("AIL"))) {
                                JSONArray extJsonArray = extractedData.optJSONArray("lines");
                                String aiProcVariables = queryParamObj.optString("ai_proc_variables");
                                String queryString = invoiceReader.pineConeVLookup(extJsonArray, procMethods[2], apiKeyParams.get(0), null, aiProcVariables, userInfo);
                                procTrailObj.put(procMethods[2], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), queryString, ""));
                            }
                            BaseLogger.log("3", null, null, "BulkDocExtraction procMethods at 1 [" + procMethods[1] + "]");
                            if (procMethods.length > 2 && (E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("IL") || E12GenericUtility.checkNull(procMethods[2]).equalsIgnoreCase("AIL"))) {
                                ItemLookUp itemLookup2 = new ItemLookUp();
                                extractedData = itemLookup2.itemCodeLookUp(extractedData, procMethods, userInfo);
                                procTrailObj.put(procMethods[2], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                            }
                            if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                                procTrailObj.put(procMethods[procMethods.length - 1], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                            }
                        } else {
                            extractedData = responseObj.getJSONObject("result");
                        }
                        String dataJsonStr = extractedData.toString();
                        if (procMethods.length > 2 && "ADW".equalsIgnoreCase(procMethods[2])) {
                            aiEngine = new WitAIEngine();
                            result = ((WitAIEngine)aiEngine).getItemCodeList(dataJsonStr, null);
                            currentReqParamTrail = ((WitAIEngine)aiEngine).getProcTrailObj().optString("REQUEST_PARAM");
                            procTrailObj.put("ADW", (Object)docProcTrail.setProcTrailJSON(procApiName, ((WitAIEngine)aiEngine).getProcTrailObj().optString("RESPONSE_DATA"), currentReqParamTrail, ""));
                            jsonItemCodes = new JSONObject(result);
                            jsonItemCodes = jsonItemCodes.getJSONObject("result");
                            jsonItemCodes = jsonItemCodes.getJSONObject("itemCodeList");
                            extractedData.put("itemCodeList", (Object)jsonItemCodes);
                            if (procMethods.length > 3 && "IL".equalsIgnoreCase(procMethods[3])) {
                                itemLookup = new ItemLookUp();
                                extractedData = itemLookup.itemCodeLookUp(extractedData, procMethods, userInfo);
                                procTrailObj.put(procMethods[3], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                                if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                                    procTrailObj.put(procMethods[procMethods.length - 1], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                                }
                            }
                        } else if (procMethods.length > 2 && "ADR".equalsIgnoreCase(procMethods[2])) {
                            aiEngine = new RasaAIEngine();
                            result = ((RasaAIEngine)aiEngine).getItemCodeList(dataJsonStr, userInfo);
                            currentReqParamTrail = ((RasaAIEngine)aiEngine).getProcTrailObj().optString("REQUEST_PARAM");
                            procTrailObj.put("ADR", (Object)docProcTrail.setProcTrailJSON(procApiName, ((RasaAIEngine)aiEngine).getProcTrailObj().optString("RESPONSE_DATA"), currentReqParamTrail, ""));
                            jsonItemCodes = new JSONObject(result);
                            extractedData.put("itemCodeList", (Object)jsonItemCodes);
                            if (procMethods.length > 3 && "IL".equalsIgnoreCase(procMethods[3])) {
                                itemLookup = new ItemLookUp();
                                extractedData = itemLookup.itemCodeLookUp(extractedData, procMethods, userInfo);
                                procTrailObj.put(procMethods[3], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                                if ("UC".equalsIgnoreCase(procMethods[procMethods.length - 1])) {
                                    procTrailObj.put(procMethods[procMethods.length - 1], (Object)docProcTrail.setProcTrailJSON(procApiName, extractedData.toString(), currentReqParamTrail, ""));
                                }
                            }
                        }
                        procStatus = "C";
                    } else {
                        JSONArray errorsArray;
                        JSONObject rootObj;
                        errMessage = jsonObject.optString("error");
                        if ("".equalsIgnoreCase(errMessage) && (rootObj = jsonObject.optJSONObject("Root")) != null && (errorsArray = rootObj.optJSONArray("Errors")) != null) {
                            JSONObject errorObj;
                            JSONObject jSONObject = errorObj = errorsArray.optJSONObject(0) != null ? errorsArray.optJSONObject(0).optJSONObject("error") : null;
                            if (errorObj != null) {
                                respString = errorObj.optString("description");
                                currentProcMtd = procMethods.length > 1 ? procMethods[1] : currentProcMtd;
                            }
                        }
                        procTrailObj.put(currentProcMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, respString));
                        procStatus = "E";
                        BaseLogger.log("3", null, "Documenthandlrservlet()", "Error occurred while extracting data [" + jsonObject.toString() + "]");
                    }
                }
            }
            catch (Exception e) {
                procStatus = "E";
                procTrailObj.put(currentProcMtd, (Object)docProcTrail.setProcTrailJSON(procApiName, "", currentReqParamTrail, e12GenericUtility.writePrintStacktrace(e)));
                BaseLogger.log("0", null, null, "Exception :1: BulkDocExtraction[refreshDocument]] [" + e.getMessage() + "]");
            }
            try {
                try {
                    if (extractedData == null) {
                        extractedData = new JSONObject();
                    }
                    if (queryParamObj != null && queryParamObj.length() > 0) {
                        extractedData.put("ent_code", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ent_code")));
                        extractedData.put("ent_name", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ent_name")));
                        if (!"".equalsIgnoreCase(queryParamObj.optString("ent_code")) && "".equalsIgnoreCase(this.checkNull(queryParamObj.optString("order_type")))) {
                            String ordType = docTypeProcDAO.getDistChannel(queryParamObj.optString("ent_code"), userInfo);
                            queryParamObj.put("order_type", (Object)ordType);
                        }
                        overviewData = new JSONObject();
                        overviewData.put("doc_type", (Object)E12GenericUtility.checkNull(queryParamObj.optString("doc_type")));
                        overviewData.put("ent_type", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ent_type")));
                        overviewData.put("ent_code", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ent_code")));
                        overviewData.put("ent_name", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ent_name")));
                        overviewData.put("order_type", (Object)E12GenericUtility.checkNull(queryParamObj.optString("order_type")));
                        overviewData.put("file_type", (Object)E12GenericUtility.checkNull(queryParamObj.optString("file_type")));
                        overviewData.put("proc_mtd", (Object)E12GenericUtility.checkNull(queryParamObj.optString("proc_mtd")));
                        overviewData.put("ai_proc_templ", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ai_proc_templ")));
                        overviewData.put("ai_proc_variables", (Object)E12GenericUtility.checkNull(queryParamObj.optString("ai_proc_variables")));
                        String overviewDataStr = String.valueOf(overviewData);
                        docHandlerWrpEJB.updateOverviewData(docId, overviewDataStr, userInfo);
                    }
                    extData = "".equalsIgnoreCase(this.checkNull(errMessage)) ? String.valueOf(extractedData) : errMessage;
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :2: BulkDocExtraction[refreshDocument]] [" + e.getMessage() + "]");
                    extData = String.valueOf(new JSONObject());
                    try {
                        docHandlerWrpEJB.saveDocProcessTrail(docId, procTrailObj.toString(), userInfo);
                        docHandlerWrpEJB.updateExtractedData(docId, extData, userInfo);
                        docHandlerWrpEJB.updateProcessStatus(docId, procStatus, userInfo);
                    }
                    catch (Exception e2) {
                        BaseLogger.log("0", null, null, "Exception :3: BulkDocExtraction[refreshDocument]] [" + e2.getMessage() + "]");
                    }
                    break block51;
                }
            }
            catch (Throwable throwable) {
                try {
                    docHandlerWrpEJB.saveDocProcessTrail(docId, procTrailObj.toString(), userInfo);
                    docHandlerWrpEJB.updateExtractedData(docId, extData, userInfo);
                    docHandlerWrpEJB.updateProcessStatus(docId, procStatus, userInfo);
                }
                catch (Exception e) {
                    BaseLogger.log("0", null, null, "Exception :3: BulkDocExtraction[refreshDocument]] [" + e.getMessage() + "]");
                }
                throw throwable;
            }
            try {
                docHandlerWrpEJB.saveDocProcessTrail(docId, procTrailObj.toString(), userInfo);
                docHandlerWrpEJB.updateExtractedData(docId, extData, userInfo);
                docHandlerWrpEJB.updateProcessStatus(docId, procStatus, userInfo);
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :3: BulkDocExtraction[refreshDocument]] [" + e.getMessage() + "]");
            }
        }
        BaseLogger.log("3", null, null, "refreshDocument extractedData[" + extractedData + "]");
    }

    private int getPDFNumberOfPages(InputStream pdfFileStream) {
        int noOfPages = 0;
        try {
            PdfReader pdfReader = new PdfReader(pdfFileStream);
            noOfPages = pdfReader.getNumberOfPages();
        }
        catch (IOException ex) {
            BaseLogger.log("0", null, null, "IOException in BulkDocExtraction :: getPDFNumberOfPages() : " + ex);
        }
        catch (Throwable throwable) {
            BaseLogger.log("0", null, null, "Exception or Error in BulkDocExtraction :: getPDFNumberOfPages() : " + throwable);
            BaseLogger.log("0", null, null, "The PDF file may be password protected or locked from copying, printing and modifying etc.\nFor error detailing, refer below stack trace");
            String stackTrace = this.buildStackTrace(throwable);
            BaseLogger.log("0", null, null, stackTrace);
        }
        BaseLogger.log("2", null, null, "BulkDocExtraction :: getPDFPageCount() : noOfPages [" + noOfPages + "]");
        return noOfPages;
    }

    private String buildStackTrace(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] elements = ex.getStackTrace();
        sb.append(String.format("%s : %s\n", ex.getClass().getSimpleName(), ex.getMessage()));
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            sb.append(String.format("\tat %s\n", element.toString()));
            ++n2;
        }
        return sb.toString();
    }

    private String checkNull(String input) {
        if (input == null || "null".equalsIgnoreCase(input)) {
            input = "";
        }
        return input.trim();
    }
}

