package ibase.webService.createDataModel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class GetSiteDetails extends ValidatorEJB {
	
	DBAccessEJB dbAccessEJB = new DBAccessEJB();
	
	public String getSiteDetails(String inputData,String xtraParams) {
		try {
			BaseLogger.log("3", null,  null, "GetSiteDetails.getSiteDetails() gsb local xtraParam:::" + xtraParams );			
			UserInfoBean userInfo = super.getUserInfo();
			
    		String loginCode = userInfo.getLoginCode().trim();
    		String profileId = userInfo.getProfileId().trim();
    		String userLevel = userInfo.getUserLevel().trim();
    		String transDB = userInfo.getTransDB().trim();
    		String finEntity = userInfo.getFin_entity().trim();
    		BaseLogger.log("3", null, null,"loginCode : ["+loginCode+"] & profileId : ["+profileId+"] & userLevel : ["+userLevel+"]");
    		BaseLogger.log("3", null, null,"transDB : ["+transDB+"] & finEntity : ["+finEntity+"]");
    		//String loginUserId ,String userLevel ,String profileId, String transDB, String fin_entity
    		String result = getSiteCodeDetailsJSON(loginCode, userLevel, profileId, transDB, finEntity );
    		BaseLogger.log("3", null, null,"result of getSiteCodeDetails method ["+result+"]");
    		
    		
    		return result;
		} catch (Exception e) {
			BaseLogger.log("0", null,  null, "GetSiteDetails.getFavoriteMenu() Exception:::" + e.getMessage() );
			return "Error:"+e.getMessage();
		}		
	} 
	
	
	private static JSONObject buildUserSiteDetailJSONArray(String siteCode, String profileID, String city, 
			String siteDescr, String finEntity, String facilityCode, String descr, String srNo) throws JSONException 
	{

        JSONObject siteDetailsObject = new JSONObject();
        
        siteDetailsObject.put("site_code", siteCode);
        siteDetailsObject.put("profile_id", profileID);
        siteDetailsObject.put("city", city);
        siteDetailsObject.put("site_descr", siteDescr);
        siteDetailsObject.put("fin_entity", finEntity);
        siteDetailsObject.put("facility_code", facilityCode);
        siteDetailsObject.put("descr", descr);
        siteDetailsObject.put("sr_no", srNo);

        return siteDetailsObject;
    }
	
	public String getSiteCodeDetailsJSON(String loginUserId ,String userLevel ,String profileId, String transDB, String fin_entity) throws ITMException
	{
		BaseLogger.log("2", null, null,"get SiteCode Details loginUserId["+loginUserId+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details userLevel["+userLevel+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details profileId["+profileId+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details transDB["+transDB+"]");
		BaseLogger.log("2", null, null,"get SiteCode Details fin_entity["+fin_entity+"]");
		
		JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
		
		StringBuffer siteCodeDetailsBuff = new StringBuffer("");
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		Connection conn = null;
		ConnDriver connDriver =  new ConnDriver();
		
		/*User Site Details JSON Array within the user_site object variables*/
		
		try
		{
			String siteCode = "";
			String profileID = "";
			String city = "";
			String siteDescr = "";
			String finEntity = "";
			String facilityCode = "";
			String descr = "";
			String srNo = "";
			
			conn = connDriver.getConnectDB(transDB);
			String sql = null;
			String enterprise = dbAccessEJB.getDBColumnValue("USERS", "ENTERPRISE", "CODE = '"+loginUserId+"'");
			BaseLogger.log("3", null, null,"get SiteCode Details enterprise["+enterprise+"]");
			
			if( "2".equalsIgnoreCase( userLevel ) )
			{
				sql = "SELECT * FROM USER_SITE WHERE USER_ID = ?";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, loginUserId);
			}
			else if(( "0".equalsIgnoreCase( userLevel ) || "1".equalsIgnoreCase( userLevel )) && (E12GenericUtility.checkNull(enterprise).length() > 0))
			{
				sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY,FACILITY_CODE," +
						"(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
						"FROM SITE WHERE SITE.ENTERPRISE = ?" + " ORDER BY SRNO,CITY,FIN_ENTITY";
				pStmt = conn.prepareStatement(sql);
				pStmt.setString(1, enterprise);
			}
			else
			{
				sql = 	"SELECT SITE.SITE_CODE,SITE.CITY,SITE.DESCR,SITE.FIN_ENTITY,FACILITY_CODE," +
						"(CASE WHEN SITE.FIN_ENTITY='" + fin_entity + "'" + "THEN 1 ELSE 2 END) AS SRNO " +
						"FROM SITE" + " ORDER BY SRNO,CITY,FIN_ENTITY";

				pStmt = conn.prepareStatement(sql);
			}
			BaseLogger.log("3", null, null,"Sql getSiteCodeDetails[" + sql + "]");
			rs = pStmt.executeQuery();
			ResultSetMetaData rsmd = rs.getMetaData();
			int colCount = rsmd.getColumnCount();
			BaseLogger.log("3", null, null,"no of column : "+colCount);
			int count = 0;
			if( rs.next() )
			{
//				siteCodeDetailsBuff.append("<Root>");
				do
				{
					count++;
					BaseLogger.log("3", null, null,"iteration no : => ["+count+"]");
					
//					siteCodeDetailsBuff.append("<USER_SITE>");
					for(int colNo = 1; colNo <= colCount; colNo++)
					{
						String colName = E12GenericUtility.checkNull( rsmd.getColumnName(colNo) ).toUpperCase();
						String colValue = E12GenericUtility.checkNull( rs.getString(colNo) );
						BaseLogger.log("3", null, null,"columnName&Value => "+colName+" : "+colValue);
						
						if ("SITE_CODE".equalsIgnoreCase(colName)) {
	                        siteCode = colValue;
	                        colName = "site_code";
	                    } else if ("CITY".equalsIgnoreCase(colName)) {
	                        city = colValue;
	                        colName = "city";
	                    } else if ("DESCR".equalsIgnoreCase(colName)) {
	                        descr = colValue;
	                        colName = "descr";
	                    } else if ("FIN_ENTITY".equalsIgnoreCase(colName)) {
	                        finEntity = colValue;
	                        colName = "fin_entity";
	                    } else if ("FACILITY_CODE".equalsIgnoreCase(colName)) {
	                        facilityCode = colValue;
	                        colName = "facility_code";
	                    } else if ("SRNO".equalsIgnoreCase(colName)) {
	                        srNo = colValue;
	                        colName = "srno";
	                    }
						
						siteCodeDetailsBuff.append("<"+colName+">").append("<![CDATA[" + colValue + "]]>").append("</"+colName+">");
						//BaseLogger.log("3", null, null,"siteCodeDetailsBuff XML gsb 131 : ["+ siteCodeDetailsBuff.toString() + "]" );
						//BaseLogger.log("3", null, null,"siteCodeDetailsBuff JSON gsb 131 : ["+ jsonArray.toString() + "]" );
//						siteCode = colValue;
						if( "2".equalsIgnoreCase( userLevel ))
						{
							//For Column Name ENTITY_CODE
							if("SITE_CODE".equalsIgnoreCase(colName))
							{
								String tableName = "SITE";
								String selectColName = "CITY";
								String whereColName = "";
								
								String selectColValue = dbAccessEJB.getDBColumnValue("SITE", "CITY", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								String siteDescription = dbAccessEJB.getDBColumnValue("SITE", "DESCR", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								
								city = selectColValue;
								siteDescr = siteDescription;
								
								siteCodeDetailsBuff.append("<CITY>").append("<![CDATA[" + selectColValue + "]]>").append("</CITY>");
								siteCodeDetailsBuff.append("<SITE_DESCR>").append("<![CDATA[" + siteDescription + "]]>").append("</SITE_DESCR>");

								String getfin_entity = dbAccessEJB.getDBColumnValue("SITE", "FIN_ENTITY", "SITE_CODE" + " = '" + colValue + "' ", transDB);
								siteCodeDetailsBuff.append("<FIN_ENTITY>").append("<![CDATA[" + getfin_entity + "]]>").append("</FIN_ENTITY>");
								finEntity = getfin_entity;
								
								String condition = "USER_ID = '"+ loginUserId +"' AND SITE_CODE = '"+ colValue +"'";
								profileId = dbAccessEJB.getDBColumnValue("USER_SITE", "PROFILE_ID", condition, transDB);
								BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USER_SITE profileId:["+profileId+"]");
								if("".equals(E12GenericUtility.checkNull(profileId)))
								{
									condition = "CODE = '"+ loginUserId +"'";
									profileId = dbAccessEJB.getDBColumnValue("USERS", "PROFILE_ID", condition);
									BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USERS profileId:["+profileId+"]");
								}
//								siteCodeDetailsBuff.append("<PROFILE_ID>").append("<![CDATA[" + profileId + "]]>").append("</PROFILE_ID>");
								profileID = profileId;
								
								String getfacility_code = dbAccessEJB.getDBColumnValue("SITE", "FACILITY_CODE", "SITE_CODE" + " = '" + colValue + "' ", transDB);
//								siteCodeDetailsBuff.append("<FACILITY_CODE>").append("<![CDATA[" + getfacility_code + "]]>").append("</FACILITY_CODE>");
								facilityCode = getfacility_code;
							}
						}
						
						else
						{
							if("SITE_CODE".equalsIgnoreCase(colName))
							{
								String selectColValue = E12GenericUtility.checkNull( rs.getString(2) );
								String siteDescription = E12GenericUtility.checkNull( rs.getString(3) );
								if( "1".equalsIgnoreCase( userLevel ))
								{
									String condition = "USER_ID = '"+ loginUserId +"' AND SITE_CODE = '"+ colValue +"'";
									profileId = dbAccessEJB.getDBColumnValue("USER_SITE", "PROFILE_ID", condition, transDB);
									BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USER_SITE profileId:["+profileId+"]");
									if("".equals(E12GenericUtility.checkNull(profileId)))
									{
										condition = "CODE = '"+ loginUserId +"'";
										profileId = dbAccessEJB.getDBColumnValue("USERS", "PROFILE_ID", condition);
										BaseLogger.log("3", null, null,"DBAccessEJB.getSiteCodeDetails() USERS profileId:["+profileId+"]");
									}
								}
								/*
								siteCodeDetailsBuff.append("<PROFILE_ID>").append("<![CDATA[" + profileId + "]]>").append("</PROFILE_ID>");
								siteCodeDetailsBuff.append("<CITY>").append("<![CDATA[" + selectColValue + "]]>").append("</CITY>");
								siteCodeDetailsBuff.append("<SITE_DESCR>").append("<![CDATA[" + siteDescription + "]]>").append("</SITE_DESCR>");
								*/
								
								profileID = profileId;
								city = selectColValue;
								siteDescr = siteDescription;

								String getfin_entity = E12GenericUtility.checkNull( rs.getString(4) );
								String getfacility_code = E12GenericUtility.checkNull( rs.getString(5) );
								
								/*
								siteCodeDetailsBuff.append("<FIN_ENTITY>").append("<![CDATA[" + getfin_entity + "]]>").append("</FIN_ENTITY>");
								siteCodeDetailsBuff.append("<FACILITY_CODE>").append("<![CDATA[" + getfacility_code+"]]>").append("</FACILITY_CODE>");
								*/
								finEntity = getfin_entity;
								facilityCode = getfacility_code;
								
//								jsonArray.put(buildUserSiteDetailJSONArray(E12GenericUtility.checkNull(siteCode), 
//										E12GenericUtility.checkNull(profileID), E12GenericUtility.checkNull(city), 
//										E12GenericUtility.checkNull(siteDescr),E12GenericUtility.checkNull(finEntity), 
//										E12GenericUtility.checkNull(facilityCode), E12GenericUtility.checkNull(descr), 
//										E12GenericUtility.checkNull(srNo)));
							}
						}
					}
					BaseLogger.log("3", null, null,"siteCode: ["+siteCode+"] & profileID : ["+profileID+"] & city : ["+city+"] & siteDescr : ["+siteDescr+"] & finEntity : ["+finEntity+"] & facilityCode : ["+facilityCode+"] & descr : ["+descr+"] & srNo : ["+srNo+"]" );
					jsonArray.put(buildUserSiteDetailJSONArray(E12GenericUtility.checkNull(siteCode), 
							E12GenericUtility.checkNull(profileID), E12GenericUtility.checkNull(city), 
							E12GenericUtility.checkNull(siteDescr),E12GenericUtility.checkNull(finEntity), 
							E12GenericUtility.checkNull(facilityCode), E12GenericUtility.checkNull(descr), 
							E12GenericUtility.checkNull(srNo)));
					
//					siteCodeDetailsBuff.append("</USER_SITE>");
					
				}
				while( rs.next() );
//				siteCodeDetailsBuff.append("</Root>");
			}

			rs.close();
			rs = null;
			pStmt.close();
			pStmt = null;
			
			/*
			 * String siteCode, String profileID, String city, 
			String siteDescr, String finEntity, String facilityCode, String descr, String srNo
			 * */
			//jsonObject.put("user_rights", jsonArray);
	        jsonObject.put("user_site", jsonArray);
			
		}
		catch (Exception e)
		{
			BaseLogger.log("0", null, null,"Exception in getEntityContactDetails ["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pStmt != null)
				{
					pStmt.close();
					pStmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				BaseLogger.log("0", null, null, "Exception : DBAccessEJB : getSiteCodeDetails()"+e.getMessage());
				throw new ITMException(e);
			}
		}
		BaseLogger.log("3", null, null,"jsonObject.toString() gsb [" + jsonObject.toString() + "]");
//		return siteCodeDetailsBuff.toString();
		return jsonObject.toString();
	}

}