

/********************************************************
	Title : QualificationEJB
	Date  : 02/07/08
	Author: Sumit Sakore

********************************************************/

package ibase.webitm.ejb.wsfa.masters;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.Properties;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] Start
//import oracle.jdbc.driver.OraclePreparedStatement;
import ibase.utility.CommonConstants;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.InputSource;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].
public class WsfaQualification extends ValidatorEJB implements WsfaQualificationRemote,WsfaQualificationLocal//implements SessionBean
{
	protected static String database = CommonConstants.DB_NAME;
/*
	public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println ( "QualificationEJB Created..." );
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate()
	{
	}

	public void ejbPassivate()
	{
	}*/

	// Code for Validation
	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			System.out.println("xmlString [" + xmlString + "]");
			System.out.println("xmlString1 [" + xmlString1 + "]");
			System.out.println("xmlString2 [" + xmlString2 + "]");
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams );
			System.out.println ( "ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println ( "Exception: QualificationEJB: wfValData(String xmlString): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println ( "Returning from QualificationEJB wfValData" );
		return ( errString );
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Statement stmt = null;
		ResultSet rs = null;
		Connection connectionObject = null;
		PreparedStatement pstmtDescr = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		//ITMDBAccessHome itmDBAccessHome = null;
		//ITMDBAccess itmDBAccess = null;

		try
		{
			String columnValue = "";
			String sql = "";
			int currentFormNo = 0;
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//itmDBAccessHome = (ITMDBAccessHome)ctx.lookup("ITMDBAccess");
			//itmDBAccess = itmDBAccessHome.create();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessRemote itmDBAccess = (ITMDBAccessRemote)ctx.lookup("ibase/ITMDBAccessEJB/remote");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}

			NodeList parentList = dom.getElementsByTagName( "Detail" + currentFormNo );
			NodeList childList = parentList.item( 0 ).getChildNodes();
			int noOfChilds = childList.getLength();
			for (int ctr = 0; ctr < noOfChilds; ctr++)
			{
				Node childNode = childList.item( ctr );
				String childNodeName = childNode.getNodeName();
				if ( childNode != null && childNode.getFirstChild() != null )
				{
					columnValue = childNode.getFirstChild().getNodeValue();
				}
				System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");

				switch ( currentFormNo )
				{
					case 1:
					{
						if ( "qlf_code".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = getErrorString( "qlf_code", "NULLQLFCOD", userId );
								break;
							}//added by rajesh 8/9/2008[validation  value of   qualification code  WS89BAS028 ].start
							else if( childNode.getFirstChild().getNodeValue() != null )
							{
								columnValue =  childNode.getFirstChild().getNodeValue();
								if( columnValue.trim().length() == 0 )
								{
									 errString = itmDBAccess.getErrorString("qlf_code","NULLQLFCOD",userId);
									  break;
								}
								else if( editFlag != null && editFlag.equalsIgnoreCase("A") )
								{

									sql = "SELECT * FROM QUALIFICATION WHERE QLF_CODE =?";
									pstmtDescr = connectionObject.prepareStatement(sql);
									/*if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
									{
										((OraclePreparedStatement)pstmtDescr).setFixedCHAR(1,columnValue);
									}
									else
									{*/
										pstmtDescr.setString(1, columnValue);
									//}
									//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] End
									rs = pstmtDescr.executeQuery();
									if( rs.next())
									{
										errString = getErrorString("qlf_code","QLFALEXIST",userId);
										break;
									}
								}
							}
							else
							{
								errString = itmDBAccess.getErrorString("qlf_code","NULLQLFCOD",userId);
								break;
							}//added by rajesh 8/9/2008[validation  value of   qualification code  WS89BAS028 ].end
						}
						else if ( "descr".equalsIgnoreCase( childNodeName ) )
						{
							if ( childNode.getFirstChild() == null )
							{
								errString = getErrorString( "descr", "NULLDESCRN", userId );
								break;
							}//added by rajesh 8/9/2008[validation  value of   descr  WS89BAS028 ].start
							if( childNode.getFirstChild().getNodeValue() != null )
							{
								columnValue =  childNode.getFirstChild().getNodeValue();
								if( columnValue.trim().length() == 0 )
								{
									 errString = itmDBAccess.getErrorString("descr","NULLDESCRN",userId);
									  break;
								}
								else if( editFlag != null && editFlag.equalsIgnoreCase("A") )
								{
									sql = "SELECT * FROM QUALIFICATION WHERE DESCR =?";
									pstmtDescr = connectionObject.prepareStatement(sql);
									//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] Start
									/*if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
									{
										((OraclePreparedStatement)pstmtDescr).setFixedCHAR(1,columnValue);
									}
									else
									{*/
										pstmtDescr.setString(1, columnValue);
									//}
									//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] End
									rs = pstmtDescr.executeQuery();
									if( rs.next())
									{
										errString = getErrorString("descr","QLFALEXIST",userId);
										break;
									}
								}
							}
							else
							{
								errString = itmDBAccess.getErrorString("descr","NULLDESCRN",userId);
								break;
							}//added by rajesh 8/9/2008[validation  value of   descr  WS89BAS028 ].end
						}
						else if ( "eqival".equalsIgnoreCase( childNodeName ) )
						{
							columnValue = genericUtility.getColumnValue("eqival", dom);
							if( columnValue != null)
							{
								sql = "SELECT * FROM QUALIFICATION WHERE QLF_CODE =?";
								pstmtDescr = connectionObject.prepareStatement(sql);
								//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] Start
								/*if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
								{
									((OraclePreparedStatement)pstmtDescr).setFixedCHAR(1,columnValue);
								}
								else
								{*/
									pstmtDescr.setString(1, columnValue);
								//}
								//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] End
								rs = pstmtDescr.executeQuery();
								if( !rs.next())
								{
									errString = getErrorString("eqival","INVEQVLCOD",userId);
									break;
								}
							}
						}
						if( pstmtDescr != null )
						{
							pstmtDescr.close();
						}
						if( rs != null )
						{
							rs.close();
						}
					}//case 1:
					break;
				}//switch ( currentFormNo )
				if (errString != null && errString.trim().length() > 0)
				{
					break;
				}
			}//for (int ctr = 0; ctr < noOfChilds; ctr++)
		} //Close Try
		catch (Exception e)
		{
			System.out.println ( "Exception: QualificationEJB: wfValData(Document dom): " + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :QualificationEJB:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return (errString);
	}



	// Code for ItemChange
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :QualificationEJB :itemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from QualificationEJB itemChanged" );
		return errString;
	}

	public String itemChanged( Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		ResultSet rs = null;
		String sql = "";
		String columnValue = "";

		Statement stmt = null;
		Connection connectionObject = null;
		PreparedStatement pstmtDescr = null;
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			columnValue = genericUtility.getColumnValue( currentColumn, dom );
			//ITMDBAccessHome itmDBAccessHome = null;
			//ITMDBAccess itmDBAccess = null;
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//itmDBAccessHome = (ITMDBAccessHome)ctx.lookup("ITMDBAccess");
			//itmDBAccess = itmDBAccessHome.create();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//ITMDBAccessRemote itmDBAccess = (ITMDBAccessRemote)ctx.lookup("ibase/ITMDBAccessEJB/remote");
			ITMDBAccessEJB itmDBAccess = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection

			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
            valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );

			switch ( currentFormNo )
			{
			  	case 1:
				{
					valueXmlString.append( "<Detail1>\r\n" );
					if( currentColumn.equalsIgnoreCase( "eqival" ) )
					{
						sql = "SELECT DESCR FROM QUALIFICATION WHERE QLF_CODE =? ";
						pstmtDescr = connectionObject.prepareStatement(sql);
						//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] Start
						/*if ( this.database.toUpperCase().startsWith( "ORACLE" ) )
						{
							((OraclePreparedStatement)pstmtDescr).setFixedCHAR(1,columnValue);
						}
						else
						{*/
						  //Changed by sumit sarkar on 22/02/12 on [ WS1LNOV001 ] set qlf_code .
						  //pstmtDescr.setString(1, columnValue);
							pstmtDescr.setString(1, getColumnValue("eqival",dom));
						//}
						//Changed By Sumit Sakore On 17/07/2008 [ WS89BAS017 ] End
						rs = pstmtDescr.executeQuery();
						if( rs.next() )
						{
							System.out.println("data present");
							valueXmlString.append( "<qualification_descr><![CDATA[" ).append( checkNull( rs.getString( "DESCR" )) ).append( "]]></qualification_descr>\r\n" );

						}
						else
						{
							valueXmlString.append( "<qualification_descr></qualification_descr>\r\n" );
						}
					}
                   	valueXmlString.append( "</Detail1>\r\n" );
					break;
				}//case 1 end here
			}//switch statement ends here
		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :QualificationEJB :itemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :QualificationEJB:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}

	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}
}

