package ibase.webitm.utility;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import java.sql.ResultSetMetaData;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.MasterStatefulLocal;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class UserTasksServiceUtility {
	private UserInfoBean userInfo = null;

	public String getUserTasksService(String refser, String refId, String tokenIDfromHeader) throws Exception {
		BaseLogger.log("3", null, null, "Inside the getUserTasksService():");
		PreparedStatement pstmt = null;
		ResultSet resultSet = null;
		Connection connection = null;

		JSONArray jsonArray = new JSONArray();
		if (userInfo == null) {
			APIUtility apiUtility = new APIUtility();
			userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
			String transDB = userInfo.getTransDB();
			String tableName = "USER_TASKS";

			BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
			String query = "SELECT * FROM " + tableName + " WHERE REF_SER = ? AND REF_ID = ?";

			try {
				ConnDriver connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(transDB);
				pstmt = connection.prepareStatement(query);
				pstmt.setString(1, refser);
				pstmt.setString(2, refId);
				resultSet = pstmt.executeQuery();

				ResultSetMetaData metaData = resultSet.getMetaData();
				int columnCount = metaData.getColumnCount();

				while (resultSet.next()) {
					JSONObject jsonObject = new JSONObject();
					for (int i = 1; i <= columnCount; i++) {
						String columnName = metaData.getColumnLabel(i);
						jsonObject.put(columnName, resultSet.getString(columnName));
					}
					jsonArray.put(jsonObject);
				}

			} catch (SQLException e) {
				BaseLogger.log("3", null, null, "Error occurred while retrieving user tasks: " + e.getMessage());
				e.printStackTrace();
			} finally {
				if (resultSet != null) {
					try {
						resultSet.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
				if (pstmt != null) {
					try {
						pstmt.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
				if (connection != null) {
					try {
						connection.close();
					} catch (SQLException e) {
						e.printStackTrace();
					}
				}
			}
		}
		BaseLogger.log("3", null, null, "jsonArray: [" + jsonArray.toString() + "]");

		return jsonArray.toString();
	}

	public String addUserTask(String transXMLHeader, UserInfoBean userInfo) throws Exception {

		String result = "";
		Connection connection = null;
		BaseLogger.log("3", null, null, "Inside updatePaymentStatus.. ");

		try {
			AppConnectParm appConnect = new AppConnectParm();
			InitialContext initialContext = new InitialContext(appConnect.getProperty());

			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfo.getTransDB());

			StringBuffer userTaskXmlString = new StringBuffer();
			userTaskXmlString.append("<DocumentRoot><description>Datawindow Root</description><group0>");
			userTaskXmlString.append(
					"<description>Group0 description</description><Header0><description>Header0 members</description>");
			userTaskXmlString.append("<objName><![CDATA[user_tasks]]></objName>");
			userTaskXmlString.append("<pageContext><![CDATA[1]]></pageContext>");
			userTaskXmlString.append("<objContext><![CDATA[1]]></objContext>");
			userTaskXmlString.append("<editFlag><![CDATA[A]]></editFlag>");
			userTaskXmlString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
			userTaskXmlString.append("<action><![CDATA[SAVE]]></action>");
			userTaskXmlString.append("<elementName><![CDATA[]]></elementName>");
			userTaskXmlString.append("<keyValue><![CDATA[1]]></keyValue>");
			userTaskXmlString.append("<saveLevel><![CDATA[1]]></saveLevel>");
			userTaskXmlString.append("<forcedSave><![CDATA[false]]></forcedSave>");
			userTaskXmlString.append("<Detail1 dbID='' domID='1'  objContext='1'  objName='user_tasks'>");
			userTaskXmlString
					.append("<attribute IS_CHANGE='Y' pkNames='TRAN_ID' selected='N' status='N' updateFlag='A'/>");

			userTaskXmlString.append(transXMLHeader);
			userTaskXmlString.append("</Detail1>");

//			userTaskXmlString.append(transXMLDetail);
			userTaskXmlString.append("</Header0></group0></DocumentRoot>");
			String xmlString = userTaskXmlString.toString();
			BaseLogger.log("3", null, null, " Xml String... " + xmlString);

			// call the process request here
			MasterStatefulLocal masterStateful = (MasterStatefulLocal) initialContext
					.lookup("ibase/MasterStatefulEJB/local");
			String retString = masterStateful.processRequest(userInfo, xmlString, false, connection);
			result = getErrorStrFromRetString(retString, "getErrorStrFromRetString Cancellation");

			BaseLogger.log("3", null, null, "'w_user_tasks' cellation retString.." + result);

//			String exeConfrimResult = masterStateful.executeConfirm(xmlString);
//			BaseLogger.log("3", null, null, "Payment Cancellation exeConfrimResult.." + E12GenericUtility.checkNull(exeConfrimResult));

		} catch (Exception e) {
			throw e;
		} finally {
			try {
//                if(rs != null)
//                {
//                    rs.close();
//                    rs = null;
//                }
//                if(pstmt != null)
//                {
//                    pstmt.close();
//                    pstmt = null;
//                }
				if (connection != null) {
					connection.close();
					connection = null;
				}
			} catch (Exception e) {
				e.getMessage();
			}
		}
		return result;

	}

	public String addUserTask(String refId, String refser, String taskDescr, String userIdAssigned,
			String tokenIDfromHeader) {
		String result = "";
		BaseLogger.log("3", null, null, "addUserTask calle ams");

		if (userInfo == null) {
			APIUtility apiUtility = new APIUtility();
			userInfo = apiUtility.createUserInfoFromJWTToken(tokenIDfromHeader);
			BaseLogger.log("3", null, null, "USER_INFO created from TOKEN: [" + userInfo + "]");
		}

		try {
			CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
			String tranID = commonDBAccessEJB.generateSeq("USER_TASKS_SEQ", 10, userInfo.getTransDB());
			BaseLogger.log("3", null, null, " generated tranID :: " + tranID); // tran_id
			LocalDate tranDate = LocalDate.now();// for tranDate
			LocalTime tranTime = LocalTime.now();
			String formattedTranDate = formatDateTime(tranDate, tranTime);

			String userId = "";
			userId = userInfo.getLoginCode(); // userId
			String taskType = "";
			String taskDomain = "";
			String taskCode = "";
			String expComplDate = "28-05-24";
//			LocalDate expComplDate = LocalDate.now();
			// LocalTime expCompTime = LocalTime.now();
			// String expCompTranDate= formatDateTime(expComplDate,expCompTime);
			String currStatus = "28-05-24";
			// LocalDate statusDate = LocalDate.now();
			String statusDate = "28-05-24";
			String complRemarks = "";
			// LocalDate addDate = LocalDate.now();
			String addDate = "28-05-24";
			String addUser = "";
			String addTerm = "";
			// LocalDate chgDate = LocalDate.now();
			String chgDate = "28-05-24";

			String chgUser = "";
			String chgTerm = "";

			String transXMLHeader = generateTransXMLForHeader(tranID, formattedTranDate, userId, taskDescr, taskType,
					taskDomain, taskCode, userIdAssigned, expComplDate, currStatus, statusDate, complRemarks, addDate,
					addUser, addTerm, chgDate, chgUser, chgTerm, refser, refId);
			String transResult = addUserTask(transXMLHeader, userInfo);
			result = transResult;
		} catch (Exception e) {
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null, "Result of addUserTask: [" + result + "]");

		return result;

	}

	//
	public String generateTransXMLForHeader(String tranId, String formattedTranDate, String userId, String taskDescr,
			String taskType, String taskDomain, String taskCode, String userIdAssigned, String expComplDate,
			String currStatus, String statusDate, String complRemarks, String addDate, String addUser, String addTerm,
			String chgDate, String chgUser, String chgTerm, String refser, String refId) throws ITMException {
		BaseLogger.log("3", null, null, "generateTransXML calling gsb:[" + refId + "]");

		StringBuffer transXML = new StringBuffer();

		transXML.append("<tran_id><![CDATA[" + tranId + "]]></tran_id>");
		transXML.append("<tran_date><![CDATA[" + dateFormatter(formattedTranDate) + "]]></tran_date>"); // tranDate
		transXML.append("<user_id><![CDATA[" + userId + "]]></user_id>");

		transXML.append("<task_descr><![CDATA[" + taskDescr + "]]></task_descr>");
		transXML.append("<task_type><![CDATA[" + taskType + "]]></task_type>");
		transXML.append("<task_domain><![CDATA[" + taskDomain + "]]></task_domain>");
		transXML.append("<task_code><![CDATA[" + taskCode + "]]></task_code>");
		transXML.append("<user_id__assigned><![CDATA[" + userIdAssigned + "]]></user_id__assigned>");

		transXML.append("<exp_compl_Date><![CDATA[" + dateFormatter(expComplDate) + "]]></exp_compl_Date>");

		transXML.append("<curr_status><![CDATA[" + currStatus + "]]></curr_status>");

		transXML.append("<status_date><![CDATA[" + dateFormatter(statusDate) + "]]></status_date>");
		transXML.append("<compl_remarks><![CDATA[" + complRemarks + "]]></compl_remarks>");

		transXML.append("<add_date><![CDATA[" + dateFormatter(addDate) + "]]></add_date>");

		transXML.append("<add_user><![CDATA[" + addUser + "]]></add_user>");

		transXML.append("<add_term><![CDATA[" + addTerm + "]]></add_term>");

		transXML.append("<chg_term><![CDATA[" + chgTerm + "]]></chg_term>");
		transXML.append("<chg_user><![CDATA[" + chgUser + "]]></chg_user>");

		transXML.append("<confirmed><![CDATA[Y]]></confirmed>");

		System.out.println("User_tasks transXML [" + transXML + "]");

		return transXML.toString();
	}

	public static String getErrorStrFromRetString(String returnXML, String calledFrom) {
		StringBuilder errorStr = new StringBuilder();

		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document document = builder.parse(new java.io.ByteArrayInputStream(returnXML.getBytes()));

			NodeList errorList = document.getElementsByTagName("error");

			for (int i = 0; i < errorList.getLength(); i++) {
				Node errorNode = errorList.item(i);

				if (errorNode.getNodeType() == Node.ELEMENT_NODE) {
					Element errorElement = (Element) errorNode;

					String message = errorElement.getElementsByTagName("message").item(0).getTextContent();
					String description = errorElement.getElementsByTagName("description").item(0).getTextContent();

					errorStr.append("Message From " + calledFrom + ":").append(message).append("\n");
					errorStr.append("Description: ").append(description).append("\n");
				} else {
					return calledFrom + " Transaction is Saved.";
				}
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		return errorStr.toString();
	}

	public static String dateFormatter(String inputDateString) {
		String result = "";
		String inputFormat = "yyyy-MM-dd HH:mm:ss";
		String outputFormat = "dd/MM/yy HH:mm:ss";

		try {
			// Parse input date string
			SimpleDateFormat inputFormatter = new SimpleDateFormat(inputFormat);
			Date date = inputFormatter.parse(inputDateString);

			// Format the date in the desired output format
			SimpleDateFormat outputFormatter = new SimpleDateFormat(outputFormat);
			String outputDateString = outputFormatter.format(date);

			System.out.println("Input Date: " + inputDateString);
			System.out.println("Formatted Date: " + outputDateString);
			result = outputDateString;

		} catch (ParseException e) {
			e.printStackTrace();
			// Handle parsing exception
		}
		return result;
	}

	// for formated date and time
	public static String formatDateTime(LocalDate tranDate, LocalTime tranTime) {
		LocalDateTime tranDateTime = LocalDateTime.of(tranDate, tranTime);
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
		String formattedDateTime = tranDateTime.format(formatter);
		return formattedDateTime;
	}

}
