/*
 * Decompiled with CFR 0.152.
 */
package ibase.webService;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DocumentHandlerWrapperEJB;
import ibase.webitm.utility.APIUtility;
import ibase.webitm.utility.ITMException;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/DocumentSearchService")
public class DocumentSearchService {
    private UserInfoBean userInfo = null;

    @POST
    @Path(value="/documentSearch")
    @Produces(value={"application/json"})
    public Response documentSearch(@FormParam(value="searchInput") String searchInput, @FormParam(value="searchType") String searchType, @Context HttpServletRequest request) throws Exception {
        String result = "";
        try {
            BaseLogger.log((String)"3", null, null, (Object)("Prin documentSearch calling searchInput:::::::::" + searchInput));
            BaseLogger.log((String)"3", null, null, (Object)("Print line no 42 documentSearch calling searchType:::::::::" + searchType));
            String dataExtractorServiceURL = "";
            APIUtility apiUtility = new APIUtility();
            this.userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            Map pythonServicesMap = CommonConstants.EXTRACTION_PYTHON_SERVICES;
            String serverUrl = "";
            if (pythonServicesMap != null) {
                Map proteusSenseServiceDetails = (Map)pythonServicesMap.get("DATA_EXTRACTOR");
                String protocol = (String)proteusSenseServiceDetails.get("PROTOCOL");
                String host = (String)proteusSenseServiceDetails.get("HOST");
                String port = E12GenericUtility.checkNull((String)((String)proteusSenseServiceDetails.get("PORT")));
                String path = apiUtility.getAPIUrl(this.userInfo, "VectorLookup");
                if (path.contains("WeaviateVector")) {
                    serverUrl = apiUtility.getAPIUrl(this.userInfo, "WeaviateVector");
                }
                dataExtractorServiceURL = String.format("%s://%s%s/%s", protocol, host, port, path);
                BaseLogger.log((String)"3", null, null, (Object)("print dataExtractorServiceURL:::::," + dataExtractorServiceURL));
            }
            JSONObject configData = new JSONObject();
            ArrayList openaiParams = apiUtility.getAPIKey(this.userInfo, "OpenAI");
            ArrayList pineConeParams = apiUtility.getAPIKey(this.userInfo, "PineCone");
            JSONArray searchData = new JSONArray();
            searchData.put((Object)searchInput);
            configData.put("index_name", (Object)"document");
            configData.put("openAI_apiKey", openaiParams.get(0));
            configData.put("pineCone_apiKey", pineConeParams.get(0));
            configData.put("queryList", (Object)searchData);
            configData.put("enterprise", (Object)this.userInfo.getEnterprise());
            configData.put("server_url", (Object)serverUrl);
            configData.put("lookup_type", (Object)searchType);
            String pineConeConfig = configData.toString();
            System.out.println("print pineConeConfig:::," + pineConeConfig);
            ByteArrayInputStream postDataInputStream = null;
            StringBuffer queryParam = new StringBuffer();
            queryParam.append("jsonData=").append(pineConeConfig);
            String querystr = queryParam.toString();
            System.out.println("print querystr:::," + querystr);
            if (querystr != null) {
                postDataInputStream = new ByteArrayInputStream(querystr.getBytes(StandardCharsets.UTF_8));
                BaseLogger.log((String)"3", null, null, (Object)("print datainputstream::::" + postDataInputStream));
            }
            byte[] responseData = E12GenericUtility.makeRequest((String)dataExtractorServiceURL, postDataInputStream, (int)0, null, (String)"application/json");
            result = new String(responseData);
            JSONArray resultData = new JSONArray(result);
            DocumentHandlerWrapperEJB documentHandlerWrapperEJB = new DocumentHandlerWrapperEJB();
            JSONArray docTypeList = documentHandlerWrapperEJB.getDocTypeList(resultData, searchType, this.userInfo);
            result = docTypeList.toString();
        }
        catch (Exception e) {
            BaseLogger.log((String)"0", null, null, (Object)"print exception in documentSerch:..");
            ITMException itmException = new ITMException(e);
            result = itmException.getMessage();
        }
        return Response.status((int)200).entity((Object)result).build();
    }
}

