/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.dao;

import ibase.bis.utility.BISUtility;
import ibase.hibernate.bean.DocContents;
import ibase.hibernate.bean.DocTransLink;
import ibase.hibernate.bean.ObjDetails;
import ibase.hibernate.bean.RefSer;
import ibase.hibernate.bean.UserDocContent;
import ibase.hibernate.utility.HibernateUtil;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentLibraryDao {
    private String responseTo = "vision";
    private BISUtility bisUtility = new BISUtility();
    List<UserDocContent> contentData = new ArrayList<UserDocContent>();
    JSONObject refSerListObj = new JSONObject();
    JSONArray refrenceArr = new JSONArray();
    List<JSONObject> assocObjList = new ArrayList<JSONObject>();
    HashMap<String, ObjDetails> assocObjMap = new HashMap();

    public List<UserDocContent> getUserDocContent(String userId, String tranDB) {
        List<UserDocContent> contentList = new ArrayList<UserDocContent>();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserDocContent userId: [" + userId + "]");
            Query query = session.createQuery("from UserDocContent where ( userId='" + userId + "' or docId in (select docId from ShareDocs where userId = '" + userId + "')) and docStatus in ('A', 'S')");
            contentList = query.getResultList();
            BaseLogger.log("3", null, null, "contentList ::" + contentList);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return contentList;
    }

    public JSONObject getUserDocContentsDetails(Map<String, UserDocContent> userDocContentMap, List<String> docIdList, String tranDB) {
        JSONObject docDetailJson = new JSONObject();
        try {
            JSONArray docContentDetails = new JSONArray();
            BaseLogger.log("3", null, null, "docIdList ::::::" + docIdList);
            Map<String, List<DocTransLink>> docTransLinkMap = this.getDocTransLink(docIdList, tranDB);
            BaseLogger.log("3", null, null, "docTransLinkMap  :::::" + docTransLinkMap);
            Map<String, DocContents> docContentsMap = this.getDocContents(docIdList, tranDB);
            HashMap<String, JSONArray> docIdMap = new HashMap<String, JSONArray>();
            ArrayList<String> refSerList = new ArrayList<String>();
            for (String docId : docIdList) {
                boolean isDocShared = false;
                UserDocContent userDocContent = userDocContentMap.get(docId);
                JSONObject userDocContentObj = new JSONObject((Object)userDocContent);
                BaseLogger.log("3", null, null, "userDocContentObj ::::" + userDocContentObj);
                DocContents docContents = docContentsMap.get(docId);
                if (docContents != null) {
                    userDocContentObj.put("docName", (Object)docContents.getDocName());
                    userDocContentObj.put("docPages", docContents.getDocPages());
                    userDocContentObj.put("addUser", (Object)docContents.getAddUser());
                    userDocContentObj.put("addDate", (Object)docContents.getAddDate());
                    userDocContentObj.put("docError", (Object)"false");
                    userDocContentObj.put("fileType", (Object)docContents.getDocType());
                    userDocContentObj.put("extractedData", (Object)docContents.getExtractedData());
                }
                List<DocTransLink> docTransLinkLst = docTransLinkMap.get(docId);
                String refSer = "";
                if (docTransLinkLst != null) {
                    JSONArray docTransRefArray = new JSONArray();
                    for (DocTransLink docTransLink : docTransLinkLst) {
                        JSONObject docTransRefObj = new JSONObject();
                        BaseLogger.log("3", null, null, "docTransLink :::: [" + docTransLink + "]");
                        refSer = docTransLink.getRefSer();
                        docTransRefObj.put("refSer", (Object)refSer);
                        docTransRefObj.put("refId", (Object)docTransLink.getRefId());
                        docTransRefObj.put("fileTypeAttach", (Object)docTransLink.getFileTypeAttach());
                        docTransRefObj.put("docTypeAttach", (Object)docTransLink.getDocTypeAttach());
                        BaseLogger.log("3", null, null, "docTransRefObj ::::::" + docTransRefObj);
                        BaseLogger.log("3", null, null, "refSer ::::to check" + refSer);
                        if (!refSerList.contains(refSer)) {
                            refSerList.add(refSer);
                        }
                        if (refSer.equalsIgnoreCase("COLPST")) {
                            isDocShared = true;
                        }
                        docTransRefArray.put((Object)docTransRefObj);
                    }
                    if (docTransRefArray.length() > 0) {
                        userDocContentObj.put("REFERENCES", (Object)docTransRefArray);
                    }
                } else {
                    String references = "";
                    JSONObject refSerObj = new JSONObject();
                    JSONArray refSerObjArray = new JSONArray();
                    refSerObj.put("refSer", (Object)"_OTHER");
                    refSerObjArray.put((Object)refSerObj);
                    userDocContentObj.put("REFERENCES", (Object)refSerObjArray);
                    if (!refSerList.contains(refSer)) {
                        refSerList.add(refSer);
                    }
                }
                userDocContentObj.put("isShared", isDocShared);
                JSONArray docIdArr = (JSONArray)docIdMap.get(refSer);
                BaseLogger.log("9", null, null, "docIdArr ::::" + docIdArr);
                if (docIdArr == null) {
                    docIdArr = new JSONArray();
                }
                docIdArr.put((Object)docId);
                BaseLogger.log("3", null, null, "docIdArr ater put DocId::::" + docIdArr);
                docIdMap.put(refSer, docIdArr);
                BaseLogger.log("3", null, null, "docIdMap ::::" + docIdMap);
                BaseLogger.log("3", null, null, "userDocContentObj ::[" + userDocContentObj + "]");
                docContentDetails.put((Object)userDocContentObj);
            }
            BaseLogger.log("3", null, null, "refSerList ::[" + refSerList + "]");
            HashMap<String, RefSer> refSeriesMap = this.getRefSerList(refSerList, tranDB);
            BaseLogger.log("3", null, null, "refSeriesList ::[" + refSeriesMap + "]");
            for (String refSer : refSerList) {
                BaseLogger.log("3", null, null, "refSer.length() [" + refSer.length() + "]");
                if (refSer.length() == 0) continue;
                RefSer refSerObj = refSeriesMap.get(refSer);
                BaseLogger.log("3", null, null, "refSer in refer" + refSer);
                JSONObject refrenceObj = new JSONObject();
                refrenceObj.put("refSer", (Object)refSer);
                BaseLogger.log("9", null, null, "refrenceObj ::::" + refrenceObj);
                if (refSerObj != null) {
                    refrenceObj.put("refSerDescr", (Object)refSerObj.getRefSerDescr());
                } else {
                    refrenceObj.put("refSerDescr", (Object)("No Description for " + refSer));
                }
                this.refrenceArr.put((Object)refrenceObj);
                BaseLogger.log("3", null, null, "refrenceArr in loop " + this.refrenceArr);
            }
            BaseLogger.log("3", null, null, "refrenceArr " + this.refrenceArr);
            docDetailJson.put("userDocContents", (Object)docContentDetails);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "getUserDocContentsDetails HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        catch (JSONException e) {
            BaseLogger.log("0", null, null, "getUserDocContentsDetails JSONException :");
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "docDetailJson :: :" + docDetailJson);
        return docDetailJson;
    }

    private HashMap<String, RefSer> getRefSerList(List<String> refSers, String tranDB) {
        HashMap<String, RefSer> refSeriesMap = new HashMap<String, RefSer>();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getRefSerList refSers: [" + refSers + "]");
            String refSersStr = this.getEnclosedString(refSers);
            Query query = session.createQuery("from RefSer where refSer in (" + refSersStr + ") order by refSer ");
            List refSerList = query.getResultList();
            for (RefSer refSer : refSerList) {
                refSeriesMap.put(refSer.getRefSer(), refSer);
            }
            BaseLogger.log("3", null, null, "refSerList :::[" + refSerList + "][" + refSeriesMap + "]");
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return refSeriesMap;
    }

    private Map<String, DocContents> getDocContents(List<String> docIdList, String tranDB) {
        HashMap<String, DocContents> contentHMap = new HashMap<String, DocContents>();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getDocContents docIdList: [" + docIdList + "]");
            String docIdListStr = this.getEnclosedString(docIdList);
            Query query = session.createQuery("from DocContents where docId in (" + docIdListStr + ") order by docId ");
            List docContentList = query.getResultList();
            if (docContentList != null) {
                for (DocContents docContents : docContentList) {
                    contentHMap.put(docContents.getDocId(), docContents);
                }
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return contentHMap;
    }

    private Map<String, List<DocTransLink>> getDocTransLink(List<String> docIdList, String tranDB) {
        HashMap<String, List<DocTransLink>> docTransLinkHMap = new HashMap<String, List<DocTransLink>>();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getDocTransLink docIdList: [" + docIdList + "]");
            String docIdListStr = this.getEnclosedString(docIdList);
            BaseLogger.log("3", null, null, "docIdListStr" + docIdListStr);
            Query query = session.createQuery("from DocTransLink where docId in (" + docIdListStr + ")");
            List docTransLinkList = query.getResultList();
            BaseLogger.log("3", null, null, "docTransLinkList   ::::::::::::::" + docTransLinkList);
            if (docTransLinkList != null) {
                for (DocTransLink docTransLink : docTransLinkList) {
                    BaseLogger.log("3", null, null, "docTransLink :::" + docTransLink);
                    ArrayList<DocTransLink> dtlList = (ArrayList<DocTransLink>)docTransLinkHMap.get(docTransLink.getDocId());
                    BaseLogger.log("3", null, null, "dtlList :::::" + dtlList);
                    if (dtlList == null) {
                        dtlList = new ArrayList<DocTransLink>();
                        BaseLogger.log("3", null, null, "dtlList in if loop" + dtlList);
                    }
                    dtlList.add(docTransLink);
                    BaseLogger.log("3", null, null, "dtlList after add of docTransLink:::::" + dtlList);
                    BaseLogger.log("3", null, null, "dtlList after nullify:::::" + dtlList);
                    BaseLogger.log("3", null, null, "docTransLink[" + docTransLink.getDocId() + "<>" + docTransLink.getRefSer() + "<>" + docTransLink + "]");
                    docTransLinkHMap.put(docTransLink.getDocId(), dtlList);
                }
            }
            BaseLogger.log("3", null, null, "docTransLinkList ::::" + docTransLinkList);
            BaseLogger.log("3", null, null, "docTransLinkHMap ::::" + docTransLinkHMap);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return docTransLinkHMap;
    }

    private String getEnclosedString(List<String> docIdList) {
        StringBuffer buffer = new StringBuffer();
        int len = 0;
        for (String docId : docIdList) {
            buffer.append("'").append(docId.trim()).append("'");
            if (++len >= docIdList.size()) continue;
            buffer.append(",");
        }
        if (buffer.length() == 0) {
            buffer.append("''");
        }
        BaseLogger.log("3", null, null, "Inside getEnclosedString buffer: [" + buffer + "]");
        return buffer.toString();
    }

    public void updatePinned(String docId, String status, String loginCode, String tranDB) {
        BaseLogger.log("2", null, null, "Update UserDocContent for: DOC ID:[" + docId + "] status:[" + status + "]loginCode" + loginCode);
        char newStatus = status.charAt(1);
        List contentList = new ArrayList();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserDocContent userId: [" + docId + "]");
            Query query = session.createQuery("from UserDocContent where docId='" + docId + "' and  userId='" + loginCode + "'");
            contentList = query.getResultList();
            BaseLogger.log("3", null, null, "contentList in updateStatus ::" + contentList);
            for (UserDocContent userDoc : contentList) {
                userDoc.setPinned(newStatus);
                this.updatePinned(userDoc, tranDB);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    private void updatePinned(UserDocContent userDocContent, String tranDB) {
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Transaction tx = session.beginTransaction();
            session.update((Object)userDocContent);
            tx.commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public void updateUserAccDate(java.util.Date newUsrAccDate, String docId, String loginCode, String tranDB) {
        BaseLogger.log("2", null, null, " updateUserAccDate IN DAO: DOC ID:[" + docId + "] newUsrAccDate:[" + newUsrAccDate + "]loginCode" + loginCode);
        List contentList = new ArrayList();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserDocContent userId: [" + docId + "]");
            Query query = session.createQuery("from UserDocContent where docId='" + docId + "' and  userId='" + loginCode + "'");
            contentList = query.getResultList();
            BaseLogger.log("3", null, null, "contentList in updateStatus ::" + contentList);
            for (UserDocContent userDoc : contentList) {
                userDoc.setLastUserAccDate(newUsrAccDate);
                this.updateUserAccDate(userDoc, tranDB);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    private void updateUserAccDate(UserDocContent userDocContent, String tranDB) {
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Transaction tx = session.beginTransaction();
            session.update((Object)userDocContent);
            tx.commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public void updatGenAccDate(java.util.Date newGenAccDate, String docId, String tranDB) {
        BaseLogger.log("2", null, null, " updatGenAccDate IN DAO: DOC ID:[" + docId + "] newGenAccDate:[" + newGenAccDate + "]");
        List contentList = new ArrayList();
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserDocContent userId: [" + docId + "]");
            Query query = session.createQuery("from UserDocContent where docId='" + docId + "'");
            contentList = query.getResultList();
            BaseLogger.log("3", null, null, "contentList in updateStatus ::" + contentList);
            for (UserDocContent userDoc : contentList) {
                userDoc.setLastGenAccDate(newGenAccDate);
                this.updateUserAccDate(userDoc, tranDB);
            }
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    private void updateDocContent(UserDocContent userDocContent, String tranDB) {
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Transaction tx = session.beginTransaction();
            session.update((Object)userDocContent);
            tx.commit();
            session.close();
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
    }

    public void updateTransactionLink(List<DocTransLink> insertTranList, List<DocTransLink> updateTranList, String tranDB) {
        Session session = null;
        List getTransactionsList = null;
        try {
            try {
                session = HibernateUtil.getSessionFactory(tranDB).openSession();
                Transaction tx = session.beginTransaction();
                int cn = 0;
                while (cn < updateTranList.size()) {
                    DocTransLink docTranObject = updateTranList.get(cn);
                    BaseLogger.log("3", null, null, String.valueOf(cn) + " > docTranObject : " + docTranObject);
                    Query query = session.createQuery("from DocTransLink  where docId='" + docTranObject.getDocId() + "' " + "and trim(refSer ) = '" + docTranObject.getRefSer() + "' " + "and trim(refId ) = '" + docTranObject.getRefId() + "' ");
                    getTransactionsList = query.getResultList();
                    if (!getTransactionsList.isEmpty()) {
                        DocTransLink docTransLink = (DocTransLink)getTransactionsList.get(0);
                        String newPageInfo = docTranObject.getPageInfo();
                        String prevPageInfo = docTransLink.getPageInfo();
                        BaseLogger.log("3", null, null, " newPageInfo : " + newPageInfo + " , prevPageInfo : " + prevPageInfo);
                        if (!newPageInfo.equalsIgnoreCase(prevPageInfo)) {
                            docTransLink.setPageInfo(docTranObject.getPageInfo());
                            BaseLogger.log("3", null, null, "1 getTransactionsList in updateTransactionLink ::" + docTransLink);
                            session.update((Object)docTransLink);
                        }
                    }
                    ++cn;
                }
                for (DocTransLink docTransLink : insertTranList) {
                    session.save((Object)docTransLink);
                }
                tx.commit();
            }
            catch (HibernateException e) {
                BaseLogger.log("0", null, null, "ContentLibraryDao.updateTransactionLink() HibernateException :");
                BaseLogger.log("0", null, null, e.getMessage());
                try {
                    session.close();
                }
                catch (Exception e2) {
                    BaseLogger.log("0", null, null, "ContentLibraryDao.updateTransactionLink() Exception while session closing :");
                    BaseLogger.log("0", null, null, e2.getMessage());
                }
            }
        }
        finally {
            try {
                session.close();
            }
            catch (Exception e2) {
                BaseLogger.log("0", null, null, "ContentLibraryDao.updateTransactionLink() Exception while session closing :");
                BaseLogger.log("0", null, null, e2.getMessage());
            }
        }
    }

    public UserDocContent getUserDocContent(String userId, String docId, String tranDB) {
        UserDocContent docContent = null;
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            BaseLogger.log("3", null, null, "Inside getuserDocContent userId: [" + userId + "] and docId: [" + docId + "]");
            Query query = session.createQuery("from UserDocContent where userId='" + userId + "' AND docId = '" + docId + "'");
            List contentList = query.getResultList();
            if (query.getResultList().size() > 0) {
                docContent = (UserDocContent)contentList.get(0);
            }
            BaseLogger.log("3", null, null, "docContent ::" + docContent);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return docContent;
    }

    public JSONArray getReferences() {
        BaseLogger.log("9", null, null, "refSerListObj in getRefSerList " + this.refrenceArr);
        return this.refrenceArr;
    }

    public UserDocContent deactivateDocContent(String docId, String loginCode, String tranDB) {
        boolean isDocExist = this.isDocExist(docId, tranDB);
        UserDocContent docContent = null;
        try {
            String docStatus = isDocExist ? "S" : "D";
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Query query = session.createQuery("from UserDocContent where docId = '" + docId + "'");
            List docContents = query.getResultList();
            if (!docContents.isEmpty() && docContents.size() > 0) {
                System.out.printf("ContentLibraryDao :: deactivateDocContent() : [%d] document(s) found for document id [%s]\n", docContents.size(), docId);
                docContent = (UserDocContent)docContents.get(0);
                for (UserDocContent userDocContent : docContents) {
                    userDocContent.setDocStatus(docStatus);
                    this.updateDocContent(userDocContent, tranDB);
                }
            } else {
                System.out.printf("ContentLibraryDao :: deactivateDocContent() : No document found for document id [%s]\n", docId);
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception :");
            BaseLogger.log("0", null, null, ex.getMessage());
        }
        return docContent;
    }

    public boolean isDocExist(String docId, String tranDB) {
        boolean isDocExist = false;
        try {
            Session session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Query query = session.createQuery("from DocTransLink where docId = '" + docId + "'");
            List contentList = query.getResultList();
            if (query.getResultList().size() > 0) {
                isDocExist = true;
            }
            BaseLogger.log("3", null, null, "isDocExist ::" + isDocExist);
        }
        catch (HibernateException e) {
            BaseLogger.log("0", null, null, "HibernateException :");
            BaseLogger.log("0", null, null, e.getMessage());
        }
        return isDocExist;
    }

    public List<JSONObject> getAssociateData(String doc_type, String doc_id, String tranDB) {
        List<String> objList = this.getObjList(doc_type, tranDB);
        BaseLogger.log("2", null, null, "objList : [" + objList + "]");
        if (objList != null && !objList.isEmpty()) {
            ObjDetails objDetail;
            String objListStr = "";
            int count = 0;
            for (String obj : objList) {
                BaseLogger.log("3", null, null, "Obj Name :[" + obj + "]");
                objDetail = new ObjDetails();
                objDetail.setObj_name(obj);
                this.assocObjMap.put(obj, objDetail);
                objListStr = count == 0 ? "'" + obj + "'" : String.valueOf(objListStr) + ",'" + obj + "'";
                ++count;
            }
            this.getObjDetails(doc_type, doc_id, objListStr, tranDB);
            for (String key : this.assocObjMap.keySet()) {
                objDetail = this.assocObjMap.get(key);
                JSONObject objDetailJson = new JSONObject((Object)objDetail);
                this.assocObjList.add(objDetailJson);
            }
        }
        return this.assocObjList;
    }

    private List<String> getObjList(String doc_type, String tranDB) {
        Session session = null;
        List<String> objList = new ArrayList<String>();
        try {
            try {
                BaseLogger.log("3", null, null, "Inside getAssociateData method !! doc_type:[" + doc_type + "]");
                session = HibernateUtil.getSessionFactory(tranDB).openSession();
                Transaction tx = session.beginTransaction();
                NativeQuery query = session.createNativeQuery(" select 'w_' || OBJ_NAME from obj_attach_config where doc_type = '" + doc_type + "'" + "AND obj_name <> 'content_library'");
                objList = query.getResultList();
                BaseLogger.log("3", null, null, "objList : [" + objList + "]");
                tx.commit();
                session.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "HibernateException :" + e);
                BaseLogger.log("0", null, null, e.getMessage());
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
        return objList;
    }

    private void getObjDetails(String doc_type, String doc_id, String objListStr, String tranDB) {
        Session session = null;
        try {
            try {
                NativeQuery query3;
                List refSerCountList;
                BaseLogger.log("3", null, null, "Inside getObjDetails method !! objListStr:[" + objListStr + "]");
                session = HibernateUtil.getSessionFactory(tranDB).openSession();
                Transaction tx = session.beginTransaction();
                NativeQuery query1 = session.createNativeQuery("select distinct trim(WIN_NAME), DESCR, COMMENTS, ICON_PATH from itm2menu where WIN_NAME in(" + objListStr + ")");
                List objDetailList1 = query1.getResultList();
                BaseLogger.log("3", null, null, "objDetailList : [" + objDetailList1 + "]");
                if (objDetailList1 != null && !objDetailList1.isEmpty()) {
                    for (Object[] row : objDetailList1) {
                        String obj_name = this.checkNull(row[0]);
                        ObjDetails objDetail = this.assocObjMap.get(obj_name);
                        objDetail.setDescr(this.checkNull(row[1]));
                        objDetail.setComments(this.checkNull(row[2]));
                        objDetail.setIcon_path(this.checkNull(row[3]));
                        this.assocObjMap.replace(obj_name, objDetail);
                    }
                }
                NativeQuery query2 = session.createNativeQuery("select trim(tran_window), REF_SER, THUMB_OBJ, THUMB_IMAGE_COL, THUMB_ALT_COL, TABLE_NAME, TRAN_ID_COL from transetup where trim(tran_window) in(" + objListStr + ")");
                List objDetailList2 = query2.getResultList();
                HashMap<String, String> refSerMap = new HashMap<String, String>();
                String refSerListStr = "";
                int count = 0;
                BaseLogger.log("3", null, null, "objDetailList : [" + objDetailList2 + "]");
                if (objDetailList2 != null && !objDetailList2.isEmpty()) {
                    for (Object[] row : objDetailList2) {
                        String obj_name = this.checkNull(row[0]);
                        String ref_ser = this.checkNull(row[1]);
                        ObjDetails objDetail = this.assocObjMap.get(obj_name);
                        objDetail.setRef_ser(ref_ser);
                        objDetail.setThumb_obj(this.checkNull(row[2]));
                        objDetail.setThumb_image_col(this.checkNull(row[3]));
                        objDetail.setThumb_alt_col(this.checkNull(row[4]));
                        objDetail.setTable_name(this.checkNull(row[5]));
                        objDetail.setTrand_id_col(this.checkNull(row[6]));
                        this.assocObjMap.replace(obj_name, objDetail);
                        if (ref_ser != null && ref_ser != "") {
                            refSerMap.put(ref_ser.trim(), obj_name);
                        }
                        refSerListStr = count == 0 ? "'" + ref_ser + "'" : String.valueOf(refSerListStr) + ",'" + ref_ser + "'";
                        ++count;
                    }
                }
                if ((refSerCountList = (query3 = session.createNativeQuery("select REF_SER, count(REF_SER) from doc_transaction_link where doc_id = '" + doc_id + "'" + " and doc_type_attach = '" + doc_type + "'" + " and trim(REF_SER) in (" + refSerListStr + ")" + " group by REF_SER")).getResultList()) != null && !refSerCountList.isEmpty()) {
                    for (Object[] row : refSerCountList) {
                        BaseLogger.log("3", null, null, "ref_ser & count: [" + row[0] + "] [" + row[1] + "]");
                        String ref_ser = this.checkNull(row[0]);
                        String obj_name = (String)refSerMap.get(ref_ser.trim());
                        BaseLogger.log("3", null, null, "obj_name & refSerMap: [" + obj_name + "] [" + refSerMap + "]");
                        if (obj_name == null || obj_name == "") continue;
                        ObjDetails objDetail = this.assocObjMap.get(obj_name);
                        objDetail.setRef_ser_count(this.checkNull(row[1]));
                        this.assocObjMap.replace(obj_name, objDetail);
                    }
                }
                tx.commit();
                session.close();
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "HibernateException :" + e);
                BaseLogger.log("0", null, null, e.getMessage());
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
    }

    public JSONObject getTransDetails(String docId, String docType, String refSer, String tranDB, String objName, String tableName, String tranIDCol) {
        Session session = null;
        JSONObject assocTranList = new JSONObject();
        JSONObject tranPageInfo = new JSONObject();
        try {
            boolean isMultipleTranId;
            session = HibernateUtil.getSessionFactory(tranDB).openSession();
            Transaction tx = session.beginTransaction();
            NativeQuery query = session.createNativeQuery("select ref_id, page_info from doc_transaction_link where doc_id = '" + docId + "'" + " and doc_type_attach = '" + docType + "' " + " and trim(REF_SER) = '" + refSer + "'" + " order by REF_SER");
            List transList = query.getResultList();
            String refIdList = "";
            ArrayList<String> refIdArrayList = new ArrayList<String>();
            boolean bl = isMultipleTranId = tranIDCol.split(",").length > 1;
            if (transList != null && !transList.isEmpty()) {
                for (Object[] row : transList) {
                    String refId = this.checkNull(row[0]);
                    String pageInfo = this.checkNull(row[1]);
                    refIdList = String.valueOf(refIdList) + ",'" + refId + "'";
                    refIdArrayList.add(refId);
                    tranPageInfo.put(refId, (Object)pageInfo);
                }
            }
            BaseLogger.log("3", null, null, "tranPageInfo : " + tranPageInfo);
            objName = objName.toUpperCase();
            String fieldName = tranIDCol.toUpperCase();
            fieldName = tranIDCol.replace(" ", "");
            query = session.createNativeQuery("SELECT SQL_STR,LAYOUT FROM POPHELP WHERE MOD_NAME='W_" + objName + "' AND FIELD_NAME='" + fieldName + "'");
            List polhelpResultList = query.getResultList();
            String popHelpSqlStr = "";
            String templetStr = "";
            if (!polhelpResultList.isEmpty()) {
                Object[] row = (Object[])polhelpResultList.get(0);
                popHelpSqlStr = this.checkNull(row[0]);
                templetStr = this.checkNull(row[1]);
            }
            assocTranList.put("template", (Object)templetStr);
            BaseLogger.log("3", null, null, "isMultipleTranId [" + isMultipleTranId + "]");
            if (!isMultipleTranId) {
                refIdList = refIdList.length() < 2 ? "''" : refIdList.substring(1);
                popHelpSqlStr = this.alterQueryForSingleTranId(popHelpSqlStr, tranIDCol, refIdList);
                System.out.printf("ContentLibraryDao :: getTransDetails() : popHelpSqlStr [%s]\n", popHelpSqlStr);
                query = session.createNativeQuery(popHelpSqlStr);
                query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                List aliasToValueMapList = query.list();
                System.out.printf("ContentLibraryDao :: getTransDetails() : aliasToValueMapList [%s]\n", aliasToValueMapList.toString());
                System.out.printf("ContentLibraryDao :: getTransDetails() : aliasToValueMapList.size [%s]\n", aliasToValueMapList.size());
                tranIDCol = this.checkNull(tranIDCol);
                if (!aliasToValueMapList.isEmpty()) {
                    JSONArray dataList = new JSONArray();
                    for (Map result : aliasToValueMapList) {
                        JSONObject tranDetailObj = new JSONObject();
                        Set columnNames = result.keySet();
                        for (String columnName : columnNames) {
                            columnName = this.checkNull(columnName);
                            String columnValue = String.valueOf(result.get(columnName));
                            columnValue = this.checkNull(columnValue);
                            tranDetailObj.put(columnName.toLowerCase(), (Object)columnValue);
                        }
                        String tranIdValue = String.valueOf(result.get(tranIDCol = tranIDCol.toUpperCase()));
                        tranIdValue = tranIdValue != null ? tranIdValue.trim() : tranIdValue;
                        String pageInfo = String.valueOf(tranPageInfo.get(tranIdValue));
                        tranDetailObj.put("@page_info", (Object)pageInfo);
                        tranDetailObj.put("@ref_id", (Object)tranIdValue);
                        dataList.put((Object)tranDetailObj);
                    }
                    assocTranList.put("data", (Object)dataList);
                }
            } else {
                JSONArray data = new JSONArray();
                for (String refId : refIdArrayList) {
                    Map<String, Object> existingTransactionRow = this.getTransactionsDataForMultipleTranIds(popHelpSqlStr, tableName, tranIDCol, refId, session);
                    BaseLogger.log("3", null, null, "ContentLibraryDao :: getTransDetails() : existingTransactionRow [" + existingTransactionRow + "]");
                    JSONObject rowObject = new JSONObject();
                    Set<String> columnNames = existingTransactionRow.keySet();
                    System.out.printf("ContentLibraryDao :: getTransDetails() : Tran id Multiple [%s]\n", columnNames.toString());
                    for (String columnName : columnNames) {
                        String columnValue = String.valueOf(existingTransactionRow.get(columnName));
                        columnName = columnName.toLowerCase();
                        rowObject.put(columnName, (Object)columnValue);
                    }
                    String pageInfo = String.valueOf(tranPageInfo.get(refId));
                    rowObject.put("@page_info", (Object)pageInfo);
                    rowObject.put("@ref_id", (Object)refId);
                    data.put((Object)rowObject);
                }
                assocTranList.put("data", (Object)data);
                BaseLogger.log("3", null, null, "ContentLibraryDao :: getTransDetails() : assocTranList [" + assocTranList + "]");
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exceptin in ContentLibraryDao.getTransDetails ::" + ex);
            ex.printStackTrace();
            this.printStackTrace(ex);
        }
        return assocTranList;
    }

    private void printStackTrace(Exception ex) {
        StackTraceElement[] elements = ex.getStackTrace();
        BaseLogger.log("2", null, null, String.valueOf(ex.getClass().getSimpleName()) + " : " + ex.getMessage());
        StackTraceElement[] stackTraceElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            BaseLogger.log("9", null, null, "\tat " + element.toString());
            ++n2;
        }
    }

    private String alterQueryForSingleTranId(String sqlQuery, String tranIDCol, String tranIds) {
        sqlQuery = (sqlQuery = this.removeSemiColon(sqlQuery)).toUpperCase().contains("WHERE") ? String.valueOf(sqlQuery) + " AND " + tranIDCol + " IN (" + tranIds + ")" : String.valueOf(sqlQuery) + " WHERE " + tranIDCol + " IN (" + tranIds + ")";
        return sqlQuery;
    }

    private Map<String, Object> getTransactionsDataForMultipleTranIds(String sqlQuery, String tableName, String tranIdCol, String refId, Session session) {
        Map<String, Object> row = new HashMap<String, Object>();
        String[] tranIdCols = tranIdCol.split(",");
        String[] refIdExtracted = refId.split(":");
        String query = this.includeTranIdConditions(sqlQuery, tableName, tranIdCols, refIdExtracted);
        NativeQuery nativeQuery = session.createNativeQuery(query);
        nativeQuery.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List result = nativeQuery.list();
        BaseLogger.log("2", null, null, "ContentLibraryDao :: getTransactionsDataForMultipleTranIds() : " + result);
        if (result != null && result.size() > 0) {
            row = (Map)result.get(0);
        }
        return row;
    }

    private String includeTranIdConditions(String sqlQuery, String tableName, String[] tranIdCols, String[] refIdExtracted) {
        String tableAlias = ContentLibraryDao.getTableAlias(sqlQuery, tableName);
        if ((tableAlias = this.checkNull(tableAlias)).length() > 0) {
            tableAlias = String.valueOf(tableAlias) + ".";
        }
        sqlQuery = sqlQuery.toUpperCase().contains(" WHERE ") ? String.valueOf(sqlQuery) + " AND " : String.valueOf(sqlQuery) + " WHERE ";
        int i = 0;
        while (i < tranIdCols.length) {
            String tranId = tranIdCols[i];
            String refIdPart = refIdExtracted[i];
            sqlQuery = String.valueOf(sqlQuery) + String.format("%s%s='%s' AND ", tableAlias, tranId.trim(), refIdPart.trim());
            ++i;
        }
        if (sqlQuery.endsWith(" AND ")) {
            sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 5);
        }
        BaseLogger.log("2", null, null, "includeTranIdConditions sqlQuery [" + sqlQuery + "]");
        return sqlQuery;
    }

    private static String getTableAlias(String sql, String tableName) {
        String aliasName = null;
        try {
            sql = sql.toLowerCase();
            tableName = tableName.toLowerCase();
            String from = "from";
            int indexOfFrom = sql.indexOf(from);
            sql = sql.substring(indexOfFrom + 4);
            int indexOfTableName = sql.indexOf(tableName);
            sql = sql.substring(indexOfTableName + tableName.length()).trim();
            if (!(sql.startsWith("where") || sql.startsWith("order by") || sql.startsWith("group by"))) {
                sql = sql.replace(",", "");
                int indexOfSpace = sql.indexOf(" ");
                aliasName = sql.substring(0, indexOfSpace);
            }
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exception in ContentLibraryDao :: getTableAlias() : " + ex);
            aliasName = null;
        }
        return aliasName;
    }

    private String removeSemiColon(String sqlQuery) {
        if ((sqlQuery = sqlQuery.trim()).indexOf(";") == sqlQuery.length()) {
            sqlQuery = sqlQuery.substring(0, sqlQuery.length() - 1);
        }
        return sqlQuery;
    }

    public String checkNull(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString().trim();
    }

    public JSONObject getNewTransctionList(String docType, String qLike, String docId, String refSer, String tranDB, String objName, String tableName, String tranIDCol) {
        qLike = qLike.toLowerCase();
        Session session = null;
        JSONObject assocTranList = new JSONObject();
        try {
            session = HibernateUtil.getSessionFactory(tranDB).openSession();
            objName = objName.toUpperCase();
            String fieldName = tranIDCol.toUpperCase();
            fieldName = tranIDCol.replace(" ", "");
            NativeQuery query = session.createNativeQuery("SELECT SQL_STR, LAYOUT, FILTER_EXPR FROM POPHELP WHERE MOD_NAME='W_" + objName + "'AND FIELD_NAME='" + fieldName + "'");
            List polhelpResultList = query.getResultList();
            String popHelpSqlStr = "";
            String templetStr = "";
            String filterCol = "";
            if (!polhelpResultList.isEmpty()) {
                Object[] row = (Object[])polhelpResultList.get(0);
                popHelpSqlStr = this.checkNull(row[0]);
                templetStr = this.checkNull(row[1]);
                filterCol = this.checkNull(row[2]);
                if (popHelpSqlStr.endsWith(";")) {
                    popHelpSqlStr = popHelpSqlStr.substring(0, popHelpSqlStr.length() - 1);
                }
            }
            String tableAliasForNotIn = "";
            String tranIdsWithAlias = "";
            String[] tranIds = tranIDCol.toUpperCase().split(",");
            String tableAlias = ContentLibraryDao.getTableAlias(popHelpSqlStr, tableName);
            if ((tableAlias = this.checkNull(tableAlias)).length() > 0) {
                tableAlias = String.valueOf(tableAlias) + ".";
            }
            if (filterCol.length() == 0) {
                tableAliasForNotIn = tranIdsWithAlias = this.getColumnsWithTableAlias(tranIds, tableAlias);
            } else {
                String[] filterCoIds = filterCol.toUpperCase().split(",");
                tranIdsWithAlias = this.getColumnsWithTableAlias(filterCoIds, "");
                tableAliasForNotIn = this.getColumnsWithTableAlias(tranIds, tableAlias);
            }
            String formatString = "";
            String notIn = String.format("SELECT REF_ID FROM DOC_TRANSACTION_LINK WHERE DOC_ID='%s' AND DOC_TYPE_ATTACH='%s' AND TRIM(REF_SER)='%s'", docId, docType, refSer);
            formatString = popHelpSqlStr.toUpperCase().contains("WHERE") ? "%s AND LOWER(%s) like '%%%s%%' AND %s NOT IN (%s)" : "%s WHERE LOWER(%s) like '%%%s%%' AND %s NOT IN (%s)";
            popHelpSqlStr = String.format(formatString, popHelpSqlStr, tranIdsWithAlias, qLike, tableAliasForNotIn, notIn);
            BaseLogger.log("9", null, null, "popHelpSqlStr : " + popHelpSqlStr);
            query = session.createNativeQuery(popHelpSqlStr);
            query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List aliasToValueMapList = query.list();
            List<String> tranIdList = Arrays.asList(tranIds);
            JSONArray rowList = new JSONArray();
            int counter = 0;
            for (Map row : aliasToValueMapList) {
                ++counter;
                Set columnNames = row.keySet();
                JSONObject columnNameValuePair = new JSONObject();
                String refId = "";
                HashMap<String, String> tranIdsColumnValue = new HashMap<String, String>();
                for (String columnName : columnNames) {
                    String columnValue = this.checkNull(row.get(columnName));
                    columnNameValuePair.put(columnName.toLowerCase(), (Object)columnValue);
                    if (!tranIdList.contains(columnName)) continue;
                    tranIdsColumnValue.put(columnName, columnValue);
                }
                String[] stringArray = tranIds;
                int n = tranIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String tranId = stringArray[n2];
                    refId = String.valueOf(refId) + (String)tranIdsColumnValue.get(tranId) + ":";
                    ++n2;
                }
                if (refId.endsWith(":")) {
                    refId = refId.substring(0, refId.length() - 1);
                }
                columnNameValuePair.put("@ref_id", (Object)refId);
                columnNameValuePair.put("template", (Object)templetStr);
                rowList.put((Object)columnNameValuePair);
                if (counter >= 20) break;
            }
            if (rowList.length() > 0) {
                assocTranList.put("template", (Object)templetStr);
                assocTranList.put("details", (Object)rowList);
            }
            BaseLogger.log("3", null, null, "ContentLibraryDao :: getNewTransctionList() : assocTranList [" + assocTranList + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exceptin in ContentLibraryDao.getTransDetails ::" + ex);
            ex.printStackTrace();
            this.printStackTrace(ex);
        }
        return assocTranList;
    }

    private String getColumnsWithTableAlias(String[] tranIds, String tableAlias) {
        String tranIdsWithAlias = "";
        int i = 0;
        while (i < tranIds.length) {
            String tranId = tranIds[i].trim();
            BaseLogger.log("3", null, null, "ContentLibraryDao :: getNewTransctionList() : tranId [" + tranId + "]");
            tranIds[i] = tranId;
            tranIdsWithAlias = String.valueOf(tranIdsWithAlias) + String.format("TRIM(%s%s),", tableAlias, tranId.trim());
            ++i;
        }
        if (tranIdsWithAlias.endsWith(",")) {
            tranIdsWithAlias = tranIdsWithAlias.substring(0, tranIdsWithAlias.length() - 1);
        }
        if (tranIds.length > 1) {
            tranIdsWithAlias = tranIdsWithAlias.replace(",", " || ':' || ");
        }
        return tranIdsWithAlias;
    }

    public JSONObject getObjLinksDetails(String objName, String targetObjName, String tranDB) {
        Session session = null;
        JSONObject objLinkDetailsTemp = new JSONObject();
        JSONObject objLinkDetails = new JSONObject();
        try {
            session = HibernateUtil.getSessionFactory(tranDB).openSession();
            String sql = "SELECT OBJ_NAME,FORM_NO,FIELD_NAME,TARGET_OBJ_NAME,LINK_FORM_NAME,LINK_TITLE,LINK_URI,LINK_TYPE,LINK_ARG,UPDATE_FLAG,LINK_NAME,RIGHTS_CHAR,IMAGE,SHOW_IN_PANEL,SHORTCUT_CHAR,AUTO_INVOKE,SWIPE_POSITION,TITLE,DESCR,SHOW_CONFIRM,DISPLAY_MODE,LINE_NO,LINK_ID,REC_SPECIFIC FROM OBJ_LINKS WHERE OBJ_NAME = '" + objName + "' AND TARGET_OBJ_NAME ='" + targetObjName + "'";
            NativeQuery query = session.createNativeQuery(sql);
            query = session.createNativeQuery(sql);
            query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List aliasToValueMapList = query.list();
            if (aliasToValueMapList.size() > 0) {
                for (Map row : aliasToValueMapList) {
                    Set columnNames = row.keySet();
                    for (String columnName : columnNames) {
                        String columnValue = this.checkNull(row.get(columnName));
                        objLinkDetailsTemp.put(columnName.toLowerCase(), (Object)columnValue);
                    }
                }
                objLinkDetails.put("FormNo", objLinkDetailsTemp.get("form_no"));
                objLinkDetails.put("ShowInPanel", objLinkDetailsTemp.get("show_in_panel"));
                objLinkDetails.put("Image", objLinkDetailsTemp.get("image"));
                objLinkDetails.put("TargetObject", objLinkDetailsTemp.get("target_obj_name"));
                objLinkDetails.put("ShortcutChar", objLinkDetailsTemp.get("shortcut_char"));
                objLinkDetails.put("UpdateFlag", objLinkDetailsTemp.get("update_flag"));
                objLinkDetails.put("RightsChar", objLinkDetailsTemp.get("rights_char"));
                objLinkDetails.put("LinkUri", objLinkDetailsTemp.get("link_uri"));
                objLinkDetails.put("AutoInvoke", objLinkDetailsTemp.get("auto_invoke"));
                objLinkDetails.put("LinkArg", objLinkDetailsTemp.get("link_arg"));
                objLinkDetails.put("LinkForm", objLinkDetailsTemp.get("link_form_name"));
                objLinkDetails.put("LinkType", objLinkDetailsTemp.get("link_type"));
                objLinkDetails.put("FieldName", objLinkDetailsTemp.get("field_name"));
                objLinkDetails.put("LinkTitle", objLinkDetailsTemp.get("link_title"));
                objLinkDetails.put("ShowConfirm", objLinkDetailsTemp.get("show_confirm"));
                objLinkDetails.put("DisplayMode", objLinkDetailsTemp.get("display_mode"));
                objLinkDetails.put("LineNo", objLinkDetailsTemp.get("line_no"));
                objLinkDetails.put("linkId", objLinkDetailsTemp.get("link_id"));
                objLinkDetails.put("RecordSpecific", objLinkDetailsTemp.get("rec_specific"));
            }
            BaseLogger.log("3", null, null, "ContentLibraryDao :: getObjLinksDetails() : objLinksDetails [" + objLinkDetails + "]");
            BaseLogger.log("3", null, null, "objLinkDetailsTemp [" + objLinkDetailsTemp + "]");
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Exceptin in ContentLibraryDao.getObjLinksDetails ::" + ex);
            ex.printStackTrace();
            this.printStackTrace(ex);
        }
        return objLinkDetails;
    }

    public String updateSharedUsersDetails(UserInfoBean userInfo, String docId, String usersList, String remarks) throws RemoteException, SQLException {
        String response;
        block32: {
            response = "";
            Connection connection = null;
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    String transDB = userInfo.getTransDB();
                    ConnDriver connDriver = new ConnDriver();
                    connection = connDriver.getConnectDB(transDB);
                    int insertCount = 0;
                    int count = 0;
                    String selectSql = "SELECT COUNT(*) as count FROM SHARE_DOCS WHERE DOC_ID=? and USER_ID_SHARED=?";
                    pstmt = connection.prepareStatement(selectSql);
                    pstmt.setString(1, docId);
                    pstmt.setString(2, userInfo.getLoginCode());
                    rs = pstmt.executeQuery();
                    int sqlCount = 0;
                    if (rs.next()) {
                        sqlCount = rs.getInt("count");
                    }
                    pstmt.close();
                    pstmt = null;
                    rs.close();
                    rs = null;
                    int cnt = 0;
                    if (sqlCount > 0) {
                        String updateSharedSql = "UPDATE SHARE_DOCS SET SHARE_STATUS=? WHERE DOC_ID=? and USER_ID_SHARED=?";
                        pstmt = connection.prepareStatement(updateSharedSql);
                        pstmt.setString(1, "R");
                        pstmt.setString(2, docId);
                        pstmt.setString(3, userInfo.getLoginCode());
                        cnt = pstmt.executeUpdate();
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                    }
                    String[] strArray = usersList.split(",");
                    int i = 0;
                    while (i < strArray.length) {
                        String sql = "SELECT COUNT(*) as count FROM SHARE_DOCS WHERE DOC_ID=? and USER_ID=? and USER_ID_SHARED=?";
                        pstmt = connection.prepareStatement(sql);
                        pstmt.setString(1, docId);
                        pstmt.setString(2, strArray[i]);
                        pstmt.setString(3, userInfo.getLoginCode());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            count = rs.getInt("count");
                        }
                        rs.close();
                        rs = null;
                        pstmt.close();
                        pstmt = null;
                        if (count == 0) {
                            if (!strArray[i].equals(userInfo.getLoginUserId())) {
                                String insertSql = "Insert into SHARE_DOCS (DOC_ID,USER_ID,USER_ID_SHARED,REMARKS,SHARE_STATUS,ADD_TERM,ADD_USER,ADD_DATE,CHG_TERM,CHG_USER,CHG_DATE) values (?,?,?,?,?,?,?,?,?,?,?)";
                                pstmt = connection.prepareStatement(insertSql);
                                pstmt.setString(1, docId);
                                pstmt.setString(2, strArray[i]);
                                pstmt.setString(3, userInfo.getLoginCode());
                                pstmt.setString(4, remarks);
                                pstmt.setString(5, "S");
                                pstmt.setString(6, userInfo.getLoginCode());
                                pstmt.setString(7, userInfo.getLoginCode());
                                pstmt.setDate(8, new Date(new java.util.Date().getTime()));
                                pstmt.setString(9, userInfo.getLoginCode());
                                pstmt.setString(10, userInfo.getLoginCode());
                                pstmt.setDate(11, new Date(new java.util.Date().getTime()));
                                insertCount = pstmt.executeUpdate();
                                if (pstmt != null) {
                                    pstmt.close();
                                    pstmt = null;
                                }
                            }
                        } else if (count > 0) {
                            String updateSql = "UPDATE SHARE_DOCS SET REMARKS=? WHERE DOC_ID=? and USER_ID=? and USER_ID_SHARED=?";
                            pstmt = connection.prepareStatement(updateSql);
                            pstmt.setString(1, remarks);
                            pstmt.setString(2, docId);
                            pstmt.setString(3, strArray[i]);
                            pstmt.setString(4, userInfo.getLoginCode());
                            int updCount = pstmt.executeUpdate();
                            if (pstmt != null) {
                                pstmt.close();
                                pstmt = null;
                            }
                        }
                        ++i;
                    }
                    if (connection != null) {
                        connection.commit();
                        connection.close();
                        connection = null;
                    }
                    response = this.bisUtility.getErrorJsonString("VTCLSUASUC", userInfo.getLoginCode(), null, this.getResponseTo(), "");
                }
                catch (Exception e) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                            connection.close();
                            connection = null;
                        }
                    }
                    catch (Exception catche) {
                        BaseLogger.log("0", userInfo, null, "Exception in updateSharedUsersList:[" + E12GenericUtility.getStackTrace(e) + "]");
                        ITMException itmExp = new ITMException(e);
                        response = itmExp.getMessage();
                    }
                    if (connection != null) {
                        if (rs != null) {
                            rs.close();
                            rs = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    break block32;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                throw throwable;
            }
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        BaseLogger.log("2", null, null, "Inside updateSharedUsersList response:::::::" + response);
        return response;
    }

    public String getSharedUsersDetails(UserInfoBean userInfo, String docId) throws RemoteException, SQLException {
        String response;
        block21: {
            response = "";
            Connection connection = null;
            Statement pstmt = null;
            ResultSet mResultSet = null;
            try {
                try {
                    String transDB = userInfo.getTransDB();
                    ConnDriver connDriver = new ConnDriver();
                    connection = connDriver.getConnectDB(transDB);
                    String sql = "SELECT USER_ID, REMARKS FROM SHARE_DOCS WHERE DOC_ID=? and USER_ID_SHARED=?";
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, docId);
                    pstmt.setString(2, userInfo.getLoginCode());
                    mResultSet = pstmt.executeQuery();
                    String usersList = "";
                    JSONObject responseJsn = new JSONObject();
                    while (mResultSet.next()) {
                        String userId = E12GenericUtility.checkNull(mResultSet.getString("USER_ID"));
                        String remarks = E12GenericUtility.checkNull(mResultSet.getString("REMARKS"));
                        usersList = "".equals(usersList) ? userId : String.valueOf(usersList) + "," + userId;
                        responseJsn.put("USERS_LIST", (Object)usersList);
                        responseJsn.put("REMARKS", (Object)remarks);
                    }
                    response = responseJsn.toString();
                    mResultSet.close();
                    mResultSet = null;
                    pstmt.close();
                    pstmt = null;
                }
                catch (Exception e) {
                    try {
                        if (connection != null) {
                            connection.rollback();
                            connection.close();
                            connection = null;
                        }
                    }
                    catch (Exception catche) {
                        BaseLogger.log("0", null, null, "Exception inside getSharedUsersDetails[" + E12GenericUtility.getStackTrace(e) + "]");
                        ITMException itmExp = new ITMException(e);
                        response = itmExp.getMessage();
                    }
                    if (connection != null) {
                        if (mResultSet != null) {
                            mResultSet.close();
                            mResultSet = null;
                        }
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (connection != null) {
                            connection.close();
                            connection = null;
                        }
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    if (mResultSet != null) {
                        mResultSet.close();
                        mResultSet = null;
                    }
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (connection != null) {
                        connection.close();
                        connection = null;
                    }
                }
                throw throwable;
            }
            if (connection != null) {
                if (mResultSet != null) {
                    mResultSet.close();
                    mResultSet = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        BaseLogger.log("2", null, null, "Inside getSharedUsersDetails response:::::::" + response);
        return response;
    }

    public String getResponseTo() {
        return this.responseTo;
    }
}

