/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.uns.schedule;

import ibase.scheduler.utility.interfaces.Schedule;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.utility.E12ExternalAPICall;
import ibase.webitm.utility.ITMException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScheduledAPICall
implements Schedule {
    E12GenericUtility e12GenericUtility = new E12GenericUtility();
    boolean objNamebool = false;
    boolean actionbool = false;
    boolean durationbool = false;
    boolean appIDbool = false;
    String objName = "";
    String action = "";
    String durationStr = "";
    String appID = "";
    UserInfoBean userInfoGlobal = new UserInfoBean();
    NodeList argNodeList = null;

    public String schedule(HashMap arg0) throws Exception {
        return null;
    }

    public String schedule(String name) throws Exception {
        UserInfoBean userInfo;
        BaseLogger.log((String)"2", null, null, (Object)"ScehduledAPICall calling------------------");
        BaseLogger.log((String)"3", null, null, (Object)("name::[ " + name + " ]"));
        Document schdulerInfoDocument = this.e12GenericUtility.parseString(name);
        this.userInfoGlobal = userInfo = new UserInfoBean(this.e12GenericUtility.serializeDom(schdulerInfoDocument.getElementsByTagName("USERINFOXML").item(0).getChildNodes().item(0)));
        this.argNodeList = schdulerInfoDocument.getElementsByTagName("ACTUALPARAMETER");
        int i = 0;
        while (i < this.argNodeList.getLength()) {
            Node childNode = this.argNodeList.item(i);
            if (childNode.getNodeType() == 1 && childNode != null) {
                System.out.println("childNode=[" + childNode + "]");
                this.objNamebool = this.isParameterPresent(childNode, "OBJ_NAME");
                this.actionbool = this.isParameterPresent(childNode, "ACTION");
                this.durationbool = this.isParameterPresent(childNode, "DURATION");
                this.appIDbool = this.isParameterPresent(childNode, "APP_ID");
                if (this.objNamebool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("OBJ_NAME")) {
                    this.objName = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("OBJ_NAME = [" + this.objName + "]");
                }
                if (this.actionbool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("ACTION")) {
                    this.action = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("ACTION = [" + this.action + "]");
                }
                if (this.durationbool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("DURATION")) {
                    this.durationStr = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("DURATION = [" + this.durationStr + "]");
                }
                if (this.appIDbool && childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase("APP_ID")) {
                    this.appID = E12GenericUtility.checkNull((String)childNode.getFirstChild().getNodeValue());
                    System.out.println("APP_ID = [" + this.appID + "]");
                }
            }
            ++i;
        }
        E12ExternalAPICall e12ExternalAPICall = new E12ExternalAPICall(this.appID, userInfo);
        HashMap<String, HashMap<String, String>> getFailedAPIDetails = this.getFailedDetailsFromFUAL(this.objName, this.action, this.appID);
        System.out.println("getFailedAPIDetails hashmap = [" + getFailedAPIDetails + "]");
        DBAccessEJB dbAccess = new DBAccessEJB();
        String maxRetryCountStr = dbAccess.getDBColumnValue("OBJ_FOLLOWUP_ACT", "MAX_RETRY_COUNT", " OBJ_NAME = '" + this.objName + "' AND ACTION_ID = '" + this.action + "' ", userInfo.getTransDB());
        System.out.println("MAX_RETRY_COUNT = [" + maxRetryCountStr + "]");
        int maxRetryCount = Integer.parseInt(maxRetryCountStr);
        long duration = Long.parseLong(this.durationStr);
        this.recallAPI(this.appID, maxRetryCount, duration, e12ExternalAPICall, getFailedAPIDetails, "", userInfo, "");
        return null;
    }

    public String schedulePriority(String arg0) throws Exception {
        return null;
    }

    private boolean isParameterPresent(Node childNode, String attribName) throws ITMException {
        boolean attribFound = false;
        try {
            System.out.println("attribFound test= [" + childNode.getAttributes() + "]");
            if (childNode != null && childNode.getAttributes() != null) {
                System.out.println("attribFound name= [" + childNode.getAttributes().getNamedItem("name").getNodeValue() + "]");
                if (childNode.getAttributes().getNamedItem("name").getNodeValue().equalsIgnoreCase(attribName)) {
                    attribFound = true;
                }
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        System.out.println("attribFound = [" + attribFound + "]");
        return attribFound;
    }

    private HashMap<String, HashMap<String, String>> getFailedDetailsFromFUAL(String objName, String action, String apiName) throws ITMException, SQLException {
        HashMap<String, HashMap<String, String>> result = new HashMap<String, HashMap<String, String>>();
        UserInfoBean userInfo = this.userInfoGlobal;
        Connection connection = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                ConnDriver connDriver = new ConnDriver();
                connection = connDriver.getConnectDB(userInfo.getTransDB());
                String getFailedTranIDSQL = "SELECT REF_ID FROM FOLLOW_UP_ACTIONS_LOGS WHERE OBJ_NAME = ? AND ACTION_NAME = ? AND RESULT_TYPE <> 'S'";
                pstmt = connection.prepareStatement(getFailedTranIDSQL);
                pstmt.setString(1, objName);
                pstmt.setString(2, action);
                rs = pstmt.executeQuery();
                ArrayList<String> refIds = new ArrayList<String>();
                while (rs.next()) {
                    String transactionId = rs.getString("REF_ID");
                    refIds.add(transactionId);
                }
                for (String transactionId : refIds) {
                    String followUpActionLogDataFilePath = "/wildfly/vision_edi/data" + File.separator + objName + File.separator + userInfo.getEnterprise() + File.separator + "follow_up_actions_logs_data" + File.separator + transactionId + ".txt";
                    BaseLogger.log((String)"3", null, null, (Object)("Inside sendJSONData2UNS followUpActionLogDataFilePath [" + followUpActionLogDataFilePath + "]"));
                    if (ScheduledAPICall.fileExists(followUpActionLogDataFilePath)) {
                        String fileContent = ScheduledAPICall.readFileContents(followUpActionLogDataFilePath);
                        JSONObject apiDetailsJSON = new JSONObject(fileContent);
                        String apiURL = apiDetailsJSON.getString("API_URL");
                        String apiParamter = apiDetailsJSON.getString("JSON_DATA");
                        System.out.println("Transaction ID: " + transactionId);
                        System.out.println("File Content: " + fileContent);
                        HashMap<String, String> apiDetails = new HashMap<String, String>();
                        apiDetails.put("API_URL", apiURL);
                        apiDetails.put("API_PARAMETER", apiParamter);
                        result.put(transactionId, apiDetails);
                        BaseLogger.log((String)"3", null, null, (Object)("Inside getFailedDetailsFromFUAL API_URL [" + apiURL + "]"));
                        BaseLogger.log((String)"3", null, null, (Object)("Inside getFailedDetailsFromFUAL jsonData [" + apiParamter + "]"));
                        System.out.println();
                        continue;
                    }
                    System.out.println("File not found at path: " + followUpActionLogDataFilePath);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                connection.close();
                connection = null;
            }
            catch (Exception e) {
                BaseLogger.log((String)"0", (UserInfoBean)userInfo, null, (Object)("E12ExternalAPICall.callLoginApiAndSetSession() Exception = [" + E12GenericUtility.getStackTrace((Exception)e) + "]"));
                throw new ITMException(e);
            }
        }
        finally {
            if (connection != null) {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (connection != null) {
                    connection.close();
                    connection = null;
                }
            }
        }
        return result;
    }

    private static String readFileContents(String filePath) {
        StringBuilder content = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content.toString();
    }

    private static boolean fileExists(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        return Files.exists(path, new LinkOption[0]);
    }

    public String recallAPI(String apiName, int maxRetryCount, long durationInMinutes, E12ExternalAPICall e12ExternalAPICall, HashMap<String, HashMap<String, String>> failedAPIDetails, String refSer, UserInfoBean userInfo, String apiLogTranID) {
        String result = "";
        int retryCount = 0;
        long startTime = System.currentTimeMillis();
        HashMap<String, HashMap<String, String>> outerKeysMap = ScheduledAPICall.getOuterKeys(failedAPIDetails);
        block2: for (Map.Entry<String, HashMap<String, String>> entry : outerKeysMap.entrySet()) {
            String refId = entry.getKey();
            HashMap<String, String> innerMap = entry.getValue();
            System.out.println("Outer Key (refId) : " + refId);
            System.out.println("Inner Map (jsonData) : " + innerMap);
            String apiURL = innerMap.get("API_URL");
            String apiParameter = innerMap.get("API_PARAMETER");
            E12GenericUtility e12genericUtility = new E12GenericUtility();
            int detailCount = e12genericUtility.jsonDetailCount(apiParameter);
            apiParameter = e12genericUtility.jsonFormatter(apiParameter, detailCount);
            JSONObject jsonData = null;
            try {
                jsonData = new JSONObject(apiParameter);
                BaseLogger.log((String)"3", null, null, (Object)("Inside recallAPI JSONData [" + jsonData + "]"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            while (retryCount < maxRetryCount && ScheduledAPICall.isWithinDuration(startTime, durationInMinutes)) {
                boolean success = ScheduledAPICall.callAPI(e12ExternalAPICall, apiName, apiURL, refId, refSer, jsonData, userInfo, apiLogTranID);
                if (success) continue block2;
                ++retryCount;
                ScheduledAPICall.waitBeforeNextAttempt();
            }
        }
        return result;
    }

    private static boolean isWithinDuration(long startTime, long durationInMinutes) {
        long durationInMillis;
        long currentTime = System.currentTimeMillis();
        return currentTime - startTime <= (durationInMillis = TimeUnit.MINUTES.toMillis(durationInMinutes));
    }

    private static void waitBeforeNextAttempt() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static boolean callAPI(E12ExternalAPICall e12ExternalAPICall, String apiName, String apiURL, String refId, String refSer, JSONObject JSONData, UserInfoBean userInfo, String apiLogTranID) {
        try {
            String respStr = e12ExternalAPICall.apiCallToPostData(apiName, apiURL, "A", "E", refId, refSer, null, JSONData, userInfo, apiLogTranID);
            BaseLogger.log((String)"3", null, null, (Object)("Inside callAPI respStr [" + respStr + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static HashMap<String, HashMap<String, String>> getOuterKeys(HashMap<String, HashMap<String, String>> outerMap) {
        HashMap<String, HashMap<String, String>> outerKeysMap = new HashMap<String, HashMap<String, String>>();
        Set<String> outerKeys = outerMap.keySet();
        for (String outerKey : outerKeys) {
            HashMap<String, String> innerMap = outerMap.get(outerKey);
            outerKeysMap.put(outerKey, innerMap);
        }
        return outerKeysMap;
    }
}

