/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.planner.utility.ITMException;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.servlet.ITMAuthenticateServlet;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CollabDocMappingServlet
extends ITMAuthenticateServlet {
    private static final long serialVersionUID = -6945284385575283482L;
    private String classname = ((Object)((Object)this)).getClass().getSimpleName();

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    @Override
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String[] split;
            this.authenticate(request);
            this.logMessage("XXXXXX " + this.classname + " XXXXXX Starts");
            String objName = request.getParameter("OBJ_NAME");
            this.logMessage("OBJ_NAME: " + objName);
            String commaSeparatedRefIds = request.getParameter("REF_ID");
            this.logMessage("REF_ID: " + commaSeparatedRefIds);
            UserInfoBean userInfo = (UserInfoBean)request.getSession().getAttribute("USER_INFO");
            ArrayList<String> refIdList = new ArrayList<String>();
            String[] stringArray = split = commaSeparatedRefIds.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String refIdString = stringArray[n2];
                refIdList.add(refIdString);
                ++n2;
            }
            DocInfoList docInfoList = this.obtainDocInfo(objName, refIdList, userInfo.getTransDB());
            ImgInfoList imgInfoList = this.obtainImgInfo(refIdList);
            String xmlString = "<?xml version=\"1.0\" ?>";
            xmlString = String.valueOf(xmlString) + "<Root>\r\n";
            xmlString = String.valueOf(xmlString) + docInfoList.toString();
            xmlString = String.valueOf(xmlString) + imgInfoList.toString();
            xmlString = String.valueOf(xmlString) + "</Root>\r\n";
            BaseLogger.log("3", userInfo, null, "xmlString " + xmlString);
            response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            response.getWriter().write(xmlString);
            this.logMessage("Response:\n" + xmlString);
        }
        catch (BaseException e) {
            e.printStackTrace(System.err);
            response.getWriter().write(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            e.printStackTrace(response.getWriter());
        }
        this.logMessage("XXXXXX " + this.classname + " XXXXXX Ends");
    }

    protected ImgInfoList obtainImgInfo(List<String> refIdList) {
        BaseLogger.log("2", null, null, "**********  contextPath [" + CommonConstants.JBOSSHOME + "]");
        ImgInfoList imgInfoList = new ImgInfoList();
        try {
            for (String refValue : refIdList) {
                String imagePath = String.valueOf(CommonConstants.JBOSSHOME) + "/server/default/deploy/ibase.ear/ibase.war/dcdet/Brands/Logo/" + refValue + ".png";
                File imgFile = new File(imagePath);
                if (!imgFile.exists()) continue;
                ImgInfo imgInfo = new ImgInfo();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                BaseLogger.log("3", null, null, "After Format : " + sdf.format(imgFile.lastModified()));
                imgInfo.setImgName(imgFile.getName());
                imgInfo.setImgDate(sdf.format(imgFile.lastModified()));
                imgInfoList.add(imgInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return imgInfoList;
    }

    protected DocInfoList obtainDocInfo(String objName, List<String> refIdList, String transDB) throws Exception {
        DocInfoList docInfoList = new DocInfoList();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String query = "SELECT DOC_ID, DOC_TYPE, CHG_DATE FROM DOC_CONTENTS WHERE DOC_ID IN (SELECT ATTACHMENTS FROM COLLAB_POSTS WHERE (IS_APPROVED IS NULL OR IS_APPROVED = 'A') AND GROUP_ID__COLLAB IN (SELECT GROUP_ID FROM COLLAB_TAGS WHERE WIN_NAME = 'w_" + objName + "' AND TRIM( REF_NO ) IN ( " + this.toCSV(refIdList) + ") " + ")" + ")";
            ConnDriver driver = new ConnDriver();
            connection = driver.getConnectDB(transDB);
            statement = connection.prepareStatement(query);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                DocInfo docInfo = new DocInfo();
                docInfo.setDocId(resultSet.getString("DOC_ID"));
                docInfo.setDocType(resultSet.getString("DOC_TYPE"));
                docInfo.setChgDate(resultSet.getString("CHG_DATE"));
                docInfoList.add(docInfo);
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace(System.err);
                throw new ITMException(e);
            }
        }
        return docInfoList;
    }

    protected <T> String toCSV(List<T> list) {
        StringBuilder s = new StringBuilder();
        for (T listItem : list) {
            s.append("'" + listItem.toString() + "', ");
        }
        return s.toString().substring(0, s.length() - 2);
    }

    protected void logMessage(String string) {
        BaseLogger.log("2", null, null, "[" + this.classname + "] " + string);
    }

    protected static class DocInfo {
        protected String docId;
        protected String docType;
        protected String chgDate;

        protected DocInfo() {
        }

        public void setDocId(String docId) {
            this.docId = docId;
        }

        public String getDocId() {
            return this.docId;
        }

        public void setDocType(String docType) {
            this.docType = docType;
        }

        public String getDocType() {
            return this.docType;
        }

        public String getChgDate() {
            return this.chgDate;
        }

        public void setChgDate(String chgDate) {
            this.chgDate = chgDate;
        }

        public String toString() {
            return "<DOC_INFO><DOC_ID>" + this.docId + "</DOC_ID>" + "<DOC_TYPE>" + this.docType + "</DOC_TYPE>" + "<CHG_DATE>" + this.chgDate + "</CHG_DATE>" + "</DOC_INFO>";
        }
    }

    protected static class DocInfoList
    extends ArrayList<DocInfo> {
        private static final long serialVersionUID = -6842604292769532722L;

        protected DocInfoList() {
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("<DOC_INFO_LIST>");
            for (DocInfo docInfo : this) {
                s.append(docInfo.toString());
            }
            s.append("</DOC_INFO_LIST>\n");
            return s.toString();
        }
    }

    protected static class ImgInfo {
        protected String imgName;
        protected String imgDate;

        protected ImgInfo() {
        }

        public String getImgName() {
            return this.imgName;
        }

        public void setImgName(String imgName) {
            this.imgName = imgName;
        }

        public String getImgDate() {
            return this.imgDate;
        }

        public void setImgDate(String imgDate) {
            this.imgDate = imgDate;
        }

        public String toString() {
            return "<IMG_INFO><IMG_NAME>" + this.imgName + "</IMG_NAME>" + "<IMG_DATE>" + this.imgDate + "</IMG_DATE>" + "</IMG_INFO>";
        }
    }

    protected static class ImgInfoList
    extends ArrayList<ImgInfo> {
        private static final long serialVersionUID = -6842604292769532722L;

        protected ImgInfoList() {
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("<IMG_INFO_LIST>");
            for (ImgInfo imgInfo : this) {
                s.append(imgInfo.toString());
            }
            s.append("</IMG_INFO_LIST>\n");
            return s.toString();
        }
    }
}

