/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.sys;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AcknowledgementReader {
    public static void main(String[] args) {
        String filePath = "/home/amol.sonawane/Documents/Acknowledgement/ACK1PSRV3.PC000025217.Q2BPH0023.20240102093848001.XML";
        HashMap<String, String> dataMap = AcknowledgementReader.Acknowledgement2Reader(filePath);
        for (String endToEndId : dataMap.keySet()) {
            System.out.println("End to End ID: " + endToEndId);
            System.out.println(dataMap.get(endToEndId));
        }
    }

    public static HashMap<String, String> Acknowledgement2Reader(String filePath) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            File xmlFile = new File(filePath);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(xmlFile);
            doc.getDocumentElement().normalize();
            NodeList txInfAndStsList = doc.getElementsByTagName("TxInfAndSts");
            int i = 0;
            while (i < txInfAndStsList.getLength()) {
                Node txInfAndStsNode = txInfAndStsList.item(i);
                if (txInfAndStsNode.getNodeType() == 1) {
                    Element txInfAndStsElement = (Element)txInfAndStsNode;
                    String endToEndId = txInfAndStsElement.getElementsByTagName("OrgnlEndToEndId").item(0).getTextContent();
                    String status = txInfAndStsElement.getElementsByTagName("TxSts").item(0).getTextContent();
                    StringBuilder valueBuilder = new StringBuilder();
                    valueBuilder.append("Status: ").append(status).append("\n");
                    NodeList rsnInfList = txInfAndStsElement.getElementsByTagName("StsRsnInf");
                    int j = 0;
                    while (j < rsnInfList.getLength()) {
                        Node rsnInfNode = rsnInfList.item(j);
                        if (rsnInfNode.getNodeType() == 1) {
                            Element rsnInfElement = (Element)rsnInfNode;
                            String rsnCd = rsnInfElement.getElementsByTagName("Cd").item(0).getTextContent();
                            NodeList addtlInfList = rsnInfElement.getElementsByTagName("AddtlInf");
                            valueBuilder.append("\nStatus Information ").append(j + 1).append("\n");
                            valueBuilder.append("Reason Code: ").append(rsnCd).append("\n");
                            valueBuilder.append("Additional Information: ");
                            int k = 0;
                            while (k < addtlInfList.getLength()) {
                                valueBuilder.append(addtlInfList.item(k).getTextContent()).append(" ");
                                ++k;
                            }
                            valueBuilder.append("\n");
                        }
                        ++j;
                    }
                    valueBuilder.append("--");
                    dataMap.put(endToEndId, valueBuilder.toString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataMap;
    }

    public static String getErrorStrFromRetString(String returnXML) {
        StringBuilder errorStr = new StringBuilder();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(returnXML.getBytes()));
            NodeList errorList = document.getElementsByTagName("error");
            int i = 0;
            while (i < errorList.getLength()) {
                Node errorNode = errorList.item(i);
                if (errorNode.getNodeType() == 1) {
                    Element errorElement = (Element)errorNode;
                    String message = errorElement.getElementsByTagName("message").item(0).getTextContent();
                    String description = errorElement.getElementsByTagName("description").item(0).getTextContent();
                    errorStr.append("Message: ").append(message).append("\n");
                    errorStr.append("Description: ").append(description).append("\n");
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errorStr.toString();
    }
}

