/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility.wiz;

import ibase.utility.BaseLogger;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wiz.Column;
import ibase.webitm.utility.wiz.DataComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class TransactionHeaderModel
implements Serializable {
    HashMap colNameObjMap = null;
    ArrayList dataList = null;
    private HashMap objDetailMap = null;

    public TransactionHeaderModel() throws ITMException {
        try {
            this.colNameObjMap = new HashMap();
            this.dataList = new ArrayList();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionHeaderModel :constructor :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    protected boolean addColumn(String colName, Column colObj) throws ITMException {
        boolean colCreated = false;
        try {
            if (!this.colNameObjMap.containsKey(colName)) {
                this.colNameObjMap.put(colName, colObj);
                colCreated = true;
            }
        }
        catch (Exception e) {
            colCreated = false;
            BaseLogger.log("0", null, null, "Exception :TransactionHeaderModel :addColumn :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return colCreated;
    }

    public ArrayList getBrowColumnList(boolean isSorted) throws ITMException {
        ArrayList<Column> browColList = null;
        try {
            if (this.colNameObjMap != null) {
                for (String logicalName : this.colNameObjMap.keySet()) {
                    Column colObj;
                    if (!this.colNameObjMap.get(logicalName).getClass().isInstance(new Column())) continue;
                    if (browColList == null) {
                        browColList = new ArrayList<Column>();
                    }
                    if ((colObj = (Column)this.colNameObjMap.get(logicalName)).getBrowPos() == -1) continue;
                    browColList.add(colObj);
                }
                if (browColList != null && isSorted) {
                    browColList = this.sortBrowColByPos(browColList);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionHeaderModel :getBrowColumnList :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return browColList;
    }

    private ArrayList sortBrowColByPos(ArrayList unSortedList) throws ITMException {
        ArrayList<Column> sortedList = new ArrayList<Column>(unSortedList);
        try {
            int ctr = 0;
            while (ctr < sortedList.size()) {
                Column colObj = (Column)sortedList.get(ctr);
                int ctr1 = ctr;
                while (ctr1 < sortedList.size()) {
                    Column colObj1 = (Column)sortedList.get(ctr1);
                    if (colObj1.getBrowPos() <= colObj.getBrowPos()) {
                        sortedList.set(ctr1, colObj);
                        sortedList.set(ctr, colObj1);
                        colObj = (Column)sortedList.get(ctr);
                        colObj1 = (Column)sortedList.get(ctr1);
                    }
                    ++ctr1;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionHeaderModel :sortBrowColByPos :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return sortedList;
    }

    public void setDataList(ArrayList dataList) throws ITMException {
        try {
            Collections.sort(dataList, new DataComparator("char", 0, 1));
            this.dataList = (ArrayList)dataList.clone();
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionHeaderModel :setDataList :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public ArrayList getDataList() {
        return this.dataList;
    }

    public void setObjDetailMapValue(String key, String value) throws ITMException {
        try {
            if (this.objDetailMap == null) {
                this.objDetailMap = new HashMap();
            }
            this.objDetailMap.put(key, value);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setObjDetailMapValue :==>" + e.getMessage());
            throw new ITMException(e);
        }
    }

    public String getObjDetailMapValue(String key) throws ITMException {
        try {
            if (this.objDetailMap != null && this.objDetailMap.containsKey(key)) {
                return this.objDetailMap.get(key).toString();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :TransactionMetaModel :setObjDetailMapValue :==>" + e.getMessage());
            throw new ITMException(e);
        }
        return null;
    }
}

