/*
 * Decompiled with CFR 0.152.
 */
package ibase.scheduler.bean;

import ibase.scheduler.bean.InvokeIBaseSchedules;
import ibase.scheduler.ejb.ScheduleInfoEJB;
import ibase.scheduler.ejb.SchedulerEJB;
import ibase.scheduler.ejb.SchedulerRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CallIBaseSchedules {
    public CallIBaseSchedules() {
        BaseLogger.log("1", null, null, "CallIBaseSchedules Constructor Called");
    }

    public void execSchedule() throws Exception {
        block12: {
            BaseLogger.log("2", null, null, "execSchedule() ");
            Object allschedArr = null;
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                AppConnectParm appConnect = new AppConnectParm();
                Properties p = appConnect.getProperty();
                InitialContext ctx = new InitialContext(p);
                ScheduleInfoEJB sEJB = new ScheduleInfoEJB();
                String schXMLString = sEJB.getSchedulersToBeFired();
                BaseLogger.log("3", null, null, "ScheduleInfoEJB:execSchedule():schXMLString" + schXMLString);
                Document allschInfo = genericUtility.parseString(schXMLString);
                if (allschInfo == null) break block12;
                NodeList rootNodeList = allschInfo.getElementsByTagName("SCHEDULES").item(0).getChildNodes();
                int schNodeListLen = rootNodeList.getLength();
                BaseLogger.log("3", null, null, "CallIBaseSchedules : :schNodeListLen [" + schNodeListLen + "]");
                int i = 0;
                while (i < schNodeListLen) {
                    block14: {
                        String schInterval;
                        String schId;
                        Node schNode;
                        block13: {
                            schNode = rootNodeList.item(i);
                            schId = schNode.getAttributes().getNamedItem("id").getNodeValue();
                            NodeList schChilds = schNode.getChildNodes();
                            int schNOdeLen = schChilds.getLength();
                            schInterval = "";
                            String schLastFired = "";
                            String schStartDate = "";
                            String runMode = "";
                            int nodeCtr = 0;
                            while (nodeCtr < schNOdeLen) {
                                Node currNode = schChilds.item(nodeCtr);
                                String nodeName = currNode.getNodeName();
                                BaseLogger.log("3", null, null, "nodeName [" + nodeName + "]");
                                if (currNode.getFirstChild() != null) {
                                    if ("INTERVAL".equalsIgnoreCase(nodeName)) {
                                        schInterval = currNode.getFirstChild().getNodeValue();
                                    } else if ("RUNMODE".equalsIgnoreCase(nodeName)) {
                                        runMode = currNode.getFirstChild().getNodeValue();
                                    }
                                }
                                ++nodeCtr;
                            }
                            if (!"S".equalsIgnoreCase(runMode) && !"null".equalsIgnoreCase(runMode) && runMode != null && runMode.trim().length() != 0) break block13;
                            boolean isThreadAlive = false;
                            for (Thread schThread : Thread.getAllStackTraces().keySet()) {
                                if (!schId.equals(schThread.getName()) || !schThread.isAlive()) continue;
                                BaseLogger.log("3", null, null, "Thread is already Running. so no action for sch [" + schId + "]");
                                isThreadAlive = true;
                                break;
                            }
                            if (isThreadAlive) break block14;
                        }
                        BaseLogger.log("3", null, null, "Invoke schId [" + schId + "] START");
                        try {
                            InvokeIBaseSchedules invokeIBaseSchedules = new InvokeIBaseSchedules(genericUtility.serializeDom(schNode), schInterval);
                            Thread invokeScheduleThread = new Thread((Runnable)invokeIBaseSchedules, schId);
                            invokeScheduleThread.start();
                            invokeScheduleThread = null;
                            invokeIBaseSchedules = null;
                        }
                        catch (Exception e) {
                            BaseLogger.log("0", null, null, "Exception occured in schId [" + schId + "] moving to next..");
                        }
                        BaseLogger.log("3", null, null, "Invoke schId [" + schId + "]END");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                BaseLogger.log("0", null, null, "Exception :CallIBaseSchedules :  :execSchedule :==>\n" + e);
                throw e;
            }
        }
    }

    private ArrayList getAllSchsTobeFiredList() throws Exception {
        BaseLogger.log("2", null, null, "Sachin in getSchID()");
        ArrayList<String> allschedArr = new ArrayList<String>();
        try {
            E12GenericUtility genericUtility = new E12GenericUtility();
            AppConnectParm appConnect = new AppConnectParm();
            Properties p = appConnect.getProperty();
            InitialContext ctx = new InitialContext(p);
            ScheduleInfoEJB sEJB = new ScheduleInfoEJB();
            String schXMLString = sEJB.getSchedulersToBeFired();
            Document allschInfo = genericUtility.parseString(schXMLString);
            if (allschInfo != null) {
                NodeList rootNodeList = allschInfo.getElementsByTagName("SCHEDULES").item(0).getChildNodes();
                int schNodeListLen = rootNodeList.getLength();
                BaseLogger.log("3", null, null, "CallIBaseSchedules : :schNodeListLen [" + schNodeListLen + "]");
                int i = 0;
                while (i < schNodeListLen) {
                    Node schNode = rootNodeList.item(i);
                    allschedArr.add(schNode.getAttributes().getNamedItem("id").getNodeValue());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseLogger.log("2", null, null, "All schedule ID----------[" + allschedArr + "]----------");
        return allschedArr;
    }

    private SchedulerRemote getSchedulerComp() throws BaseException {
        SchedulerEJB ejbObj = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            InitialContext ctx = new InitialContext(appConnect.getProperty());
            ejbObj = new SchedulerEJB();
        }
        catch (BaseException be) {
            throw be;
        }
        catch (Exception exp) {
            throw new BaseException(exp);
        }
        return ejbObj;
    }

    private synchronized void checkSchAvailability(String path) throws Exception {
        try {
            File schFile = new File(path);
            if (schFile.exists()) {
                BaseLogger.log("3", null, null, "SchedulerProperties.xml is exist........................." + schFile.length() + "..........");
                if (schFile.length() < 20L) {
                    boolean isCopy;
                    BaseLogger.log("3", null, null, "\n\n\n  \n\n\n\n");
                    BaseLogger.log("3", null, null, "#####################################################################################################################");
                    BaseLogger.log("3", null, null, "........$$$$$$$$$$$$$$$$$$$$$$$$..........SCHEDULER PROPERTIES.XML FILE IS CORRUPTED........$$$$$$$$$$$$$$$$$$$$$... ");
                    BaseLogger.log("3", null, null, "#####################################################################################################################");
                    BaseLogger.log("3", null, null, "\n\n\n  \n\n\n\n");
                    BaseLogger.log("3", null, null, "SchedulerProperties.xml length is less than ZERO....................");
                    String backupPath = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "setting" + File.separator + "SchedulePropertiesBackup.xml";
                    File backupFile = new File(backupPath);
                    if (backupFile.exists() && (isCopy = this.copySchFile(backupPath, path))) {
                        BaseLogger.log("3", null, null, "Coping the SchedulerPropertiesBackup.xml into SchedulerProperties.xml.............");
                    }
                } else {
                    BaseLogger.log("3", null, null, "SchedulerProperties.xml is Present....................");
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            BaseLogger.log("0", null, null, "CallIBaseSchedules :  [checkSchAvailability] FileNotFoundException Exception::::::::");
            fnfe.printStackTrace();
        }
        catch (IllegalArgumentException iae) {
            BaseLogger.log("0", null, null, "CallIBaseSchedules :  [checkSchAvailability] IllegalArgumentException Exception::::::::");
            iae.printStackTrace();
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized boolean copySchFile(String srcFile, String destFile) throws Exception {
        try {
            RandomAccessFile schOriginal = new RandomAccessFile(srcFile, "r");
            RandomAccessFile schBackup = new RandomAccessFile(destFile, "rw");
            StringBuffer strBuff = new StringBuffer();
            String data = schOriginal.readLine();
            while (data != null) {
                strBuff.append(data);
                data = schOriginal.readLine();
            }
            if (strBuff.toString() != null) {
                schBackup.writeBytes(strBuff.toString());
            }
            schOriginal.close();
            schBackup.close();
            return true;
        }
        catch (FileNotFoundException fnfe) {
            BaseLogger.log("0", null, null, "SchedulerEJB [takeBackup] Method Exception::::::::");
            fnfe.printStackTrace();
            return false;
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
            return false;
        }
        catch (SecurityException se) {
            se.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String getDate(String strDate) throws BaseException, Exception {
        String strDateformat = "";
        try {
            String strMonth;
            StringTokenizer tokens = new StringTokenizer(strDate, "-");
            String strDay = tokens.nextToken();
            if (strDay.trim().length() == 1) {
                strDay = "0" + strDay;
            }
            if ((strMonth = tokens.nextToken()).trim().length() == 1) {
                strDay = "0" + strDay;
            }
            String strYear = tokens.nextToken();
            int day = Integer.parseInt(strDay.trim());
            int month = Integer.parseInt(strMonth.trim());
            int year = Integer.parseInt(strYear.trim());
            strDateformat = month < 10 && day < 10 ? String.valueOf(year) + "-0" + month + "-0" + day : (month < 10 && day > 10 ? String.valueOf(year) + "-0" + month + "-" + day : (month > 10 && day < 10 ? String.valueOf(year) + "-" + month + "-0" + day : String.valueOf(year) + "-" + month + "-" + day));
            BaseLogger.log("3", null, null, "DATE FORMATE[" + strDateformat + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strDateformat;
    }
}

