/********************************************************
	Title : StrgCustDeactivePrc
	Date  : 29/JUN/12
	Developer:Rakesh kumar
 ********************************************************/
package ibase.webitm.ejb.wsfa.transactions;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ProcessEJB;
//import ibase.webitm.utility.GenericUtility;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless		commented by Sagar M [22 Nov 2018].
public class StrgCustDeactivePrc extends ProcessEJB implements StrgCustDeactivePrcLocal,StrgCustDeactivePrcRemote
{
	//changed by Rahul Barve on 3-sep-2014
	//GenericUtility genericUtility = GenericUtility.getInstance();
	 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr ="";
		Document headerDom = null;
		Document detailDom = null;
		try
		{
			System.out.println("xmlString :::"+xmlString);
			System.out.println("xmlString2 :::"+xmlString2);
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{
			rtrStr = e.getMessage();
			throw new ITMException(e);
		}
		return rtrStr;
	}
	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		String resultString = "";
		String salesPers = "";
		String objName = "";
		String custType = "";
		String sql= null ;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n");
		try
		{

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			connDriver = null;
			conn.setAutoCommit(false);
			salesPers = genericUtility.getColumnValue("sales_pers",headerDom);
			//objName = checkNullAndTrim(getObjNameFromDom(headerDom, "objName", "1" ));

			System.out.println("window Name =["+windowName+"] and obj Name =["+objName+"]");
			if("w_doctor_deact".equalsIgnoreCase(windowName))
			{
				custType = "D";
			}
			else if("w_chemist_deact".equalsIgnoreCase(windowName))
			{
				custType = "C";
			}
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDate = sdf.format(new java.util.Date());

			sql = "select strg_series.sc_code, strg_series.short_id, strg_series.sales_pers, "+
					"(upper (strg_customer.first_name )|| '  ' || upper(strg_customer.middle_name) || '  ' || upper(strg_customer.last_name) )as customer_name, "+
					"strg_series.no_visit, strg_series.class_code_descr, speciality.descr as speciality_descr, strg_cust_subclass.subclass_descr, "+
					"locality.descr as locality_descr, strg_series.business_to_us, strg_series.total_business,  strg_series.no_patient_day, "+
					"strg_series.route_id, strg_series.item_ser, itemser.descr as itemser_descr , strg_series.status, strg_customer.practicing_since, "+
					"strg_customer.visit_time_fr,strg_customer.visit_time_to, strg_customer.locality_code " +
					"from  strg_series strg_series, sales_pers sales_pers, speciality speciality,itemser itemser, "+
					"strg_customer  strg_customer,locality  locality, strg_cust_subclass  strg_cust_subclass "+
					"where  ( strg_series.item_ser      = itemser.item_ser   ) "+
					"and ( strg_customer.locality_code      = locality.locality_code ) "+
					"and ( strg_series.sales_pers=sales_pers.sales_pers(+)) "+
					"and ( strg_series.spl_code=speciality.spl_code(+)) "+
					"and ( strg_customer.sc_code=strg_series.sc_code(+)) "+
					"and ( strg_series.subclass_code=strg_cust_subclass.subclass_code(+)) "+
					"and strg_series.status='Y' "+
					"and strg_series.item_ser <> 'OTC' and strg_customer.status='Y'" +
					"and strg_series.sales_pers = ? "+
					"and strg_series.cust_type = ? " +
					"and (strg_series.sales_pers, strg_series.sc_code) not in(select sales_pers,sc_code from drchem_deact_status ) "+
					"order by customer_name, strg_series.short_id ";



			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,salesPers);
			pstmt.setString(2,custType);
			rs = pstmt.executeQuery();
			int count = 1;
			while(rs.next())
			{
				valueXmlString.append("<Detail2 domID='"+count+"' >\r\n");
				valueXmlString.append("<sc_code><![CDATA[").append(checkNullAndTrim(rs.getString("SC_CODE"))).append("]]></sc_code>\r\n");
				valueXmlString.append("<short_id><![CDATA[").append(rs.getInt("short_id")).append("]]></short_id>\r\n");
				valueXmlString.append("<customer_name><![CDATA[").append(checkNullAndTrim(rs.getString("customer_name"))).append("]]></customer_name>\r\n");
				valueXmlString.append("<no_visit><![CDATA[").append(checkNullAndTrim(rs.getString("no_visit"))).append("]]></no_visit>\r\n");
				valueXmlString.append("<class_code_descr><![CDATA[").append(checkNullAndTrim(rs.getString("class_code_descr"))).append("]]></class_code_descr>\r\n");
				valueXmlString.append("<subclass_descr><![CDATA[").append(checkNullAndTrim(rs.getString("subclass_descr"))).append("]]></subclass_descr>\r\n");
				valueXmlString.append("<speciality_descr><![CDATA[").append(checkNullAndTrim(rs.getString("speciality_descr"))).append("]]></speciality_descr>\r\n");
				valueXmlString.append("<locality_descr><![CDATA[").append(checkNullAndTrim(rs.getString("locality_descr"))).append("]]></locality_descr>\r\n");
				valueXmlString.append("<business_to_us><![CDATA[").append(rs.getDouble("business_to_us")).append("]]></business_to_us>\r\n");
				valueXmlString.append("<total_business><![CDATA[").append(rs.getDouble("total_business")).append("]]></total_business>\r\n");
				valueXmlString.append("<no_patient_day><![CDATA[").append(checkNullAndTrim(rs.getString("no_patient_day"))).append("]]></no_patient_day>\r\n");
				valueXmlString.append("<route_id><![CDATA[").append(rs.getString("route_id")).append("]]></route_id>\r\n");
				valueXmlString.append("<item_ser><![CDATA[").append(checkNullAndTrim(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
				valueXmlString.append("<itemser_descr><![CDATA[").append(checkNullAndTrim(rs.getString("itemser_descr"))).append("]]></itemser_descr>\r\n");
				valueXmlString.append("<status><![CDATA[").append(checkNullAndTrim(rs.getString("status"))).append("]]></status>\r\n");
				valueXmlString.append("<practicing_since><![CDATA[").append(checkNullAndTrim(rs.getString("practicing_since"))).append("]]></practicing_since>\r\n");
				valueXmlString.append("<visit_time_fr><![CDATA[").append(checkNullAndTrim(rs.getString("visit_time_fr"))).append("]]></visit_time_fr>\r\n");
				valueXmlString.append("<visit_time_to><![CDATA[").append(checkNullAndTrim(rs.getString("visit_time_to"))).append("]]></visit_time_to>\r\n");
				valueXmlString.append("<locality_code><![CDATA[").append(checkNullAndTrim(rs.getString("locality_code"))).append("]]></locality_code>\r\n");
				valueXmlString.append("<sales_pers><![CDATA[").append(checkNullAndTrim(rs.getString("sales_pers"))).append("]]></sales_pers>\r\n");
				valueXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
				valueXmlString.append("<tran_date><![CDATA[").append(currDate).append("]]></tran_date>\r\n");
				valueXmlString.append("<deact_date><![CDATA[").append(currDate).append("]]></deact_date>\r\n");
				valueXmlString.append("</Detail2>\r\n");
				count++;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println(e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom2 = null;
		String errString = "";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = process(dom,dom2,windowName,xtraParams);
		}
		catch(Exception e)
		{
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		return errString;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		ConnDriver connDriver = new ConnDriver();
		NodeList parentNodeList = null;
		Node parentNode = null;
		Document dom2 = null;
		String scCode="";
		String salesPers="";
		String deactDate="";
		String sql = "";
		PreparedStatement pstmt = null;
		Connection conn=null;
		SimpleDateFormat simpleDateFormat = null;
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			simpleDateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			deactDate = genericUtility.getColumnValue("deact_date", dom2);
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());
			java.util.Date sDate = simpleDateFormat.parse(deactDate);
			java.util.Date currDate =simpleDateFormat.parse(simpleDateFormat.format(timestamp).toString());
			parentNodeList = dom2.getElementsByTagName("Detail2");
			parentNode=parentNodeList.item(0);
			int parentNodeListLength = parentNodeList.getLength();
			for(int ctr = 0; ctr < parentNodeListLength; ctr++)
			{
				if(sDate.equals(currDate))
				{
					salesPers = genericUtility.getColumnValue("sales_pers",dom2);
					System.out.println("dom2 sales person is equal==============>"+salesPers);
					scCode= genericUtility.getColumnValue("sc_code",dom2);
					System.out.println("dom2 sc code is equal to===============>"+scCode);
					sql = "update strg_series set short_id='NULL' and status='Y' where sales_pers= ? and sc_code= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,salesPers);
					pstmt.setString(2,scCode);
					int i = pstmt.executeUpdate();
					if(i>0)
					{
						System.out.println("******Record updated sucessfully******");
					}
					pstmt.close();
					pstmt = null;
				}

			}
		}
		catch(Exception e)
		{
			System.out.println("Error ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "returnString";
	}
	private String getObjNameFromDom( Document dom, String attribute, String objContext ) throws RemoteException,ITMException
	{
		NodeList detailList = null;
		Node currDetail = null;
		String objName = "";
		int	detailListLength = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+objContext);
			detailListLength = detailList.getLength();
		    for (int ctr = 0; ctr < detailListLength; ctr++)
			{
				currDetail = detailList.item(ctr);
				objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
			}
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		return objName;
	}
	public String getSalesPersonList( String loginCode ) throws RemoteException,ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");

			sql = "SELECT A.SALES_PERS, A.SP_NAME FROM SALES_PERS A, EMPLOYEE B WHERE A.SALES_PERS = B. EMP_CODE AND B.REPORT_TO = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, loginCode );
			rs = pstmt.executeQuery();
			int num = 1;
			while (rs.next())
			{
				String salesPers = checkNullAndTrim(rs.getString("SALES_PERS"));
				String spName = checkNullAndTrim(rs.getString("SP_NAME"));

				valueXmlString.append("<SALESPERS domID='" + num	+ "' selected = 'N'>\r\n");

				valueXmlString.append("<SALES_PERS><![CDATA[").append(salesPers).append("]]></SALES_PERS>\r\n");
				valueXmlString.append("<SP_NAME><![CDATA[").append(spName).append("]]></SP_NAME>\r\n");
				valueXmlString.append("</SALESPERS>\r\n");
				num++;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String):"	+ e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception :ITMWizardStatefulEJB :getSalesPersTeamList(String) :==>\n"+ e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()	+ ":********");
		return valueXmlString.toString();
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	private String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}

