/*
 * Decompiled with CFR 0.152.
 */
package ibase.ejb;

import ibase.ejb.UserEventLogEJBLocal;
import ibase.ejb.UserEventLogEJBRemote;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.DBAccessLocal;
import ibase.webitm.utility.ITMException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.ejb.Stateless;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class UserEventLogEJB
implements UserEventLogEJBLocal,
UserEventLogEJBRemote {
    public static LinkedHashMap eventActivityMap = new LinkedHashMap();
    public static LinkedHashMap<String, String> eventActionMap = new LinkedHashMap();
    private static HashMap<String, String> objNameDescrMap = new HashMap();
    public static HashMap<String, String> objIconPathMap = new HashMap();
    private static HashMap<String, String> eventDescrMap = new HashMap();
    private DBAccessLocal dbAccess = null;
    private String currentEditorId = "";

    @Override
    public void setEventLog(String userCode, String objName, String sessionId, String editorId, String action, String event, Date startTime, Date endTime, String argsParam, String tranId, String eventResult, String actionType, String exception) {
        try {
            LinkedList<LinkedHashMap<String, String>> editorActivityList;
            String formNoStr;
            E12GenericUtility genericUtility;
            LinkedHashMap objectActivityMap;
            LinkedHashMap userEventLogMap;
            if ("3".equalsIgnoreCase(CommonConstants.USER_LOG)) {
                return;
            }
            BaseLogger.log("3", null, null, "<<<<<<< inside UserEventLogEJB ---->setEventLog >>>>>>>>>>>>tranId[" + tranId + "] action[" + action + "] objName[" + objName + "] event[" + event + "]");
            if (this.checkNull(userCode).trim().length() == 0 || this.checkNull(objName).trim().length() == 0 || this.checkNull(sessionId).trim().length() == 0 || this.checkNull(action).trim().length() == 0 || this.checkNull(event).trim().length() == 0) {
                return;
            }
            if ((editorId = this.checkNull(editorId)).length() <= 0) {
                this.currentEditorId = editorId = "" + new Date().getTime();
            }
            if ("Confirm".equalsIgnoreCase(this.checkNull(action))) {
                action = "Confirm";
            }
            if ((tranId = this.checkNull(tranId)).length() == 0 && "EDIT".equalsIgnoreCase(action)) {
                action = "ADD";
            }
            if (tranId == "" || "null".equalsIgnoreCase(tranId)) {
                tranId = "NA";
            }
            if ((userEventLogMap = (LinkedHashMap)eventActivityMap.get(userCode)) == null) {
                userEventLogMap = new LinkedHashMap();
            }
            if ((objectActivityMap = (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName)) == null) {
                objectActivityMap = new LinkedHashMap();
            }
            formNoStr = (genericUtility = new E12GenericUtility()).isNumeric(formNoStr = this.getFormNum(argsParam)) ? formNoStr : "";
            int formNo = formNoStr.length() == 0 ? 0 : Integer.parseInt(formNoStr);
            String objectActivityMapKey = "";
            if (formNo > 1) {
                Set keySet = objectActivityMap.keySet();
                for (String key : keySet) {
                    if (!key.contains(editorId)) continue;
                    objectActivityMapKey = key;
                    break;
                }
            }
            if (objectActivityMapKey.trim().length() == 0) {
                objectActivityMapKey = String.valueOf(editorId) + "_" + action;
            }
            if ((editorActivityList = (LinkedList<LinkedHashMap<String, String>>)objectActivityMap.get(objectActivityMapKey)) == null) {
                editorActivityList = new LinkedList<LinkedHashMap<String, String>>();
            }
            exception = this.checkNull(exception);
            LinkedHashMap<String, String> eventDetailMap = this.getEventDetailMap(event, startTime, endTime, argsParam, tranId, eventResult, actionType, exception);
            editorActivityList.add(eventDetailMap);
            eventDetailMap.put("EVENT_ID", "" + editorActivityList.size());
            this.addServerSentEventData(userCode, sessionId, objName, editorId, action, objectActivityMapKey, eventDetailMap);
            objectActivityMap.put(objectActivityMapKey, editorActivityList);
            userEventLogMap.put(String.valueOf(sessionId) + "~SEP~" + objName, objectActivityMap);
            eventActivityMap.put(userCode, userEventLogMap);
            if (!eventActionMap.containsKey(String.valueOf(editorId) + "_" + action)) {
                eventActionMap.put(String.valueOf(editorId) + "_" + action, action);
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                StringBuffer callerName = new StringBuffer();
                int i = 0;
                while (i < stackTraceElements.length) {
                    String methodName = "" + stackTraceElements[i];
                    if (methodName.contains("ibase")) {
                        callerName.append(methodName).append("~~");
                    }
                    methodName = null;
                    ++i;
                }
                eventActionMap.put(String.valueOf(editorId) + "_" + action + "_callerName", callerName.toString());
                callerName = null;
            }
            BaseLogger.log("3", null, null, "<<<<<<<<< ended UserEventLogEJB--> setEventLog >>>>>>>>>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in UserEventLogEJB->setEventLog()..........." + e.getMessage());
            E12GenericUtility genericUtility = new E12GenericUtility();
            BaseLogger.log("0", null, null, "Exception in UserEventLogEJB->setEventLog()..........." + genericUtility.writePrintStacktrace(e));
            e.printStackTrace();
        }
    }

    @Override
    public LinkedHashMap getUserEventLogInfo(String userCode) {
        return (LinkedHashMap)eventActivityMap.get(userCode);
    }

    @Override
    public LinkedHashMap<String, String> getEventDetailMap(String eventCode, Date startTime, Date endTime, String argsParam, String tranId, String eventResult, String actionType, String exception) throws ITMException, Exception {
        LinkedHashMap<String, String> eventDetailMap = new LinkedHashMap<String, String>();
        E12GenericUtility genericUtility = new E12GenericUtility();
        if (startTime == null) {
            startTime = new Date();
        }
        eventDetailMap.put("EVENT", eventCode);
        eventDetailMap.put("ARG_PARAM", argsParam);
        eventDetailMap.put("ACCESS_TIME", this.getValidDateTimeString(startTime, genericUtility.getApplDateTimeFormat()));
        if (endTime == null) {
            eventDetailMap.put("COMPL_TIME", "");
        } else {
            eventDetailMap.put("COMPL_TIME", this.getValidDateTimeString(endTime, genericUtility.getApplDateTimeFormat()));
        }
        eventDetailMap.put("TRAN_ID", tranId);
        eventDetailMap.put("EXCEPTION_MSG", exception);
        eventDetailMap.put("EVENT_RESULT", eventResult);
        eventDetailMap.put("ACTION_TYPE", actionType);
        return eventDetailMap;
    }

    @Override
    public String getEventDescr(String event, String transDB) throws ITMException {
        String descr = "";
        try {
            if (event != null && event.trim().length() > 0) {
                if (eventDescrMap != null && eventDescrMap.containsKey(event)) {
                    descr = eventDescrMap.get(event);
                } else {
                    this.dbAccess = new DBAccessEJB();
                    String condition = " EVENT_CODE = '" + event.trim() + "' ";
                    if (transDB != null && transDB.trim().length() > 0) {
                        descr = this.dbAccess.getDBColumnValue("EVENTS", "DESCR", condition, transDB);
                    }
                    if (descr.trim().length() == 0) {
                        descr = event;
                    }
                    eventDescrMap.put(event, descr);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getEventDescr[" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return descr;
    }

    public String getObjNameDescr(String objName, String transDB, String userCode) {
        String descr = "";
        try {
            if (objName != null && objName.trim().length() > 0) {
                if (objNameDescrMap != null && objNameDescrMap.containsKey(objName)) {
                    descr = objNameDescrMap.get(objName);
                } else {
                    this.dbAccess = new DBAccessEJB();
                    String condition = " WIN_NAME = 'w_" + objName + "' ";
                    if (transDB == null || transDB.trim().length() == 0) {
                        transDB = this.dbAccess.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + userCode + "'");
                    }
                    descr = this.dbAccess.getDBColumnValue("ITM2MENU", "DESCR", condition, transDB);
                    this.dbAccess = null;
                    objNameDescrMap.put(objName, descr);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getObjNameDescr[" + e.getMessage() + "]");
            e.printStackTrace();
        }
        return descr;
    }

    public String getobjIconPath(String objName, String transDB, String userCode) throws ITMException {
        String iconPath = "";
        try {
            if (objName != null && objName.trim().length() > 0) {
                if (objIconPathMap != null && objIconPathMap.containsKey(objName)) {
                    iconPath = objIconPathMap.get(objName);
                } else {
                    this.dbAccess = new DBAccessEJB();
                    String condition = " WIN_NAME = 'w_" + objName + "' ";
                    if (transDB == null || transDB.trim().length() == 0) {
                        transDB = this.dbAccess.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + userCode + "'");
                    }
                    iconPath = this.dbAccess.getDBColumnValue("ITM2MENU", "ICON_PATH", condition, transDB);
                    objIconPathMap.put(objName, iconPath);
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in getObjNameDescr[" + e.getMessage() + "]");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return iconPath;
    }

    private String checkNull(String str) {
        if (str == null) {
            str = "";
        }
        return str;
    }

    private String getValidDateTimeString(Date dateTime, String targetDateTimeFormat) throws ITMException {
        String retDateStr = "";
        SimpleDateFormat formatter = null;
        try {
            try {
                formatter = new SimpleDateFormat(targetDateTimeFormat);
                String strDate = formatter.format(dateTime);
                String nanoSecs = "" + dateTime.getTime();
                nanoSecs = nanoSecs.substring(nanoSecs.length() - 3, nanoSecs.length());
                retDateStr = String.valueOf(strDate) + "." + nanoSecs;
            }
            catch (Exception e) {
                BaseLogger.log("0", null, null, "Exception :UserEventLogEJB :getValidDateTimeString :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            formatter = null;
        }
        return retDateStr;
    }

    private String getFormNum(String argParam) {
        String formNum = "";
        String[] eventForm = null;
        if (argParam.contains("EventContext:")) {
            eventForm = argParam.split("EventContext:");
            if (!eventForm[1].substring(1, 2).equalsIgnoreCase("n")) {
                formNum = eventForm[1].substring(1, 2);
            }
        } else if (argParam.contains("objContext:")) {
            eventForm = argParam.split("objContext:");
            if (!eventForm[1].substring(1, 2).equalsIgnoreCase("n")) {
                formNum = eventForm[1].substring(1, 2);
            }
        } else if (argParam.contains("pageContext:")) {
            eventForm = argParam.split("pageContext:");
            if (!eventForm[1].substring(1, 2).equalsIgnoreCase("n")) {
                formNum = eventForm[1].substring(1, 2);
            }
        } else if (argParam.contains("domId:") && !(eventForm = argParam.split("domId:"))[1].substring(1, 2).equalsIgnoreCase("n")) {
            formNum = eventForm[1].substring(1, 2);
        }
        return formNum;
    }

    public void updateEventLog(String userCode, String objName, String sessionId, String editorId, String action, String event, Date startTime, Date endTime, String argsParam, String tranId, String eventResult, String actionType, String exception) {
        E12GenericUtility genericUtility = new E12GenericUtility();
        try {
            LinkedList editorActivityList;
            String formNoStr;
            LinkedHashMap objectActivityMap;
            LinkedHashMap userEventLogMap;
            if ("3".equalsIgnoreCase(CommonConstants.USER_LOG)) {
                return;
            }
            BaseLogger.log("3", null, null, "<<<<<<< inside UserEventLogEJB ---->updateEventLog >>>>>>>>>>>>tranId[" + tranId + "] action[" + action + "] objName[" + objName + "] event[" + event + "]");
            if (this.checkNull(userCode).trim().length() == 0 || this.checkNull(objName).trim().length() == 0 || this.checkNull(sessionId).trim().length() == 0 || this.checkNull(action).trim().length() == 0 || this.checkNull(event).trim().length() == 0) {
                return;
            }
            exception = this.checkNull(exception);
            StringBuffer newMsg = new StringBuffer();
            if (exception.contains("Errors") && exception.contains("error")) {
                Document dom = genericUtility.parseString(exception);
                NodeList nodeList = dom.getElementsByTagName("Errors");
                int i = 0;
                while (i < nodeList.getLength()) {
                    Node currNode = nodeList.item(i);
                    NodeList childNodeList = currNode.getChildNodes();
                    int j = 0;
                    while (j < childNodeList.getLength()) {
                        Node currChidNode = childNodeList.item(j);
                        NodeList currChidNodeList = currChidNode.getChildNodes();
                        int k = 0;
                        while (k < currChidNodeList.getLength()) {
                            Node detailNode = currChidNodeList.item(k);
                            if (detailNode != null && detailNode.getNodeType() == 1) {
                                if (detailNode.getFirstChild() != null && detailNode.getFirstChild().getNodeValue() != null && detailNode.getNodeName().equals("message")) {
                                    newMsg.append("ERROR_MESSAGE=");
                                    newMsg.append(detailNode.getFirstChild().getNodeValue());
                                    newMsg.append("\n");
                                }
                                if (detailNode.getFirstChild() != null && detailNode.getFirstChild().getNodeValue() != null && detailNode.getNodeName().equals("description")) {
                                    newMsg.append("ERROR_DESCRIPTION=");
                                    newMsg.append(detailNode.getFirstChild().getNodeValue());
                                    newMsg.append("\n");
                                }
                                if (detailNode.getFirstChild() != null && detailNode.getFirstChild().getNodeValue() != null && detailNode.getNodeName().equals("trace")) {
                                    String trace = detailNode.getFirstChild().getNodeValue();
                                    if (!"".equals(trace) && trace.length() > 1000) {
                                        trace = trace.substring(0, 1000);
                                    }
                                    newMsg.append("ERROR_TRACE=");
                                    newMsg.append(trace);
                                    newMsg.append("\n");
                                }
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                exception = "<![CDATA[" + newMsg.toString() + "]]>";
            } else if (!"".equals(exception) && exception.length() > 1000) {
                exception = exception.substring(0, 1000);
            }
            editorId = this.checkNull(editorId);
            if (editorId.length() <= 0) {
                editorId = this.currentEditorId;
            }
            if ("Confirm".equalsIgnoreCase(this.checkNull(action))) {
                action = "Confirm";
            }
            if (((tranId = this.checkNull(tranId)).equalsIgnoreCase("NA") || tranId.length() == 0) && "EDIT".equalsIgnoreCase(action)) {
                action = "ADD";
            }
            if (tranId == "" || "null".equalsIgnoreCase(tranId)) {
                tranId = "NA";
            }
            if ((userEventLogMap = (LinkedHashMap)eventActivityMap.get(userCode)) == null) {
                userEventLogMap = new LinkedHashMap();
            }
            if ((objectActivityMap = (LinkedHashMap)userEventLogMap.get(String.valueOf(sessionId) + "~SEP~" + objName)) == null) {
                objectActivityMap = new LinkedHashMap();
            }
            formNoStr = genericUtility.isNumeric(formNoStr = this.getFormNum(argsParam)) ? formNoStr : "";
            int formNo = formNoStr.length() == 0 ? 0 : Integer.parseInt(formNoStr);
            String objectActivityMapKey = "";
            if (formNo > 1) {
                Set keySet = objectActivityMap.keySet();
                for (String key : keySet) {
                    if (!key.contains(editorId)) continue;
                    objectActivityMapKey = key;
                    break;
                }
            }
            if (objectActivityMapKey.trim().length() == 0) {
                objectActivityMapKey = String.valueOf(editorId) + "_" + action;
            }
            if ((editorActivityList = (LinkedList)objectActivityMap.get(objectActivityMapKey)) == null) {
                editorActivityList = new LinkedList();
            }
            int i = 0;
            while (i < editorActivityList.size()) {
                LinkedHashMap eventDetailMap = new LinkedHashMap();
                eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                Set eventDetailMapKey = eventDetailMap.keySet();
                String sTime = this.getValidDateTimeString(startTime, genericUtility.getApplDateTimeFormat());
                if (eventDetailMap.containsValue(event) && eventDetailMap.containsValue(sTime)) {
                    for (String key : eventDetailMapKey) {
                        String value = (String)eventDetailMap.get(key);
                        if ("COMPL_TIME".equals(key) && "".equalsIgnoreCase(value)) {
                            if (endTime == null) {
                                endTime = new Date();
                            }
                            eventDetailMap.replace("COMPL_TIME", this.getValidDateTimeString(endTime, genericUtility.getApplDateTimeFormat()));
                            continue;
                        }
                        if ("EVENT_RESULT".equals(key) && (value.equalsIgnoreCase("Pending") || value.equalsIgnoreCase("Exception"))) {
                            eventDetailMap.replace("EVENT_RESULT", eventResult);
                            continue;
                        }
                        if ("EXCEPTION_MSG".equals(key) && !"".equalsIgnoreCase(exception)) {
                            eventDetailMap.replace("EXCEPTION_MSG", exception);
                            continue;
                        }
                        if (!"item change".equals(event) || !"Success".equals(eventResult) || !"ARG_PARAM".equals(key)) continue;
                        eventDetailMap.replace("ARG_PARAM", argsParam);
                    }
                    if ("Save".equalsIgnoreCase(event) && !"NA".equals(tranId)) {
                        eventDetailMap.replace("TRAN_ID", tranId);
                    }
                    this.addServerSentEventData(userCode, sessionId, objName, editorId, action, objectActivityMapKey, eventDetailMap);
                }
                ++i;
            }
            objectActivityMap.put(objectActivityMapKey, editorActivityList);
            userEventLogMap.put(String.valueOf(sessionId) + "~SEP~" + objName, objectActivityMap);
            eventActivityMap.put(userCode, userEventLogMap);
            if (!eventActionMap.containsKey(String.valueOf(editorId) + "_" + action)) {
                eventActionMap.put(String.valueOf(editorId) + "_" + action, action);
                StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
                StringBuffer callerName = new StringBuffer();
                int i2 = 0;
                while (i2 < stackTraceElements.length) {
                    String methodName = "" + stackTraceElements[i2];
                    if (methodName.contains("ibase")) {
                        callerName.append(methodName).append("~~");
                    }
                    methodName = null;
                    ++i2;
                }
                eventActionMap.put(String.valueOf(editorId) + "_" + action + "_callerName", callerName.toString());
                callerName = null;
            }
            BaseLogger.log("3", null, null, "<<<<<<<<< ended UserEventLogEJB--> updateEventLog >>>>>>>>>");
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception in UserEventLogEJB->updateEventLog()..........." + e.getMessage());
            BaseLogger.log("0", null, null, "Exception in UserEventLogEJB->updateEventLog()..........." + genericUtility.writePrintStacktrace(e));
            e.printStackTrace();
        }
    }

    public String userActivities(String objName, String user, String timeDiff) throws Exception {
        BaseLogger.log("3", null, null, "<<<<<<<<< start userActivities >>>>>>>>>");
        StringBuffer allactivites = new StringBuffer();
        E12GenericUtility genericUtility = new E12GenericUtility();
        String formNo = "";
        String transDB = "";
        String arVlaue = "";
        Set keys = eventActivityMap.keySet();
        allactivites.append("<All_Activites>");
        if (keys.contains(user)) {
            LinkedHashMap userActivityMap = (LinkedHashMap)eventActivityMap.get(user);
            DBAccessEJB dbAccessEjb = new DBAccessEJB();
            transDB = dbAccessEjb.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + user + "'");
            Set userActivitykey = userActivityMap.keySet();
            allactivites.append("<User_Activity>");
            String objNamePresentKey = "";
            for (String key1 : userActivitykey) {
                String currentObjName = key1.substring(key1.lastIndexOf("~SEP~") + 5);
                if (!currentObjName.equalsIgnoreCase(objName)) continue;
                objNamePresentKey = key1;
                break;
            }
            if (!"".equalsIgnoreCase(objNamePresentKey)) {
                LinkedHashMap objNameActivity = (LinkedHashMap)userActivityMap.get(objNamePresentKey);
                allactivites.append("<Event_Activity>");
                Set actionkeys = objNameActivity.keySet();
                Iterator iterator = actionkeys.iterator();
                while (iterator.hasNext()) {
                    String editorIdkey = (String)iterator.next();
                    String activity = editorIdkey.substring(editorIdkey.lastIndexOf("_") + 1);
                    LinkedList editorActivityList = (LinkedList)objNameActivity.get(editorIdkey);
                    LinkedHashMap eventDetailMap = new LinkedHashMap();
                    int i = 0;
                    while (i < editorActivityList.size()) {
                        allactivites.append("<EditorActivity_List>");
                        eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                        Set eventDetailMapKey = eventDetailMap.keySet();
                        SimpleDateFormat sdfFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                        String startDate = (String)eventDetailMap.get("ACCESS_TIME");
                        Date StartDateTime = sdfFormat.parse(startDate);
                        String currentDate = this.getValidDateTimeString(new Date(), genericUtility.getApplDateTimeFormat());
                        Date currDateTime = sdfFormat.parse(currentDate);
                        long DiffTime = (currDateTime.getTime() - StartDateTime.getTime()) / 1000L;
                        if (eventDetailMap.containsValue("Pending") || eventDetailMap.containsValue("Exception")) {
                            if (!"".equalsIgnoreCase(timeDiff)) {
                                arVlaue = "";
                                int timeinSecond = Integer.parseInt(timeDiff);
                                if (DiffTime >= (long)timeinSecond) {
                                    allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                    allactivites.append("<USER>" + user + "</USER>");
                                    allactivites.append("<OBJNAME>" + objName + "</OBJNAME>");
                                    allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                    for (Object key : eventDetailMapKey) {
                                        String value = (String)eventDetailMap.get(key);
                                        if (((String)key).equals("ARG_PARAM")) {
                                            formNo = this.getFormNum(value);
                                        }
                                        if (!"ARG_PARAM".equalsIgnoreCase((String)key) && !"IS_WRITETOFILE".equalsIgnoreCase((String)key)) {
                                            allactivites.append("<" + (String)key + ">");
                                            allactivites.append(value);
                                            allactivites.append("</" + (String)key + ">");
                                        }
                                        if (((String)key).equalsIgnoreCase("COMPL_TIME")) {
                                            allactivites.append("<TimeDiff>");
                                            allactivites.append(DiffTime);
                                            allactivites.append("</TimeDiff>");
                                        }
                                        if (!((String)key).equalsIgnoreCase("ARG_PARAM")) continue;
                                        arVlaue = value;
                                    }
                                    allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                    allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                }
                            } else {
                                Object key;
                                arVlaue = "";
                                allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                allactivites.append("<USER>" + user + "</USER>");
                                allactivites.append("<OBJNAME>" + objName + "</OBJNAME>");
                                allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                key = eventDetailMapKey.iterator();
                                while (key.hasNext()) {
                                    String key2 = (String)key.next();
                                    String value = (String)eventDetailMap.get(key2);
                                    if (key2.equals("ARG_PARAM")) {
                                        formNo = this.getFormNum(value);
                                    }
                                    if (!"ARG_PARAM".equalsIgnoreCase(key2) && !"IS_WRITETOFILE".equalsIgnoreCase(key2)) {
                                        allactivites.append("<" + key2 + ">");
                                        allactivites.append(value);
                                        allactivites.append("</" + key2 + ">");
                                    }
                                    if (key2.equalsIgnoreCase("COMPL_TIME")) {
                                        allactivites.append("<TimeDiff>");
                                        allactivites.append(DiffTime);
                                        allactivites.append("</TimeDiff>");
                                    }
                                    if (!key2.equalsIgnoreCase("ARG_PARAM")) continue;
                                    arVlaue = value;
                                }
                                allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                            }
                        }
                        allactivites.append("</EditorActivity_List>");
                        ++i;
                    }
                }
                allactivites.append("</Event_Activity>");
            } else if (objName.equalsIgnoreCase("")) {
                for (String key1 : userActivitykey) {
                    String currObjName = key1.substring(key1.lastIndexOf("~") + 1);
                    allactivites.append("<Event_Activity>");
                    LinkedHashMap objNameActivity = (LinkedHashMap)userActivityMap.get(key1);
                    Set actionkeys = objNameActivity.keySet();
                    for (String editorIdkey : actionkeys) {
                        String activity = editorIdkey.substring(editorIdkey.lastIndexOf("_") + 1);
                        LinkedList editorActivityList = (LinkedList)objNameActivity.get(editorIdkey);
                        LinkedHashMap eventDetailMap = new LinkedHashMap();
                        int i = 0;
                        while (i < editorActivityList.size()) {
                            allactivites.append("<EditorActivity_List>");
                            eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                            Set eventDetailMapKey = eventDetailMap.keySet();
                            SimpleDateFormat sdfFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                            String startDate = (String)eventDetailMap.get("ACCESS_TIME");
                            Date StartDateTime = sdfFormat.parse(startDate);
                            String currentDate = this.getValidDateTimeString(new Date(), genericUtility.getApplDateTimeFormat());
                            Date currDateTime = sdfFormat.parse(currentDate);
                            long DiffTime = (currDateTime.getTime() - StartDateTime.getTime()) / 1000L;
                            if (eventDetailMap.containsValue("Pending") || eventDetailMap.containsValue("Exception")) {
                                if (!"".equalsIgnoreCase(timeDiff)) {
                                    arVlaue = "";
                                    int timeinSecond = Integer.parseInt(timeDiff);
                                    if (DiffTime >= (long)timeinSecond) {
                                        allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                        allactivites.append("<USER>" + user + "</USER>");
                                        allactivites.append("<OBJNAME>" + currObjName + "</OBJNAME>");
                                        allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                        for (Object key : eventDetailMapKey) {
                                            String value = (String)eventDetailMap.get(key);
                                            if (((String)key).equals("ARG_PARAM")) {
                                                formNo = this.getFormNum(value);
                                            }
                                            if (!"ARG_PARAM".equalsIgnoreCase((String)key) && !"IS_WRITETOFILE".equalsIgnoreCase((String)key)) {
                                                allactivites.append("<" + (String)key + ">");
                                                allactivites.append(value);
                                                allactivites.append("</" + (String)key + ">");
                                            }
                                            if (((String)key).equalsIgnoreCase("COMPL_TIME")) {
                                                allactivites.append("<TimeDiff>");
                                                allactivites.append(DiffTime);
                                                allactivites.append("</TimeDiff>");
                                            }
                                            if (!((String)key).equalsIgnoreCase("ARG_PARAM")) continue;
                                            arVlaue = value;
                                        }
                                        allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                        allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                    }
                                } else {
                                    Object key;
                                    arVlaue = "";
                                    allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                    allactivites.append("<USER>" + user + "</USER>");
                                    allactivites.append("<OBJNAME>" + currObjName + "</OBJNAME>");
                                    allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                    key = eventDetailMapKey.iterator();
                                    while (key.hasNext()) {
                                        String key3 = (String)key.next();
                                        String value = (String)eventDetailMap.get(key3);
                                        if (key3.equals("ARG_PARAM")) {
                                            formNo = this.getFormNum(value);
                                        }
                                        if (!"ARG_PARAM".equalsIgnoreCase(key3) && !"IS_WRITETOFILE".equalsIgnoreCase(key3)) {
                                            allactivites.append("<" + key3 + ">");
                                            allactivites.append(value);
                                            allactivites.append("</" + key3 + ">");
                                        }
                                        if (key3.equalsIgnoreCase("COMPL_TIME")) {
                                            allactivites.append("<TimeDiff>");
                                            allactivites.append(DiffTime);
                                            allactivites.append("</TimeDiff>");
                                        }
                                        if (!key3.equalsIgnoreCase("ARG_PARAM")) continue;
                                        arVlaue = value;
                                    }
                                    allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                    allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                }
                            }
                            allactivites.append("</EditorActivity_List>");
                            ++i;
                        }
                    }
                    allactivites.append("</Event_Activity>");
                }
            }
            allactivites.append("</User_Activity>");
        } else if ("".equals(user)) {
            allactivites.append("<User_Activity>");
            for (String k : keys) {
                DBAccessEJB dbAccessEjb = new DBAccessEJB();
                transDB = dbAccessEjb.getDBColumnValue("USERS", "TRANS_DB", "CODE = '" + k + "'");
                LinkedHashMap userActivityMap = (LinkedHashMap)eventActivityMap.get(k);
                Set userActivitykey = userActivityMap.keySet();
                String objNamePresentKey = "";
                for (String key1 : userActivitykey) {
                    String currentObjName = key1.substring(key1.lastIndexOf("~SEP~") + 5);
                    if (!currentObjName.equalsIgnoreCase(objName)) continue;
                    objNamePresentKey = key1;
                    break;
                }
                if (!"".equalsIgnoreCase(objNamePresentKey)) {
                    allactivites.append("<Event_Activity>");
                    LinkedHashMap objNameActivity = (LinkedHashMap)userActivityMap.get(objNamePresentKey);
                    Set actionkeys = objNameActivity.keySet();
                    for (String editorIdkey : actionkeys) {
                        LinkedList editorActivityList = (LinkedList)objNameActivity.get(editorIdkey);
                        String activity = editorIdkey.substring(editorIdkey.lastIndexOf("_") + 1);
                        LinkedHashMap eventDetailMap = new LinkedHashMap();
                        int i = 0;
                        while (i < editorActivityList.size()) {
                            allactivites.append("<EditorActivity_List>");
                            eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                            Set eventDetailMapKey = eventDetailMap.keySet();
                            SimpleDateFormat sdfFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                            String startDate = (String)eventDetailMap.get("ACCESS_TIME");
                            Date StartDateTime = sdfFormat.parse(startDate);
                            String currentDate = this.getValidDateTimeString(new Date(), genericUtility.getApplDateTimeFormat());
                            Date currDateTime = sdfFormat.parse(currentDate);
                            long DiffTime = (currDateTime.getTime() - StartDateTime.getTime()) / 1000L;
                            if (eventDetailMap.containsValue("Pending") || eventDetailMap.containsValue("Exception")) {
                                arVlaue = "";
                                if (!"".equalsIgnoreCase(timeDiff)) {
                                    int timeinSecond = Integer.parseInt(timeDiff);
                                    if (DiffTime >= (long)timeinSecond) {
                                        allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                        allactivites.append("<USER>" + k + "</USER>");
                                        allactivites.append("<OBJNAME>" + objName + "</OBJNAME>");
                                        allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                        for (Object key : eventDetailMapKey) {
                                            String value = (String)eventDetailMap.get(key);
                                            if (((String)key).equals("ARG_PARAM")) {
                                                formNo = this.getFormNum(value);
                                            }
                                            if (!"ARG_PARAM".equalsIgnoreCase((String)key) && !"IS_WRITETOFILE".equalsIgnoreCase((String)key)) {
                                                allactivites.append("<" + (String)key + ">");
                                                allactivites.append(value);
                                                allactivites.append("</" + (String)key + ">");
                                            }
                                            if (((String)key).equalsIgnoreCase("COMPL_TIME")) {
                                                allactivites.append("<TimeDiff>");
                                                allactivites.append(DiffTime);
                                                allactivites.append("</TimeDiff>");
                                            }
                                            if (!((String)key).equalsIgnoreCase("ARG_PARAM")) continue;
                                            arVlaue = value;
                                        }
                                        allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                        allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                    }
                                } else {
                                    Object key;
                                    arVlaue = "";
                                    allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                    allactivites.append("<USER>" + k + "</USER>");
                                    allactivites.append("<OBJNAME>" + objName + "</OBJNAME>");
                                    allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                    key = eventDetailMapKey.iterator();
                                    while (key.hasNext()) {
                                        String key4 = (String)key.next();
                                        String value = (String)eventDetailMap.get(key4);
                                        if (key4.equals("ARG_PARAM")) {
                                            formNo = this.getFormNum(value);
                                        }
                                        if (!"ARG_PARAM".equalsIgnoreCase(key4) && !"IS_WRITETOFILE".equalsIgnoreCase(key4)) {
                                            allactivites.append("<" + key4 + ">");
                                            allactivites.append(value);
                                            allactivites.append("</" + key4 + ">");
                                        }
                                        if (key4.equalsIgnoreCase("COMPL_TIME")) {
                                            allactivites.append("<TimeDiff>");
                                            allactivites.append(DiffTime);
                                            allactivites.append("</TimeDiff>");
                                        }
                                        if (!key4.equalsIgnoreCase("ARG_PARAM")) continue;
                                        arVlaue = value;
                                    }
                                    allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                    allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                }
                            }
                            allactivites.append("</EditorActivity_List>");
                            ++i;
                        }
                    }
                    allactivites.append("</Event_Activity>");
                    continue;
                }
                if (!objName.equalsIgnoreCase("")) continue;
                for (String key1 : userActivitykey) {
                    allactivites.append("<Event_Activity>");
                    String currObjName = key1.substring(key1.lastIndexOf("~") + 1);
                    LinkedHashMap objNameActivity = (LinkedHashMap)userActivityMap.get(key1);
                    Set actionkeys = objNameActivity.keySet();
                    for (String editorIdkey : actionkeys) {
                        String activity = editorIdkey.substring(editorIdkey.lastIndexOf("_") + 1);
                        LinkedList editorActivityList = (LinkedList)objNameActivity.get(editorIdkey);
                        LinkedHashMap eventDetailMap = new LinkedHashMap();
                        int i = 0;
                        while (i < editorActivityList.size()) {
                            allactivites.append("<EditorActivity_List>");
                            eventDetailMap = (LinkedHashMap)editorActivityList.get(i);
                            Set eventDetailMapKey = eventDetailMap.keySet();
                            SimpleDateFormat sdfFormat = new SimpleDateFormat(genericUtility.getApplDateTimeFormat());
                            String startDate = (String)eventDetailMap.get("ACCESS_TIME");
                            Date StartDateTime = sdfFormat.parse(startDate);
                            String currentDate = this.getValidDateTimeString(new Date(), genericUtility.getApplDateTimeFormat());
                            Date currDateTime = sdfFormat.parse(currentDate);
                            long DiffTime = (currDateTime.getTime() - StartDateTime.getTime()) / 1000L;
                            if (eventDetailMap.containsValue("Pending") || eventDetailMap.containsValue("Exception")) {
                                arVlaue = "";
                                if (!"".equalsIgnoreCase(timeDiff)) {
                                    int timeinSecond = Integer.parseInt(timeDiff);
                                    if (DiffTime >= (long)timeinSecond) {
                                        allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                        allactivites.append("<USER>" + k + "</USER>");
                                        allactivites.append("<OBJNAME>" + currObjName + "</OBJNAME>");
                                        allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                        for (String key : eventDetailMapKey) {
                                            String value = (String)eventDetailMap.get(key);
                                            if (key.equals("ARG_PARAM")) {
                                                formNo = this.getFormNum(value);
                                            }
                                            if (!"ARG_PARAM".equalsIgnoreCase(key) && !"IS_WRITETOFILE".equalsIgnoreCase(key)) {
                                                allactivites.append("<" + key + ">");
                                                allactivites.append(value);
                                                allactivites.append("</" + key + ">");
                                            }
                                            if (key.equalsIgnoreCase("COMPL_TIME")) {
                                                allactivites.append("<TimeDiff>");
                                                allactivites.append(String.valueOf(DiffTime) + " seconds");
                                                allactivites.append("</TimeDiff>");
                                            }
                                            if (!key.equalsIgnoreCase("ARG_PARAM")) continue;
                                            arVlaue = value;
                                        }
                                        allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                        allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                    }
                                } else {
                                    arVlaue = "";
                                    allactivites.append("<DB_NAME>" + transDB + "</DB_NAME>");
                                    allactivites.append("<USER>" + k + "</USER>");
                                    allactivites.append("<OBJNAME>" + currObjName + "</OBJNAME>");
                                    allactivites.append("<ACTIVITY>" + activity + "</ACTIVITY>");
                                    for (String key : eventDetailMapKey) {
                                        String value = (String)eventDetailMap.get(key);
                                        if (key.equals("ARG_PARAM")) {
                                            formNo = this.getFormNum(value);
                                        }
                                        if (!"ARG_PARAM".equalsIgnoreCase(key) && !"IS_WRITETOFILE".equalsIgnoreCase(key)) {
                                            allactivites.append("<" + key + ">");
                                            allactivites.append(value);
                                            allactivites.append("</" + key + ">");
                                        }
                                        if (key.equalsIgnoreCase("COMPL_TIME")) {
                                            allactivites.append("<TimeDiff>");
                                            allactivites.append(String.valueOf(DiffTime) + " seconds");
                                            allactivites.append("</TimeDiff>");
                                        }
                                        if (!key.equalsIgnoreCase("ARG_PARAM")) continue;
                                        arVlaue = value;
                                    }
                                    allactivites.append("<FORM_NO>" + formNo + "</FORM_NO>");
                                    allactivites.append("<ARG_PARAM>" + arVlaue + "</ARG_PARAM>");
                                }
                            }
                            allactivites.append("</EditorActivity_List>");
                            ++i;
                        }
                    }
                    allactivites.append("</Event_Activity>");
                }
            }
            allactivites.append("</User_Activity>");
        }
        allactivites.append("</All_Activites>");
        return allactivites.toString();
    }

    private void addServerSentEventData(String userCode, String sessionId, String objName, String editorId, String action, String objectActivityMapKey, LinkedHashMap<String, String> eventDetailMap) {
        block12: {
            try {
                String tranId;
                E12GenericUtility e12GenericUtility = new E12GenericUtility();
                if (userCode.equalsIgnoreCase("")) break block12;
                JSONObject userActivityDetails = new JSONObject();
                String userSessionKey = String.valueOf(userCode) + ":" + sessionId;
                String activityDescr = this.checkNull(eventActionMap.get(objectActivityMapKey));
                if (activityDescr.length() == 0) {
                    activityDescr = "VIEW";
                }
                String objNameDescr = this.checkNull(this.getObjNameDescr(objName, null, userCode));
                if (activityDescr.length() == 0) {
                    objNameDescr = objName;
                }
                if ((tranId = this.checkNull(eventDetailMap.get("TRAN_ID"))).length() == 0) {
                    tranId = "NA";
                }
                userActivityDetails.put("ACTIVITY_TITLE", (Object)objNameDescr);
                userActivityDetails.put("ACTIVITY_OBJECT", (Object)objName);
                userActivityDetails.put("ACTIVITY_DESCRP", (Object)activityDescr);
                userActivityDetails.put("ACTIVITY_EDITOR", (Object)editorId);
                userActivityDetails.put("EVENT_ID", (Object)eventDetailMap.get("EVENT_ID"));
                userActivityDetails.put("EVENT_DESCRP", (Object)eventDetailMap.get("EVENT"));
                userActivityDetails.put("ARG_PARAM", (Object)eventDetailMap.get("ARG_PARAM"));
                userActivityDetails.put("ACCESS_START_TIME", (Object)eventDetailMap.get("ACCESS_TIME"));
                userActivityDetails.put("ACCESS_END_TIME", (Object)eventDetailMap.get("COMPL_TIME"));
                String accessTime = eventDetailMap.get("ACCESS_TIME");
                String complTime = eventDetailMap.get("COMPL_TIME");
                String timeDiff = "";
                if (E12GenericUtility.checkNull(accessTime).length() > 0 && E12GenericUtility.checkNull(complTime).length() > 0) {
                    try {
                        SimpleDateFormat sdf = new SimpleDateFormat(e12GenericUtility.getApplDateTimeFormat());
                        Date d1 = sdf.parse(accessTime);
                        Date d2 = sdf.parse(complTime);
                        long difference_In_Time = d2.getTime() - d1.getTime();
                        long difference_In_Seconds = difference_In_Time / 1000L % 60L;
                        long difference_In_Minutes = difference_In_Time / 60000L % 60L;
                        int accessTimeMS = Integer.parseInt(accessTime.substring(accessTime.lastIndexOf(".") + 1));
                        int complTimeMS = Integer.parseInt(complTime.substring(complTime.lastIndexOf(".") + 1));
                        int difference_In_MilliSeconds = 0;
                        if (complTimeMS < accessTimeMS) {
                            complTimeMS += 1000;
                            --difference_In_Seconds;
                        }
                        difference_In_MilliSeconds = complTimeMS - accessTimeMS;
                        timeDiff = String.valueOf(difference_In_Minutes) + ":" + difference_In_Seconds + ":" + difference_In_MilliSeconds;
                    }
                    catch (ITMException e) {
                        BaseLogger.log("0", null, null, "In UserEventLogEJB addServerSentEventData ITMException accessTime : [" + accessTime + "]");
                        BaseLogger.log("0", null, null, "In UserEventLogEJB addServerSentEventData ITMException complTime : [" + complTime + "]");
                        BaseLogger.log("0", null, null, "In UserEventLogEJB addServerSentEventData ITMException : [" + E12GenericUtility.getStackTrace(e) + "]");
                    }
                    catch (Exception e) {
                        BaseLogger.log("0", null, null, "In UserEventLogEJB addServerSentEventData Exception accessTime : [" + accessTime + "]");
                        BaseLogger.log("0", null, null, "In UserEventLogEJB addServerSentEventData Exception complTime : [" + complTime + "]");
                        BaseLogger.log("0", null, null, "In UserEventLogEJB addServerSentEventData Exception : [" + E12GenericUtility.getStackTrace(e) + "]");
                    }
                }
                userActivityDetails.put("TIME_DIFF", (Object)timeDiff);
                userActivityDetails.put("PRIMARY_KEY", (Object)tranId);
                userActivityDetails.put("EVENT_RESULT", (Object)eventDetailMap.get("EVENT_RESULT"));
                userActivityDetails.put("EXCEPTION", (Object)eventDetailMap.get("EXCEPTION_MSG"));
                userActivityDetails.put("ACTIVITY_MAP_KEY", (Object)objectActivityMapKey);
                JSONArray userActivityList = null;
                if (CommonConstants.eventMonitoringUsersList.containsKey(userSessionKey)) {
                    userActivityList = new JSONArray(CommonConstants.eventMonitoringUsersList.get(userSessionKey));
                }
                if (userActivityList == null) {
                    userActivityList = new JSONArray();
                }
                userActivityList.put((Object)userActivityDetails.toString());
                CommonConstants.eventMonitoringUsersList.put(userSessionKey, userActivityList.toString());
                CommonConstants.eventMonitoringUsersList.put(String.valueOf(userSessionKey) + "_STATUS", "true");
            }
            catch (JSONException e) {
                BaseLogger.log("0", null, null, "JSONException :: addServerSentEventData : [" + e.getMessage() + "]");
                e.printStackTrace();
            }
        }
    }
}

