/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.utility;

import ibase.utility.BaseLogger;
import ibase.webitm.utility.PreprocessorFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class InvoiceDataPreprocessor {
    public String processData(String extractedDataStr) {
        String processedData = "";
        try {
            JSONObject extractedData = (JSONObject)new JSONParser().parse(extractedDataStr);
            Map<String, ArrayList<PreprocessorFunction>> keyListToBeProcess = this.getKeyAndFunctionListToBeProcess(extractedData);
            BaseLogger.log("3", null, null, "keyListToBeProcess : " + keyListToBeProcess);
            JSONObject processedJson = new JSONObject();
            for (Map.Entry<String, ArrayList<PreprocessorFunction>> functionDetails : keyListToBeProcess.entrySet()) {
                String key = functionDetails.getKey();
                String sourceValue = (String)extractedData.get((Object)key);
                ArrayList<PreprocessorFunction> functionList = functionDetails.getValue();
                for (PreprocessorFunction function : functionList) {
                    sourceValue = function.invoke(sourceValue);
                    processedJson.put((Object)key, (Object)sourceValue);
                }
            }
            BaseLogger.log("3", null, null, "processedJson [" + processedJson + "]");
            this.updateExtratedData(extractedData, processedJson);
            processedData = extractedData.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BaseLogger.log("0", null, null, "Exception in InvoiceDataPreprocessor :: processData " + ex);
        }
        return processedData;
    }

    public Map<String, ArrayList<PreprocessorFunction>> getKeyAndFunctionListToBeProcess(JSONObject extractedData) {
        HashMap<String, ArrayList<PreprocessorFunction>> keyList = new HashMap<String, ArrayList<PreprocessorFunction>>();
        Set keys = extractedData.keySet();
        for (String key : keys) {
            if (key.indexOf("@") <= 1) continue;
            String sourceValue = (String)extractedData.get((Object)key);
            ArrayList<PreprocessorFunction> details = this.getFunctionList(key);
            keyList.put(key, details);
        }
        return keyList;
    }

    public ArrayList<PreprocessorFunction> getFunctionList(String key) {
        BaseLogger.log("3", null, null, "prosessKeys key : " + key);
        ArrayList<PreprocessorFunction> functionsList = new ArrayList<PreprocessorFunction>();
        if (key.length() > 1) {
            String[] keys;
            String keyField = "";
            keyField = key.substring(key.indexOf("@") + 1);
            key = key.substring(0, key.indexOf("@"));
            String[] stringArray = keys = key.split("::");
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object functionDetails;
                String details = stringArray[n2];
                if (key.contains("#")) {
                    functionDetails = details.split("#");
                    String funName = functionDetails[0];
                    String[] funparamsArr = functionDetails[1].split(",");
                    PreprocessorFunction functionDetailObject = new PreprocessorFunction(funName, funparamsArr);
                    functionsList.add(functionDetailObject);
                } else {
                    functionDetails = new PreprocessorFunction(details, new String[0]);
                    functionsList.add((PreprocessorFunction)functionDetails);
                }
                ++n2;
            }
        }
        return functionsList;
    }

    private void updateExtratedData(JSONObject extratedData, JSONObject updatedData) {
        Set keys = updatedData.keySet();
        for (String key : keys) {
            extratedData.remove((Object)key);
            String newkey = key.substring(key.indexOf("@") + 1);
            extratedData.put((Object)newkey, updatedData.get((Object)key));
        }
    }
}

