//package ibase.wsfa.ejb;
package ibase.webitm.ejb.wsfa.masters;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
//import oracle.jdbc.driver.OraclePreparedStatement;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

//@Stateless			commented by Sagar M [22 Nov 2018].
public class SprsStockist extends ValidatorEJB implements SprsStockistLocal,SprsStockistRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	protected static String database = CommonConstants.DB_NAME;

	public String wfValData() throws RemoteException, ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);
			System.out.println("ErrString: " + errString);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockist: wfValData(String xmlString): " + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		System.out.println("Returning from SprsStockist wfValData");
		return (errString);
	}

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String columnName = "";
		String columnValue = "";
		String userId = "";
		String errString = "";
		String userType = "";
		String loginEmpCode = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		Statement stmt = null; //Added by jaimin on 29/05/2008 (SY89SUN001)
		ResultSet rs = null;

		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String selSql = "";//Added by jaimin on 29/05/2008 (SY89SUN001)

		int intDtRet = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int count = 0;

		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{
			//InitialContext ctx = getInitialContext();
			//ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );
			//Commented by vinayak on [11/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [11/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//Gulzar - to set user type (H- HO user and M - Manager) - 12/08/10 [WS90SUN049]
			userType = checkNull(genericUtility.getColumnValue("user_type__login",dom));
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			//End added changes gulzar - 12/08/10 [WS90SUN049]

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			parentNode = parentList.item(0);
			childList = parentNode.getChildNodes();
			noOfChilds = childList.getLength();
			for(ctr = 0; ctr < noOfChilds; ctr++)
			{
				childNode = childList.item(ctr);
				childNodeName = childNode.getNodeName();
				switch(currentFormNo)
				{
					case 1:
						 if (childNodeName.equalsIgnoreCase("sprs_code"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "sprs_code", "NULSPRCODE", userId );
							}
							//Start - Added by jaimin on 29/05/2008 (SY89SUN001)
							else
							{
								String sprsCode = genericUtility.getColumnValue("sprs_code",dom);
								stmt =  connectionObject.createStatement();
								selSql = "SELECT SALES_PERS FROM SALES_PERS WHERE SALES_PERS = '"+ sprsCode +"' ";
								rs = stmt.executeQuery(selSql);
								if (!rs.next())
								{
									errString = getErrorString( "sprs_code", "VSPRSCODE", userId );
								}
								//Added by Hariom S for dirty connection close  -- 07-Sep-21 [Start]
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( stmt != null )
								{
									stmt.close();
									stmt = null;
								}
								//Added by Hariom S for dirty connection close  -- 07-Sep-21 [End]
								//Following block of code added by gulzar - 09/08/10[WS90SON049]
								String selectSql = "";
								int spCount = 0;
								if ( !(userType.trim().equalsIgnoreCase("H")) )
								{
									selectSql = "SELECT COUNT(*) AS COUNT FROM SALES_PERS WHERE SALES_PERS = '"+sprsCode+"' AND "+
												"SALES_PERS IN( SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = '"+loginEmpCode+"' "+
												"CONNECT BY PRIOR EMP_CODE = REPORT_TO )";
									stmt =  connectionObject.createStatement();
									rs = stmt.executeQuery(selectSql);
									if ( rs.next() )
									{
										spCount = rs.getInt("COUNT");
									}
									//Added by Hariom S for dirty connection close  -- 07-Sep-21 [Start]
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( stmt != null )
									{
										stmt.close();
										stmt = null;
									}
									//Added by Hariom S for dirty connection close  -- 07-Sep-21 [End]
									if ( spCount == 0 )
									{
										errString = getErrorString("sprs_code","SLPNOTVAL",userId);
										break;
									}
								}
								//End Added changes gulzar - 12/08/10 [WS90SUN049]
							}
							//End - Added by jaimin on 29/05/2008 (SY89SUN001)
						}
						else if (childNodeName.equalsIgnoreCase("route_id"))
						{
							String statusDom = genericUtility.getColumnValue("status",dom); //Gulzar - 05/12/2008
							if(childNode.getFirstChild() == null)
							{

								//Modified by Ramchandra on [03/10/2012][To change error message for Route_Id]
								//errString = getErrorString( "route_id", "NULROTID", userId );
								System.out.println("[SprsStockist][wfValData()][Route_Id]");
								errString = getErrorString( "route_id", "VMINVCUST2", userId );
							}
							//Start - Added by jaimin on 29/05/2008 (SY89SUN001)
							else if( statusDom != null && statusDom.trim().equalsIgnoreCase("Y") ) //Condition Added - Gulzar - 05/12/2008
							{
								String routeId = genericUtility.getColumnValue("route_id",dom);
								String sprsCode = genericUtility.getColumnValue("sprs_code",dom);
								stmt =  connectionObject.createStatement();
								/*-- Commented and Changes below - Gulzar - 14/11/08
								selSql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ sprsCode +"' AND ROUTE_ID = '"+ routeId +"' ";
								rs = stmt.executeQuery(selSql);
								if (!rs.next())
								{
									errString = getErrorString( "route_id", "VROUTEID", userId );
								}
								*/
								String routeStatus = "";
								String sprsRouteID = "";

								//Modified by Ramchandra on [10/07/2012] [To check for validation for Route Type also ] [Start]
								//selSql = "SELECT ROUTE_ID, STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ sprsCode +"' AND ROUTE_ID = '"+ routeId +"' ";
								String sprsRouteType = "";
								selSql = "SELECT ROUTE_ID, STATUS, ROUTE_TYPE FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ sprsCode +"' AND ROUTE_ID = '"+ routeId +"' ";
								//Modified by Ramchandra on [10/07/2012] [To check for validation for Route Type also ] [End]

								rs = stmt.executeQuery(selSql);
								if ( rs.next() )
								{
									sprsRouteID = rs.getString("ROUTE_ID");
									routeStatus = rs.getString("STATUS");
									//Modified by Ramchandra on [10/07/2012] [To check validation for Route Type also ]
									sprsRouteType = rs.getString("ROUTE_TYPE");
								}
								//Added by Hariom S for dirty connection close  -- 07-Sep-21 [Start]
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( stmt != null )
								{
									stmt.close();
									stmt = null;
								}
								//Added by Hariom S for dirty connection close  -- 07-Sep-21 [End]

								//Modified by Ramchandra on[03/10/2012][To check validation for Route_Id of SprsRoute]
								//if ( sprsRouteID == null && sprsRouteID.trim().length() == 0 )
								if ( sprsRouteID == null || sprsRouteID.trim().length() == 0 )
								{
									System.out.println("[SprsStockist][wfValData()][sprsRouteID]" +sprsRouteID);
									errString = getErrorString( "route_id", "VROUTEID", userId );
								}
								else if ( routeStatus != null && routeStatus.trim().equalsIgnoreCase("N") )
								{
									errString = getErrorString( "route_id", "VROUTEID", userId );
								}

								//Modified by Ramchandra on [10/07/2012] [To check validation for Route Type also ] [Start]
								else
								{
									String [] propValueArr = null;
									String propValues = "";
									Vector vector = new Vector();
									propValues = getAllowedRouteType( sprsCode, connectionObject );
									if (propValues.trim().length() > 0)
									{
										if(propValues.indexOf(',')>0)
										{
											propValueArr = propValues.split(",");
										}
										else
										{
											propValueArr = new String[1];
											propValueArr[0] = propValues;
										}
										for(int k=0 ; k<propValueArr.length ; k++)
										{
											vector.add(propValueArr[k]);
										}

										//if (vector.contains(sprsRouteType))
										System.out.println("vector::defined sprs_stockist::route:::["+vector+"]::actual sprs_stockist :sprsRouteType from sprs_route::::["+sprsRouteType+"]");
										// Request id :W17JSUN003  Changed by Sachin Satre on [22-Jan-18] for CHC div user in propertis table define the route for CHC user. if route is M ot T then give the validation for all division as well as CHC [Start]
										if ( vector.contains(sprsRouteType)  )
									    {
									    	if ( ( sprsRouteType.equalsIgnoreCase("M") || sprsRouteType.equalsIgnoreCase("T")) )
									    	{
												System.out.println("In error when adding stockist");
												errString = getErrorString( "route_id", "VINVSTKP", userId );
											}
									    }
									    else
									    {
									    	if ( ( sprsRouteType.equalsIgnoreCase("M") || sprsRouteType.equalsIgnoreCase("T")) )
									    	{
									    		errString = getErrorString( "route_id", "VINVSTKP", userId );
									    	}
									    }
										// Request id :W17JSUN003  Changed by Sachin Satre on [22-Jan-18] for CHC div user in propertis table define the route for CHC user. if route is M ot T then give the validation for all division as well as CHC [Start]
									}
								}
								//Modified by Ramchandra on [10/07/2012] [To check validation for Route Type also ] [End]

								//End Changes Gulzar - 14/11/08
							}
							//End - Added by jaimin on 29/05/2008 (SY89SUN001)
						}
						else if(childNodeName.equalsIgnoreCase("cust_code"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "cust_code", "NULCUSCODE", userId );
							}
							else
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								if( columnValue != null )
								{
									String custType = "";
									String sql = "SELECT CUST_TYPE FROM CUSTOMER WHERE CUST_CODE = ?";
									pstmt = connectionObject.prepareStatement(sql);
									pstmt.setString(1, columnValue);
									//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
									rs = pstmt.executeQuery();
									if ( !rs.next() )
									{
										errString = getErrorString( "cust_code", "CUSNOTEXT", userId );
									}
									else
									{
										custType = rs.getString("CUST_TYPE");
									}
									//Added by Hariom S for dirty connection close  -- 07-Sep-21 [Start]
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									//Start Added - Guzar - 22/05/10 [WS90SUN032]
									if ( editFlag != null && "A".equalsIgnoreCase(editFlag.trim()) )
									{
										String salesPers = checkNull(genericUtility.getColumnValue("sprs_code",dom));
										sql = "SELECT COUNT(*) AS COUNT FROM SPRS_STOCKIST WHERE CUST_CODE = ? AND STATUS = ? AND SPRS_CODE = ? ";
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, columnValue);
										pstmt.setString(2, "Y");
										pstmt.setString(3, salesPers);
										rs = pstmt.executeQuery();
										pstmt.clearParameters();
										if ( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										if ( count > 0 )
										{
											errString = getErrorString( "CUST_CODE", "STOCKSTEXT", userId );
										}
										rs.close();
										rs = null;

										pstmt.setString(1, columnValue);
										pstmt.setString(2, "N");
										pstmt.setString(3, salesPers);
										rs = pstmt.executeQuery();
										pstmt.clearParameters();
										if ( rs.next() )
										{
											count = rs.getInt("COUNT");
										}
										if ( count > 0 )
										{
											errString = getErrorString( "CUST_CODE", "INACTSTKST", userId );
										}
										rs.close();
										rs = null;
										if( pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}
										//The following code added by gulzar to validate customer - 16/08/10 [WS90SUN049]

										/* Modified by Rupesh [10/07/2012] [Change message text] [Start] */
										int count1 = 0;
										/*
										sql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER A WHERE A.LOCALITY_CODE IN " +
										"(SELECT DISTINCT B.LOCALITY_CODE FROM SPRS_ROUTE B " +
										"WHERE B.SPRS_CODE = ? AND B.LOCALITY_CODE = A.LOCALITY_CODE AND B.STATUS ='Y') "+
										"AND CUST_CODE = ? AND A.BLACK_LISTED ='N' AND A.CUST_TYPE IN('T','D','I','C','O')";
										*/

										sql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER A WHERE CUST_CODE = ? AND A.BLACK_LISTED ='N' AND A.CUST_TYPE IN('T','D','I','C','O','L')";//Added L cust type by kailash on 01-11-18 for koye requirement.
										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, columnValue);
										rs = pstmt.executeQuery();
										System.out.println(" Validation [cust_code] Sql1 :==>> "+ sql );
										pstmt.clearParameters();
										if ( rs.next() )
										{
											count = rs.getInt("COUNT");
										}

										if( rs != null)
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}

										sql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER A WHERE A.LOCALITY_CODE IN " +
										"(SELECT DISTINCT B.LOCALITY_CODE FROM SPRS_ROUTE B " +
										"WHERE B.SPRS_CODE = ? AND B.LOCALITY_CODE = A.LOCALITY_CODE AND B.STATUS ='Y')";

										pstmt = connectionObject.prepareStatement(sql);
										pstmt.setString(1, salesPers);
										rs = pstmt.executeQuery();
										System.out.println(" Validation [cust_code] Sql2 ==>> "+ sql );
										pstmt.clearParameters();
										if ( rs.next() )
										{
											count1 = rs.getInt("COUNT");
										}

										if( rs != null)
										{
											rs.close();
											rs = null;
										}
										if( pstmt != null)
										{
											pstmt.close();
											pstmt = null;
										}

										if ( count == 0 )
										{
											errString = getErrorString( "CUST_CODE", "VMINVCUST", userId );
										}
										else if ( count1 == 0 )
										{
											errString = getErrorString( "CUST_CODE", "VMINVCUST2", userId );
										}
										/* Modified by Rupesh [10/07/2012] [Change message text] [End]*/
										//End Added changes - Guzar - 16/08/10 [WS90SUN049]
									}
									//End Added - Guzar - 22/05/10 [WS90SUN032]
								}
							}
						}
						//Start - Added by jaimin on 29/05/2008 (SY89SUN001)
						else if (childNodeName.equalsIgnoreCase("status"))
						{
							if(childNode.getFirstChild() == null)
							{
								errString = getErrorString( "status", "VSTATUS", userId );
							}
							//Added - Gulzar - 14/11/08 - Req ID :
							columnValue = childNode.getFirstChild().getNodeValue().trim();
							if ( editFlag.equalsIgnoreCase("E") && columnValue.equalsIgnoreCase("Y") )
							{
								String routeStatus = "";
								String routeId = genericUtility.getColumnValue("route_id",dom);
								String sprsCode = genericUtility.getColumnValue("sprs_code",dom);
								String custCode = genericUtility.getColumnValue("cust_code",dom);
								selSql = "SELECT STATUS FROM SPRS_ROUTE WHERE SPRS_CODE = '"+ sprsCode +"' AND ROUTE_ID = '"+ routeId +"' ";
								System.out.println("selSql ::"+selSql);
								stmt =  connectionObject.createStatement();
								rs = stmt.executeQuery(selSql);
								if ( rs.next() )
								{
									routeStatus = rs.getString("STATUS");
								}
								if ( routeStatus != null && routeStatus.trim().equalsIgnoreCase("N") )
								{
									errString = getErrorString( "status", "VROUTEID", userId );
								}
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								int custCnt = 0;
								selSql = "SELECT COUNT(*) AS COUNT FROM CUSTOMER WHERE CUST_CODE='"+custCode+"' AND BLACK_LISTED = 'Y' ";
								rs = stmt.executeQuery(selSql);
								if ( rs.next() )
								{
									custCnt = rs.getInt("COUNT");
								}
								//Added by Hariom S for dirty connection close  -- 07-Sep-21 [Start]
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( stmt != null )
								{
									stmt.close();
									stmt = null;
								}
								//Added by Hariom S for dirty connection close  -- 07-Sep-21 [End]
								if ( custCnt > 0 )
								{
									errString = getErrorString( "status", "VTINACUST", userId );
								}
								//End Changes Gulzar - 14/11/08
							}
						}					 
						//Added By Haseeb Khan for Category Validations on [21/10/2021] [START]
						else if(childNodeName.equalsIgnoreCase("category")) 
						{
							if(childNode.getFirstChild() == null)
							{
								
							}
							else
							{
								String category = checkNull(childNode.getFirstChild().getNodeValue().trim());
								System.out.println("Inside Category Node Name >>>>>>> "+category);
								int count1 =0 ;
								if(category != null)
								{
									String query = "select count(*) as category from gencodes where fld_name ='CATEGORY' and mod_name ='W_SPRS_STOCKIST' and active ='Y' "
											+ "and fld_value = ? ";
									pstmt = connectionObject.prepareStatement(query);
									pstmt.setString(1, category);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										count1=rs.getInt("category");
									}
									if ( rs != null )
									{
										rs.close();
										rs = null;
									}
									if ( pstmt != null )
									{
										pstmt.close();
										pstmt = null;
									}
									System.out.println("Count ==== :::"+count1);
									if(count1 == 0)
									{
										errString = getErrorString( "category", "CATNOTEXT", userId );
									}
									
								}
							}
						}					
						 //Added By Haseeb Khan for Category Validations on [21/10/2021] [END]
						//End - Added by jaimin on 29/05/2008 (SY89SUN001)
					}
					if ( errString != null && errString.trim().length() > 0 )
					{
						break;
					}
				}
			}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockist: wfValData(Document dom): " + se.getMessage() + ":");
			//errString = genericUtility.createErrorString(se);
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			System.out.println("Exception: SprsStockist: wfValData(Document dom): " + e.getMessage() + ":");
			//errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally //Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch (Exception e){}
		}
		return (errString);
	}

	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}

	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2);
			}
			errString = itemChanged(dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams);
			System.out.println ("ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ("Exception :SprsStockist :itemChanged(String,String):" + e.getMessage() + ":");
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ("returning from SprsStockist itemChanged");
		return errString;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("SPRS STOCKIST EJB ITEMCHANGE");
		String columnValue = "";
		String returnString = "";
		String custName = "";
		String shName = "";
		String addr1 = "";
		String addr2 = "";
		String addr3 = "";
		String city = "";
		String stateCode = "";
		String pin = "";
		String countCode = "";
		String stanCode = "";
		String tele1 = "";
		String tele2 = "";
		String tele3 = "";
		String teleExt = "";
		String fax = "";
		String stateCodeDescr = "";
		String stanCodeDescr = "";
		String locCode = "";
		String routeId = "";
		String shDescr = ""; //Added by jaimin on 29/05/2008 (SY89PHE001)
		String selectSql = ""; //Added by jaimin on 29/05/2008 (SY89PHE001)
		String salesPersName = ""; //Added by jaimin on 29/05/2008 (SY89PHE001)
		String empCodeMGR = ""; //Gulzar - 16/08/10 [WS90SUN049]
		String empCodeHO = ""; //Gulzar - 16/08/10 [WS90SUN049]
		String loginEmpCode = ""; //Gulzar - 16/08/10 [WS90SUN049]

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		Statement stmt = null ; //Added by jaimin on 29/05/2008 (SY89PHE001)
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer();

		int currentFormNo = 0;
		int shortID = 0; //Added by jaimin on 29/05/2008 (SY89PHE001)
		//E12GenericUtility genericUtility = new E12GenericUtility(); //Commented by vinayak on [29/04/2016] as object has been declared on class level

		try
		{
			//Commented by vinayak on [08/07/2016] [start]
			/*ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			connectionObject = connDriver.getConnectDB("DriverValidator");*/
			//Commented by vinayak on [08/07/2016] [end]
			connectionObject = getConnection();//Added by vinayak on [08/07/2016] to get connection.
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");//Gulzar - 12/08/10 [WS90SUN049]

			columnValue = genericUtility.getColumnValue(currentColumn,dom);
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
            //valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<Root>\r\n<Header>\r\n<editFlag>");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			valueXmlString.append(editFlag).append("</editFlag>\r\n</Header>\r\n");
			switch (currentFormNo)
			{
				case 1:
					valueXmlString.append("<Detail>\r\n");
					if (currentColumn.trim().equalsIgnoreCase("itm_default"))
					{
						//Start - Added by jaimin on 29/05/2008 (SY89PHE001)
						String salesPers = checkNull(genericUtility.getColumnValue("sprs_code",dom));
						String salesPersFarg = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"SPRS_CODE_FARG"));
						String entityCode = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"));
						if ( salesPers.trim().length() == 0 )
						{
							salesPers = ( salesPersFarg.trim().length() == 0 ) ? entityCode: salesPersFarg;
						}
						//salesPers = (salesPers == null || salesPers.length() == 0) ? genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode"):salesPers; //Added - Gulzar - 9/18/2008
						selectSql = "SELECT CASE WHEN MAX(SHORT_ID) IS NULL THEN 0 ELSE MAX(SHORT_ID) END "+
									"FROM SPRS_STOCKIST WHERE SPRS_CODE = '"+salesPers+"'";
						System.out.println("SQL :: "+selectSql); //Added by jaimin on 30/05/2008 (SY89PHE001)
						stmt = connectionObject.createStatement();
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							shortID = rs.getInt(1);
							shortID++;//Gulzar - 9/18/2008
							System.out.println("shortID :: "+shortID); //Added by jaimin on 30/05/2008 (SY89PHE001)
						}
						rs.close();
						selectSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = '"+salesPers+"'";
						System.out.println("selectSql :: "+selectSql); //Added by jaimin on 30/05/2008 (SY89PHE001)
						rs = stmt.executeQuery(selectSql);
						if ( rs.next() )
						{
							salesPersName = rs.getString("SP_NAME");
							System.out.println("salesPersName :: "+salesPersName); //Added by jaimin on 30/05/2008 (SY89PHE001)
						}
						rs.close();
						stmt.close();
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
						//valueXmlString.append("<short_id>").append(shortID).append("</short_id>\r\n");
						valueXmlString.append("<short_id><![CDATA[").append(shortID).append("]]></short_id>\r\n");
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						valueXmlString.append("<sprs_code protect = '1'>").append("<![CDATA["+salesPers+"]]>").append("</sprs_code>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<sp_name>").append("<![CDATA["+salesPersName+"]]>").append("</sp_name>\r\n");

						//Modified by Ramchandra on [14/07/2012] [To disable Status field for add new]
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
						//valueXmlString.append("<status protect = '1'>").append("Y").append("</status>\r\n");
						valueXmlString.append("<status protect = '1'><![CDATA[").append("Y").append("]]></status>\r\n");
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						//End - Added by jaimin on 29/05/2008	 (SY89PHE001)
						//Added changes gulzar - 12/08/10 [WS90SUN049]
						empCodeMGR = getMGREmployee( loginEmpCode, connectionObject );
						empCodeHO = getHOEmployee( loginEmpCode, connectionObject );
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
						//valueXmlString.append("<entity_code__login>").append(loginEmpCode).append("</entity_code__login>\r\n");
						valueXmlString.append("<entity_code__login><![CDATA[").append(loginEmpCode).append("]]></entity_code__login>\r\n");
						//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						if ( empCodeMGR != null && empCodeMGR.trim().length() > 0 )
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<user_type__login>").append("M").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("M").append("]]></user_type__login>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<user_type__login>").append("H").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("H").append("]]></user_type__login>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<user_type__login>").append("").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("").append("]]></user_type__login>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						//End added changes gulzar - 12/08/10 [WS90SUN049]
					}
					//Start - Added by jaimin on 29/05/2008 (SY89PHE001)
					if (currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					{
						String status = genericUtility.getColumnValue("status",dom);
						if ( status.equals("Y") )
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<reply_status>").append("0").append("</reply_status>\r\n");
							valueXmlString.append("<reply_status><![CDATA[").append("0").append("]]></reply_status>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						//Added - Gulzar - 30/10/10
						empCodeMGR = getMGREmployee( loginEmpCode, connectionObject );
						empCodeHO = getHOEmployee( loginEmpCode, connectionObject );
						if ( empCodeMGR != null && empCodeMGR.trim().length() > 0 )
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<user_type__login>").append("M").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("M").append("]]></user_type__login>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else if ( empCodeHO != null && empCodeHO.trim().length() > 0 )
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<user_type__login>").append("H").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("H").append("]]></user_type__login>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<user_type__login>").append("").append("</user_type__login>\r\n");
							valueXmlString.append("<user_type__login><![CDATA[").append("").append("]]></user_type__login>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						//End Added - Gulzar - 30/10/10
					}
					//End - Added by jaimin on 29/05/2008 (SY89PHE001)
					else if(currentColumn.trim().equalsIgnoreCase("sprs_code"))
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						String selSql = "SELECT SP_NAME FROM SALES_PERS WHERE SALES_PERS = ?";
						String spName = "";

						pstmt = connectionObject.prepareStatement(selSql);
						pstmt.setString(1, columnValue);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							spName = checkNull(rs.getString("SP_NAME"));
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							valueXmlString.append("<sp_name><![CDATA[").append(spName).append("]]></sp_name>\r\n");	//Gulzar - 05/12/2008
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
							valueXmlString.append("<sp_name>").append("<![CDATA["+spName+"]]>").append("</sp_name>\r\n"); //Gulzar - 05/12/2008
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<sp_name>").append("").append("</sp_name>\r\n");
							valueXmlString.append("<sp_name><![CDATA[").append("").append("]]></sp_name>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						rs.close(); //Gulzar - 04/09/08 Req ID :SY89SUN019
						if(pstmt != null)
						{
							pstmt.close();
						}
					}
					else if(currentColumn.trim().equalsIgnoreCase("cust_code"))
					{
						columnValue = genericUtility.getColumnValue(currentColumn,dom);
						String sprsCode = genericUtility.getColumnValue("sprs_code",dom);
						String selSql ="SELECT CUST_NAME,SH_NAME,ADDR1,ADDR2,  ADDR3,  CITY,  STATE_CODE,  PIN,  COUNT_CODE,  STAN_CODE,  TELE1,  TELE2,  TELE3,  TELE_EXT,  FAX ,LOCALITY_CODE FROM CUSTOMER WHERE CUST_CODE = ? ";
						String selSql1 = "SELECT DESCR FROM STATION WHERE STAN_CODE = ?";
						String selSql2 = "SELECT DESCR FROM STATION WHERE STATE_CODE = ?";
						pstmt = connectionObject.prepareStatement(selSql);
						pstmt.setString(1, columnValue);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							custName = checkNull(rs.getString(1));
							shName = checkNull(rs.getString(2));
							addr1 = checkNull(rs.getString(3));
							addr2 = checkNull(rs.getString(4));
							addr3 = checkNull(rs.getString(5));
							city = checkNull(rs.getString(6));
							stateCode = checkNull(rs.getString(7));
							pin = checkNull(rs.getString(8));
							countCode = checkNull(rs.getString(9));
							stanCode = checkNull(rs.getString(10));
							tele1 = checkNull(rs.getString(11));
							tele2 = checkNull(rs.getString(12));
							tele3 = checkNull(rs.getString(13));
							teleExt = checkNull(rs.getString(14));
							fax = checkNull(rs.getString(15));
							locCode = checkNull(rs.getString(16));
						}
						rs.close(); //Gulzar - 04/09/08 Req ID :SY89SUN019
						if(pstmt != null)
						{
							pstmt.close();
						}
						pstmt = connectionObject.prepareStatement(selSql1);
						pstmt.setString(1,stanCode);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							stanCodeDescr = rs.getString(1);
						}
						rs.close(); //Gulzar - 04/09/08 Req ID :SY89SUN019
						if(pstmt != null)
						{
							pstmt.close();
						}
						pstmt = connectionObject.prepareStatement(selSql2);
						pstmt.setString(1,stateCode);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if( rs.next())
						{
							stateCodeDescr = rs.getString(1);
						}
						rs.close(); //Gulzar - 04/09/08 Req ID :SY89SUN019
						if(pstmt != null)
						{
							pstmt.close();
						}
						//String selSql3 =  "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";//Commented by jaimin on 29/05/2008 (SY89SUN001)
						String selSql3 =  "SELECT ROUTE_ID,SH_DESCR FROM SPRS_ROUTE WHERE SPRS_CODE = ? AND LOCALITY_CODE = ?";//Sql changed by jaimin on 29/05/2008 (SY89SUN001)
						System.out.println("SQL :: "+selSql3);//Sql changed by jaimin on 29/05/2008 (SY89SUN001)
						pstmt = connectionObject.prepareStatement(selSql3);
						pstmt.setString(1, sprsCode);
						pstmt.setString(2, locCode);
						//End Changes - Gulzar - 04/09/08 Req ID :SY89SUN019
						rs = pstmt.executeQuery();
						if ( rs.next() )
						{
							routeId = rs.getString(1);
							shDescr = rs.getString(2); //Added by jaimin on 29/05/2008 (SY89SUN001)
							System.out.println("shDescr :: "+shDescr);//Added by jaimin on 29/05/2008 (SY89SUN001)
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							//valueXmlString.append("<route_id>").append(routeId).append("</route_id>\r\n");
							valueXmlString.append("<route_id><![CDATA[").append(routeId).append("]]></route_id>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
							//valueXmlString.append("<sh_descr>").append(shDescr).append("</sh_descr>\r\n");//Added by jaimin on 29/05/2008 (SY89SUN001)
							valueXmlString.append("<sh_descr>").append("<![CDATA["+shDescr+"]]>").append("</sh_descr>\r\n"); //Gulzar - 05/12/2008
						}
						else
						{
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][Start]
							/*valueXmlString.append("<route_id>").append("").append("</route_id>\r\n");
							valueXmlString.append("<sh_descr>").append("").append("</sh_descr>\r\n");*///Added by jaimin on 29/05/2008 (SY89SUN001)
							valueXmlString.append("<route_id><![CDATA[").append("").append("]]></route_id>\r\n");
							valueXmlString.append("<sh_descr><![CDATA[").append("").append("]]></sh_descr>\r\n");
							//Modified By Ganesh [14/05/2013][To set the value in cdata of xml][End]
						}
						rs.close(); //Gulzar - 04/09/08 Req ID :SY89SUN019
						if(pstmt != null)
						{
							pstmt.close();
						}


						//valueXmlString.append("<short_id>").append("").append("</short_id>\r\n"); // Gulzar - 9/18/2008
						/*--Commented and Changes below - Gulzar - 05/12/2008
						valueXmlString.append("<sh_name>").append(shName != null ? shName:"").append("</sh_name>\r\n");
						valueXmlString.append("<addr1>").append(addr1 != null ? addr1:"").append("</addr1>\r\n");
						valueXmlString.append("<addr2>").append(addr2 != null ? addr2:"").append("</addr2>\r\n");
						valueXmlString.append("<addr3>").append(addr3 != null ? addr3:"").append("</addr3>\r\n");
						valueXmlString.append("<city>").append(city != null ? city:"").append("</city>\r\n");
						valueXmlString.append("<state_code>").append(stateCode != null ? stateCode:"").append("</state_code>\r\n");
						valueXmlString.append("<pin>").append(pin != null ? pin:"").append("</pin>\r\n");
						valueXmlString.append("<cust_name>").append(custName != null ? custName:"").append("</cust_name>\r\n");
						valueXmlString.append("<stan_code>").append(stanCode != null ? stanCode:"").append("</stan_code>\r\n");
						valueXmlString.append("<tele1>").append(tele1 != null ? tele1:"").append("</tele1>\r\n");
						valueXmlString.append("<tele2>").append(tele2 != null ? tele2:"").append("</tele2>\r\n");
						valueXmlString.append("<tele3>").append(tele3 != null ? tele3:"").append("</tele3>\r\n");
						valueXmlString.append("<tele_ext>").append(teleExt != null ? teleExt:"").append("</tele_ext>\r\n");
						valueXmlString.append("<fax>").append(fax != null ? fax:"").append("</fax>\r\n");
						valueXmlString.append("<state_descr>").append(stateCodeDescr != null ? stateCodeDescr:"").append("</state_descr>\r\n");
						valueXmlString.append("<station_descr>").append(stanCodeDescr != null ? stanCodeDescr:"").append("</station_descr>\r\n");
						valueXmlString.append("<count_code>").append(countCode != null ? countCode:"").append("</count_code>\r\n");
						*/
						valueXmlString.append("<sh_name>").append("<![CDATA["+(shName != null ? shName:"")+"]]>").append("</sh_name>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<addr1>").append("<![CDATA["+(addr1 != null ? addr1:"")+"]]>").append("</addr1>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<addr2>").append("<![CDATA["+(addr2 != null ? addr2:"")+"]]>").append("</addr2>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<addr3>").append("<![CDATA["+(addr3 != null ? addr3:"")+"]]>").append("</addr3>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<city>").append("<![CDATA["+(city != null ? city:"")+"]]>").append("</city>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<state_code>").append("<![CDATA["+(stateCode != null ? stateCode:"")+"]]>").append("</state_code>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<pin>").append("<![CDATA["+(pin != null ? pin:"")+"]]>").append("</pin>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<cust_name>").append("<![CDATA["+(custName != null ? custName:"")+"]]>").append("</cust_name>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<stan_code>").append("<![CDATA["+(stanCode != null ? stanCode:"")+"]]>").append("</stan_code>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<tele1>").append("<![CDATA["+(tele1 != null ? tele1:"")+"]]>").append("</tele1>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<tele2>").append("<![CDATA["+(tele2 != null ? tele2:"")+"]]>").append("</tele2>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<tele3>").append("<![CDATA["+(tele3 != null ? tele3:"")+"]]>").append("</tele3>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<tele_ext>").append("<![CDATA["+(teleExt != null ? teleExt:"")+"]]>").append("</tele_ext>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<fax>").append("<![CDATA["+(fax != null ? fax:"")+"]]>").append("</fax>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<state_descr>").append("<![CDATA["+(stateCodeDescr != null ? stateCodeDescr:"")+"]]>").append("</state_descr>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<station_descr>").append("<![CDATA["+(stanCodeDescr != null ? stanCodeDescr:"")+"]]>").append("</station_descr>\r\n");//Gulzar - 14/08/08
						valueXmlString.append("<count_code>").append("<![CDATA["+(countCode != null ? countCode:"")+"]]>").append("</count_code>\r\n");//Gulzar - 14/08/08
						//End Changes Gulzar - 05/12/2008
					}
					valueXmlString.append("</Detail>\r\n");
			}
		}
		catch(SQLException se)//Gulzar - 04/09/08 Req ID :SY89SUN019
		{
			System.out.println("Exception: SprsStockist: itemChanged(Document,String): " + se.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(se));
		}
		catch(Exception e)
		{
			System.out.println("Exception :SprsStockist :itemChanged(Document,String):" + e.getMessage() + ":");
			valueXmlString = valueXmlString.append(genericUtility.createErrorString(e));
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( connectionObject != null )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				throw new ITMException(e);
			}
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString + ":********");
		return valueXmlString.toString();
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[EmpITDeclNewServlet] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}
	//Added changes gulzar - 16/08/10 [WS90SUN049]
	private String getHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " +
				  "WHERE A.EMP_CODE = ? " +
				  "AND A.PROFILE_ID = B.PROFILE_ID " +
				  "AND B.APPLICATION = 'MRO' " +
				  "AND B.MENU_ROW = 1 " +
				  "AND B.MENU_COL = 1 " +
				  "AND B.MENU_SUBCOL = 1 " +
				  "AND B.LEVEL_4 = 1 " +
				  "AND B.LEVEL_5 = 1 " +
				  "AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return empCodeHO;
	}
	private String getMGREmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " +
				  "WHERE A.EMP_CODE = ? " +
				  "AND A.GRADE = B.GRADE_CODE " +
				  "AND B.GRADE_TYPE = 'M' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return empCodeMGR;
	}
	//End Added changes gulzar - 16/08/10 [WS90SUN049]

	//Modified by Ramchandra on [10/07/2012] [To check validation for Route Type] [Start]
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String propValue = "";
		String propSql = "";
		Statement stmt1 = null;
		ResultSet rs1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			stmt = conn.createStatement();
			rs = stmt.executeQuery(propSql);
			System.out.println("QUERY::"+propSql);
			if(rs.next())
			{
				propValue = checkNull(rs.getString("PROP_VALUE"));
				isPropFound = true;

			}
			System.out.println("propValue:::"+propValue);
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(propSql1);
				if(rs1.next())
				{
					propValue = checkNull(rs1.getString("PROP_VALUE"));
				}
			}

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if ( stmt != null )
			{
				stmt.close();
				stmt = null;
			}
			if (rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if ( stmt1 != null )
			{
				stmt1.close();
				stmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}
			}
			catch(Exception e1){}
		}
		return propValue;
	}
	//Modified by Ramchandra on [10/07/2012] [To check validation for Route Type] [End]
}
