package ibase.webitm.ejb.wsfa.masters;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.JSONArray;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;



import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.EMail;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.wsfa.transactions.StrgMeetDCRWizard;
import ibase.webitm.notification.ejb.PublishPushNotificationEJB;
import ibase.webitm.notification.ejb.PublishPushNotificationRemote;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.ExceptionUtility;

public class BrandCampaign {
	
	E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
	public String getBrandCompaign( UserInfoBean userInfo )
	{
		System.out.println( "In side the getBrandCompaign " );
		JSONArray getBrandCompaignArr = new JSONArray();

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		String subOrdinateData = "";
		int employeeCount = 1 ;
		//StringBuilder builder = null;
		try
		{
		

			String transDB = checkNull( userInfo.getTransDB() );

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB );
			String userCode = checkNull( userInfo.getLoginCode() );
			String loginEmpCode = checkNull( userInfo.getEmpCode() );
			StringBuilder builder  = new StringBuilder();
			

			StrgMeetDCRWizard strgMeetDCRWizard = new StrgMeetDCRWizard();
			String mgrCode = strgMeetDCRWizard.getMGREmployee(loginEmpCode, conn);
			String itemSer=getItemSer(loginEmpCode, conn);
			if( mgrCode.trim().length() > 0)
			{
				subOrdinateData = getempId(loginEmpCode,conn);
			
			}
			else
			{
				StringBuffer empIdBuff = new StringBuffer();
				subOrdinateData = empIdBuff.append("'").append(loginEmpCode).append("'").toString();
				
			}
			
			System.out.println( "In side the getBrandCompaign mgrCode "+mgrCode );
			System.out.println( "In side the getBrandCompaign subOrdinateData "+subOrdinateData );

			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
			
			
			DateFormat applFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			
			if( mgrCode.trim().length()== 0)
			{
				builder.append(" SELECT STRG_CAMPAIGN.CAMPGN_ID AS CAMPGN_ID,STRG_CAMPAIGN.DESCR AS CAMPGN_DECR, ");
				builder.append(" EFF_FROM,valid_upto + NVL(GRACE_DAYS, 0) AS valid_upto,GRACE_DAYS,valid_upto - eff_from As DIFFERENCE,STRG_CAMPAIGN_DET.BRAND_CODE,BRAND.DESCRIPTION AS BRAND_DESCR ");
				builder.append(" FROM STRG_CAMPAIGN INNER JOIN STRG_CAMPAIGN_DET ON ");
				builder.append(" STRG_CAMPAIGN.CAMPGN_ID = STRG_CAMPAIGN_DET.CAMPGN_ID INNER JOIN BRAND ON ");
				builder.append(" STRG_CAMPAIGN_DET.BRAND_CODE = BRAND.BRAND_CODE ");
				builder.append(" AND STRG_CAMPAIGN.CAMPGN_ID IN (SELECT CAMPGN_ID FROM SPRS_CAMPGN WHERE SPRS_CAMPGN.SALES_PERS =? )  and ? between STRG_CAMPAIGN.EFF_FROM and STRG_CAMPAIGN.VALID_UPTO+ NVL(STRG_CAMPAIGN.GRACE_DAYS, 0) UNION  ");
				builder.append(" SELECT STRG_CAMPAIGN.CAMPGN_ID AS CAMPGN_ID,STRG_CAMPAIGN.DESCR AS CAMPGN_DECR, ");
				builder.append(" EFF_FROM,valid_upto + NVL(GRACE_DAYS, 0) AS valid_upto,GRACE_DAYS,valid_upto - eff_from As DIFFERENCE,STRG_CAMPAIGN_DET.BRAND_CODE,BRAND.DESCRIPTION AS BRAND_DESCR ");
				builder.append(" FROM STRG_CAMPAIGN INNER JOIN STRG_CAMPAIGN_DET ON ");
				builder.append(" STRG_CAMPAIGN.CAMPGN_ID = STRG_CAMPAIGN_DET.CAMPGN_ID INNER JOIN BRAND ON ");
				builder.append(" STRG_CAMPAIGN_DET.BRAND_CODE = BRAND.BRAND_CODE AND BRAND.ACTIVE_YN='Y' and ? between STRG_CAMPAIGN.EFF_FROM and STRG_CAMPAIGN.VALID_UPTO+ NVL(STRG_CAMPAIGN.GRACE_DAYS, 0) AND STRG_CAMPAIGN.ITEM_SER =? order by BRAND_DESCR,CAMPGN_DECR ");
				
			}
			else
			{
				
				builder.append(" SELECT STRG_CAMPAIGN.CAMPGN_ID AS CAMPGN_ID,STRG_CAMPAIGN.DESCR AS CAMPGN_DECR, ");
				builder.append(" EFF_FROM,valid_upto + NVL(GRACE_DAYS, 0) AS valid_upto,GRACE_DAYS,valid_upto - eff_from As DIFFERENCE,STRG_CAMPAIGN_DET.BRAND_CODE,BRAND.DESCRIPTION AS BRAND_DESCR ");
				builder.append(" FROM STRG_CAMPAIGN INNER JOIN STRG_CAMPAIGN_DET ON ");
				builder.append(" STRG_CAMPAIGN.CAMPGN_ID = STRG_CAMPAIGN_DET.CAMPGN_ID INNER JOIN BRAND ON ");
				builder.append(" STRG_CAMPAIGN_DET.BRAND_CODE = BRAND.BRAND_CODE ");
				builder.append(" AND STRG_CAMPAIGN.CAMPGN_ID IN ( SELECT CAMPGN_ID FROM SPRS_CAMPGN WHERE SPRS_CAMPGN.SALES_PERS IN ( SELECT emp_code FROM employee WHERE nvl(status, ' ') <> 'S' and emp_code != ?  START WITH emp_code = ? CONNECT BY PRIOR emp_code = report_to)) and ? between STRG_CAMPAIGN.EFF_FROM and STRG_CAMPAIGN.VALID_UPTO+ NVL(STRG_CAMPAIGN.GRACE_DAYS, 0)  UNION  ");
				builder.append(" SELECT STRG_CAMPAIGN.CAMPGN_ID AS CAMPGN_ID,STRG_CAMPAIGN.DESCR AS CAMPGN_DECR, ");
				builder.append(" EFF_FROM,valid_upto + NVL(GRACE_DAYS, 0) AS valid_upto,GRACE_DAYS,valid_upto - eff_from As DIFFERENCE,STRG_CAMPAIGN_DET.BRAND_CODE,BRAND.DESCRIPTION AS BRAND_DESCR ");
				builder.append(" FROM STRG_CAMPAIGN INNER JOIN STRG_CAMPAIGN_DET ON ");
				builder.append(" STRG_CAMPAIGN.CAMPGN_ID = STRG_CAMPAIGN_DET.CAMPGN_ID INNER JOIN BRAND ON ");
				builder.append(" STRG_CAMPAIGN_DET.BRAND_CODE = BRAND.BRAND_CODE AND BRAND.ACTIVE_YN='Y' and ? between STRG_CAMPAIGN.EFF_FROM and STRG_CAMPAIGN.VALID_UPTO+ NVL(STRG_CAMPAIGN.GRACE_DAYS, 0)  AND STRG_CAMPAIGN.ITEM_SER =?  order by BRAND_DESCR,CAMPGN_DECR ");
				
				
				
				
			}
				pstmt = conn.prepareStatement( builder.toString() );
				if( mgrCode.trim().length()== 0)
				{
					pstmt.setString(1, loginEmpCode);
					pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
					pstmt.setDate(3,java.sql.Date.valueOf(currentDate));
					pstmt.setString(4,itemSer);


				}
				else
				{	
					pstmt.setString(1, loginEmpCode);
					pstmt.setString(2, loginEmpCode);
					pstmt.setDate(3,java.sql.Date.valueOf(currentDate));
					pstmt.setDate(4,java.sql.Date.valueOf(currentDate));
					pstmt.setString(5,itemSer);

				}
				
				rs = pstmt.executeQuery();
				int count  = 1;
				String campaignId = "";
				String brandCode = "";

				int prCount = 0 ;
				int drCount = 0 ;
				
				while( rs.next() )
				{

					JSONObject jsonObject = getJSONObject();
					
					jsonObject.put("ACTUAL_VALUE", "50");
					jsonObject.put("ACT_PRD_CODE", "202011");
					
					Date effDate = rs.getDate( "EFF_FROM" );
					String effDateStr = "";
					if ( effDate != null )
					{
						effDateStr = applFormat.format( effDate );
					}

					Date validDate = rs.getDate( "VALID_UPTO" );
					String validDateStr = "";
					if ( validDate != null )
					{
						validDateStr = applFormat.format( validDate );
					}
					
					campaignId = rs.getString( "CAMPGN_ID" ) ;
					brandCode = rs.getString( "BRAND_CODE" ) ;

					if( mgrCode.trim().length() > 0)
					{
						employeeCount = getEmployeeCount ( loginEmpCode,campaignId, conn);
					}
					
					
					jsonObject.put("EFF_FROM", effDateStr);
					jsonObject.put("VALID_UPTO", validDateStr);
					jsonObject.put("NOMR", employeeCount);
					jsonObject.put("DIFFERENCE", rs.getString( "DIFFERENCE" ));
					jsonObject.put("GRACE_DAYS", rs.getString( "GRACE_DAYS" ));
					jsonObject.put("BRAND_DESCR", rs.getString( "BRAND_DESCR" ));
					jsonObject.put("ICON", "tag.svg");
					jsonObject.put("LAST_DCR_DATE", "");
					jsonObject.put("LINK_METADATA", "So-Brand-Campaign");
					jsonObject.put("MGR_SUB", "9006");
					jsonObject.put("PRD_CODE", "202012");
					jsonObject.put("THEME_COLOR", "white");
					jsonObject.put("COMPIGN_DESCR", rs.getString( "CAMPGN_DECR" ) );
					jsonObject.put("CAMPGN_ID", campaignId );
					jsonObject.put("BRAND_CODE", rs.getString( "BRAND_CODE" ) );
					
					
					prCount = getPrCount(campaignId, subOrdinateData,brandCode ,conn );
					drCount = getDrCount(campaignId, subOrdinateData,brandCode ,conn );
					
					LinkedHashMap getDrCountEachCampaign = new LinkedHashMap();
					 
					if( mgrCode.trim().length() > 0)
					{
						getDrCountEachCampaign =  getDrCountEachCampaignMgr ( campaignId, subOrdinateData,brandCode ,conn );
					}
					else
					{
						getDrCountEachCampaign =  getDrCountEachCampaign ( campaignId, subOrdinateData,brandCode ,conn );
					}
                    LinkedHashMap getPrCountEachCampaign = getPrCountEachCampaign ( campaignId, subOrdinateData,brandCode ,conn );
                    
                    ArrayList transactionDates = getTranDateFromEachCampaign( campaignId, subOrdinateData,brandCode ,conn );
                    JSONArray getDataJSONArray = getDataJSONArray(getDrCountEachCampaign, getPrCountEachCampaign, transactionDates);
					jsonObject.put("COUNTDR", drCount);
					jsonObject.put("COUNTPR", prCount );

//					if (count == 1)
//					{	
						
						jsonObject.put("SALESPER", "1313");
						if ( drCount != 0 )
						{	
							jsonObject.put("DRCOUNT",getDataJSONArray.get(1));
							jsonObject.put("LABLES", getDataJSONArray.get(0));
						}
						else
						{
							jsonObject.put("DRCOUNT","[]");
						}
						
						if ( prCount != 0 )
						{	
							jsonObject.put("PRCOUNT", getDataJSONArray.get(2));
							jsonObject.put("LABLES", getDataJSONArray.get(0));
						}
						else
						{
							jsonObject.put("PRCOUNT","[]");
						}
						
//					}
//					if (count == 2)
//					{	
//						jsonObject.put("SALESPER", "1313");
//						if ( drCount != 0 )
//						{
//							jsonObject.put("DRCOUNT","[5,10,17,20]");
//						}
//						else
//						{
//							jsonObject.put("DRCOUNT","[]");
//						}
//						
//						if ( prCount != 0 )
//						{
//							jsonObject.put("PRCOUNT", "[100,200,250,400]");
//						}
//						else
//						{
//							jsonObject.put("PRCOUNT","[]");
//						}
//					}
//					if (count == 3)
//					{	
//						
//						jsonObject.put("SALESPER", "1313");
//						if ( drCount != 0 )
//						{
//							jsonObject.put("DRCOUNT","[15,26,41,50]");
//						}
//						else
//						{
//							jsonObject.put("DRCOUNT","[]");
//						}
//						
//						if ( prCount != 0 )
//						{
//							jsonObject.put("PRCOUNT", "[90,150,350,500]");
//						}
//						else
//						{
//							jsonObject.put("PRCOUNT","[]");
//						}
//					}
					
					
					

					getBrandCompaignArr.add( jsonObject );
					count++;

				}

				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				
			System.out.println( "getBrandCompaignArr : ["+ getBrandCompaignArr +"]" );
		}
		catch(Exception e)
		{
			System.out.println(" getBrandCompaign : "+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return getBrandCompaignArr.toString();
	}
	//Added by Nilesh Gunjal on 05/02/21 [to get the jsonObject from the Brand Compaign] END
	
	
	
	public String getBrandCompaignSO( UserInfoBean userInfo,String brandCode , String campainId )
	{
		System.out.println( "In side the getBrandCompaignSO changed Nil " );
		JSONArray getBrandCompaignArr = new JSONArray();

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		StringBuilder builder = null;
		String subOrdinateData = "";
		float prCount = 0 ;
		float drCount = 0 ;
		String campaignId = "";
		String brandCodes="";
		String salesPers ="";
		String salesPersNew ="";
		try
		{
		

			String transDB = checkNull( userInfo.getTransDB() );

			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB );
			String userCode = checkNull( userInfo.getLoginCode() );
			String loginEmpCode = checkNull( userInfo.getEmpCode() );
			builder = new StringBuilder();
			
			StrgMeetDCRWizard strgMeetDCRWizard = new StrgMeetDCRWizard();
			String mgrCode = strgMeetDCRWizard.getMGREmployee(loginEmpCode, conn);
			
			JSONObject getBrandCompaignRankingRegion = getRankingRegionEmpCodeWise( conn,mgrCode );
			
			
			if( mgrCode.trim().length() > 0)
			{
				subOrdinateData = getempId(loginEmpCode,conn);
			}
			else
			{
				StringBuffer empIdBuff = new StringBuffer();
				subOrdinateData = empIdBuff.append("'").append(loginEmpCode).append("'").toString();
			}
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
			
			if( mgrCode.trim().length() == 0)
			{
			
				builder.append(" SELECT 'WHITE' AS THEME_COLOR, A.EMP_CODE   AS SALES_PERS, ");
				builder.append(" TRIM(A.EMP_FNAME)|| ' '|| SUBSTR(TRIM(A.EMP_MNAME), 1, 1)|| ' '|| TRIM(A.EMP_LNAME) SALES_PERS_NAME, ");
				builder.append(" B.SH_DESCR   AS GRADE, GRADE_CODE,STRG_CAMPAIGN_DET.BRAND_CODE,STRG_CAMPAIGN.CAMPGN_ID ");
				builder.append(" FROM EMPLOYEE   A, GRADE      B,");
				builder.append(" STRG_CAMPAIGN INNER JOIN STRG_CAMPAIGN_DET ON STRG_CAMPAIGN.CAMPGN_ID = STRG_CAMPAIGN_DET.CAMPGN_ID INNER JOIN BRAND ON  ");
				builder.append(" STRG_CAMPAIGN_DET.BRAND_CODE = BRAND.BRAND_CODE AND STRG_CAMPAIGN.CAMPGN_ID IN (SELECT CAMPGN_ID FROM SPRS_CAMPGN WHERE SPRS_CAMPGN.SALES_PERS  IN ( SALES_PERS ))");
				builder.append(" WHERE A.EMP_CODE IN ( SELECT EMP_CODE FROM EMPLOYEE WHERE NVL(STATUS, ' ') <> 'S' START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO) ");
				builder.append(" AND A.GRADE = B.GRADE_CODE AND STRG_CAMPAIGN.CAMPGN_ID IN (SELECT CAMPGN_ID FROM SPRS_CAMPGN WHERE SPRS_CAMPGN.SALES_PERS IN (A.EMP_CODE)) and ? between STRG_CAMPAIGN.EFF_FROM and STRG_CAMPAIGN.VALID_UPTO+ NVL(STRG_CAMPAIGN.GRACE_DAYS, 0) ");
				builder.append(" UNION  ");
				builder.append(" SELECT 'WHITE' AS theme_color,a.emp_code   AS sales_pers,TRIM(a.emp_fname) || ' ' || substr(TRIM(a.emp_mname), 1, 1) || ' '|| TRIM(a.emp_lname) sales_pers_name,");
				builder.append(" b.sh_descr   AS grade, grade_code, '"+brandCode+"' as brand_code, '"+campainId+"' as campgn_id FROM employee a, grade b ");
				builder.append(" WHERE a.emp_code  IN ( SELECT emp_code FROM employee WHERE nvl(status, ' ') <> 'S' START WITH emp_code = ? ");
				builder.append(" CONNECT BY PRIOR emp_code = report_to ) AND a.grade = b.grade_code ");
				

			}
			else
			{
				
				builder.append(" SELECT 'WHITE' AS THEME_COLOR, A.EMP_CODE   AS SALES_PERS, ");
				builder.append(" TRIM(A.EMP_FNAME)|| ' '|| SUBSTR(TRIM(A.EMP_MNAME), 1, 1)|| ' '|| TRIM(A.EMP_LNAME) SALES_PERS_NAME, ");
				builder.append(" B.SH_DESCR   AS GRADE, GRADE_CODE,STRG_CAMPAIGN_DET.BRAND_CODE,STRG_CAMPAIGN.CAMPGN_ID ");
				builder.append(" FROM EMPLOYEE   A, GRADE      B,");
				builder.append(" STRG_CAMPAIGN INNER JOIN STRG_CAMPAIGN_DET ON STRG_CAMPAIGN.CAMPGN_ID = STRG_CAMPAIGN_DET.CAMPGN_ID INNER JOIN BRAND ON  ");
				builder.append(" STRG_CAMPAIGN_DET.BRAND_CODE = BRAND.BRAND_CODE AND STRG_CAMPAIGN.CAMPGN_ID IN (SELECT CAMPGN_ID FROM SPRS_CAMPGN WHERE SPRS_CAMPGN.SALES_PERS  IN ( SALES_PERS ))");
				builder.append(" WHERE A.EMP_CODE IN ( SELECT EMP_CODE FROM EMPLOYEE WHERE NVL(STATUS, ' ') <> 'S' and emp_code != ? START WITH EMP_CODE = ? CONNECT BY PRIOR EMP_CODE = REPORT_TO) ");
				builder.append(" AND A.GRADE = B.GRADE_CODE AND STRG_CAMPAIGN.CAMPGN_ID IN (SELECT CAMPGN_ID FROM SPRS_CAMPGN WHERE SPRS_CAMPGN.SALES_PERS IN (A.EMP_CODE)) and ? between STRG_CAMPAIGN.EFF_FROM and STRG_CAMPAIGN.VALID_UPTO+ NVL(STRG_CAMPAIGN.GRACE_DAYS, 0) ");
				//builder.append(" ORDER BY TRIM(A.EMP_FNAME) || '  ' || TRIM(A.EMP_LNAME) ");
				builder.append(" UNION  ");
				builder.append(" SELECT 'WHITE' AS theme_color,a.emp_code   AS sales_pers,TRIM(a.emp_fname) || ' ' || substr(TRIM(a.emp_mname), 1, 1) || ' '|| TRIM(a.emp_lname) sales_pers_name,");
				builder.append(" b.sh_descr   AS grade, grade_code, '"+brandCode+"' as brand_code, '"+campainId+"' as campgn_id FROM employee   a, grade      b ");
				builder.append(" WHERE a.emp_code  IN ( SELECT emp_code FROM employee WHERE nvl(status, ' ') <> 'S' and emp_code != ? START WITH EMP_CODE = ? ");
				builder.append(" CONNECT BY PRIOR emp_code = report_to ) AND a.grade = b.grade_code  ");
				
				
			}
			
				pstmt = conn.prepareStatement( builder.toString() );
				
				if( mgrCode.trim().length()== 0)
				{
					pstmt.setString(1, loginEmpCode);
					pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
					pstmt.setString(3, loginEmpCode);

				}
				else
				{	
					pstmt.setString(1, loginEmpCode);
					pstmt.setString(2, loginEmpCode);
					pstmt.setDate(3,java.sql.Date.valueOf(currentDate));
					pstmt.setString(4, loginEmpCode);
					pstmt.setString(5, loginEmpCode);

				}
				
				rs = pstmt.executeQuery();
				int recordCount = 0 ;
				String checkSales ="";
				while( rs.next() )
				{

					JSONObject jsonObject;
					try 
					{
						
							jsonObject = getJSONObject();
							
							salesPers = checkNull(rs.getString( "SALES_PERS" ) );
							
							if( ! checkSales.equalsIgnoreCase(salesPers) )
							{
								recordCount ++;
								jsonObject.put("RECORD_COUNT", recordCount);
							}
							else
							{
								jsonObject.put("RECORD_COUNT", recordCount);
							}
							checkSales = salesPers;
							

							if( mgrCode.trim().length() == 0)
							{
								jsonObject.put("ISMGR", false);
							}
							else
							{
								jsonObject.put("ISMGR", true);
							}
							
								
							StringBuffer empIdBuff = new StringBuffer();
							String salesPersData = empIdBuff.append("'").append(salesPers).append("'").toString();
							salesPersNew = salesPersData.toString();

							campaignId = checkNull(rs.getString( "CAMPGN_ID" )) ;
							brandCodes = checkNull(rs.getString( "BRAND_CODE" )) ;

							
							jsonObject.put("ACTUAL_VALUE", "50");
							jsonObject.put("ACT_PRD_CODE", "202011");
							jsonObject.put("DESCR", checkNull(rs.getString( "SALES_PERS_NAME" )));
							jsonObject.put("LAST_DCR_DATE", "");
							jsonObject.put("LINK_METADATA", "Brand-Doctor");
							jsonObject.put("THEME_COLOR", "white");
							jsonObject.put("CAMPGN_ID",campaignId );
							jsonObject.put("BRAND_CODE", checkNull(rs.getString( "BRAND_CODE" )) );
							jsonObject.put("GRADE", checkNull(rs.getString( "GRADE" )));
							
	
							prCount = getPrCount(campaignId, salesPersNew,brandCodes ,conn );
							drCount = getDrCount(campaignId, salesPersNew,brandCodes ,conn );
							
							
							LinkedHashMap getDrCountEachCampaign =  getDrCountEachCampaign ( campaignId, salesPersNew,brandCodes ,conn );
                            LinkedHashMap getPrCountEachCampaign = getPrCountEachCampaign ( campaignId, salesPersNew,brandCodes ,conn );
                            
                            ArrayList transactionDates = getTranDateFromEachCampaign( campaignId, subOrdinateData,brandCode ,conn );
                            JSONArray getDataJSONArray = getDataJSONArray(getDrCountEachCampaign, getPrCountEachCampaign, transactionDates);
					        
							
							//System.out.println( "getPrCountEachCampaign ***  : ["+ getPrCountEachCampaign +"]" );
							//System.out.println( "getDrCountEachCampaign drCount : ["+ getDrCountEachCampaign +"]" );
							jsonObject.put("COUNTDR", drCount);
							jsonObject.put("COUNTPR", prCount );
							
							//System.out.println( "getBrandCompaignArr prCount : ["+ prCount +"]" );
                            //System.out.println( "getBrandCompaignArr drCount : ["+ drCount +"]" );
							
							if ( drCount !=0 )
							{
								jsonObject.put("DRCOUNT",getDataJSONArray.get(1));
								jsonObject.put("LABLES", getDataJSONArray.get(0));
							}
							if ( prCount !=0 )
							{
								jsonObject.put("PRCOUNT", getDataJSONArray.get(2));
								jsonObject.put("LABLES", getDataJSONArray.get(0));
							}
							
	
							if ( drCount !=0 &&  prCount !=0)
							{
								double avgRx =  prCount/drCount;
								jsonObject.put("AVGRX", String.format("%.2f", avgRx) );
							}
							else
							{
								jsonObject.put("AVGRX","0" );
								
							}
							
//							String salesPersNew = genericUtility.checkNull( rs.getString( "SALES_PERS" ) );
							jsonObject.put("SALESPER", salesPers );
							
							//System.out.println( " getBrandCompaignRankingRegion.BEFORE : ["+ getBrandCompaignRankingRegion.get("SEQ_COUNT_+"+salesPers+"") +"]" );
	
							try {
								if ( getBrandCompaignRankingRegion.get("EMPCODE_+"+salesPers+"")!=null  )
								{
									if (getBrandCompaignRankingRegion.get("EMPCODE_+"+salesPers+"").equals(salesPers) )
									{	
										jsonObject.put("REGION",getRankingSalesPersonCart(userInfo, salesPers, "REGION"));
										jsonObject.put("ZONAL", getRankingSalesPersonCart(userInfo, salesPers, "ZONAL"));
										jsonObject.put("ALLINDIA", getRankingSalesPersonCart(userInfo, salesPers, "ALLINDIA"));
									}	
											
								}
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
								
								jsonObject.put("REGION",0);
								jsonObject.put("ZONAL",0);
								jsonObject.put("ALLINDIA",0);
								//getBrandCompaignArr.add( jsonObject );
							}
							getBrandCompaignArr.add( jsonObject );
						} catch (Exception e) {
							
							System.out.println( "getBrandCompaignArr Exception : ["+ e +"]" );
							e.printStackTrace();
					}
					
				
				
				}

				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				
			
			System.out.println( "getBrandCompaignArr 225 : ["+ getBrandCompaignArr +"]" );
		}
		catch(Exception e)
		{
			System.out.println( " getBrandCompaignSO: "+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
			}
		}
		return getBrandCompaignArr.toString();
	}
	
	
	public String getBrandCompaignDoctor( UserInfoBean userInfo ,String brandCode, String campgnID , String salperon,String uri )
	{
		System.out.println( "In side the getBrandCompaign getBrandCompaignDoctor Changd " );
		JSONArray getBrandCompaignArr = new JSONArray();
		
		String doctorDetailString = "";
		String doctorsql="";
		int currentFormNo = 0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String doctorName="";
		String localityDescr ="";
		String localityCode="";
		String speciality = "";
		String qualification="";
		String tranIdSql="",strgCodeSql="";
		String presctranId="", doctorTranId="";
		String selStrgCode="";
		String selBrandCode="";
		String strgCode="";
		String brandDescr="";
		String classCode="";
		String stateDesc="";
		String selDoctors ="";
		String doctranIdSql="";
		HashMap selStrgCodeMap = new HashMap();
		StringBuffer valueXmlString = new StringBuffer();
		
		StringBuffer custBuff = new StringBuffer();
		String customers="";
		int lineNum=1;
		Connection conn = null;
		StringBuilder builderMaxTranId = new StringBuilder();
		StringBuilder maxIdBuff = new StringBuilder();
	    String maxId = "";
	    String maxIdComma = "";
		try 
		{
			//valueXmlString.append( "<Root>\r\n" );
			E12GenericUtility genericUtility = new E12GenericUtility();
			int domID = 1;
			
			String transDB = checkNull( userInfo.getTransDB() );
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB );
			
			doctranIdSql="select max(SC.tran_id)  as tran_id from STRG_CAMPAIGN,SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCMPS "
					+ " where SC.tran_date  between strg_campaign.eff_from and strg_campaign.valid_upto+NVL(strg_campaign.GRACE_DAYS, 0) and strg_campaign.campgn_id=SC.campgn_id "
					+ "and SC.sales_pers = ? and SC.tran_type= ? and SC.campgn_id=? AND SC.tran_id=SCMPS.tran_id AND SCMPS.BRAND_CODE=?";  // adding campaignId 3032021 issue raised by qc then changes
			pstmt =  conn.prepareStatement(doctranIdSql);
			
			
			pstmt.setString(1, salperon);
            pstmt.setString(2, "D");
            pstmt.setString(3,campgnID);       
            pstmt.setString(4,brandCode);    

			rs = pstmt.executeQuery();
			if (rs.next())                           
			{
				doctorTranId=checkNull(rs.getString("tran_id"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
            
            //brandCode = checkNull(genericUtility.getColumnValue("brand_code",dom1));
            //System.out.println("getDoctorDetail brandCode:::["+brandCode+"]");
            
//            tranIdSql="select max(tran_id) as tran_id from SPRS_CAMPGN where tran_date =(select max(SP.tran_date) from SPRS_CAMPGN SP, STRG_CAMPAIGN ST where SP.CAMPGN_ID = ST.CAMPGN_ID and SP.tran_date between ST.eff_from and ST.valid_upto and SP.sales_pers =? ) and sales_pers = ? AND TRAN_TYPE='P' ";
//            
//            pstmt =  conn.prepareStatement(tranIdSql);
//			pstmt.setString(1,  checkNull( userInfo.getEmpCode() ));
//			pstmt.setString(2,  checkNull( userInfo.getEmpCode() ));
//			rs = pstmt.executeQuery();
//			if (rs.next())                           
//			{
//				presctranId=checkNull(rs.getString("tran_id"));
//				System.out.println("presctranId="+presctranId);
//			}
//			if (rs!= null)
//			{
//				rs.close();
//				rs = null;
//			}
//			if(pstmt!=null)
//			{
//				pstmt.close();
//				pstmt = null;
//			}
//            
//			 doctranIdSql="select max(tran_id) as tran_id from SPRS_CAMPGN where tran_date =(select max(SP.tran_date) from SPRS_CAMPGN SP, STRG_CAMPAIGN ST where SP.CAMPGN_ID = ST.CAMPGN_ID and SP.tran_date between ST.eff_from and ST.valid_upto and SP.sales_pers =? ) and sales_pers = ? AND TRAN_TYPE='D' ";
//	            
//	            pstmt =  conn.prepareStatement(doctranIdSql);
//				pstmt.setString(1,  checkNull( userInfo.getEmpCode() ));
//				pstmt.setString(2,  checkNull( userInfo.getEmpCode() ));
//				rs = pstmt.executeQuery();
//				if (rs.next())                           
//				{
//					doctorTranId=checkNull(rs.getString("tran_id"));
//					System.out.println("doctorTranId="+doctorTranId);
//				}
//				if (rs!= null)
//				{
//					rs.close();
//					rs = null;
//				}
//				if(pstmt!=null)
//				{
//					pstmt.close();
//					pstmt = null;
//				}
//			
//			strgCodeSql="SELECT STRG_CODE, BRAND_CODE FROM SPRS_CAMPGN_STRG WHERE TRAN_ID =?";
//			pstmt =  conn.prepareStatement(strgCodeSql);
//			pstmt.setString(1, presctranId);
//			rs = pstmt.executeQuery();
//			while(rs.next())
//			{
//				selStrgCode=checkNull(rs.getString("STRG_CODE"));
//				selBrandCode=checkNull(rs.getString("BRAND_CODE"));
//				System.out.println("getCustomerDetail selStrgCode.........["+selStrgCode+"]");
//				System.out.println("getCustomerDetail brand Code..........["+selBrandCode+"]");
//				selStrgCodeMap.put(selStrgCode, selBrandCode);
//				
//				if( custBuff.length() == 0)
//				{
//					custBuff.append("'").append( selStrgCode ).append("'");
//				}
//				else
//				{
//					custBuff.append(",'").append( selStrgCode ).append("'");
//				}
//				selDoctors=custBuff.toString();
//			}
//			if (rs!= null)
//			{
//				rs.close();
//				rs = null;
//			}
//			if(pstmt!=null)
//			{
//				pstmt.close();
//				pstmt = null;
//			}
//			System.out.println("selDoctors::"+selDoctors);
//			if( customers == "" || customers == null)
//			{
//				customers = "'x'";
//			}
//			//customers = "'x'";
//			/*doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
//				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
//				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY," +
//				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT(STRG.STRG_CODE) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
//				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
//				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
//				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+customers+"))A WHERE A.ROWNO=1 " +
//				    " UNION" +
//				    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
//				    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
//				    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
//				    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT(STRG.STRG_CODE) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
//				    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
//				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
//				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+customers+"))B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
//		
//			*/
//			
//			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
//				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT, a.campgn_id AS campaignid,a.brand_code AS brandcode, a.sales_pers FROM" +
//				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY," +
//				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE,sp.campgn_id,strg.brand_code, sp.sales_pers, FN_GET_RX_COUNT(STRG.STRG_CODE) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
//				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
//				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
//				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y'  AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS IN ( SELECT emp_code FROM employee WHERE nvl(status, ' ') <> 'S' START WITH emp_code = ? CONNECT BY PRIOR emp_code = report_to) AND STRG.STRG_CODE NOT IN("+customers+"))A WHERE A.ROWNO=1 " ;
//				   
//			
//
//			pstmt =  conn.prepareStatement( doctorsql );
//			
//			pstmt.setString(1, campgnID);
//			pstmt.setString(2, checkNull( userInfo.getEmpCode() ));
//
//		
//			rs = pstmt.executeQuery();
//			
//			
//			while(rs.next())
//			{
//				JSONObject jsonObject = getJSONObject();
////				strgCode = checkNull(rs.getString("STRG_CODE")) ;
////				doctorName = checkNull(rs.getString("SC_NAME")) ;
////				localityCode = checkNull(rs.getString("LOCALITY")) ;
////				localityDescr = checkNull(rs.getString("DESCR")) ;
////				speciality = checkNull(rs.getString("SPECIALITY")) ;
////				qualification = checkNull(rs.getString("QUALIFICATION")) ;
////				classCode = checkNull(rs.getString("CLASS_CODE")) ;
////				stateDesc = checkNull(rs.getString("STATE")) ;
//				
//				//System.out.println("selStrgCodeMap:::["+selStrgCodeMap+"]");
//				//System.out.println("strgCode:::["+strgCode+"]");
//				
//				if(selStrgCodeMap != null &&  selStrgCodeMap.containsKey(strgCode))
//				{
//					brandCode = (String)selStrgCodeMap.get(strgCode);
//					brandDescr = getBrandDescr(brandCode, conn);
//					
//					String scCode = genericUtility.checkNull( rs.getString( "STRG_CODE" ) );
//					String docName = genericUtility.checkNull( rs.getString( "SC_NAME" ) );
//					
//					String customImageSrc = getCustomImageURL("STRG_CUSTOMER", "StrgCustomer", scCode, docName, "Icon",uri);
//					
//					System.out.println(" customImageSrc 646 "+customImageSrc);
//					
//					jsonObject.put("CUSTOMERIMAGESRC", customImageSrc);
//					
////					valueXmlString.append( "<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
////					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
////					valueXmlString.append("<cust_name><![CDATA[").append(doctorName).append("]]></cust_name>\r\n");
////					valueXmlString.append("<line_no><![CDATA[").append(lineNum).append("]]></line_no>\r\n");
////					valueXmlString.append("<locality_code><![CDATA[").append(localityCode).append("]]></locality_code>\r\n");
////					valueXmlString.append("<locality_descr><![CDATA[").append(localityDescr).append("]]></locality_descr>\r\n");
////					valueXmlString.append("<speciality><![CDATA[").append(speciality).append("]]></speciality>\r\n");
////					valueXmlString.append("<qualification><![CDATA[").append(qualification).append("]]></qualification>\r\n");
////					valueXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
////					valueXmlString.append( "<brand_code><![CDATA[").append(brandCode).append("]]></brand_code>\r\n");
////					valueXmlString.append( "<description><![CDATA[").append(brandDescr).append("]]></description>\r\n");
////					valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
////					valueXmlString.append( "<state_descr><![CDATA[").append(stateDesc).append("]]></state_descr>\r\n");
////					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
////					valueXmlString.append( "<rx_cnt><![CDATA[").append(rxCnt).append("]]></rx_cnt>\r\n");
////					//valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
//					
//					
//					jsonObject.put("STRG_CODE", rs.getString( "STRG_CODE" ));					
//					jsonObject.put("SC_NAME", rs.getString( "SC_NAME" ));
//					jsonObject.put("QUALIFICATION", rs.getString( "QUALIFICATION" ));
//					jsonObject.put("SPECIALITY", rs.getString( "SPECIALITY" ));
//					jsonObject.put("LOCALITY",  rs.getString( "LOCALITY" ));
//					jsonObject.put("DESCR",  rs.getString( "DESCR" ));
//					jsonObject.put("CLASS_CODE", rs.getString( "CLASS_CODE" ) );
//					jsonObject.put("STATE_DESCR", rs.getString( "STATE_DESCR" ) );
//					jsonObject.put("RX_CNT", rs.getString( "RX_CNT" ) );
//					jsonObject.put("CAMPGN_ID", campgnID );
//					jsonObject.put("BRAND_CODE", brandCode);
//					jsonObject.put("SALESPER",checkNull( rs.getString( "sales_pers" ) ));
//					
//					getBrandCompaignArr.add( jsonObject );
//					domID++;
//					lineNum++;
//				}
//				
//			}
//			
//			rs.close();
//			rs = null;
//			pstmt.close();
//			pstmt = null;
//			
//			
//			//System.out.println("selDoctors before ::"+selDoctors);
//			if( selDoctors == "" || selDoctors == null)
//			{
//				selDoctors = "'x'";
//			}
//			
//			System.out.println("getBrandCompaignArr=["+getBrandCompaignArr.toString()+"]");
//			System.out.println("customers after=["+selDoctors+"]");
			
			
//			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
//				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
//				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY," +
//				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT(STRG.STRG_CODE) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
//				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
//				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
//				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+"))A WHERE A.ROWNO=1 " +
//				    " UNION" +
//				    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
//				    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
//				    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
//				    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT(STRG.STRG_CODE) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
//				    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
//				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
//				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID = ? AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+"))B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
//		
			
		
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
		
			builderMaxTranId.append(" select max(sprs_campgn_items.tran_id) As maxTranId,sprs_campgn.tran_date from sprs_campgn inner join sprs_campgn_items on sprs_campgn.tran_id = sprs_campgn_items.tran_id ,STRG_CAMPAIGN  ");
			builderMaxTranId.append(" where sprs_campgn.campgn_id = ? and sprs_campgn.tran_type = 'P' AND STRG_CAMPAIGN.CAMPGN_ID=SPRS_CAMPGN.CAMPGN_ID AND sprs_campgn.SALES_PERS IN ('"+salperon+"')  ");
			builderMaxTranId.append(" AND sprs_campgn_items.ITEM_CODE IN(SELECT ITEM_CODE FROM ITEM WHERE BRAND_CODE= ? )   ");
			builderMaxTranId.append(" AND ? BETWEEN STRG_CAMPAIGN.EFF_FROM AND STRG_CAMPAIGN.valid_upto+NVL(STRG_CAMPAIGN.GRACE_DAYS, 0) group by sprs_campgn.tran_date ");
		
			pstmt = conn.prepareStatement(builderMaxTranId.toString());
	
			pstmt.setString(1, campgnID);
			pstmt.setString(2, brandCode);
			pstmt.setDate(3,java.sql.Date.valueOf(currentDate));
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				maxId = genericUtility.checkNull( rs.getString("maxTranId") ) ;
				maxIdBuff.append(",'").append(maxId).append("'");
			}
			if ( maxIdBuff.length() > 0 && maxIdBuff!=null )
			{
				
				maxIdComma = maxIdBuff.toString().substring(1);
			}
			else
			{
				maxIdComma = "''";
			}
			
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			strgCodeSql="SELECT STRG_CODE, BRAND_CODE FROM SPRS_CAMPGN_STRG WHERE TRAN_ID IN ("+maxIdComma+") ";
			pstmt =  conn.prepareStatement(strgCodeSql);
            //pstmt.setString(1,brandCode);       

			rs = pstmt.executeQuery();
			while(rs.next())
			{
				selStrgCode=checkNull(rs.getString("STRG_CODE"));
				selBrandCode=checkNull(rs.getString("BRAND_CODE"));
				if( custBuff.length() == 0)
				{
					custBuff.append("'").append( selStrgCode ).append("'");
				}
				else
				{
					custBuff.append(",'").append( selStrgCode ).append("'");
				}
				selDoctors=custBuff.toString();
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			if( selDoctors == "" || selDoctors == null)
			{
				selDoctors = "'x'";
			}


//			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
//				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT,   a.campgn_id  AS campaignid,a.brand_code      AS brandcode,a.sales_pers  FROM" +
//				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY," +
//				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE,sp.campgn_id,strg.brand_code, FN_GET_RX_COUNT_CAMPAIGNWISE( strg.strg_code , sp.campgn_id , sp.sales_pers,strg.brand_code,strg.tran_id ) AS RX_CNT, sp.sales_pers, ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
//				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
//				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
//				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y'  AND SP.CAMPGN_ID = ? AND STRG.brand_code=? AND SP.TRAN_TYPE ='D'  AND SP.SALES_PERS IN ( SELECT emp_code FROM employee WHERE nvl(status, ' ') <> 'S' START WITH emp_code = ? CONNECT BY PRIOR emp_code = report_to) ) A WHERE A.ROWNO=1 " ;
//
			/* backup sql comment by prachi
			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY," +
				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,sp.tran_id) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID IN ('"+doctorTranId+"') AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+") )A WHERE A.ROWNO=1 " +
				    " UNION" +
				    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
				    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
				    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
				    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,sp.tran_id) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
				    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID IN ("+maxIdComma+") AND SP.CAMPGN_ID = ?   AND strg.brand_code = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND  sp.tran_id IN ("+maxIdComma+") )B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
		*/
			doctorsql = " SELECT A.STRG_CODE AS STRG_CODE,A.SC_NAME AS SC_NAME,A.QUALIFICATION AS QUALIFICATION,A.Speciality  AS Speciality,A.CATEGORY AS CATEGORY,A.LOCALITY As LOCALITY,A.DESCR AS DESCR,"   +
				    " A.CLASS_CODE AS CLASS_CODE,A.STATE AS STATE,A.RX_CNT AS RX_CNT FROM" +
				    " (SELECT STRG.STRG_CODE AS STRG_CODE,UPPER(SC.FIRST_NAME)||' ' ||UPPER(SC.MIDDLE_NAME)||' ' ||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY," +
				    " SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID,SR.DESCR,SC.CLASS_CODE,S.DESCR AS STATE, FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,sp.tran_id) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO" +
				    " FROM SPRS_CAMPGN_STRG STRG,SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE, LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE"+
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE =STRG.STRG_CODE AND L.LOCALITY_CODE = SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID IN ('"+doctorTranId+"') AND SP.CAMPGN_ID = ? AND SP.TRAN_TYPE ='D' AND SP.SALES_PERS = ? AND STRG.STRG_CODE NOT IN("+selDoctors+") )A WHERE A.ROWNO=1 " +
				    " UNION" +
				    " SELECT B.STRG_CODE AS STRG_CODE, B.SC_NAME AS SC_NAME,B.QUALIFICATION AS QUALIFICATION, B.SPECIALITY AS SPECIALITY,B.CATEGORY AS CATEGORY,B.LOCALITY AS LOCALITY,B.DESCR AS DESCR,B.CLASS_CODE AS CLASS_CODE," +
				    " B.STATE AS STATE, B.RX_CNT AS RX_CNT FROM" +
				    " (SELECT DISTINCT(STRG.STRG_CODE), UPPER(SC.FIRST_NAME)||' '||UPPER(SC.MIDDLE_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME,SC.QUALIFICATION,SP.DESCR AS SPECIALITY,SS.CATEGORY AS CATEGORY,SC.LOCALITY_CODE AS LOCALITY, SS.ROUTE_ID," +
				    " SR.DESCR, SC.CLASS_CODE, S.DESCR  AS STATE,FN_GET_RX_COUNT_CAMPAIGNWISE(STRG.STRG_CODE,SP.CAMPGN_ID,SP.SALES_PERS,STRG.BRAND_CODE,sp.tran_id) AS RX_CNT,ROW_NUMBER() OVER(PARTITION BY STRG.STRG_CODE ORDER BY SS.ROUTE_ID) AS ROWNO FROM SPRS_CAMPGN_STRG STRG," +
				    " SPRS_CAMPGN SP,STRG_CUSTOMER SC LEFT OUTER JOIN STATE S ON S.STATE_CODE=SC.STATE_CODE,LOCALITY L,SPRS_ROUTE SR,STRG_SERIES SS LEFT OUTER JOIN SPECIALITY SP ON SP.SPL_CODE = SS.SPL_CODE" +
				    " WHERE STRG.TRAN_ID =SP.TRAN_ID AND SC.SC_CODE  =STRG.STRG_CODE AND L.LOCALITY_CODE =SC.LOCALITY_CODE AND SR.LOCALITY_CODE =SC.LOCALITY_CODE AND SS.ROUTE_ID = SR.ROUTE_ID AND SS.SC_CODE = SC.SC_CODE" +
				    " AND SS.STATUS IN('Y','A') AND SR.STATUS ='Y' AND SP.TRAN_ID IN ("+maxIdComma+") AND SP.CAMPGN_ID = ?   AND strg.brand_code = ? AND SP.TRAN_TYPE ='P' AND SP.SALES_PERS = ? AND  sp.tran_id IN ("+maxIdComma+") )B  WHERE B.ROWNO=1 ORDER BY SC_NAME" ;
		
		
				pstmt =  conn.prepareStatement( doctorsql );
				
				pstmt.setString(1, campgnID);
				pstmt.setString(2, salperon);
		
				pstmt.setString(3, campgnID);
				pstmt.setString(4, brandCode);
				pstmt.setString(5, salperon);
				
//				pstmt =  conn.prepareStatement( doctorsql );
//			
//				pstmt.setString(1, campgnID);
//				pstmt.setString(2, brandCode);
//
//				pstmt.setString(3, checkNull( userInfo.getEmpCode() ));
				rs = pstmt.executeQuery();
				String sCode ="";
				String rxCount ="";
				while(rs.next())
				{
					
					JSONObject jsonObject = getJSONObject();
					
					String scCode = genericUtility.checkNull( rs.getString( "STRG_CODE" ) );
					String docName = genericUtility.checkNull( rs.getString( "SC_NAME" ) );
					
					String customImageSrc = getCustomImageURL("STRG_CUSTOMER", "StrgCustomer", scCode, docName, "Icon",uri);
					
					
					jsonObject.put("CUSTOMERIMAGESRC", customImageSrc);
					
//					strgCode = checkNull(rs.getString("STRG_CODE")) ;
//					doctorName = checkNull(rs.getString("SC_NAME")) ;
//					localityCode = checkNull(rs.getString("LOCALITY")) ;
//					localityDescr = checkNull(rs.getString("DESCR")) ;
//					speciality = checkNull(rs.getString("SPECIALITY")) ;
//					qualification = checkNull(rs.getString("QUALIFICATION")) ;
//					classCode = checkNull(rs.getString("CLASS_CODE")) ;
//					stateDesc = checkNull(rs.getString("STATE")) ;
//					
//					valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
//					valueXmlString.append("<cust_name><![CDATA[").append(doctorName).append("]]></cust_name>\r\n");
//					valueXmlString.append("<line_no><![CDATA[").append(lineNum).append("]]></line_no>\r\n");
//					valueXmlString.append("<locality_code><![CDATA[").append(localityCode).append("]]></locality_code>\r\n");
//					valueXmlString.append("<locality_descr><![CDATA[").append(localityDescr).append("]]></locality_descr>\r\n");
//					valueXmlString.append("<speciality><![CDATA[").append(speciality).append("]]></speciality>\r\n");
//					valueXmlString.append("<qualification><![CDATA[").append(qualification).append("]]></qualification>\r\n");
//					valueXmlString.append("<tran_id><![CDATA[").append("").append("]]></tran_id>\r\n");
//					valueXmlString.append( "<brand_code><![CDATA[").append("").append("]]></brand_code>\r\n");
//					valueXmlString.append( "<description><![CDATA[").append("").append("]]></description>\r\n");
//					valueXmlString.append( "<class_code><![CDATA[").append(classCode).append("]]></class_code>\r\n");
//					valueXmlString.append( "<state_descr><![CDATA[").append(stateDesc).append("]]></state_descr>\r\n");
//					valueXmlString.append("<host_url><![CDATA[" ).append(CommonConstants.TOMCAT_HOME).append( "]]></host_url>\r\n" );
//					
					
					jsonObject.put("STRG_CODE", scCode);					
					jsonObject.put("SC_NAME",docName);
					jsonObject.put("QUALIFICATION", rs.getString( "QUALIFICATION" ));
					jsonObject.put("SPECIALITY", rs.getString( "SPECIALITY" ));
					jsonObject.put("LOCALITY",  rs.getString( "LOCALITY" ));
					jsonObject.put("DESCR",  rs.getString( "DESCR" ));
					jsonObject.put("CLASS_CODE", rs.getString( "CLASS_CODE" ) );
					jsonObject.put("STATE_DESCR", rs.getString( "STATE" ) );
					jsonObject.put("RX_CNT", rs.getString( "RX_CNT" ) );
					jsonObject.put("CAMPGN_ID", campgnID );
					jsonObject.put("BRAND_CODE", brandCode);
					jsonObject.put("SALESPER",checkNull( salperon ));
					jsonObject.put("CATEGORY", rs.getString( "CATEGORY" ) );
					
					getBrandCompaignArr.add( jsonObject );
					//valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
					domID++;
					lineNum++;
					scCode = scCode;
				}
				
				System.out.println("getBrandCompaignArr is BrandCamp: "+getBrandCompaignArr);
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			//valueXmlString.append( "</Root>\r\n" );
		}
		catch (Exception e)
		{
			System.out.println(" getBrandCompaignDoctor : "+e.getMessage());
//			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("getBrandCompaignDoctor.finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
		System.out.println("doctorform getBrandCompaignArr.toString()+::["+getBrandCompaignArr.toString()+"]");
		return getBrandCompaignArr.toString();
	}
	//Added by Nilesh Gunjal on 05/02/21 [to get the jsonObject from the Brand Compaign] END
	
	private static JSONObject getJSONObject()
	{
		JSONObject jsonObject = null;
		try
		{
			jsonObject= new JSONObject();
			java.lang.reflect.Field map = jsonObject.getClass().getDeclaredField("map");
			map.setAccessible(true);
			map.set(jsonObject, new LinkedHashMap<>());
			map.setAccessible(false);
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.getJSONObject() Exception : "+e);
		}
		return jsonObject;
	}

	private static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	
	public String getBrandDescr(String brandCode, Connection conn) throws ITMException 
	{
		System.out.println("Inside getBrandDescr method...["+brandCode+"]");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql="";
		String brandDescr="";
		String brandDescription="";
		try 
		{
			if(brandCode !=null && brandCode.trim().length()>0)
			{
				sql = " SELECT DESCRIPTION FROM BRAND WHERE BRAND_CODE in "+ E12GenericUtility.getFormattedProfileId(brandCode)+"";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				
				if ( brandCode.indexOf(",")  != -1)
				{
					System.out.println("inside...::["+brandCode+"]");
					while (rs.next())
					{
						brandDescr = brandDescr + checkNull(rs.getString("DESCRIPTION")) + ",";
						brandDescr=	brandDescr.concat(" ");
						brandDescription = brandDescr.substring(0, brandDescr.length()-2);
						//System.out.println("brandDescription="+brandDescription);
					}
					
				}
				else
				{
					if (rs.next())
					{
						brandDescription = checkNull(rs.getString("DESCRIPTION"));
						//System.out.println("brandDescr::["+brandDescr+"]");
					}
				}
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); 
		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null && ! conn.isClosed())
				{
					conn.close();
					conn = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("return brandDescription["+brandDescription+"]");
		return brandDescription;
	}
	
	public int getEmployeeCount (String empCode,String campaignId ,Connection con) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int count = 1 ;
		StringBuilder selectSql = null;
		try
		{
			
			selectSql = new StringBuilder();	
			
//			selectSql.append(" SELECT count ( DISTINCT   sprs_campgn.sales_pers) As COUNTMR ");
//			selectSql.append(" FROM sprs_campgn INNER JOIN sprs_campgn_strg ON sprs_campgn.tran_id = sprs_campgn_strg.tran_id  ");
//			selectSql.append(" AND sprs_campgn.campgn_id = ? AND sprs_campgn.tran_type in ('P','D')   ");
//			selectSql.append(" AND sprs_campgn.SALES_PERS IN ( SELECT emp_code FROM employee ");
//			selectSql.append(" WHERE nvl(status, ' ') <> 'S' and emp_code != ? START WITH emp_code = ? CONNECT BY PRIOR emp_code = report_to) ");
			
			selectSql.append( " SELECT  count (emp_code) As COUNTMR  FROM employee WHERE nvl(status, ' ') <> 'S' AND emp_code ! = ? START WITH emp_code = ? CONNECT BY PRIOR emp_code = report_to " );

			
			pstmt = con.prepareStatement(selectSql.toString());
			
			//pstmt.setString(1, campaignId);
			pstmt.setString(1, empCode);
			pstmt.setString(2, empCode);
			
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				count = rs.getInt("COUNTMR");
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			}
			catch (Exception e1){}

		}
		return count;
	}

	public String getCustomImageURL(String objName, String object, String fldValue, String altFldValue, String docAttachType,String uri )
	{
		StringBuffer imageURL = new StringBuffer();
		if ( ! CommonConstants.TOMCAT_HOME.contains("localhost"))
		{	
			imageURL.append(CommonConstants.TOMCAT_HOME);
		}
		else
		{
			BaseLogger.log("2",null,null," Else  .getCustomImageURL :[" +  imageURL.toString() + "]" );
			imageURL.append(uri);
		}
		imageURL.append("/ibase/CustomMenuImageServlet?");
		imageURL.append("fldValue=").append( checkNull(fldValue) );
		imageURL.append("&ALT_FLD_VALUE=").append(checkNull(altFldValue));
		imageURL.append("&objName=").append(checkNull(objName));
		imageURL.append("&object=").append(checkNull(object));
		imageURL.append("&docAttachType=").append(checkNull(docAttachType));

		BaseLogger.log("2",null,null," 1007 E12GenericUtility.getCustomImageURL :[" +  imageURL.toString() + "]" );
		return imageURL.toString();
	}
	
	
	
	public String getRanking(String salperson, UserInfoBean userInfo ,String brandCode, String campgnID ,String uri )
	{
	    
		System.out.println( "In side the getRanking  " );
		JSONArray getBrandCompaignArr = new JSONArray();
		
		String doctorsql="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		ResultSet rs1 = null;
		PreparedStatement pstmt1 = null;
		StringBuffer valueXmlString = new StringBuffer();
		String subOrdinateData = "";
		
		int lineNum=1;
		Connection conn = null;
		
		StringBuilder builderMaxTranId = new StringBuilder();
		StringBuilder maxIdBuff = new StringBuilder();
	    String maxId = "";
	    String maxIdComma = "";
		ArrayList<String> rsmHierarchyList = new ArrayList<String>();
		String rsmHierarchyEmployee="";
		
		ArrayList<String> zsmHierarchyList = new ArrayList<String>();
		String zsmHierarchyEmployee="";
		try 
		{
			//valueXmlString.append( "<Root>\r\n" );
			E12GenericUtility genericUtility = new E12GenericUtility();
			int domID = 1;
				
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
			
			
				String transDB = checkNull( userInfo.getTransDB() );
				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB(transDB );
				String userCode = checkNull( userInfo.getLoginCode() );
				String loginEmpCode = checkNull( userInfo.getEmpCode() );
			
				
				StrgMeetDCRWizard strgMeetDCRWizard = new StrgMeetDCRWizard();
				String mgrCode = strgMeetDCRWizard.getMGREmployee(loginEmpCode, conn);
				
				if( mgrCode.trim().length() > 0)
				{
					subOrdinateData = getempId(loginEmpCode,conn);
				
				}
				else
				{
					StringBuffer empIdBuff = new StringBuffer();
					subOrdinateData = empIdBuff.append("'").append(loginEmpCode).append("'").toString();
					
				}
				
			
/*			String allIndia = "  SELECT a.RxCount       AS RxCount, a.sales_pers         AS sales_pers,a.Rankp   AS Rankp,b.DocCount,ROUND((a.RxCount / b.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
				    " FROM ( select count(sprs_campgn_items.tran_id) as RxCount,sprs_campgn.sales_pers, B.sh_descr   AS grade, " +
				    " RANK() OVER(ORDER BY count(sprs_campgn_items.tran_id) DESC) Rankp from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
				    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code  group by sprs_campgn.sales_pers,B.sh_descr  ) a left JOIN   " +
				    " ( select count(sprs_campgn_strg.tran_id) as DocCount,sprs_campgn.sales_pers ,RANK() OVER(ORDER BY count(sprs_campgn_strg.tran_id) DESC )  Rankd from sprs_campgn_strg , sprs_campgn  "+
				    "  where sprs_campgn.tran_id = sprs_campgn_strg.tran_id AND sprs_campgn.tran_type ='D' group by sprs_campgn.sales_pers ) b   " +
				    "  ON a.sales_pers = b.sales_pers  ORDER BY Rankp  " ;
*/
				String brndCode = "";
				String brandCodeSql = "select distinct(brand_code) as brand_code from sprs_campgn_strg where tran_id in (select tran_id from sprs_campgn where sales_pers IN ("+subOrdinateData+") AND TRAN_TYPE='P')";
				pstmt1 = conn.prepareStatement(brandCodeSql);
				rs1 = pstmt1.executeQuery();
				while(rs1.next())
				{
					brndCode = genericUtility.checkNull( rs1.getString("brand_code") );
					if(brndCode != null && brndCode.length() > 0)
					{
						
						
						String maxTranSql = "select max(SC.TRAN_ID) as maxTranId from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCS,STRG_CAMPAIGN SCM where SC.CAMPGN_ID=SCM.CAMPGN_ID AND SC.TRAN_ID=SCS.TRAN_ID and SC.TRAN_TYPE='P' "
								+ " and scs.brand_code=? AND ? BETWEEN SCM.EFF_FROM AND SCM.valid_upto+NVL(SCM.GRACE_DAYS, 0) group by sc.tran_date,SC.CAMPGN_ID,sc.sales_pers";
						//builderMaxTranId.append("select max(SC.TRAN_ID) as maxTranId from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCS where SC.TRAN_ID=SCS.TRAN_ID and SC.TRAN_TYPE='P'"
								//+ " and scs.brand_code=? group by sc.tran_date,sc.sales_pers");
						
						
						pstmt = conn.prepareStatement(maxTranSql);
						pstmt.setString(1, brndCode);
						pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
						rs = pstmt.executeQuery();
						while(rs.next())
						{
							maxId = genericUtility.checkNull( rs.getString("maxTranId") ) ;
							maxIdBuff.append(",'").append(maxId).append("'");
						}
						if (rs!= null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
				}
				if (rs1!= null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1!=null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if ( maxIdBuff.length() > 0 && maxIdBuff!=null )
				{
					
					maxIdComma = maxIdBuff.toString().substring(1);
				}
				else
				{
					maxIdComma = "''";
				}
				/*builderMaxTranId.append(" SELECT MAX(tran_id) as maxTranId from sprs_campgn where sprs_campgn.tran_type ='P' group by tran_Date,sales_pers  ");
				
			
				pstmt = conn.prepareStatement(builderMaxTranId.toString());
	
				System.out.println( "In side the getRanking  builderMaxTranId"+builderMaxTranId.toString() );
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					maxId = genericUtility.checkNull( rs.getString("maxTranId") ) ;
					maxIdBuff.append(",'").append(maxId).append("'");
				}
				if ( maxIdBuff.length() > 0 && maxIdBuff!=null )
				{
					
					maxIdComma = maxIdBuff.toString().substring(1);
				}
				else
				{
					maxIdComma = "''";
				}
				System.out.println( " getRanking maxIdComma : ["+ maxIdComma +"]" );
				
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}*/
				HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
				int rank=1;

				String allIndia = "  SELECT SUM ( a.RxCount ) AS RxCount, a.sales_pers AS sales_pers,a.DocCount,ROUND((a.RxCount / a.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
					    " FROM ( select sum(sprs_campgn_items.OUTCOME_NUM) as RxCount,count(distinct(sprs_campgn_items.strg_code)) as DocCount,sprs_campgn.sales_pers, B.sh_descr   AS grade " +
					    " from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
					    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.tran_id IN ("+maxIdComma+")  group by sprs_campgn.sales_pers,B.sh_descr  )a  GROUP BY  RxCount,sales_pers,DocCount,grade ORDER BY AVGRX DESC,RXCOUNT DESC " ; 


				
				pstmt =  conn.prepareStatement( allIndia );
			
				//pstmt.setString(1, campgnID);
				//pstmt.setString(2, checkNull( userInfo.getEmpCode() ));
				rs = pstmt.executeQuery();
				int loginSalesPersCnt=1;
				boolean isLoginSalesPers=false;
				while(rs.next())
				{
					String salesPers = checkNull(rs.getString( "sales_pers" ));
				    String Avg=checkNull( rs.getString( "AVGRX" ) );

					//if( mgrCode.trim().length() == 0)
					//{
						if(isLoginSalesPers==false && salesPers.equalsIgnoreCase(salperson))
						{
							isLoginSalesPers=true;
						}
						if(loginSalesPersCnt==6 && isLoginSalesPers==false)
						{
							if(!salesPers.equalsIgnoreCase(checkNull(salperson)))
							{
								
								if(hashMap != null &&  hashMap.containsKey(Avg))
								{
								}
								else
								{
									hashMap.put(Avg , rank);
									rank++;
								}

								continue;
							}
						}
					//}

					
					JSONObject jsonObject = getJSONObject();
					
					 
				    String empName = getEmpInfo(salesPers,conn);
				    
					jsonObject.put("THEME_COLOR","white");	
					jsonObject.put("ACT_PRD_CODE","202011");	
					jsonObject.put("ICON", "field_wrk.svg");
					jsonObject.put("MGR_SUB", "9006");
					//Integer  ranking = Integer.parseInt( rs.getString( "Rankp" )) ;
					//if (ranking <= 1 )
					//{
						
//					}
//					else
//					{
//						jsonObject.put("SEQ_COUNT", "..." );
//					}
					if(hashMap != null &&  hashMap.containsKey(Avg))
					{
						int existRank=hashMap.get(Avg);
						jsonObject.put("SEQ_COUNT", existRank );
					}
					else
					{
						jsonObject.put("SEQ_COUNT", rank );
						hashMap.put(Avg , rank);
						rank++;
					}

					jsonObject.put("EMPCODE", salesPers);
					jsonObject.put("GRDE", rs.getString( "grade" ));
					jsonObject.put("AVG",checkNull( rs.getString( "AVGRX" ) ));
					jsonObject.put("RXCOUNT",checkNull( rs.getString( "RxCount" ) ));
					jsonObject.put("DOCCOUNT",checkNull( rs.getString( "DocCount" ) ));
					jsonObject.put("SO_NAME",empName);
					jsonObject.put("LOGIN_CODE",checkNull(userInfo.getEmpCode()));
					jsonObject.put("theme_column", "THEME_COLOR");
					jsonObject.put("name", "SO_NAME" );
					jsonObject.put("emp_code", "EMPCODE" );
					jsonObject.put("grade", "GRDE");
					jsonObject.put("count", "SEQ_COUNT" );
					jsonObject.put("avg", "AVG" );
					jsonObject.put("rxcount", "RXCOUNT" );
					jsonObject.put("dccount", "DOCCOUNT" );
					jsonObject.put("logincode", "LOGIN_CODE" );
					jsonObject.put("info_column", "PRD_CODE");
					jsonObject.put("sub_info_column", "MGR_SUB");
					jsonObject.put("DATA_GRP", "All_India");
					if ( salesPers.equalsIgnoreCase(salperson))
					{
						jsonObject.put("ISMR",true);
						jsonObject.put("ismrornot", "ISMR");
					}
						 

					
					if(loginSalesPersCnt<=6)
					{
						getBrandCompaignArr.add( jsonObject );
					}
					

					//valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
					
					domID++;
					lineNum++;
					loginSalesPersCnt++;
				}
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				rank=1;
				hashMap.clear();
/*				String region = "  SELECT a.RxCount       AS RxCount, a.sales_pers         AS sales_pers,a.Rankp   AS Rankp,b.DocCount,ROUND((a.RxCount / b.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
					    " FROM ( select count(sprs_campgn_items.tran_id) as RxCount,sprs_campgn.sales_pers, B.sh_descr   AS grade, " +
					    " RANK() OVER(ORDER BY count(sprs_campgn_items.tran_id) DESC) Rankp from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
					    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.sales_pers  IN("+subOrdinateData+")  group by sprs_campgn.sales_pers,B.sh_descr  ) a left JOIN   " +
					    " ( select count(sprs_campgn_strg.tran_id) as DocCount,sprs_campgn.sales_pers ,RANK() OVER(ORDER BY count(sprs_campgn_strg.tran_id) DESC )  Rankd from sprs_campgn_strg , sprs_campgn  "+
					    "  where sprs_campgn.tran_id = sprs_campgn_strg.tran_id AND sprs_campgn.tran_type ='D' group by sprs_campgn.sales_pers ) b   " +
					    "  ON a.sales_pers = b.sales_pers  ORDER BY Rankp  " ;
*/
				String rsmEmpCode="";
				String rsmSql="SELECT EMP_CODE  from EMPLOYEE EMP ,GRADE G where EMP.EMP_CODE in(select EMP_CODE as REPORT_TO from EMPLOYEE O start with O.EMP_CODE= " + 
				"(select O.REPORT_TO from EMPLOYEE O where EMP_CODE=?) connect by prior REPORT_TO = EMP_CODE) " +
				"AND EMP.GRADE=G.GRADE_CODE AND G.LEVEL_NO=2 " ;
				pstmt =  conn.prepareStatement( rsmSql );
				pstmt.setString(1, salperson);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rsmEmpCode = checkNull(rs.getString( "EMP_CODE" ));

				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				String rsmsql1="select a.EMP_CODE as SALES_PERS from EMPLOYEE a, GRADE B where a.EMP_CODE in " + 
				"(select EMP_CODE from EMPLOYEE start with EMP_CODE=? connect by prior EMP_CODE = REPORT_TO) and a.GRADE = B.GRADE_CODE and B.LEVEL_NO='4'" ; 
				pstmt =  conn.prepareStatement( rsmsql1 );
				pstmt.setString(1, rsmEmpCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String rsmHierarchyEmpCode = checkNull(rs.getString( "SALES_PERS" ));
					rsmHierarchyList.add(rsmHierarchyEmpCode);
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(!rsmHierarchyList.isEmpty()) 
				{
					OrgStructure orgStructure = new OrgStructure();
					rsmHierarchyEmployee=orgStructure.getFormattedList(rsmHierarchyList);
				}
				if(rsmHierarchyEmployee==null || rsmHierarchyEmployee.trim().length()==0)
				{
					rsmHierarchyEmployee="'X'";
				}
				
				String region = " SELECT SUM ( a.RxCount )       AS RxCount, a.sales_pers         AS sales_pers,a.DocCount,ROUND((a.RxCount / a.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
					    " FROM ( select sum(sprs_campgn_items.OUTCOME_NUM) as RxCount,count(distinct(sprs_campgn_items.strg_code)) as DocCount,sprs_campgn.sales_pers, B.sh_descr   AS grade " +
					    "  from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
					    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.tran_id IN ("+maxIdComma+") AND SPRS_CAMPGN.SALES_PERS IN("+rsmHierarchyEmployee+")  group by sprs_campgn.sales_pers,B.sh_descr  )a  GROUP BY  RxCount,sales_pers,DocCount,grade ORDER BY AVGRX desc,RXCOUNT DESC   " ;

			
					pstmt =  conn.prepareStatement( region );
				
					//pstmt.setString(1, campgnID);
					//pstmt.setString(2, checkNull( userInfo.getEmpCode() ));
					rs = pstmt.executeQuery();
					int loginSalesPersCnt2=1;
					boolean isLoginSalesPers2=false;
					while(rs.next())
					{
						
						JSONObject jsonObject = getJSONObject();
						
						 
					    String salesPers = checkNull(rs.getString( "sales_pers" ));
					    String Avg=checkNull( rs.getString( "AVGRX" ) );

						//if( mgrCode.trim().length() == 0)
						//{
							if(isLoginSalesPers2==false && salesPers.equalsIgnoreCase(salperson))
							{
								isLoginSalesPers2=true;
							}
							if(loginSalesPersCnt2==6 && isLoginSalesPers2==false)
							{
								if(!salesPers.equalsIgnoreCase(checkNull(salperson)))
								{
									
									if(hashMap != null &&  hashMap.containsKey(Avg))
									{
									}
									else
									{
										hashMap.put(Avg , rank);
										rank++;
									}
									continue;
								}
							}
						//}
					    
					    
					    String empName = getEmpInfo(salesPers,conn);

					    
					    
						jsonObject.put("THEME_COLOR","white");	
						jsonObject.put("ACT_PRD_CODE","202011");	
						jsonObject.put("ICON", "field_wrk.svg");
						jsonObject.put("MGR_SUB", "9006");
						//Integer  ranking = Integer.parseInt( rs.getString( "Rankp" )) ;
//						if (ranking <= 1 )
//						{
//							jsonObject.put("SEQ_COUNT", ranking );
//						}
//						else
//						{
//							jsonObject.put("SEQ_COUNT", "..." );
//						}

					    if(hashMap != null &&  hashMap.containsKey(Avg))
						{
							int existRank=hashMap.get(Avg);
							jsonObject.put("SEQ_COUNT", existRank );
						}
						else
						{
							jsonObject.put("SEQ_COUNT", rank );
							hashMap.put(Avg , rank);
							rank++;
						}
						jsonObject.put("EMPCODE", salesPers);
						jsonObject.put("GRDE", rs.getString( "grade" ));
						jsonObject.put("AVG",checkNull( rs.getString( "AVGRX" ) ));
						jsonObject.put("RXCOUNT",checkNull( rs.getString( "RxCount" ) ));
						jsonObject.put("DOCCOUNT",checkNull( rs.getString( "DocCount" ) ));
						jsonObject.put("SO_NAME",empName);
						jsonObject.put("LOGIN_CODE",checkNull(userInfo.getEmpCode()));
						jsonObject.put("theme_column", "THEME_COLOR");
						jsonObject.put("name", "SO_NAME" );
						jsonObject.put("emp_code", "EMPCODE" );
						jsonObject.put("grade", "GRDE");
						jsonObject.put("count", "SEQ_COUNT" );
						jsonObject.put("avg", "AVG" );
						jsonObject.put("rxcount", "RXCOUNT" );
						jsonObject.put("dccount", "DOCCOUNT" );
						jsonObject.put("logincode", "LOGIN_CODE" );
						jsonObject.put("info_column", "PRD_CODE");
						jsonObject.put("sub_info_column", "MGR_SUB");
						jsonObject.put("DATA_GRP", "Region");
						if ( salesPers.equalsIgnoreCase(salperson))
						{
							jsonObject.put("ISMR", true);
							jsonObject.put("ismrornot", "ISMR");
						}

						
						
						
						if(loginSalesPersCnt2<=6)
						{
							getBrandCompaignArr.add( jsonObject );
						}
						//valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
						domID++;
						lineNum++;
						loginSalesPersCnt2++;
					}
					
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					rank=1;
					hashMap.clear();					
					
/*					String zonal = "  SELECT a.RxCount       AS RxCount, a.sales_pers         AS sales_pers,a.Rankp   AS Rankp,b.DocCount,ROUND((a.RxCount / b.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
						    " FROM ( select count(sprs_campgn_items.tran_id) as RxCount,sprs_campgn.sales_pers, B.sh_descr   AS grade, " +
						    " RANK() OVER(ORDER BY count(sprs_campgn_items.tran_id) DESC) Rankp from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
						    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code  group by sprs_campgn.sales_pers,B.sh_descr  ) a left JOIN   " +
						    " ( select count(sprs_campgn_strg.tran_id) as DocCount,sprs_campgn.sales_pers ,RANK() OVER(ORDER BY count(sprs_campgn_strg.tran_id) DESC )  Rankd from sprs_campgn_strg , sprs_campgn  "+
						    "  where sprs_campgn.tran_id = sprs_campgn_strg.tran_id AND sprs_campgn.tran_type ='D' group by sprs_campgn.sales_pers ) b   " +
						    "  ON a.sales_pers = b.sales_pers  ORDER BY Rankp  " ;*/
					String zonalEmpCode="";
					String zonalSql="SELECT EMP_CODE  from EMPLOYEE EMP ,GRADE G where EMP.EMP_CODE in(select EMP_CODE as REPORT_TO from EMPLOYEE O start with O.EMP_CODE= " + 
					"(select O.REPORT_TO from EMPLOYEE O where EMP_CODE=?) connect by prior REPORT_TO = EMP_CODE) " +
					"AND EMP.GRADE=G.GRADE_CODE AND G.LEVEL_NO=1 " ;
					pstmt =  conn.prepareStatement( zonalSql );
					pstmt.setString(1, salperson);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						zonalEmpCode = checkNull(rs.getString( "EMP_CODE" ));

					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					
					String zonalsql1="select a.EMP_CODE as SALES_PERS from EMPLOYEE a, GRADE B where a.EMP_CODE in " + 
					"(select EMP_CODE from EMPLOYEE start with EMP_CODE=? connect by prior EMP_CODE = REPORT_TO) and a.GRADE = B.GRADE_CODE and B.LEVEL_NO='4'" ; 
					pstmt =  conn.prepareStatement( zonalsql1 );
					pstmt.setString(1, zonalEmpCode);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						String zsmHierarchyEmpCode = checkNull(rs.getString( "SALES_PERS" ));
						zsmHierarchyList.add(zsmHierarchyEmpCode);
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if(!zsmHierarchyList.isEmpty()) 
					{
						OrgStructure orgStructure = new OrgStructure();
						zsmHierarchyEmployee=orgStructure.getFormattedList(zsmHierarchyList);
					}
					if(zsmHierarchyEmployee==null || zsmHierarchyEmployee.trim().length()==0)
					{
						zsmHierarchyEmployee="'X'";
					}
					
					
					String zonal =  "  SELECT SUM ( a.RxCount )       AS RxCount, a.sales_pers         AS sales_pers,a.DocCount,ROUND((a.RxCount / a.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
						    " FROM ( select sum(sprs_campgn_items.OUTCOME_NUM) as RxCount,count(distinct(sprs_campgn_items.strg_code)) as DocCount,sprs_campgn.sales_pers, B.sh_descr   AS grade " +
						    "  from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
						    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.tran_id IN ("+maxIdComma+") AND sprs_campgn.SALES_PERS IN("+zsmHierarchyEmployee+") group by sprs_campgn.sales_pers,B.sh_descr  )a  GROUP BY  RxCount,sales_pers,DocCount,grade ORDER BY AVGRX DESC,RXCOUNT DESC  " ;

						
						pstmt =  conn.prepareStatement( zonal );
					
						//pstmt.setString(1, campgnID);
						//pstmt.setString(2, checkNull( userInfo.getEmpCode() ));
						rs = pstmt.executeQuery();
						int loginSalesPersCnt3=1;
						boolean isLoginSalesPers3=false;
						while(rs.next())
						{
							
							JSONObject jsonObject = getJSONObject();
							
							 
						    String salesPers = checkNull(rs.getString( "sales_pers" ));
							String Avg=checkNull( rs.getString( "AVGRX" ) );

						    
							//if( mgrCode.trim().length() == 0)
							//{
								if(isLoginSalesPers3==false && salesPers.equalsIgnoreCase(checkNull(salperson)))
								{
									isLoginSalesPers3=true;
								}
								if(loginSalesPersCnt3==6 && isLoginSalesPers3==false)
								{
									if(!salesPers.equalsIgnoreCase(checkNull(salperson)))
									{
										if(hashMap != null &&  hashMap.containsKey(Avg))
										{
										}
										else
										{
											hashMap.put(Avg , rank);
											rank++;
										}
										continue;
									}
								}
							//}
						    
						    
						    String empName = getEmpInfo(salesPers,conn);
						    
						    
							jsonObject.put("THEME_COLOR","white");	
							jsonObject.put("ACT_PRD_CODE","202011");	
							jsonObject.put("ICON", "field_wrk.svg");
							jsonObject.put("MGR_SUB", "9006");
							//Integer  ranking = Integer.parseInt( rs.getString( "Rankp" )) ;
							//if (ranking <= 1 )
							//{
								//jsonObject.put("SEQ_COUNT", ranking );
//							}
//							else
//							{
//								jsonObject.put("SEQ_COUNT", "..." );
//							}

						    if(hashMap != null &&  hashMap.containsKey(Avg))
							{
								int existRank=hashMap.get(Avg);
								jsonObject.put("SEQ_COUNT", existRank );
							}
							else
							{
								jsonObject.put("SEQ_COUNT", rank );
								hashMap.put(Avg , rank);
								rank++;
							}
							jsonObject.put("EMPCODE", salesPers);
							jsonObject.put("GRDE", rs.getString( "grade" ));
							jsonObject.put("AVG",checkNull( rs.getString( "AVGRX" ) ));
							jsonObject.put("RXCOUNT",checkNull( rs.getString( "RxCount" ) ));
							jsonObject.put("DOCCOUNT",checkNull( rs.getString( "DocCount" ) ));
							jsonObject.put("SO_NAME",empName);
							jsonObject.put("LOGIN_CODE",checkNull(userInfo.getEmpCode()));
							jsonObject.put("theme_column", "THEME_COLOR");
							jsonObject.put("name", "SO_NAME" );
							jsonObject.put("emp_code", "EMPCODE" );
							jsonObject.put("grade", "GRDE");
							jsonObject.put("count", "SEQ_COUNT" );
							jsonObject.put("avg", "AVG" );
							jsonObject.put("rxcount", "RXCOUNT" );
							jsonObject.put("dccount", "DOCCOUNT" );
							jsonObject.put("logincode", "LOGIN_CODE" );
							jsonObject.put("info_column", "PRD_CODE");
							jsonObject.put("sub_info_column", "MGR_SUB");
							jsonObject.put("DATA_GRP", "Zonal");
							if ( salesPers.equalsIgnoreCase(checkNull(salperson)))
							{
								jsonObject.put("ISMR", true);
								jsonObject.put("ismrornot", "ISMR");
							}

							
							
							
							if(loginSalesPersCnt3<=6)
							{
								getBrandCompaignArr.add( jsonObject );
							}
							//valueXmlString.append( "<item_form_no><![CDATA[").append(brandItem).append("]]></item_form_no>\r\n");
							domID++;
							lineNum++;
							loginSalesPersCnt3++;
						}
						
						if ( rs != null )
						{
							rs.close();
							rs = null;
						}
						if ( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
			//valueXmlString.append( "</Root>\r\n" );
		}
		catch (Exception e)
		{
			System.out.println("SellsStock.getAvgSellInOut() : "+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("getBrandCompaignDoctor.finally["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
		System.out.println("doctorform getBrandCompaignArr.toString()+::["+getBrandCompaignArr.toString()+"]");
		return getBrandCompaignArr.toString();
	}
	//Added by Nilesh Gunjal on 05/02/21 [to get the jsonObject from the Brand Compaign] END
	
	
	public JSONObject getRankingRegionEmpCodeWise( Connection conn ,String mgrCode )
	{
		JSONObject jsonObjectReturn = getJSONObject();
		
		String doctorsql="";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		StringBuffer valueXmlString = new StringBuffer();
		
		
		int lineNum=1;
		//Connection conn = null;
		try 
		{
			//valueXmlString.append( "<Root>\r\n" );
			E12GenericUtility genericUtility = new E12GenericUtility();
			int domID = 1;
					
//				String transDB = checkNull( userInfo.getTransDB() );
//				ConnDriver connDriver = new ConnDriver();
//				conn = connDriver.getConnectDB(transDB );
			
			String allIndia = "  SELECT COUNT(sprs_campgn_items.tran_id) AS rxcount,    "   +
				    "  sprs_campgn.sales_pers,b.sh_descr AS grade, " +
				    " RANK() OVER( ORDER BY COUNT(sprs_campgn_items.tran_id) DESC ) rankp 	" +
				    "  FROM sprs_campgn_items,sprs_campgn,employee   a,grade      b  " +
				    "  WHERE sprs_campgn.tran_id = sprs_campgn_items.tran_id  "+
				    "  AND sprs_campgn.tran_type = 'P' AND a.emp_code = sprs_campgn.sales_pers   " +
				    "  AND a.grade = b.grade_code GROUP BY sprs_campgn.sales_pers,b.sh_descr  " ;
				    
				
				pstmt =  conn.prepareStatement( allIndia );
			
				//pstmt.setString(1, campgnID);
				//pstmt.setString(2, checkNull( userInfo.getEmpCode() ));
				rs = pstmt.executeQuery();
				
				while(rs.next())
				{
					
					
					
					 
				    String salesPers = checkNull(rs.getString( "sales_pers" ));
				    String empName = getEmpInfo(salesPers,conn);
		
				    jsonObjectReturn.put("SEQ_COUNT_+"+salesPers+"", rs.getString( "Rankp" ));
				    jsonObjectReturn.put("EMPCODE_+"+salesPers+"", salesPers);
				    jsonObjectReturn.put("DATA_GRP_+"+salesPers+"", "All_India");
					
					
					
				}
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				
				
		}
		catch (Exception e)
		{
			System.out.println(" getRankingRegionEmpCodeWise : "+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				//throw new ITMException(e);
			}
		}
		
		System.out.println("doctorform getBrandCompaignArr.toString()+::");
		return jsonObjectReturn;
	


	}
	private String getEmpInfo(String empCode,Connection connectionObject) throws ITMException,Exception
	{
		
				SimpleDateFormat sdfWorkDate = null ;
				//SimpleDateFormat sdfSubmissionDate = null ;
				PreparedStatement pstmt = null;
				ResultSet rs = null ;
				String loginName ="";
				
				try
				{

					String sql = "SELECT  EMP_FNAME ||' '|| EMP_MNAME ||' '|| EMP_LNAME AS EMP_NAME " +
							" FROM EMPLOYEE WHERE EMP_CODE = ? ";
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString(1, empCode);
							rs = pstmt.executeQuery();
							if( rs.next())
							{
								loginName =  rs.getString("EMP_NAME")   ==null ? "":rs.getString("EMP_NAME");
							}
							
							if ( rs != null )
							{
								rs.close();
								rs = null;
							}
							if ( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}
					
				}
				catch (Exception ex)
				{
					ex.printStackTrace();
				}
				finally
				{
					try
					{
						if ( rs != null )
						{
							rs.close();
							rs = null;
						}
						if ( pstmt != null )
						{
							pstmt.close();
							pstmt = null;
						}
					}
					catch(Exception e)
					{
						throw new ITMException(e);
					}
				}
				System.out.println("loginName : "+loginName);
				return loginName;
			}
	
//Added By Nilesh In case of Dr count and proction count start "" 15-05-2021
public int getPrCount(String campaignId, String empId,String brandCode ,Connection conn )
{
	System.out.println( "In side the getPrCount " );
	int prCount = 0;
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	
	StringBuilder builder = null;
	StringBuilder builderMaxTranId = new StringBuilder();
	StringBuilder maxIdBuff = new StringBuilder();
    String maxId = "";
    String maxIdComma = "";
	try
	{
			//String itemSql="SELECT ITEM_CODE ";
		
		
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
		
			
			builderMaxTranId.append(" select max(sprs_campgn_items.tran_id) As maxTranId,sprs_campgn.tran_date,sprs_campgn.SALES_PERS from sprs_campgn inner join sprs_campgn_items on sprs_campgn.tran_id = sprs_campgn_items.tran_id,STRG_CAMPAIGN where  ");
			builderMaxTranId.append(" sprs_campgn.campgn_id = ? and sprs_campgn.tran_type = 'P' AND STRG_CAMPAIGN.CAMPGN_ID=SPRS_CAMPGN.CAMPGN_ID AND sprs_campgn.SALES_PERS IN ("+empId+")  ");
			builderMaxTranId.append(" AND sprs_campgn_items.ITEM_CODE IN(SELECT ITEM_CODE FROM ITEM WHERE BRAND_CODE= ? )   ");
			builderMaxTranId.append(" AND ? BETWEEN STRG_CAMPAIGN.EFF_FROM AND STRG_CAMPAIGN.valid_upto+NVL(STRG_CAMPAIGN.GRACE_DAYS, 0) group by sprs_campgn.tran_date,sprs_campgn.SALES_PERS ");
		
			pstmt = conn.prepareStatement(builderMaxTranId.toString());
	
			pstmt.setString(1, campaignId);
			pstmt.setString(2, brandCode);
			pstmt.setDate(3,java.sql.Date.valueOf(currentDate));
			
			System.out.println( "In side the getPrCountEachCampaign  builderMaxTranId"+builderMaxTranId.toString() );
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				maxId = genericUtility.checkNull( rs.getString("maxTranId") ) ;
				maxIdBuff.append(",'").append(maxId).append("'");
			}
			if ( maxIdBuff.length() > 0 && maxIdBuff!=null )
			{
				
				maxIdComma = maxIdBuff.toString().substring(1);
			}
			else
			{
				maxIdComma = "''";
			}
			System.out.println( "getPrCount maxIdComma : ["+ maxIdComma +"]" );
			
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		
			builder = new StringBuilder();
		
			builder.append(" select SUM(OUTCOME_NUM) as prCount from sprs_campgn  inner join  sprs_campgn_items on ");
			builder.append(" sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.campgn_id = ? ");
			builder.append(" and sprs_campgn.tran_type = 'P' AND sprs_campgn.SALES_PERS IN("+empId+") AND sprs_campgn_items.tran_id in ("+maxIdComma+") AND sprs_campgn_items.ITEM_CODE IN(SELECT ITEM_CODE FROM ITEM WHERE BRAND_CODE=?) GROUP BY campgn_id ");
			
		
		
			pstmt = conn.prepareStatement( builder.toString() );
			pstmt.setString(1, campaignId);
			pstmt.setString(2, brandCode);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{

				prCount = rs.getInt("prCount");

			}

			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		
		System.out.println( "prCount 1425 : ["+ prCount +"]" );
	}
	catch(Exception e)
	{
		System.out.println(" getPrCount : "+e.getMessage());
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return prCount;
}


public int getDrCount( String campaignId, String empId,String brandCode ,Connection conn )
{
	System.out.println( "In side the getDrCount " );
	int drCount = 0;
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	
	StringBuilder builder = null;
	try
	{
		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
		Calendar calendar = Calendar.getInstance();
		String currentDate  = dtFormat.format(calendar.getTime());
		currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
		System.out.println("currentDate => " + currentDate);
		
			builder = new StringBuilder();	
			
			
			builder.append(" select  SUM(count(distinct(sprs_campgn_strg.strg_code))) as DrCount from strg_campaign,sprs_campgn  inner join  sprs_campgn_strg on ");
			builder.append(" sprs_campgn.tran_id = sprs_campgn_strg.tran_id where sprs_campgn.campgn_id = ? and strg_campaign.campgn_id=sprs_campgn.campgn_id and ? BETWEEN strg_campaign.EFF_FROM AND strg_campaign.VALID_UPTO+NVL(strg_campaign.GRACE_DAYS, 0) ");
			builder.append(" and sprs_campgn.tran_type = 'D' AND sprs_campgn.SALES_PERS IN("+empId+") AND INSTR(SPRS_CAMPGN_STRG.BRAND_CODE,?)>0 GROUP BY sprs_campgn.campgn_id ");
			
		
		
			pstmt = conn.prepareStatement( builder.toString() );
			pstmt.setString(1, campaignId);
			pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
			pstmt.setString(3, brandCode);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{

				drCount = rs.getInt("DrCount");

			}

			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		
	}
	catch(Exception e)
	{
		System.out.println("getDrCount : "+e.getMessage());
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return drCount;
}


public String getempId(String empCode,Connection connectionObject) throws ITMException
{
	
	
	PreparedStatement pstmt = null;
	ResultSet rs = null ;
	StringBuffer empIdBuff = new StringBuffer();
	ArrayList temp = new ArrayList(100);
	String sql = "";
	String salesCode ="";
	try
	{
		
		sql = " SELECT emp_code FROM employee WHERE nvl(status, ' ') <> 'S' AND emp_code ! = ? START WITH emp_code = ? CONNECT BY PRIOR emp_code = report_to ";
		pstmt = connectionObject.prepareStatement(sql);

		pstmt.setString(1, empCode);
		pstmt.setString(2, empCode);
		
		rs = pstmt.executeQuery();
		while(rs.next())
		{
			salesCode = genericUtility.checkNull( rs.getString("emp_code") ) ;
			empIdBuff.append(",'").append(salesCode).append("'");
		}
		
		
		if ( empIdBuff.length()  > 0)
		{	
			temp.add(empIdBuff);
		}	
		
		
		if (rs!= null)
		{
			rs.close();
			rs = null;
		}
		if(pstmt!=null)
		{
			pstmt.close();
			pstmt = null;
		}
		temp.clear();

	}
	catch(Exception e)
	{
		e.printStackTrace();
		System.out.println("getempId : "+e.getMessage());
		throw new ITMException(e);

	}
	finally
	{
		try
		{
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}

	if ( empIdBuff.length()  > 0)
	{	
		temp.add(empIdBuff);
	}	
	else
	{
		return empIdBuff.toString();
	}
	return empIdBuff.toString().substring(1);

}

public JSONArray getDataJSONArray(LinkedHashMap getDrCountEachCampaign, LinkedHashMap getPrCountEachCampaign, ArrayList transactionDates)
{
    JSONArray getDataJSONArray = new JSONArray();
    try
    {
        Object objPrCount = 0;
        Object objDrCount = 0;
        JSONArray getPrCountYAxis = new JSONArray();
        JSONArray getDrCountYAxis = new JSONArray();
        JSONArray getTranDateXAxis = new JSONArray();
        for(int i=0; i<transactionDates.size(); i++)
        {
            getTranDateXAxis.add( transactionDates.get(i) );
            if( getDrCountEachCampaign.containsKey(transactionDates.get(i)) )
            {
                objDrCount = getDrCountEachCampaign.get( transactionDates.get(i) );
                //int DrCount = Integer.parseInt(count);
                //objDrCount = DrCount;
            }
            getDrCountYAxis.add(objDrCount);
            if( getPrCountEachCampaign.containsKey(transactionDates.get(i)) )
            {
                objPrCount = getPrCountEachCampaign.get( transactionDates.get(i) );
                //int PrCount = Integer.parseInt(count);
                //objPrCount = PrCount;
            }
            getPrCountYAxis.add(objPrCount);
        }
        System.out.println( "getDataJSONArray getTranDateXAxis : "+getTranDateXAxis );
        System.out.println( "getDataJSONArray getDrCountYAxis :  " +getDrCountYAxis);
        System.out.println( "getDataJSONArray getPrCountYAxis : "+getPrCountYAxis );
        getDataJSONArray.add(getTranDateXAxis);
        getDataJSONArray.add(getDrCountYAxis);
        getDataJSONArray.add(getPrCountYAxis);
    }
    catch (Exception e) 
	{
		System.out.println( "Exception at getDataJSONArray ::::"+e.getMessage() );
	}
    return getDataJSONArray;
}

public ArrayList getTranDateFromEachCampaign( String campaignId, String empId,String brandCode ,Connection conn )
{
	System.out.println( "In side the getTranDateFromEachCampaign "+empId );
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	ArrayList arrList = new ArrayList();
	String[] months = {"Jan", "Feb", "Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov", "Dec"};
	try 
	{
		String tranDates = "select distinct(sprs_campgn.tran_date) AS TRAN_DATE from sprs_campgn "
				+ "inner join sprs_campgn_strg on sprs_campgn.tran_id = sprs_campgn_strg.tran_id AND   sprs_campgn.campgn_id = ? "
				+ "and sprs_campgn.tran_type IN ('D','P')    AND sprs_campgn.SALES_PERS IN("+empId+") and "
				+ "instr(sprs_campgn_strg.BRAND_CODE,?)>0  group by sprs_campgn.tran_date order by sprs_campgn.tran_date";
		pstmt = conn.prepareStatement( tranDates );
		pstmt.setString(1, campaignId);
		pstmt.setString(2, brandCode);
		rs = pstmt.executeQuery();
		String tran_date ="";
		java.util.Date date = null;
		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
		while (rs.next()) 
		{
			date = rs.getDate("TRAN_DATE");
			System.out.println( "getTranDateFromEachCampaign date : " +date);
			if ( date!=null)
			{
				tran_date = dtFormat.format( date );
			}
			if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd-MMM-yyyy"))
			{
				String daraArry[] = tran_date.split("-");
				tran_date = tran_date.split("-")[0]+""+tran_date.split("-")[1];
			}
			else if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd/MM/yy"))
			{
				String daraArry[] = tran_date.split("/");
				int dateMonth = Integer.parseInt(tran_date.split("/")[1]);
				tran_date = tran_date.split("/")[0]+""+months[dateMonth -1];
			}
			arrList.add(tran_date);
		}
		if ( rs != null )
		{
			rs.close();
			rs = null;
		}
		if ( pstmt != null )
		{
			pstmt.close();
			pstmt = null;
		}
		System.out.println( "arrList date : " +arrList);
	} 
	catch (Exception e) 
	{
		System.out.println( "Exception at getTranDateFromEachCampaign ::::"+e.getMessage() );
	}
	finally
	{
		try
		{
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return arrList;
}

public LinkedHashMap getPrCountEachCampaign( String campaignId, String empId,String brandCode ,Connection conn )
{
	System.out.println( "In side the getPrCountEachCampaign " );
	JSONArray getPrCountEachCampaign = new JSONArray();
	String drCountAraay = "";
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	
	JSONArray getPrCount = new JSONArray();
	JSONArray getPrCountLable = new JSONArray();
	LinkedHashMap<String, String> linkedMap = new LinkedHashMap<String, String>();
	
	StringBuilder builder = null;
	StringBuilder builderMaxTranId = new StringBuilder();
	StringBuilder maxIdBuff = new StringBuilder();
    String[] months = {"Jan", "Feb", "Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov", "Dec"};
    String maxId = "";
    String maxIdComma = "";
     
    
	try
	{
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
		

			
			
			
			builderMaxTranId.append(" select max(sprs_campgn_items.tran_id) As maxTranId,sprs_campgn.tran_date from sprs_campgn inner join sprs_campgn_items on sprs_campgn.tran_id = sprs_campgn_items.tran_id,STRG_CAMPAIGN  where  ");
			builderMaxTranId.append(" sprs_campgn.campgn_id = ? and sprs_campgn.tran_type = 'P' AND STRG_CAMPAIGN.CAMPGN_ID=SPRS_CAMPGN.CAMPGN_ID AND sprs_campgn.SALES_PERS IN ("+empId+")  ");
			builderMaxTranId.append(" AND sprs_campgn_items.ITEM_CODE IN(SELECT ITEM_CODE FROM ITEM WHERE BRAND_CODE= ? )  AND ? BETWEEN STRG_CAMPAIGN.EFF_FROM AND STRG_CAMPAIGN.valid_upto+NVL(strg_campaign.GRACE_DAYS, 0) ");
			builderMaxTranId.append("  group by sprs_campgn.tran_date ");
		
			pstmt = conn.prepareStatement(builderMaxTranId.toString());
	
			pstmt.setString(1, campaignId);
			pstmt.setString(2, brandCode);
			pstmt.setDate(3,java.sql.Date.valueOf(currentDate));
			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				maxId = genericUtility.checkNull( rs.getString("maxTranId") ) ;
				maxIdBuff.append(",'").append(maxId).append("'");
			}
			if ( maxIdBuff.length() > 0 && maxIdBuff!=null )
			{
				
				maxIdComma = maxIdBuff.toString().substring(1);
			}
			else
			{
				maxIdComma = "''";
			}
			
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			builder = new StringBuilder();	
			
			builder.append(" select   sum(sprs_campgn_items.outcome_num) AS COUNTPR,sprs_campgn.tran_date from sprs_campgn ");
			builder.append(" inner join sprs_campgn_items on sprs_campgn.tran_id = sprs_campgn_items.tran_id AND  ");
			builder.append(" sprs_campgn.campgn_id = ? and sprs_campgn.tran_type = 'P'   ");
			builder.append(" AND sprs_campgn.SALES_PERS IN("+empId+") AND  sprs_campgn_items.tran_id in ("+maxIdComma+") AND sprs_campgn_items.ITEM_CODE IN(SELECT ITEM_CODE FROM ITEM WHERE BRAND_CODE = ?) group by sprs_campgn.tran_date order by sprs_campgn.tran_date ");
			
		
			pstmt = conn.prepareStatement( builder.toString() );
			pstmt.setString(1, campaignId);
			pstmt.setString(2, brandCode);
			rs = pstmt.executeQuery();
			int countDR = 0;
			String tran_date ="";
			java.util.Date date = null;
			//DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			while( rs.next() )
			{
				countDR = countDR + rs.getInt("COUNTPR");
				//int countDR= rs.getInt("COUNTPR");
				 Object obj = countDR;
				 date = rs.getDate("tran_date");
				 if ( date!=null)
				 {
					 tran_date = dtFormat.format( date );
				 }
				 
				 //getPrCount.add(obj);
				
				if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd-MMM-yyyy"))
				{
					String daraArry[] = tran_date.split("-");
					tran_date = tran_date.split("-")[0]+""+tran_date.split("-")[1]; 
					//getPrCountLable.add(tran_date);
				}
				else if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd/MM/yy"))
				{
					String daraArry[] = tran_date.split("/");
					int dateMonth = Integer.parseInt(tran_date.split("/")[1]);
					tran_date = tran_date.split("/")[0]+""+months[dateMonth -1] ; 
					//getPrCountLable.add(tran_date);
				}
                //drCount = rs.getInt("DrCount");
                linkedMap.put(tran_date, countDR+"");

			}
    		//System.out.println( "getPrCountEachCampaign getDrCountLable : "+getPrCountLable );
			//System.out.println( "getPrCountEachCampaign 1421 : getPrCount " +getPrCount);
			
			//getPrCountEachCampaign.add(getPrCountLable);
			//getPrCountEachCampaign.add(getPrCount);
			
			//System.out.println( "getDrCountEachCampaign 1421 : getPrCountEachCampaign " +getPrCountEachCampaign);
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		
	}
	catch(Exception e)
	{
		System.out.println("getPrCountEachCampaign : "+e.getMessage());
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return linkedMap;
}


public LinkedHashMap getDrCountEachCampaign ( String campaignId, String empId,String brandCode ,Connection conn )
{
	System.out.println( "In side the getDrCountEachCampaign "+empId );
	
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	//JSONArray getDrCountEachCampaign = new JSONArray();
	//JSONArray getDrCount = new JSONArray();
    //JSONArray getDrCountLable = new JSONArray();
    LinkedHashMap<String, String> linkedMap = new LinkedHashMap<String, String>();
	
	StringBuilder builder = null;
    String[] months = {"Jan", "Feb", "Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov", "Dec"};

	try
	{

			builder = new StringBuilder();	
			
			DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Calendar calendar = Calendar.getInstance();
			String currentDate  = dtFormat.format(calendar.getTime());
			currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
			System.out.println("currentDate => " + currentDate);
			
			builder.append(" select count(distinct(sprs_campgn_strg.strg_code)) AS COUNTDR,sprs_campgn.tran_date from strg_campaign,sprs_campgn ");
			builder.append(" inner join sprs_campgn_strg on sprs_campgn.tran_id = sprs_campgn_strg.tran_id where  ");
			builder.append(" sprs_campgn.campgn_id = ? and strg_campaign.campgn_id=sprs_campgn.campgn_id and sprs_campgn.tran_type = 'D'  and ? BETWEEN strg_campaign.EFF_FROM AND strg_campaign.VALID_UPTO+NVL(strg_campaign.GRACE_DAYS, 0)  ");
			builder.append(" AND sprs_campgn.SALES_PERS IN("+empId+") and instr(sprs_campgn_strg.BRAND_CODE,?)>0  group by sprs_campgn.tran_date order by sprs_campgn.tran_date ");
			
		
		
			pstmt = conn.prepareStatement( builder.toString() );
			pstmt.setString(1, campaignId);
			pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
			pstmt.setString(3, brandCode);

			rs = pstmt.executeQuery();
			//int countDR = 0;
			String tran_date ="";
			java.util.Date date = null;
			while( rs.next() )
			{
				//countDR = countDR + rs.getInt("COUNTDR");
				int countDR= rs.getInt("COUNTDR");
				Object obj = countDR;
				date = rs.getDate("tran_date");
				 if ( date!=null)
				 {
					 tran_date = dtFormat.format( date );
				 }
				 
				//getDrCount.add(obj);
				
				if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd-MMM-yyyy"))
				{
					String daraArry[] = tran_date.split("-");
					tran_date = tran_date.split("-")[0]+""+tran_date.split("-")[1]; 
					//getDrCountLable.add(tran_date);
				}
				else if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd/MM/yy"))
				{
					String daraArry[] = tran_date.split("/");
					int dateMonth = Integer.parseInt(tran_date.split("/")[1]);
					tran_date = tran_date.split("/")[0]+""+months[dateMonth -1]; 
					//getDrCountLable.add(tran_date);
				}
                //drCount = rs.getInt("DrCount");
                linkedMap.put(tran_date, countDR+"");

			}
			//System.out.println( "getDrCountEachCampaign getDrCountLable : "+getDrCountLable );
			//System.out.println( "getDrCountEachCampaign 1421 : getDrCount " +getDrCount);
			
			//getDrCountEachCampaign.add(getDrCountLable);
			//getDrCountEachCampaign.add(getDrCount);
			
			//System.out.println( "getDrCountEachCampaign 1421 : getDrCountEachCampaign " +getDrCountEachCampaign);

			
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		
		System.out.println( "getDrCountEachCampaign 1421 : " );
	}
	catch(Exception e)
	{
		System.out.println("getDrCountEachCampaign : "+e.getMessage());
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return linkedMap;
}

public LinkedHashMap getDrCountEachCampaignMgr ( String campaignId, String empId,String brandCode ,Connection conn )
{
	System.out.println( "In side the getDrCountEachCampaign "+empId );
	
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	//JSONArray getDrCountEachCampaign = new JSONArray();
	//JSONArray getDrCount = new JSONArray();
    //JSONArray getDrCountLable = new JSONArray();
    LinkedHashMap<String, String> linkedMap = new LinkedHashMap<String, String>();
	ArrayList<String> scCodeList = new ArrayList<String>();
	StringBuilder builder = null;
    String[] months = {"Jan", "Feb", "Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov", "Dec"};

	try
	{
		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
		Calendar calendar = Calendar.getInstance();
		String currentDate  = dtFormat.format(calendar.getTime());
		currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
		System.out.println("currentDate => " + currentDate);
		
		
			builder = new StringBuilder();	
			
			builder.append(" select distinct(SPRS_CAMPGN_STRG.STRG_CODE) as STRG_CODE, sprs_campgn.tran_date from strg_campaign,sprs_campgn ");
			builder.append(" inner join sprs_campgn_strg on sprs_campgn.tran_id = sprs_campgn_strg.tran_id where  ");
			builder.append(" sprs_campgn.campgn_id = ? and strg_campaign.campgn_id=sprs_campgn.campgn_id  and sprs_campgn.tran_type = 'D' and ? BETWEEN strg_campaign.EFF_FROM AND strg_campaign.VALID_UPTO+NVL(strg_campaign.GRACE_DAYS, 0) ");
			builder.append(" AND sprs_campgn.SALES_PERS IN("+empId+") and instr(sprs_campgn_strg.BRAND_CODE,?)>0 order by sprs_campgn.tran_date ");
			
		
		
			pstmt = conn.prepareStatement( builder.toString() );
			pstmt.setString(1, campaignId);
			pstmt.setDate(2,java.sql.Date.valueOf(currentDate));
			pstmt.setString(3, brandCode);

			rs = pstmt.executeQuery();
			int countDR = 0;
			String tran_date ="";
			java.util.Date date = null;
			while( rs.next() )
			{
				//countDR = countDR + rs.getInt("COUNTDR");
				String strgCode = rs.getString("STRG_CODE");
				//Object obj = countDR;
				date = rs.getDate("tran_date");
				 if ( date!=null)
				 {
					 tran_date = dtFormat.format( date );
				 }
				 
				//getDrCount.add(obj);
				
				if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd-MMM-yyyy"))
				{
					String daraArry[] = tran_date.split("-");
					tran_date = tran_date.split("-")[0]+""+tran_date.split("-")[1]; 
					//getDrCountLable.add(tran_date);
				}
				else if ( genericUtility.getDispDateFormat().equalsIgnoreCase("dd/MM/yy"))
				{
					String daraArry[] = tran_date.split("/");
					int dateMonth = Integer.parseInt(tran_date.split("/")[1]);
					tran_date = tran_date.split("/")[0]+""+months[dateMonth -1]; 
					//getDrCountLable.add(tran_date);
				}
				if(!scCodeList.contains(strgCode))
				{
					scCodeList.add(strgCode);
				}
				countDR = scCodeList.size();
				linkedMap.put(tran_date, countDR+"");
                //drCount = rs.getInt("DrCount");
                //linkedMap.put(tran_date, countDR+"");

			}
			//System.out.println( "getDrCountEachCampaign getDrCountLable : "+getDrCountLable );
			//System.out.println( "getDrCountEachCampaign 1421 : getDrCount " +getDrCount);
			
			//getDrCountEachCampaign.add(getDrCountLable);
			//getDrCountEachCampaign.add(getDrCount);
			
			//System.out.println( "getDrCountEachCampaign 1421 : getDrCountEachCampaign " +getDrCountEachCampaign);

			
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			
			
		
	}
	catch(Exception e)
	{
		System.out.println("getDrCountEachCampaign : "+e.getMessage());
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
		}
		catch (SQLException e)
		{
			e.printStackTrace();
		}
	}
	return linkedMap;
}
public String getItemSer(String salesPers,Connection conn)
{
	PreparedStatement pstmt = null;
	ResultSet rs = null;
	String itemSer="";
	try
	{
		String sql="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS=?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, salesPers);
		rs = pstmt.executeQuery();
		if(rs.next())
		{
			itemSer = checkNull(rs.getString("ITEM_SER"));
		}
		if (rs!= null)
		{
			rs.close();
			rs = null;
		}
		if(pstmt!=null)
		{
			pstmt.close();
			pstmt = null;
		}

	}
	catch(Exception e)
	{
		e.printStackTrace();
	}
	finally
	{

		try
		{
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

	}
	return itemSer;
}
public int getRankingSalesPersonCart( UserInfoBean userInfo,String loginEmpCode,String dataGrp  )
{
    
	System.out.println( "In side the getRankingSalesPersonCart  " );
	JSONArray getBrandCompaignArr = new JSONArray();
	
	String doctorsql="";
	ResultSet rs = null;
	PreparedStatement pstmt = null;
	ResultSet rs1 = null;
	PreparedStatement pstmt1 = null;
	StringBuffer valueXmlString = new StringBuffer();
	String subOrdinateData = "";
	int finalRank=0;
	int lineNum=1;
	Connection conn = null;
	
	StringBuilder builderMaxTranId = new StringBuilder();
	StringBuilder maxIdBuff = new StringBuilder();
    String maxId = "";
    String maxIdComma = "";
	ArrayList<String> rsmHierarchyList = new ArrayList<String>();
	String rsmHierarchyEmployee="";
	
	ArrayList<String> zsmHierarchyList = new ArrayList<String>();
	String zsmHierarchyEmployee="";
	try 
	{
		//valueXmlString.append( "<Root>\r\n" );
		E12GenericUtility genericUtility = new E12GenericUtility();
		int domID = 1;
			
		DateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
		Calendar calendar = Calendar.getInstance();
		String currentDate  = dtFormat.format(calendar.getTime());
		currentDate =  genericUtility.getValidDateString(currentDate,  genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat());
		System.out.println("currentDate => " + currentDate);
		
		
			String transDB = checkNull( userInfo.getTransDB() );
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB );
			//String userCode = checkNull( userInfo.getLoginCode() );
			//String loginEmpCode = checkNull( userInfo.getEmpCode() );
		
			
			StrgMeetDCRWizard strgMeetDCRWizard = new StrgMeetDCRWizard();
			String mgrCode = strgMeetDCRWizard.getMGREmployee(loginEmpCode, conn);
			
			if( mgrCode.trim().length() > 0)
			{
				subOrdinateData = getempId(loginEmpCode,conn);
			
			}
			else
			{
				StringBuffer empIdBuff = new StringBuffer();
				subOrdinateData = empIdBuff.append("'").append(loginEmpCode).append("'").toString();
				
			}
			
		
			String brndCode = "";
			String brandCodeSql = "select distinct(brand_code) as brand_code from sprs_campgn_strg where tran_id in (select tran_id from sprs_campgn where sales_pers IN ("+subOrdinateData+") AND TRAN_TYPE='P')";
			pstmt1 = conn.prepareStatement(brandCodeSql);
			rs1 = pstmt1.executeQuery();
			while(rs1.next())
			{
				brndCode = genericUtility.checkNull( rs1.getString("brand_code") );
				if(brndCode != null && brndCode.length() > 0)
				{
					
					
					String maxTranSql = "select max(SC.TRAN_ID) as maxTranId from SPRS_CAMPGN SC,SPRS_CAMPGN_STRG SCS,STRG_CAMPAIGN SCM where SC.CAMPGN_ID=SCM.CAMPGN_ID AND SC.TRAN_ID=SCS.TRAN_ID and SC.TRAN_TYPE='P' "
							+ " and scs.brand_code=? AND ? BETWEEN SCM.EFF_FROM AND SCM.valid_upto+NVL(SCM.GRACE_DAYS, 0) group by sc.tran_date,SC.CAMPGN_ID,sc.sales_pers";
					pstmt = conn.prepareStatement(maxTranSql);
					pstmt.setString(1, brndCode);
					pstmt.setDate(2,java.sql.Date.valueOf(currentDate));

					rs = pstmt.executeQuery();
					while(rs.next())
					{
						maxId = genericUtility.checkNull( rs.getString("maxTranId") ) ;
						maxIdBuff.append(",'").append(maxId).append("'");
					}
					
					
					if (rs!= null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			if (rs1!= null)
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1!=null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if ( maxIdBuff.length() > 0 && maxIdBuff!=null )
			{
				
				maxIdComma = maxIdBuff.toString().substring(1);
			}
			else
			{
				maxIdComma = "''";
			}

			if("ALLINDIA".equalsIgnoreCase(dataGrp))
			{
				HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
				int rank=1;

				String allIndia = "  SELECT SUM ( a.RxCount ) AS RxCount, a.sales_pers AS sales_pers,a.DocCount,ROUND((a.RxCount / a.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
					    " FROM ( select sum(sprs_campgn_items.OUTCOME_NUM) as RxCount,count(distinct(sprs_campgn_items.strg_code)) as DocCount,sprs_campgn.sales_pers, B.sh_descr   AS grade " +
					    " from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
					    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.tran_id IN ("+maxIdComma+")  group by sprs_campgn.sales_pers,B.sh_descr  )a  GROUP BY  RxCount,sales_pers,DocCount,grade ORDER BY AVGRX DESC,RXCOUNT DESC " ; 


				
				pstmt =  conn.prepareStatement( allIndia );
				rs = pstmt.executeQuery();
				while(rs.next())
				{
				    String salesPers = checkNull(rs.getString( "sales_pers" ));
				    String Avg=checkNull( rs.getString( "AVGRX" ) );

				    
				    
					if(hashMap != null &&  hashMap.containsKey(Avg))
					{
						int existRank=hashMap.get(Avg);
					}
					else
					{
						hashMap.put(Avg , rank);
						if(loginEmpCode.equalsIgnoreCase(salesPers))
						{
							finalRank=rank;
							break;
						}
						rank++;
					}
					
					 

				}
				
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}

			if("REGION".equalsIgnoreCase(dataGrp))
			{
				HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
				int rank=1;
				String rsmEmpCode="";
				String rsmSql="SELECT EMP_CODE  from EMPLOYEE EMP ,GRADE G where EMP.EMP_CODE in(select EMP_CODE as REPORT_TO from EMPLOYEE O start with O.EMP_CODE= " + 
				"(select O.REPORT_TO from EMPLOYEE O where EMP_CODE=?) connect by prior REPORT_TO = EMP_CODE) " +
				"AND EMP.GRADE=G.GRADE_CODE AND G.LEVEL_NO=2 " ;
				pstmt =  conn.prepareStatement( rsmSql );
				pstmt.setString(1, loginEmpCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rsmEmpCode = checkNull(rs.getString( "EMP_CODE" ));

				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				String rsmsql1="select a.EMP_CODE as SALES_PERS from EMPLOYEE a, GRADE B where a.EMP_CODE in " + 
				"(select EMP_CODE from EMPLOYEE start with EMP_CODE=? connect by prior EMP_CODE = REPORT_TO) and a.GRADE = B.GRADE_CODE and B.LEVEL_NO='4'" ; 
				pstmt =  conn.prepareStatement( rsmsql1 );
				pstmt.setString(1, rsmEmpCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String rsmHierarchyEmpCode = checkNull(rs.getString( "SALES_PERS" ));
					rsmHierarchyList.add(rsmHierarchyEmpCode);
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(!rsmHierarchyList.isEmpty()) 
				{
					OrgStructure orgStructure = new OrgStructure();
					rsmHierarchyEmployee=orgStructure.getFormattedList(rsmHierarchyList);
				}
				if(rsmHierarchyEmployee==null || rsmHierarchyEmployee.trim().length()==0)
				{
					rsmHierarchyEmployee="'X'";
				}
				
				String region = " SELECT SUM ( a.RxCount )       AS RxCount, a.sales_pers         AS sales_pers,a.DocCount,ROUND((a.RxCount / a.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
					    " FROM ( select sum(sprs_campgn_items.OUTCOME_NUM) as RxCount,count(distinct(sprs_campgn_items.strg_code)) as DocCount,sprs_campgn.sales_pers, B.sh_descr   AS grade " +
					    "  from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
					    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.tran_id IN ("+maxIdComma+") AND SPRS_CAMPGN.SALES_PERS IN("+rsmHierarchyEmployee+")  group by sprs_campgn.sales_pers,B.sh_descr  )a  GROUP BY  RxCount,sales_pers,DocCount,grade ORDER BY AVGRX desc,RXCOUNT DESC   " ;

			
					pstmt =  conn.prepareStatement( region );
				
					rs = pstmt.executeQuery();
					while(rs.next())
					{

					    String salesPers = checkNull(rs.getString( "sales_pers" ));
					    String Avg=checkNull( rs.getString( "AVGRX" ) );

						if(hashMap != null &&  hashMap.containsKey(Avg))
						{
							int existRank=hashMap.get(Avg);
						}
						else
						{
							hashMap.put(Avg , rank);
							if(loginEmpCode.equalsIgnoreCase(salesPers))
							{
								finalRank=rank;
								break;
							}
							rank++;
						}
						
						
					}
					
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
			}

			if("ZONAL".equalsIgnoreCase(dataGrp))
			{
				HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
				int rank=1;

				String zonalEmpCode="";
				String zonalSql="SELECT EMP_CODE  from EMPLOYEE EMP ,GRADE G where EMP.EMP_CODE in(select EMP_CODE as REPORT_TO from EMPLOYEE O start with O.EMP_CODE= " + 
				"(select O.REPORT_TO from EMPLOYEE O where EMP_CODE=?) connect by prior REPORT_TO = EMP_CODE) " +
				"AND EMP.GRADE=G.GRADE_CODE AND G.LEVEL_NO=1 " ;
				pstmt =  conn.prepareStatement( zonalSql );
				pstmt.setString(1, loginEmpCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					zonalEmpCode = checkNull(rs.getString( "EMP_CODE" ));

				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				
				String zonalsql1="select a.EMP_CODE as SALES_PERS from EMPLOYEE a, GRADE B where a.EMP_CODE in " + 
				"(select EMP_CODE from EMPLOYEE start with EMP_CODE=? connect by prior EMP_CODE = REPORT_TO) and a.GRADE = B.GRADE_CODE and B.LEVEL_NO='4'" ; 
				pstmt =  conn.prepareStatement( zonalsql1 );
				pstmt.setString(1, zonalEmpCode);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					String zsmHierarchyEmpCode = checkNull(rs.getString( "SALES_PERS" ));
					zsmHierarchyList.add(zsmHierarchyEmpCode);
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if(!zsmHierarchyList.isEmpty()) 
				{
					OrgStructure orgStructure = new OrgStructure();
					zsmHierarchyEmployee=orgStructure.getFormattedList(zsmHierarchyList);
				}
				if(zsmHierarchyEmployee==null || zsmHierarchyEmployee.trim().length()==0)
				{
					zsmHierarchyEmployee="'X'";
				}
				
				
				String zonal =  "  SELECT SUM ( a.RxCount )       AS RxCount, a.sales_pers         AS sales_pers,a.DocCount,ROUND((a.RxCount / a.DocCount), 2) AS AVGRX, a.grade   AS grade    "   +
					    " FROM ( select sum(sprs_campgn_items.OUTCOME_NUM) as RxCount,count(distinct(sprs_campgn_items.strg_code)) as DocCount,sprs_campgn.sales_pers, B.sh_descr   AS grade " +
					    "  from sprs_campgn_items , sprs_campgn ,Employee A ,grade B 	" +
					    "  where sprs_campgn.tran_id = sprs_campgn_items.tran_id AND sprs_campgn.tran_type ='P' AND  A.Emp_code = sprs_campgn.sales_pers AND a.grade = b.grade_code AND sprs_campgn.tran_id IN ("+maxIdComma+") AND sprs_campgn.SALES_PERS IN("+zsmHierarchyEmployee+") group by sprs_campgn.sales_pers,B.sh_descr  )a  GROUP BY  RxCount,sales_pers,DocCount,grade ORDER BY AVGRX DESC,RXCOUNT DESC  " ;

					
					pstmt =  conn.prepareStatement( zonal );
				
					//pstmt.setString(1, campgnID);
					//pstmt.setString(2, checkNull( userInfo.getEmpCode() ));
					rs = pstmt.executeQuery();
					int loginSalesPersCnt3=1;
					boolean isLoginSalesPers3=false;
					while(rs.next())
					{


					    String salesPers = checkNull(rs.getString( "sales_pers" ));
					    String Avg=checkNull( rs.getString( "AVGRX" ) );

						if(hashMap != null &&  hashMap.containsKey(Avg))
						{
							int existRank=hashMap.get(Avg);
						}
						else
						{
							hashMap.put(Avg , rank);
							if(loginEmpCode.equalsIgnoreCase(salesPers))
							{
								finalRank=rank;
								break;
							}
							rank++;
						}
						
						
					
						
					}
					
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if ( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
			}


		//valueXmlString.append( "</Root>\r\n" );
	}
	catch (Exception e)
	{
		System.out.println("SellsStock.getAvgSellInOut() : "+e.getMessage());
		e.printStackTrace();
	}
	finally
	{
		try
		{
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(conn!= null && !conn.isClosed())
			{
				conn.close();
				conn = null;
			}
		}
		catch(SQLException se)
		{
			System.out.println("getBrandCompaignDoctor.finally["+se.getMessage()+"]");
			se.printStackTrace();
		}
	}
	
	System.out.println("data Group["+dataGrp+"]SalesPerson["+loginEmpCode+"]finalRank["+finalRank+"]");
	return finalRank;
}	
	
}