/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.servlet;

import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.wrkflw.SignManagerEJB;
import java.io.IOException;
import java.io.PrintWriter;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SignAjaxDataServlet
extends HttpServlet {
    protected InitialContext ctx = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession sess = null;
        try {
            BaseLogger.log("3", null, null, "\nXXXXXX SignAjaxDataServlet XXXXXXXXXXXXXX");
            if (this.ctx == null) {
                this.ctx = this.getInitialContext();
            }
            sess = request.getSession();
            BaseLogger.log("3", null, null, "\nsess.getId()............... :" + sess.getId());
            UserInfoBean userInfo = (UserInfoBean)sess.getAttribute("USER_INFO");
            String LoginCode = "";
            String EntityCode = "";
            if (userInfo == null) {
                request.getSession().invalidate();
                throw new BaseException(new Exception("SESSION_EXPIRED"));
            }
            EntityCode = userInfo.getEntityCode();
            LoginCode = userInfo.getLoginCode();
            SignManagerEJB signManager = new SignManagerEJB();
            String action = request.getParameter("ACTION");
            String status = request.getParameter("SIGNSTATUS");
            String roles = request.getParameter("ROLES");
            String ctx1 = request.getParameter("CONTEXT1");
            String ctx2 = request.getParameter("CONTEXT2");
            String ctx3 = request.getParameter("CONTEXT3");
            String isEntity = request.getParameter("ENTITYCOND");
            String isRole = request.getParameter("ROLECOND");
            BaseLogger.log("3", null, null, "\nAction: [" + action + "]");
            String SignXmlData = null;
            if (roles == null || roles != null && roles.trim().length() == 0) {
                BaseLogger.log("3", null, null, "roles resetting as blank");
                roles = "";
            }
            if (action.equalsIgnoreCase("ROLE")) {
                SignXmlData = signManager.getRoles(action, LoginCode, userInfo.getTransDB());
            } else if (action.equalsIgnoreCase("TREE")) {
                SignXmlData = signManager.getTree(action, roles, isEntity, isRole, EntityCode, userInfo.getTransDB());
            } else if (action.equalsIgnoreCase("TABLE")) {
                SignXmlData = signManager.getBrowData(action, status, roles, ctx1, ctx2, ctx3, EntityCode, userInfo.getTransDB());
            }
            SignXmlData.toString();
            response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
            response.setHeader("Cache-Control", "no-cache");
            response.getWriter().write(SignXmlData.toString());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception: " + e.getMessage());
            try {
                e.printStackTrace();
                E12GenericUtility genericUtility = new E12GenericUtility();
                PrintWriter writer = response.getWriter();
                String errMsg = "";
                if (request.getSession().getAttribute("ERR_MSG") == null) {
                    response.setContentType("text/xml; charset=" + CommonConstants.ENCODING);
                    errMsg = genericUtility.createErrorString(e);
                } else {
                    String sessMsg = (String)request.getSession().getAttribute("ERR_MSG");
                    response.setContentType("text/html; charset=" + CommonConstants.ENCODING);
                    errMsg = "ERR_MSG :" + sessMsg;
                }
                response.setContentLength(errMsg.length());
                writer.println(errMsg);
                writer.flush();
                writer.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private InitialContext getInitialContext() throws Exception {
        InitialContext ctx = null;
        try {
            AppConnectParm appConnect = new AppConnectParm();
            ctx = new InitialContext(appConnect.getProperty());
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception : SignAjaxDataServlet :getInitialContext :==>" + e.getMessage());
        }
        return ctx;
    }
}

