package ibase.utility;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.rmi.RemoteException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Matcher;
//By Sainath T. on 16/11/18
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.ejb.EJBHome;
import javax.imageio.ImageIO;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jcodec.api.FrameGrab;
import org.jcodec.common.model.Picture;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.itextpdf.text.pdf.PdfReader;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;

import ibase.bis.utility.BISDictionary;
import ibase.ejb.CommonDBAccessEJB;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.UploadFileEJB;
import ibase.webitm.utility.Column;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ResourceModifier;
import ibase.webitm.utility.TransIDGenerator;//Added by pranjali
import java.util.Enumeration;
import java.net.NetworkInterface;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.InterfaceAddress;

public class E12GenericUtility
{
	//Added by shrutika on 20-12-18 [Start] for perform itemchange one by one field in copy paste functionality.
	HashMap<String, String> editableListMap = new HashMap<String, String>();
	public HashMap<String, String> getEditableListMap() {
		return editableListMap;
	}
	//Added by shrutika on 20-12-18 [End] for perform itemchange one by one field in copy paste functionality.
	public E12GenericUtility()
	{
	}

	public Document parseString(String xmlString) throws ITMException
	{
		Document dom1 = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		OutputStreamWriter errorWriter = null;
		ByteArrayInputStream baos = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			if (xmlString != null && xmlString.length() > 0)
			{
				//Changed by Monif on 2/23/2009 [For special char parsing issue].
				xmlString = setXmlDec( xmlString );
				dbf = DocumentBuilderFactory.newInstance();//API	's use application to convert the xml data to the parse format (also creates the instance)
				dbf.setNamespaceAware(true);//change the xml tag value to those of xml understandable namespaces
				dbf.setIgnoringComments(true);//ignore the comments
				db = dbf.newDocumentBuilder();//simply converts xml data to the document (documnt object module)
				errorWriter = new OutputStreamWriter( System.err, CommonConstants.ENCODING );//writes the thing with the specific format hardcoded
				//Changed by Monif on 24/04/08 [TO support Character encoding ].
				//ByteArrayInputStream baos = new ByteArrayInputStream( xmlString.getBytes() );//(takes xml string and get there string to byte converted form)
				baos = new ByteArrayInputStream(xmlString.getBytes( CommonConstants.ENCODING ) );
				dom1 = db.parse(baos);//parse function of db takes the stream object and parses it accordingly and keeps the o/p in to the specified new dom

				//Added By Prajyot on 25-JAN-2013 [Close Input Stream]
				baos.close();
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][parseString] :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;

			try
			{
				if(errorWriter != null)
				{
					errorWriter.close();
				}
				if(baos != null)
				{
					baos.close();
				}
			}
			catch (IOException e)
			{
				throw new ITMException(e);
			}
			finally
			{
				errorWriter = null;
				baos = null;
			}
		}
		return dom1;
	}

	public byte[] transformToBytes(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix)throws ITMException
	{
		byte[] data = null;
		//Changed by Shravan on 21/05/2007 to close file io streams.
		FileInputStream  fis = null;
		ByteArrayOutputStream baos = null;
		ibase.utility.ValidateXMLInput vxi = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		//DANISH 04MAR2011
		String outputFileName = "";
		try
		{
			vxi = new ibase.utility.ValidateXMLInput();
			//DANISH 04MAR2011  -- outputFileName taken outside
			//String outputFileName = vxi.validate(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
			outputFileName = vxi.validate(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
			fis = new FileInputStream(outputFileName);
			baos = new ByteArrayOutputStream();
			int i = -1;
			while((i=fis.read())!=-1)
			{
				baos.write(i);
			}
			data = baos.toByteArray();
		}
		catch (ITMException itme)
		{
			throw itme;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( fis != null )
				{
					fis.close();
					fis = null;
				}
				if( baos != null )
				{
					baos.close();
					baos = null;
				}
				//DANISH 04MAR2011
				if( outputFileName.length() > 0 )
				{
					File tempFile = new File(outputFileName);
					tempFile.delete();
					tempFile = null;
				}
				//DANISH 04MAR2011

				vxi = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				outputFileName = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
			catch ( Exception e )
			{
				BaseLogger.log("0",null,null, "Exception in releasing file resource :" );
				e.printStackTrace();
			}
		}
		return data;
	}

	public String transformToString(String xslType, String xmlType, String targetDir, String fileNamePrefix, String fileNameSuffix)throws ITMException
	{
		String transformedString = "";
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		ibase.utility.ValidateXMLInput vxi = null;
		String outputFileName = null;
		File tempFile = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			vxi = new ibase.utility.ValidateXMLInput();
			outputFileName = vxi.validate(xslType, xmlType, targetDir, fileNamePrefix, fileNameSuffix);
			transformedString = readFile( outputFileName );
			//DANISH 04MAR2011
			tempFile = new File(outputFileName);
			tempFile.delete();
			tempFile = null;
			//DANISH 04MAR2011
		}
		catch (ITMException itme)
		{
			throw itme;
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			vxi = null;
			outputFileName = null;
			tempFile = null;
		}
		return transformedString;
	}

	public String readFile( String fileName ) throws Exception
	{
		StringBuffer fileContent = new StringBuffer();
		BufferedReader bfr = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		FileInputStream fMainIn = null;
		String outTempStr = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			fMainIn = new FileInputStream( fileName );
			bfr = new BufferedReader(new InputStreamReader(fMainIn, CommonConstants.ENCODING));
			while((outTempStr = bfr.readLine()) != null)
			{
				fileContent.append(outTempStr);
			}
			bfr.close();
			bfr = null;
		}
		catch ( Exception e )
		{
			throw e;
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if(fMainIn != null)
				{
					fMainIn.close();
				}
			}
			catch ( Exception e )
			{
				BaseLogger.log("0",null,null, "Exception in releasing file resource :[" + fileName + "]" );
				e.printStackTrace();
			}
			finally
			{
				fMainIn = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				outTempStr = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
		}
		return fileContent.toString();
	}

	public String serializeDom(Node dom)throws ITMException
	{
		String retString = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		ByteArrayOutputStream out = null;
		Transformer serializer = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			out = new ByteArrayOutputStream();
			serializer = TransformerFactory.newInstance().newTransformer();
			serializer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
			serializer.setOutputProperty(OutputKeys.ENCODING, CommonConstants.ENCODING);
			serializer.transform(new DOMSource(dom), new javax.xml.transform.stream.StreamResult(out));
			retString = out.toString( CommonConstants.ENCODING );
			out.flush();
			out.close();
			out = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : GenericUtility : serializeDom :"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			if(out != null)
			{
				try
				{
					out.close();
				}
				catch (IOException e)
				{
					throw new ITMException(e);
				}
				finally
				{
					out = null;
				}
			}

			serializer = null;
		}
		return retString;
	}

	//Changed by Monif on 2/23/2009 [For special char parsing issue].Start
	//Changed by Dayanand on 07/11/2011[ Remove Parsing exception As per KB and Danish Sir]
	//private static String removeAllDec( String xmlData )throws ITMException
	private synchronized String removeAllDec( String xmlData )throws ITMException
	{
		StringBuffer retXmlDataBuff = new StringBuffer();
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		String xmlDataFirst = null;
		String xmlDatasecond = null;
		String logFileName = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		//Added by Prasad on 14/04/17 [create local variable to perform operation]
		String xmlStr = xmlData;
		try
		{
			//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
			//BaseLogger.log("9",null,null,"removeAllDec : startsWith: ["+xmlStr.trim().startsWith("<?xml")+"]");
			if(xmlStr.trim().startsWith("<?xml"))
			{
				//Changed by Dayanand on 07/11/2011[ Remove Parsing exception As per KB and Danish Sir]
				//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
				//BaseLogger.log("9",null,null, "removeAllDec : startsWith" );
				xmlStr = xmlStr.substring(xmlStr.indexOf(">") + 1, xmlStr.length()).trim();
				retXmlDataBuff.append(xmlStr);
			}
			else if(xmlStr.indexOf("<?xml") != -1)
			{
				//Changed by Dayanand on 29/10/10 [Check Contains]
				if (xmlStr.contains("<?xml"))
				{
					//Changed by Dayanand on 07/11/2011[ Remove Parsing exception As per KB and Danish Sir]
					//String xmlDataFirst = xmlData.substring(0, xmlData.indexOf("<?xml")).trim();
					//String xmlDatasecond = xmlData.substring(xmlData.indexOf("<?xml"), xmlData.length());
					int idx = xmlStr.indexOf("<?xml");
					//Changed by Prasad on 14/04/17 [check length condition while substring data as per Danish Sir] START
					int strLen = xmlStr.length();
					//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
					//BaseLogger.log("9",null,null, "removeAllDec : contains :idx ["+idx+"], strLen ["+ strLen +"]" );
					if ( idx != -1 && strLen >= idx )
					{
						//Commented By Ravindra C on 06-09-18 for prevent SYSOUT.
						//BaseLogger.log("9",null,null, "removeAllDec : contains" );
						xmlDataFirst = xmlStr.substring( 0, idx ).trim();
						xmlDatasecond = xmlStr.substring( idx, strLen );
						xmlDatasecond = xmlDatasecond.substring( xmlDatasecond.indexOf(">") + 1, xmlDatasecond.length() ).trim();
						retXmlDataBuff.append( xmlDataFirst );
						retXmlDataBuff.append( xmlDatasecond );
					}
					//Changed by Prasad on 14/04/17 [check length condition while substring data as per Danish Sir] END
				}
			}
			else//Changed by Dayanand on 7/15/2011[ Added else incase above fails ]start
			{
				retXmlDataBuff.append(xmlStr);
			}
		}
		catch (Exception e)
		{
			//Changed by Dayanand on 26/10/10 [ TO GENERATE LOG]
			try
			{
				BaseLogger.log("3",null,null,"removeAllDecError : xmlData[" + xmlStr + "]");//Temporary added by Prajyot
				logFileName = generateLog( xmlStr, "removeAllDecError", "removeAllDecError", true );
				BaseLogger.log("3",null,null,"logFileName in removeAllDec["+logFileName+"]");
			}
			catch ( Exception ex )
			{
				BaseLogger.log("0",null,null,"Exception : E12GenericUtility : removeAllDec : generateLog"+ex);
				throw new ITMException(ex);
			}
			BaseLogger.log("3",null,null,"Exception : E12GenericUtility : removeAllDec :"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			xmlDataFirst = null;
			xmlDatasecond = null;
			logFileName = null;
		}
		return retXmlDataBuff.toString();
	}

	//Changed by Dayanand on 7/15/2011[ synchronized remAllXmlDec method]
	//public String remAllXmlDec( String xmlDomStr  )throws ITMException
	public synchronized String remAllXmlDec( String xmlDomStr  )throws ITMException
	{
		try
		{
			for(boolean isXmlDecExist = true; (xmlDomStr != null) && (isXmlDecExist);)
			{
				if(xmlDomStr.indexOf("<?xml") != -1)
				{
					//Changed by Dayanand on 29/10/10 [Check Contains]
					if ( xmlDomStr.contains("<?xml") )
					{
						xmlDomStr = removeAllDec(xmlDomStr);
					}
				}
				else
				{
					isXmlDecExist = false;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : GenericUtility : remAllXmlDec :"+e);
			throw new ITMException(e);
		}
		return xmlDomStr;
	}

	public String setXmlDec( String xmlDomStr  )throws ITMException
	{
		StringBuffer xmlStrBuff = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			if (xmlDomStr != null && xmlDomStr.length() > 0)
			{
				//Changed by Dayanand on 7/15/2011[ check <?xml in xmlDomStr before it pass to remAllXmlDec ]start
				if( xmlDomStr.indexOf("<?xml") != -1)
				{
					xmlDomStr = remAllXmlDec( xmlDomStr );
				}
				xmlStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>");
				xmlStrBuff.append(xmlDomStr);
				xmlDomStr = xmlStrBuff.toString();
				/* Commented to revert changes temporary
// Need to find all sources from where <?xml declration get added
				//Changes by Prajyot on 09-JUL-2014 [For XML Declaration string update]Starts
				//if( xmlDomStr.indexOf("<?xml") != -1)
				//{
				//	xmlDomStr = remAllXmlDec( xmlDomStr );
				//}
				int startIdx = xmlDomStr.indexOf("<?xml");
				int endIdx = xmlDomStr.lastIndexOf("<?xml");

				if( xmlDomStr.startsWith("<?xml") && startIdx != -1 )
			 	{
					if( startIdx == endIdx ) // Both startIdx and endIdx are equal means string has only one occurrence of <?xml
					{
						return xmlDomStr;
					}
					else // Both startIdx and endIdx are not equal means string has more than one occurrences of <?xml
					{
						generateLog(xmlDomStr, "XML has more than one occurrences of xmlDec tag", "XMLDecError_", false);
						String errorMsg = "XML String has more than one occurrences of xmlDec tag";
						BaseLogger.log("9",null,null,"Exception :GenericUtility : : setXmlDec :"+ errorMsg);
						throw new ITMException( new Exception(errorMsg) );
					}
			 	}
				else  // Occurrences of <?xml this string not found, Appending XML Declaration tag and returning.
			 	{
					StringBuffer xmlStrBuff = new StringBuffer("<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>");
					xmlStrBuff.append(xmlDomStr);
					xmlDomStr = xmlStrBuff.toString();
			 	}
				//Changes by Prajyot on 09-JUL-2014[For XML Declaration string update]Starts
				 */
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility : : setXmlDec :"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			xmlStrBuff = null;
		}
		return xmlDomStr;
	}

	public String serializeDom(Node dom, boolean spclCharParsing )throws ITMException
	{
		String retString = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		ByteArrayOutputStream out = null;
		Transformer serializer = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			out = new ByteArrayOutputStream();
			serializer = TransformerFactory.newInstance().newTransformer();
			if( dom.getNodeType() == Node.ELEMENT_NODE )
			{
				serializer.setOutputProperty( OutputKeys.OMIT_XML_DECLARATION, "yes" );
			}
			serializer.setOutputProperty(OutputKeys.ENCODING, CommonConstants.ENCODING );
			serializer.transform(new DOMSource(dom), new javax.xml.transform.stream.StreamResult(out));
			//Changed by Dayanand on 7/26/2011[ Apply CommonConstants.ENCODING for serialized dom ]
			//retString = out.toString();
			retString = out.toString( CommonConstants.ENCODING );
			out.flush();
			out.close();
			out = null;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility : : serializeDom :"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			if(out != null)
			{
				try
				{
					out.close();
				}
				catch (IOException e)
				{
					throw new ITMException(e);
				}
				finally
				{
					out = null;
				}
			}

			serializer = null;
		}
		return retString;
	}
	//Changed by Monif on 2/23/2009 [For special char parsing issue].End

	public String getColumnValue( String colName, Document dom ) throws ITMException
	{
		String colValue ="";
		try
		{
			colValue = getColumnValue(colName,dom,"0");
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][getColumnValue(1)] :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return colValue;
	}

	public String getColumnValue(String colName, Document dom, String formNo) throws ITMException
	{
		Node elementName = null, parentNode = null;
		NodeList elementList = null;
		Element elementAttr = null;
		String columnName = "";
		String columnValue = null;
		boolean continueLoop = true;
		boolean isFormNo = false;
		int ctr;
		try
		{
			elementList = dom.getElementsByTagName(colName);
			if (Integer.parseInt(formNo) < 1)//parseInt takes the String type as input and treats the value as a particulas integer value.
			{
				isFormNo = true;
			}
			for(ctr = 0; ctr < elementList.getLength(); ctr++)
			{
				elementName = elementList.item(ctr);//item returns the indexed item in the collection
				parentNode = elementName.getParentNode();//get the parent node name
				elementAttr = (Element)parentNode;
				if(elementAttr.getAttribute("objContext").equals(formNo) || elementAttr.getAttribute("formno").equals(formNo) || isFormNo)
				{
					columnName = elementName.getNodeName();//name of the node stored in the string
					columnValue = "";//column value is not set to null here still till now
					if(elementName.getFirstChild()!=null)//first child of the node !equals to null then
					{
						columnValue = elementName.getFirstChild().getNodeValue();
					}
					else
					{
						columnValue = null;
					}
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][getColumnValue(2)] :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			elementName = null;
			parentNode = null;
			elementList = null;
			elementAttr = null;
			columnName = null;
		}
		return columnValue;
	}

	//Changed by Nazia on 7/7/2008 [New methode with pass column value from specific form and row no WI89BAS005]Start
	public String getColumnValue(String colName, Document dom, String formNo,String rowNo) throws ITMException
	{
		String returnVal = "";
		//BaseLogger.log("9",null,null,"GenericUtility:: getColumnValue() :  formNo["+formNo+"]  ["+formNo+"], rowNo["+rowNo+"]");
		Node elementName = null;
		NodeList elementList = null;
		Element elementAttr = null;
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		int pNode = 0;
		int ctr = 0;
		int noOfChilds = 0;
		int currentFormNo = 0;
		int parentNodes= 0 ;
		String columnName = "";
		String columnValue = null;
		boolean isFormNo = false;
		try
		{
			if ( formNo != null && formNo.length()>0 )
			{
				if (Integer.parseInt(formNo) < 1)//parseInt takes the String type as input and treats the value as a particulas integer value.
				{
					isFormNo = true;
				}
			}
			if ( rowNo == null || ("").equals(rowNo) )
			{
				parentList = dom.getElementsByTagName("Detail"+formNo);
				parentNodes = parentList.getLength();
				BaseLogger.log("3",null,null," GenericUtility::parentList.getLength  ["+parentList.getLength()+"]  ");
				for( pNode = 0 ; pNode< parentNodes; pNode++ )//For loop for detail
				{
					parentNode = parentList.item(pNode);
					childList = parentNode.getChildNodes();
					noOfChilds = childList.getLength();
					BaseLogger.log("3",null,null,"noOfChilds length  ["+noOfChilds+"]");
					for (ctr = 0; ctr < noOfChilds; ctr++)//for loop for row no in detail
					{
						childNode = childList.item(ctr);
						childNodeName = childNode.getNodeName();
						if(childNodeName.equals(colName))
						{
							if(childNode.getFirstChild()!=null)
							{
								columnValue = childNode.getFirstChild().getNodeValue().trim();
								returnVal = (pNode == 0)?columnValue:returnVal+","+columnValue;
							}
						}
					}
				}

			}
			else
			{
				elementList = dom.getElementsByTagName(colName);
				for(ctr = 0; ctr < elementList.getLength(); ctr++)
				{
					elementName = elementList.item(ctr);//item returns the indexed item in the collection
					parentNode = elementName.getParentNode();//get the parent node name
					elementAttr = (Element)parentNode;
					if(elementAttr.getAttribute("objContext").equals(formNo) || elementAttr.getAttribute("formno").equals(formNo) || isFormNo)
					{
						if(elementAttr.getAttribute("domID").equals(rowNo))
						{
							columnName = elementName.getNodeName();//name of the node stored in the string
							columnValue = "";//column value is not set to null here still till now
							if(elementName.getFirstChild()!=null)//first child of the node !equals to null then
							{
								returnVal = elementName.getFirstChild().getNodeValue();
							}
							else
							{
								returnVal = null;
							}
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : GenericUtility: getColumnValue() :==>\n"+e.getMessage());
			//e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			elementName = null;
			elementList = null;
			elementAttr = null;
			parentList = null;
			childList = null;
			parentNode = null;
			childNode = null;
			childNodeName = null;
			columnName = null;
			columnValue = null;
		}
		BaseLogger.log("2",null,null," returnVal ["+returnVal+"]");
		return returnVal;
	}
	//Changed by Nazia on 7/7/2008 [New methode with pass column value from specific form and row no WI89BAS005]end

	public String getColumnValueFromNode( String colName, Node detailNode )throws ITMException
	{
		String colValue = null;
		NodeList childList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			childList = detailNode.getChildNodes();
			int noOfChilds = childList.getLength();
			for(int colCtr = 0; colCtr < noOfChilds; colCtr++)
			{
				Node colNode = childList.item(colCtr);
				if(colNode != null && colNode.getNodeType() == Node.ELEMENT_NODE)
				{
					if(colNode.getNodeName().equals(colName))
					{
						if(colNode.getFirstChild() != null)
						{
							colValue = colNode.getFirstChild().getNodeValue();
						}
						break;
					}
				}
				colNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			childList = null;
		}
		return colValue;
	}

	public ArrayList getTokenList(String tokenString, String delimiter) throws Exception
	{
		BaseLogger.log("2",null,null,"getTokenList tokenString :["+tokenString+"] delimiter :["+delimiter+"]");
		ArrayList returnList = null;
		if ( tokenString != null && tokenString.length() > 0 )
		{
			returnList = new ArrayList();
			while (tokenString.indexOf( delimiter ) != -1)
			{
				int endIndex = tokenString.indexOf(delimiter);
				returnList.add(tokenString.substring(0, endIndex));
				tokenString = tokenString.substring(endIndex + delimiter.length(), tokenString.length());
			}
			returnList.add(tokenString.substring( 0, tokenString.length() ) );
		}
		return returnList;
	}

	public java.util.Date getDateObject(String date) throws ITMException
	{
		java.util.Date dat = null;
		DateFormat df = null;
		SimpleDateFormat simpleDateFormat = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			simpleDateFormat = new SimpleDateFormat(getApplDateFormat());
			dat = simpleDateFormat.parse(date);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDateObject :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			df = null;
			simpleDateFormat = null;
		}
		return dat;
	}

	public String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException
	{
		//BaseLogger.log("9",null,null,"[GenericUtility]Converting dateStr :["+dateStr+"] From format :["+sourceDateFormat +"] To Format :["+targetDateFormat+"]");
		Object date = null;
		SimpleDateFormat sdfOutput = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		String retDateStr = "";
		try
		{
			if (!(sourceDateFormat.equalsIgnoreCase(targetDateFormat)))
			{
				if (sourceDateFormat.indexOf("/") != -1)
				{
					dateStr.replace('/', '-');
				}
				else if (sourceDateFormat.indexOf(".") != -1)
				{
					dateStr.replace('.', '-');
				}

				date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
				sdfOutput = new SimpleDateFormat(targetDateFormat);
				retDateStr = sdfOutput.format(date);
			}
			else
			{
				retDateStr = dateStr;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			sdfOutput = null;
			date = null;
		}
		//BaseLogger.log("9",null,null,"[GenericUtility]Converted Datestr :["+retDateStr+"]");
		return retDateStr;
	}

	public String getValidDateTimeString( String dateTimeStr, String sourceDateTimeFormat, String targetDateTimeFormat ) throws ITMException
	{
		//BaseLogger.log("9",null,null, "Getting the valid datetime string for dateTimeStr :["+dateTimeStr+"] which is in format :["+sourceDateTimeFormat+"]" );
		Object date = null;
		SimpleDateFormat sdfOutput =null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		String retDateStr = "";
		try
		{
			if ( ! ( sourceDateTimeFormat.equalsIgnoreCase( targetDateTimeFormat ) ) )
			{
				if ( sourceDateTimeFormat.indexOf( "/" ) != -1 )
				{
					dateTimeStr.replace( '/', '-' );
				}
				else if ( sourceDateTimeFormat.indexOf( "." ) != -1 )
				{
					dateTimeStr.replace( '.', '-' );
				}
				//Changed by Madhup on 27/06/2007 accomodating DateTime Format.Start
				/*date = new SimpleDateFormat(sourceDateTimeFormat+" HH:mm:ss").parse(dateTimeStr+" 00:00:00");
				SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateTimeFormat+" HH:mm:ss");
				retDateStr = sdfOutput.format(date);*/
				if(sourceDateTimeFormat.toLowerCase().indexOf("hh:mm:ss") != -1)
				{
					if(dateTimeStr.indexOf("00:00:00") == -1)
					{
						date = new SimpleDateFormat(sourceDateTimeFormat).parse(dateTimeStr+" 00:00:00");
					}
					else
					{
						date = new SimpleDateFormat(sourceDateTimeFormat).parse(dateTimeStr);
					}

					if(targetDateTimeFormat.toLowerCase().indexOf("hh:mm:ss")==-1)
					{
						sdfOutput = new SimpleDateFormat(targetDateTimeFormat+" HH:mm:ss");
					}
					else
					{
						sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
					}
					retDateStr = sdfOutput.format(date);
				}
				else
				{
					if(dateTimeStr.indexOf("00:00:00") == -1)
					{
						date = new SimpleDateFormat(sourceDateTimeFormat+" HH:mm:ss").parse(dateTimeStr+" 00:00:00");
					}
					else
					{
						date = new SimpleDateFormat(sourceDateTimeFormat+" HH:mm:ss").parse(dateTimeStr);
					}
					if(targetDateTimeFormat.toLowerCase().indexOf("hh:mm:ss")==-1)
					{
						sdfOutput = new SimpleDateFormat(targetDateTimeFormat+" HH:mm:ss");
					}
					else
					{
						sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
					}
					retDateStr = sdfOutput.format(date);
				}
				//Changed by Madhup on 27/06/2007 accomodating DateTime Format.End
			}
			else
			{
				retDateStr = dateTimeStr;
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage() );
			throw new ITMException( e );
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			sdfOutput = null;
			date = null;
		}
		//BaseLogger.log("9",null,null, "retDateStr :[" + retDateStr + "]" );
		return retDateStr;
	}

	public String getDispDateFormat()throws ITMException,Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		Node ndDateFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if (CommonConstants.DISP_DATE_FORMAT == null || CommonConstants.DISP_DATE_FORMAT.trim().length() == 0 )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();
				//BaseLogger.log("9",null,null,"[GenericUtility] CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName("DISP_DATE_FORMAT");
				ndDateFormat = nlDateFormat.item(0);
				//dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
				//Changed by Madhup on 12/07/07 to check for null.
				if( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
				{
					CommonConstants.DISP_DATE_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDispDateFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
			ndDateFormat = null;
		}
		//Changes By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
		//return CommonConstants.DISP_DATE_FORMAT;

		return getValidDateFormat( CommonConstants.DISP_DATE_FORMAT );
	}

	public String getDispDateTimeFormat()throws ITMException,Exception
	{
		//String dateFormatStr = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		Node ndDateFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			if ( CommonConstants.DISP_DATETIME_FORMAT == null || CommonConstants.DISP_DATETIME_FORMAT.trim().length() == 0 )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();
				//BaseLogger.log("9",null,null,"[GenericUtility] CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName( "DISP_DATETIME_FORMAT" );
				ndDateFormat = nlDateFormat.item(0);
				//Changed by Madhup on 12/07/07 to check for null.
				if( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
				{
					CommonConstants.DISP_DATETIME_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDispDateFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
			ndDateFormat = null;
		}
		//Changes By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
		//return CommonConstants.DISP_DATETIME_FORMAT;
		return getValidDateFormat( CommonConstants.DISP_DATETIME_FORMAT );
	}

	public String getApplDateTimeFormat()throws ITMException,Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		Node ndDateFormat = null;
		String dateTimeFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		//String dateFormatStr = null;//Danish Saturday, July 01, 2006
		try
		{
			if (CommonConstants.APPL_DATETIME_FORMAT == null || CommonConstants.APPL_DATETIME_FORMAT.trim().length() == 0 )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();
				//BaseLogger.log("9",null,null,"[GenericUtility] CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName("APPL_DATETIME_FORMAT");
				ndDateFormat = nlDateFormat.item(0);
				//Changed by Madhup on 12/07/07 to check for null.
				if( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
				{
					dateTimeFormat = ndDateFormat.getFirstChild().getNodeValue();
					BaseLogger.log("3",null,null,"dateTimeFormat["+ dateTimeFormat +"]");
					if( dateTimeFormat.endsWith( "HH:mm" ) )
					{
						dateTimeFormat = dateTimeFormat + ":ss";
					}
					BaseLogger.log("3",null,null,"dateTimeFormat Assign SS["+ dateTimeFormat +"]");
					CommonConstants.APPL_DATETIME_FORMAT = dateTimeFormat;
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getApplDateTimeFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
			ndDateFormat = null;
			dateTimeFormat = null;
		}
		//Changes By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
		//return CommonConstants.APPL_DATETIME_FORMAT;
		return getValidDateFormat( CommonConstants.APPL_DATETIME_FORMAT );
	}

	public String getApplDateFormat()throws ITMException,Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		Node ndDateFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		//String dateFormatStr = null;
		try
		{
			if ( CommonConstants.APPL_DATE_FORMAT == null || CommonConstants.APPL_DATE_FORMAT.trim().length() == 0 )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();
				//BaseLogger.log("9",null,null,"[GenericUtility] CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName("APPL_DATE_FORMAT");
				ndDateFormat = nlDateFormat.item(0);

				//Changed by Madhup on 12/07/07 to check for null.
				if( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
				{
					CommonConstants.APPL_DATE_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getApplDateFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
			ndDateFormat = null;
		}
		//Changes By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
		//return CommonConstants.APPL_DATE_FORMAT;
		return getValidDateFormat( CommonConstants.APPL_DATE_FORMAT );
	}

	public String getDBDateFormat()throws ITMException,Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		Node ndDateFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		//String dateFormatStr = null;
		try
		{
			if ( CommonConstants.DB_DATE_FORMAT == null || CommonConstants.DB_DATE_FORMAT.trim().length() == 0 )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();
				//9",null,null,"[GenericUtility] CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName("DB_DATE_FORMAT");
				ndDateFormat = nlDateFormat.item(0);
				//Changed by Madhup on 12/07/07 to check for null.
				if( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
				{
					CommonConstants.DB_DATE_FORMAT  = ndDateFormat.getFirstChild().getNodeValue();
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDBDateFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
			ndDateFormat = null;
		}
		//Changes By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
		//return CommonConstants.DB_DATE_FORMAT ;
		return getValidDateFormat( CommonConstants.DB_DATE_FORMAT );
	}

	// changed by Roshan 08/10/07  to get time Format.Start
	public String getDisplayTimeFormat() throws ITMException, Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		Node ndDateFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if (CommonConstants.DISP_TIME_FORMAT == null || CommonConstants.DISP_TIME_FORMAT.trim().length() == 0 )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName("DISP_TIME_FORMAT");
				ndDateFormat = nlDateFormat.item(0);

				if( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
				{
					CommonConstants.DISP_TIME_FORMAT = ndDateFormat.getFirstChild().getNodeValue();
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDisplayTimeFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
			ndDateFormat = null;
		}
		//Changes By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
		//return CommonConstants.DISP_TIME_FORMAT;
		return getValidDateFormat( CommonConstants.DISP_TIME_FORMAT );
	}
	// changed by Roshan 08/10/07  to get time Format.End

	public java.util.Date getDateTimeObject(String date) throws ITMException
	{
		java.util.Date dat = null;
		DateFormat df = null;
		SimpleDateFormat simpleDateFormat = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			simpleDateFormat = new SimpleDateFormat(getApplDateTimeFormat());
			dat = simpleDateFormat.parse(date);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDateTimeObject :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			df = null;
			simpleDateFormat = null;
		}
		return dat;
	}

	public float timeDiff(java.util.Date d1, java.util.Date d2)throws ITMException
	{
		long t1 = d1.getTime();
		long t2 = d2.getTime();
		long t3 = t1 - t2;
		float hr  = (float)((float)t3/(60.00f*1000.00f*60.00f));
		float min = ((int)((hr - (int)hr) * 60))/100.00f;
		float time = (int)(hr) + min;

		return time;
	}

	public int getParameterCount(String str)throws ITMException
	{
		int indx = 0;
		int cnt = 0;
		try
		{
			while(indx != -1)
			{
				indx++ ;
				indx=str.indexOf('?',indx);
				cnt++;
			}
			cnt--;
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : GenericUtility : genParameterCount :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return cnt;
	}

	public String getValueFromXTRA_PARAMS( String xtraParams, String searchParam ) throws ITMException
	{
		String searchParamVal = "";
		try
		{
			int searchParamPos = xtraParams.indexOf( searchParam );
			//Changed by Prasad on 20/02/18 [check index of provided serachParam, if not then return empty] START
			if ( searchParamPos != -1 )
			{
				int equalsPos = xtraParams.indexOf( "=", searchParamPos );

				int endPos = xtraParams.indexOf( "~", equalsPos );
				if ( endPos < 0 )
				{
					endPos = xtraParams.length();
				}
				searchParamVal = xtraParams.substring( equalsPos + 1, endPos );
				if( searchParamVal != null && ("null".equalsIgnoreCase(searchParamVal) || "undefined".equalsIgnoreCase(searchParamVal)) )
				{
					searchParamVal = "";
				}
			}
			else
			{
				BaseLogger.log("3",null,null, searchParam + " index not found in xtraParam" );
			}
			//Changed by Prasad on 20/02/18 [check index of provided serachParam, if not then return empty] END
			BaseLogger.log("3",null,null, "Value of "+searchParam+" : ["+searchParamVal+"]" );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValueFromXTRA_PARAMS :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return searchParamVal;
	}

	public String createErrorString(Exception e)
	{
		ITMException ie = new ITMException(e);
		String errString = "<?xml version=\"1.0\"?>\r\n" + ie.getMessage();
		ie = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		return errString;
	}

	//Added by Ravindra on 11/05/2021 [to get exception in JSON format] START
	public String createErrorString(Exception e, String dataFormat)
	{
		ITMException ie = new ITMException(dataFormat, e);
		String errString = ie.getMessage();
		if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
		{
			errString = "<?xml version=\"1.0\"?>\r\n" + errString;
		}
		ie = null;
		return errString;
	}
	//Added by Ravindra on 11/05/2021 [to get exception in JSON format] END

	public String formatDouble(double value, int sigDigit)throws ITMException
	{
		BaseLogger.log("2",null,null,"GenericUtility=>Converting double value ["+value+"] by formatDouble()");
		String retValue = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		BigDecimal bgd = null;
		String decimalStr = null;
		String afterSigDigit = null;
		DecimalFormat dec = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			retValue = String.valueOf(value);
			if(retValue.indexOf('E') != -1)
			{
				bgd = new BigDecimal(value);
				retValue = bgd.toString();
			}
			int indexOfDot = retValue.indexOf(".");
			if(indexOfDot != -1)
			{
				int noOfDigitsAfterDot = retValue.substring(indexOfDot+1).length();
				double tempDouble = 0;
				if(noOfDigitsAfterDot > sigDigit)
				{
					decimalStr = retValue.substring(0,(indexOfDot+sigDigit+1));
					afterSigDigit = retValue.substring((indexOfDot + sigDigit+1), (indexOfDot + sigDigit+2));
					int afterSigDigitInt = Integer.parseInt(afterSigDigit);
					if(afterSigDigitInt >= 5)
					{
						tempDouble = Double.parseDouble(decimalStr) + (1/Math.pow(10, sigDigit));
					}
					else
					{
						tempDouble = Double.parseDouble(decimalStr);
					}
				}
				else
				{
					tempDouble = Double.parseDouble(retValue);
				}
				dec = new DecimalFormat();
				dec.applyPattern("#.#");
				dec.setMaximumFractionDigits(sigDigit);
				retValue = dec.format(tempDouble);
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			bgd = null;
			decimalStr = null;
			afterSigDigit = null;
			dec = null;
		}
		BaseLogger.log("2",null,null,"GenericUtility=>Returning converted string from by formatDouble():["+retValue+"]");
		return retValue;
	}

	public String getNormalizeString(String nodeString)throws ITMException
	{
		StringBuffer tempStringBuff = new StringBuffer();
		try
		{
			//Changed by Pramod on 06-01-11[ WI01SUN021 || Set encoding from CommonConstants]
			//tempStringBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?>");
			tempStringBuff.append("<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>");
			tempStringBuff.append("<DocumentRoot>");
			tempStringBuff.append("<description>Datawindow Root</description>");
			tempStringBuff.append("<group0>");
			tempStringBuff.append("<description>Group0 description</description>");
			tempStringBuff.append("<Header0>");
			tempStringBuff.append("<description>Header0 members</description>");

			tempStringBuff.append(nodeString);

			tempStringBuff.append("</Header0>");
			tempStringBuff.append("</group0>");
			tempStringBuff.append("</DocumentRoot>");
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getNormalizeString :==>\n"+e);
			//e.printStackTrace();
			throw new ITMException(e);
		}
		return tempStringBuff.toString();
	}

	public String initCap(String dataString, String wordSeparator)throws ITMException
	{
		//BaseLogger.log("9",null,null,"dataString ["+dataString+"]");
		//String retStr = "";
		try
		{
			/*//Changed By Dhruv on 16/01/2007
			StringTokenizer dataBuffer = new StringTokenizer( dataString, wordSeparator );
			while ( dataBuffer.hasMoreElements() )
			{
				String currentToken = ( String )dataBuffer.nextElement();
				String firstStr = currentToken.substring( 0, 1 );
				currentToken = firstStr.toUpperCase() + currentToken.substring( 1 );
				retStr += currentToken + wordSeparator;
			}*/

			int index = 0;
			do
			{
				StringBuffer dataStringBuffer = new StringBuffer(dataString);
				dataStringBuffer.replace(index, index+1, dataString.substring(index, index+1).toUpperCase());
				dataString = dataStringBuffer.toString();
				dataStringBuffer = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				index = dataString.indexOf( wordSeparator, index + 1 );
				index = index+1;
			}
			while(index != 0);

		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :initCap :==>\n"+e);
			throw new ITMException(e);
		}
		//BaseLogger.log("9",null,null,"GenericUtility : initCap : returning : dataString "+dataString);
		return dataString;
	}

	//Changed by Danish on 28/08/2006 added as utility to set "" to nodevalue
	public String removeElementValues( String xmlString, String elements, String sep )throws ITMException
	{
		BaseLogger.log("2",null,null,"Removing Element Values :["+elements+"]");
		Document document = null;
		StringTokenizer elementsStrTokenizer = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		String detailXMLString = "";
		try
		{
			document = parseString(xmlString);
			elementsStrTokenizer = new StringTokenizer(elements, sep);
			while ( elementsStrTokenizer.hasMoreTokens() )
			{
				String nextToken = elementsStrTokenizer.nextToken() ;
				NodeList elementNodeList = document.getElementsByTagName(nextToken.trim());
				int nodeListLen = elementNodeList.getLength();
				for (int i = 0; i < nodeListLen ; i++ )
				{
					Node element = elementNodeList.item(i);
					String val = null;
					element.getFirstChild().setNodeValue(detailXMLString);
				}
				//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				nextToken = null;
				elementNodeList = null;
				//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
			//detailXMLString = getNormalizedString(serializeDom(document));
			detailXMLString = serializeDom(document);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :MasterStatefulEJB : removeElementValues :==>\n"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			document = null;
			elementsStrTokenizer = null;
		}
		return detailXMLString;
	}

	public boolean isNodePresent( String colName, String formNo, Document dom ) throws ITMException
	{
		NodeList nodeList = null;
		NodeList detailNodeList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		boolean isColumn = false;

		try
		{
			detailNodeList = dom.getElementsByTagName( "Detail" + formNo );
			if( detailNodeList.item( 0 ) != null )
			{
				nodeList = detailNodeList.item(0).getChildNodes();
			}
			for(int i = 0;i < nodeList.getLength(); i++ )
			{
				Node childNode = nodeList.item(i);
				if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE && childNode.getNodeName().equalsIgnoreCase( colName ) )
				{
					isColumn = true;
					childNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					break;
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][getColumnValue(2)] :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			nodeList = null;
			detailNodeList = null;
		}
		return isColumn;
	}

	//Changed by Danish on 26/03/2007 added to generate tabseparated data alternatively through transformation.
	public String generateTabSeparatedData( String xmlData, String objContext, String domID ) throws ITMException
	{
		StringBuffer tabSepDataBuff = new StringBuffer();
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		Node detailNode = null;
		NodeList detailNodeList = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			detailNode = searchNode( parseString( xmlData ), objContext, domID);

			if( detailNode != null && detailNode.getNodeType() == Node.ELEMENT_NODE &&  detailNode.getNodeName().startsWith( "Detail" ) )
			{
				detailNodeList = detailNode.getChildNodes();
				int detailNodeListLen = detailNodeList.getLength();

				for(int i = 0; i < detailNodeListLen; i++ )
				{
					Node childNode = detailNodeList.item(i);
					//Added By Prajyot [Check for DB_ID to omit DB_ID from tabseparated data]
					//if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE  && ! childNode.getNodeName().equalsIgnoreCase( "attribute" ) )
					if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE  && ! childNode.getNodeName().equalsIgnoreCase( "attribute" ) && ! childNode.getNodeName().equalsIgnoreCase( "DB_ID" ) )
					{
						String nodeVal = ( ( childNode.getFirstChild() != null ) ?  childNode.getFirstChild().getNodeValue() : "" );
						tabSepDataBuff.append( nodeVal );
						nodeVal = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						if ( i > 0 && i != detailNodeListLen)
						{
							tabSepDataBuff.append("\t");
						}
					}
					childNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][ generateTabSeparatedData ] :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			detailNode = null;
			detailNodeList = null;
		}
		return tabSepDataBuff.toString();
	}

	//Changed by Kunjal on 24-03-07.
	public Document parseFile( Object sourceXMLFile )throws Exception
	{
		Document dom = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		File file = null;
		DocumentBuilderFactory dbf = null;
		DocumentBuilder parser = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if( sourceXMLFile.getClass().getName().equalsIgnoreCase( "java.lang.String" ) )
			{
				file = new File((String)sourceXMLFile);
			}
			else
			{
				file = (File)sourceXMLFile;
			}
			dbf = DocumentBuilderFactory.newInstance();
			dbf.setNamespaceAware(true);
			dbf.setIgnoringComments(true);
			parser = dbf.newDocumentBuilder();
			dom = parser.parse(file);
		}
		catch(Exception e)
		{
			dom = null;
			BaseLogger.log("0",null,null,"Exception :GenericUtility :parseFile :\n"+e.getMessage());
			//BaseLogger.log("9",null,null,"Exception :ETLControllerEJB :parseFile :\n"+e);
			throw e;
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			file = null;
			dbf = null;
			parser = null;
		}
		return dom;
	}

	//Changed by Danish on 26/03/2007 added to generate add dom alternatively through transformation.
	public String createITMAddDom(String objName, String objCtx, String xmlFileName )throws ITMException
	{
		StringBuffer itmAddDomBuff = new StringBuffer();
		BaseLogger.log("3",null,null, " -------------44444444--------- Calling GenericUtility for creating ITMAddDom...." );
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		Document dom = null;
		NodeList tableColNodeList = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if(xmlFileName != null)
			{
				//Changed by Pramod on 06-01-11[ WI01SUN021 || Set encoding from CommonConstants]
				//itmAddDomBuff.append("<?xml version='1.0' encoding='utf-8'?>");
				itmAddDomBuff.append("<?xml version='1.0' encoding='"+CommonConstants.ENCODING+"'?>");
				itmAddDomBuff.append("<DocumentRoot>");
				itmAddDomBuff.append("<description>Datawindow Root</description>");
				itmAddDomBuff.append("<group0>");
				itmAddDomBuff.append("<description>Group0 description</description>");
				itmAddDomBuff.append("<Header0>");
				itmAddDomBuff.append("<description>Header0 members</description>");
				if( objName.equalsIgnoreCase( "TAXTRAN" ) )
				{
					itmAddDomBuff.append("<Tax domID=''>");
				}
				else
				{
					itmAddDomBuff.append("<Detail"+objCtx+" dbID='' domID='' objName='"+objName+"' objContext='"+objCtx+"'>");
				}

				itmAddDomBuff.append("<attribute pkNames='' status='N' updateFlag='A' selected='N'/>");

				dom = parseFile( xmlFileName );
				tableColNodeList = dom.getElementsByTagName("table_column");
				int noOfTableCol = tableColNodeList.getLength();

				for( int i = 0; i < noOfTableCol; i++ )
				{
					//Changed by Danish on 26/03/2007 Added variables
					String name = "";
					String type = "";
					String initial = "";
					String spaceStr = "";

					Node currTableNode = tableColNodeList.item(i);
					NodeList currTableNodeList = currTableNode.getChildNodes();
					currTableNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					int noOfTabColChildNodes = currTableNodeList.getLength();

					for(int j = 0; j < noOfTabColChildNodes; j++ )
					{
						Node currChild = currTableNodeList.item(j);
						if (currChild.getNodeName().equalsIgnoreCase("name") && currChild.getFirstChild() != null )
						{
							name = currChild.getFirstChild().getNodeValue();
						}
						else if (currChild.getNodeName().equalsIgnoreCase("type") && currChild.getFirstChild() != null )
						{
							type = currChild.getFirstChild().getNodeValue();

							String sizeStr = ( currChild.getAttributes().getNamedItem("size") != null ? ( currChild.getAttributes().getNamedItem("size").getNodeValue() ).trim() : "0" );

							if ( sizeStr.length() > 0 )
							{
								int spaces = Integer.parseInt( sizeStr );
								for (int ctr = 0; ctr < spaces; ctr++ )
								{
									spaceStr = spaceStr + " ";
								}
							}
							sizeStr = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						}
						else if (currChild.getNodeName().equalsIgnoreCase("initial") && currChild.getFirstChild() != null )
						{
							initial = currChild.getFirstChild().getNodeValue();
						}
						currChild = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					}
					currTableNodeList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

					String val = "";

					//Add else if blocks for "NULL" \ "EMPTY" here if reqd.
					if ( "SPACES".equalsIgnoreCase( initial ) )
					{
						val = spaceStr;
					}
					else if ( "TODAY".equalsIgnoreCase( initial )  )
					{
						java.sql.Date currDate = new java.sql.Date( System.currentTimeMillis() );
						if ( "DATE".equalsIgnoreCase( type ) )
						{
							val = getValidDateString( currDate.toString(), "yyyy-MM-dd", getApplDateFormat() );
						}
						else if ( "DATETIME".equalsIgnoreCase( type ) )
						{
							val = getValidDateTimeString( currDate.toString(), "yyyy-MM-dd", getApplDateTimeFormat() );
						}
					}
					else
					{
						if ( initial.length() > 0 )
						{
							val = initial;
						}
					}
					itmAddDomBuff.append("<"+name+">").append(val).append("</"+name+">");

					//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					name = null;
					type = null;
					initial = null;
					spaceStr = null;
					val = null;
					//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				}

				if( objName.equalsIgnoreCase( "TAXTRAN" ) )
				{
					itmAddDomBuff.append("</Tax>");
				}
				else
				{
					itmAddDomBuff.append("</Detail"+objCtx+">");
				}

				itmAddDomBuff.append("</Header0>");
				itmAddDomBuff.append("</group0>");
				itmAddDomBuff.append("</DocumentRoot>");

			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][createITMAddDom] :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally //changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dom = null;
			tableColNodeList = null;
		}
		BaseLogger.log("2",null,null," -------------77777777 --------itmAddDomBuff.toString():["+itmAddDomBuff.toString()+"]");
		return itmAddDomBuff.toString();
	}

	//Changed by  Danish on 26/03/2007 added new generic Method
	public Node searchNode(Document dom, String objContext, String nodeID)throws ITMException
	{
		BaseLogger.log("2",null,null,"Searching node from dom :["+dom+"] for objContext :["+objContext+"] nodeID :["+nodeID+"]");
		Node detailNode = null;
		NodeList detailList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			objContext = ( objContext == null ) ? "1" : objContext;
			nodeID = ( nodeID == null ) ? "1" : nodeID;
			detailList = dom.getElementsByTagName("Detail" + objContext);
			int detListLength = detailList.getLength();
			for(int ctr = 0; ctr < detListLength; ctr++)
			{
				Node curDetail = detailList.item(ctr);
				if(curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID))
				{
					detailNode = curDetail;
					curDetail = null; //changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					break;
				}
				else
				{
					continue;
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : GenericUtility :searchNode :==>"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			detailList = null;
		}
		return detailNode;
	}

	public java.sql.ResultSet executeQuery( java.sql.Connection myCon, String sqlQry, String pkValues, String pkColumnsDataType )throws ITMException
	{
		BaseLogger.log("2",null,null,"Query Parameters :["+pkValues+"] and their types :["+pkColumnsDataType+"]");
		java.sql.ResultSet rs = null ;
		java.sql.PreparedStatement pstmt = null;
		String COLUMN_SEPARATOR = ":";
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		E12GenericUtility genericUtility = null;
		StringTokenizer qryParamTokens = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]


		try
		{
			genericUtility = new E12GenericUtility();
			pstmt = myCon.prepareStatement( sqlQry );
			if( pkValues != null && sqlQry.indexOf( "?" ) != -1 )
			{
				qryParamTokens = new StringTokenizer( pkValues );
				int pCount=1;
				while( qryParamTokens.hasMoreTokens() )
				{
					String testParam = qryParamTokens.nextToken( COLUMN_SEPARATOR );
					if ( pkColumnsDataType != null )
					{
						String testParamType = pkColumnsDataType.substring( 0, pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) );
						BaseLogger.log("3",null,null, "Setting Param value :["+testParam+"] Type :["+testParamType+"] position :["+pCount+"]" );
						if ( testParamType.equalsIgnoreCase( "DATETIME" ) )
						{
							testParam = genericUtility.getValidDateTimeString(testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat());

							pstmt.setTimestamp(pCount, java.sql.Timestamp.valueOf(testParam));
						}
						else if (testParamType.equalsIgnoreCase("DATE"))
						{
							testParam = getValidDateString( testParam, genericUtility.getDispDateFormat(), genericUtility.getDBDateFormat() );
							pstmt.setDate( pCount, java.sql.Date.valueOf( testParam ) );
						}
						else if ( testParamType.equalsIgnoreCase( "DECIMAL" ) )
						{
							pstmt.setDouble(pCount, Double.parseDouble(testParam));
						}
						else
						{
							pstmt.setString(pCount, testParam);
						}
						pkColumnsDataType = pkColumnsDataType.substring( pkColumnsDataType.indexOf( COLUMN_SEPARATOR ) + 1 );
						testParamType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					}
					else
					{
						pstmt.setString( pCount, testParam );
					}
					testParam = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					pCount = pCount + 1;
				}
			}
			//	BaseLogger.log("9",null,null,"Executing Query :"+sqlQry);
			rs = pstmt.executeQuery();
			pstmt.close();
			pstmt = null;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :DB2XMLGenerator :executeQuery() ==>");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			try
			{
				if(pstmt != null && !pstmt.isClosed())
				{
					pstmt.close();
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
			finally
			{
				pstmt = null;
			}
			genericUtility = null;
			qryParamTokens = null;
		}
		return rs ;
	}

	//Changed by Madhup on 27/06/2007 accomodating DateTime Format.Start
	public String getDBDateTimeFormat()throws ITMException,Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlDateFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if ( CommonConstants.DB_DATETIME_FORMAT == null )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();

				//Changed by Swapnil Shirke on 18-Aug-2010 [ SY90SUN004 ] To support multiple database connection through single JBoss.
				//Document doc = db.parse(CommonConstants.JBOSSHOME + File.separator + "setting" + File.separator + "DateFormat.xml");
				doc = db.parse(CommonConstants.APPLICATION_CONTEXT + File.separator + "setting" + File.separator + "DateFormat.xml");
				nlDateFormat = doc.getElementsByTagName("DB_DATETIME_FORMAT");
				//changes by madhup 11/07/07 start [if clause added]
				if( nlDateFormat != null )
				{
					Node ndDateFormat = nlDateFormat.item(0);
					//Changed by Danish on 9/5/2007 Check for null
					if ( ndDateFormat != null && ndDateFormat.getFirstChild() != null )
					{
						CommonConstants.DB_DATETIME_FORMAT  = ndDateFormat.getFirstChild().getNodeValue();
					}
					ndDateFormat = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				}
				//changes by madhup 11/07/07 end
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getDBDateFormat :==>\n"+e);
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlDateFormat = null;
		}
		return CommonConstants.DB_DATETIME_FORMAT ;
	}

	public String getValidDateTimeString(Date dateTime, String targetDateTimeFormat) throws ITMException
	{
		String retDateStr = "";
		SimpleDateFormat sdfOutput = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
			retDateStr = sdfOutput.format(dateTime);
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateTimeString :==>"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			sdfOutput = null;
		}
		BaseLogger.log("2",null,null,"retDateStr :"+retDateStr);
		return retDateStr;
	}

	public Column getColumnObject(ArrayList columnObjects, String colLogicalName) throws ITMException , Exception
	{
		Column colObj = null;
		try
		{
			for(int colIndex = 0 ; colIndex < columnObjects.size() ; colIndex++ )
			{
				if( ((Column)columnObjects.get( colIndex )).getLogicalName().equalsIgnoreCase( colLogicalName ) )
				{
					colObj = (Column)columnObjects.get( colIndex );
					break;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getColumnObject :==>"+e.getMessage());
			throw new ITMException(e);
		}
		return colObj;
	}

	public String getValidDateTimeString(String dateTime, String targetDateTimeFormat) throws ITMException
	{
		String retDateStr = "";
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		java.util.Date dateTimeObj = null;
		SimpleDateFormat sdfOutput = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			dateTimeObj = getDateTimeObject(dateTime);
			sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
			retDateStr = sdfOutput.format( dateTimeObj );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateTimeString :==>"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dateTimeObj = null;
			sdfOutput = null;
		}
		BaseLogger.log("2",null,null,"retDateStr :"+retDateStr);
		return retDateStr;
	}
	public String getValidDateString(String dateTime, String targetDateTimeFormat) throws ITMException
	{
		String retDateStr = "";
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		java.util.Date dateTimeObj = null;
		SimpleDateFormat sdfOutput = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			dateTimeObj = getDateObject(dateTime);
			sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
			retDateStr = sdfOutput.format( dateTimeObj );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dateTimeObj = null;
			sdfOutput = null;
		}
		BaseLogger.log("2",null,null,"retDateStr :"+retDateStr);
		return retDateStr;
	}
	//Changed by Madhup on 27/06/2007 accomodating DateTime Format.End

	//Changed by Roshan 22/11/07 [Gui related changes :apply theme].Start
	public String getThemeFormat() throws ITMException, Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		DocumentBuilderFactory dbf = null;
		DocumentBuilder db = null;
		Document doc = null;
		NodeList nlThemeFormat = null;
		Node ndThemeFormat = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			if (CommonConstants.THEME == null )
			{
				dbf = DocumentBuilderFactory.newInstance();
				db = dbf.newDocumentBuilder();
				doc = db.parse("/" + "IBASEHOME" + File.separator + "ibase.xml");
				nlThemeFormat = doc.getElementsByTagName("THEME");
				ndThemeFormat = nlThemeFormat.item(0);

				if( ndThemeFormat != null && ndThemeFormat.getFirstChild() != null )
				{
					CommonConstants.THEME = ndThemeFormat.getFirstChild().getNodeValue();
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getThemeFormat :==>["+e+"]");
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			dbf = null;
			db = null;
			doc = null;
			nlThemeFormat = null;
			ndThemeFormat = null;
		}
		BaseLogger.log("2",null,null,"CommonConstants.THEME:==> ["+CommonConstants.THEME+"]");
		return CommonConstants.THEME;
	}
	// Changed by Roshan 22/11/07 [Gui related changes :apply theme].End

	//Changed by Danish on 14/01/2008  [ utility to identify if error Type 'E' found in error node ] Start
	public boolean isErrorNodeFound( String errXmlString ) throws ITMException, Exception
	{
		boolean isErrorNodeFound = false;
		NodeList errorNodeList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			if( errXmlString.indexOf( "<Errors>" ) != -1 )
			{
				errorNodeList = parseString( errXmlString ).getElementsByTagName("error");
				int errorNodeListLen = errorNodeList.getLength();
				for ( int i = 0; i < errorNodeListLen; i++)
				{
					String errorType = errorNodeList.item( i ).getAttributes().getNamedItem( "type" ).getNodeValue();
					BaseLogger.log("3",null,null, "errorType :[" + errorType + "]" );
					if( "E".equals( errorType ) )
					{
						isErrorNodeFound = true;
						errorType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						break;
					}
					if( "X".equals( errorType ) )
					{
						isErrorNodeFound = true;
						errorType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						break;
					}

					//Added by Shrutika on 20-01-18 [Start] for handle warning and Prompt case.
					/*if( "W".equals( errorType ) )
					{
						isErrorNodeFound = true;
						errorType = null;
						break;
					}

					if( "P".equals( errorType ) )
					{
						isErrorNodeFound = true;
						errorType = null;
						break;
					}*/
					//Added by Shrutika on 20-01-18 [End] for handle warning and Prompt case.
				}
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			errorNodeList = null;
		}
		return isErrorNodeFound;
	}
	//Changed by Danish on 14/01/2008 [ utility to identify if error node found in returned xml] End

	//Changed by Monif for writing Data in Log File UserId Wise.Start
	public void writeLoggerFile(String userId, String siteCode, String eventCode, String focussedColumn, String xmlDataAll, String xmlData, String returnData ) throws Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		BufferedReader bf = null;
		BufferedWriter bw = null;
		Date date = null;
		String time = null;
		String infoData = null;
		String tranData = null;
		String filePath = null;
		File file = null;
		StringBuffer fileContent = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			date = new Date();
			time = date.getHours()+":"+date.getMinutes()+":"+date.getSeconds();
			infoData = "Time ["+ time +"] User::[" + userId + "] SiteCode::[" + siteCode + "] EventCode::[" + eventCode +"] focussedColumn::[" + focussedColumn + "]";
			tranData = "["+ xmlDataAll +"] " + "Data Send::[" + xmlData + "] " + "Data Returned::[" + returnData + "] ";
			filePath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator + userId + ".txt";
			file = new File( filePath );

			fileContent = new StringBuffer("");
			if( file.exists() )
			{
				bf = new BufferedReader( new FileReader( file ) );
				String outTempStr = null;
				while((outTempStr = bf.readLine()) != null)
				{
					if( outTempStr != null && outTempStr.trim().length() > 0 )
					{
						fileContent=fileContent.append(outTempStr+"\n");
						outTempStr = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					}
				}
				if( bf != null)
				{
					bf.close();
				}
			}
			else
			{
				fileContent.append( "" );
			}
			bw = new BufferedWriter( new FileWriter(file));
			bw.newLine();
			bw.write((fileContent.append(infoData)).toString());
			bw.newLine();
			bw.write(tranData);
			bw.flush();
			bw.close();
		}
		catch (  Exception e )
		{
			BaseLogger.log("0",null,null,"Exception occured while writting logger file: In GenericUtility:writeLoggerFile ["+userId+"]");
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			if( bf != null)
			{
				bf.close();
			}

			if( bw != null)
			{
				bw.close();
			}
			bf = null;
			bw = null;
			date = null;
			time = null;
			infoData = null;
			tranData = null;
			filePath = null;
			file = null;
			fileContent = null;
		}
	}
	//Changed by Monif for writing Data in Log File UserId Wise.End
	//Changed by Dayanand on 26/10/10 [ To generate log and send mail with attachment]start

	//Changes by Prajyot on 02-JUNE-2014 [Removed static keyword : As per Danish sir]
	public String generateLog( String dataString, String mailSubject, String logFileName, boolean sendMailFlag ) throws ITMException, Exception
	{
		BufferedWriter logFileWriter = null;
		double randomNo = Math.random();
		try
		{
			if(!( new File ( CommonConstants.JBOSSHOME  + File.separator + "log" + File.separator + logFileName+randomNo+".txt" ) ).exists() )
			{
				( new File( CommonConstants.JBOSSHOME  + File.separator + "log" + File.separator + logFileName+randomNo+".txt" ) ).createNewFile();
			}
			logFileName = CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + logFileName+randomNo+".txt";
			BaseLogger.log("3",null,null,"GenericUtility:generateLog["+logFileName+"]");
			logFileWriter = new BufferedWriter( new FileWriter( logFileName ) );
			logFileWriter.newLine();
			logFileWriter.write( dataString );
			logFileWriter.flush();
			logFileWriter.close();
			logFileWriter = null;
			//Commented by Prajyot on 02-JUNE-2014 [As per Danish sir]
			//			if( sendMailFlag )
			{
				sendMail( logFileName,mailSubject );
			}
		}
		catch ( Exception e )
		{
			BaseLogger.log("0",null,null,"Error when generating the log : In GenericUtility:generateLog["+randomNo+"]");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( logFileWriter != null )
				{
					logFileWriter.flush();
					logFileWriter.close();
					logFileWriter = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
				logFileWriter = null;
			}
			finally
			{
				logFileWriter = null;
			}
		}
		return logFileName;
	}
	private void sendMail( String logFileName, String mailSubject) throws ITMException, Exception
	{
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		String emailID = null;
		ibase.utility.EMail emailObj = null;
		StringBuffer mailInfoXml = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		if( mailSubject == null || ( mailSubject != null && mailSubject.trim().length() == 0 ))
		{
			mailSubject = "No Subject";
		}

		try
		{
			emailID = checkEmailId();
			if( emailID != null && emailID.trim().length() > 0  )
			{
				emailObj = new ibase.utility.EMail();
				mailInfoXml = new StringBuffer();
				mailInfoXml.append("<MAILINFO>");
				mailInfoXml.append("<EMAIL_TYPE><![CDATA[page]]></EMAIL_TYPE>");
				mailInfoXml.append("<TO_ADD><![CDATA["+emailID+"]]></TO_ADD>");
				mailInfoXml.append("<SUBJECT><![CDATA["+mailSubject+"]]></SUBJECT>");
				mailInfoXml.append("<MESSAGE><![CDATA["+logFileName+"]]></MESSAGE>");
				mailInfoXml.append("<XML_DATA_FILE><![CDATA["+logFileName+"]]></XML_DATA_FILE>");
				mailInfoXml.append("</MAILINFO>");
				emailObj.sendMail(mailInfoXml.toString(),null);
			}
			else
			{
				BaseLogger.log("3",null,null, "Tech Support E-mail id not defined." );
			}
		}
		catch ( Exception e )
		{
			BaseLogger.log("0",null,null,"Error when Sending the mail : In GenericUtility:sendMail ["+logFileName+"]");
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			emailID = null;
			emailObj = null;
			mailInfoXml = null;
		}
	}
	private String checkEmailId() throws ITMException, Exception
	{
		java.sql.Connection con = null;
		java.sql.PreparedStatement pstmt = null;
		java.sql.ResultSet rs = null;
		String emailId = null;
		String query = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			con = new ibase.system.config.ConnDriver().getConnectDB("Driver");
			//query = "SELECT EMAIL_ID FROM PARAMETER WHERE PRD_CODE='999999' AND VAR_NAME='TECH_SUPPORT_EMAIL' ";
			//Changed By Pankaj T. on 29-06-18 as per discussed with KB Sir add column EMAIL_ID varchar2(500) in PARAMETER table for getting email_id
			query = "SELECT EMAIL_ID FROM PARAMETER";
			pstmt = con.prepareStatement(query);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				emailId = rs.getString("EMAIL_ID");
			}
		}
		catch ( Exception e )
		{
			BaseLogger.log("0",null,null,"Error when checking email Id : In GenericUtility:checkEmailId");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				//Changed by Nilesh Soor on 18/09/2014 [ rs.isClosed() is not working in this vesrion as per Gulzar Sir. ]
				//if(rs != null && !rs.isClosed())//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				if(rs != null)
				{
					rs.close();
				}
				if ( pstmt != null && !pstmt.isClosed())
				{
					pstmt.close();
				}
				if ( con != null && !con.isClosed())
				{
					con.close();
				}
				//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				query = null;
				pstmt = null;
				rs = null;
				con=null;
				//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
			catch ( Exception ex)
			{
				throw new ITMException(ex);
			}
			query = null;
			pstmt = null;
			rs = null;
			con=null;
		}
		return emailId;
	}
	//Changed by Dayanand on 26/10/10 [To generate log and send mail with attachment]end
	//Changed by Dayanand on 26/10/10 [Write Exception in string]start
	public String writePrintStacktrace( Exception e )
	{
		String errorlog = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		ByteArrayOutputStream b = null;
		PrintStream p = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			b = new ByteArrayOutputStream();
			p = new PrintStream(b);
			e.printStackTrace(p);
			errorlog = b.toString();
			p.flush();
			b.close();
			p.close();
		}
		catch ( Exception ex )
		{
			ex.printStackTrace();
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			if(b != null)
			{
				b = null;
			}
			if(p != null)
			{
				p = null;
			}
		}
		return errorlog;
	}
	//Changed by Dayanand on 26/10/10 [Write Exception in string]end

	public void removeWhitespaces(Node n)
	{
		removeWhitespaceInner(n, null);
	}

	public void removeWhitespaceInner(Node n, Node parent)
	{
		List<Node> toBeProcessed = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		// This n is removed from the parent if n is a whitespace node
		if (parent != null && n instanceof Text && (!(n instanceof CDATASection)))
		{
			Text t = (Text) n;
			if (t.getData().matches("[ \t\n]*"))
			{
				parent.removeChild(t);
			}
			t = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		}
		if (n.hasChildNodes())
		{
			int length = n.getChildNodes().getLength();
			toBeProcessed = new ArrayList<Node>();
			// We collect all the nodes to iterate as the child nodes will change
			// upon removal
			for (int i = 0; i < length; i++)
			{
				toBeProcessed.add(n.getChildNodes().item(i));
			}
			// This changes the child nodes, but the iterator of nodes never changes
			// meaning that this is safe
			for (Node childNode : toBeProcessed)
			{
				removeWhitespaceInner(childNode, n);
			}
		}
	}

	//Added by Harshada on 26th Nov 2012 [Create user connections on login]-START
	public String getDisplayValues(String value) throws ParserConfigurationException, SAXException, IOException
	{
		String tagValues = null;
		String fileName = CommonConstants.APPLICATION_CONTEXT;
		String separator = System.getProperty("file.separator");
		String applFilePath = null;

		BaseLogger.log("0",null,null,"Called getDisplayValues():: " +fileName);
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		Document doc = null;
		File fXmlFile = null;
		NodeList nList = null;
		NodeList tagValue = null;
		Node nValue = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if(fileName.contains(".war")){
				int lastSeparatorIndex = fileName.lastIndexOf(separator+"ibase.war");
				if (lastSeparatorIndex == -1) {
					applFilePath = fileName;
				} else {
					applFilePath = fileName.substring(0, lastSeparatorIndex + 1)+"META-INF/application.xml";
				}
			}


			fXmlFile = new File(applFilePath);

			//Changed by Harshada on 5-APR-2013 [DOM parser Exception in parsing application.xml]STARTS
			try {
				doc = parseFile(fXmlFile);
			} catch (Exception e)
			{
				BaseLogger.log("0",null,null,"Exception in parsing file: "+e.getMessage());
				e.printStackTrace();
			}
			//Changed by Harshada on 5-APR-2013 [DOM parser Exception in parsing application.xml]ENDS

			nList = doc.getElementsByTagName("application");
			for (int temp = 0; temp < nList.getLength(); temp++) {

				Node nNode = nList.item(temp);
				if (nNode.getNodeType() == Node.ELEMENT_NODE) {
					Element eElement = (Element) nNode;
					if(value!=null){
						tagValue = eElement.getElementsByTagName(value).item(0).getChildNodes();
						eElement = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						nValue = (Node) tagValue.item(0);
						tagValues = nValue.getNodeValue();
						nValue = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						BaseLogger.log("3",null,null,"display Details for user connections: " + tagValues);
					}
					//     NodeList secNodelst = eElement.getElementsByTagName("description").item(0).getChildNodes();
					//BaseLogger.log("9",null,null,"description : " + nValue2.getNodeValue());
				}
				nNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
		}
		catch (Exception e)//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			BaseLogger.log("0",null,null,"Exception in GenericUtility:getDisplayValues: "+e.getMessage());
			e.printStackTrace();
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			doc = null;
			fXmlFile = null;
			nList = null;
			tagValue = null;
			nValue = null;
		}
		return tagValues;
	}
	//Added by Harshada on 26th Nov 2012 [Create user connections on login]-END

	//Added by gayatri on 09-03-2013 [identify if error node found in returned xml]start
	public boolean isWarnNodeFound( String errXmlString ) throws ITMException, Exception
	{
		boolean isErrorNodeFound = false;
		NodeList errorNodeList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			if( errXmlString.indexOf( "<Errors>" ) != -1 )
			{
				errorNodeList = parseString( errXmlString ).getElementsByTagName("error");
				int errorNodeListLen = errorNodeList.getLength();
				for ( int i = 0; i < errorNodeListLen; i++)
				{
					String errorType = errorNodeList.item( i ).getAttributes().getNamedItem( "type" ).getNodeValue();
					BaseLogger.log("3",null,null, "errorType :[" + errorType + "]" );
					if( "W".equals( errorType ) )
					{
						isErrorNodeFound = true;
						errorType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						break;
					}
				}
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			errorNodeList = null;
		}
		return isErrorNodeFound;
	}

	//Added by gayatri on 09-03-2013 [identify if error node found in returned xml]end
	//Added by gayatri on 23-08-2013 [identify if success node found in returned xml]start
	public boolean isSuccessNodeFound( String errXmlString ) throws ITMException, Exception
	{
		//Commented and changes by Gulzar on 06/01/15 initialize to true to check whether error(E) is exist or not
		//boolean isSuccessFound = false;
		boolean isSuccessFound = true;

		NodeList errorNodeList = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]

		try
		{
			if( errXmlString.indexOf( "<Errors>" ) != -1 )
			{
				errorNodeList = parseString( errXmlString ).getElementsByTagName("error");
				int errorNodeListLen = errorNodeList.getLength();
				for ( int i = 0; i < errorNodeListLen; i++)
				{
					String errorType = errorNodeList.item( i ).getAttributes().getNamedItem( "type" ).getNodeValue();
					BaseLogger.log("3",null,null, "errorType :[" + errorType + "]" );
					/*--Commented and changed by Gulzar on 06/01/15 to check whether error(E) is exist or not. START
						//If message list contains both E and P then in that case it was returning as true instead of false.
						if( "P".equals( errorType ) )
						{
							isSuccessFound = true;
							errorType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
							break;
						}
					 */
					if( "X".equals( errorType ) )
					{
						isSuccessFound = false;
						errorType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						break;
					}
					if( "E".equals( errorType ) )
					{
						isSuccessFound = false;
						errorType = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						break;
					}
					//Commented and changed by Gulzar on 06/01/15 to check whether error(E) or Worning(W) is exist or not. END
				}
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			errorNodeList = null;
		}
		return isSuccessFound;
	}
	//Added by gayatri on 23-08-2013 [identify if success node found in returned xml]end

	//Added By Prajyot [As per Danish sir - To remove [.fffffffff] from dateformat ]
	private String getValidDateFormat( String dateFormat )
	{
		if( dateFormat != null && dateFormat.indexOf( "[.fffffffff]" ) != -1 )
		{
			//BaseLogger.log("9",null,null,"Framework ---" + new Date() + " DateFormat contains [.fffffffff] dateFormat[" + dateFormat + "]");
			dateFormat = dateFormat.replace("[.fffffffff]", "");
		}
		//BaseLogger.log("9",null,null,"Framework --- Returning DateFormat [" + dateFormat + "]");
		return dateFormat;
	}


	//Added by Prajyot [To detect string is XML string or not]Starts
	public boolean isXMLString(String xmlString)
	{
		boolean isXml = false;
		if( xmlString != null )
		{
			xmlString = xmlString.trim();
			if( xmlString.startsWith("<") && xmlString.indexOf("</") != -1 && xmlString.indexOf(">") != -1 )
			{
				isXml = true;
			}
			BaseLogger.log("3",null,null,"xmlString[" + xmlString + "]isXml["+isXml+"]");
		}
		return isXml;
	}
	//Added by Prajyot [To detect string is XML string or not]Ends


	//Added by Prajyot [From Common GenericUtility]Starts

	public String getValidDateString( java.util.Date date, String targetDateFormat) throws BaseException
	{
		//BaseLogger.log("9",null,null,"[GenericUtility]Converting dateStr :["+dateStr+"] From format :["+sourceDateFormat +"] To Format :["+targetDateFormat+"]");
		String retDateStr = "";
		try
		{
			SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
			retDateStr = sdfOutput.format(date);
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			throw new BaseException(e);
		}
		//BaseLogger.log("9",null,null,"[GenericUtility]Converted Datestr :["+retDateStr+"]");
		return retDateStr;
	}

	public String getValidDateString( java.sql.Date date, String targetDateFormat ) throws BaseException
	{
		//BaseLogger.log("9",null,null,"[GenericUtility]Converting dateStr :["+dateStr+"] From format :["+sourceDateFormat +"] To Format :["+targetDateFormat+"]");
		String retDateStr = "";
		try
		{
			SimpleDateFormat sdfOutput = new SimpleDateFormat( targetDateFormat );
			retDateStr = sdfOutput.format( date );
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			throw new BaseException(e);
		}
		//BaseLogger.log("9",null,null,"[GenericUtility]Converted Datestr :["+retDateStr+"]");
		return retDateStr;
	}

	/*	public String getValidDateTimeString(String dateTimeStr, String sourceDateTimeFormat, String targetDateTimeFormat) throws BaseException
		{
			BaseLogger.log("9",null,null,"Getting the valid datetime string for dateTimeStr :"+dateTimeStr+": which is in format :"+sourceDateTimeFormat);
			Object date = null;
			String retDateStr = "";
			try
			{
				if (!(sourceDateTimeFormat.equalsIgnoreCase(targetDateTimeFormat)))
				{
					if (sourceDateTimeFormat.indexOf("/") != -1)
					{
						dateTimeStr.replace('/', '-');
					}
					else if (sourceDateTimeFormat.indexOf(".") != -1)
					{
						dateTimeStr.replace('.', '-');
					}
					date = new SimpleDateFormat(sourceDateTimeFormat+" HH:mm:ss").parse(dateTimeStr+" 00:00:00");
					SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateTimeFormat+" HH:mm:ss");
					retDateStr = sdfOutput.format(date);
				}
				else
				{
					retDateStr = dateTimeStr;
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("9",null,null,"Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
				throw new BaseException(e);
			}
			BaseLogger.log("9",null,null,"retDateStr :"+retDateStr);
			return retDateStr;
		}
	 */

	public String getValidDateTimeString(Timestamp dateTime, String targetDateTimeFormat) throws BaseException
	{
		String retDateStr = "";
		try
		{
			//Commented and changed below by Gulzar on 12/09/14 to check exist of "HH:mm:ss" before appending : START
			//SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateTimeFormat+" HH:mm:ss");
			if(targetDateTimeFormat.toLowerCase().indexOf("hh:mm:ss") == -1)
			{
				targetDateTimeFormat = targetDateTimeFormat+" HH:mm:ss";
			}
			SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateTimeFormat);
			//Commented and changed below by Gulzar on 12/09/14 to check exist of "HH:mm:ss" before appending : END

			retDateStr = sdfOutput.format(dateTime);
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :getValidDateString :==>"+e.getMessage());
			throw new BaseException(e);
		}
		BaseLogger.log("2",null,null,"retDateStr :"+retDateStr);
		return retDateStr;
	}

	private String idxOfSubArrLst ="" ;
	private boolean subarraylist = false;
	public String arrayListToString(ArrayList inputArrayList) throws Exception
	{
		String  xmlStringOfArrayList="";
		int sizeOfArray = inputArrayList.size();
		if(!subarraylist)
		{
			xmlStringOfArrayList ="<Root>";
		}

		for (int i=0; i <sizeOfArray ;i++ )
		{
			if(inputArrayList.get(i)== null)
			{
				if(!subarraylist)
				{
					xmlStringOfArrayList+="<index"+i+">"+(String)inputArrayList.get(i)+"</index"+i+">" ;
				}
				else
				{
					xmlStringOfArrayList+="<index"+Integer.parseInt(idxOfSubArrLst)+i+">"+(String)inputArrayList.get(i)+"</index"+Integer.parseInt(idxOfSubArrLst)+i+">" ;
				}
			}
			if( (inputArrayList.get(i)!= null) && (inputArrayList.get(i).getClass().getName().equals("java.lang.String")) )
			{

				if(!subarraylist)
				{
					xmlStringOfArrayList+="<index"+i+">"+(String)inputArrayList.get(i)+"</index"+i+">" ;
				}
				else
				{
					xmlStringOfArrayList+="<index"+Integer.parseInt(idxOfSubArrLst)+i+">"+(String)inputArrayList.get(i)+"</index"+Integer.parseInt(idxOfSubArrLst)+i+">" ;
				}
			}
			if( (inputArrayList.get(i)!= null) && inputArrayList.get(i).getClass().getName().equals("java.util.ArrayList"))
			{
				idxOfSubArrLst =""+i+"";
				subarraylist = true;
				xmlStringOfArrayList+="<index"+i+">"+arrayListToString((ArrayList)inputArrayList.get(i) )+"</index"+i+">" ;
				subarraylist = false;
			}
		}
		if(!subarraylist)
		{
			xmlStringOfArrayList +="</Root>";
		}
		//BaseLogger.log("9",null,null," xmlStringOfArrayList  " + xmlStringOfArrayList );
		return xmlStringOfArrayList;
	}

	public ArrayList stringToArrayList(String inputStringXML) throws Exception
	{
		String nodevalue="";
		ArrayList stringToArrayList  = new ArrayList();
		TreeMap valueofNodeTreeMap = new TreeMap();
		Document dom1 = parseString( inputStringXML );
		NodeList nodelist = dom1.getElementsByTagName("Root");
		Node node = nodelist.item(0);
		NodeList childnodelist = node.getChildNodes();
		int size =  childnodelist.getLength();
		for(int iTot=0;iTot<size;iTot++)
		{
			Node valueNode=childnodelist.item(iTot);
			if(valueNode.getFirstChild().getNodeType()==valueNode.TEXT_NODE)
			{
				nodevalue = valueNode.getNodeName();
				valueofNodeTreeMap.put(nodevalue,valueNode.getFirstChild().getNodeValue());
			}
			else
			{
				nodevalue = valueNode.getNodeName();
				valueofNodeTreeMap.put(nodevalue,subStringTosubArrayList(valueNode, iTot));
			}
		}
		for(int iTot=0;iTot<size;iTot++)
		{
			stringToArrayList.add(valueofNodeTreeMap.get("index"+iTot));
		}
		return stringToArrayList ;
	}

	public ArrayList subStringTosubArrayList (Node inputsubStringXML,int index) throws Exception
	{
		String subnodeName=" ";
		ArrayList subStringToArrayList  = new ArrayList();
		TreeMap valueofsubNodeTreeMap = new TreeMap();
		Node getNextNode = inputsubStringXML.getFirstChild();
		while(getNextNode !=null)
		{
			subnodeName = getNextNode.getNodeName();
			valueofsubNodeTreeMap.put(subnodeName,getNextNode.getFirstChild().getNodeValue());
			getNextNode = getNextNode.getNextSibling();
		}
		int sizeofTreeMap =  valueofsubNodeTreeMap.size();
		for(int iTot=0;iTot<sizeofTreeMap;iTot++)
		{
			subStringToArrayList.add(valueofsubNodeTreeMap.get("index"+index+iTot));
		}
		return subStringToArrayList;
	}

	public String HashmapToString(HashMap inputHashMap) throws Exception
	{
		String  xmlStringOfHashMap = null;
		try
		{
			xmlStringOfHashMap = "<Root>";
			int sizeOfHashMap = inputHashMap.size();
			Set keyset  = inputHashMap.keySet();
			ArrayList arraykeylist = new ArrayList(keyset);

			for (int i=0; i <sizeOfHashMap ;i++ )
			{
				if(inputHashMap.get(arraykeylist.get(i) )== null )
				{
					xmlStringOfHashMap+="<"+arraykeylist.get(i)+">"+inputHashMap.get(arraykeylist.get(i) )+"</"+arraykeylist.get(i)+">" ;
				}
				if(inputHashMap.get(arraykeylist.get(i) )!= null && inputHashMap.get(arraykeylist.get(i) ).getClass().getName().equals("java.lang.String"))
				{
					xmlStringOfHashMap+="<"+arraykeylist.get(i)+">"+inputHashMap.get(arraykeylist.get(i) )+"</"+arraykeylist.get(i)+">" ;
				}
			}
			xmlStringOfHashMap += "</Root>";
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :HashmapToString :==>\n"+e.getMessage());
			throw new BaseException(e);
		}
		return xmlStringOfHashMap;
	}

	public HashMap StringToHashmap(String inputStringXML) throws Exception
	{
		HashMap stringToHashMap  = new HashMap();
		try
		{
			BaseLogger.log("3",null,null,"In StringToHashmap");
			Document dom1 = parseString( inputStringXML);
			NodeList nodelist = dom1.getElementsByTagName("Root");
			Node node = nodelist.item(0);
			NodeList childnodelist = node.getChildNodes();
			int size =  childnodelist.getLength();
			for(int iTot=0;iTot<size;iTot++)
			{
				Node valueNode = childnodelist.item(iTot);
				if(!valueNode.getFirstChild().getNodeValue().equals("null"))
				{
					stringToHashMap.put(valueNode.getNodeName(),valueNode.getFirstChild().getNodeValue());
				}
				else
				{
					stringToHashMap.put(valueNode.getNodeName(),null);
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :GenericUtility :StringToHashmap :==>\n"+e.getMessage());
			throw new BaseException(e);
		}
		return  stringToHashMap;
	}

	public Document getDocument (String inputString) throws Exception
	{
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();//API	's use application to convert the xml data to the parse format (also creates the instance)
		DocumentBuilder db = dbf.newDocumentBuilder();//simply converts xml data to the document (documnt object module)
		OutputStreamWriter errorWriter = new OutputStreamWriter(System.err, CommonConstants.ENCODING);
		ByteArrayInputStream baos = new ByteArrayInputStream(inputString.getBytes( CommonConstants.ENCODING ));//(takes xml string and get there string to byte converted form)
		Document dom1 = db.parse(baos);
		return dom1;
	}

	public void writeToFile( Node xmlNode, String filePath )throws BaseException
	{
		try
		{
			//Changed by Monif on 2/13/2009.Start[For special char parsing issue]Start
			//String serializeDomStr = serializeDom( xmlNode );
			String serializeDomStr = null;
			if( xmlNode.getNodeType() == Node.ELEMENT_NODE )
			{
				serializeDomStr = serializeDom( xmlNode, true);
			}
			else
			{
				serializeDomStr = serializeDom( xmlNode );
			}
			//changed by Monif on 2/13/2009.[For special char parsing issue]End
			writeToFile( serializeDomStr, filePath );
		}
		catch ( BaseException be )
		{
			throw be;
		}
		catch ( Exception e )
		{
			throw new BaseException( e );
		}
	}

	public void writeToFile( String xmlDomString, String filePath )throws BaseException
	{
		try
		{
			// Changes by Gagan B. as suggested by Gulzar Sir on 15-MAR-24
//			FileWriter fw = new FileWriter( filePath );
			FileWriter fw = new FileWriter(filePath, StandardCharsets.UTF_8);
			BaseLogger.log("3",null,null,"E12GeneericUtility writeToFile using StandardCharsets.UTF_8");

			fw.write( xmlDomString );
			fw.flush();
			fw.close();
		}
		catch ( Exception e )
		{
			throw new BaseException( e );
		}
	}

	//Changed by Nazia on 20/07/07 to format error xml String.Start
	public String getErrorMsgDescr(String errorXmlStr) throws BaseException
	{
		StringBuffer retStrBuff = new StringBuffer("");
		try
		{
			String tempStr = "";
			DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
			DocumentBuilder db = dbf.newDocumentBuilder();
			java.io.ByteArrayInputStream bais = new ByteArrayInputStream(errorXmlStr.getBytes( CommonConstants.ENCODING ));
			Document doc = db.parse(bais);
			NodeList nlApp = doc.getElementsByTagName("message");

			if( nlApp.item(0).getFirstChild() != null )
			{
				tempStr = nlApp.item(0).getFirstChild().getNodeValue();
			}
			//retStrBuff.append("Message :" +tempStr + "   \n");
			nlApp = doc.getElementsByTagName("description");

			if(nlApp.item(0).getFirstChild()!=null)
			{
				tempStr = nlApp.item(0).getFirstChild().getNodeValue();
			}
			if ( tempStr.indexOf("INVALID_ACCESS") != -1 )
			{
				tempStr = "Session time out.";
			}
			retStrBuff.append(" Error Description : "+tempStr);
		}
		catch ( Exception e )
		{
			throw new BaseException( e );
		}
		return retStrBuff.toString();
	}
	//Changed by Nazia on 20/07/07 to format error xml String.End

	//Changed by Danish on 27/09/2007 [ An utility which will return ejb Object ] start
	public Object getObj( String lookupName ) throws Exception
	{
		try
		{
			EJBHome obHome = getHome( lookupName );
			Method m = obHome.getClass().getDeclaredMethod( "create", new Class[0] );
			Object obj = m.invoke ( obHome, new Object[0] );
			return obj;
		}
		catch (Exception e)
		{
			throw e;
		}
	}

	private EJBHome getHome( String lookupName ) throws Exception
	{
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);

			Object home = ctx.lookup( lookupName );
			EJBHome obHome = (EJBHome)PortableRemoteObject.narrow (home, EJBHome.class);
			return obHome;
		}
		catch (Exception e)
		{
			throw e;
		}
	}
	//Changed by Danish on 27/09/2007 [ An utility which will return ejb Object ] End

	//Added by Prajyot [From Common GenericUtility]Ends
	//Added by Dnyaneshwar Chavan on 19-DEC-14 [ Check  the RIAWizardBean and ITMWizardBean are instance removed or not ] Start
	/**
	 * This method write new file if file is not exist otherwise append the given contents
	 *
	 * @param fileName the file Name
	 * @param contents the file contents for write in file
	 */
	public void writeFile( String fileName, String contents )
	{
		try
		{
			if( "1".equals( CommonConstants.COMP_LOG ) )
			{
				String filePath = CommonConstants.JBOSSHOME + File.separator +
						"server" + File.separator + "default" + File.separator +
						"log" + File.separator + fileName + "_" +  new SimpleDateFormat("yyyyMMdd").format(new Date()) + ".cvs" ;
				File file = new File( filePath );
				if( !file.exists() )
				{
					BaseLogger.log("3",null,null,"New File created.....");
					file.createNewFile();
				}
				FileWriter fos = new FileWriter( file, true );
				fos.write( contents );
				fos.flush();
				fos.close();
			}
		}
		catch (IOException e)
		{
			e.printStackTrace();
		}
	}
	//Added by Dnyaneshwar Chavan on 19-DEC-14 [ Check  the RIAWizardBean and ITMWizardBean are instance removed or not ] End

	public static String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}

	//Changed by Reema on 12-oct-15 [check numberStr is numeric character]
	public boolean isNumeric( String numberStr )
	{
		boolean isNumber;
		try{
			Integer.parseInt( numberStr );
			isNumber = true;
		}
		catch(Exception ex)
		{
			isNumber = false;
		}
		return isNumber;
	}
	//Changed by Reema on 12-oct-15 [check numberStr is numeric character]-End
	//Added By Suraj Bhandvale On 09/12/15 [W15HSUN005][To delete directory path]START
	/**
	 * To delete directory of given dirPath
	 *
	 * @param dirPath the directory path
	 */
	public void deleteDir( String dirPath ) throws Throwable
	{
		File file = new File( dirPath );
		if( file.exists() )
		{
			FileUtils.deleteDirectory( file );
			BaseLogger.log("3",null,null, "This "+file.getName()+" dir has been deleted." );
		}
	}

	/**
	 * To delete file on given path
	 *
	 * @param filePath the file path
	 */
	public void deleteFile( String filePath ) throws Throwable
	{
		File file = new File( filePath );
		if( file.exists() )
		{
			if( file.delete() )
			{
				BaseLogger.log("3",null,null, "This "+file.getName()+" file has been deleted." );
			}
		}
	}
	//Added By Suraj Bhandvale On 09/12/15 [W15HSUN005][To delete file]END
	/**
	 * Compares two files and returns true
	 * if second file is older
	 * @return
	 *
	 */
	//Added By Suraj Bhandvale On 26/02/15 [W15HSUN005][To Compare to files]Start
	public boolean compareFiles(String filePath1 , String filePath2)
	{
		BaseLogger.log("2",null,null,"------------Comparing files--------------");
		boolean isOld = false ;
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			File file1 = new File(filePath1);
			File file2 = new File(filePath2);
			String file1Date = sdf.format(file1.lastModified());
			String file2Date = sdf.format(file2.lastModified());
			Date date1 = sdf.parse(file1Date);
			Date date2 = sdf.parse(file2Date);
			if(date1.after(date2))
			{
				isOld = true ;
			}

		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return isOld;
	}
	//Added By Suraj Bhandvale On 26/02/15 [W15HSUN005][To Compare to files]End

	//Added by Prasad on 07/03/16 [to convert XML to JSON and JSON to XML String] START
	/**
	 * to convert XML String into Json String
	 *
	 * @param xmlString
	 * @return
	 * @throws Exception
	 */
	public String xmlToJSONString( String xmlString ) throws Exception
	{
		//Changed by Ravindra C on 15/12/2020 [used jettison.json object as getting parsing issue]
		return (new XMLtoJSONConverter().xmlToJSONString( xmlString ));
	}

	/**
	 * to convert Json String into XML String
	 *
	 * @param jsonobject
	 * @return
	 * @throws ITMException
	 */
	public String jsonToXMLString( String jsonString ) throws ITMException
	{
		//Changed by Ravindra C on 15/12/2020 [used jettison.json object as getting parsing issue]
		return (new JSONtoXMLConverter().jsonToXMLString( jsonString ));
	}

	/**
	 * check valid JSON or Not
	 *
	 * @param jsonString
	 * @return
	 */
	public boolean isJSONValid( String jsonString )
	{
		try
		{
			new JSONObject( jsonString );
		}
		catch (JSONException ex)
		{
			try
			{
				new JSONArray( jsonString );
			}
			catch (JSONException ex1)
			{
				return false;
			}
		}
		return true;
	}

	//Added by Jatin M on 02-03-2023 [ To validate if the input if JSONArray or not] - START
	public boolean isJSONArrayValid( String jsonString )
	{
		try
		{
			new JSONArray( jsonString );
		}
		catch (JSONException ex)
		{
			return false;
		}
		catch (Exception e)
		{
			return false;
		}
		return true;
	}
	//Added by Jatin M on 02-03-2023 [ To validate if the input if JSONArray or not] - END
	//Added by Prasad on 07/03/16 [to convert XML to JSON and JSON to XML String] END
	//Added by Santosh on 09/01/17 to format data xml [Start]
	public String getReorderedXML(String targetXml, String inputXML) throws ITMException, NumberFormatException, RemoteException
	{
		Document transDom = parseString( inputXML );
		Document blankDom = null;
		NodeList transDomChildNL = null;
		if(transDom.getElementsByTagName("Header0").item(0) != null){
			transDomChildNL = transDom.getElementsByTagName("Header0").item(0).getChildNodes();
		}
		int transDomChildNLLength = transDomChildNL.getLength();
		for ( int i = 0; i < transDomChildNLLength; i++ )
		{
			Node transDomChildNode = null;
			if(transDomChildNL.item( i ) != null)
			{
				transDomChildNode = transDomChildNL.item( i );
			}
			Node tempNode = null;
			if ( transDomChildNode.getNodeName().indexOf("Detail") != -1 )
			{
				blankDom = parseString( targetXml );
				//Added by Pratheek on 25-05-18[to check if value is null or not]-STart
				String currObjCtx ="";
				String currDomID ="";
				if(transDomChildNode.getAttributes().getNamedItem("domID") !=null)
				{
					currDomID = transDomChildNode.getAttributes().getNamedItem("domID").getNodeValue();
				}
				if(transDomChildNode.getAttributes().getNamedItem("objContext") !=null)
				{
					currObjCtx = transDomChildNode.getAttributes().getNamedItem("objContext").getNodeValue();
				}
				//Added by Pratheek on 25-05-18[to check if value is null or not]-End
				tempNode = blankDom.getElementsByTagName(transDomChildNode.getNodeName()).item(0);
				NamedNodeMap attributesH = tempNode.getAttributes();
				Node searchNode = transDomChildNode;
				for (int attCtr = 0; attCtr < attributesH.getLength(); ++attCtr)
				{
					Node attr = attributesH.item(attCtr);
					String attributeString = getAttributeValue(transDom, currObjCtx, currDomID, attr.getNodeName());
					attr.setNodeValue(attributeString);
				}

				NodeList nodeList = tempNode.getChildNodes();
				String valueData = "";

				for(int nodeCtr = 0;nodeCtr < nodeList.getLength(); nodeCtr++)
				{
					Node currNode = nodeList.item(nodeCtr);
					if(!"#text".equals(currNode.getNodeName()))
					{
						if(!currNode.getNodeName().equalsIgnoreCase("attribute") )
						{
							valueData = getColumnValueFromNode(currNode.getNodeName(), searchNode);
							BaseLogger.log("3",null,null,searchNode.getNodeName()+"="+currNode.getNodeName()+"="+valueData);
							if(valueData == null)
							{
								valueData="";
							}
							if( currNode.getFirstChild() != null )
							{
								currNode.removeChild(currNode.getFirstChild());
							}
							if( currNode.getFirstChild() != null )
							{
								currNode.setNodeValue(valueData);
							}
							else
							{
								CDATASection cDataSection = blankDom.createCDATASection(valueData);
								currNode.appendChild( cDataSection );
							}
						}
						else
						{
							NamedNodeMap attributes = currNode.getAttributes();
							for (int attCtr = 0; attCtr < attributes.getLength(); ++attCtr)
							{
								Node attr = attributes.item(attCtr);
								String attribString = getAttributeValue(searchNode, attr.getNodeName());
								attr.setNodeValue(attribString);
							}

						}
					}
				}
				Node headerNode = transDom.getElementsByTagName("Header0").item(0);
				headerNode.replaceChild(headerNode.getOwnerDocument().importNode(tempNode,true),transDomChildNode);
			}
		}
		return serializeDom(transDom);
	}
	private static String getAttributeValue( Document dom, String objContext, String domID, String attributeName )throws ITMException
	{
		String attributeValue = null;
		try
		{
			objContext = ( objContext == null || objContext.length() == 0 ) ? "1" : objContext;
			domID = ( domID == null || domID.length() == 0 ) ? "1" : domID;
			NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
			int detListLength = detailList.getLength();
			for(int ctr = 0; ctr < detListLength; ctr++)
			{
				Node curDetail = detailList.item(ctr);
				if(curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(domID))
				{
					//ADDED By Pratheek on 25-05-18[to check if value is nul or not]-Start
					if(curDetail.getAttributes().getNamedItem(attributeName) !=null)
					{
						attributeValue = curDetail.getAttributes().getNamedItem(attributeName).getNodeValue();
					}
					//ADDED By Pratheek on 25-05-18[to check if value is nul or not]-End
					break;
				}
				else
				{
					continue;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : : searchNode :["+e.getMessage()+"]");
			throw new ITMException(e);
		}
		return attributeValue;
	}
	public static String getAttributeValue( Node dom, String attributeName )throws ITMException
	{
		String attributeValue = null;
		try
		{
			NodeList detailList = dom.getChildNodes();
			int detListLength = detailList.getLength();
			for(int ctr = 0; ctr < detListLength; ctr++)
			{
				Node curDetail = detailList.item(ctr);
				if(("attribute").equals(curDetail.getNodeName()) )
				{
					if(curDetail.getAttributes().getNamedItem(attributeName) !=null)
					{
						attributeValue = curDetail.getAttributes().getNamedItem(attributeName).getNodeValue();
					}
					BaseLogger.log("3",null,null,"attributeValue 3712!!!["+attributeValue+"]");
					break;
				}
				else
				{
					continue;
				}
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : : searchNode :"+e);
			throw new ITMException(e);
		}
		return attributeValue;
	}
	//Added by Santosh on 09/01/17 to format data xml [End]

	//Added by Sagar Balip on 08/02/17 to print on console [Start]
	/**
	 * To print on Console on Demand
	 * DEBUG_LEVEL = 9
	 * @param msg
	 */
	public static void printOnDemand( Object msg )
	{
		if( "9".equals( CommonConstants.DEBUG_LEVEL ) )
		{
			BaseLogger.log("3",null,null, msg );
		}
	}

	/**
	 * To print on console always
	 * @param msg
	 */
	public static void printAlways( Object msg )
	{
		BaseLogger.log("2",null,null, msg );
	}
	//Added by Sagar Balip on 08/02/17 to print on console [End]
	// Added by Mahesh Saggam [31-MAY-21] [When to try to View the newly added transaction "Data mismatch zero row returned " error occurs.] Start
	public void setAttribValue(Node node, String nodeName, String value)
	{
		if(node.hasAttributes())
		{
			NamedNodeMap detAttrMap = node.getAttributes();
			for(int ind=0; ind<detAttrMap.getLength(); ind++)
			{
				Node attr = detAttrMap.item(ind);
				BaseLogger.log("3",null,null,"Print nodename::: 3580 ["+attr.getNodeName()+"]");
				if(nodeName.equalsIgnoreCase(attr.getNodeName()))
				{
					attr.setNodeValue(value);
					break;
				}
			}
		}
	}
	// Added by Mahesh Saggam [31-MAY-21] [When to try to View the newly added transaction "Data mismatch zero row returned " error occurs.] End

	//Added by Bhupendra M on 15-05-17 for Tran Id is not display on summery page after saving any transaction in compact layout Starts
	public String editWebSocketXml( String infiStr )
	{
		HashMap<String, String> transPkDataMap = new HashMap<String, String>();
		StringBuilder finalInfiString = new StringBuilder();
		String PKFieldNames = "";
		String PKFieldValues = "";
		String dataXml = "";
		String pkNamesData [] = null;
		String pkValuesData [] = null;
		String currentUpdateFlag = "";
		try
		{
			if( !"".equalsIgnoreCase(infiStr) && infiStr.length() > 0 )
			{
				String newData [] =  infiStr.split("~");
				PKFieldNames = newData[0];
				PKFieldValues = newData[1];
				dataXml = newData[2];
				pkNamesData  = PKFieldNames.split(":");
				pkValuesData = PKFieldValues.split(":");
			}
			for( int j=0; j < pkNamesData.length; j++ )
			{
				transPkDataMap.put( pkNamesData[j], pkValuesData[j] );
			}
			BaseLogger.log("3",null,null,"PKFieldNames ["+PKFieldNames+"] PKFieldValues ["+PKFieldValues+"] *** transPkDataMap ["+transPkDataMap+"]  \n");
			Document document = parseString(dataXml);
			NodeList detailNodeList = document.getElementsByTagName("Detail1");
			// Added by Mahesh Saggam [31-MAY-21] [When to try to View the newly added transaction "Data mismatch zero row returned " error occurs.] Start
			try
			{
				Node detNode = detailNodeList.item(0);
				String id = "";
				String objCtxt = "1";
				String domId = "1";
				NodeList detChildList = detNode.getChildNodes();
				if(detNode.hasAttributes())
				{
					if(detNode.getAttributes().getNamedItem("dbID") != null && "".equalsIgnoreCase(detNode.getAttributes().getNamedItem("dbID").getNodeValue().trim()))
					{
						BaseLogger.log("3",null,null,"Vlaue of dbId is blank");
						id = objCtxt + ":" + domId + ":" + PKFieldValues;
						setAttribValue(detNode, "dbID", PKFieldValues);
						setAttribValue(detNode, "id", id);

						for(int i=0; i<detChildList.getLength(); i++)
						{
							Node detChildNode = detChildList.item(i);
							if("attribute".equalsIgnoreCase(detChildNode.getNodeName()))
							{
								setAttribValue(detChildNode, "pkNames", PKFieldNames);
								break;
							}
						}
					}
				}

			}
			catch(Exception e)
			{
				BaseLogger.log("3",null,null,"Exception inside editWebSocketXml line 3573 ["+e.getMessage()+"]");
			}
			// Added by Mahesh Saggam [31-MAY-21] [When to try to View the newly added transaction "Data mismatch zero row returned " error occurs.] End
			NodeList attributeNodeList = document.getElementsByTagName("attribute");
			for( int n=0; n< attributeNodeList.getLength(); n++)
			{
				Node attributeNode = attributeNodeList.item(n);
				if( attributeNode.hasAttributes() )
				{
					NamedNodeMap detailAttrMap = attributeNode.getAttributes();
					for( int k=0; k< detailAttrMap.getLength(); k++ )
					{
						Node tempNode = detailAttrMap.item(k);
						if( "updateFlag".equalsIgnoreCase( tempNode.getNodeName() ) )
						{
							currentUpdateFlag = tempNode.getFirstChild().getNodeValue();
						}
					}
				}
			}
			BaseLogger.log("3",null,null,"E12GenUtlt currentUpdateFlag ["+currentUpdateFlag+"]");
			if( currentUpdateFlag.equalsIgnoreCase("A") || currentUpdateFlag.equalsIgnoreCase("N") )
			{
				for (int j = 0; j < detailNodeList.getLength(); j++)
				{
					Node detailNode = detailNodeList.item(j);
					//if( currentUpdateFlag.equalsIgnoreCase("A") )
					{
						NodeList detailChildList = detailNode.getChildNodes();
						for( int k=0; k< detailChildList.getLength(); k++ )
						{
							Node childNode = detailChildList.item(k);
							if(childNode.getNodeType() == Node.ELEMENT_NODE && !"attribute".equalsIgnoreCase(childNode.getNodeName()))
							{
								if( childNode.getFirstChild() != null )
								{

								}
								else
								{
									String nodeName = childNode.getNodeName();
									if( transPkDataMap.containsKey( nodeName ) )
									{
										BaseLogger.log("3",null,null,"Node name --"+childNode.getNodeName());
										childNode.appendChild( document.createCDATASection( transPkDataMap.get( nodeName ) ));
									}
								}
							}
						}
					}
				}
			}
			document.normalize();
			finalInfiString.append(PKFieldNames+"~"+PKFieldValues+"~"+serializeDom(document));
			BaseLogger.log("3",null,null, "Changes XML finalInfiString Value ["+finalInfiString+"]  \n" );
			infiStr = finalInfiString.toString();
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception :RequestHandlerServlet :editTransEditorXMLData :==> "+e.getMessage());
		}
		return infiStr;
	}
	//Added by Bhupendra M on 15-05-17 for Tran Id is not display on summery page after saving any transaction in compact layout Ends

	// Added by Sandesh Shinde on 17-MAY-2017 [ Authentication API: Improper Error handling] Start
	/**
	 * This method write the exception message to a txt file based on trace.
	 * @param trace
	 * @param folderPath
	 * @param fileName
	 * @return
	 */
	public static String updateLog( String trace, String folderPath, String fileName)
	{
		String exceptionLogFile = "";
		File logFile = null;
		try
		{
			Random random = new Random();
			int randomInt = random.nextInt(100000);
			// FolderPath is blank or null then default path will use
			String filePath = checkNull(folderPath).length() > 0 ? folderPath
					: CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "ExceptionLog";

			File logDir = new File(filePath);
			// FileName is blank or null then randomNumber will be name as file.
			exceptionLogFile = checkNull(fileName).length() > 0 ? fileName : randomInt + "";
			// Check folder exists if not then create
			if (!logDir.exists())
			{
				logDir.mkdirs();
			}

			//Added by Prasad on 07/09/2020 [to delete the files from folder is provided limit is exceeds]
			//E12GenericUtility.deleteOldFilesFromFolder( filePath, null, CommonConstants.MAX_LOG_FILE_LEN );

			logFile = new File( filePath, exceptionLogFile+".txt" );
			logFile.createNewFile();
			PrintWriter writer = new PrintWriter(logFile);
			writer.print(trace);
			writer.close();
		}
		catch( IOException er )
		{
			BaseLogger.log("0",null,null,"BaseException :: updateLog : " + er.getMessage());
			er.printStackTrace();
		}

		return exceptionLogFile;
	}
	// Added by Sandesh Shinde on 17-MAY-2017 [ Authentication API: Improper Error handling] End
	//Added by Pankaj R on 26-DEC-19 to get datamodel xsl [START]

	//Added by Jay.K to draw summary from enterprise folder[Start]
	public String getSummaryXSL( String objName, String callerInterface,String enterprise)
	{
		return getObjNameWiseXSL( objName, callerInterface, null,enterprise );
	}
	//Added by Jay.K to draw summary from enterprise folder[End]

	public String getSummaryXSL( String objName, String callerInterface )
	{
		return getObjNameWiseXSL( objName, callerInterface, null );
	}

	//Added by Jay.K to draw summary from enterprise folder[Start]
	public String getObjNameWiseXSL( String objName, String callerInterface, String dataModelName, String enterprise )
	{
		String xsl = "";
		try
		{
			callerInterface = checkNull( callerInterface );
			String xslFileName = "";
			String xslFilePath = "";
			if( !"".equalsIgnoreCase( callerInterface ) )
			{
				//Commented and Added by Pankaj R on 26-DEC-19 to get datamodel xsl [START]
				if(checkNull(dataModelName).length() > 0)
				{
					if( callerInterface.equalsIgnoreCase("MOBILE") )
					{
						xslFileName = dataModelName+"_MOBILE.xsl";
					}
					else
					{
						xslFileName = dataModelName+".xsl";
					}
				}
				else
				{
					if( callerInterface.equalsIgnoreCase("MOBILE") )
					{
						xslFileName = objName+"_preview_MOBILE.xsl";
					}
					else
					{
						xslFileName = objName+"_preview.xsl";
					}
				}
				//Commented and Added by Pankaj R on 26-DEC-19 to get datamodel xsl [END]
			}
			//String path = CommonConstants.APPLICATION_CONTEXT;
			//BaseLogger.log("9",null,null,"----11### path ["+path+"]");
			//path = path + "webitm" + File.separator + "xsl"+ File.separator + "Standard" + File.separator + xslFileName;
			xslFilePath = getXSLFilePath( xslFileName,enterprise );

			if( callerInterface.equalsIgnoreCase("MOBILE") )
			{
				if( xslFilePath == null )
				{
					xslFileName = objName+"_preview.xsl";
					xslFilePath = getXSLFilePath( xslFileName,enterprise );
				}
			}

			BaseLogger.log("0",null,null,"!!** Path is ["+xslFilePath+"]");
			if( xslFilePath == null )
			{
				xsl = "<Root></Root>";
			}
			else
			{
				FileReader fr = new FileReader( xslFilePath );
				StringBuilder xslBuilder = new StringBuilder();
				BufferedReader bufr = new BufferedReader(fr);
				int count = 1;
				String line = bufr.readLine();
				while (line != null)
				{
					xslBuilder.append(line);
					line = bufr.readLine();
				}
				bufr.close();
				xsl = xslBuilder.toString();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception while reading xsl file E12Gen ["+e.getMessage()+"]");
		}
		return xsl;
	}
	//Added by Jay.K to draw summary from enterprise folder[End]

	//Added by Bhupendra M on 5-June-17 for Client Side Summary Xsl Transformation Starts
	public String getObjNameWiseXSL( String objName, String callerInterface, String dataModelName )
	{
		String xsl = "";
		try
		{
			callerInterface = checkNull( callerInterface );
			String xslFileName = "";
			String xslFilePath = "";
			if( !"".equalsIgnoreCase( callerInterface ) )
			{
				//Commented and Added by Pankaj R on 26-DEC-19 to get datamodel xsl [START]
				if(checkNull(dataModelName).length() > 0)
				{
					if( callerInterface.equalsIgnoreCase("MOBILE") )
					{
						xslFileName = dataModelName+"_MOBILE.xsl";
					}
					else
					{
						xslFileName = dataModelName+".xsl";
					}
				}
				else
				{
					if( callerInterface.equalsIgnoreCase("MOBILE") )
					{
						xslFileName = objName+"_preview_MOBILE.xsl";
					}
					else
					{
						xslFileName = objName+"_preview.xsl";
					}
				}
				//Commented and Added by Pankaj R on 26-DEC-19 to get datamodel xsl [END]
			}
			//String path = CommonConstants.APPLICATION_CONTEXT;
			//BaseLogger.log("9",null,null,"----11### path ["+path+"]");
			//path = path + "webitm" + File.separator + "xsl"+ File.separator + "Standard" + File.separator + xslFileName;
			xslFilePath = getXSLFilePath( xslFileName );

			if( callerInterface.equalsIgnoreCase("MOBILE") )
			{
				if( xslFilePath == null )
				{
					xslFileName = objName+"_preview.xsl";
					xslFilePath = getXSLFilePath( xslFileName );
				}
			}

			BaseLogger.log("0",null,null,"!!** Path is ["+xslFilePath+"]");
			if( xslFilePath == null )
			{
				xsl = "<Root></Root>";
			}
			else
			{
				FileReader fr = new FileReader( xslFilePath );
				StringBuilder xslBuilder = new StringBuilder();
				BufferedReader bufr = new BufferedReader(fr);
				int count = 1;
				String line = bufr.readLine();
				while (line != null)
				{
					xslBuilder.append(line);
					line = bufr.readLine();
				}
				bufr.close();
				xsl = xslBuilder.toString();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"Exception while reading xsl file E12Gen ["+e.getMessage()+"]");
		}
		return xsl;
	}

	//Added by Jay.K to draw summary from enterprise folder[Start]
	private String getXSLFilePath( String fileName,String enterprise )
	{
		BaseLogger.log("2",null,null, "getXSLFileName:fileName::: "+fileName );
		BaseLogger.log("2",null,null, "getXSLFileName:Enterprise::: "+enterprise );

		String retFileName = null;

		try
		{

			String defaultPath = null;

			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT;
				BaseLogger.log("3",null,null,"default Application context path:"+defaultPath);
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			if ( ! ( new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME ) ).exists() )
			{
				( new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME) ).mkdir();
			}

			File xslFile = new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME , fileName);
			File xslFileInEnterprise = new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + enterprise, fileName);

			BaseLogger.log("3",null,null,"File exists in Standard :"+xslFile.exists());
			BaseLogger.log("3",null,null,"File exists in Enterprise Folder :"+xslFileInEnterprise.exists());

			if(xslFileInEnterprise.exists())
			{
				retFileName = xslFileInEnterprise.getAbsolutePath();
				BaseLogger.log("3",null,null,"File found @ "+xslFileInEnterprise.getAbsolutePath());
			}
			else if (xslFile.exists()) 
			{
				retFileName = xslFile.getAbsolutePath();
				BaseLogger.log("3",null,null,"File found @ "+xslFile.getAbsolutePath());
			}
			else
			{
				BaseLogger.log("3",null,null,"File not found @ "+xslFileInEnterprise.getAbsolutePath()+" OR @ "+xslFile.getAbsolutePath());

			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return retFileName;
	}
	//Added by Jay.K to draw summary from enterprise folder[End]

	private String getXSLFilePath( String fileName )
	{
		BaseLogger.log("2",null,null, "getXSLFileName:fileName: "+fileName );
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT;
				BaseLogger.log("3",null,null,"default Application context path:"+defaultPath);
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			if ( ! ( new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME ) ).exists() )
			{
				( new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME) ).mkdir();
			}

			File xslFile = new File(defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME , fileName);
			BaseLogger.log("3",null,null,"xslFile exists :"+xslFile.exists());
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				BaseLogger.log("3",null,null,"Default file not found @ "+xslFile.getAbsolutePath());
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return retFileName;
	}
	//Added by Bhupendra M on 5-June-17 for Client Side Summary Xsl Transformation End
	//Added by Samadhan pawar on 30/10/2017 for property editor enterprise ( site and division ) wise start
	public String getMetaDataFilePath( String objName, String objContext, String pageContext, String formName, HashMap<String, String> propEditorInfoMap, String transDB)
	{
		BaseLogger.log("2",null,null, "E12GenericUtils:getMetaDataFilePath: objName: [" + objName + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getMetaDataFilePath: objContext: [" + objContext + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getMetaDataFilePath: pageContext: [" + pageContext + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getMetaDataFilePath: formName: [" + formName + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getMetaDataFilePath: propEditorInfoMap: [" + propEditorInfoMap + "]" );
		String retFilePath = null;
		ResourceModifier resModifier = null;
		ArrayList<String> enterpriseResList = new ArrayList<String>();
		ArrayList<String> profileResList = new ArrayList<String>();
		String metaDataFilePath = "";
		String exportToFolderName = "";
		String mataDataDefaultPath = "";
		File metaDataFile = null;
		String metaDatafileName = "";
		String profileIdRes = "";
		String enterpriseIdRes = "";
		String profileId = "";
		String editor = "";
		try
		{
			if(formName != null && !"null".equalsIgnoreCase(formName) && formName.trim().length() > 0)
			{
				metaDatafileName = objName + pageContext + formName;
			}
			else
			{
				metaDatafileName = objName+""+pageContext+""+objContext;
			}
			profileIdRes = checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
			enterpriseIdRes = checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
			profileId = checkNull(propEditorInfoMap.get("PROFILE_ID")); //Added by Jatin M on 10-06-2021 for profile Id wise changes
			//editor = checkNull(propEditorInfoMap.get("EDITOR")); //removed editor wise metadata resource pack property editor as per kandarp sir.
			propEditorInfoMap.put("EDITOR", editor);

			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
			String userId = checkNull(propEditorInfoMap.get("USER_ID"));
			boolean tablePropFileExist = false;
			boolean prResPropFileExist = false;
			boolean entrResPropFileExist = false;

			resModifier = new ResourceModifier();
			// Commented and Added by Pankaj R on 24-Nov-20 as suggested by Danish sir
			// mataDataDefaultPath = CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator;
			mataDataDefaultPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
			if( "".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes) )
			{
				metaDataFilePath = mataDataDefaultPath;
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
				//Changes by Jatin M on 10-06-2021 for profile Id wise changes - Start
				tablePropFileExist = resModifier.isTablePropertiesFileExist( objName, objContext, pageContext, editor, formName, userId, profileId );
				if ( tablePropFileExist )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileId + File.separator + userId + File.separator;
				}
				//Changes by Jatin M on 10-06-2021 for profile Id wise changes - End
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
			}
			else
			{
				if( "".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes) )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
				}
				else if(!"".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes))
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator + userId + File.separator;
				}
				else
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator + userId + File.separator;
				}
			}
			BaseLogger.log("3",null,null,"E12GenericUtils:getMetaDataFilePath:metaDataFilePath :["+metaDataFilePath+"]");
			metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml");
			if( ! metaDataFile.exists() )
			{
				if( !"".equalsIgnoreCase(profileIdRes)  )
				{
					profileResList =  resModifier.getResourcePath( profileIdRes, transDB );
				}
				if( !"".equalsIgnoreCase(enterpriseIdRes) )
				{
					enterpriseResList = resModifier.getEnterpriseResPath( enterpriseIdRes, transDB );
				}

				if( profileResList.size() <= 0 && enterpriseResList.size() <= 0 )
				{
					metaDataFilePath = mataDataDefaultPath;
					//metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml");
					//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
					//Changes by Jatin M on 10-06-2021 for profile Id wise changes - Start
					tablePropFileExist = resModifier.isTablePropertiesFileExist( objName, objContext, pageContext, editor, formName, userId, profileId );
					if ( tablePropFileExist )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileId + File.separator + userId + File.separator;
						exportToFolderName = userId;
					}
					//Changes by Jatin M on 10-06-2021 for profile Id wise changes - End
					//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
				}
				else
				{
					prResPropFileExist = resModifier.isPropertiesFileExist(profileResList, objName, objContext, pageContext, editor, formName);
					entrResPropFileExist = resModifier.isPropertiesFileExist(enterpriseResList, objName, objContext, pageContext, editor, formName);
					if( profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFileExist && entrResPropFileExist )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator + userId + File.separator;
						exportToFolderName = (enterpriseIdRes + "-"+ profileIdRes) + File.separator + userId;
					}
					else if( profileResList.size() > 0 && prResPropFileExist )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator + userId + File.separator;
						exportToFolderName = profileIdRes + File.separator + userId;
					}
					else if( enterpriseResList.size() > 0 && entrResPropFileExist )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
						exportToFolderName = enterpriseIdRes + File.separator + userId;
					}
					else
					{
						metaDataFilePath = mataDataDefaultPath;
					}
				}
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
				metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml");
				if( ! metaDataFile.exists() && (prResPropFileExist || entrResPropFileExist || tablePropFileExist) )
				{
					CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
					UserInfoBean userInfo = commonDBAccessEJB.createUserInfo(userId);
					DWFactory dws = new DWFactory(userInfo);
					DWObject dwObject = ( DWObject )dws.getDataWindow( metaDatafileName );
					String tempStr = dwObject.exportToXML(exportToFolderName, objName, objContext, pageContext, formName, profileResList, enterpriseResList, propEditorInfoMap, transDB);
				}
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
				BaseLogger.log("3",null,null,"E12GenericUtils:getMetaDataFilePath:metaDataFilePath :["+metaDataFilePath+"]");
			}

			BaseLogger.log("3",null,null,"Metadata file exists :"+metaDataFile.exists());
			if( metaDataFile.exists() )
			{
				retFilePath = metaDataFile.getAbsolutePath();
			}
			else
			{
				retFilePath = "";
				BaseLogger.log("3",null,null,"E12GenericUtils:getMetaDataFilePath: MetaDataFilePath not found......");
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		BaseLogger.log("2",null,null,"E12GenericUtils:getMetaDataFilePath: retFilePath :["+retFilePath+"]");
		return retFilePath;
	}

	public String getAngCompFilePath( HashMap<String, String> propEditorInfoMap, String transDB, String objName ) throws ITMException
	{
		BaseLogger.log("2",null,null,"23012023 Inside getAngCompFilePath");
		ResourceModifier resModifier = null;
		ArrayList<String> enterpriseResList = new ArrayList<String>();
		ArrayList<String> profileResList = new ArrayList<String>();
		String xslFilePath = "";
		String xslDefaultPath = "";
		String profileIdRes = "";
		String enterpriseIdRes = "";
		String profileId = ""; //Added by Jatin M on 10-06-2021 for profile Id wise changes
		try
		{
			profileIdRes = checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
			enterpriseIdRes = checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
			profileId = checkNull(propEditorInfoMap.get("PROFILE_ID"));
			resModifier = new ResourceModifier();
			if(CommonConstants.APPLICATION_CONTEXT != null)
			{
				xslDefaultPath = CommonConstants.APPLICATION_CONTEXT;
			}
			else
			{
				xslDefaultPath = ".." + File.separator + "webapps" + File.separator + "ibase";
			}

			xslDefaultPath = xslDefaultPath + File.separator  + "angular" + File.separator + "components";

			if( !"".equalsIgnoreCase(profileIdRes)  )
			{
				profileResList =  resModifier.getResourcePath( profileIdRes, transDB );
			}

			if( !"".equalsIgnoreCase(enterpriseIdRes) )
			{
				enterpriseResList = resModifier.getEnterpriseResPath( enterpriseIdRes, transDB );
			}

			if( profileResList.size() <= 0 && enterpriseResList.size() <= 0 )
			{
				xslFilePath = xslDefaultPath;
			}
			else
			{
				if( profileResList.size() > 0 && enterpriseResList.size() > 0 )
				{
					xslFilePath = xslDefaultPath + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator;
				}
				else if( profileResList.size() > 0 )
				{
					xslFilePath = xslDefaultPath + File.separator + profileIdRes + File.separator;
				}
				else if( enterpriseResList.size() > 0 )
				{
					xslFilePath = xslDefaultPath + File.separator + enterpriseIdRes + File.separator;
				}
			}
			xslFilePath = xslFilePath + File.separator + objName;

			if ( ! ( new File( xslFilePath ) ).exists() )
			{
				( new File(xslFilePath) ).mkdirs();
			}
		}
		catch (Exception e)
		{
			BaseLogger.log("0",null,null,"E12GenericUtils: getAngCompFilePath: e :["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"E12GenericUtils: getAngCompFilePath: xslFilePath :["+xslFilePath+"]");
		return xslFilePath;
	}

	public String getWebEditorXslPath( HashMap<String, String> propEditorInfoMap, String transDB ) throws ITMException
	{
		ResourceModifier resModifier = null;
		ArrayList<String> enterpriseResList = new ArrayList<String>();
		ArrayList<String> profileResList = new ArrayList<String>();
		String xslFilePath = "";
		String xslDefaultPath = "";
		String profileIdRes = "";
		String enterpriseIdRes = "";
		String profileId = ""; //Added by Jatin M on 10-06-2021 for profile Id wise changes
		try
		{
			profileIdRes = checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
			enterpriseIdRes = checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
			profileId = checkNull(propEditorInfoMap.get("PROFILE_ID"));
			resModifier = new ResourceModifier();
			if(CommonConstants.APPLICATION_CONTEXT != null)
			{
				xslDefaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT ;
			}
			else
			{
				xslDefaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT;
			}

			xslDefaultPath = xslDefaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME;

			if( !"".equalsIgnoreCase(profileIdRes)  )
			{
				profileResList =  resModifier.getResourcePath( profileIdRes, transDB );
			}

			if( !"".equalsIgnoreCase(enterpriseIdRes) )
			{
				enterpriseResList = resModifier.getEnterpriseResPath( enterpriseIdRes, transDB );
			}

			if( profileResList.size() <= 0 && enterpriseResList.size() <= 0 )
			{
				xslFilePath = xslDefaultPath;
			}
			else
			{
				if( profileResList.size() > 0 && enterpriseResList.size() > 0 )
				{
					xslFilePath = xslDefaultPath + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator;
				}
				else if( profileResList.size() > 0 )
				{
					xslFilePath = xslDefaultPath + File.separator + profileIdRes + File.separator;
				}
				else if( enterpriseResList.size() > 0 )
				{
					xslFilePath = xslDefaultPath + File.separator + enterpriseIdRes + File.separator;
				}
			}

			if ( ! ( new File( xslFilePath ) ).exists() )
			{
				( new File(xslFilePath) ).mkdirs();
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		BaseLogger.log("2",null,null,"E12GenericUtils: getWebEditorXslPath: xslFilePath :["+xslFilePath+"]");
		return xslFilePath;
	}
	//Added by Samadhan pawar on 30/10/2017 for property editor enterprise( site and division ) wise end
	//Added By Prasad R on 24/11/17 for error msg [start]
	public String getErrorString( String columnName, String msgNo, String userId )throws RemoteException,ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		StringBuffer errStringXml;
		Statement stmt = null;
		Statement stmt1 = null;
		Statement stmt2 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		String sqlQuery,sqlQuery1;
		String msgType = "";
		String msgString = "";
		String msgDescription = "";
		String profileId = "";
		String errSource = "";
		String tempMsgType = "";
		String msgOption = "";
		String msgTime = "";

		String redirerr = "";
		String soundPlay = "";
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			connDriver = null;
			sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
				msgString = rs.getString("MSG_STR");
				msgDescription = rs.getString("MSG_DESCR");
				errSource = rs.getString("ERR_SOURCE");
				msgOption = rs.getString("MSG_OPT");
				msgTime = rs.getString("MSG_TIME");
				soundPlay = rs.getString("ALARM");
			}
			else
			{
				msgDescription = "Message Id not found" + " [" + msgNo + "]" ;
				msgType = "E";
				msgString = "";
			}

			if (msgType.equals("E") || msgType.trim().length() == 0)
			{
				sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(sqlQuery1);
				if (rs1.next())
				{
					profileId=rs1.getString("profile_id");
					if (profileId == null)
					{
						profileId= "";
					}
					sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )"; //$NON-NLS-2$ //$NON-NLS-3$
					stmt2 = conn.createStatement();
					rs2 = stmt2.executeQuery(sqlQuery1);
					if (rs2.next())
					{
						tempMsgType = rs2.getString("msg_type");
					}
					rs2.close();
				}
				rs1.close();
				if (tempMsgType!=null && tempMsgType.trim().length()>0)
				{
					msgType = tempMsgType;
				}
			}
			if (msgType.equals("W"))
			{
				msgString = "Warning : " + msgString;
			}
			else if (msgType.equals("P"))
			{
				msgString = "Prompt : " + msgString;
			}
			else if(msgType.equals("F"))
			{
				msgString = "Information : " + msgString;
			}
			else
			{
				msgType = "E";
				msgString = "Error : " + msgString;
			}
			if (errSource!=null && errSource.trim().equals("D"))
			{
				msgDescription = msgDescription +  " * From Database ";
			}
			if (redirerr==null || redirerr.trim().length()==0)
			{
				redirerr = "1";
			}
			if (msgOption!=null && msgOption.trim().equals("M"))
			{
				if (redirerr.trim().equals("1"))
				{
					redirerr = "2";
				}
				else
				{
					redirerr = "1";
				}
			}
			if (rs != null)
			{
				rs.close();
				stmt.close();
			}
			if (rs1 != null)
			{
				rs1.close();
				stmt1.close();
			}
			if (rs2 != null)
			{
				rs2.close();
				stmt2.close();
			}
			conn.close();
		}
		catch(ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException : [E12GenericUtility][getErrorString] :==>\n"+itme.getMessage());
			throw itme;
		}
		catch(SQLException se)
		{
			msgDescription = se.getMessage();
			msgType = "";
			msgString = "";
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getErrorString] :==>\n"+se.getMessage());
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getErrorString] :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}
				if ( stmt2 != null )
				{
					stmt2.close();
					stmt2 = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( rs2 != null )
				{
					rs2.close();
					rs2 = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		errStringXml = new StringBuffer();
		//Changed by Prasad on 13/10/2020 [created a common method for errorString] START
		/*errStringXml.append("<?xml version=\"1.0\"?>\r\n<Root><Errors>\r\n");
		errStringXml.append("<error id=\"");
		errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
		errStringXml.append(columnName).append("\">\r\n");
		errStringXml.append("<message><![CDATA[ "+msgString+"]]></message>");
		errStringXml.append("<description><![CDATA["+msgDescription+"]]></description>");
		errStringXml.append("<type><![CDATA["+msgType+"]]></type>");
		errStringXml.append("<time><![CDATA["+msgTime+"]]></time>");
		errStringXml.append("<alarm><![CDATA["+soundPlay+"]]></alarm>");
		errStringXml.append("<source><![CDATA["+errSource+"]]></source>");
		errStringXml.append("<trace><![CDATA["+msgString+"]]></trace>");
		errStringXml.append("<redirect><![CDATA["+redirerr+"]]></redirect>");
		errStringXml.append("</error>").append("</Errors></Root>");*/
		errStringXml.append( getErrorString( msgNo, msgType, columnName, msgString, msgDescription, msgString, msgOption, msgTime, soundPlay, errSource, redirerr ) );
		//Changed by Prasad on 13/10/2020 [created a common method for errorString] END

		return errStringXml.toString();
	}

	public String getErrorString( String columnName, String messageValue, String message, String errorId )
	{
		//Changed by Prasad on 13/10/2020 [created a common method for errorString] START
		/*String errString = "";
		try
		{
			columnName = checkNull( columnName );
			if ( columnName.length() == 0 )
			{
				columnName = "description";
			}
			StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
			valueXmlErrorString.append("<error id=\"").append(errorId).append("\" type=\"E\"").append(" column_name=\"").append(columnName).append("\" >\r\n");
			valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
			valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
			valueXmlErrorString.append("<type>E</type>\r\n");
			valueXmlErrorString.append("<option></option>\r\n");
			valueXmlErrorString.append("<time></time>\r\n");
			valueXmlErrorString.append("<alarm></alarm>\r\n");
			valueXmlErrorString.append("<source></source>\r\n");
			valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
			valueXmlErrorString.append("<redirect>1</redirect>\r\n");
			valueXmlErrorString.append("</error>\r\n");
			valueXmlErrorString.append("</Errors>\r\n");
			valueXmlErrorString.append("</Header>\r\n");
			valueXmlErrorString.append( "</Root>\r\n" );

			BaseLogger.log("0",null,null, "valueXmlErrorString : ["+ valueXmlErrorString.toString() +"]" );

			errString = valueXmlErrorString.toString();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return errString;*/
		return getErrorString( columnName, messageValue, message, errorId, "Error : NO DATA" );
		//Changed by Prasad on 13/10/2020 [created a common method for errorString] END
	}
	//Added By Prasad R on 24/11/17 for error msg [End]

	//shrutika on 28-11-17 [Start] for getting tab header data of xml for copy functionality.
	public String getXmlTag( String xmlData, String objContext, String domID )throws ITMException
	{
		StringBuffer tabSepDataBuff = new StringBuffer();
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		Node detailNode = null;
		NodeList detailNodeList = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			detailNode = searchNode( parseString( xmlData ), objContext, domID);

			if( detailNode != null && detailNode.getNodeType() == Node.ELEMENT_NODE &&  detailNode.getNodeName().startsWith( "Detail" ) )
			{
				detailNodeList = detailNode.getChildNodes();
				int detailNodeListLen = detailNodeList.getLength();

				for(int i = 0; i < detailNodeListLen; i++ )
				{
					Node childNode = detailNodeList.item(i);
					String tagVlaue = childNode.getNodeName();
					//Added By Prajyot [Check for DB_ID to omit DB_ID from tabseparated data]
					//if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE  && ! childNode.getNodeName().equalsIgnoreCase( "attribute" ) )
					if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE  && ! childNode.getNodeName().equalsIgnoreCase( "attribute" ) && ! childNode.getNodeName().equalsIgnoreCase( "DB_ID" ) )
					{
						tabSepDataBuff.append( tagVlaue );
						tagVlaue = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						if ( i > 0 && i != detailNodeListLen)
						{
							tabSepDataBuff.append("\t");
						}
					}
					childNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				}
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][ generateTabSeparatedData ]4395 :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			detailNode = null;
			detailNodeList = null;
		}
		return tabSepDataBuff.toString();


	}
	//shrutika on 28-11-17 [End] for getting tab header data of xml for copy functionality.
	//shrutika on 28-11-17 [start] for geeting tab seprated data for copy functionality.
	public String TabSeparatedDataForAllFormData( String xmlData, String objContext, String domID )throws ITMException
	{

		StringBuffer tabSepDataBuff = new StringBuffer();
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		Node detailNode = null;
		NodeList detailNodeList = null;
		NodeList detailList = null;
		//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		try
		{
			Document dom = parseString(xmlData);
			detailList = dom.getElementsByTagName("Detail" + objContext);
			int detListLength = detailList.getLength();
			int documentId = Integer.parseInt(domID);
			BaseLogger.log("3",null,null,"inside TabSeparatedDataForAllFormData domid["+domID+"]detListLength["+detListLength+"] documentId["+documentId+"]");
			for(int k=1; k<=detListLength; k++ )
			{
				domID = String.valueOf(documentId);
				detailNode = searchNode( parseString( xmlData ), objContext, domID);

				if( detailNode != null && detailNode.getNodeType() == Node.ELEMENT_NODE &&  detailNode.getNodeName().startsWith( "Detail" ) )
				{
					detailNodeList = detailNode.getChildNodes();
					int detailNodeListLen = detailNodeList.getLength();

					for(int i = 0; i < detailNodeListLen; i++ )
					{
						Node childNode = detailNodeList.item(i);
						//Added By Prajyot [Check for DB_ID to omit DB_ID from tabseparated data]
						//if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE  && ! childNode.getNodeName().equalsIgnoreCase( "attribute" ) )
						if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE  && ! childNode.getNodeName().equalsIgnoreCase( "attribute" ) && ! childNode.getNodeName().equalsIgnoreCase( "DB_ID" ) )
						{
							String nodeVal = ( ( childNode.getFirstChild() != null ) ?  childNode.getFirstChild().getNodeValue() : "" );
							tabSepDataBuff.append( nodeVal );
							nodeVal = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
							if ( i > 0 && i != detailNodeListLen)
							{
								tabSepDataBuff.append("\t");
							}
						}
						childNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
					}
				}
				documentId ++;
				tabSepDataBuff.append("\r\n");
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][ generateTabSeparatedData ]4459 :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			detailNode = null;
			detailNodeList = null;
		}
		return tabSepDataBuff.toString();

	}
	//shrutika on 28-11-17 [start] for geeting tab seprated data for copy functionality.

	//Added by Sagar B. for multiple profile id related changes[07Dec17]START
	/**
	 *
	 * @param profileID comma(,) seperated multiple profile Id's.
	 * @return the SQL <b>IN</b> formatted string to concate in sql.
	 */
	public static String getFormattedProfileId( String profileID )
	{
		StringBuffer profileIdSql = new StringBuffer();
		try
		{
			profileID = checkNull(profileID);
			BaseLogger.log("3",null,null,"@@@ getFormattedProfileId profileID:::["+profileID+"]");
			//if( profileID != null && !"null".equalsIgnoreCase(profileID) && profileID.contains(",") )
			if( profileID.length() > 0 && profileID.contains(",") )
			{
				profileIdSql.append("(");
				String[] pArr = profileID.split(",");
				for( int i = 0; i < pArr.length; i++ )
				{
					if( i == pArr.length - 1 )
					{
						profileIdSql.append("'"+pArr[i]+"'");
					}
					else
					{
						profileIdSql.append("'"+pArr[i]+"',");
					}
				}
				profileIdSql.append(")");
			}
			else
			{
				profileIdSql.append("('"+profileID+"')");
			}
			BaseLogger.log("3",null,null,"@@@ getFormattedProfileId profileIdSql:::["+profileIdSql.toString()+"]");
		}
		catch( Exception e )
		{
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getFormattedProfileId] :==>\n"+e.getMessage());
			e.printStackTrace();
		}
		return profileIdSql.toString();
	}
	//Added by Sagar B. for multiple profile id related changes[07Dec17]END

	//Added by Shrutika on 09-03-18 [start] for display prompt and warning message.
	public String isPromptOrWarningMsg( String errXmlString )
	{
		NodeList errorNodeList = null;
		String errorType ="";
		boolean isPrompt = false;
		try
		{
			if( errXmlString.indexOf( "<Errors>" ) != -1 )
			{
				errorNodeList = parseString( errXmlString ).getElementsByTagName("error");
				int errorNodeListLen = errorNodeList.getLength();
				for ( int i = 0; i < errorNodeListLen; i++)
				{
					errorType = errorNodeList.item( i ).getAttributes().getNamedItem( "type" ).getNodeValue();
					if( "P".equals( errorType ) || "W".equals( errorType ) )
					{
						isPrompt = true;
					}
				}
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}
		if(!isPrompt)
		{
			errorType= "";
		}
		BaseLogger.log("2",null,null,"inside isPromptMsg...2128 errorType["+errorType+"]");
		return errorType;

	}
	//Added by Shrutika on 09-03-18 [End] for display prompt and warning message.

	//Added by Pratheek on 22-03-18[to import error node into rootNode]-Start
	public String appendErrorXMLString(String errorXML,String detailString) throws ITMException
	{
		String retString = "";
		try
		{
			if(errorXML.length() > 0 && detailString.length() > 0 )
			{
				Document doc = parseString(errorXML);
				Node errorNode = doc.getElementsByTagName("Errors").item(0);
				Document detailDom = parseString(detailString);
				Node rootNode = detailDom.getElementsByTagName("Root").item(0);
				if(rootNode !=null)
				{
					NodeList list = rootNode.getChildNodes();
					BaseLogger.log("3",null,null,"In appendErrorXMLString method list :: 4624!!!!!!["+list.getLength()+"]");
					Node childNode = list.item(1);
					rootNode.insertBefore(detailDom.importNode(errorNode,true), childNode);
					/*Node importedNode = returnDom.importNode(errorNode,true);
				rootNode.appendChild( importedNode );*/
					BaseLogger.log("3",null,null,"child Node 4634!!!");
				}
				retString = checkNull(serializeDom(detailDom));
				BaseLogger.log("3",null,null,"In appendErrorXMLString method retString :: 4638!!!!!!["+retString.length()+"]");
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception when taking error node {"+e.getMessage()+"}");
			throw new ITMException(e);
		}
		return retString;
	}
	//Added by Pratheek on 22-03-18[to import error node into rootNode]-End

	//Added by shrutika on 26-04-18 [Start] for update header attribute value.
	public String updateDataHeader(String chgStr ,String chgAttributeValue, String chgAttributeName) throws ITMException
	{
		String returnChgStr="";
		chgStr =  checkNull(chgStr);
		if(!"".equalsIgnoreCase(chgStr))
		{
			Document doc = parseString(chgStr);
			Node headerNode = doc.getElementsByTagName("header").item(0);
			if(headerNode !=null)
			{
				NodeList detailNodeList = headerNode.getChildNodes();
				int headerNodeLen = detailNodeList.getLength();
				for ( int i = 0; i < headerNodeLen; i++)
				{
					Node curDetail = detailNodeList.item(i);
					if(chgAttributeName.equals(curDetail.getNodeName()) )
					{
						if(curDetail.getFirstChild().getNodeValue() != null)
						{
							curDetail.getFirstChild().setNodeValue(chgAttributeValue);
						}
						break;
					}
					else
					{
						continue;
					}
					//attributeValue = detailNodeList.item( i ).getAttributes().getNamedItem( "forcedSave" ).getNodeValue();
				}
			}
			returnChgStr = serializeDom(doc);
		}
		return returnChgStr;
	}
	//Added by shrutika on 26-04-18 [End] for update header attribute value.

	/**
	 * @param objName : Name of Object - like for ITEM= product, Customer= strg_customer / wsfa_strg_customer
	 * @param object : Name of Object's Folder place in <b>/ibase/resource/images/&lt;object&gt;</b>
	 * @param fldValue : This should be Tran ID / Unique ID field's value
	 * @param altFldValue : This should be Descriptive field's value
	 * @param docAttachType : This should be DOC_TYPE define in OBJ_ATTACH_CONFIG table
	 * @return
	 */
	// Added By Prajyot on 24MAY2018 [To get CustomMenuImageServlet path in same sequence] Start
	public String getCustomImageURL(String objName, String object, String fldValue, String altFldValue, String docAttachType )
	{
		StringBuffer imageURL = new StringBuffer();
		imageURL.append(CommonConstants.TOMCAT_HOME);
		imageURL.append("/ibase/CustomMenuImageServlet?");
		imageURL.append("fldValue=").append( checkNull(fldValue) );
		imageURL.append("&ALT_FLD_VALUE=").append(checkNull(altFldValue));
		imageURL.append("&objName=").append(checkNull(objName));
		imageURL.append("&object=").append(checkNull(object));
		imageURL.append("&docAttachType=").append(checkNull(docAttachType));

		BaseLogger.log("2",null,null,"E12GenericUtility.getCustomImageURL :[" +  imageURL.toString() + "]" );
		return imageURL.toString();
	}
	// Added By Prajyot on 24MAY2018 [To get CustomMenuImageServlet path in same sequence] End


	//Changes By Prajyot on 28JUN2018 [For Sysdate issue in various DATABASE (DB2, MySQL, MSSQL, ORACLE)] Start
	public static String getSysdate()
	{
		String sysdateStr = "";
		if ("db2".equalsIgnoreCase( CommonConstants.DB_NAME ) )
		{
			sysdateStr = " current timestamp ";
		}
		else if ( "mssql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
		{
			sysdateStr = " getdate() ";
		}
		else if ( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
		{
			sysdateStr = " DATE(CURRENT_TIMESTAMP) ";
		}
		else
		{
			sysdateStr = " sysdate ";
		}
		return sysdateStr;
	}
	//Changes By Prajyot on 28JUN2018 [For Sysdate issue in various DATABASE (DB2, MySQL, MSSQL, ORACLE)] End

	//Added by shrutika on 16-06-18 [Start] for apply itemchange response on current copy data.
	public Node applyItemchangeData(String itemchangeData, Node currDataDoc, String formNo, HashMap<String, String> copyDataMap, HashMap<String, String> tabOrderWiseLogicalNameMap ) throws ITMException
	{
		BaseLogger.log("2",null,null,"inside applyItemchangeData start");
		Document doc = parseString(itemchangeData);
		Document temDocument = currDataDoc.getOwnerDocument();
		Node tempNode =  temDocument.getElementsByTagName("Detail"+formNo).item(0);
		if(tempNode == null)
		{
			tempNode =  temDocument.getElementsByTagName("Detail").item(0);
		}
		int totalDetailNodes = doc.getElementsByTagName("Detail" + formNo).getLength();
		if(totalDetailNodes == 0)
		{
			totalDetailNodes = doc.getElementsByTagName("Detail").getLength();
		}
		Node currDetailNode = null;
		currDetailNode = currDataDoc;
		Node appendNode = null;
		if( totalDetailNodes > 0)
		{
			for( int j = 0 ; j < totalDetailNodes ; j++ )
			{
				Node detailNode = doc.getElementsByTagName("Detail"+formNo).item(j);

				if(detailNode == null)
				{
					detailNode = doc.getElementsByTagName("Detail").item(j);
				}
				if(detailNode !=null)
				{
					NodeList detailNodeList = detailNode.getChildNodes();
					int detailLength = detailNodeList.getLength();
					for ( int k = 0; k < detailLength; k++)
					{
						Node curitemchangeDetail = detailNodeList.item(k);

						if(curitemchangeDetail != null && curitemchangeDetail.getNodeType() == Node.ELEMENT_NODE)
						{
							appendNode = curitemchangeDetail;
							String nodename = checkNull(curitemchangeDetail.getNodeName());
							String nodeValue = checkNull(curitemchangeDetail.getTextContent());
							boolean isnodeExist = isNodeExist(nodename, formNo, currDataDoc);
							if(currDetailNode !=null && isnodeExist)
							{
								NodeList currDetailNodeList = currDetailNode.getChildNodes();
								int currDetailLength = currDetailNodeList.getLength();
								for ( int m = 0; m < currDetailLength; m++)
								{
									Node curData = currDetailNodeList.item(m);
									Node replaceNode = curData;
									String currNodename = curData.getNodeName();
									if(nodename.equalsIgnoreCase(currNodename) && !"".equalsIgnoreCase(nodeValue) && !("#text".equals(nodename) || "attribute".equalsIgnoreCase(nodename)) )
									{
										//for set value which is enter by user
										boolean iscpoyData = copyDataMap.containsKey(nodename);

										if(iscpoyData)
										{
											for ( Map.Entry<String, String> entry : copyDataMap.entrySet() )
											{
												String copyDataNodeName =  entry.getKey();
												String copyDataNodeValue = entry.getValue();
												if(nodename.equalsIgnoreCase(copyDataNodeName) && !"".equalsIgnoreCase(nodeValue)  && !"".equalsIgnoreCase(copyDataNodeValue) && tabOrderWiseLogicalNameMap.containsKey(copyDataNodeName) )
												{
													if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
													{
														replaceNode.getFirstChild().setNodeValue( copyDataNodeValue );
													}
													else
													{
														replaceNode.setTextContent( copyDataNodeValue );
													}
												}

												else
												{
													if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
													{
														replaceNode.getFirstChild().setNodeValue( nodeValue );
													}
													else
													{
														replaceNode.setTextContent( nodeValue );
													}
												}
											}
										}

										else
										{
											if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
											{
												replaceNode.getFirstChild().setNodeValue( nodeValue );
											}
											else
											{
												replaceNode.setTextContent( nodeValue );
											}
										}

										currDetailNode.replaceChild(replaceNode, curData);
										break;
									}
								}
							}

							else
							{
								if(!("#text".equals(nodename) || "attribute".equalsIgnoreCase(nodename)))
								{
									Element tempEle = temDocument.createElement(nodename);
									tempEle.appendChild(temDocument.createCDATASection(nodeValue));
									tempNode.appendChild(tempEle);
									currDetailNode = tempNode;
								}
							}
						}


					}
				}
			}
		}
		BaseLogger.log("2",null,null,"inside applyItemchangeData start["+serializeDom(currDetailNode)+"]");
		return currDetailNode;
	}
	//Added by shrutika on 16-06-18 [End] for apply itemchange response on current copy data.

	//Added by shrutika on 16-06-18 [Start] for checking node is present or not in current data.
	public boolean isNodeExist( String colName, String formNo, Node DetailNode ) throws ITMException
	{
		BaseLogger.log("2",null,null,"inside isNodeExist start");
		//E12GenericUtility genericUtility = new E12GenericUtility();
		boolean isColumn = false;
		NodeList currDetailNodeList = null;
		try
		{
			if(DetailNode != null)
			{
				currDetailNodeList = DetailNode.getChildNodes();
				int detailLength = currDetailNodeList.getLength();
				for(int i = 0;i < detailLength ; i++ )
				{
					Node childNode = currDetailNodeList.item(i);
					if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE && childNode.getNodeName().equalsIgnoreCase( colName ) )
					{
						isColumn = true;
						childNode = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
						break;
					}
				}

			}

		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [GenericUtility][getColumnValue(2)] 5057 :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
		{
			DetailNode = null;
			currDetailNodeList = null;
		}
		BaseLogger.log("2",null,null,"inside isNodeExist end isColumn["+isColumn+"]");
		return isColumn;
	}
	//Added by shrutika on 16-06-18 [End] for checking node is present or not in current data.

	//Added by shrutika on 16-06-18 [Start] for apply itemchange response on detail.
	public Document applyItemchangeDataOnDetail(String itemchangeData, Document detailDom, String formNo, String DomID,  HashMap<String, String> copyDataMap, HashMap<String, String> tabOrderWiseLogicalNameMap) throws ITMException
	{
		BaseLogger.log("2",null,null,"inside applyItemchangeDataOnDetail start.");
		Document doc = parseString(itemchangeData);
		int currDomId = Integer.parseInt(DomID);
		Document temDocument = detailDom;
		/*Node tempNode =  detailDom.getElementsByTagName("Detail"+formNo).item(currDomId - 1);
		if(tempNode == null)
		{
			tempNode =  temDocument.getElementsByTagName("Detail").item(0);
		}*/
		Node tempNode = null;

		int totalDetailNodes = doc.getElementsByTagName("Detail" + formNo).getLength();

		if(totalDetailNodes == 0)
		{
			totalDetailNodes = doc.getElementsByTagName("Detail").getLength();
		}
		int cuurtotalDetailNodes = detailDom.getElementsByTagName("Detail" + formNo).getLength();
		//Added by shrutika on 02-11-18 [Start] for getting current note [issue when delete detail then current node is not getting properly].
		for( int i = 0; i < cuurtotalDetailNodes; i++ )
		{
			Node currNode = detailDom.getElementsByTagName("Detail" + formNo).item(i);
			if( currNode != null)
			{
				String currentNewDomId = currNode.getAttributes().getNamedItem("domID").getNodeValue();
				if( currentNewDomId.equalsIgnoreCase(DomID))
				{
					tempNode = currNode;
				}

			}
		}
		//Added by shrutika on 02-11-18 [End] for getting current note [issue when delete detail then current node is not getting properly].
		Node currDetailNode = null;
		if( totalDetailNodes > 0)
		{
			for( int j = 0 ; j < totalDetailNodes ; j++ )
			{
				Node detailNode = doc.getElementsByTagName("Detail"+formNo).item(j);
				if(detailNode == null)
				{
					detailNode = doc.getElementsByTagName("Detail").item(j);
				}
				if(detailNode !=null)
				{
					NodeList detailNodeList = detailNode.getChildNodes();
					int detailLength = detailNodeList.getLength();
					for ( int k = 0; k < detailLength; k++)
					{
						Node curitemchangeDetail = detailNodeList.item(k);

						if(curitemchangeDetail != null && curitemchangeDetail.getNodeType() == Node.ELEMENT_NODE)
						{
							//Commented by Jatin M on 02-11-2023 [When we use the copy paste option on detail form it removes the leading whitespace from line_no due to checkNull() using trim() on the String] - START 
//							String nodename = checkNull(curitemchangeDetail.getNodeName());
//							String nodeValue = checkNull(curitemchangeDetail.getTextContent());
							String nodename = curitemchangeDetail.getNodeName();
							String nodeValue = curitemchangeDetail.getTextContent();
							//Commented by Jatin M on 02-11-2023 [When we use the copy paste option on detail form it removes the leading whitespace from line_no due to checkNull() using trim() on the String] - END
							if( cuurtotalDetailNodes > 0)
							{
								//(currDomId - 1) because domId starts from 1 and item starts from 0
								//Added by shrutika on 26-09-19 [Start] for issue occur when we delete all recordes and again add new records then copy paste not working.
								//currDetailNode = detailDom.getElementsByTagName("Detail"+formNo).item(currDomId - 1);
								int detilLen = detailDom.getElementsByTagName("Detail"+formNo).getLength();
								for(int i=0; i < detilLen; i++ )
								{
									if( detailDom.getElementsByTagName("Detail"+formNo).item(i).getAttributes().getNamedItem("domID") != null )
									{
										String cuurRecordDomId = checkNull(detailDom.getElementsByTagName("Detail"+formNo).item(i).getAttributes().getNamedItem("domID").getNodeValue().toString());
										BaseLogger.log("2",null,null,"inside applyItemchnageon detail.......5060["+cuurRecordDomId+"]DomID["+DomID+"]");
										if( DomID.equalsIgnoreCase(cuurRecordDomId))
										{
											currDetailNode = detailDom.getElementsByTagName("Detail"+formNo).item(i);
										}
									}
								}
								//Added by shrutika on 26-09-19 [End] for issue occur when we delete all recordes and again add new records then copy paste not working.

								boolean isnodeExist = isNodeExist(nodename, formNo, currDetailNode);
								if(currDetailNode !=null  && isnodeExist )
								{
									NodeList currDetailNodeList = currDetailNode.getChildNodes();
									int currDetailLength = currDetailNodeList.getLength();
									for ( int m = 0; m < currDetailLength; m++)
									{
										Node curData = currDetailNodeList.item(m);
										Node replaceNode = curData.cloneNode(true);
										String currNodename = curData.getNodeName();
										if(nodename.equalsIgnoreCase(currNodename) && !"".equalsIgnoreCase(nodeValue) && !("#text".equals(nodename) || "attribute".equalsIgnoreCase(nodename)))
										{
											//for set value which is enter by user
											boolean iscpoyData = copyDataMap.containsKey(nodename);

											if(iscpoyData)
											{
												for ( Map.Entry<String, String> entry : copyDataMap.entrySet() )
												{
													String copyDataNodeName =  entry.getKey();
													String copyDataNodeValue = entry.getValue();
													if(nodename.equalsIgnoreCase(copyDataNodeName) && !"".equalsIgnoreCase(nodeValue) && tabOrderWiseLogicalNameMap.containsKey(copyDataNodeName))
													{

														if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
														{
															replaceNode.getFirstChild().setNodeValue( copyDataNodeValue );
														}
														else
														{
															replaceNode.setTextContent( copyDataNodeValue );
														}
													}
													else
													{

														if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
														{
															replaceNode.getFirstChild().setNodeValue( nodeValue );
														}
														else
														{
															replaceNode.setTextContent( nodeValue );
														}
													}
												}
											}

											else
											{

												if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
												{
													replaceNode.getFirstChild().setNodeValue( nodeValue );
												}
												else
												{
													replaceNode.setTextContent( nodeValue );
												}
											}
											currDetailNode.replaceChild(replaceNode, curData);
											break;
										}
									}
								}

								else
								{
									if(!("#text".equals(nodename) || "attribute".equalsIgnoreCase(nodename)))
									{
										Element tempEle = temDocument.createElement(nodename);
										tempEle.appendChild(temDocument.createCDATASection(nodeValue));
										tempNode.appendChild(tempEle);

										currDetailNode = tempNode;
									}
								}

							}
						}

					}
				}
			}
		}
		BaseLogger.log("2",null,null,"inside applyItemchangeDataOnDetail end["+serializeDom(detailDom)+"]");
		return detailDom;
	}
	//Added by shrutika on 16-06-18 [End] for apply itemchange response on detail.

	//Added by shrutika on 16-06-18 [Start] for apply copy data on blank xml.
	public Node copyDataOnBalnkDom(String copyData, String blankDomData, String childObjCtx, HashMap<String, String> copyDataMap, HashMap<String, String>  tabOrderWiseLogicalNameMap, ArrayList primaryKeyMap) throws ITMException
	{
		BaseLogger.log("2",null,null,"inside copyDataOnBalnkDom start");
		Document blankDataDom = parseString(blankDomData);
		int totalNode = blankDataDom.getElementsByTagName("Detail"+childObjCtx).getLength();
		Node detailNode = null;
		Document copyDataDom = parseString(copyData);
		int totalCopyData = copyDataDom.getElementsByTagName("Detail"+childObjCtx).getLength();

		Node appendNode = null;
		if(totalNode > 0)
		{
			for( int i = 0 ; i < totalNode ; i++ )
			{
				detailNode = blankDataDom.getElementsByTagName("Detail"+childObjCtx).item(i);
				if(detailNode !=null)
				{
					NodeList detailNodeList = detailNode.getChildNodes();
					int detailLength = detailNodeList.getLength();
					for ( int k = 0; k < detailLength; k++)
					{
						Node cuurentBlnkDetail = detailNodeList.item(k);
						appendNode = cuurentBlnkDetail;
						if(cuurentBlnkDetail != null && cuurentBlnkDetail.getNodeType() == Node.ELEMENT_NODE)
						{
							String nodename = checkNull(cuurentBlnkDetail.getNodeName());
							String nodeValue = checkNull(cuurentBlnkDetail.getTextContent());
							for( int j = 0 ; j < totalCopyData ; j++ )
							{
								Node copyDetailNode = copyDataDom.getElementsByTagName("Detail"+childObjCtx).item(j);
								NodeList copyDeatiNodeList = copyDetailNode.getChildNodes();
								int copyDetailLen = copyDeatiNodeList.getLength();
								for ( int l = 0; l < copyDetailLen; l++)
								{
									Node currCopyDetail = copyDeatiNodeList.item(l);
									if(currCopyDetail != null && currCopyDetail.getNodeType() == Node.ELEMENT_NODE)
									{
										String curCopyNodeName = checkNull(currCopyDetail.getNodeName());
										String curCopyNodeValue = checkNull(currCopyDetail.getTextContent());
										if((nodename.equalsIgnoreCase(curCopyNodeName) && tabOrderWiseLogicalNameMap.containsKey(curCopyNodeName) && !"".equalsIgnoreCase(curCopyNodeValue)) ||(!"".equalsIgnoreCase(curCopyNodeName) && primaryKeyMap.contains(curCopyNodeName) && nodename.equalsIgnoreCase(curCopyNodeName)) )
										{
											if(cuurentBlnkDetail.getFirstChild() != null && cuurentBlnkDetail.getFirstChild().getNodeValue() != null)
											{
												cuurentBlnkDetail.getFirstChild().setNodeValue( curCopyNodeValue );
											}
											else
											{
												cuurentBlnkDetail.setTextContent( curCopyNodeValue );
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		BaseLogger.log("2",null,null,"inside copyDataOnBalnkDom end["+serializeDom(detailNode)+"]");
		return detailNode;
	}
	//Added by shrutika on 16-06-18 [Start] for apply copy data on blank xml.

	//Added by Prasad on 20/07/18 [creating method for get value from json and update value in json] START
	public String getValueFromJson( JSONObject responseJson, String tagNamePath, String tagName ) throws ITMException
	{
		String jsonValue = null;
		try
		{
			ArrayList<String> tagNamePathList = new ArrayList<String>( Arrays.asList( tagNamePath.split( "\\s*:\\s*" ) ) );
			int tagNamePathListSize = tagNamePathList.size();
			JSONObject childJson = responseJson;
			for ( int childCnt = 0; childCnt < tagNamePathListSize; childCnt++ )
			{
				childJson = childJson.getJSONObject( tagNamePathList.get( childCnt ) );
			}
			jsonValue = (String) childJson.get( tagName );
		}
		catch (JSONException e)
		{
			BaseLogger.log("0",null,null, "getValueFromJson : ["+ e.getMessage() +"]" );
			e.printStackTrace();
			throw new ITMException( e );
		}
		return jsonValue;
	}

	public void updateValueInJson( JSONObject responseJson, String tagNamePath, String tagName, String updateValue ) throws ITMException
	{
		try
		{
			ArrayList<String> tagNamePathList = new ArrayList<String>( Arrays.asList( tagNamePath.split( "\\s*:\\s*" ) ) );
			int tagNamePathListSize = tagNamePathList.size();
			JSONObject childJson = responseJson;
			for ( int childCnt = 0; childCnt < tagNamePathListSize; childCnt++ )
			{
				childJson = childJson.getJSONObject( tagNamePathList.get( childCnt ) );
			}
			childJson.put( tagName, updateValue );
		}
		catch (JSONException e)
		{
			BaseLogger.log("0",null,null, "updateValueInJson : ["+ e.getMessage() +"]" );
			e.printStackTrace();
			throw new ITMException( e );
		}
	}
	//Added by Prasad on 20/07/18 [creating method for get value from json and update value in json] END

	public String getErrorString( String response )
	{
		String errorStr = "";
		String msgStr = "";
		String descrStr = "";
		String traceStr = "";
		try
		{
			Document document = parseString(response);
			if( document != null )
			{
				Node errorNode = document.getElementsByTagName("error").item(0);
				if( errorNode != null && errorNode.getNodeType() == Node.ELEMENT_NODE  )
				{
					BaseLogger.log("2",null,null,"errorNode:["+serializeDom(errorNode)+"]");
					NodeList childNodeList = errorNode.getChildNodes();
					int len = childNodeList.getLength();
					for ( int i = 0; i < len; i++ )
					{
						Node childNode = childNodeList.item(i);
						if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE )
						{
							String nodeName = checkNull( childNode.getNodeName() );
							BaseLogger.log("3",null,null,"NodeName:["+nodeName+"]");
							String nodeValue = "";
							if( childNode.getFirstChild() !=  null && childNode.getFirstChild().getNodeValue() != null )
							{
								nodeValue = childNode.getFirstChild().getNodeValue();
							}
							BaseLogger.log("3",null,null,"NodeValue:["+nodeValue+"]");
							if( "message".equals(nodeName) )
							{
								msgStr = nodeValue;
							}
							else if( "description".equals(nodeName) )
							{
								descrStr = nodeValue;
							}
							else if( "trace".equals(nodeName) )
							{
								traceStr = nodeValue;
							}
						}
					}
				}
				errorStr = msgStr + " " + descrStr + " " + traceStr;
			}
		}
		catch (ITMException e)
		{
			BaseLogger.log("0",null,null,"E12GenericUtility getErrorString():["+e+"]");
			e.printStackTrace();
		}
		return errorStr;
	}

	//Added By Pankaj T. on 27-07-18 for apply postsavedata on detailDom - start
	public Document applyPostSaveDataOnDetail( String postSaveData, Document detailDom, int noOfForms ) throws ITMException
	{
		BaseLogger.log("2",null,null,"Inside applyPostSaveDataOnDetail noOfForms:["+noOfForms+"]");
		BaseLogger.log("2",null,null,"Inside applyPostSaveDataOnDetail postSaveData:["+postSaveData+"]");
		postSaveData = checkNull(postSaveData);
		if( postSaveData.length() > 0 )
		{
			BaseLogger.log("3",null,null,"Inside applyPostSaveDataOnDetail detailDom before update:["+serializeDom(detailDom)+"]");
			try
			{
				Document postSavedocument = parseString(postSaveData);
				Document temDocument = detailDom;
				for( int i = 1; i <= noOfForms; i++ )
				{
					if( postSavedocument != null )
					{
						NodeList nodeList =  postSavedocument.getElementsByTagName("Detail"+i);
						int len = nodeList.getLength();
						if( len > 0 )
						{
							for( int j = 0; j < len; j++ )
							{
								Node detailNode = nodeList.item(j);
								if( detailNode != null && detailNode.getNodeType() == Node.ELEMENT_NODE )
								{
									String domID = "";
									if( i == 1 )
									{
										domID = "1";
									}
									else if( detailNode.getAttributes() != null && detailNode.getAttributes().getNamedItem("domID") != null )
									{
										domID = checkNull(detailNode.getAttributes().getNamedItem("domID").getNodeValue().toString());
									}
									BaseLogger.log("3",null,null,"domID:["+domID+"]");
									NodeList detailNodeList = detailNode.getChildNodes();
									int detailNodeListLen = detailNodeList.getLength();
									for( int k = 0; k < detailNodeListLen; k++ )
									{
										Node childNode = detailNodeList.item(k);
										if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE )
										{
											String nodeName = checkNull(childNode.getNodeName());
											BaseLogger.log("3",null,null,"NodeName:["+nodeName+"]");
											if( !("#text".equals(nodeName) || "attribute".equalsIgnoreCase(nodeName)))
											{
												String nodeValue = "";
												if( childNode != null && childNode.getFirstChild() != null )
												{
													nodeValue = checkNull(childNode.getFirstChild().getNodeValue());
												}
												NodeList currDetailNodeList = detailDom.getElementsByTagName("Detail"+i);
												int currDetailListLen = currDetailNodeList.getLength();
												for( int l = 0; l < currDetailListLen; l++ )
												{
													Node currDetailNode = currDetailNodeList.item(l);
													Node tempNode = currDetailNode;
													String currDomID = "";
													if( currDetailNode != null && currDetailNode.getNodeType() == Node.ELEMENT_NODE )
													{
														if( currDetailNode.getAttributes() != null && currDetailNode.getAttributes().getNamedItem("domID") != null )
														{
															currDomID = checkNull(currDetailNode.getAttributes().getNamedItem("domID").getNodeValue().toString());
														}
														BaseLogger.log("3",null,null,"currDomID:["+currDomID+"]");
														if( domID.equals(currDomID) )
														{
															boolean isNodeExist = isNodeExist(nodeName, "", currDetailNode);
															if(currDetailNode !=null  && isNodeExist )
															{
																NodeList currDetailChildNodeList = currDetailNode.getChildNodes();
																int currDetailLength = currDetailChildNodeList.getLength();
																for ( int m = 0; m < currDetailLength; m++)
																{
																	Node currChildNode = currDetailChildNodeList.item(m);
																	Node replaceNode = currChildNode.cloneNode(true);
																	String currNodeName = checkNull(currChildNode.getNodeName());
																	BaseLogger.log("3",null,null,"CurrNodeName:["+nodeName+"]");
																	if(nodeName.equalsIgnoreCase(currNodeName) && !("#text".equals(nodeName) || "attribute".equalsIgnoreCase(nodeName)))
																	{
																		BaseLogger.log("3",null,null,"New NodeValue:["+nodeValue+"]");
																		String currNodeValue = "";
																		if( currChildNode != null && currChildNode.getFirstChild() != null )
																		{
																			currNodeValue = checkNull(currChildNode.getFirstChild().getNodeValue());
																		}
																		BaseLogger.log("3",null,null,"Old NodeValue:["+currNodeValue+"]");
																		if(replaceNode.getFirstChild() != null && replaceNode.getFirstChild() != null && replaceNode.getFirstChild().getNodeValue() != null)
																		{
																			replaceNode.getFirstChild().setNodeValue( nodeValue );
																		}
																		else
																		{
																			replaceNode.setTextContent( nodeValue );
																		}
																		currDetailNode.replaceChild(replaceNode, currChildNode);
																		break;
																	}
																}
															}
															else
															{
																if(!("#text".equals(nodeName) || "attribute".equalsIgnoreCase(nodeName)))
																{
																	Element tempEle = temDocument.createElement(nodeName);
																	tempEle.appendChild(temDocument.createCDATASection(nodeValue));
																	tempNode.appendChild(tempEle);
																	currDetailNode = tempNode;
																}
															}
														}
													}
													else
													{
														BaseLogger.log("3",null,null,"DomId not match");
														continue;
													}
												}
											}
										}
									}
								}
							}
						}
						else
						{
							continue;
						}
					}
				}
			}
			catch (Exception e)
			{
				BaseLogger.log("0",null,null,"Exception in applyPostSaveDataOnDetail:["+e+"]");
				e.printStackTrace();
				throw new ITMException(e);
			}
			BaseLogger.log("3",null,null,"Inside applyPostSaveDataOnDetail end updated detailDom:["+serializeDom(detailDom)+"]");
		}
		return detailDom;
	}
	//Added By Pankaj T. on 27-07-18 for apply postsavedata on detailDom - end

	//Changed by Prasad on 13/10/2020 [created a common method for errorString] START
	public String getErrorString( String columnName, String msgDescr, String message, String msgNo, String trace )
	{
		return getErrorString( msgNo, "", columnName, message, msgDescr, trace, "", "", "", "", "" );
	}

	public String getErrorString( String msgNo, String msgType, String columnName, String message, String msgDescr, String trace )
	{
		return getErrorString( msgNo, msgType, columnName, message, msgDescr, trace, "", "", "", "", "" );
	}

	public String getErrorString( String msgNo, String msgType, String columnName, String message, String msgDescr, String trace, String msgOption, String msgTime, String soundPlay, String errSource, String redirErr )
	{
		String errString = "";
		try
		{
			columnName = checkNull( columnName );
			if ( columnName.length() == 0 )
			{
				columnName = "description";
			}
			msgType = checkNull( msgType );
			if ( msgType.length() == 0 )
			{
				msgType = "E";
			}
			msgOption = checkNull( msgOption );
			msgTime = checkNull( msgTime );
			soundPlay = checkNull( soundPlay );
			errSource = checkNull( errSource );
			redirErr = checkNull( redirErr );
			if ( redirErr.length() == 0 )
			{
				redirErr = "1";
			}

			StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Errors>\r\n" );
			valueXmlErrorString.append("<error id=\"").append( msgNo ).append("\" type=\"").append( msgType ).append("\" column_name=\"").append( columnName ).append("\" >\r\n");
			valueXmlErrorString.append("<message><![CDATA[").append( message ).append("]]></message>\r\n");
			valueXmlErrorString.append("<description><![CDATA[").append( msgDescr ).append("]]></description>\r\n");
			valueXmlErrorString.append("<type><![CDATA[").append( msgType ).append("]]></type>\r\n");
			if ( msgOption.length() > 0 )
			{
				valueXmlErrorString.append("<option><![CDATA[").append( msgOption ).append("]]></option>\r\n");
			}
			if ( msgTime.length() > 0 )
			{
				valueXmlErrorString.append("<time><![CDATA[").append( msgTime ).append("]]></time>\r\n");
			}
			if ( soundPlay.length() > 0 )
			{
				valueXmlErrorString.append("<alarm><![CDATA[").append( soundPlay ).append("]]></alarm>\r\n");
			}
			if ( errSource.length() > 0 )
			{
				valueXmlErrorString.append("<source><![CDATA[").append( errSource ).append("]]></source>\r\n");
			}
			valueXmlErrorString.append("<trace><![CDATA[").append( trace ).append("]]></trace>\r\n");
			valueXmlErrorString.append("<redirect><![CDATA[").append( redirErr ).append("]]></redirect>\r\n");
			valueXmlErrorString.append("</error>\r\n");
			valueXmlErrorString.append("</Errors>\r\n");
			valueXmlErrorString.append("</Root>");

			errString = valueXmlErrorString.toString();
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		BaseLogger.log( "3", null, null, "getErrorString :: errString : ["+ errString +"]" );
		return errString;
	}
	//Changed by Prasad on 13/10/2020 [created a common method for errorString] END

	/**
	 * Build a stack trace string from given exception object.
	 *
	 * @param ex The exception object.
	 *
	 * @return The stack trace.
	 */
	public static String getStackTrace(Exception ex)
	{
		StringBuilder sb = new StringBuilder();

		StackTraceElement[] elements = ex.getStackTrace();
		sb.append(ex.getClass().getSimpleName() + " : " + ex.getMessage() + "\n");

		for (StackTraceElement element : elements)
			sb.append("\nat " + element.toString());

		return sb.toString();
	}

	public static String getStackTrace(Throwable ex)
	{
		StringBuilder sb = new StringBuilder();

		StackTraceElement[] elements = ex.getStackTrace();
		sb.append(ex.getClass().getSimpleName() + " : " + ex.getMessage() + "\n");

		for (StackTraceElement element : elements)
			sb.append("\nat " + element.toString());

		return sb.toString();
	}
	//added by Sainath T. on 19/09/2018-start[For Camel case]
	/**
	 *
	 * @param inputStr
	 * @return
	 */
	public String getCamelCaseStr( String inputStr )
	{
		StringBuilder camelCaseStr = new StringBuilder( inputStr );
		// Flag to keep track if last visited character is a
		// white space or not
		boolean isLastSpace = true;

		// Iterate String from beginning to end.
		for( int i = 0; i < camelCaseStr.length(); i++ )
		{
			char ch = camelCaseStr.charAt( i );

			if(isLastSpace && ch >= 'a' && ch <='z')
			{
				// Character need to be converted to uppercase
				camelCaseStr.setCharAt(i, ( char )( ch + ( 'A' - 'a' ) ));
				isLastSpace = false;
			}
			else if (ch != ' ')
			{
				isLastSpace = false;
			}
			else
			{
				isLastSpace = true;
			}
		}
		return camelCaseStr.toString();
	}
	//added by Sainath T. on 19/09/2018-end[For Camel case]
	//added by Sainath T. on 24/10/2018[ To check JSONObject is NULL]-START
	public static String checkJsonObjectNull( Object input )
	{
		if( !JSONObject.NULL.equals( input ))
		{
			return input.toString();
		}
		return "";
	}
	//added by Sainath T. on 24/10/2018[ To check JSONObject is NULL]-END
	//added by Sainath T. on 15/11/2018[ To get error from xml to json string ] -START
	public String getErrorXmlToJsonString(String errCode, String messageType, String errMsg, String errorDescr,String errorTrace)
	{
		String gException="";
		try
		{
			JSONObject errorDataJson = new JSONObject();
			errorDataJson.put( "@id", errCode );
			errorDataJson.put( "@type", messageType );
			errorDataJson.put( "message", errMsg );
			errorDataJson.put( "description", errorDescr );
			errorDataJson.put( "type", messageType );
			errorDataJson.put( "trace", errorTrace );

			JSONObject resultJson = new JSONObject();
			resultJson.put( "error", errorDataJson );

			JSONObject detailJson = new JSONObject();
			detailJson.put("Errors", resultJson);

			JSONObject responseJson = new JSONObject();
			responseJson.put( "Root", detailJson );

			gException = responseJson.toString();
		}
		catch (JSONException e)
		{
			e.printStackTrace();
		}
		return gException;
	}
	//added by Sainath T. on 15/11/2018[ To get error from xml to json string ] -END

	//added by Sainath T. on 15/11/2018[ To remove empty nodes ] -START
	public Document removeEmptyNode( Document newDomAdd )
	{
		String inputXML ="";
		Document validDom = null;
		try
		{
			inputXML = serializeDom( newDomAdd );
			Pattern emptyValueTag = Pattern.compile("\\s*<\\w+/>");
			Pattern emptyTagMultiLine = Pattern.compile("\\s*<\\w+>\n*\\s*</\\w+>");

			inputXML = emptyValueTag.matcher(inputXML).replaceAll("");

			while (inputXML.length() != ( inputXML = emptyTagMultiLine.matcher( inputXML ).replaceAll( "" )).length()){}
			validDom = parseString( inputXML );
		}
		catch ( ITMException e )
		{
			e.printStackTrace();
		}
		return validDom;
	}
	//added by Sainath T. on 15/11/2018[ To remove empty nodes ] -START

	// Added by Abhishek T on 06-Dec-2018 START
	/**
	 * Copy the content of source <source>InputStream</source> into the target <source>OutputStream</source>
	 * and return the total bytes processed.<br/>
	 * <b>Note: This method does not close any of both streams</b>
	 * 
	 * @param source The source InputStream object
	 * @param target The target OutputStream object
	 * 
	 * @return The number of total bytes processed
	 * 
	 * @throws IOException If the first byte cannot be read for any
	 * 					   reason other than the end of the file,
	 * 					   if the input stream has been closed,
	 * 					   or if some other I/O error occurs.
	 * @throws NullPointerException If either source or target is null
	 */
	public static long copy(InputStream source, OutputStream target)
			throws IOException, NullPointerException {

		if (source == null || target == null) {
			throw new NullPointerException("Either source or target is null");
		}

		byte[] buffer = new byte[4096];
		int readed = -1;
		long total = 0L;

		while (-1 != (readed = source.read(buffer))) {
			target.write(buffer, 0, readed);
			total += readed;
		}

		return total;
	}
	// Added by Abhishek T on 06-Dec-2018 END

	// Added by Abhishek T on 15-Dec-2018 START
	/**
	 * Reads the given InputStream object and return the content as bytes
	 * 
	 * @param is The InputStream object
	 * 
	 * @return The content of given input stream as byte array
	 * 
	 * @throws IOException If any I/O exception occurred, like input stream has been closed etc.
	 * @throws NullPointerException If InputStream object is null.
	 */
	public static byte[] readStreamAsBytes(InputStream is)
			throws IOException {
		OutputStream os = new ByteArrayOutputStream();

		byte[] buffer = new byte[1024];
		int readed = -1;

		while ((readed = is.read(buffer)) != -1) {
			os.write(buffer, 0, readed);
		}

		return ((ByteArrayOutputStream) os).toByteArray();
	}

	/**
	 * Reads the input stream as string
	 * 
	 * @param is InputStram object
	 * @return Input stream data as string
	 * 
	 * @throws IOException If any I/O exception occurred, like input stream has been closed etc.
	 */
	public static String readStreamAsString(InputStream is)
			throws IOException {
		return new String(readStreamAsBytes(is));
	}

	/**
	 * Calls the given url using HttpURLConnection, and return the response as byte array. 
	 * 
	 * @param url The url.
	 * @param postDataInputStream Data to send in request (post data), if any
	 * 
	 * @return The response as byte array
	 * @throws IOException 
	 */
	public static byte[] makeRequest(String url, InputStream postDataInputStream)
			throws IOException {
		return makeRequest(url, postDataInputStream, 0);
	}

	/**
	 * Calls the given url using HttpURLConnection, and return the response as byte array. 
	 * 
	 * @param url The url.
	 * @param postDataInputStream Data to send in request (post data), if any
	 * @param readTimeout The maximum response read timeout
	 * 
	 * @return The response as byte array
	 * @throws IOException 
	 */
	public static byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout)
			throws IOException {
		byte[] result = new byte[0];

		URL serviceURL = new URL(url);
		HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
		if (readTimeout > 0) {
			httpConnection.setReadTimeout(2000);
		}

		httpConnection.setRequestMethod("GET");
		httpConnection.setDoOutput(true);
		httpConnection.setDoInput(true);
		httpConnection.setUseCaches(false);

		if (postDataInputStream != null) {
			httpConnection.setRequestMethod("POST");
			httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			httpConnection.setRequestProperty("charset", "UTF-8");
			httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));

			OutputStream connectionOutputStream = httpConnection.getOutputStream();
			E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
		}

		httpConnection.connect();

		InputStream responseStream = httpConnection.getInputStream();
		result = E12GenericUtility.readStreamAsBytes(responseStream);

		return result;
	}

	/**
	 * Send a multipart request to a given endpoint
	 *  
	 * @param endPoint The endpoint url (with query string parameters, if any)
	 * @param files File(s) to send in request body
	 * 
	 * @return The response as a byte array
	 * 
	 * @throws ClientProtocolException
	 * @throws IOException
	 */
	public static byte[] makeMultipartRequest(String endPoint, File ... files)
			throws ClientProtocolException, IOException {

		CloseableHttpClient httpClient = HttpClients.createDefault();
		HttpPost httpPost = new HttpPost(endPoint);

		// multi part payload builder
		MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();

		// adding file one by one in multipart body
		int totalFiles = 0;
		for (int i = 0; i < files.length; i++) {
			File file = files[i];

			if (file != null && file.exists()) {
				FileBody fileBody = new FileBody(file);
				multipartEntityBuilder.addPart(String.format("file_%s", i), fileBody);
				totalFiles++;
			}
		}

		// total file count in multipart body
		// if file names are in pattern file_0, file_1 .. file_n
		// then "totalFiles = n"
		multipartEntityBuilder.addTextBody("totalFiles", String.valueOf(totalFiles));

		// building body and setting into post request
		HttpEntity httpEntity = multipartEntityBuilder.build();
		httpPost.setEntity(httpEntity);

		// sending post request
		CloseableHttpResponse closeableHttpResponse = httpClient.execute(httpPost);
		HttpEntity response = closeableHttpResponse.getEntity();

		InputStream responseInputStream = response.getContent();

		byte[] responseBytes = readStreamAsBytes(responseInputStream);

		try {
			responseInputStream.close();
			closeableHttpResponse.close();
			httpClient.close();
		} catch (Exception ex) {
			System.err.println(ex);
		}

		return responseBytes;
	}

	/**
	 * Calls the given url using HttpURLConnection, and return the response as byte array. 
	 * 
	 * @param url The url.
	 * @param postDataInputStream Data to send in request (post data), if any
	 * @param readTimeout The maximum response read timeout
	 * @param sessionId set sessionid in cookie
	 * @param contentType Pass dynamic contentType in header 
	 * 
	 * @return The response as byte array
	 * @throws IOException 
	 */
	public static byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout, String sessionID, String contentType)
			throws IOException {
		byte[] result = new byte[0];

		URL serviceURL = new URL(url);
		HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
		if (readTimeout > 0) {
			httpConnection.setReadTimeout(2000);
		}

		httpConnection.setRequestMethod("GET");
		httpConnection.setDoOutput(true);
		httpConnection.setDoInput(true);
		httpConnection.setUseCaches(false);

		if (postDataInputStream != null) {
			httpConnection.setRequestMethod("POST");
			if( contentType == null )
			{
				httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			}
			else
			{
				httpConnection.setRequestProperty("Content-Type", contentType);
			}
			httpConnection.setRequestProperty("charset", "UTF-8");
			httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));

			OutputStream connectionOutputStream = httpConnection.getOutputStream();
			E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
		}

		httpConnection.connect();

		InputStream responseStream = httpConnection.getInputStream();
		result = E12GenericUtility.readStreamAsBytes(responseStream);

		return result;
	}

	/**
	 * Build query string from given Map
	 * 
	 * @param queryParamters A java.util.Map object containing key and value
	 * 
	 * @return Generated query string
	 * 
	 * @throws UnsupportedEncodingException, If the named encoding (UTF-8) is not supported.
	 */
	public static String buildQueryString(Map<String, String> queryParamters)
			throws UnsupportedEncodingException {

		if (queryParamters == null || queryParamters.size() == 0) {
			return "";
		}

		Set<String> keys = queryParamters.keySet();

		String queryString = "";

		for (String key: keys) {
			String value = queryParamters.get(key);
			queryString += URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8") + "&";
		}

		return queryString;
	}
	// Added by Abhishek T on 15-Dec-2018 END

	//Added by shrutika on 20-12-18 [Start] for perform itemchange one by one field in copy paste functionality.
	public Node applyValueOnParentNode(String nodeName, String value, Node parentNode, String formNo, Document detailDom) throws ITMException
	{
		try
		{
			Node currDetailNode = parentNode;
			Node appendNode = null;
			if(currDetailNode != null && currDetailNode.getNodeType() == Node.ELEMENT_NODE)
			{
				NodeList subChildList = currDetailNode.getChildNodes();
				int totalDetailNodes = subChildList.getLength();
				if( totalDetailNodes > 0)
				{
					for( int j = 0 ; j < totalDetailNodes ; j++ )
					{
						appendNode = subChildList.item(j);
						if(appendNode != null && appendNode.getNodeType() == Node.ELEMENT_NODE)
						{
							String currNodeName = appendNode.getNodeName();
							if(currNodeName.equalsIgnoreCase(nodeName))
							{
								if ( appendNode.getFirstChild() != null &&  appendNode.getFirstChild().getNodeValue() != null)
								{
									appendNode.getFirstChild().setNodeValue( value );
									break;
								}
								else
								{
									CDATASection cDataSection = detailDom.createCDATASection(value);
									appendNode.appendChild(cDataSection);
									break;
								}
							}
						}
					}
				}
			}
			return currDetailNode;
		}
		catch (DOMException e)
		{
			// TODO Auto-generated catch block
			BaseLogger.log("0", null, null,"Exception in applyVlaue["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return null;
	}

	public void seteditableListMap(String itemchangeString, String formNo) throws ITMException
	{
		Document itemchangrespDom = parseString(itemchangeString);
		NodeList newDetailList = itemchangrespDom.getElementsByTagName("Detail" + formNo);
		for ( int k = 0; k < newDetailList.getLength(); k++)
		{
			Node currentDetail = newDetailList.item(k);
			if(currentDetail != null && currentDetail.getNodeType() == Node.ELEMENT_NODE)
			{
				NodeList childNodeList = currentDetail.getChildNodes();
				for( int i=0; i<=childNodeList.getLength(); i++)
				{
					Node currChildNode = childNodeList.item(i);
					if(currChildNode != null && currChildNode.getNodeType() == Node.ELEMENT_NODE)
					{
						String nodeName = checkNull(currChildNode.getNodeName());
						if(currChildNode.hasAttributes())
						{
							String value = currChildNode.getAttributes().getNamedItem("protect").getNodeValue();
							editableListMap.put(nodeName, value);
						}
					}
				}
			}
		}
	}
	//Added by shrutika on 20-12-18 [End] for perform itemchange one by one field in copy paste functionality.

	//Added By Pankaj T. on 24-01-19 for Prevent to change value of transetup column confirm_col,site_acc_col,emp_acc_col,cust_acc_col,supp_acc_col and sales_pers_acc_col if defined and match entity type - start
	public String checkConsistency( String headerString, UserInfoBean userInfo, String editorId, String objName, String formNo, String objType, TreeMap<String, String> argumentMap ) throws ITMException
	{
		BaseLogger.log("2", userInfo, editorId,"E12GenericUtility.checkConsistency() start");
		String responseStr = null;
		Boolean isValidate = false;  
		Document headerDom = null;
		Connection connection = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String confirm_col = null;
		String confirm_val = null;
		String site_acc_col = null;
		String emp_acc_col = null;
		String cust_acc_col = null;
		String supp_acc_col = null;
		String sales_pers_acc_col = null;
		try 
		{
			formNo = checkNull(formNo);
			objType = checkNull(objType);
			headerString = checkNull(headerString);
			BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() formNo:["+formNo+"]");
			BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() objType:["+objType+"]");
			BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() objName:["+objName+"]");
			if( formNo.length() > 0 && "1".equals(formNo) && ( (("T".equals(objType) || "P".equals(objType) || "W".equals(objType)) && headerString.length() > 0 && headerString.contains("Detail1")) || ("R".equals(objType) && argumentMap != null) ) )
			{
				headerDom = parseString(headerString);
				String userId = userInfo.getLoginCode();
				String userLevel = checkNull(userInfo.getUserLevel());
				String transDB = userInfo.getTransDB();
				String siteCode = checkNull(userInfo.getSiteCode());
				String entityType = checkNull(userInfo.getUserType());
				String entityCode = checkNull(userInfo.getEntityCode());
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() userId:["+userId+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() userLevel:["+userLevel+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() transDB:["+transDB+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() siteCode:["+siteCode+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() entityType:["+entityType+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() entityCode:["+entityCode+"]");
				ConnDriver connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(transDB);
				String sql = "SELECT CONFIRM_COL, CONFIRM_VAL, EMP_ACC_COL, SITE_ACC_COL, CUST_ACC_COL, SUPP_ACC_COL, SALES_PERS_ACC_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + objName+"'";
				pstmt = connection.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					confirm_col = checkNull(rs.getString( "CONFIRM_COL" ));
					confirm_val = checkNull(rs.getString( "CONFIRM_VAL" ));
					emp_acc_col = checkNull(rs.getString( "EMP_ACC_COL" ));
					site_acc_col = checkNull(rs.getString( "SITE_ACC_COL" ));
					cust_acc_col = checkNull(rs.getString( "CUST_ACC_COL" ));
					supp_acc_col = checkNull(rs.getString( "SUPP_ACC_COL" ));
					sales_pers_acc_col = checkNull(rs.getString( "SALES_PERS_ACC_COL" ));
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( connection != null )
				{
					connection.close();
					connection = null;
				}
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() confirm_col:["+confirm_col+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() confirm_val:["+confirm_val+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() emp_acc_col:["+emp_acc_col+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() site_acc_col:["+site_acc_col+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() cust_acc_col:["+cust_acc_col+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() supp_acc_col:["+supp_acc_col+"]");
				BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() sales_pers_acc_col:["+sales_pers_acc_col+"]");
				if( confirm_col != null && confirm_val != null && !"".equals(confirm_col) && !"".equals(confirm_val) )
				{
					String confirmColVal = "";
					if( "R".equals(objType) )
					{
						confirmColVal = checkNull(argumentMap.get(confirm_col.toLowerCase()));
						isValidate = true;
					}
					else if( "T".equals(objType) || "P".equals(objType) || "W".equals(objType) )
					{
						Node confrimNode = headerDom.getElementsByTagName(confirm_col.toLowerCase()).item(0);
						if( confrimNode != null && confrimNode.getNodeType() == Node.ELEMENT_NODE && confrimNode.getFirstChild() != null )
						{
							confirmColVal = checkNull(confrimNode.getFirstChild().getNodeValue());
							isValidate = true;
						}
					}
					BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() confirmColVal:["+confirmColVal+"]");
					if( isValidate && confirm_val.equals(confirmColVal) )
					{
						responseStr = getErrorString(confirm_col, "VTINVTDATA", userId);
						//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
						writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", confirm_col, confirmColVal, confirm_val, "Non editable column ( "+ confirm_col +" ) value is mismatch" );
						return responseStr = updateXMLString("trace", "Non editable column ( "+ confirm_col +" ) value is mismatch", responseStr, userInfo);
					}
					else
					{
						isValidate = false;
					}
				}
				if( site_acc_col != null && !"".equals(site_acc_col) && !("0".equals(userLevel) || "1".equals(userLevel)) )
				{
					String siteAccColVal = "";
					if( "R".equals(objType) )
					{
						//siteAccColVal = argumentMap.get(site_acc_col.toLowerCase());
						//Added By Pankaj T. on 29-01-19 validate sites from user_site against userId - start
						boolean result = validateSites(userInfo, argumentMap, site_acc_col);
						if(!result)
						{
							responseStr = getErrorString(site_acc_col, "VTINVTDATA", userId);
							//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder - start
							String siteCodes = argumentMap.get(site_acc_col.toLowerCase());
							if( siteCodes != null && siteCodes.indexOf(".") != -1 )
							{
								siteCodes = siteCodes.substring(siteCodes.indexOf(".")+1);
							}
							writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", site_acc_col, siteCode, siteCodes, "Non editable column ( "+ site_acc_col +" ) value is mismatch" );
							//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder - end
							return responseStr = updateXMLString("trace", "Non editable column ( "+ site_acc_col +" ) value is mismatch", responseStr, userInfo);
						}
						//Added By Pankaj T. on 29-01-19 validate sites from user_site against userId - end
					}
					else if( "T".equals(objType) || "P".equals(objType) || "W".equals(objType) )
					{
						Node siteAccColNode = headerDom.getElementsByTagName(site_acc_col.toLowerCase()).item(0);
						if( siteAccColNode != null && siteAccColNode.getNodeType() == Node.ELEMENT_NODE && siteAccColNode.getFirstChild() != null )
						{
							siteAccColVal = checkNull(siteAccColNode.getFirstChild().getNodeValue());
							isValidate = true;
						}
						BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() siteAccColVal:["+siteAccColVal+"]");
						if( isValidate && !siteCode.equals(siteAccColVal) )
						{
							responseStr = getErrorString(site_acc_col, "VTINVTDATA", userId);
							//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
							writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", site_acc_col, siteAccColVal, siteCode, "Non editable column ( "+ site_acc_col +" ) value is mismatch" );
							return responseStr = updateXMLString("trace", "Non editable column ( "+ site_acc_col +" ) value is mismatch", responseStr, userInfo);
						}
						else
						{
							isValidate = false;
						}
					}
				}
				if( "E".equals(entityType) && emp_acc_col != null && !"".equals(emp_acc_col) )
				{
					String empAccColVal = "";
					if( "R".equals(objType) )
					{
						empAccColVal = checkNull(argumentMap.get(emp_acc_col.toLowerCase()));
						isValidate = true;
					}
					else if( "T".equals(objType) || "P".equals(objType) || "W".equals(objType) )
					{
						Node empAccColNode = headerDom.getElementsByTagName(emp_acc_col.toLowerCase()).item(0);
						if( empAccColNode != null && empAccColNode.getNodeType() == Node.ELEMENT_NODE && empAccColNode.getFirstChild() != null )
						{
							empAccColVal = checkNull(empAccColNode.getFirstChild().getNodeValue());
							isValidate = true;
						}
					}
					BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() empAccColVal:["+empAccColVal+"]");
					if( isValidate && !entityCode.equals(empAccColVal) )
					{
						responseStr = getErrorString(emp_acc_col, "VTINVTDATA", userId);
						//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
						writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", emp_acc_col, empAccColVal, entityCode, "Non editable column ( "+ emp_acc_col +" ) value is mismatch" );
						return responseStr = updateXMLString("trace", "Non editable column ( "+ emp_acc_col +" ) value is mismatch", responseStr, userInfo);
					}
					else
					{
						isValidate = false;
					}
				}
				else if( "C".equals(entityType) && cust_acc_col != null && !"".equals(cust_acc_col) )
				{
					String custAccColVal = "";
					if( "R".equals(objType) )
					{
						custAccColVal = checkNull(argumentMap.get(cust_acc_col.toLowerCase()));
						isValidate = true;
					}
					else if( "T".equals(objType) || "P".equals(objType) || "W".equals(objType) )
					{
						Node custAccColNode = headerDom.getElementsByTagName(cust_acc_col.toLowerCase()).item(0);
						if( custAccColNode != null && custAccColNode.getNodeType() == Node.ELEMENT_NODE && custAccColNode.getFirstChild() != null )
						{
							custAccColVal = checkNull(custAccColNode.getFirstChild().getNodeValue());
							isValidate = true;
						}
					}
					BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() custAccColVal:["+custAccColVal+"]");
					if( isValidate && !entityCode.equals(custAccColVal) )
					{
						responseStr = getErrorString(cust_acc_col, "VTINVTDATA", userId);
						//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
						writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", cust_acc_col, custAccColVal, entityCode, "Non editable column ( "+ cust_acc_col +" ) value is mismatch" );
						return responseStr = updateXMLString("trace", "Non editable column ( "+ cust_acc_col +" ) value is mismatch", responseStr, userInfo);
					}
					else
					{
						isValidate = false;
					}
				}
				else if( "S".equals(entityType) && supp_acc_col != null && !"".equals(supp_acc_col) )
				{
					String suppAccColVal = "";
					if( "R".equals(objType) )
					{
						suppAccColVal = checkNull(argumentMap.get(supp_acc_col.toLowerCase()));
						isValidate = true;
					}
					else if( "T".equals(objType) || "P".equals(objType) || "W".equals(objType) )
					{
						Node suppAccColNode = headerDom.getElementsByTagName(supp_acc_col.toLowerCase()).item(0);
						if( suppAccColNode != null && suppAccColNode.getNodeType() == Node.ELEMENT_NODE && suppAccColNode.getFirstChild() != null )
						{
							suppAccColVal = checkNull(suppAccColNode.getFirstChild().getNodeValue());
							isValidate = true;
						}
					}
					BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() suppAccColVal:["+suppAccColVal+"]");
					if( isValidate && !entityCode.equals(suppAccColVal) )
					{
						responseStr = getErrorString(supp_acc_col, "VTINVTDATA", userId);
						//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
						writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", supp_acc_col, suppAccColVal, entityCode, "Non editable column ( "+ supp_acc_col +" ) value is mismatch" );
						return responseStr = updateXMLString("trace", "Non editable column ( "+ supp_acc_col +" ) value is mismatch", responseStr, userInfo);
					}
					else
					{
						isValidate = false;
					}
				}
				else if( "P".equals(entityType) && sales_pers_acc_col != null && !"".equals(sales_pers_acc_col) )
				{
					String salesPersAccColVal = "";
					if( "R".equals(objType) )
					{
						salesPersAccColVal = checkNull(argumentMap.get(sales_pers_acc_col.toLowerCase()));
						isValidate = true;
					}
					else if( "T".equals(objType) || "P".equals(objType) || "W".equals(objType) )
					{
						Node salesPersAccColNode = headerDom.getElementsByTagName(sales_pers_acc_col.toLowerCase()).item(0);
						if( salesPersAccColNode != null && salesPersAccColNode.getNodeType() == Node.ELEMENT_NODE && salesPersAccColNode.getFirstChild() != null )
						{
							salesPersAccColVal = checkNull(salesPersAccColNode.getFirstChild().getNodeValue());
							isValidate = true;
						}
					}
					BaseLogger.log("3", userInfo, editorId,"E12GenericUtility.checkConsistency() salesPersAccColVal:["+salesPersAccColVal+"]");
					if( isValidate && !entityCode.equals(salesPersAccColVal) )
					{
						responseStr = getErrorString(sales_pers_acc_col, "VTINVTDATA", userId);
						//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
						writeSystemInconsistencyLogInFile( userInfo, "ProtectedDataAltered", objName, "", sales_pers_acc_col, salesPersAccColVal, entityCode, "Non editable column ( "+ sales_pers_acc_col +" ) value is mismatch" );
						return responseStr = updateXMLString("trace", "Non editable column ( "+ sales_pers_acc_col +" ) value is mismatch", responseStr, userInfo);
					}
					else
					{
						isValidate = false;
					}
				}
			}
		}
		catch(ITMException itmException)
		{
			BaseLogger.log("0", userInfo, editorId,"ITMException in E12GenericUtility.checkConsistency() :["+itmException.getMessage()+"]");
			throw itmException;
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, editorId,"Exception in E12GenericUtility.checkConsistency() :["+getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		finally 
		{
			try 
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( connection != null )
				{
					connection.close();
					connection = null;
				}
			}
			catch (Exception ex) 
			{
				BaseLogger.log("0", userInfo, editorId,"E12GenericUtility.checkConsistency() Exception in finally:["+getStackTrace(ex)+"]");
			}
		}
		BaseLogger.log("2", userInfo, editorId,"E12GenericUtility.checkConsistency() responseStr:["+responseStr+"]");
		BaseLogger.log("2", userInfo, editorId,"E12GenericUtility.checkConsistency() end");
		return responseStr;
	}
	//Added By Pankaj T. on 24-01-19 for Prevent to change value of transetup column confirm_col,site_acc_col,emp_acc_col,cust_acc_col,supp_acc_col and sales_pers_acc_col if defined and match entity type - end

	//Added By Pankaj T. on 29-01-19 validate sites from user_site against userId - start
	public boolean validateSites( UserInfoBean userInfo, TreeMap<String, String> argumentMap, String fieldName )
	{
		boolean result = false;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection connection = null;

		try 
		{
			String transDB = userInfo.getTransDB();
			String userID = userInfo.getLoginCode();
			BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() userID:["+userID+"]");
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(transDB);
			String siteCodes = argumentMap.get(fieldName.toLowerCase());
			BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() siteCodes:["+siteCodes+"]");
			if( siteCodes != null && !"null".equals(siteCodes) && !"undefined".equals(siteCodes) && !"".equals(siteCodes.trim()) )
			{
				//Added By Pankaj T. on 23-04-19 in report screen site_code field remove option like 1.,2.,3.,4.,5. from data - start
				if( siteCodes.indexOf(".") != -1 )
				{
					siteCodes = siteCodes.substring(siteCodes.indexOf(".")+1);
				}
				//Added By Pankaj T. on 23-04-19 in report screen site_code field remove option like 1.,2.,3.,4.,5. from data - end
				if( siteCodes.indexOf(",") != -1 )
				{
					siteCodes = siteCodes.replace("'", "");
				}
				BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() siteCodes after:["+siteCodes+"]");
				String siteCodeArr[] = siteCodes.split(",");
				String sql = "SELECT COUNT(1) FROM USER_SITE WHERE USER_ID=? AND SITE_CODE IN "+getFormattedProfileId(siteCodes);
				pstmt = connection.prepareStatement(sql);
				pstmt.setString(1, userID);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					int count = rs.getInt("COUNT(1)");
					BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() count:["+count+"]");
					BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() siteCodeArr size:["+siteCodeArr.length+"]");
					if( count == siteCodeArr.length )
					{
						BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() in if");
						result = true;
					}
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( connection != null )
				{
					connection.close();
					connection = null;
				}
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null,"E12GenericUtility.validateSites() Exception :["+getStackTrace(e)+"]");
		}
		finally 
		{
			try 
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( connection != null )
				{
					connection.close();
					connection = null;
				}
			}
			catch (Exception ex) 
			{
				BaseLogger.log("0", userInfo, null,"E12GenericUtility.validateSites() Exception in finally:["+getStackTrace(ex)+"]");
			}
		}
		BaseLogger.log("2", userInfo, null,"E12GenericUtility.validateSites() result:["+result+"]");
		return result;
	}
	//Added By Pankaj T. on 29-01-19 validate sites from user_site against userId - end

	//Added By Vikas L on 6-2-2019 [Start]
	public static String getPythonServiceURL(String serviceName)
	{
		String pythonServerPath = null;
		Map<String, Map<String, String>> pythonServicesMap = CommonConstants.PYTHON_SERVICES;

		if (pythonServicesMap != null) 
		{
			Map<String, String> pythonServiceDetails = pythonServicesMap.get(serviceName);

			if (pythonServiceDetails != null) {
				String protocol = pythonServiceDetails.get("PROTOCOL");
				String host = pythonServiceDetails.get("HOST");
				String port = E12GenericUtility.checkNull((pythonServiceDetails.get("PORT")));
				String path = pythonServiceDetails.get("ENDPOINT");

				pythonServerPath = String.format("%s://%s%s/%s", protocol, host, port, path);
			}
		}

		return pythonServerPath;
	}
	//Added By Vikas L on 6-2-2019 [End]

	//Added By Pankaj T. on 08-03-19 for update node value in xmlString - start
	public String updateXMLString( String nodeName, String nodeValue, String xmlString, UserInfoBean userInfo )
	{
		String returnXML = xmlString;
		try 
		{
			if( !"".equals(checkNull(xmlString)) )
			{
				xmlString = setXmlDec(xmlString);
				Document doc = parseString(xmlString);
				if( doc != null )
				{
					Node node = doc.getElementsByTagName(nodeName).item(0);
					if( node != null )
					{
						if( node.getNodeType() == Node.ELEMENT_NODE && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null )
						{
							node.getFirstChild().setNodeValue(nodeValue);
						}
						else
						{
							node.setTextContent(nodeValue);
						}
					}
				}
				returnXML = serializeDom(doc);
				BaseLogger.log("0", userInfo, null, "In updateXMLString returnXML:["+returnXML+"]");
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null, "In updateXMLString Exception:["+e+"]");
			return returnXML;
		}
		return returnXML;
	}
	//Added By Pankaj T. on 08-03-19 for update node value in xmlstring - end

	//Changed By Pankaj T. on 21-10-19 check request parameter value if found mismatch then throw "System Inconsistency Detected" error - start
	public String checkVulnerability( String queryString, String servletPathString, UserInfoBean userInfo, String requestURI, String requestURL, String host ) throws ITMException
	{
		String result = "";
		try 
		{
			//Added By Pankaj T. on 28-07-2020 to handle vulnerability of Host Header Injection in request to validate host when request comes - start
			requestURL = requestURL.substring(0, requestURL.indexOf("/ibase"));
			String domainName = requestURL.substring(requestURL.indexOf("/")+2);
			if( domainName.contains(":"))
			{
				domainName = domainName.substring(0, domainName.indexOf(":"));
			}
			//Added by Pankaj T. on 07-01-2022 for removing vulnerability host header injection checked host exist in defined domain list
			if( checkNull(CommonConstants.DOMAIN_NAMES).length() > 0 && !( CommonConstants.DOMAIN_NAMES.contains(domainName) && CommonConstants.DOMAIN_NAMES.contains(host) ) )
			{
				//Change By Pankaj T. on 28-09-2020 changed message of hostheader injection inconsistency
				//Changed by Prasad on 12/02/21 [to resolve null pointer exception] START
				String loginCode = "";
				if( userInfo != null )
				{
					loginCode = userInfo.getLoginCode();
				}
				result = getErrorString("", "VTINVDNAME", loginCode);
				//Changed by Prasad on 12/02/21 [to resolve null pointer exception] END
				result = updateXMLString("trace", "Domain found mismatch in the requested URL : "+requestURL, result, userInfo);
				//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
				writeSystemInconsistencyLogInFile( userInfo, "HostHeaderInjection", servletPathString, "", "DomainName", domainName, "<DOMAIN_NAMES>"+CommonConstants.DOMAIN_NAMES+"</DOMAIN_NAMES>", "" );
			}
			//Added By Pankaj T. on 28-07-2020 to handle vulnerability of Host Header Injection in request to validate host when request comes - end
			else if( !("".equals(checkNull(queryString))) )
			{
				//Added by Pankaj T. on 03-09-2020 to validate get request parameters min length, max lngth and contains space when request comes at server side in SessionTimeoutFilter - start
				Firewall firewall = new Firewall();
				String returnString = firewall.checkVulnerability(queryString, servletPathString, userInfo, requestURI, requestURL);
				if( returnString != null && returnString.startsWith("INVALID_REQUEST_PARAMETER") )
				{
					String[] stringArray = returnString.split("~~");
					String key = stringArray[1];
					String value = stringArray[2];
					String inconsistencyReason = stringArray[3];
					//change by shrutika on 19-12-2020 for Exception in application start
					String loginCode = "";
					if( userInfo != null )
					{
						loginCode = userInfo.getLoginCode();
					}
					result = getErrorString(key, "VTINVPDATA", loginCode);
					//change by shrutika on 19-12-2020 for Exception in application end
					result = updateXMLString("trace", "Request parameter ( "+ key +" ) value found mismatch in request "+servletPathString+"?"+queryString, result, userInfo);
					//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder
					writeSystemInconsistencyLogInFile( userInfo, "ParameterInjection", servletPathString, "", key, value, "", inconsistencyReason );
				}
				//Added by Pankaj T. on 03-09-2020 to validate get request parameters min length, max lngth and contains space when request comes at server side in SessionTimeoutFilter - end
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null,"E12GenericUtility.checkVulnerability() Exception : ["+getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		BaseLogger.log("0", null, null,"E12GenericUtility.checkVulnerability() result : ["+result+"]");
		return result;
	}
	//Changed By Pankaj T. on 21-10-19 check request parameter value if found mismatch then throw "System Inconsistency Detected" error - end

	//Added By Pankaj T. on 06-02-2020 for creating excel file from xml data - start
	public String convertXMLtoExcel( Document dom, String docName, String hostURL ) throws ITMException
	{
		String serverFilePath = "";
		try 
		{
			XSSFWorkbook workbook = new XSSFWorkbook();
			NodeList headerNodeList = dom.getElementsByTagName("Detail");
			BaseLogger.log("3",null,null,"E12GenericUtility.doPost() header count:["+headerNodeList.getLength()+"]");
			if( headerNodeList != null )
			{
				XSSFSheet sheet = workbook.createSheet("Header");
				for( int i = 0; i < headerNodeList.getLength(); i++ )
				{
					if( i == 0 )
					{
						Row headingRow = sheet.createRow(i);
						Node detailNode = headerNodeList.item(i);
						if( detailNode != null )
						{
							NodeList deatilChildList = detailNode.getChildNodes();
							for( int j = 0; j < deatilChildList.getLength(); j++ )
							{
								Node node = deatilChildList.item(j);
								if( node != null && Node.ELEMENT_NODE == node.getNodeType() )
								{
									String colName = node.getNodeName();
									BaseLogger.log("3",null,null,"E12GenericUtility.doPost() colName:["+colName+"]");
									Cell cell = headingRow.createCell(j);
									cell.setCellValue(colName);
								}
							}
						}
					}

					Row row = sheet.createRow(i+1);
					Node detailNode = headerNodeList.item(i);
					if( detailNode != null )
					{
						NodeList detailChildList = detailNode.getChildNodes();
						for( int j = 0; j < detailChildList.getLength(); j++ )
						{
							Node node = detailChildList.item(j);
							if( node != null && Node.ELEMENT_NODE == node.getNodeType() )
							{
								if( node.getFirstChild() != null )
								{
									String colValue = node.getFirstChild().getNodeValue();
									BaseLogger.log("3",null,null,"E12GenericUtility.doPost() colValule:["+colValue+"]");
									Cell cell = row.createCell(j);
									cell.setCellValue(colValue);
								}
							}
						}
					}
				}
			}

			/*NodeList detailNodeList = dom.getElementsByTagName("Detail2");
			BaseLogger.log("3",null,null,"E12GenericUtility.doPost() detail count:["+detailNodeList.getLength()+"]");
			if( detailNodeList != null )
			{
				XSSFSheet sheet = workbook.createSheet("Detail");
				for( int i = 0; i < detailNodeList.getLength(); i++ )
				{
					BaseLogger.log("3",null,null,"E12GenericUtility.doPost() in detail "+i);
					if( i == 0 )
					{
						Row headingRow = sheet.createRow(i);
						Node detailNode = detailNodeList.item(i);
						if( detailNode != null )
						{
							NodeList deatilChildList = detailNode.getChildNodes();
							for( int j = 0; j < deatilChildList.getLength(); j++ )
							{
								Node node = deatilChildList.item(j);
								if( node != null && Node.ELEMENT_NODE == node.getNodeType() )
								{
									String colName = node.getNodeName();
									BaseLogger.log("3",null,null,"E12GenericUtility.doPost() colName:["+colName+"]");
									Cell cell = headingRow.createCell(j);
									cell.setCellValue(colName);
								}
							}
						}
					}

					Row row = sheet.createRow(i+1);
					Node detailNode = detailNodeList.item(i);
					if( detailNode != null )
					{
						NodeList detailChildList = detailNode.getChildNodes();
						for( int j = 0; j < detailChildList.getLength(); j++ )
						{
							Node node = detailChildList.item(j);
							if( node != null && Node.ELEMENT_NODE == node.getNodeType() )
							{
								if( node.getFirstChild() != null )
								{
									String colValue = node.getFirstChild().getNodeValue();
									BaseLogger.log("3",null,null,"E12GenericUtility.doPost() colValule:["+colValue+"]");
									Cell cell = row.createCell(j);
									cell.setCellValue(colValue);
								}
							}
						}
					}
				}
			}*/

			if( "".equals(checkNull(docName)) )
			{
				docName = "Order.xlsx";
			}
			else
			{
				docName = docName.substring(0, docName.lastIndexOf("."));
				docName = docName + ".xlsx";
			}
			BaseLogger.log("3",null,null,"E12GenericUtility.convertXMLtoExcel() docName :["+ docName +"]");
			String folderPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator +"default"+ File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "upload_orders";
			File file = new File(folderPath);
			if( !file.exists() )
			{
				file.mkdirs();
			}
			String filePath = folderPath + File.separator + docName;
			try(FileOutputStream fileOutputStream = new FileOutputStream(filePath)) 
			{
				if( workbook.getNumberOfSheets() > 0 )
				{
					workbook.write(fileOutputStream);
					//serverFilePath = CommonConstants.TOMCAT_HOME + File.separator + "ibase" + File.separator + "upload_orders" + File.separator + docName;
					serverFilePath = hostURL + File.separator + "ibase" + File.separator + "upload_orders" + File.separator + docName;
				}
			}
			catch(Exception exp)
			{
				BaseLogger.log("0",null,null,"E12GenericUtility.doPost() Exception@@@:["+E12GenericUtility.getStackTrace(exp)+"]");
				throw new ITMException(exp);
			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0",null,null,"E12GenericUtility.convertXMLtoExcel() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		return serverFilePath;
	}
	//Added By Pankaj T. on 06-02-2020 for creating excel file from xml data - end

	public HashMap<String, String> getUserInfoMap( UserInfoBean userInfo )
	{
		HashMap<String, String> userInfoMap = new HashMap<String, String>();
		try
		{
			Document dom = parseString( userInfo.toString() );
			NodeList nodeList = dom.getElementsByTagName( "UserInfo" ).item( 0 ).getChildNodes();
			String fieldName = "";
			String fieldValue = "";
			for( int ctr = 0; ctr < nodeList.getLength(); ctr++ )
			{
				Node childNode = nodeList.item(ctr);
				if( childNode != null && childNode.getNodeType() == Node.ELEMENT_NODE )
				{
					fieldName = childNode.getNodeName();
					fieldValue = "";
					if( childNode.getFirstChild() != null )
					{
						fieldValue = childNode.getFirstChild().getNodeValue();
					}
					userInfoMap.put( fieldName, fieldValue );
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return userInfoMap;
	}
	//Added By Pankaj T. on 02-04-2020 for return errorstring in Message tag - start
	public String getErrorMessage( String columnName, String msgNo, String userId )throws RemoteException,ITMException
	{
		ConnDriver connDriver = null;
		Connection conn = null;
		StringBuffer errStringXml;
		Statement stmt = null;
		Statement stmt1 = null;
		Statement stmt2 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		String sqlQuery,sqlQuery1;
		String msgType = "";
		String msgString = "";
		String msgDescription = "";
		String profileId = "";
		String errSource = "";
		String tempMsgType = "";
		String msgOption = "";
		String msgTime = "";

		String redirerr = "";
		String soundPlay = "";
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			connDriver = null;
			sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
				msgString = rs.getString("MSG_STR");
				msgDescription = rs.getString("MSG_DESCR");
				errSource = rs.getString("ERR_SOURCE");
				msgOption = rs.getString("MSG_OPT");
				msgTime = rs.getString("MSG_TIME");
				soundPlay = rs.getString("ALARM");
			}
			else
			{
				msgDescription = "Message Id not found" + " [" + msgNo + "]" ;
				msgType = "E";
				msgString = "";
			}

			if (msgType.equals("E") || msgType.trim().length() == 0)
			{
				sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(sqlQuery1);
				if (rs1.next())
				{
					profileId=rs1.getString("profile_id");
					if (profileId == null)
					{
						profileId= "";
					}
					sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )"; //$NON-NLS-2$ //$NON-NLS-3$
					stmt2 = conn.createStatement();
					rs2 = stmt2.executeQuery(sqlQuery1);
					if (rs2.next())
					{
						tempMsgType = rs2.getString("msg_type");
					}
					rs2.close();
				}
				rs1.close();
				if (tempMsgType!=null && tempMsgType.trim().length()>0)
				{
					msgType = tempMsgType;
				}
			}
			if (msgType.equals("W"))
			{
				msgString = "Warning : " + msgString;
			}
			else if (msgType.equals("P"))
			{
				msgString = "Prompt : " + msgString;
			}
			else if(msgType.equals("F"))
			{
				msgString = "Information : " + msgString;
			}
			else
			{
				msgType = "E";
				msgString = "Error : " + msgString;
			}
			if (errSource!=null && errSource.trim().equals("D"))
			{
				msgDescription = msgDescription +  " * From Database ";
			}
			if (redirerr==null || redirerr.trim().length()==0)
			{
				redirerr = "1";
			}
			if (msgOption!=null && msgOption.trim().equals("M"))
			{
				if (redirerr.trim().equals("1"))
				{
					redirerr = "2";
				}
				else
				{
					redirerr = "1";
				}
			}
			if (rs != null)
			{
				rs.close();
				stmt.close();
			}
			if (rs1 != null)
			{
				rs1.close();
				stmt1.close();
			}
			if (rs2 != null)
			{
				rs2.close();
				stmt2.close();
			}
			conn.close();
		}
		catch(ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException : [E12GenericUtility][getErrorString] :==>\n"+itme.getMessage());
			throw itme;
		}
		catch(SQLException se)
		{
			msgDescription = se.getMessage();
			msgType = "";
			msgString = "";
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getErrorString] :==>\n"+se.getMessage());
			se.printStackTrace();
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getErrorString] :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}
				if ( stmt2 != null )
				{
					stmt2.close();
					stmt2 = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( rs2 != null )
				{
					rs2.close();
					rs2 = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		errStringXml = new StringBuffer();
		errStringXml.append("<Message id=\"");
		errStringXml.append(msgNo).append("\" type=\"").append(msgType).append("\" column_name=\"");
		errStringXml.append(columnName).append("\">\r\n");
		errStringXml.append("<message><![CDATA[ "+msgString+"]]></message>");
		errStringXml.append("<description><![CDATA["+msgDescription+"]]></description>");
		errStringXml.append("<type><![CDATA["+msgType+"]]></type>");
		errStringXml.append("<time><![CDATA["+msgTime+"]]></time>");
		errStringXml.append("<alarm><![CDATA["+soundPlay+"]]></alarm>");
		errStringXml.append("<source><![CDATA["+errSource+"]]></source>");
		errStringXml.append("<trace><![CDATA["+msgString+"]]></trace>");
		errStringXml.append("<redirect><![CDATA["+redirerr+"]]></redirect>");
		errStringXml.append("</Message>");

		return errStringXml.toString();
	}
	//Added By Pankaj T. on 02-04-2020 for return errorstring in Message tag - end

	//Added by Prasad on 19/05/2020 [get formNo wise xmlString from detail string dom] START
	public String getFormNoDetailStrFromDom( String allXmlString, String formNo ) throws ITMException
	{
		StringBuffer detailXml = new StringBuffer();
		try 
		{
			Document dom = parseString( allXmlString );
			NodeList detailNodeList = dom.getElementsByTagName( "Detail" + formNo );
			//BaseLogger.log( "3", null, null, "getFormNoDetailStrFromDom in detailNodeList ::"+detailNodeList.getLength());
			if (detailNodeList.getLength() > 0)
			{
				for ( int domCtr = 0; domCtr < detailNodeList.getLength(); domCtr++ )
				{
					detailXml.append( serializeDom( detailNodeList.item( domCtr ) ) );
				}
			} 
			else
			{
				detailXml.append( allXmlString  );
			} 
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
			throw e;
		}
		return detailXml.toString();
	}
	//Added by Prasad on 19/05/2020 [get formNo wise xmlString from detail string dom] END

	//Added by Sadique on 18/07/2020 [to column reorder related functionality] START
	public String applyPropertiesOnMetadata( JSONObject jsonObject, HashMap<String, String> propEditorInfoMap, UserInfoBean userInfo )
	{
		String retFilePath = null;
		ResourceModifier resModifier = null;
		ArrayList<String> enterpriseResList = new ArrayList<String>();
		ArrayList<String> profileResList = new ArrayList<String>();
		String metaDataFilePath = "";
		String exportToFolderName = "";
		File metaDataFile = null;
		String metaDatafileName = "";
		String profileIdRes = "";
		String enterpriseIdRes = "";
		String profileId = "";
		String editor = "";
		try
		{
			//Changed by sadique shaikh on 20-07-2020 for Multiple Drag and drop start
			org.json.JSONObject jsonObjectMetadata = jsonObject.getJSONObject("REORDER_DATA");

			String formName = jsonObjectMetadata.getString("FORM_NAME");
			String objContext = jsonObjectMetadata.getString("FORM_NO");
			String objName = jsonObjectMetadata.getString("OBJ_NAME");
			String pageContext = "1";
			//Changed by sadique shaikh on 20-07-2020 for Multiple Drag and drop End
			if ( formName != null && ! "null".equalsIgnoreCase(formName) && formName.trim().length() > 0 )
			{
				metaDatafileName = objName + pageContext + formName;
			}
			else
			{
				metaDatafileName = objName+""+pageContext+""+objContext;
			}
			profileIdRes = checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
			enterpriseIdRes = checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
			profileId = checkNull(propEditorInfoMap.get("PROFILE_ID"));
			//editor = checkNull(propEditorInfoMap.get("EDITOR")); //removed editor wise metadata resource pack property editor as per kandarp sir.
			propEditorInfoMap.put("EDITOR", editor);

			String userId = checkNull(propEditorInfoMap.get("USER_ID"));
			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
			String mataDataDefaultPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;

			resModifier = new ResourceModifier();
			//Changed by sadique shaikh on 20-07-2020 for Multiple Drag and drop Metda xml file Start no to check on default path
			if( ! "".equalsIgnoreCase( profileIdRes ) )
			{
				profileResList = resModifier.getResourcePath( profileIdRes, userInfo.getTransDB() );
				BaseLogger.log( "3", null, null, "metaDataFile.profileResList "+profileResList );
			}
			if( ! "".equalsIgnoreCase( enterpriseIdRes ) )
			{
				enterpriseResList = resModifier.getEnterpriseResPath( enterpriseIdRes, userInfo.getTransDB() );
				BaseLogger.log( "3", null, null, "metaDataFile.enterpriseResList "+enterpriseResList );
			}
			if( profileResList.size() <= 0 && enterpriseResList.size() <= 0 )
			{
				BaseLogger.log( "3", null, null, "metaDataFile.profileId "+profileId );
				//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop Metda xml file 
				//Changes by Jatin M on 10-06-2021 for profile Id wise changes - Start
				updatePropertiesFile( jsonObject, "", userInfo );
				//metaDataFilePath = mataDataDefaultPath;
				//exportToFolderName = userId;
				metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileId + File.separator + userId + File.separator;
				exportToFolderName = profileId + File.separator + userId;
				BaseLogger.log( "3", null, null, "metaDataFile.metaDataFilePath "+metaDataFilePath );
				BaseLogger.log( "3", null, null, "metaDataFile.exportToFolderName "+exportToFolderName );
				//Changes by Jatin M on 10-06-2021 for profile Id wise changes - End
			}
			else
			{
				//Changed by Sadique S 19-02-2021 [get path of properties file] START
				String prResPropFilePath = resModifier.getPropertiesFilePath( profileResList, objName, objContext, pageContext, editor, formName, false );
				String entrResPropFilePath = resModifier.getPropertiesFilePath( enterpriseResList, objName, objContext, pageContext, editor, formName, false );
				//Changed by Sadique S 19-02-2021 [get path of properties file] END

				if( profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFilePath.length() > 0 && entrResPropFilePath.length() > 0 )
				{
					updatePropertiesFile( jsonObject, prResPropFilePath, userInfo );
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator + userId + File.separator;
					exportToFolderName = enterpriseIdRes + "-"+ profileIdRes + File.separator + userId;
				}
				else if( profileResList.size() > 0 && prResPropFilePath.length() > 0 )
				{
					updatePropertiesFile( jsonObject, prResPropFilePath, userInfo );
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator + userId + File.separator;
					exportToFolderName = profileIdRes + File.separator + userId;
				}
				else if( enterpriseResList.size() > 0 && entrResPropFilePath.length() > 0 )
				{
					updatePropertiesFile( jsonObject, entrResPropFilePath, userInfo );
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
					exportToFolderName = enterpriseIdRes + File.separator + userId;
				}
				else
				{
					//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop Metda xml file Start
					//Changed by sadique shaikh 27-07-2020 exportFolder name was getting null and metadata file was not creating start
					updatePropertiesFile( jsonObject, "", userInfo );
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator + userId + File.separator;
					exportToFolderName = profileIdRes + File.separator + userId;
					//Changed by sadique shaikh 27-07-2020 exportFolder name was getting null and metadata file was not creating End
				}
			}
			//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop Metda xml file Start
			BaseLogger.log( "3", null, null, "metaDataFile : ["+ metaDataFilePath +"]" );
			metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml" );
			BaseLogger.log( "3", null, null,"Metadata file exists : ["+ metaDataFile.exists() +"]" );
			if( metaDataFile.exists() && ! mataDataDefaultPath.equalsIgnoreCase( metaDataFilePath ) )
			{
				metaDataFile.delete();
			}
			DWFactory dws = new DWFactory(userInfo);
			DWObject dwObject = ( DWObject )dws.getDataWindow( metaDatafileName );
			dwObject.exportToXML( exportToFolderName, objName, objContext, pageContext, formName, profileResList, enterpriseResList, propEditorInfoMap, userInfo.getTransDB() );
			//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop Metda xml file End

			BaseLogger.log( "3", null, null, "E12GenericUtils : applyPropertiesOnMetadata : metaDataFilePath :["+ metaDataFilePath +"]" );
			BaseLogger.log( "3", null, null, "Metadata file exists : ["+ metaDataFile.exists() +"]" );
			if( metaDataFile.exists() )
			{
				retFilePath = metaDataFile.getAbsolutePath();
			}
			else
			{
				retFilePath = "";
				BaseLogger.log( "3", null, null, "E12GenericUtils:getMetaDataFilePath: MetaDataFilePath not found......" );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		BaseLogger.log("2",null,null,"E12GenericUtils:getMetaDataFilePath: retFilePath :["+retFilePath+"]");
		return retFilePath;
	}

	//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available]
	private void updatePropertiesFile( JSONObject jsonObject, String tablePropertiesFilepath, UserInfoBean userInfo )
	{
		BaseLogger.log( "3", null, null, "updatePropertiesFile propertiesFilepath ["+ tablePropertiesFilepath +"]" );
		//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop
		String dataPropertieseStr = "";
		String formName = "" ,formNo ="",objName ="",logicalname = "",pageContext = "1";
		String profileId = checkNull( userInfo.getProfileId() );
		try 
		{
			//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop Start
			org.json.JSONObject jsonObjectFormData = jsonObject.getJSONObject("REORDER_DATA");

			BaseLogger.log( "3", null, null, "updatePropertiesFile jsonObjectFormData ["+jsonObjectFormData +"]" );
			formName = jsonObjectFormData.getString("FORM_NAME");
			formNo = jsonObjectFormData.getString("FORM_NO");
			objName = jsonObjectFormData.getString("OBJ_NAME");

			JSONArray jsonArray = jsonObject.getJSONArray("REORDER_COORDINATE");
			BaseLogger.log( "3", null, null, "updatePropertiesFile jsonArray ["+ jsonArray +"]" );
			for (int i = 0; i < jsonArray.length(); i++) 
			{
				String jsonStr =  jsonArray.get(i).toString();
				org.json.JSONObject jsonXcorObject = new org.json.JSONObject( jsonStr );
				int xcordinate = jsonXcorObject.getInt("X_CORDINATE");
				logicalname = jsonXcorObject.getString("LOGICAL_NAME");
				logicalname = logicalname.substring(logicalname.indexOf(".") + 1, logicalname.length());

				dataPropertieseStr += "\nColumnObject." + logicalname + ".x=" + xcordinate + "\nTextObject." + logicalname + "_t.x=" + xcordinate;
			}
			BaseLogger.log( "3", null, null, "dataPropertieseStr Data created: ["+ dataPropertieseStr +"]" );
			//Added by sadique shaikh on 20-07-2020 for Multiple Drag and drop End

			tablePropertiesFilepath = checkNull( tablePropertiesFilepath ); // Changes by Jatin M on 25-07-2021 for white-space getting added to variable value
			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
			String tablePropertiesFileName = "";
			String userId = userInfo.getLoginCode().trim();
			//Changed by sadiqeu shaikh 24-07-2020 [For reource pack] Start
			if ( tablePropertiesFilepath.length() == 0 )
			{
				tablePropertiesFileName = (objName+"_"+pageContext+formNo+"_table.properties");
				//tablePropertiesFilepath = CommonConstants.RESOURCE_PROFILE_PATH + File.separator + userId;
				//BaseLogger.log( "3", null, null, "tablePropertiesFilepath b4 created: ["+ tablePropertiesFilepath +"]" );
				tablePropertiesFilepath = CommonConstants.RESOURCE_PROFILE_PATH + File.separator + profileId + File.separator + userId; //Changes by Jatin M on 10-06-2021 for profile Id wise changes
				BaseLogger.log( "3", null, null, "tablePropertiesFilepath after created: ["+ tablePropertiesFilepath +"]" );
				if ( formName != null && formName.trim().length() > 0 && ! "null".equalsIgnoreCase( formName ) )
				{
					tablePropertiesFileName = (objName+"_"+pageContext+formName+"_table.properties");
					tablePropertiesFilepath = CommonConstants.RESOURCE_PROFILE_PATH + File.separator + profileId + File.separator + userId;
				}
			}
			else
			{
				tablePropertiesFileName = tablePropertiesFilepath.substring( tablePropertiesFilepath.lastIndexOf( File.separator ) + 1 );
				tablePropertiesFileName = tablePropertiesFileName.substring( 0, tablePropertiesFileName.lastIndexOf( "." ) );
				tablePropertiesFileName = (tablePropertiesFileName + "_table.properties");

				tablePropertiesFilepath = tablePropertiesFilepath.substring( 0, tablePropertiesFilepath.lastIndexOf( File.separator ) );
				tablePropertiesFilepath = tablePropertiesFilepath + File.separator + userId;
			}
			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
			BaseLogger.log( "3", null, null, "propertiesFilepath : ["+ tablePropertiesFilepath +"]" );
			//Changed by sadiqeu shaikh 24-07-2020 [For reource pack] End
			File propertiesFilesObj = new File( tablePropertiesFilepath );
			//propertiesFilesObj = new File( propertiesFilepath );

			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
			if ( ! propertiesFilesObj.exists() )
			{
				BaseLogger.log( "3", null, null, "table properties file path created" );
				propertiesFilesObj.mkdirs();
			}
			propertiesFilesObj = new File( tablePropertiesFilepath + File.separator + tablePropertiesFileName );
			if ( propertiesFilesObj.exists() )
			{
				BaseLogger.log( "3", null, null, "existing table propertise file deleted" );
				propertiesFilesObj.delete();
			}
			propertiesFilesObj = new File( tablePropertiesFilepath + File.separator + tablePropertiesFileName );
			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
			if( ! propertiesFilesObj.exists() )
			{
				propertiesFilesObj.createNewFile();
				BaseLogger.log( "3", null, null, "new table propertise file created" );
			}
			FileWriter propertiesFileWriter = new FileWriter( propertiesFilesObj );
			propertiesFileWriter.write( dataPropertieseStr );
			propertiesFileWriter.close();
		}
		catch (JSONException e) 
		{
			e.printStackTrace();
			BaseLogger.log( "0", null, null, "Exception :: JSONException : ["+ e.getMessage() +"]" );
		}
		catch (IOException e) 
		{
			e.printStackTrace();
			BaseLogger.log( "0", null, null, "Exception :: IOException : ["+ e.getMessage() +"]" );
		}
	}
	//Added by Sadique on 18/07/2020 [to column reorder related functionality] END

	//Added by shrutika on 23-07-2020 [Start] for update itemchange response on server side for issue in CCA screen(status_remarks field not update issue occur in validation)
	public String updateXMLStringWithCDATA( String nodeName, String nodeValue, String xmlString, UserInfoBean userInfo )
	{
		String returnXML = xmlString;
		try 
		{
			if( !"".equals(checkNull(xmlString)) )
			{
				xmlString = setXmlDec(xmlString);
				Document doc = parseString(xmlString);
				if( doc != null )
				{
					Node node = doc.getElementsByTagName(nodeName).item(0);
					if( node != null )
					{
						if( node.getNodeType() == Node.ELEMENT_NODE && node.getFirstChild() != null && node.getFirstChild().getNodeValue() != null )
						{
							node.getFirstChild().setNodeValue(nodeValue);
						}
						else
						{
							CDATASection cDataSection = doc.createCDATASection(nodeValue);
							node.appendChild( cDataSection );
						}
					}
				}
				returnXML = serializeDom(doc);
				BaseLogger.log("0", userInfo, null, "In updateXMLStringWithCDATA returnXML:["+returnXML+"]");

			}
		}
		catch (Exception e) 
		{
			BaseLogger.log("0", userInfo, null, "In updateXMLStringWithCDATA Exception:["+e+"]");
			return returnXML;
		}
		return returnXML;
	}
	//Added by shrutika on 23-07-2020 [End] for update itemchange response on server side for issue in CCA screen(status_remarks field not update issue occur in validation)

	//Added by Pankaj T. on 03-09-2020 to validate get request parameters min length, max lngth and contains space when request comes at server side in SessionTimeoutFilter - start
	public static JsonObject readJsonFile( String fileName ) throws Exception
	{
		BaseLogger.log("3", null, null, "In readJsonFile fileName:["+fileName+"]");
		StringBuffer fileContent = new StringBuffer();
		BufferedReader bfr = null;
		FileInputStream fMainIn = null;
		String outTempStr = null;
		try
		{
			fMainIn = new FileInputStream( fileName );
			bfr = new BufferedReader(new InputStreamReader(fMainIn, CommonConstants.ENCODING));
			while((outTempStr = bfr.readLine()) != null)
			{
				fileContent.append(outTempStr);
			}
			bfr.close();
			bfr = null;
		}
		catch ( Exception e )
		{
			throw e;
		}
		finally
		{
			try
			{
				if( 
bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if(fMainIn != null)
				{
					fMainIn.close();
				}
			}
			catch ( Exception e )
			{
				BaseLogger.log("0",null,null, "Exception in readJsonFile file resource :[" + e.getMessage() + "]" );
				e.printStackTrace();
			}
			finally
			{
				fMainIn = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
				outTempStr = null;//changed by Nilesh Soor on 24/07/2014 [Memory Leak Issue]
			}
		}
		JsonParser parser = new JsonParser();
		JsonObject jsonObject = (JsonObject) parser.parse(fileContent.toString());
		BaseLogger.log("3", null, null, "In readJsonFile 7347["+jsonObject.toString()+"]");
		return jsonObject;
	}
	//Added by Pankaj T. on 03-09-2020 to validate get request parameters min length, max lngth and contains space when request comes at server side in SessionTimeoutFilter - end

	//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder - start
	public void writeSystemInconsistencyLogInFile( UserInfoBean userInfo, String inconsistencyMessage, String componentName, String methodName, String parameterName, String parameterClientValue, String parameterServerValue, String inconsistencyReason )
	{
		try
		{
			BaseLogger.log("0",null,null,"E12Genericutility : writeSystemInconsistencyLogInFile");
			String folderPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "ExceptionLog";
			File logDir = new File( folderPath );
			// Check folder exists if not then create
			if( !logDir.exists() )
			{
				logDir.mkdirs();
			}

			String logFileName = "Firewall_breach_attempts.log";
			File logFile = new File( folderPath, logFileName );
			// Check file exists if not then create
			if( !logFile.exists() )
			{
				logFile.createNewFile();
			}

			if( componentName != null && componentName.startsWith("/") )
			{
				componentName = componentName.substring(1);
			}

			SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
			Date date = new Date();
			String sysDate = formatter.format(date);
			if( sysDate != null && sysDate.indexOf("/") != -1 )
			{
				sysDate = sysDate.replaceAll("/", "-");
			}
			formatter = new SimpleDateFormat("hh:mm:ss");
			String sysTime = formatter.format(date);

			//change by shrutika on 19-12-2020 for Exception in application start
			String loginCode = "";
			if( userInfo != null )
			{
				loginCode =  userInfo.getLoginCode();
			}
			String message = "";
			if( "HostHeaderInjection".equalsIgnoreCase( inconsistencyMessage ) )
			{
				message = sysDate + "," + sysTime + "," + loginCode + "," + inconsistencyMessage + "," + componentName + "," + parameterName + "," + parameterClientValue + "," + parameterServerValue + "\n\n";
			}
			else if( "ParameterInjection".equalsIgnoreCase( inconsistencyMessage ) )
			{
				message = sysDate + "," + sysTime + "," + loginCode + "," + inconsistencyMessage + "," + componentName + "," + parameterName + "," + parameterClientValue + "," + inconsistencyReason + "\n\n";
			}
			else if( "ProtectedDataAltered".equalsIgnoreCase( inconsistencyMessage ) )
			{
				message = sysDate + "," + sysTime + "," + loginCode + "," + inconsistencyMessage + "," + componentName + "," + parameterName + "," + parameterClientValue + "," + parameterServerValue + "\n\n";
			}
			//change by shrutika on 19-12-2020 for Exception in application end
			BaseLogger.log("0",null,null,"E12Genericutility : writeSystemInconsistencyLogInFile inconsistency details:["+message+"]");

			FileWriter writer = new FileWriter(logFile, true);
			writer.write( message );
			writer.flush();
			writer.close();
		}
		catch( IOException er )
		{
			BaseLogger.log("0",null,null,"E12Genericutilty : writeSystemInconsistencyLogInFile : " + E12GenericUtility.getStackTrace(er));
		}
	}
	//Added by Pankaj T. on 11-09-2020 written log for system inconsitency detected details in file Firewall_breach_attempts.log in ExceptionLog folder - end

	//Added by Prasad on 07/09/2020 [to delete the files from folder is provided limit is exceeds] START
	public static void deleteOldFilesFromFolder( String folderPath, String extensionCouldBeNull, int limit )
	{
		try 
		{
			if ( limit <= 1 )
			{
				return;
			}
			BaseLogger.log( "3", null, null, "default limit ["+ limit +"]" );

			File dir = new File( folderPath );
			if ( ! dir.exists() )
			{
				return;
			}
			Path parentFolder = dir.toPath();
			BaseLogger.log( "3", null, null, "parentFolder ["+ parentFolder.getFileName() +"]" );

			//get file list sorted by creation date
			List<Path> files = getSortedFilesByDateCreated( parentFolder, extensionCouldBeNull, false );
			BaseLogger.log( "3", null, null, "files.size() ["+ files.size() +"]" );
			if ( files.size() <= limit )
			{
				return;
			}

			//count to delete the files at a time
			int removeFileLimit = CommonConstants.DELETE_LOG_FILE_COUNT;
			if ( limit >= removeFileLimit )
			{
				limit = limit - removeFileLimit;
			}
			BaseLogger.log( "3", null, null, "limit ["+ limit +"]" );
			//delete recent files and keeping old files in the list
			files.subList( 0, limit ).clear();

			//deleting old files
			files.forEach(p -> {
				try 
				{
					Files.delete(p);
				}
				catch (IOException e) 
				{
					e.printStackTrace();
				}
			});
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", null, null, "Exception :: deleteOldFilesFromFolder : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
	}

	private static List<Path> getSortedFilesByDateCreated( Path parentFolder, String targetExtensionCouldBeNull, boolean ascendingOrder ) 
	{
		try 
		{
			Comparator<Path> pathComparator = Comparator.comparingLong( p -> getFileCreationEpoch( (p).toFile() ) );
			return Files.list(parentFolder)
					.filter( Files::isRegularFile )
					.filter( p -> targetExtensionCouldBeNull == null || p.getFileName().toString().endsWith( targetExtensionCouldBeNull ) )
					.sorted( ascendingOrder ? pathComparator : pathComparator.reversed() )
					.collect( Collectors.toList() );
		}
		catch (IOException e) 
		{
			throw new RuntimeException(e);
		}
	}

	private static long getFileCreationEpoch(File file) 
	{
		try 
		{
			BasicFileAttributes attr = Files.readAttributes( file.toPath(), BasicFileAttributes.class );
			return attr.creationTime().toInstant().toEpochMilli();
		}
		catch (IOException e) 
		{
			throw new RuntimeException(e);
		}
	}
	//Added by Prasad on 07/09/2020 [to delete the files from folder is provided limit is exceeds] END

	//Added by Prasad on 03/10/2020 [to get orderedJsonObject] START
	public static JSONObject getOrderedJSONObject()
	{
		JSONObject jsonObject = null;
		try
		{
			jsonObject = new JSONObject();
			java.lang.reflect.Field map = jsonObject.getClass().getDeclaredField("map");
			map.setAccessible(true);
			map.set(jsonObject, new LinkedHashMap<>());
			map.setAccessible(false);
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception :: getOrderedJSONObject : ["+ e.getMessage() +"]" );
			e.printStackTrace();
			jsonObject = new JSONObject();
		}
		return jsonObject;
	}
	//Added by Prasad on 03/10/2020 [to get orderedJsonObject] END

	//Added by Prasad on 15/10/2020 [to set attribute value] START
	public String setAttribValue( String formDetailXml, String nodeName, String attribStr, String attribValue )
	{
		try
		{
			Document detailDom = parseString( formDetailXml );
			Node attributeNode = detailDom.getElementsByTagName( nodeName ).item(0);
			if( attributeNode != null && attributeNode.getAttributes() != null)
			{
				Node attribNode = attributeNode.getAttributes().getNamedItem( attribStr );
				if( attribNode != null )
				{
					attribNode.setNodeValue(attribValue);
				}
				else
				{
					( ( Element )attributeNode ).setAttribute( attribStr, attribValue );
				}
			}
			formDetailXml = serializeDom( detailDom );
		}
		catch(Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception : setAttribValue : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		return formDetailXml;
	}
	//Added by Prasad on 15/10/2020 [to set attribute value] END

	//Added by sadique shaikh 12-11-2020 [to get reorder xml path] start
	public String getReorderMetaDataFilePath( String objName, String objContext, String pageContext, String formName, HashMap<String, String> propEditorInfoMap, String transDB)
	{
		BaseLogger.log("2",null,null, "E12GenericUtils:getReorderMetaDataFilePath: objName: [" + objName + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getReorderMetaDataFilePath: objContext: [" + objContext + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getReorderMetaDataFilePath: pageContext: [" + pageContext + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getReorderMetaDataFilePath: formName: [" + formName + "]" );
		BaseLogger.log("2",null,null, "E12GenericUtils:getReorderMetaDataFilePath: propEditorInfoMap: [" + propEditorInfoMap + "]" );
		String retFilePath = null;
		ResourceModifier resModifier = null;
		ArrayList<String> enterpriseResList = new ArrayList<String>();
		ArrayList<String> profileResList = new ArrayList<String>();
		String metaDataFilePath = "";
		String exportToFolderName = "";
		String mataDataDefaultPath = "";
		File metaDataFile = null;
		String metaDatafileName = "";
		String profileIdRes = "";
		String enterpriseIdRes = "";
		String profileId = "";
		String editor = "";
		try
		{
			if(formName != null && !"null".equalsIgnoreCase(formName) && formName.trim().length() > 0)
			{
				metaDatafileName = objName + pageContext + formName;
			}
			else
			{
				metaDatafileName = objName+""+pageContext+""+objContext;
			}
			profileIdRes = checkNull(propEditorInfoMap.get("PROFILE_ID_RES"));
			enterpriseIdRes = checkNull(propEditorInfoMap.get("ENTERPRISE_ID_RES"));
			profileId = checkNull(propEditorInfoMap.get("PROFILE_ID")); //Changes by Jatin M on 10-06-2021 for profile Id wise changes
			//editor = checkNull(propEditorInfoMap.get("EDITOR")); //removed editor wise metadata resource pack property editor as per kandarp sir.
			propEditorInfoMap.put("EDITOR", editor);

			//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
			String userId = checkNull(propEditorInfoMap.get("USER_ID"));
			boolean tablePropFileExist = false;
			boolean prResPropFileExist = false;
			boolean entrResPropFileExist = false;

			resModifier = new ResourceModifier();

			//Commented and Added by Pankaj R on 24-Nov-20 as suggested by Danish sir
			//mataDataDefaultPath = CommonConstants.JBOSSHOME + File.separator + "bin" + File.separator + "metadata" + File.separator;
			mataDataDefaultPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;

			if( "".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes) )
			{
				metaDataFilePath = mataDataDefaultPath;

				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
				tablePropFileExist = resModifier.isTablePropertiesFileExist( objName, objContext, pageContext, editor, formName, userId, profileId );
				if ( tablePropFileExist )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileId + File.separator + userId + File.separator; //Changes by Jatin M on 10-06-2021 for profile Id wise changes
				}
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
			}
			else
			{
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
				/*if( !"".equalsIgnoreCase(profileIdRes) )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator;
					metaDataFile = new File( metaDataFilePath , metaDatafileName+".xml");
					if(! metaDataFile.exists() && !"".equalsIgnoreCase(enterpriseIdRes) )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator;
						metaDataFile = new File( metaDataFilePath , metaDatafileName+".xml");

						if(! metaDataFile.exists() && !"".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes) )
						{
							metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator;
						}
					}
				}
				else
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator;
				}*/
				if( !"".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes) )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator + userId + File.separator;
				}
				else if( !"".equalsIgnoreCase(profileIdRes) && "".equalsIgnoreCase(enterpriseIdRes) )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator + userId + File.separator;
				}
				else if( "".equalsIgnoreCase(profileIdRes) && !"".equalsIgnoreCase(enterpriseIdRes) )
				{
					metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
				}
				//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
			}
			BaseLogger.log( "3", null, null, "E12GenericUtils: getReorderMetaDataFilePath : metaDataFilePath :["+ metaDataFilePath +"]" );
			metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml" );
			if( ! metaDataFile.exists() )
			{
				if( !"".equalsIgnoreCase(profileIdRes)  )
				{
					profileResList = resModifier.getResourcePath( profileIdRes, transDB );
				}
				if( !"".equalsIgnoreCase(enterpriseIdRes) )
				{
					enterpriseResList = resModifier.getEnterpriseResPath( enterpriseIdRes, transDB );
				}
				if( profileResList.size() <= 0 && enterpriseResList.size() <= 0 )
				{
					metaDataFilePath = mataDataDefaultPath;
					metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml" );

					//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
					tablePropFileExist = resModifier.isTablePropertiesFileExist( objName, objContext, pageContext, editor, formName, userId, profileId );
					if ( tablePropFileExist )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileId + File.separator + userId + File.separator; //Changes by Jatin M on 10-06-2021 for profile Id wise changes
						exportToFolderName = userId;
					}
					//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
				}
				else
				{
					//Changed by Jatin M ON 06-May-2022 [reordered metadata file read from incorrect path] - START
					//prResPropFileExist = resModifier.isPropertiesFileExist(profileResList, objName, objContext, pageContext, editor, formName);
					//entrResPropFileExist = resModifier.isPropertiesFileExist(enterpriseResList, objName, objContext, pageContext, editor, formName);
					String prResPropFilePath = resModifier.getPropertiesFilePath( profileResList, objName, objContext, pageContext, editor, formName, false );
					String entrResPropFilePath = resModifier.getPropertiesFilePath( enterpriseResList, objName, objContext, pageContext, editor, formName, false );
					//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] START
					/*if( profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFileExist && entrResPropFileExist )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator;
						exportToFolderName = enterpriseIdRes + "-" + profileIdRes;

						metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml" );

						if( ! metaDataFile.exists() && profileResList.size() > 0 && prResPropFileExist )
						{
							metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator;
							exportToFolderName = profileIdRes;

							metaDataFile = new File( metaDataFilePath , metaDatafileName+".xml");

							if( ! metaDataFile.exists() && enterpriseResList.size() > 0 && entrResPropFileExist)
							{
								metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator;
								exportToFolderName = enterpriseIdRes;
							}
							else
							{
								metaDataFilePath = mataDataDefaultPath;
							}
						}
					}
					else
					{
						if( profileResList.size() > 0 && prResPropFileExist )
						{
							metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator;
							exportToFolderName = profileIdRes;
							metaDataFile = new File( metaDataFilePath , metaDatafileName+".xml");
							if( ! metaDataFile.exists() && enterpriseResList.size() > 0 && entrResPropFileExist)
							{
								metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator;
								exportToFolderName = enterpriseIdRes;
							}
							else
							{
								metaDataFilePath = mataDataDefaultPath;
							}
						}
						else if( enterpriseResList.size() > 0 && entrResPropFileExist)
						{
							metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator;
							exportToFolderName = enterpriseIdRes;
						}
						else
						{
							metaDataFilePath = mataDataDefaultPath;
						}
					}*/
					//if( profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFileExist && entrResPropFileExist )
					if( profileResList.size() > 0 && enterpriseResList.size() > 0 && prResPropFilePath.length() > 0 && entrResPropFilePath.length() > 0 )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + "-"+ profileIdRes + File.separator + userId + File.separator;
						exportToFolderName = (enterpriseIdRes + "-"+ profileIdRes) + File.separator + userId;
					}
					//else if( profileResList.size() > 0 && prResPropFileExist )
					else if( profileResList.size() > 0 && prResPropFilePath.length() > 0 )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + profileIdRes + File.separator + userId + File.separator;
						exportToFolderName = profileIdRes + File.separator + userId;
					}
					//else if( enterpriseResList.size() > 0 && entrResPropFileExist )
					else if( enterpriseResList.size() > 0 && entrResPropFilePath.length() > 0 )
					{
						metaDataFilePath = CommonConstants.JBOSSHOME + File.separator + CommonConstants.RESOURCE + File.separator + enterpriseIdRes + File.separator + userId + File.separator;
						exportToFolderName = enterpriseIdRes + File.separator + userId;
					}
					else
					{
						metaDataFilePath = mataDataDefaultPath;
					}
					//Changed by Jatin M ON 06-May-2022 [reordered metadata file read from incorrect path] -END
					/*if( ! metaDataFile.exists() && ( prResPropFileExist || entrResPropFileExist || tablePropFileExist ) )
					{
						DWFactory dws = new DWFactory();
						DWObject dwObject = ( DWObject )dws.getDataWindow( metaDatafileName );
						String tempStr = dwObject.exportToXML( exportToFolderName, objName, objContext, pageContext, formName, profileResList, enterpriseResList, propEditorInfoMap, transDB );
					}*/
					//Changed by Sadique on 22/03/2021 [to support reorder column functionality in case of profile_id_res is not available] END
				}
				BaseLogger.log( "3", null, null, "E12GenericUtils: getReorderMetaDataFilePath :metaDataFilePath :["+ metaDataFilePath +"]" );

				metaDataFile = new File( metaDataFilePath, metaDatafileName+".xml");
			}

			BaseLogger.log( "3", null, null, "Metadata file exists :["+ metaDataFile.exists() +"]" );
			if( metaDataFile.exists() )
			{
				retFilePath = metaDataFile.getAbsolutePath();
			}
			else
			{
				retFilePath = "";
				BaseLogger.log( "3", null, null, "E12GenericUtils: getReorderMetaDataFilePath : MetaDataFilePath not found......" );
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		BaseLogger.log( "2", null, null, "E12GenericUtils: getReorderMetaDataFilePath : retFilePath :["+ retFilePath +"]" );
		return retFilePath;
	}
	// Added by sadique shaikh 12-11-2020 [to get reorder xml] End

	//Added by Prasad on 01/12/2020 [added some functions to write file, encodeXML, decodeXML] START
	public String writeFile( String filePath, String fileName, String data ) throws ITMException
	{
		String fileSize = writeFile( filePath, fileName, data, false );
		return fileSize;
	}

	public String writeFile( String filePath, String fileName, String data, boolean append ) throws ITMException
	{
		String fileSize = "";
		try
		{
			File fileDir = new File( filePath );
			if( ! fileDir.exists() )
			{
				fileDir.mkdirs();
				BaseLogger.log( "3", null, null, "New Directory Created" );
			}

			filePath = fileDir + File.separator + fileName;
			File file = new File( filePath );
			BaseLogger.log( "3", null, null, "file : ["+ file +"]" );
			if ( ! file.exists() )
			{
				file.createNewFile();
				BaseLogger.log( "3", null, null, "new File Created" );
			}

			PrintWriter out = new PrintWriter( new BufferedWriter( new FileWriter( filePath, append ) ) );
			out.println( data );
			out.close();
			long fileSizeL = file.length();
			fileSize = String.valueOf(fileSizeL);
			BaseLogger.log("3", null, null, "file size::" + "[" + fileSize + "]");
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			BaseLogger.log( "0", null, null, "Exception in writeFile : ["+ e.getMessage() +"]" );
			throw new ITMException( e );
		}
		return fileSize;
	}

	public String decodeXMLString( String encodeXMLString ) 
	{
		if ( encodeXMLString == null ) 
		{
			return "";
		}
		return encodeXMLString.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&apos;", "'").replaceAll("&quot;", "\"");
	}

	public String encodeXMLString( String xmlString ) 
	{
		if ( xmlString == null ) 
		{
			return "";
		}
		return xmlString.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
	}
	//Added by Prasad on 01/12/2020 [added some functions to write file, encodeXML, decodeXML] END

	//Added by Prasad on 13/12/2020 [call a service and provide response in json format] START
	public static JSONObject callJsonResponseService( String serviceURL, String paramStr, InputStream postDataStream ) throws JSONException, UnsupportedEncodingException
	{
		BaseLogger.log( "2", null, null, "In callJsonResponseService" );
		String result = "{}";
		try
		{
			if( paramStr != null )
			{
				postDataStream = new ByteArrayInputStream( paramStr.getBytes() );
			}
			byte[] resultBytes = makeRequest( serviceURL, postDataStream );
			result = new String(resultBytes);
			BaseLogger.log( "2", null, null, "JsonResponse result ["+ result +"]" );
		}
		catch (Exception ex)
		{
			BaseLogger.log( "0", null, null, "Exception in ProjectDeployment :: callJsonResponseService : ["+ ex.getMessage() +"]" );
			result = "{\"status\": \"error\", \"results\": \"" + ex + "\"}";
		}
		return new JSONObject(result);
	}

	public byte[] readFileAsBytes( String fileName ) throws Exception
	{
		BufferedInputStream bfr = null;
		FileInputStream fileInputStream = null;
		byte[] byteArray = {0};
		try
		{
			fileInputStream = new FileInputStream( fileName );
			bfr = new BufferedInputStream( fileInputStream );

			byteArray = readStreamAsBytes( bfr );

			bfr.close();
			bfr = null;

			fileInputStream.close();
		}
		catch ( Exception e )
		{
			throw e;
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if(fileInputStream != null)
				{
					fileInputStream.close();
				}
			}
			catch ( Exception e )
			{
				BaseLogger.log("0",null,null, "Exception in releasing file resource :[" + fileName + "]" );
				e.printStackTrace();
			}
			finally
			{
				fileInputStream = null;
			}
		}
		return byteArray;
	}

	public static byte[] makeMultipartRequest( String endPoint, HashMap<String, Object> paramsMap ) throws ClientProtocolException, IOException 
	{
		CloseableHttpClient httpClient = HttpClients.createDefault();
		HttpPost httpPost = new HttpPost( endPoint );

		MultipartEntityBuilder builder = MultipartEntityBuilder.create();
		builder.setMode( HttpMultipartMode.BROWSER_COMPATIBLE );
		if ( paramsMap != null )
		{
			for ( Map.Entry<String, Object> paramEntry : paramsMap.entrySet() )
			{
				String paramName = paramEntry.getKey();
				Object paramValue = paramEntry.getValue();
				if ( paramValue instanceof File )
				{
					File file = (File) paramValue;
					if ( file != null && file.exists() ) 
					{
						FileBody fileBody = new FileBody( file );
						builder.addPart( "file", fileBody );
					}
				}
				else if ( paramValue instanceof String )
				{
					builder.addTextBody( paramName, (String)paramValue, ContentType.TEXT_PLAIN );
				}
			}
		}
		HttpEntity entity = builder.build();
		httpPost.setEntity( entity );

		CloseableHttpResponse closeableHttpResponse = httpClient.execute( httpPost );
		int responseCode = closeableHttpResponse.getStatusLine().getStatusCode();
		BaseLogger.log( "3", null, null, "responseCode : ["+ responseCode +"], ReasonPhrase : ["+ closeableHttpResponse.getStatusLine().getReasonPhrase() +"]" );

		HttpEntity responseEntity = closeableHttpResponse.getEntity();
		InputStream responseInputStream = responseEntity.getContent();
		byte[] responseBytes = readStreamAsBytes(responseInputStream);
		try 
		{
			responseInputStream.close();
			closeableHttpResponse.close();
			httpClient.close();
		}
		catch (Exception ex) 
		{
			System.err.println(ex);
		}
		return responseBytes;
	}

	public static JSONObject callMultipartJsonResponseService( String serviceURL, HashMap<String, Object> paramsMap ) throws JSONException, UnsupportedEncodingException
	{
		BaseLogger.log( "2", null, null, "In callJsonResponseService" );
		String result = "{}";
		try
		{
			byte[] resultBytes = makeMultipartRequest( serviceURL, paramsMap );
			result = new String(resultBytes);
			BaseLogger.log( "2", null, null, "JsonResponse result ["+ result +"]" );
		}
		catch (Exception ex)
		{
			BaseLogger.log( "0", null, null, "Exception in ProjectDeployment :: callJsonResponseService : ["+ ex.getMessage() +"]" );
			result = "{\"status\": \"error\", \"error\": \"" + ex + "\"}";
		}
		return new JSONObject(result);
	}
	//Added by Prasad on 13/12/2020 [call a service and provide response in json format] END

	//Added by Prasad on 20/12/20 [copy file from source to destination location] START
	public void copyFile( File src, File dest ) throws ITMException 
	{
		InputStream is = null; 
		OutputStream os = null; 
		try 
		{
			is = new FileInputStream(src); 
			os = new FileOutputStream(dest);
			byte[] buf = new byte[1024]; 
			int bytesRead; 
			while ((bytesRead = is.read(buf)) > 0) 
			{ 
				os.write(buf, 0, bytesRead); 
			}
		}
		catch (FileNotFoundException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (IOException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally 
		{ 
			try 
			{
				is.close(); 
				os.close();
			}
			catch (IOException e) 
			{
				e.printStackTrace();
			}
		}
	}
	//Added by Prasad on 20/12/20 [copy file from source to destination location] END

	//Added by Prasad on 03/02/2021 [get value from json] START
	/**
	 * 
	 * @param dataJson
	 * @param fieldName
	 * @return
	 * @throws JSONException
	 */
	public static String getJSONValue( JSONObject dataJson, String fieldName ) throws JSONException
	{
		String fieldValue = "";
		if ( dataJson != null )
		{
			if ( dataJson.has( fieldName ) )
			{
				fieldValue = dataJson.getString( fieldName );
			}
			else if ( dataJson.has( fieldName.toLowerCase() ) )
			{
				fieldValue = dataJson.getString( fieldName.toLowerCase() );
			}
			else if ( dataJson.has( fieldName.toUpperCase() ) )
			{
				fieldValue = dataJson.getString( fieldName.toUpperCase() );
			}
		}
		return fieldValue;
	}
	//Added by Prasad on 03/02/2021 [get value from json] END

	//Added By Pankaj T. on 23-02-2021 - to encode or decode wildfly datasource password using Cipher algorithm - start    
	public static String encodeWildflyDataSourcePwd(String secret) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, ITMException
	{
		String retString = "";
		try
		{
			byte[] kbytes = "jaas is the way".getBytes();
			SecretKeySpec key = new SecretKeySpec( kbytes, "Blowfish" );

			Cipher cipher = Cipher.getInstance( "Blowfish" );
			cipher.init(Cipher.ENCRYPT_MODE, key);

			byte[] encoding = cipher.doFinal(secret.getBytes());
			BigInteger n = new BigInteger(encoding);

			retString = n.toString(16);
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", null, null, "In E12GenericUtility.encodeWildflyDataSourcePwd() Exception :["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		BaseLogger.log( "3", null, null, "In E12GenericUtility.decodeWildflyDataSourcePwd() Encoded String :["+retString+"]");
		return retString;
	}

	public static String decodeWildflyDataSourcePwd( String secret ) throws ITMException 
	{
		String retString = "";
		try
		{
			byte[] kbytes = "jaas is the way".getBytes();
			SecretKeySpec key = new SecretKeySpec( kbytes, "Blowfish" );

			BigInteger n = new BigInteger( secret, 16 );
			byte[] encoding = n.toByteArray();

			Cipher cipher = Cipher.getInstance( "Blowfish" );
			cipher.init( Cipher.DECRYPT_MODE, key );

			byte[] decode = cipher.doFinal( encoding );

			retString = new String( decode );
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", null, null, "In E12GenericUtility.decodeWildflyDataSourcePwd() Exception :["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		BaseLogger.log( "3", null, null, "In E12GenericUtility.decodeWildflyDataSourcePwd() Decoded String :["+retString+"]");
		return retString;
	}
	//Added By Pankaj T. on 23-02-2021 - to encode or decode wildfly datasource password using Cipher algorithm - end

	//Added by Samruddhi for email logging 20/05/2021 [Start]
	public void writeCommunicationLog(UserInfoBean userInfo, boolean isException, String commType, String commStatus, String commErrMsg, String sendTo, String sendCC, String sendBCC, String subject, String mailBody, int attachCount, ArrayList<File> attachmentList) throws ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null;
		String tranID = null;
		String comLogOpt = "";
		CommonDBAccessEJB commonDBAccessEJB = new CommonDBAccessEJB();
		ConnDriver connDriver = new ConnDriver();
		try
		{
			conn = connDriver.getConnectDB(userInfo);
			DBAccessEJB dbAccessEJB = new DBAccessEJB();
			comLogOpt = dbAccessEJB.getDBColumnValue("ENTERPRISE", "COMM_LOG_OPT", "ENTERPRISE  = '"+userInfo.getEnterprise()+"'", userInfo.getTransDB());

			tranID = commonDBAccessEJB.generateSeq("comm_log_seq", 20, userInfo.getTransDB());

			if((comLogOpt != null && "A".equalsIgnoreCase(comLogOpt)) || (comLogOpt != null && "E".equalsIgnoreCase(comLogOpt) && isException))
			{
				String sqlQuery = "INSERT INTO COMM_LOG(TRAN_ID,TRAN_DATE,COMM_TYPE,COMM_STATUS,COMM_ERR_MSG,COMM_TO,COMM_CC,COMM_BCC,COMM_SUBJECT,COMM_BODY,ATTACH_COUNT) VALUES(?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement( sqlQuery );

				pstmt.setString(1, tranID);
				pstmt.setTimestamp(2, new java.sql.Timestamp(System.currentTimeMillis()));
				pstmt.setString( 3, commType);
				pstmt.setString( 4, commStatus);
				pstmt.setString( 5, commErrMsg);
				pstmt.setString( 6, sendTo);
				pstmt.setString( 7, sendCC);
				pstmt.setString( 8, sendBCC);
				pstmt.setString( 9, subject);
				pstmt.setString( 10, mailBody);
				pstmt.setInt( 11, attachCount);
				int insCnt = pstmt.executeUpdate();
				if(insCnt > 0)
				{
					conn.commit();
				}
			}

			for(int k = 0; k < attachCount; k++)
			{
				File file = attachmentList.get(k);
				String filePath = file.getAbsolutePath();
				addDocument(filePath,tranID,userInfo,attachCount);
			}
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception message.........:"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( conn != null )
				{
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
	}
	//Added by Samruddhi for email logging 20/05/2021 [End]

	//Added by Samruddhi on 20/05/21 to attach the attachments in standard attachment [Start]
	public String addDocument(String filePath, String tranID, UserInfoBean userInfo, int attachCount)throws Exception
	{
		StringBuffer retXMLStringBuff = null;
		String retString = null;
		byte[] byteArray = {0};
		byte[] videoFrameByteArray = {0};

		BufferedInputStream bfr = null;
		ByteArrayOutputStream bout = null;

		try
		{
			File file = new File(filePath);
			FileInputStream input = new FileInputStream(file);

			bfr = new BufferedInputStream(input);
			bout = new ByteArrayOutputStream();
			int i = -1;
			while((i = bfr.read()) != -1)
			{
				bout.write(i);
			}
			byteArray = bout.toByteArray();

			String refId = tranID;
			String refCol = " ";
			String objName = "comm_log";
			String refSer = "COMLOG";
			String fileType = filePath.substring( filePath.lastIndexOf(".") + 1 );
			String documentType = "EMAIL_ATTACHMENT";
			String attachFileType = fileType;
			String user = userInfo.getLoginCode();
			String docLinkOptn = " "; 
			int noOfPages = 0;
			if ("pdf".equalsIgnoreCase(attachFileType)) 
			{
				InputStream pdfFileStream = new FileInputStream(file);
				PdfReader pdfReader = new PdfReader(pdfFileStream);            
				noOfPages = pdfReader.getNumberOfPages();            
				pdfFileStream.close();
			}
			if ("mp4".equalsIgnoreCase(attachFileType) || "avi".equalsIgnoreCase(attachFileType) || "3gp".equalsIgnoreCase(attachFileType) || "mov".equalsIgnoreCase(attachFileType))
			{
				File videoFile = new File(filePath);
				if (videoFile.exists())
				{
					try
					{
						Picture picFrame = FrameGrab.getNativeFrame(videoFile, 10);
						int height = picFrame.getHeight(), width = picFrame.getWidth();
						BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_3BYTE_BGR);

						byte[] bufferedImageData = ((DataBufferByte) bufferedImage.getRaster().getDataBuffer()).getData();
						int[] picData = picFrame.getPlaneData(0);

						for (int m = 0, len = bufferedImageData.length; m < len; m++)
						{
							bufferedImageData[m] = (byte) picData[m];
						}
						ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
						ImageIO.write(bufferedImage, "png", arrayOutputStream);
						videoFrameByteArray = arrayOutputStream.toByteArray();
					}
					catch (IOException ex)
					{
						BaseLogger.log("0", userInfo,  null,"Exception in videoFrameByteArray 7964 : " + ex);
					}
					catch (Exception ex)
					{
						BaseLogger.log("0", userInfo,  null,"Exception in videoFrameByteArray 7968 : " + ex);
					}
				}
				else
				{
					BaseLogger.log("3", userInfo,  null,"@@@@@ E12GenericUtility :: addDocument() : Video file NOT found at [" + videoFile.toString() + "]");
				}
			}
			String referenceDescription = " ";
			String extractedData = " ";       
			String fileMetadata = " ";

			retXMLStringBuff = new StringBuffer();
			retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			retXMLStringBuff.append("<?xml version=\"1.0\" encoding=\""+CommonConstants.ENCODING+"\"?>");
			retXMLStringBuff.append("<DocumentRoot>");
			retXMLStringBuff.append("<description>Datawindow Root</description>");
			retXMLStringBuff.append("<group0>");
			retXMLStringBuff.append("<description>Group0 description</description>");
			retXMLStringBuff.append("<Header0>");
			retXMLStringBuff.append("<description>Header0 members</description>");
			retXMLStringBuff.append("<header>");
			retXMLStringBuff.append("<ref_id><![CDATA["+refId+"]]></ref_id>");
			retXMLStringBuff.append("<ref_col><![CDATA["+refCol+"]]></ref_col>");
			retXMLStringBuff.append("<obj_name><![CDATA["+objName+"]]></obj_name>");
			retXMLStringBuff.append("<ref_ser><![CDATA["+refSer+"]]></ref_ser>");
			retXMLStringBuff.append("<doc_name><![CDATA["+file.getName()+"]]></doc_name>");
			retXMLStringBuff.append("<doc_type><![CDATA["+fileType+"]]></doc_type>");
			retXMLStringBuff.append("<document_type><![CDATA["+documentType+"]]></document_type>");
			retXMLStringBuff.append("<file_type><![CDATA["+attachFileType+"]]></file_type>");
			retXMLStringBuff.append("<created_by><![CDATA["+user+"]]></created_by>");
			retXMLStringBuff.append("<doc_link_optn><![CDATA[" + docLinkOptn + "]]></doc_link_optn>");
			retXMLStringBuff.append("<ref_descr><![CDATA[" + referenceDescription + "]]></ref_descr>");
			retXMLStringBuff.append("<doc_pages><![CDATA[" + noOfPages + "]]></doc_pages>");
			retXMLStringBuff.append("<extracted_data><![CDATA[" + extractedData + "]]></extracted_data>");
			retXMLStringBuff.append("<file_metadata><![CDATA[" + fileMetadata + "]]></file_metadata>");
			retXMLStringBuff.append("</header>");
			retXMLStringBuff.append("</Header0>");
			retXMLStringBuff.append("</group0>");
			retXMLStringBuff.append("</DocumentRoot>");

			retString = uploadDocument( file, byteArray, videoFrameByteArray, retXMLStringBuff.toString(), userInfo);
		}
		catch (ITMException itme)
		{
			throw itme;
		}
		catch (Exception e)
		{
			throw e;
		}
		finally
		{
			try
			{
				if( bfr != null )
				{
					bfr.close();
					bfr = null;
				}
				if( bout != null )
				{
					bout.close();
					bout = null;
				}
			}
			catch ( Exception e )
			{
				BaseLogger.log("0", null,  null, "Exception in releasing file resource :" );
				e.printStackTrace();
			}
		}

		return retString;
	}

	public String uploadDocument( File uploadFile, byte[] fileBytes, byte[] videoFrameBytes, String xmlStr, UserInfoBean userInfo) throws ITMException
	{
		String response = "";
		try
		{
			String requestURL =  CommonConstants.TOMCAT_HOME + "/ibase/rest/E12ExtService/uploadDocument";
			CloseableHttpClient httpClient = HttpClients.createDefault();
			HttpPost httpPost = new HttpPost( requestURL );

			MultipartEntityBuilder builder = MultipartEntityBuilder.create();
			builder.setMode( HttpMultipartMode.BROWSER_COMPATIBLE );
			builder.addTextBody( "UPLOAD_XML_STR", xmlStr, ContentType.DEFAULT_BINARY );
			builder.addTextBody( "USER_INFO", userInfo.toString(), ContentType.DEFAULT_BINARY );
			builder.addBinaryBody( "fileBytes", fileBytes, ContentType.DEFAULT_BINARY, uploadFile.getName() );
			builder.addBinaryBody( "videoFrameBytes", videoFrameBytes, ContentType.DEFAULT_BINARY, uploadFile.getName() );

			HttpEntity entity = builder.build();
			httpPost.setEntity( entity );

			CloseableHttpResponse closehttpResponse = httpClient.execute( httpPost );
			BaseLogger.log("3", userInfo,  null, "StatusCode : ["+ closehttpResponse.getStatusLine().getStatusCode() +"], ReasonPhrase : ["+ closehttpResponse.getStatusLine().getReasonPhrase() +"]");

			HttpEntity responseEntity = closehttpResponse.getEntity();

			InputStream inStream = responseEntity.getContent();
			response = IOUtils.toString( inStream, CommonConstants.ENCODING );
			inStream.close();
			httpClient.close();
		}
		catch (UnsupportedEncodingException e)
		{
			BaseLogger.log("3", userInfo,  null, "uploadDocument :: UnsupportedEncodingException : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (ClientProtocolException e)
		{
			BaseLogger.log("3", userInfo,  null, "uploadDocument :: ClientProtocolException : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (UnsupportedOperationException e)
		{
			BaseLogger.log("0", userInfo,  null, "uploadDocument :: UnsupportedOperationException : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		catch (IOException e)
		{
			BaseLogger.log("0", userInfo,  null, "uploadDocument :: IOException : ["+ e.getMessage() +"]" );
			e.printStackTrace();
		}
		BaseLogger.log("2", userInfo,  null, "uploadDocument :: response : ["+ response +"]" );
		return response;
	}
	//Added by Samruddhi on 20/05/21 to attach the attachments in standard attachment [End]

	public static String printCurrDateTime()
	{
		DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");  
		LocalDateTime now = LocalDateTime.now();  
		return dtf.format(now);
	}

	//Added by Pankaj R on 27-JUL-21 to return the API call in String [START]
	public static String callStringResponseService( String serviceURL, String paramStr, InputStream postDataStream, String sessionId ) throws JSONException, UnsupportedEncodingException
	{
		BaseLogger.log( "2", null, null, "In callStringResponseService" );
		String result = "";
		try
		{
			if( paramStr != null )
			{
				postDataStream = new ByteArrayInputStream( paramStr.getBytes() );
			}
			byte[] resultBytes = makeRequest( serviceURL, postDataStream, 0 , sessionId);
			result = new String(resultBytes);
			BaseLogger.log( "2", null, null, "String result ["+ result +"]" );
		}
		catch (Exception ex)
		{
			BaseLogger.log( "0", null, null, "Exception in E12GenericUtility :: callStringResponseService : ["+ ex.getMessage() +"]" );
			result = "Error";
		}
		return result;
	}

	public static byte[] makeRequest(String url, InputStream postDataInputStream, int readTimeout, String sessionId) throws IOException 
	{
		byte[] result = new byte[0];

		URL serviceURL = new URL(url);
		HttpURLConnection httpConnection = (HttpURLConnection)serviceURL.openConnection();
		if (readTimeout > 0) {
			httpConnection.setReadTimeout(2000);
		}

		httpConnection.setRequestMethod("GET");
		httpConnection.setDoOutput(true);
		httpConnection.setDoInput(true);
		httpConnection.setUseCaches(false);

		if (postDataInputStream != null) {
			httpConnection.setRequestMethod("POST");
			httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			httpConnection.setRequestProperty("charset", "UTF-8");
			httpConnection.setRequestProperty("Content-Length", Integer.toString(postDataInputStream.available()));
			httpConnection.setRequestProperty( "Cookie", "JSESSIONID=" + URLEncoder.encode( sessionId, CommonConstants.ENCODING) );

			OutputStream connectionOutputStream = httpConnection.getOutputStream();
			E12GenericUtility.copy(postDataInputStream, connectionOutputStream);
		}

		httpConnection.connect();

		InputStream responseStream = httpConnection.getInputStream();
		result = E12GenericUtility.readStreamAsBytes(responseStream);

		return result;
	}
	//Added by Pankaj R on 27-JUL-21 to return the API call in String [END]

	//Added by Jatin M on 14-03-2023 [To create a common method to call python service] - START 
	public String callPythonService(String url, JSONObject queryParamObj, UserInfoBean userInfo ) throws ITMException
	{
		String result = "";
		BaseLogger.log("0",userInfo,  null,"[callPythonService] url ["+url+"] queryParamObj ["+queryParamObj+"]");
		try
		{
			String queryParamStr = null;
			InputStream postDataInputStream = null;
			StringBuffer queryParam = new StringBuffer();
			queryParam.append("jsonData=").append(queryParamObj.toString());
			queryParamStr = queryParam.toString();
			if(queryParamStr != null) 
			{
				postDataInputStream = new ByteArrayInputStream(queryParamStr.getBytes(StandardCharsets.UTF_8));
			}
			byte[] responseData = E12GenericUtility.makeRequest(url, postDataInputStream, 0, null, "application/json");
			result = new String(responseData);  
			BaseLogger.log("0",userInfo,  null,"[callPythonService] result ["+result+"]");
		}
		catch(Exception ex)
		{
			BaseLogger.log( "0", null, null, "Exception in E12GenericUtility :: callPythonService : ["+ ex.getMessage() +"]" );
			throw new ITMException(ex);
		}
		return result;
	}
	//Added by Jatin M on 14-03-2023 [To create a common method to call python service] - END

	//Added by Jatin M on 14-03-2023 [To convert csv data returned from AI response into JSON] - START
	public JSONObject convertCSVToJSON(String csvData, UserInfoBean userInfo) throws ITMException
	{
		JSONObject jsonObject = new JSONObject();
		try
		{
			if("".equalsIgnoreCase(checkNull(csvData)))
			{
				return jsonObject;
			}
			BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] csvData ["+csvData+"]");

			JSONObject prodIdentificationObj = new JSONObject();
			BISDictionary  bis = new BISDictionary();
			prodIdentificationObj = bis.getProductIdentificationAlias(userInfo);
			BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] prodIdentificationObj ["+prodIdentificationObj+"]");
			if(isJSONValid(csvData))
			{
				JSONObject csvObject = new JSONObject(csvData);
				if(csvObject.has("Header") && csvObject.has("Details"))
				{
					jsonObject = replacePhraseInJSON(csvObject, prodIdentificationObj);
					return jsonObject;
				}
			}

			String headerJson = "";
			if(csvData.contains("}"))
			{
				headerJson = (csvData.substring(0, csvData.indexOf("}") + 1)).trim();
			}
			else if(csvData.contains("\"Sr.No"))
			{
				headerJson = (csvData.substring(0, csvData.indexOf("\"Sr.No"))).trim();
			}
			else if(csvData.contains("\"Sr. No"))
			{
				headerJson = (csvData.substring(0, csvData.indexOf("\"Sr. No"))).trim();
			}
			else if(csvData.contains("Sr.No"))
			{
				headerJson = (csvData.substring(0, csvData.indexOf("Sr.No"))).trim();
			}
			else if(csvData.contains("Sr. No"))
			{
				headerJson = (csvData.substring(0, csvData.indexOf("Sr. No"))).trim();
			}
			else
			{
				JSONObject errorObj = new JSONObject();
				errorObj.put("status", "error");
				errorObj.put("message", "Invalid Extraction");
				return errorObj;
			}

			if(isJSONValid(headerJson))
			{
				JSONObject tempObj = new JSONObject(headerJson);
				Iterator iterator = tempObj.keys();
				while(iterator.hasNext())
				{
					String label = checkNull( (String) iterator.next() );
					String value = checkNull( tempObj.optString(label) );
					if(prodIdentificationObj.has(label))
					{
						label = checkNull( prodIdentificationObj.optString(label) );
						//BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] case isJSON replaced label ["+label+"]");
					}
					jsonObject.put(label,value);
				}
			}
			else
			{
				if(headerJson.contains("{") && headerJson.contains("}"))
				{
					headerJson = headerJson.substring(headerJson.indexOf("{") + 1 , headerJson.indexOf("}") );
				}
				headerJson = (headerJson.replaceAll("\"", "")).trim();
				//BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] headerJson ["+headerJson+"]");
				String[] headers = headerJson.split("\n");
				for(String header : headers) 
				{
					String[] values = header.split(":");
					int len = values.length -1;
					String label = checkNull(values[0]);
					String value = checkNull(values[len]);
					if(prodIdentificationObj.has(label))
					{
						label = checkNull( prodIdentificationObj.optString(label) );
						//BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] case !isJSON replaced label ["+label+"]");
					}
					if(value.endsWith(","))
					{
						value = value.substring(0, value.length() - 1);
					}
					jsonObject.put(label,value);	
				}
			}
			//Changes by Jatin M on 29-06-2023 [To change the logic for csv conversion to handle Exception when csvData contains JSONArray] - START
			String dataToConvert = "";
			if( csvData.contains("[") && csvData.contains("]") )
			{
				dataToConvert = csvData.substring(csvData.indexOf("["), csvData.indexOf("]") + 1);
			}
			JSONArray linesArray = new JSONArray();
			if(isJSONArrayValid(dataToConvert))
			{
				JSONArray tempArray = new JSONArray(dataToConvert);
				for(int i = 0; i < tempArray.length(); i++)
				{
					JSONObject tempRowObj = tempArray.optJSONObject(i);
					if(tempRowObj != null)
					{
						JSONObject rowObj = new JSONObject();
						Iterator rowItr = tempRowObj.keys();
						while(rowItr.hasNext())
						{
							String key = checkNull( (String) rowItr.next() );
							String value = checkNull(tempRowObj.optString(key));
							if(prodIdentificationObj.has(key))
							{
								String resValKey = checkNull(prodIdentificationObj.optString(key));
								rowObj.put(resValKey, value);
							}
							else
							{
								rowObj.put(key, value);
							}
						}
						linesArray.put(rowObj);
					}
				}
			}
			if(linesArray.length() == 0)
			{
				if(csvData.contains("\"Sr.No"))
				{
					dataToConvert =csvData.substring(csvData.indexOf("\"Sr.No"), csvData.length());
				}
				else if(csvData.contains("\"Sr. No"))
				{
					dataToConvert =csvData.substring(csvData.indexOf("\"Sr. No"), csvData.length());
				}
				else if(csvData.contains("Sr.No"))
				{
					dataToConvert =csvData.substring(csvData.indexOf("Sr.No"), csvData.length());
				}
				else if(csvData.contains("Sr. No"))
				{
					dataToConvert =csvData.substring(csvData.indexOf("Sr. No"), csvData.length());
				}
				else
				{
					JSONObject errorObj = new JSONObject();
					errorObj.put("status", "error");
					errorObj.put("message", "Invalid Extraction");
					return errorObj;
				}
//    			if(dataToConvert.endsWith("\""))
//        		{
//        			dataToConvert = checkNull( dataToConvert.substring(0, dataToConvert.length()-1) );
//        		}
				if((dataToConvert.toLowerCase()).contains("note:") || (dataToConvert.toLowerCase()).contains("please note"))
				{
					int end = (dataToConvert.toLowerCase()).contains("note:") ? (dataToConvert.toLowerCase()).indexOf("note:") : (dataToConvert.toLowerCase()).indexOf("please note");
					dataToConvert = dataToConvert.substring(0, end);
				}
				String csvHeaders = dataToConvert.substring(0, dataToConvert.indexOf("\n"));
				String[] csvHeadersArr = csvHeaders.split(",");
				String resValue = "";
				for(String csvHeader : csvHeadersArr)
				{
					csvHeader = checkNull(csvHeader);
					if(csvHeader != null && csvHeader.startsWith("\"") && csvHeader.endsWith("\""))
					{
						csvHeader = csvHeader.substring(1, csvHeader.length()-1);
						if(prodIdentificationObj.has(csvHeader))
						{
							resValue = resValue + "\"" +prodIdentificationObj.optString(csvHeader) + "\",";
							//BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] replaced resValue ["+resValue+"]");
						}
						else
						{
							resValue = resValue + "\"" +csvHeader + "\",";
						}
					}
					else
					{
						if(prodIdentificationObj.has(csvHeader))
						{
							resValue = resValue + prodIdentificationObj.optString(csvHeader) + ",";
							//BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] replaced resValue ["+resValue+"]");
						}
						else
						{
							resValue = resValue + csvHeader + ",";
						}
					}
					
				}
				resValue = resValue.substring(0, resValue.length() - 1);
				dataToConvert = dataToConvert.replace(csvHeaders, resValue);
				BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] dataToConvert ["+dataToConvert+"]");
				linesArray = csvToJson(dataToConvert);
//				linesArray = csvToJsonWoLibrary(dataToConvert);
			}
			//Changes by Jatin M on 29-06-2023 [To change the logic for csv conversion to handle Exception when csvData contains JSONArray] - END
			BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] linesArray ["+linesArray+"]");
			//Added by Pankaj T. on 16-01-2024 to calculate quanity to add free in quantity or in in quantity adding itself.
			linesArray = calculateQuantity(linesArray);
			jsonObject.putOpt("lines", linesArray);
			BaseLogger.log("0",userInfo,  null,"[convertCSVToJSON] jsonObject ["+String.valueOf(jsonObject)+"]");
		}
		catch (Exception e) 
		{
			BaseLogger.log( "0", null, null, "Exception in E12GenericUtility :: convertCSVToJSON : ["+ e.getMessage() +"]" );
			throw new ITMException(e);
		}
		return jsonObject;
	}

	private JSONObject replacePhraseInJSON(JSONObject csvObject, JSONObject prodIdentificationObj)
	{
		JSONObject jsonObject = new JSONObject();
		try
		{
			JSONObject headerObj = csvObject.optJSONObject("Header");
			Iterator headerItr = headerObj.keys();
			while(headerItr.hasNext())
			{
				String label = checkNull( (String) headerItr.next() );
				String value = checkNull( headerObj.optString(label) );
				if(prodIdentificationObj.has(label))
				{
					label = checkNull( prodIdentificationObj.optString(label) );
				}
				jsonObject.put(label, value);
			}
			JSONArray detailJSONArr = csvObject.optJSONArray("Details");

			for(int i = 0; i < detailJSONArr.length(); i++)
			{
				JSONObject lineObj = detailJSONArr.optJSONObject(i);
				Iterator lineObjItr = lineObj.keys();
				while(lineObjItr.hasNext())
				{
					String label = checkNull( (String) lineObjItr.next() );
					String value = checkNull( lineObj.optString(label) );
					if(prodIdentificationObj.has(label))
					{
						lineObj.remove(label);
						label = checkNull( prodIdentificationObj.optString(label) );
						lineObj.put(label, value);
					}
				}
			}
			jsonObject.putOpt("lines", detailJSONArr);
		}
		catch(Exception e)
		{
			BaseLogger.log( "0", null, null, "Exception in E12GenericUtility :: replacePhraseInJSON : ["+ e.getMessage() +"]" );
		}
		return jsonObject;
	}
	// Added by Tejas S on 28/July/2023..[Use csv library to convert the csv formatted data to json]...Start
	public JSONArray csvToJson(String csvData) 
	{
		JSONArray jsonArray = new JSONArray();
		try 
		{	
			CSVReader csvReader = new CSVReaderBuilder(new StringReader(csvData)).build();
			String[] headers = csvReader.readNext();
			if (headers == null) 
			{
				throw new RuntimeException("CSV data is empty.");
			}
			String[] row;
			while ((row = csvReader.readNext()) != null) 
			{
				if(row.length > 1)
				{
					JSONObject jsonObject = new JSONObject();
					for (int i = 0; i < headers.length; i++)
					{
						if(headers[i].indexOf("\"") != -1)
						{
							headers[i] = headers[i].replaceAll("\"", "");
						}
						String value = row.length > i ? row[i] : "";
						if(value.indexOf("\"") != -1)
						{
							value = value.replaceAll("\"", "");
						}
						jsonObject.put(checkNull(headers[i]), checkNull(value));
					}
					jsonArray.put(jsonObject);
				}
			}
			BaseLogger.log( "0", null, null, "E12GenericUtility :: csvToJson :jsonArray ["+ jsonArray.toString() +"]" );
		} 
		catch (Exception e) 
		{
			BaseLogger.log( "0", null, null, "E12GenericUtility :: csvToJson :Exception ["+ e +"]" );
			e.printStackTrace();
        }
		return jsonArray; 
	}
	// Added by Tejas S on 28/July/2023..[Use csv library to convert the csv formatted data to json]...End

	public JSONArray csvToJsonWoLibrary(String csvData)
	{
		JSONArray linesArray = new JSONArray();
		try 
		{
			String[] csvLines = csvData.split("\n");
			String[] headerRow = new String[0];

			for (int i = 0; i < csvLines.length; i++) 
			{
				String row = csvLines[i];
				if(row.contains(","))
				{
					String[] columns = row.split(",");
					if (i == 0) 
					{
						headerRow = columns;
					}
					else
					{
						JSONObject lineObject = new JSONObject();
						for(int j = 0 ; j < headerRow.length; j++)
						{
							String value = "";
							if(j < columns.length)
							{
								value = checkNull( columns[j] );
								if(value.indexOf("\"") != -1)
								{
									value = value.replaceAll("\"", "");
								}
							}
							String label = checkNull( headerRow[j] );
							if(label.indexOf("\"") != -1)
							{
								label = label.replaceAll("\"", "");
							}
							lineObject.put(label, value);
						}
						linesArray.put(lineObject);
					}
				}
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log( "0", null, null, "Exception in E12GenericUtility :: csvToJson : ["+ e.getMessage() +"]" );
		}
		return linesArray;
	}
	//Added by Jatin M on 14-03-2023 [To convert csv data returned from AI response into JSON] - END
	
	//Added by Pankaj T. on 16-01-2024 to calculate quanity to add free in quantity or in in quantity adding itself - start
	public JSONArray calculateQuantity( JSONArray linesArray ) throws ITMException
	{
		try
		{
			BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() linesArray before update : ["+linesArray+"]");
			for( int i = 0; i < linesArray.length(); i++ )
			{
				JSONObject lineJsonObject = linesArray.optJSONObject(i);
				BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() lineJsonObject : ["+lineJsonObject+"]");

				String quantity = checkNull( lineJsonObject.getString("quantity") );
				BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() quantity : ["+quantity+"]");
				
				double qty = 0;
				if( quantity != null && quantity.length() > 0 )
				{
					if( quantity.indexOf(",") != -1 )
					{
						quantity = quantity.replace(",", "");
					}
					
					//Pattern pattern = Pattern.compile("\\p{Alnum}+");
					//Matcher matcher = pattern.matcher(quantity);
					
					//if( !matcher.matches() )
					if( !quantity.matches("[0-9]+") ) 
					{
						BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() quantity contains non numeric values");
						for( char c : quantity.toCharArray() )
						{
						    if( !Character.isDigit(c) && !("+".equalsIgnoreCase(""+c)) && !(".".equalsIgnoreCase(""+c)) )
						    {
						    	quantity = quantity.replace(""+c, "");
						    }
						}
					}
					BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() quantity after replace non numeric values : ["+quantity+"]");
					
					quantity = checkNull( quantity );
					if( quantity != null && quantity.length() > 0 )
					{
						if( quantity.indexOf("+") != -1 )
						{
							String preQuqntity = checkNull( quantity.substring( 0, quantity.indexOf("+") ) );
							BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() preQuqntity : ["+preQuqntity+"]");
							
							String postQuqntity = checkNull( quantity.substring( quantity.indexOf("+") + 1 ) );
							BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() postQuqntity : ["+postQuqntity+"]");
							
							double preQty = 0;
							if( preQuqntity != null && preQuqntity.length() > 0 )
							{
								preQty = Double.parseDouble(preQuqntity);
								BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() preQty : ["+preQty+"]");
							}
							
							double postQty = 0;
							if( postQuqntity != null && postQuqntity.length() > 0 )
							{
								postQty = Double.parseDouble(postQuqntity);
								BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() postQty : ["+postQty+"]");
							}
							
							qty = preQty + postQty;
						}
						else
						{
							qty = Double.parseDouble(quantity);
						}
						BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() qty : ["+qty+"]");
						if( lineJsonObject.has("FREE") )
						{
							String FREE = checkNull( lineJsonObject.getString("FREE") );
							BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() FREE : ["+FREE+"]");
							
							if( FREE != null && FREE.length() > 0 && !FREE.contains("%") )
							{
								if( FREE.indexOf(",") != -1 )
								{
									FREE = FREE.replace(",", "");
								}
								
								if( !FREE.matches("[0-9]+") ) 
								{
									BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() FREE contains non numeric values");
									for( char c : FREE.toCharArray() )
									{
									    if( !Character.isDigit(c) && !("+".equalsIgnoreCase(""+c)) && !(".".equalsIgnoreCase(""+c)) )
									    {
									    	FREE = FREE.replace(""+c, "");
									    }
									}
									BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() FREE after replace non numeric values : ["+FREE+"]");
								}
								
								FREE = checkNull(FREE);
								if( FREE != null && FREE.length() > 0 )
								{
									double free = 0;
									if( FREE.indexOf("+") != -1 )
									{
										String preFREE = checkNull( FREE.substring( 0, FREE.indexOf("+") ) );
										BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() preFREE : ["+preFREE+"]");
										
										String postFREE = checkNull( FREE.substring( FREE.indexOf("+") + 1 ) );
										BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() postFREE : ["+postFREE+"]");
										
										double preFree = 0;
										if( preFREE != null && preFREE.length() > 0 )
										{
											preFree = Double.parseDouble(preFREE);
											BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() preFree : ["+preFree+"]");
										}
										
										double postFree = 0;
										if( postFREE != null && postFREE.length() > 0 )
										{
											postFree = Double.parseDouble(postFREE);
											BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() postFree : ["+postFree+"]");
										}
										
										free = preFree + postFree;
									}
									else
									{
										free = Double.parseDouble(FREE);
									}
									BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() free : ["+free+"]");
									
									qty = qty + free;
									BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() qty after adding FREE : ["+qty+"]");
								}
							}
						}
					}
				}
				lineJsonObject.put("quantity", (int)qty);
				BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() lineJsonObject after adding free: ["+lineJsonObject+"]");
			}
			BaseLogger.log( "3", null, null, "E12GenericUtility.calculateQuantity() linesArray after update : ["+linesArray+"]");
		}
		catch (Exception e)
		{
			BaseLogger.log( "0", null, null, "E12GenericUtility.calculateQuantity() Exception:["+E12GenericUtility.getStackTrace(e)+"]");
			throw new ITMException(e);
		}
		return linesArray;
	}
	//Added by Pankaj T. on 16-01-2024 to calculate quanity to add free in quantity or in in quantity adding itself - end

	// Added by Gagan B. to check whether XML is valid or not [START] on 22-MAY-23
	public boolean validateXML(String xmlString) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			builder.parse(new InputSource(new StringReader(xmlString)));
			return true;
		} catch (ParserConfigurationException | SAXException | IOException e) {
			return false;
		}
	}
	// Added by Gagan B. to check whether XML is valid or not [END] on 22-MAY-23

	// Added by Gagan B. for some common methods related to XML/JSON manupilation and API call via unirest 14-JUN-23 -- [START] 
	public String getDetailXMLDomString( String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo )throws RemoteException,ibase.webitm.utility.ITMException, ITMException
	{
		String resultString = "";
		//Added By Nilesh Start ::12-05-2017
		MasterStatefulLocal masterStateful=null;
		//Added By Nilesh End ::12-05-2017
		try
		{
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfo );
			resultString = masterStateful.getDetailXMLDomString( objName, objContext, editFlag, pkValues, argFieldValues );
		}
		catch (NamingException e)
		{
			BaseLogger.log("0",null,null,"NamingException :: getDetailXMLDomString() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		//Added By Nilesh Start ::12-05-2017
		finally
		{
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
		}
		//Added By Nilesh End ::12-05-2017
		return resultString;
	}

	private InitialContext getInitialContext() throws ITMException	
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			BaseLogger.log("0",null,null, "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null, "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}

	public String getSortedJson(String xmlStr,String objName, UserInfoBean userInfo) {
		StringBuilder json = new StringBuilder("{\"Root\":{");
		Document document = convertStringToDocument(xmlStr);
		try {
			UploadFileEJB uploadFileEJB = new UploadFileEJB();
			Map<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, userInfo);
			Map<String,List<String>> detailDataMap = new TreeMap<>();
			for(int mapIndex =1;mapIndex<=formDetailInfo.size();mapIndex++)
			{
				NodeList detailNodeList = document.getElementsByTagName("Detail"+mapIndex);
				for(int detailIndex=0;detailIndex<detailNodeList.getLength();detailIndex++) {
					Node detailNode = detailNodeList.item(detailIndex);
					BaseLogger.log("3", null, null,"DetailNode="+detailNode.getNodeName());
					NodeList detailList = detailNode.getChildNodes();
					String data = "";
					for(int index=0;index<detailList.getLength();index++) 
					{
						Node child = detailList.item(index);

						if(child.getTextContent().contains("{") && child.getTextContent().contains("}") ) {
							BaseLogger.log("3", null, null,"Found Json obj"+child.getTextContent());
							String jsonData ="\""+ child.getTextContent().replace("\"", "\\\"")+"\"";
							BaseLogger.log("3", null, null,"Found Json obj"+jsonData);
							data+="\""+child.getNodeName()+"\":"+jsonData+",";
						}
						else if(child.getTextContent().equals("\"\"")) {
							data+="\""+child.getNodeName()+"\":"+child.getTextContent()+",";
						}
						else {
							data+="\""+child.getNodeName()+"\":\""+child.getTextContent()+"\",";
						}
						/*if(child.getTextContent().equals("\"\"")) {
						  data+="\""+child.getNodeName()+"\":"+child.getTextContent()+",";
					  }
					  else {
					  data+="\""+child.getNodeName()+"\":\""+child.getTextContent()+"\",";
					  }*/

					}

					if(!data.equals("")) {
						data="{"+data.substring(0,data.length()-1)+ "}";  
					}
					// BaseLogger.log("3", null, null,"Data Json=="+data);
					//

					//BaseLogger.log("3", null, null,"data string="+detailNode.getNodeName()+"["+data+"}");
					if(!detailDataMap.containsKey(detailNode.getNodeName())) {
						//BaseLogger.log("3", null, null,"Key Not Found==");
						List<String>list = new ArrayList<>();
						list.add(data);
						detailDataMap.put(detailNode.getNodeName(), list);
					}
					else
					{
						//BaseLogger.log("3", null, null,"Key Found==");
						List<String>list = detailDataMap.get(detailNode.getNodeName());
						list.add(data);

						detailDataMap.put(detailNode.getNodeName(),list);
					}
				}
			}

			detailDataMap.forEach((key,value)->{
				//BaseLogger.log("3", null, null,"Key json="+key);
				json.append("\""+key+"\":");
				//BaseLogger.log("3", null, null,"value json="+value);
				json.append(value+",");
			});
			json.append("}}");
			//BaseLogger.log("3", null, null,"Detail Data with quot treeMap"+detailDataMap.toString());

			//BaseLogger.log("3", null, null,"Formatted with old  JSON String==["+json);

		}catch(Exception e) {
			BaseLogger.log("3", null, null,"Error in getSortedJson()"+e.getMessage());
		}

		return json.toString().replace("],}", "]}");
	}

	private  Document convertStringToDocument(String xmlStr) {
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();  
		DocumentBuilder builder;  
		try  
		{  
			builder = factory.newDocumentBuilder();  
			Document doc = builder.parse( new InputSource( new StringReader( xmlStr ) ) ); 
			return doc;
		} catch (Exception e) {  
			e.printStackTrace();  
		} 
		return null;
	}

	public String getFormattedXML(String result,String objName, UserInfoBean userInfo) {//with multiple rows
		StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?><Root>");
		try {
			UploadFileEJB uploadFileEJB = new UploadFileEJB();

			DocumentBuilder builder =  DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
			Map<Integer, String> formDetailInfo = uploadFileEJB.getFormWiseTitleMap(objName, userInfo);
			BaseLogger.log("3", null, null,"formDetailInfoMAP=["+formDetailInfo+"]");
			for(int mapIndex =1;mapIndex<=formDetailInfo.size();mapIndex++)
			{
				NodeList detailNodeList = document.getElementsByTagName("Detail"+mapIndex);
				BaseLogger.log("3", null, null,"Detail node count="+detailNodeList.getLength());
				for(int detailIndex=0;detailIndex<detailNodeList.getLength();detailIndex++)
				{
					if(!detailNodeList.item(detailIndex).getNodeName().contains("#")) 
					{
						Node detailNode = detailNodeList.item(detailIndex);
						xml.append("<"+detailNode.getNodeName()+">");

						NodeList detailChildList = detailNode.getChildNodes();
						for(int childIndex=0;childIndex<detailChildList.getLength();childIndex++) {
							Node childNode = detailChildList.item(childIndex);
							if(!childNode.getNodeName().contains("#") && !childNode.getNodeName().equalsIgnoreCase("attribute")) {
								String data="\"\"";
								if(childNode.hasChildNodes()) {
									data = childNode.getFirstChild().getTextContent();
								}
								xml.append("<"+childNode.getNodeName()+"><![CDATA["+data+"]]>");
								xml.append("</"+childNode.getNodeName()+">");
							}//end check child empty
						}
						xml.append("</"+detailNode.getNodeName()+">");
					}
				}//end check empty node
			}
			xml.append("</Root>");
		}catch(Exception e) {
			e.printStackTrace();
		}
		BaseLogger.log("3", null, null,"xml String output="+xml.toString());
		return xml.toString();
	} 
	//makeApiCall

	public static HttpResponse<String> makeApiCall(String apiURL, Map<String, String> headers, JSONObject parameters) {
		Unirest.setTimeouts(0, 0);
		HttpResponse<String> response = null;
		BaseLogger.log("3", null, null,"Inside makeApiCall");
		try {
			BaseLogger.log("3", null, null,"Inside makeApiCall try");
			Unirest.setTimeouts(0, 0);
			response = Unirest.post(apiURL)
					.headers(headers)
					.body(parameters)
					.asString();

		} catch (UnirestException e) {
			e.printStackTrace();
		}
		return response;
	}
	// Added by Gagan B. for some common methods related to XML/JSON manupilation and API call via unirest 14-JUN-23 -- [END]

	// Added by Gagan B. method removes properties from JSON which have "" as values 22-JUN-23 -- [START]
	public void removePropertiesWithEmptyValues(JSONObject jsonObject) throws JSONException {
		JSONArray keys = jsonObject.names();
		if (keys != null) {
			for (int i = 0; i < keys.length(); i++) {
				String key = keys.getString(i);
				Object value = jsonObject.get(key);

				if (value instanceof JSONObject) {
					removePropertiesWithEmptyValues((JSONObject) value);
				} else if (value instanceof JSONArray) {
					JSONArray array = (JSONArray) value;
					for (int j = 0; j < array.length(); j++) {
						if (array.get(j) instanceof JSONObject) {
							removePropertiesWithEmptyValues(array.getJSONObject(j));
						}
					}
				} else if (value instanceof String && ((String) value).isEmpty()) {
					jsonObject.remove(key);
				} else if (value == null) {
					jsonObject.remove(key);
				}
			}
		}
	}
	// Added by Gagan B. method removes properties from JSON which have "" as values 22-JUN-23 -- [END]

	// Added by Gagan B. using regular expression to remove empty properties from JSON to maintain order after removing empty properties [START]
	public static String removeEmptyProperties(String jsonString) {
		String pattern = "\"(\\w+)\":\\s*\"\",?";

		Pattern regex = Pattern.compile(pattern);
		Matcher matcher = regex.matcher(jsonString);

		String result = matcher.replaceAll("");

		result = result.replaceAll(",\\s*}", "}");

		return result;
	}
	// Added by Gagan B. using regular expression to remove empty properties from JSON to maintain order after removing empty properties [END]

	// Added by Gagan B. method returns how many detail object present in JSON 22-JUN-23 -- [START]
	public int jsonDetailCount(String jsonData) {
		int detailCount = 0;
		try {
			JSONObject jsonObject = new JSONObject(jsonData);
			JSONObject rootObject = jsonObject.getJSONObject("Root");

			for (int i = 1; i <= rootObject.length(); i++) {
				if (rootObject.has("Detail" + i)) {
					detailCount++;
				}
			}

			BaseLogger.log( "3", null, null, "Number of Detail objects: " + detailCount);
		} catch (Exception e) {

		}
		return detailCount;
	}
	// Added by Gagan B. method returns how many detail object present in JSON 22-JUN-23 -- [END]

	// Added by Gagan B. method formats the order of JSON -- [22-JUN-23/START]
	public String jsonFormatter(String jsonData, int detailCount) {
		String finalJson = "";
		try {
			JSONObject originalObject = new JSONObject(jsonData);

			StringBuilder jsonBuilder = new StringBuilder();
			jsonBuilder.append("{ \"Root\": {");

			boolean isFirstDetail = true;
			for (int i = 1; i <= detailCount; i++) {
				String detailArrayName = "Detail" + i;
				if (originalObject.getJSONObject("Root").has(detailArrayName)) {
					JSONArray jsonArray = originalObject.getJSONObject("Root").getJSONArray(detailArrayName);

					if (!isFirstDetail) {
						jsonBuilder.append(",");
					}

					jsonBuilder.append("\"").append(detailArrayName).append("\": ").append(jsonArray.toString());
					isFirstDetail = false;
				}
			}

			jsonBuilder.append("}}");
			finalJson = jsonBuilder.toString();

			BaseLogger.log( "3", null, null, "Formatted JSON: " + finalJson);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return finalJson;
	}
	// Added by Gagan B. method formats the order of JSON -- [22-JUN-23/END]

	// Added by Gagan B. on 8th July for adding isDataUpload="true" in xml for mimicing upload utility [START]
	public static void addisDataUploadAttribute(Document document) {
		// Get all the Detailn tags
		NodeList detailList = document.getElementsByTagName("*");
		for (int i = 0; i < detailList.getLength(); i++) {
			Element detail = (Element) detailList.item(i);

			// Check if the tag name starts with "Detail"
			if (detail.getTagName().startsWith("Detail")) {
				// Get all the child nodes of the Detailn tag
				NodeList children = detail.getChildNodes();
				for (int j = 0; j < children.getLength(); j++) {
					Node child = children.item(j);

					// Check if the child node is an element
					if (child.getNodeType() == Node.ELEMENT_NODE) {
						Element element = (Element) child;

						// Add the attribute isDataUpload="true"
						element.setAttribute("isDataUpload", "true");
					}
				}
			}
		}
	}

	public static String documentToString(Document document) throws TransformerException {
		TransformerFactory factory = TransformerFactory.newInstance();
		Transformer transformer = factory.newTransformer();
		transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");

		StringWriter writer = new StringWriter();
		transformer.transform(new DOMSource(document), new StreamResult(writer));

		return writer.toString();
	}
	// Added by Gagan B. on 8th July for adding isDataUpload="true" in xml for mimicing upload utility [END]

	// Added by Gagan B. on 11th July : methods for checking whether file exists and read file contents [START]
	public static boolean fileExists(String filePath) {
		Path path = Paths.get(filePath);
		return Files.exists(path);
	}

	public static String readFileContents(String filePath) {
		StringBuilder content = new StringBuilder();

		try (BufferedReader reader = new BufferedReader(new FileReader(filePath))) {
			String line;
			while ((line = reader.readLine()) != null) {
				content.append(line);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}

		return content.toString();
	}
	// Added by Gagan B. on 11th July : methods for checking whether file exists and read file contents [END]

	// Added by Gagan B. to get API URL for 3rd party external API call's. :17th-JULY-23 [START]
	public String getExternalAPIURL(String appId, String serviceClass, UserInfoBean userInfo)
			throws ITMException, SQLException {
		String endpoint = "";

		Connection connection = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfo.getTransDB());

			String getAPIDetailsSQL = "SELECT ENDPOINT, SERVICE_SETTING FROM AUTH_APPS_API WHERE APP_ID = ? AND SERVICE_CLASS = ?";
			pstmt = connection.prepareStatement(getAPIDetailsSQL);
			pstmt.setString(1, appId);
			pstmt.setString(2, serviceClass);
			rs = pstmt.executeQuery();

			while (rs.next()) {
				String serviceSettingJson = rs.getString("service_setting");
				if (serviceSettingJson != null) {
					try {
						BaseLogger.log("3", userInfo, null,
								"E12ExternalAPICall.getExternalAPIURL() serviceSettingJson = [" + serviceSettingJson
								+ "]");
						JSONObject jsonObject = new JSONObject(serviceSettingJson);
						if (jsonObject.has("isExternal") && jsonObject.getString("isExternal").equals("true")) {
							endpoint = rs.getString("endpoint");
							BaseLogger.log("3", userInfo, null,
									"E12ExternalAPICall.getExternalAPIURL() endpoint = [" + endpoint + "]");
							return endpoint;
						}
					} catch (JSONException e) {
						e.printStackTrace();
					}
				}
			}

			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			connection.close();
			connection = null;

		} catch (Exception e) {
			BaseLogger.log("0", userInfo, null, "E12ExternalAPICall.callLoginApiAndSetSession() Exception = ["
					+ E12GenericUtility.getStackTrace(e) + "]");
			throw new ITMException(e);
		} finally {
			if (connection != null) {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (connection != null) {
					connection.close();
					connection = null;
				}
			}
		}
		return endpoint;
	}
	// Added by Gagan B. to get API URL for 3rd party external API call's. :17th-JULY-23 [END]
	//Added by Jatin M on 20-Jul-2023 [To convert csv data into excel file] - START
	public String convertCSVToExcel(String csvData, String docName, String docType, String hostURL) throws ITMException
	{
		String serverFilePath = "";
		try 
		{
			docType = "".equalsIgnoreCase(checkNull(docType)) ? "Order" : docType;
			XSSFWorkbook workbook = new XSSFWorkbook();
			XSSFSheet sheet = workbook.createSheet(docType);
			BaseLogger.log("3",null,null,"E12GenericUtility.convertCSVToExcel() csvData :["+ csvData +"]");
			// Added by Tejas S on 03/Aug/2023..[Use csv library to convert the csv formatted data to Excel]...Start
			CSVReader csvReader = new CSVReaderBuilder(new StringReader(csvData)).build();
			String[] header = csvReader.readNext();

			Row headerRow = sheet.createRow(0);
			for (int i = 0; i < header.length; i++) 
			{
				Cell cell = headerRow.createCell(i);
				cell.setCellValue(header[i]);
			}
			String[] nextLine;
			int rowIndex = 1;
			while ((nextLine = csvReader.readNext()) != null)
			{
				Row row = sheet.createRow(rowIndex++);
				for (int i = 0; i < nextLine.length; i++) 
				{
					Cell cell = row.createCell(i);
					cell.setCellValue(nextLine[i]);
				}
			}

			//			String[] rows = csvData.split("\n");
			//			for(int i = 0; i < rows.length; i++)
			//			{
			//				String row = rows[i];
			//				Row excelRow = sheet.createRow(i);
			//				String[] columns = row.split(",");
			//				for(int j = 0; j < columns.length; j++)
			//				{
			//					String column = columns[j];
			//					Cell excelColumn = excelRow.createCell(j);
			//					excelColumn.setCellValue(column);
			//				}
			//			}
			// Added by Tejas S on 03/Aug/2023..[Use csv library to convert the csv formatted data to Excel]...End

			if( "".equals(checkNull(docName)) )
			{
				docName = "Order.xlsx";
			}
			else
			{
				docName = docName.substring(0, docName.lastIndexOf("."));
				docName = docName + ".xlsx";
			}
			BaseLogger.log("3",null,null,"E12GenericUtility.convertCSVToExcel() docName :["+ docName +"]");
			String folderPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator +"default"+ File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "ibase.war" + File.separator + "upload_orders";
			File file = new File(folderPath);
			if( !file.exists() )
			{
				file.mkdirs();
			}
			String filePath = folderPath + File.separator + docName;
			try(FileOutputStream fileOutputStream = new FileOutputStream(filePath)) 
			{
				if( workbook.getNumberOfSheets() > 0 )
				{
					workbook.write(fileOutputStream);
					//serverFilePath = CommonConstants.TOMCAT_HOME + File.separator + "ibase" + File.separator + "upload_orders" + File.separator + docName;
					serverFilePath = hostURL + File.separator + "ibase" + File.separator + "upload_orders" + File.separator + docName;
				}
			}
			catch(Exception exp)
			{
				BaseLogger.log("0",null,null,"E12GenericUtility.convertCSVToExcel() Exception@@@:["+E12GenericUtility.getStackTrace(exp)+"]");
				throw new ITMException(exp);
			}
		} 
		catch (Exception e) 
		{
			BaseLogger.log("0", null, null, "E12GenericUtility.convertCSVToExcel() Exception = ["
					+ E12GenericUtility.getStackTrace(e) + "]");
			throw new ITMException(e);
		}
		return serverFilePath;
	}
	//Added by Jatin M on 20-Jul-2023 [To convert csv data into excel file] - END

	// Added by Gagan B. on 20-JUL-23: method to update dbID attribute . [START]
	public static String updateDbIDAttribute(String xmlString, String pkValues) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			Document doc = builder.parse(new InputSource(new StringReader(xmlString)));

			NodeList detailNodes = doc.getElementsByTagName("Detail1");
			Element detailElement = (Element) detailNodes.item(0);

			String dbIDValue = detailElement.getAttribute("dbID");
			if (dbIDValue.isEmpty()) {
				detailElement.setAttribute("dbID", pkValues);

				TransformerFactory transformerFactory = TransformerFactory.newInstance();
				Transformer transformer = transformerFactory.newTransformer();
				StringWriter writer = new StringWriter();
				transformer.transform(new DOMSource(doc), new StreamResult(writer));
				return writer.toString();
			} else {
				return xmlString; // Changes by Gagan B. on 01-NOV-23 to return the xmlString as it is if dbID value is already present.
			}
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
	// Added by Gagan B. on 20-JUL-23: method to update dbID attribute . [END]

	// Added by Gagan B. on 21-JUL-23: method to sort xmlString on basis of tabSequence Attribute . [START]
	public static String sortXmlByTabSequence(String xmlString) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = factory.newDocumentBuilder();
			InputSource inputSource = new InputSource(new StringReader(xmlString));
			Document document = builder.parse(inputSource);

			NodeList detailNodes = document.getDocumentElement().getChildNodes();
			List<Element> detailElements = new ArrayList<>();
			for (int i = 0; i < detailNodes.getLength(); i++) {
				Node node = detailNodes.item(i);
				if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().startsWith("Detail")) {
					detailElements.add((Element) node);
				}
			}

			for (Element detailElement : detailElements) {
				NodeList childNodes = detailElement.getChildNodes();
				List<Element> childElements = new ArrayList<>();
				for (int i = 0; i < childNodes.getLength(); i++) {
					Node childNode = childNodes.item(i);
					if (childNode.getNodeType() == Node.ELEMENT_NODE) {
						childElements.add((Element) childNode);
					}
				}
				List<Element> sortedChildElements = childElements.stream()
						.sorted(Comparator.comparingInt(e -> {
							String tabSequenceAttr = e.getAttribute("tabSequence");
							return tabSequenceAttr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(tabSequenceAttr);
						}))
						.collect(Collectors.toList());

				for (Element childElement : childElements) {
					detailElement.removeChild(childElement);
				}

				for (Element sortedChildElement : sortedChildElements) {
					detailElement.appendChild(sortedChildElement);
				}
			}

			TransformerFactory transformerFactory = TransformerFactory.newInstance();
			Transformer transformer = transformerFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			DOMSource source = new DOMSource(document);
			StringWriter writer = new StringWriter();
			StreamResult result = new StreamResult(writer);
			transformer.transform(source, result);

			return writer.toString();
		} catch (Exception e) {
			e.printStackTrace();
			return xmlString;
		}
	}
	// Added by Gagan B. on 21-JUL-23: method to sort xmlString on basis of tabSequence Attribute . [END]

	// Added by Gagan B. on 21-JUL-23: to get count from OBJ_FORMS . [START]
	public int getObjFormCount(String objName, UserInfoBean userInfo) throws SQLException {
		int count = 0;
		Connection connection = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {
			ConnDriver connDriver = new ConnDriver();
			connection = connDriver.getConnectDB(userInfo.getTransDB());

			String getFailedTranIDSQL = "SELECT COUNT(*) AS ROW_COUNT FROM OBJ_FORMS WHERE WIN_NAME = ?";
			pstmt = connection.prepareStatement(getFailedTranIDSQL);
			pstmt.setString(1, objName);
			rs = pstmt.executeQuery();

			if (rs.next()) {
				count = rs.getInt("ROW_COUNT");
				BaseLogger.log( "3", null, null, "Row count: " + count);
			}


		} catch (Exception exp) {

		} finally {
			if (connection != null) {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (connection != null) {
					connection.close();
					connection = null;
				}
			}
		}
		return count;
	}
	// Added by Gagan B. on 21-JUL-23: to get count from OBJ_FORMS . [END]

	public String getErrorJson( String columnName, String msgNo, String userId )
	{
		BaseLogger.log( "3", null, null, "getErrorJson :: line no 9387: ["+ columnName +"]" );
		ConnDriver connDriver = null;
		Connection conn = null;
		String errStringJson;
		Statement stmt = null;
		Statement stmt1 = null;
		Statement stmt2 = null;
		ResultSet rs = null;
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		String sqlQuery,sqlQuery1;
		String msgType = "";
		String msgString = "";
		String msgDescription = "";
		String profileId = "";
		String errSource = "";
		String tempMsgType = "";
		String msgOption = "";
		String msgTime = "";

		String redirerr = "";
		String soundPlay = "";
		try
		{
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			connDriver = null;
			sqlQuery = "SELECT MSG_TYPE,MSG_STR,MSG_DESCR,MSG_OPT,MSG_TIME,ALARM,ERR_SOURCE FROM MESSAGES WHERE MSG_NO='" + msgNo + "'";
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sqlQuery);
			if (rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
				msgString = rs.getString("MSG_STR");
				msgDescription = rs.getString("MSG_DESCR");
				errSource = rs.getString("ERR_SOURCE");
				msgOption = rs.getString("MSG_OPT");
				msgTime = rs.getString("MSG_TIME");
				soundPlay = rs.getString("ALARM");
			}
			else
			{
				msgDescription = "Message Id not found" + " [" + msgNo + "]" ;
				msgType = "E";
				msgString = "";
			}

			if (msgType.equals("E") || msgType.trim().length() == 0)
			{
				sqlQuery1 = "SELECT PROFILE_ID FROM USERS WHERE CODE='" + userId + "'";
				stmt1 = conn.createStatement();
				rs1 = stmt1.executeQuery(sqlQuery1);
				if (rs1.next())
				{
					profileId=rs1.getString("profile_id");
					if (profileId == null)
					{
						profileId= "";
					}
					sqlQuery1 = "SELECT MSG_TYPE FROM MESSAGES_LEVEL WHERE MSG_NO='" + msgNo.trim() + "' AND ( PROFILE_ID='" + profileId.trim() + "' OR PROFILE_ID = 'X' )"; //$NON-NLS-2$ //$NON-NLS-3$
					stmt2 = conn.createStatement();
					rs2 = stmt2.executeQuery(sqlQuery1);
					if (rs2.next())
					{
						tempMsgType = rs2.getString("msg_type");
					}
					rs2.close();
				}
				rs1.close();
				if (tempMsgType!=null && tempMsgType.trim().length()>0)
				{
					msgType = tempMsgType;
				}
			}
			if (msgType.equals("W"))
			{
				msgString = "Warning : " + msgString;
			}
			else if (msgType.equals("P"))
			{
				msgString = "Prompt : " + msgString;
			}
			else if(msgType.equals("F"))
			{
				msgString = "Information : " + msgString;
			}
			else
			{
				msgType = "E";
				msgString = "Error : " + msgString;
			}
			if (errSource!=null && errSource.trim().equals("D"))
			{
				msgDescription = msgDescription +  " * From Database ";
			}
			if (redirerr==null || redirerr.trim().length()==0)
			{
				redirerr = "1";
			}
			if (msgOption!=null && msgOption.trim().equals("M"))
			{
				if (redirerr.trim().equals("1"))
				{
					redirerr = "2";
				}
				else
				{
					redirerr = "1";
				}
			}
			if (rs != null)
			{
				rs.close();
				stmt.close();
			}
			if (rs1 != null)
			{
				rs1.close();
				stmt1.close();
			}
			if (rs2 != null)
			{
				rs2.close();
				stmt2.close();
			}
			conn.close();
		}
		catch(ITMException itme)
		{
			BaseLogger.log("0",null,null,"ITMException : [E12GenericUtility][getErrorJson] :==>\n"+itme.getMessage());
//			throw itme;
		}
		catch(SQLException se)
		{
			msgDescription = se.getMessage();
			msgType = "";
			msgString = "";
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getErrorJson] :==>\n"+se.getMessage());
			se.printStackTrace();
//			throw new ITMException(se);
		}
		catch(Exception e)
		{
			BaseLogger.log("0",null,null,"Exception : [E12GenericUtility][getErrorJson] :==>\n"+e.getMessage());
			e.printStackTrace();
//			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
				if ( stmt != null )
				{
					stmt.close();
					stmt = null;
				}
				if ( stmt1 != null )
				{
					stmt1.close();
					stmt1 = null;
				}
				if ( stmt2 != null )
				{
					stmt2.close();
					stmt2 = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( rs2 != null )
				{
					rs2.close();
					rs2 = null;
				}
			}
			catch (SQLException e)
			{
				e.printStackTrace();
//				throw new ITMException(e);
			}
		}

		errStringJson = getErrorJson( msgNo, msgType, columnName, msgString, msgDescription, msgString, msgOption, msgTime, soundPlay, errSource, redirerr );

		return errStringJson;
	}

	public String getErrorJson( String msgNo, String msgType, String columnName, String message, String msgDescr, String trace, String msgOption, String msgTime, String soundPlay, String errSource, String redirErr )
	{
		JSONObject errJson = new JSONObject();
		try
		{
			JSONObject rootJson = new JSONObject();
			JSONArray errors = new JSONArray();
			JSONObject errorJson = new JSONObject();
			JSONObject errorsJson = new JSONObject();
			columnName = checkNull( columnName );
			if ( columnName.length() == 0 )
			{
				columnName = "description";
			}
			msgType = checkNull( msgType );
			if ( msgType.length() == 0 )
			{
				msgType = "E";
			}
			msgOption = checkNull( msgOption );
			msgTime = checkNull( msgTime );
			soundPlay = checkNull( soundPlay );
			errSource = checkNull( errSource );
			redirErr = checkNull( redirErr );
			if ( redirErr.length() == 0 )
			{
				redirErr = "1";
			}

			errorJson.put("message", message);
			errorJson.put("description", msgDescr);
			errorJson.put("type", msgType);
			if ( msgOption.length() > 0 )
			{
				errorJson.put("option", msgOption);				
			}
			if ( msgTime.length() > 0 )
			{
				errorJson.put("time", msgTime);				
			}
			if ( soundPlay.length() > 0 )
			{
				errorJson.put("alarm", soundPlay);				
			}
			if ( errSource.length() > 0 )
			{
				errorJson.put("source", errSource);				
			}
			errorJson.put("trace", trace);
			errorJson.put("redirect", redirErr);
			errorJson.put("column_name", columnName);

			errorsJson.put("error", errorJson);

			errors.put(errorsJson);

			rootJson.put("Errors",errors);

			errJson.put("Root", rootJson);

		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		BaseLogger.log( "3", null, null, "getErrorString :: errString line no 9675: ["+ errJson +"]" );
		return errJson.toString();
	}
	
	// Added by Gagan B. on 09-OCT-23 for copying file from one directory to another directory with updated name -- [START]
	public void copyFileWithNewName(String fromPath, String toPath, String newFileName) throws IOException {
		File sourceFile = new File(fromPath);

		if (!sourceFile.exists()) {
			System.err.println("Source file does not exist.");
			return;
		}

		File destinationDirectory = new File(toPath);

		if (!destinationDirectory.exists()) {
			destinationDirectory.mkdirs();
		}

		File destinationFile = new File(toPath, newFileName);

		try (InputStream inStream = new FileInputStream(sourceFile);
				OutputStream outStream = new FileOutputStream(destinationFile)) {
			byte[] buffer = new byte[1024];
			int length;

			while ((length = inStream.read(buffer)) > 0) {
				outStream.write(buffer, 0, length);
			}

			BaseLogger.log( "3", null, null, "File copied successfully to: " + destinationFile.getAbsolutePath());
		} catch (IOException e) {
			System.err.println("Error copying the file: " + e.getMessage());
		}
	}
	// Added by Gagan B. on 09-OCT-23 for copying file from one directory to another directory with updated name -- [END]
	
	// Added by Pranjalis  on 18-OCT-23 for crate aiapilog -- [START]
	public void createAIApiLog(UserInfoBean userInfo, int noOfPages, String objName,String apiProvider)throws ITMException
	{

		BaseLogger.log("2",null,null, "createAIApiLog: userInfo: [" + userInfo + "]" );
		BaseLogger.log("2",null,null, "createAIApiLog: objName: [" + objName + "]" );
		BaseLogger.log("2",null,null, "createAIApiLog: apiProvider: [" + apiProvider + "]" );
		Connection conn = null;
		ResultSet rs = null;
        PreparedStatement pstmt = null;
        String tranId="";
        int requestCount=1;
        String serverIp = "";
        
        try
		{
			int updateCount = 0;
			String userTranID = "";
			String transDB = userInfo.getTransDB();
			String userID = userInfo.getLoginCode();
			String enterprise = userInfo.getEnterprise();
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(transDB);
			
			String addUser = userInfo.getLoginCode();
			String addTerm = userInfo.getRemoteHostName();
			if( addTerm != null && addTerm.length() > 15 )
            {
                addTerm = addTerm.substring(0, 15);
            }
            else if( addTerm == null || addTerm.length() == 0 )
            {
                addTerm = userInfo.getRemoteHost();
            }
			
			serverIp = getAppServerIPAddr();
			
			BaseLogger.log("2", userInfo, null,"E12GenericUtility.callOpenAiLog() userID:["+userID+"]");
			TransIDGenerator tranIDGenerator = new TransIDGenerator("<Root></Root>",userID, CommonConstants.DB_NAME);
			userTranID = tranIDGenerator.generateTranSeqID( "AILOG","TRAN_ID","_seq15",conn);
			String insertQry = "INSERT INTO AI_API_LOG (TRAN_ID, OBJ_NAME, ENTERPRISE, API_PROVIDER, REQUEST_COUNT, NO_OF_PAGES, SERVER_IP,CHG_USER,CHG_DATE,CHG_TERM) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"; 
			
			pstmt = conn.prepareStatement(insertQry);
			pstmt.setString(1, userTranID);
			pstmt.setString(2, objName);
			pstmt.setString(3, enterprise);
			pstmt.setString(4, apiProvider);
			pstmt.setInt(5, requestCount);
			pstmt.setInt(6, noOfPages);
			pstmt.setString(7, serverIp);
			pstmt.setString(8, addUser);
			pstmt.setTimestamp(9, new java.sql.Timestamp(System.currentTimeMillis()));
			pstmt.setString(10, addTerm);

			
			updateCount = pstmt.executeUpdate();
			conn.commit();
	}
		catch (Exception e)
        { 
            BaseLogger.log("0",null,null,"Exception in callOpenAiLog [" + e.getMessage() + "]" );

            throw new ITMException(e);

        }
        finally
        {
            try
            {
                if (pstmt != null) 
                {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null)
                {
                    rs.close();
                    rs = null;
                }
                if (conn != null)
                {
                    conn.close();
                    conn = null;
                }
            }
            catch(Exception e)
            {
                e.printStackTrace();
                BaseLogger.log( "3", null, null, "Exception in callOpenAiLog :" + e.getMessage());
            }
        }        
		
	}
	
	public String getAppServerIPAddr() throws Exception
	{
		String ipAddr = "";
		try
        {
            Enumeration<NetworkInterface> b = NetworkInterface.getNetworkInterfaces();
            while( b.hasMoreElements())
            {
                for ( InterfaceAddress f :b.nextElement().getInterfaceAddresses())
                {
                    if ( f.getAddress().isSiteLocalAddress())
                    {
                        ipAddr = f.getAddress().toString();
                        //BaseLogger.log("9",null,null,f.getAddress());
                    }
                }
            }
            BaseLogger.log("3",null,null,"ipAddr =["+ipAddr+"]");

            if(ipAddr.startsWith("\"") || ipAddr.startsWith("/"))
            {
                ipAddr = ipAddr.substring(1, ipAddr.length());
            }
            BaseLogger.log("3",null,null,"ipAddr1 =["+ipAddr+"]");
            //Changes by Gulzar on 28-12-2021-START
            if(ipAddr == null || ipAddr.trim().length() == 0)
            {
            	InetAddress inetAddress;
                inetAddress = InetAddress.getLocalHost();
                String hostName = inetAddress.getHostName();
                ipAddr = inetAddress.getHostAddress();
                BaseLogger.log("3",null,null,"hostName =["+hostName+"]");
            }
			//Changes by Gulzar on 28-12-2021-END
            BaseLogger.log("3",null,null,"ipAddr2 =["+ipAddr+"]");
        }
        catch (SocketException se)
        {
            se.printStackTrace();
        }
		catch (Exception e)
        {
            e.printStackTrace();
        }
		return ipAddr;
	}
	
	public int getPDFNumberOfPages(InputStream pdfFileStream)
	{
		int noOfPages = 0;

		try
		{
			PdfReader pdfReader = new PdfReader(pdfFileStream);
			noOfPages = pdfReader.getNumberOfPages();
		}
		catch (IOException ex)
		{
			BaseLogger.log("0", null,  null,"IOException in DocumentHandlerServlet :: getPDFNumberOfPages() : " + ex);
		}
		catch (Throwable throwable)
		{
			// Changed by Abhishek T on 04-OCT-18 START
			/*
			 * Error (not Exception) throws,
			 * if PDF document is password protected,
			 * locked for printing, modifying, copying etc.
			 * in this 0 return as no of pages
			 */
			BaseLogger.log("0", null,  null,"Exception or Error in DocumentHandlerServlet :: getPDFNumberOfPages() : " + throwable);
			BaseLogger.log("0", null, null,
				"The PDF file may be password protected or locked from copying, printing and modifying etc.\n" +
				"For error detailing, refer below stack trace"
			);
			String stackTrace = buildStackTrace(throwable);
			BaseLogger.log("0", null,  null,stackTrace);
			// Changed by Abhishek T on 04-OCT-18 END
		}

		BaseLogger.log("2", null,  null,"DocumentHandlerServlet :: getPDFPageCount() : noOfPages [" + noOfPages + "]");

		return noOfPages;
	}
	private String buildStackTrace(Throwable ex)
	{
		StringBuilder sb = new StringBuilder();

		StackTraceElement[] elements = ex.getStackTrace();
		sb.append(String.format("%s : %s\n", ex.getClass().getSimpleName(), ex.getMessage()));

		for (StackTraceElement element : elements) {
			sb.append(String.format("\tat %s\n", element.toString()));
		}

		return sb.toString();
	}
	// Added by Pranjali  on 18-OCT-23 for crate aiapilog -- [END]
	
	//Added by pranjali Before calling openai please check openai request count exceeded against enterprise on mothly basis[START] 26/10/2023
	public String isRequestLimitExceeded(String enterprise, String format, UserInfoBean userInfo)throws ITMException
	{
		String errMessage = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Connection conn = null;
		String sql="";
		try
        {
        	int aiProcCount = 0;
        	int noOfPages = 0;
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB(userInfo.getTransDB());
			sql = "SELECT AI_PROC_LIMIT FROM ENTERPRISE WHERE ENTERPRISE=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, enterprise);
			
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				aiProcCount = rs.getInt(1);
				BaseLogger.log("3",userInfo,null,"aiProcCount :"+aiProcCount+":"); 
			}
			pstmt.clearParameters();
			rs.close();
		
			sql = "";
	        if ( "mssql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
	        {
	            sql = "SELECT SUM(NO_OF_PAGES) FROM AI_API_LOG WHERE MONTH(CHG_DATE) = MONTH(GETDATE()) AND ENTERPRISE=?";
	        }
	        else if ( "mysql".equalsIgnoreCase( CommonConstants.DB_NAME ) )
	        {
	            sql = "SELECT SUM(NO_OF_PAGES) FROM AI_API_LOG WHERE MONTH(CHG_DATE) = MONTH(CURDATE()) AND ENTERPRISE=?";
	        }
	        else
	        {
	            sql = "SELECT SUM(NO_OF_PAGES) FROM AI_API_LOG WHERE EXTRACT(MONTH FROM CHG_DATE) = EXTRACT(MONTH FROM SYSDATE) AND ENTERPRISE=?";
	        }
	        pstmt = conn.prepareStatement(sql);
	        pstmt.setString(1, enterprise);
	        
	        rs = pstmt.executeQuery();
			if(rs.next())
			{
				noOfPages = rs.getInt(1);
				BaseLogger.log("3",userInfo,null,"noOfPages:"+noOfPages+":"); 
			}
			
			if( aiProcCount == 0 )
			{
				if("xml".equalsIgnoreCase(format))
		        {
		        	errMessage = getErrorString("", "AINTCONFIG", userInfo.getLoginCode());
		        }
		        else
		        {
		        	errMessage =getErrorJson("", "AINTCONFIG", userInfo.getLoginCode());
		        }
			}
			else if(aiProcCount >= 0 && aiProcCount < noOfPages)
			{
	        	if("xml".equalsIgnoreCase(format))
		        {
		        	errMessage = getErrorString("", "AIREQEXCD", userInfo.getLoginCode());
		        }
		        else
		        {
		        	errMessage =getErrorJson("", "AIREQEXCD", userInfo.getLoginCode());
		        }
			}
		        
        }
        catch (Exception e)
        { 
            BaseLogger.log("0",null,null,"Exception in  isRequestLimitExceeded[" + e.getMessage() + "]" );
            throw new ITMException(e);
        }
        finally
        {
            try
            {
                if (pstmt != null) 
                {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) 
                {
                    rs.close();
                    rs = null;
                }
                if (conn != null)
                {
                    conn.close();
                    conn = null;
                }
            }
            catch(Exception e)
            {
                e.printStackTrace();
                BaseLogger.log( "0", null, null, "Exception in :isRequestLimitExceeded:finally " + e.getMessage());
            }
        }
		System.out.println("E12GenericUtility.isRequestLimitExceeded() errMessage:["+errMessage+"]");
        return errMessage;
	}
	//Added by pranjali Before calling openai please check openai request count exceeded against enterprise on mothly basis[END] 26/10/2023
	
	// Added by Gagan B. on 31-OCT-23 for getting cumulative logged in time for the day -- [START]
		public String getCumulativeLoggedInTimeForTheDay(String userID, String transDB) throws SQLException {
			String result = "";
			BaseLogger.log("3", null, null, "getCumulativeLoggedInTimeForTheDay userID: [" + userID + "]");
			BaseLogger.log("3", null, null, "getCumulativeLoggedInTimeForTheDay transDB: [" + transDB + "]");

			Connection connection = null;
			PreparedStatement getCumulativeLoggedInTimeForTheDayPS = null;
			ResultSet getCumulativeLoggedInTimeForTheDayRS = null;

			try {

				ConnDriver connDriver = new ConnDriver();
				connection = connDriver.getConnectDB(transDB);

				String getCumulativeLoggedInTimeForTheDaySQL = "SELECT SUM( ROUND( (CAST( LOGOUTTIME AS DATE) - CAST( LOGINTIME  AS DATE)) * 24 * 60  ) ) AS TOTAL_LOGGED_IN_TIME_IN_MINUTES FROM LOGINTRACE WHERE LOGINTIME >= TRUNC(SYSDATE) AND USERID = ?";
				getCumulativeLoggedInTimeForTheDayPS = connection.prepareStatement(getCumulativeLoggedInTimeForTheDaySQL);
				getCumulativeLoggedInTimeForTheDayPS.setString(1, userID);
				getCumulativeLoggedInTimeForTheDayRS = getCumulativeLoggedInTimeForTheDayPS.executeQuery();

				while (getCumulativeLoggedInTimeForTheDayRS.next()) {
					String totalLoggedinTimeInMinutes = getCumulativeLoggedInTimeForTheDayRS.getString("TOTAL_LOGGED_IN_TIME_IN_MINUTES");
					if(checkNull(totalLoggedinTimeInMinutes).equalsIgnoreCase("")) {
						totalLoggedinTimeInMinutes = "0"; //set totalLoggedinTimeInMinutes if the query returns NULL.
					}
					BaseLogger.log("3", null, null, "TOTAL_LOGGED_IN_TIME_IN_MINUTES: [" + totalLoggedinTimeInMinutes + "]");
					result = totalLoggedinTimeInMinutes;
				}
			} catch (Exception exp) {
				exp.printStackTrace();
			} finally {
				if (connection != null) {
					if (getCumulativeLoggedInTimeForTheDayRS != null) {
						getCumulativeLoggedInTimeForTheDayRS.close();
						getCumulativeLoggedInTimeForTheDayRS = null;
					}
					if (getCumulativeLoggedInTimeForTheDayPS != null) {
						getCumulativeLoggedInTimeForTheDayPS.close();
						getCumulativeLoggedInTimeForTheDayPS = null;
					}
					if (connection != null) {
						connection.close();
						connection = null;
					}
				}
			}
			return result;
		}
		// Added by Gagan B. on 31-OCT-23 for getting cumulative logged in time for the day -- [END]
 
		// Added by Rahul P. on 26-Dec-23 [to add Log in JMS_LOGS table] :: START
		public void jmsLog(String jmsData, String sendStatus, String recvdStatus, String msgType) throws Exception {
			
			BaseLogger.log("3", null, null, "E12GenericUtility.jmsLog() => jmsData : [" + jmsData + "]");
			if (jmsData == null || jmsData.trim().isEmpty()) {
				throw new IllegalArgumentException("Invalid input! jmsData is "+ ((jmsData == null) ? "null" : "empty"));
			}
	
			BaseLogger.log("3", null, null, "sendStatus: [" + sendStatus + "] & recvdStatus : [" + recvdStatus + "] & msgType : ["+msgType+"]");
	
			String[] inputArr = jmsData.split("!~~!");
			BaseLogger.log("3", null, null, "inputArr => " + Arrays.toString(inputArr));
			BaseLogger.log("3", null, null, "inputArr.length => [" + inputArr.length + "]");
	
			// Added by Rahul P. on 16-Jan-24 [to capture JMS log for WORKFLOW and UPDATE_DIRTY_DATAMODEL msgType as well] :: START
			String objName = "";
			String action = "";
			String transDB = "";
			String loginCode = "";
			String chgTerm = "";
			UserInfoBean userInfo = null;
			
			String refId = msgType.equals("WORKFLOW") ? inputArr[2] : ""; 
			
			String xmlString = msgType.equals("UPDATE_DIRTY_DATAMODEL") ? inputArr[1] : "";
		    BaseLogger.log("3", null, null, "xmlString : ["+ xmlString + "]");
		    
		    if (!xmlString.trim().isEmpty()) {
				
		    	Document doc = parseString(xmlString);
		    	
		    	NodeList parentNodeList = doc.getElementsByTagName("Detail1");
		    	BaseLogger.log("3", null, null, "parentNodeList length : " + parentNodeList.getLength());
		    	
		    	Node parentNode = parentNodeList.item(0);
		    	BaseLogger.log("3", null, null, "parentNodeName : " + parentNode.getNodeName());
		    	
				NodeList childNodeList = parentNode.getChildNodes();
				BaseLogger.log("3", null, null, "childNodeList length : " + childNodeList.getLength());

				for (int i = 1; i < childNodeList.getLength(); i++) {
					Node childNode = childNodeList.item(i);
					if (childNode.getFirstChild() != null) {
						BaseLogger.log("3", null, null,childNode.getNodeName() + " : " + childNode.getFirstChild().getNodeValue());

						if (childNode.getNodeName().equalsIgnoreCase("tran_id")) {
							refId = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}

			}
			BaseLogger.log("3", null, null, "refId : " + refId);

			switch (msgType) {
			case "WORKFLOW":
				BaseLogger.log("3", null, null, "jmsLog => WORKFLOW");
				userInfo = new UserInfoBean(inputArr[3]);
				objName = inputArr[0];
				action = "WORKFLOW";
				break;

			case "UPDATE_DIRTY_DATAMODEL":
				BaseLogger.log("3", null, null, "jmsLog => UPDATE_DIRTY_DATAMODEL");
				userInfo = new UserInfoBean(inputArr[3]);
				objName = inputArr[0];
				action = "UPDT_DRTY_DTMOD";
				break;

			case "FOLLOWUP_ACTIONS":
				BaseLogger.log("3", null, null, "jmsLog => FOLLOWUP_ACTIONS");
				userInfo = new UserInfoBean(inputArr[7]);

				String[] strArray = inputArr[6].split("~~");
				for (String pair : strArray) {
					String[] parts = pair.split("=");
					if (parts.length == 2 && parts[0].equals("chgTerm")) {
						chgTerm = parts[1];
						break;
					}
				}

				objName = inputArr[1];
				refId = inputArr[4];
				action = inputArr[5];
				break;

			default:
				BaseLogger.log("3", null, null, "default >> MsgType :: [" + msgType +"]");
			}

			if (userInfo != null) {
				loginCode = userInfo.getLoginCode();
				transDB = userInfo.getTransDB();
			}
			BaseLogger.log("3", null, null, "jmsLog => transDB : [" + transDB + "]");
			// Added by Rahul P. on 16-Jan-24 [to capture JMS log for WORKFLOW and UPDATE_DIRTY_DATAMODEL msgType] :: END
			
			BaseLogger.log("3", null, null,	"refId : [" + refId + "] & objName : [" + objName + "] & action : [" + action + "]");
	
			String query = "SELECT COUNT(1) AS COUNT FROM jms_logs WHERE obj_name = ? AND action_name = ? AND ref_id = ? ";
			
			//if ((msgType.equals("WORKFLOW") || msgType.equals("UPDATE_DIRTY_DATAMODEL")) && (refId == null || refId.trim().isEmpty())) {
			if (refId == null || refId.trim().isEmpty()) {
				
	        	BaseLogger.log("3", null, null, "Changing query...");
	        	query = "SELECT COUNT(1) AS COUNT FROM jms_logs WHERE obj_name = ? AND action_name = ? AND ref_id IS NULL ";
	        	
	        } 
			
			try (Connection conn = new ConnDriver().getConnectDB(transDB);
					PreparedStatement ps = conn.prepareStatement(query)) {
	
				ps.setString(1, objName);
				ps.setString(2, action);
				
				//if (!(msgType.equals("WORKFLOW") || msgType.equals("UPDATE_DIRTY_DATAMODEL")) || (refId != null && !refId.trim().isEmpty())) {
				if (refId != null && !refId.trim().isEmpty()) {
		        	BaseLogger.log("3", null, null, "setting refId param value..");
		        	ps.setString(3, refId);
		        } 
				
				try (ResultSet rs = ps.executeQuery()) {
	
					if (rs.next()) {
	
						int count = rs.getInt("COUNT");
						BaseLogger.log("3", null, null, "count : [" + count + "]");
	
						java.sql.Date currentDate = new java.sql.Date(System.currentTimeMillis());
						BaseLogger.log("3", null, null, "currentDate : [" + currentDate + "] & empCode : [" + loginCode + "] & chgTerm : [" + chgTerm + "]");
	
						if ((sendStatus != null && !sendStatus.trim().isEmpty()) && count == 0) {
	
							BaseLogger.log("3", null, null, "sendStatus and count == 0");
	
							String insertQuery = "INSERT INTO jms_logs (tran_id, obj_name, ref_id, action_name, jms_data, send_on, send_status, add_date, add_user, add_term) "
									+ "SELECT SUBSTR('0000000000' || JMSLOG_SEQ.nextval, -10) AS tran_id, "
									+ " ?, ?, ?, ?, ?, ?, ?, ?, ? " + "FROM dual";
	
							try (PreparedStatement pstmt = conn.prepareStatement(insertQuery)) {
	
								pstmt.setString(1, objName);
								pstmt.setString(2, refId);
								pstmt.setString(3, action);
								pstmt.setString(4, jmsData);
								pstmt.setDate(5, currentDate);
								pstmt.setString(6, sendStatus);
								pstmt.setDate(7, currentDate);
								pstmt.setString(8, loginCode);
								pstmt.setString(9, chgTerm);
	
								int updatedRows = pstmt.executeUpdate();
	
								if (updatedRows == 1) {
									conn.commit();
									BaseLogger.log("3", null, null, "log is added in jms_logs..");
								}
	
							}
						}
						else if ((sendStatus != null && !sendStatus.trim().isEmpty()) && count == 1) {
	
							BaseLogger.log("3", null, null, "sendStatus and count == 1");
	
							String updateQuery = "UPDATE jms_logs SET send_status = ?, chg_date = ?, chg_user = ?, chg_term = ? WHERE obj_name = ? AND action_name = ? AND ref_id = ? ";
	
							//if ((msgType.equals("WORKFLOW") || msgType.equals("UPDATE_DIRTY_DATAMODEL")) && (refId == null || refId.trim().isEmpty())) {
							if (refId == null || refId.trim().isEmpty()) {
								
					        	BaseLogger.log("3", null, null, "Changing query..");
					        	updateQuery = "UPDATE jms_logs SET send_status = ?, chg_date = ?, chg_user = ?, chg_term = ? WHERE obj_name = ? AND action_name = ? AND ref_id IS NULL ";
					        	
					        } 
							
							try (PreparedStatement pstmt = conn.prepareStatement(updateQuery)) {
								pstmt.setString(1, sendStatus);
								pstmt.setDate(2, currentDate);
								pstmt.setString(3, loginCode);
								pstmt.setString(4, chgTerm);
								pstmt.setString(5, objName);
								pstmt.setString(6, action);
	
								if (!(msgType.equals("WORKFLOW") || msgType.equals("UPDATE_DIRTY_DATAMODEL")) || (refId != null && !refId.trim().isEmpty())) {
						        	pstmt.setString(7, refId);
						        } 
								
								int updatedRows = pstmt.executeUpdate();
								if (updatedRows == 1) {
									conn.commit();
									BaseLogger.log("3", null, null, "log updated in jms_logs..");
								}
							}
	
						}
						else if ((recvdStatus != null && !recvdStatus.trim().isEmpty()) && count == 1) {
	
							BaseLogger.log("3", null, null, "recvdStatus and count == 1");
	
							String updateQuery = "UPDATE jms_logs SET recvd_on = ?, rcvd_status = ?, chg_date = ?, chg_user = ?, chg_term = ? "
									+ "WHERE obj_name = ? AND action_name = ? AND ref_id = ? ";
							
							//if ((msgType.equals("WORKFLOW") || msgType.equals("UPDATE_DIRTY_DATAMODEL")) && (refId == null || refId.trim().isEmpty())) {
							if (refId == null || refId.trim().isEmpty()) {
								
					        	BaseLogger.log("3", null, null, "Changing query..");
					        	updateQuery = "UPDATE jms_logs SET recvd_on = ?, rcvd_status = ?, chg_date = ?, chg_user = ?, chg_term = ? "
										+ "WHERE obj_name = ? AND action_name = ? AND ref_id IS NULL ";
					        	
					        } 
							
							try (PreparedStatement pstmt = conn.prepareStatement(updateQuery)) {
	
								pstmt.setDate(1, currentDate);
								pstmt.setString(2, recvdStatus);
								pstmt.setDate(3, currentDate);
								pstmt.setString(4, loginCode);
								pstmt.setString(5, chgTerm);
								pstmt.setString(6, objName);
								pstmt.setString(7, action);
	
								if (!(msgType.equals("WORKFLOW") || msgType.equals("UPDATE_DIRTY_DATAMODEL")) || (refId != null && !refId.trim().isEmpty())) {
						        	//Setting ref_id param value
						        	pstmt.setString(8, refId);
						        } 
																
								int updatedRows = pstmt.executeUpdate();
								if (updatedRows == 1) {
									conn.commit();
									BaseLogger.log("3", null, null, "log updated in jms_logs..");
								}
							}
	
						}
	
					}
				}
				catch (Exception e) {
					BaseLogger.log("3", null, null, "Exception occur in jmsLogs => " + e);
					try {
						if (conn != null) {
							conn.rollback();
						}
					} catch (SQLException rollbackException) {
						BaseLogger.log("3", null, null, "Rollback Exception occur in jmsLogs => " + rollbackException);
					}
				}
				
			}
			catch (Exception e) {
				BaseLogger.log("3", null, null, "Exception occur in jmsLogs => " + e);
			}
	
		}
		// Added by Rahul P. on 26-Dec-23 [to add Log in JMS_LOGS table] :: END
		
		// Added by Gagan B. on 15-FEB-24: method to get file extenstion from filename [START]
		public static String getFileExtension(String filename) {
            if (filename == null) {
                return null;
            }
            Path path = Path.of(filename);
            String fileExtension = null;
            if (path.getFileName() != null) {
                String fileName = path.getFileName().toString();
                int dotIndex = fileName.lastIndexOf('.');
                if (dotIndex > 0 && dotIndex < fileName.length() - 1) {
                    fileExtension = fileName.substring(dotIndex + 1);
                }
            }
            return fileExtension;
        }
		// Added by Gagan B. on 15-FEB-24: method to get file extenstion from filename [END]
				
}