/*
 * Decompiled with CFR 0.152.
 */
package ibase.hibernate.utility;

import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.cfg.Configuration;
import org.hibernate.service.ServiceRegistry;

public class HibernateUtil {
    private static SessionFactory sessionFactory = null;
    private static final Map<String, SessionFactory> sessionFactories;
    public static String DB_DATE_FORMAT;
    public static String APPL_DATE_FORMAT;

    static {
        try {
            String hibernetCfgPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "hibernate.cfg.xml";
            BaseLogger.log("3", null, null, "path for cfg file is ====" + hibernetCfgPath);
            File file = new File(hibernetCfgPath);
            BaseLogger.log("3", null, null, "file.exist():" + file.exists());
            BaseLogger.log("3", null, null, "cfg file ====" + file.getAbsolutePath());
            BaseLogger.log("3", null, null, "new Configuration() ====" + new Configuration());
            StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure(new File(hibernetCfgPath)).build();
            Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
            sessionFactory = metaData.getSessionFactoryBuilder().build();
            BaseLogger.log("3", null, null, "Session factory created successfully:" + sessionFactory);
        }
        catch (Exception ex) {
            BaseLogger.log("0", null, null, "Initial SessionFactory creation failed." + ex);
            throw new ExceptionInInitializerError(ex);
        }
        sessionFactories = new HashMap<String, SessionFactory>();
        DB_DATE_FORMAT = "yyyy-MM-dd";
        APPL_DATE_FORMAT = "dd/MM/yyyy";
    }

    public static SessionFactory getSessionFactory() {
        return sessionFactory;
    }

    public static void shutdown() {
        HibernateUtil.getSessionFactory().close();
    }

    private static SessionFactory buildSessionFactory(String dbName) {
        BaseLogger.log("2", null, null, "dbName is ===" + dbName);
        try {
            String hibernetCfgPath = String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "hibernate_" + dbName + ".cfg.xml";
            BaseLogger.log("3", null, null, "path for cfg file is ====" + hibernetCfgPath);
            StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().configure(new File(hibernetCfgPath)).build();
            Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
            sessionFactory = metaData.getSessionFactoryBuilder().build();
            sessionFactories.put(dbName, sessionFactory);
            return sessionFactory;
        }
        catch (HibernateException e) {
            System.err.println("Initial SessionFactory creation failed." + (Object)((Object)e));
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
        catch (Throwable ex) {
            System.err.println("Initial SessionFactory creation failed." + ex);
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static SessionFactory getSessionFactory(String dsName) {
        BaseLogger.log("2", null, null, "Inside getSessionFactory method :::" + dsName);
        if ("DEFAULT".equalsIgnoreCase(dsName)) {
            return HibernateUtil.getSessionFactory();
        }
        SessionFactory sessionFactory = sessionFactories.get(dsName);
        if (sessionFactory == null || sessionFactory.isClosed()) {
            sessionFactory = HibernateUtil.buildSessionFactory(dsName);
        }
        return sessionFactory;
    }

    public static void shutdown(String dbName) {
        HibernateUtil.getSessionFactory(dbName).close();
    }

    public static Date getDateObject(String dateStr, String dateFormat) {
        Date dateObj = null;
        SimpleDateFormat simpleDateFormat = null;
        try {
            simpleDateFormat = new SimpleDateFormat(dateFormat);
            dateObj = simpleDateFormat.parse(dateStr);
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getDateObject :==>\n" + e.getMessage());
            e.printStackTrace();
        }
        return dateObj;
    }

    public static String getValidDB2APPLDate(String dateStr) {
        return HibernateUtil.getValidDateString(dateStr, DB_DATE_FORMAT, APPL_DATE_FORMAT);
    }

    public static String getValidAPPL2DBDate(String dateStr) {
        return HibernateUtil.getValidDateString(dateStr, APPL_DATE_FORMAT, DB_DATE_FORMAT);
    }

    private static String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) {
        Date date = null;
        SimpleDateFormat sdfOutput = null;
        String retDateStr = "";
        try {
            if (!sourceDateFormat.equalsIgnoreCase(targetDateFormat)) {
                if (sourceDateFormat.indexOf("/") != -1) {
                    dateStr.replace('/', '-');
                } else if (sourceDateFormat.indexOf(".") != -1) {
                    dateStr.replace('.', '-');
                }
                date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
                sdfOutput = new SimpleDateFormat(targetDateFormat);
                retDateStr = sdfOutput.format((Object)date);
            } else {
                retDateStr = dateStr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", null, null, "Exception :GenericUtility :getValidDateString :==>" + e.getMessage());
            e.printStackTrace();
        }
        return retDateStr;
    }
}

