/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.UploadFileLocal;
import ibase.webitm.ejb.UploadFileRemote;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.ejb.Stateless;
import oracle.sql.CLOB;
import org.json.JSONObject;

@Stateless
public class UploadNewTemplateEJB
implements UploadFileLocal,
UploadFileRemote {
    @Override
    public boolean getIsDefault(String tempName, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadNewTemplateEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String respString = "";
        boolean isDefault = false;
        String transDB = null;
        try {
            try {
                transDB = userInfo.getTransDB();
                String getIsDefault = "SELECT IS_DEFAULT FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME =?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getIsDefault);
                pstmt.setString(1, tempName);
                rs = pstmt.executeQuery();
                if (rs.next() && "Y".equalsIgnoreCase(rs.getString(1))) {
                    isDefault = true;
                }
            }
            catch (Exception e) {
                respString = "exception" + e.getMessage();
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return isDefault;
    }

    @Override
    public HashMap getErrorData(String batchId, String profileId, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadNewTemplateEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap errorMap = new HashMap();
        String transDB = null;
        try {
            try {
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                transDB = userInfo.getTransDB();
                String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, ERROR_MSG FROM BATCHLOAD WHERE  BATCH_ID = ?  AND LOAD_STAT = ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getErrorData);
                pstmt.setString(1, batchId);
                pstmt.setString(2, "N");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        HashMap<String, Object> innerMap = new HashMap<String, Object>();
                        innerMap.put("winName", rs.getString(1));
                        innerMap.put("tranSl", rs.getInt(2));
                        innerMap.put("loadDate", rs.getTimestamp(3));
                        innerMap.put("errorMessage", rs.getString(4));
                        errorMap.put(String.valueOf(batchId) + "_" + rs.getInt(2), innerMap);
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return errorMap;
    }

    @Override
    public ArrayList getDefaultTemp(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadNewTemplateEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> defaultTemp = new ArrayList<String>();
        String transDB = null;
        try {
            try {
                transDB = userInfo.getTransDB();
                String getDefaultTemp = "SELECT TEMPLATE_NAME ,TEMPLATE_XML FROM OBJ_FILE_TEMPLATE WHERE OBJ_NAME = ? AND IS_DEFAULT = ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getDefaultTemp);
                pstmt.setString(1, objName);
                pstmt.setString(2, "Y");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    defaultTemp.add(rs.getString(1));
                    defaultTemp.add(rs.getString(2));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return defaultTemp;
    }

    @Override
    public TreeMap getSortedErrorData(String batchId, String profileId, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadNewTemplateEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        TreeMap errorMap = new TreeMap();
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG  FROM BATCHLOAD  WHERE  BATCH_ID = ?  AND LOAD_STAT in ('N','E','Y')  ORDER BY TO_NUMBER(TRAN_SL)";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getErrorData);
                pstmt.setString(1, batchId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        HashMap<String, Object> innerMap = new HashMap<String, Object>();
                        innerMap.put("winName", rs.getString(1));
                        innerMap.put("tranSl", rs.getInt(2));
                        innerMap.put("loadDate", rs.getTimestamp(3));
                        innerMap.put("errorMessage", rs.getString(4));
                        errorMap.put(String.valueOf(batchId) + "_" + rs.getInt(2), innerMap);
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return errorMap;
    }

    @Override
    public String getSqlValue(String sqlString, String sqlInput, UserInfoBean userInfo) throws RemoteException, ITMException {
        BaseLogger.log("2", userInfo, null, "UploadNewTemplateEjb called");
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String respString = "";
        try {
            try {
                connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                BaseLogger.log("3", userInfo, null, "sqlString = [" + sqlString + "] , sqlInput[= " + sqlInput + "]");
                pstmt = conn.prepareStatement(sqlString);
                if (sqlInput.contains(",")) {
                    String[] sqlInputArray = sqlInput.split(",");
                    int i = 0;
                    while (i < sqlInputArray.length) {
                        BaseLogger.log("3", userInfo, null, "input value = " + sqlInputArray[i]);
                        pstmt.setString(i + 1, sqlInputArray[i]);
                        ++i;
                    }
                } else {
                    pstmt.setString(1, sqlInput);
                }
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    respString = rs.getString(1);
                    BaseLogger.log("3", userInfo, null, " respString in getSqlValue = " + respString);
                }
            }
            catch (Exception e) {
                respString = "exception" + e.getMessage();
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return respString;
    }

    public HashMap getObjList(String profileId, UserInfoBean userInfo, String caller) throws RemoteException, ITMException {
        HashMap<String, String> objListMap;
        block18: {
            ConnDriver connDriver = null;
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            objListMap = new HashMap<String, String>();
            try {
                try {
                    String objMapQuery = "SELECT WIN_NAME, DESCR FROM USER_RIGHTS A, ITM2MENU B WHERE PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + "AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " + "AND ( A.RIGHTS LIKE '%U%' or (A.RIGHTS LIKE '%*%' AND  (A.EXCLUDE_RIGHTS_CHAR NOT LIKE '%U%' OR A.EXCLUDE_RIGHTS_CHAR IS NULL ))) AND ( WIN_NAME != NULL or WIN_NAME != '-') AND B.OBJ_TYPE = 'T '" + "ORDER BY A.APPLICATION,MENU_ROW,MENU_COL,MENU_SUBCOL,A.LEVEL_4,A.LEVEL_5";
                    connDriver = new ConnDriver();
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                    pstmt = conn.prepareStatement(objMapQuery);
                    String objName = "";
                    String desc = "";
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        do {
                            if ((objName = rs.getString("WIN_NAME")) != null && objName.indexOf("w") == 0 && objName.indexOf("_") == 1) {
                                objName = objName.substring(2);
                            }
                            desc = rs.getString("DESCR");
                            objListMap.put(objName, desc);
                        } while (rs.next());
                        break block18;
                    }
                    BaseLogger.log("3", userInfo, null, "rs is null");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        return objListMap;
    }

    @Override
    public String getTemplateXml(String tempName, UserInfoBean userInfo) throws RemoteException, ITMException {
        String xmlString = "";
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_XML_NEW.getClobval()  FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.TEMPLATE_NAME =?";
                connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getExistingTemplate);
                pstmt.setString(1, tempName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    xmlString = rs.getString(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return xmlString;
    }

    @Override
    public boolean getUserAccess(String profileId, String pageName, UserInfoBean userInfo) {
        BaseLogger.log("2", userInfo, null, " pageName = " + pageName);
        boolean isAccessible = false;
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String transDB = null;
        String getUserAccess = "SELECT COUNT(1) FROM USER_RIGHTS A, ITM2MENU B WHERE A.PROFILE_ID IN " + E12GenericUtility.getFormattedProfileId(profileId) + " AND WIN_NAME IN (?, ? ) AND A.APPLICATION=B.APPLICATION AND LEVEL_1=MENU_ROW AND LEVEL_2=MENU_COL " + "AND MENU_SUBCOL=LEVEL_3 AND A.LEVEL_4=B.LEVEL_4 AND A.LEVEL_5=B.LEVEL_5 " + "AND ( A.RIGHTS LIKE '%U%' or A.RIGHTS LIKE '%*%') AND ( WIN_NAME != NULL or WIN_NAME != '-')";
        try {
            try {
                transDB = userInfo.getTransDB();
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getUserAccess);
                if (pageName.equals("Apply_Default_Temp")) {
                    pstmt.setString(1, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/jsp/E12ApplyDefaultTemp.jsp");
                    pstmt.setString(2, "/ibase/jsp/E12ApplyDefaultTemp.jsp");
                } else if (pageName.equals("Upload_Temp")) {
                    pstmt.setString(1, String.valueOf(CommonConstants.TOMCAT_HOME) + "/ibase/jsp/E12UploadNewTemplate.jsp");
                    pstmt.setString(2, "/ibase/jsp/E12UploadNewTemplate.jsp");
                }
                rs = pstmt.executeQuery();
                if (rs.next() && rs.getInt(1) > 0) {
                    isAccessible = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return isAccessible;
    }

    @Override
    public HashMap getExistingTemplate(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, String> existingTemplateList = new HashMap<String, String>();
        try {
            try {
                String getExistingTemplate = "SELECT TEMPLATE.TEMPLATE_NAME, TEMPLATE.TEMPLATE_XML , TEMPLATE.TEMPLATE_XML_NEW.getClobval() FROM OBJ_FILE_TEMPLATE TEMPLATE WHERE TEMPLATE.OBJ_NAME =?";
                connDriver = new ConnDriver();
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getExistingTemplate);
                pstmt.setString(1, objName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        existingTemplateList.put(rs.getString("TEMPLATE_NAME"), rs.getString(3));
                    } while (rs.next());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return existingTemplateList;
    }

    @Override
    public String saveTemplate(String objName, String tempName, String xmlString, String isDefault, UserInfoBean userInfo) throws RemoteException, ITMException {
        String respString = null;
        ConnDriver connDriver = null;
        connDriver = new ConnDriver();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String transDB = userInfo.getTransDB();
                conn = connDriver.getConnectDB(transDB);
                String getTemplateCount = "SELECT COUNT(1) FROM OBJ_FILE_TEMPLATE WHERE TEMPLATE_NAME= ? ";
                pstmt = conn.prepareStatement(getTemplateCount);
                pstmt.setString(1, tempName);
                rs = pstmt.executeQuery();
                pstmt.close();
                pstmt = null;
                if (rs.next()) {
                    if (rs.getInt(1) == 0) {
                        String insertTemplate = "INSERT INTO OBJ_FILE_TEMPLATE(OBJ_NAME, TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT,TEMPLATE_XML_NEW) VALUES (?,?,?,?,XMLType(?))";
                        BaseLogger.log("3", userInfo, null, "insertTemplate = " + insertTemplate);
                        pstmt = conn.prepareStatement(insertTemplate);
                        pstmt.setString(1, objName);
                        pstmt.setString(2, tempName);
                        pstmt.setString(3, "");
                        pstmt.setString(4, isDefault);
                        CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        xmlData.putString(1L, xmlString);
                        pstmt.setClob(5, (Clob)xmlData);
                    } else {
                        String updateTemplate = "UPDATE OBJ_FILE_TEMPLATE SET TEMPLATE_XML = ? , IS_DEFAULT = ? , TEMPLATE_XML_NEW = XMLType(?) WHERE  TEMPLATE_NAME = ? AND OBJ_NAME = ? ";
                        BaseLogger.log("3", userInfo, null, "updateTemplate = " + updateTemplate);
                        pstmt = conn.prepareStatement(updateTemplate);
                        pstmt.setString(1, "");
                        pstmt.setString(2, isDefault);
                        CLOB xmlData = CLOB.createTemporary((Connection)conn.getMetaData().getConnection(), (boolean)true, (int)10);
                        xmlData.putString(1L, xmlString);
                        pstmt.setClob(3, (Clob)xmlData);
                        pstmt.setString(4, tempName);
                        pstmt.setString(5, objName);
                    }
                    int result = pstmt.executeUpdate();
                    respString = result > 0 ? "Template saved in database" : "Error while saving template";
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.commit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return respString;
    }

    @Override
    public HashMap<String, HashMap<String, String>> getTemplateDetail(String objName, String accessFrom, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        HashMap<String, HashMap<String, String>> templateDetailMap = new HashMap<String, HashMap<String, String>>();
        try {
            try {
                connDriver = new ConnDriver();
                if (userInfo != null) {
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                }
                connDriver = null;
                String getTemplateDetail = " SELECT TEMPLATE_NAME, TEMPLATE_XML, IS_DEFAULT, TEMPLATE_XML_NEW.getClobval() TEMPLATE_XML_NEW, FILE_MAPPING.getClobval() FILE_MAPPING  FROM OBJ_FILE_TEMPLATE  WHERE TEMPLATE.OBJ_NAME = ? ";
                pstmt = conn.prepareStatement(getTemplateDetail);
                pstmt.setString(1, objName);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        String templateName = E12GenericUtility.checkNull(rs.getString("TEMPLATE_NAME"));
                        String templateXml = E12GenericUtility.checkNull(rs.getString("TEMPLATE_XML"));
                        String templateXmlNew = E12GenericUtility.checkNull(rs.getString("TEMPLATE_XML_NEW"));
                        String isDefault = E12GenericUtility.checkNull(rs.getString("IS_DEFAULT"));
                        String fileMappingXml = E12GenericUtility.checkNull(rs.getString("FILE_MAPPING"));
                        HashMap<String, String> detailMap = new HashMap<String, String>();
                        detailMap.put("TEMPLATE_NAME", templateName);
                        detailMap.put("TEMPLATE_XML", templateXml);
                        detailMap.put("TEMPLATE_XML_NEW", templateXmlNew);
                        detailMap.put("IS_DEFAULT", isDefault);
                        detailMap.put("FILE_MAPPING", fileMappingXml);
                        templateDetailMap.put(templateName, detailMap);
                    } while (rs.next());
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return templateDetailMap;
    }

    @Override
    public TreeMap<Integer, String> getFormWiseTitleMap(String objName, UserInfoBean userInfo) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pStmt = null;
        ResultSet rs = null;
        TreeMap<Integer, String> formDetailInfo = new TreeMap<Integer, String>();
        try {
            try {
                connDriver = new ConnDriver();
                if (userInfo != null) {
                    String transDB = userInfo.getTransDB();
                    conn = connDriver.getConnectDB(transDB);
                }
                connDriver = null;
                String winName = objName.contains("w_") ? objName : "w_" + objName;
                String sql = " SELECT FORM_NO, TITLE FROM OBJ_FORMS WHERE WIN_NAME = ? ORDER BY TO_NUMBER(FORM_NO) ";
                pStmt = conn.prepareStatement(sql);
                pStmt.setString(1, winName);
                rs = pStmt.executeQuery();
                while (rs.next()) {
                    formDetailInfo.put(rs.getInt("FORM_NO"), rs.getString("TITLE"));
                }
                rs.close();
                rs = null;
                pStmt.close();
                pStmt = null;
            }
            catch (Exception e) {
                throw new ITMException(e);
            }
        }
        finally {
            if (conn != null) {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (pStmt != null) {
                        pStmt.close();
                        pStmt = null;
                    }
                    conn.close();
                    conn = null;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ITMException(e);
                }
            }
        }
        return formDetailInfo;
    }

    public String getUploadStatusData(String batchId, String profileId, UserInfoBean userInfo) throws RemoteException, ITMException {
        StringBuffer result;
        block19: {
            ConnDriver connDriver = null;
            Connection conn = null;
            Statement pstmt = null;
            ResultSet rs = null;
            result = new StringBuffer();
            try {
                try {
                    String transDB = userInfo.getTransDB();
                    BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                    String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG  FROM BATCHLOAD  WHERE  BATCH_ID = ?  AND LOAD_STAT in ('N','E','Y')  ORDER BY TO_NUMBER(TRAN_SL)";
                    connDriver = new ConnDriver();
                    conn = connDriver.getConnectDB(transDB);
                    pstmt = conn.prepareStatement(getErrorData);
                    pstmt.setString(1, batchId);
                    SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        result.append("<ROOT>");
                        do {
                            result.append("<DETAIL>");
                            result.append("<BATCH_ID><![CDATA[").append(batchId).append("]]></BATCH_ID>");
                            result.append("<WIN_NAME><![CDATA[").append(rs.getString(1)).append("]]></WIN_NAME>");
                            result.append("<TRAN_SL><![CDATA[").append(rs.getInt(2)).append("]]></TRAN_SL>");
                            result.append("<TRAN_ID_REF><![CDATA[").append(rs.getString(4)).append("]]></TRAN_ID_REF>");
                            result.append("<LOAD_DATE><![CDATA[").append(sdf.format(rs.getTimestamp(3))).append("]]></LOAD_DATE>");
                            result.append("<ERROR_MSG><![CDATA[").append(rs.getString(5)).append("]]></ERROR_MSG>");
                            result.append("</DETAIL>");
                        } while (rs.next());
                        result.append("</ROOT>");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block19;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return result.toString();
    }

    @Override
    public String getUploadStatusData(String batchId, UserInfoBean userInfo, Connection conn) throws RemoteException, ITMException {
        StringBuffer result;
        block20: {
            ConnDriver connDriver = null;
            Statement pstmt = null;
            ResultSet rs = null;
            result = new StringBuffer();
            boolean localConn = false;
            try {
                try {
                    BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                    String getErrorData = "SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG  FROM BATCHLOAD  WHERE  BATCH_ID = ?  AND LOAD_STAT in ('N','E','Y')  ORDER BY TO_NUMBER(TRAN_SL)";
                    connDriver = new ConnDriver();
                    if (conn == null) {
                        String transDB = userInfo.getTransDB();
                        ConnDriver mConnDriver = new ConnDriver();
                        conn = mConnDriver.getConnectDB(transDB);
                        mConnDriver = null;
                        localConn = true;
                    }
                    pstmt = conn.prepareStatement(getErrorData);
                    pstmt.setString(1, batchId);
                    SimpleDateFormat sdf = new SimpleDateFormat(CommonConstants.DISP_DATETIME_FORMAT);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        result.append("<ROOT>");
                        do {
                            result.append("<DETAIL>");
                            result.append("<BATCH_ID><![CDATA[").append(batchId).append("]]></BATCH_ID>");
                            result.append("<WIN_NAME><![CDATA[").append(rs.getString(1)).append("]]></WIN_NAME>");
                            result.append("<TRAN_SL><![CDATA[").append(rs.getInt(2)).append("]]></TRAN_SL>");
                            result.append("<TRAN_ID_REF><![CDATA[").append(rs.getString(4)).append("]]></TRAN_ID_REF>");
                            result.append("<LOAD_DATE><![CDATA[").append(sdf.format(rs.getTimestamp(3))).append("]]></LOAD_DATE>");
                            result.append("<ERROR_MSG><![CDATA[").append(rs.getString(5)).append("]]></ERROR_MSG>");
                            result.append("</DETAIL>");
                        } while (rs.next());
                        result.append("</ROOT>");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                            pstmt = null;
                        }
                        if (localConn && conn != null) {
                            conn.close();
                            conn = null;
                        }
                        break block20;
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (localConn && conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (localConn && conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return result.toString();
    }

    @Override
    public String getAllUploadStatusData(UserInfoBean userInfo, String loadDate) throws RemoteException, ITMException {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String retResult = "";
        try {
            try {
                E12GenericUtility genericUtility = new E12GenericUtility();
                String transDB = userInfo.getTransDB();
                String getErrorData = " SELECT WIN_NAME, TRAN_SL, LOAD_DATE, TRAN_ID__REF, LOAD_STAT, BATCH_ID,  CASE WHEN LOAD_STAT = 'Y' THEN 'Uploaded Successfully' ELSE ERROR_MSG END ERROR_MSG  FROM BATCHLOAD  WHERE LOAD_STAT in ('N','E','Y') AND TO_CHAR( LOAD_DATE, 'dd-Mon-yyyy' ) = ?  AND CHG_USER = ?  ORDER BY BATCH_ID, LOAD_DATE";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(getErrorData);
                SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
                String currDate = "";
                if (loadDate != null && loadDate.length() > 0) {
                    Date loadDt = dtFormat.parse(loadDate);
                    currDate = dtFormat.format(loadDt);
                } else {
                    currDate = dtFormat.format(System.currentTimeMillis());
                }
                currDate = genericUtility.getValidDateString(currDate, genericUtility.getApplDateFormat(), "dd-MMM-yyyy");
                pstmt.setString(1, currDate);
                pstmt.setString(2, userInfo.getLoginCode());
                HashMap<String, HashMap> dataMap = new HashMap<String, HashMap>();
                int totalRec = 0;
                boolean transl = false;
                int processed = 0;
                int successRec = 0;
                int errorRec = 0;
                int unProcessed = 0;
                String objName = "";
                String loadStatus = "";
                String batchId = "";
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    do {
                        batchId = rs.getString(6);
                        objName = rs.getString(1);
                        objName = rs.getString(1).substring(2);
                        BaseLogger.log("3", userInfo, null, "2161 batchId - [" + batchId + "]");
                        HashMap metadataMap = new HashMap();
                        if (dataMap != null && dataMap.containsKey(batchId)) {
                            metadataMap = (HashMap)dataMap.get(batchId);
                        } else {
                            totalRec = 0;
                            processed = 0;
                            successRec = 0;
                            errorRec = 0;
                            unProcessed = 0;
                            loadStatus = "";
                        }
                        ++totalRec;
                        loadStatus = rs.getString(5);
                        if ("Y".equalsIgnoreCase(loadStatus)) {
                            ++successRec;
                        } else if ("E".equalsIgnoreCase(loadStatus)) {
                            ++errorRec;
                        } else if ("N".equalsIgnoreCase(loadStatus)) {
                            ++unProcessed;
                        }
                        processed = successRec + errorRec;
                        float percentage = processed * 100 / totalRec;
                        BaseLogger.log("3", userInfo, null, "successRec - [" + successRec + "], errorRec - [" + errorRec + "], unProcessed - [" + unProcessed + "]");
                        BaseLogger.log("3", userInfo, null, "processed - [" + processed + "]");
                        metadataMap.put("batchId", batchId);
                        metadataMap.put("objName", objName);
                        metadataMap.put("totalRec", "" + totalRec);
                        metadataMap.put("successRec", "" + successRec);
                        metadataMap.put("errorRec", "" + errorRec);
                        metadataMap.put("unProcessed", "" + unProcessed);
                        metadataMap.put("processed", "" + processed);
                        metadataMap.put("progress", String.valueOf(processed) + " / " + totalRec);
                        metadataMap.put("percentage", "" + percentage);
                        metadataMap.put("loadStatus", loadStatus);
                        dataMap.put(batchId, metadataMap);
                        BaseLogger.log("3", userInfo, null, "dataMap [" + dataMap + "]");
                    } while (rs.next());
                }
                JSONObject resultJson = new JSONObject();
                for (Map.Entry entry : dataMap.entrySet()) {
                    String mapBatchId = (String)entry.getKey();
                    HashMap metadataMap = (HashMap)entry.getValue();
                    if (metadataMap == null) continue;
                    JSONObject metadataJson = new JSONObject();
                    for (Map.Entry entry1 : metadataMap.entrySet()) {
                        metadataJson.put((String)entry1.getKey(), entry1.getValue());
                    }
                    resultJson.put(mapBatchId, (Object)metadataJson);
                }
                retResult = resultJson.toString();
                BaseLogger.log("3", userInfo, null, "retResult ---[" + retResult + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getallUploadStatusData----[" + e.getMessage() + "]");
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return retResult;
    }

    @Override
    public String getDataFileName(String batchId, UserInfoBean userInfo) {
        ConnDriver connDriver = null;
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        String downloadFile = "";
        try {
            try {
                String transDB = userInfo.getTransDB();
                BaseLogger.log("3", userInfo, null, "batchId " + batchId);
                String fileName = " select data_file_name from BATCHLOAD where batch_id = ?";
                connDriver = new ConnDriver();
                conn = connDriver.getConnectDB(transDB);
                pstmt = conn.prepareStatement(fileName);
                pstmt.setString(1, batchId);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    downloadFile = rs.getString(1);
                }
                BaseLogger.log("3", userInfo, null, "retResult ---[" + downloadFile + "]");
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception on getUploadStatusData----[" + e.getMessage() + "]");
                try {
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (conn != null) {
                        conn.close();
                        conn = null;
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (conn != null) {
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        return downloadFile;
    }

    @Override
    public boolean checkExistingTempName(String objName, String tempName, UserInfoBean userInfo) throws RemoteException, ITMException {
        return false;
    }

    @Override
    public String getDocId(String batchId, String refSer, UserInfoBean userInfo) {
        return null;
    }

    @Override
    public String getDocIdNrefId(String objName, String tempName, UserInfoBean userInfo) {
        return null;
    }

    @Override
    public String saveTemplate(String tempId, String objName, String tempName, String xmlString, String isDefault, String fileMapping, String shareScope, String scopeValue, String templateRightsChar, String fileName, byte[] byteArray, String filePath, String isDataUploadAutoConfirm, UserInfoBean userInfo) throws RemoteException, ITMException {
        return null;
    }
}

