package ibase.utility.training;

import java.io.*;
import java.nio.file.*;
import java.text.SimpleDateFormat;
import java.util.Date;

public class XmlReader {
	public static void main(String[] args) {
		String filePath = "/home/amol.sonawane/Documents/UNS-HSBC";
		String outputFileName = generateOutputFileName();
		String archiveFolderName = generateArchiveFolderName();

		try {
			concatenateXmlFiles(filePath, outputFileName);
			moveFilesToArchive(filePath, archiveFolderName);
			System.out.println("XML files concatenated successfully. Output file: " + outputFileName);
		} catch (IOException e) {
			System.err.println("Error concatenating XML files: " + e.getMessage());
		}
	}

	private static void concatenateXmlFiles(String filePath, String outputFileName) throws IOException {
		File outputDir = new File("/home/amol.sonawane/Documents/UNS-HSBC/NewXml");
		if (!outputDir.exists()) {
			outputDir.mkdirs();
		}

		File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));

		if (xmlFiles == null || xmlFiles.length == 0) {
			System.err.println("No XML files found in the specified directory.");
			return;
		}

		try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputDir, outputFileName)))) {
			writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			writer.write("<Document xmlns=\"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03\">");

			for (int i = 0; i < xmlFiles.length; i++) {

				String content = new String(Files.readAllBytes(xmlFiles[i].toPath()));
				
				int startIdxOfMsgId = content.indexOf("<MsgId>");
				int endIdxOfMsgId = content.indexOf("</MsgId>") + "</MsgId>".length();
				if (startIdxOfMsgId != -1 && endIdxOfMsgId != -1) {
				    String updatedMsgIdTag = "<MsgId>" + getFileNameWithoutExtension(generateOutputFileName()) + "</MsgId>";
				    content = content.substring(0, startIdxOfMsgId) + updatedMsgIdTag + content.substring(endIdxOfMsgId);
				}

				int startIdxOfPmtInfId = content.indexOf("<PmtInfId>");
				int endIdxOfPmtInfId = content.indexOf("</PmtInfId>") + "</PmtInfId>".length();
				if (startIdxOfPmtInfId != -1 && endIdxOfPmtInfId != -1) {
				    String updatedPmtInfIdTag = "<PmtInfId>" + getFileNameWithoutExtension(generateOutputFileName()) + "</PmtInfId>";
				    content = content.substring(0, startIdxOfPmtInfId) + updatedPmtInfIdTag + content.substring(endIdxOfPmtInfId);
				}
				int startIdxOfCtrlSum = content.indexOf("<CtrlSum>");
				int endIdxOfCtrlSum = content.indexOf("</CtrlSum>", startIdxOfCtrlSum);
				
				
				if (i == 0) 
				{

					int totalCtrlSum = 0;

					for (int j = 0; j < xmlFiles.length; j++)
					{
						String tempContent = content; 
						if (startIdxOfCtrlSum != -1 && endIdxOfCtrlSum != -1)
						{
							String ctrlSumValueStr = tempContent.substring(startIdxOfCtrlSum + "<CtrlSum>".length(),
									endIdxOfCtrlSum);
							int ctrlSumValue = Integer.parseInt(ctrlSumValueStr);
							tempContent = tempContent.substring(0, startIdxOfCtrlSum)
									+ tempContent.substring(endIdxOfCtrlSum + "</CtrlSum>".length());

							totalCtrlSum += ctrlSumValue;
							System.out.println("totalCtrlSum : " + totalCtrlSum);

						}
					}
					content = content.substring(0, startIdxOfCtrlSum + "<CtrlSum>".length()) + totalCtrlSum
							+ content.substring(endIdxOfCtrlSum);

					int startIdxOfNbOfTxsTag = content.indexOf("<NbOfTxs>");
					int endIdxOfNbOfTxsTag = content.indexOf("</NbOfTxs>") + "</NbOfTxs>".length();

					if (startIdxOfNbOfTxsTag != -1 && endIdxOfNbOfTxsTag != -1) 
					{
						String updatedNbOfTxsTag = "<NbOfTxs>" + xmlFiles.length + "</NbOfTxs>";
						content = content.substring(0, startIdxOfNbOfTxsTag) + updatedNbOfTxsTag
								+ content.substring(endIdxOfNbOfTxsTag);
					}

					// Extract content starting from <CstmrCdtTrfInitn>
					int startIdx = content.indexOf("<CstmrCdtTrfInitn>");
					int endIdx = content.lastIndexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();

					if (startIdx != -1 && endIdx != -1) 
					{
						content = content.substring(startIdx, endIdx);
					}
				} else 
				{
					int startIdx = content.indexOf("<CdtTrfTxInf>");
					int endIdx = content.indexOf("</CdtTrfTxInf>") + "</CdtTrfTxInf>".length();
					if (startIdx != -1 && endIdx != -1) {
						content = content.substring(startIdx, endIdx);
					}
				}

				writer.write(content);
			}

			writer.write("</PmtInf>");
			writer.write("</CstmrCdtTrfInitn>");
			writer.write("</Document>");
		}
	}

	private static void moveFilesToArchive(String filePath, String archiveFolderName) throws IOException
	{
		File archiveDir = new File(filePath + File.separator + archiveFolderName);
		if (!archiveDir.exists()) {
			archiveDir.mkdirs();
		}

		File[] xmlFiles = new File(filePath).listFiles((dir, name) -> name.toLowerCase().endsWith(".xml"));

		if (xmlFiles != null) {
			for (File xmlFile : xmlFiles) {
				Path sourcePath = Paths.get(xmlFile.getAbsolutePath());
				Path destinationPath = Paths.get(archiveDir.getAbsolutePath() + File.separator + xmlFile.getName());
				Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
			}
		}
	}

	private static String generateOutputFileName() 
	{
		SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmm");
		String formattedDate = dateFormat.format(new Date());
		return formattedDate + ".xml";
	}

	private static String generateArchiveFolderName() 
	{
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH");
		return dateFormat.format(new Date());
	}
	private static String getFileNameWithoutExtension(String formattedDate) {
	    int lastDotIndex = formattedDate.lastIndexOf(".");
	    if (lastDotIndex != -1) {
	        return formattedDate.substring(0, lastDotIndex);
	    }
	    return formattedDate;
	}
}
