package ibase.webitm.ejb.wsfa.transactions;
import java.lang.String;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import java.util.*;
import java.util.Date;
import java.sql.*;
import java.text.*;
import java.io.*;
import org.w3c.dom.*; 
import javax.xml.parsers.*;
import javax.ejb.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.*;
import ibase.system.config.*;
import java.util.*;
import javax.naming.InitialContext;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.GenericUtility;
//import ibase.wsfa.utility.SFACommon;
import ibase.webitm.utility.wsfa.WSFACommon;

import java.io.File;
import ibase.system.config.ConnDriver;

//@Stateless
public class StrgSeriesPsrCopyPrc extends ProcessEJB implements StrgSeriesPsrCopyPrcLocal,StrgSeriesPsrCopyPrcRemote
{
	File filePtr ;
	File logDir ;
	String logDirName = "";			
	static String logOnOffFlag = "Y";//For On-Off Log file.
	String err = "";
	E12GenericUtility genericUtility = new E12GenericUtility();
	ResultSet rs1 = null;
	PreparedStatement pstmt1 = null;
	String Sql1="";
	
	static void writeLog(File f,String Msg,boolean flag)
	{
		try
		{  
			PrintWriter pw = new PrintWriter((new FileOutputStream(f,flag)),flag);				
			if(logOnOffFlag.trim().equals("Y"))
			{
				pw.println("["+new java.util.Date() +"]   " + Msg);		
			}
			pw.close();
		}
		catch(Exception exWm){exWm.printStackTrace();}		
	}
	
	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		if(CommonConstants.J2EE_VERSION.equals("1"))
		{
			logDirName =  CommonConstants.JBOSSHOME  + File.separator + "log" ;
		}
		else if(CommonConstants.J2EE_VERSION.equals("2"))
		{
			logDirName =  CommonConstants.JBOSSHOME   + File.separator + "server"+ File.separator +"default"+ File.separator +"log" ;
		}
		logDir = new File(logDirName);
		filePtr = new File(logDirName+ File.separator + "StrgSeriesPsrCopyPrc.log");

		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;	
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 				
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{			
			writeLog(filePtr,"Exception -->"+e,true);
			rtrStr = e.getMessage();
		}
		return rtrStr; 
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		//StringBuffer retTabSepStrBuff = new StringBuffer();//Gulzar - 31/05/08
		Connection conn = null;
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		String errCode = "";
		String resultString = "";
		String getSql= "";
		String salesPersFrom = "";
		String salesPersTo = "";
		String divisionOpt = "";
		String divisionTo = "";
		String copyOpt = "";
		String sql= null ;
		ResultSet rs = null;
		ResultSet rs1 = null;
		PreparedStatement pstmt = null;
		Statement stmt = null;
		try
		{
			//valueXmlString added to return the data in xml string format insted of tab separated format - Gulzar - 31/05/08
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][Start]
			//StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\" encoding='UTF-8'?>\r\n<DocumentRoot>\r\n<description>Datawindow Root</description>\r\n<group0>\r\n<description>Group0 description</description>\r\n<Header0>\r\n<description>Header0 members</description>\r\n");
			//Modified by Ganesh [16/05/2013][To add utf-8 in xml format][End]
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			//DatabaseMetaData dbmd = conn.getMetaData();
			//For logonoff
			//logOnOffFlag = "N";
			getSql = "select var_value from disparm where prd_code='999999' and var_name='STRGSERCPY_LOGONOFF'";
			pstmt = conn.prepareStatement(getSql); 
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				logOnOffFlag = rs.getString(1);
				System.out.println("------------------in rs--------");
			}
			if (logOnOffFlag == null || logOnOffFlag.trim().length() == 0)
			{
				logOnOffFlag = "N";
			}
			System.out.println("----------------logOnOff:"+logOnOffFlag);
			rs.close();
			pstmt.close();
			

			salesPersFrom = genericUtility.getColumnValue("sales_pers__from",headerDom);
			salesPersTo = genericUtility.getColumnValue("sales_pers__to",headerDom);
			divisionOpt = genericUtility.getColumnValue("division_opt",headerDom);
			copyOpt = genericUtility.getColumnValue("copy_opt",headerDom);
			System.out.println("divisionOpt ============================> "+divisionOpt);
			System.out.println("copyOpt ============================> "+copyOpt);

			sql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
			writeLog(filePtr,"sql-->"+sql,true);
			System.out.println("SQL from strg_customer :: "+sql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				divisionTo = rs.getString("ITEM_SER");
			}
			rs.close();
			stmt.close();

			if ( copyOpt != null && copyOpt.trim().length()>0 )
			{
				getSql= "SELECT STRG_CUSTOMER.SC_CODE, "
					+" RTRIM(STRG_CUSTOMER.FIRST_NAME)||' '||RTRIM(STRG_CUSTOMER.MIDDLE_NAME)||' '||RTRIM(STRG_CUSTOMER.LAST_NAME) AS NAME, "
					+" STRG_CUSTOMER.QUALIFICATION, "
					+" STRG_CUSTOMER.CITY, "
					+" STRG_CUSTOMER.STATUS, "
					+" STRG_CUSTOMER.SEX, "
					+" STRG_CUSTOMER.ADDED_DATE, "
					+" STRG_CUSTOMER.RES_CITY, "
					+" STRG_CUSTOMER.EMAIL_ADDR, "
					+" STRG_SERIES.ITEM_SER, "
					+" CASE WHEN STRG_SERIES.CLASS_CODE IS NULL THEN 'N' ELSE STRG_SERIES.CLASS_CODE END AS CLASS_CODE, "
					+" STRG_SERIES.NO_VISIT, "
					+" STRG_SERIES.SHORT_ID, "
					+" STRG_CUSTOMER.LOCALITY_CODE, "
					+" RTRIM(STRG_CUSTOMER.ADDR1)  ADDR1, "
					+" RTRIM(STRG_CUSTOMER.ADDR2) ADDR2, "
					+" RTRIM(STRG_CUSTOMER.ADDR3) ADDR3, "
					+" STRG_CUSTOMER.STAN_CODE, "
					+" STRG_CUSTOMER.STATE_CODE, "
					+" STRG_CUSTOMER.PIN, "
					+" STRG_CUSTOMER.COUNT_CODE  , "
					+" ITEMSER.DESCR, "
					+" RTRIM(STRG_CUSTOMER.RES_ADDR1)  RESADDR1, "
					+" RTRIM(STRG_CUSTOMER.RES_ADDR2) RESADDR2, "
					+" RTRIM(STRG_CUSTOMER.RES_ADDR3) RESADDR3, "
					+" STRG_CUSTOMER.RES_STAN_CODE, "
					+" STRG_CUSTOMER.RES_STATE_CODE, "
					+" STRG_CUSTOMER.RES_PIN, "
					+" STRG_CUSTOMER.RES_COUNT_CODE, "
					+" STRG_CUSTOMER.RES_LOCALITY_CODE, "
					+" SALES_PERS.SP_NAME, "
					+" STRG_SERIES.SALES_PERS__OLD , "
					+" STRG_SERIES.REASON AS REASON, "
					+" STRG_SERIES.EFF_DATE AS EFF_DATE , "
					//Modified By Rupesh [11/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES.SPL_CODE , "
					+"SPECIALITY.DESCR AS SPECIALITY_DESCR, "  
					//Modified By Rupesh [11/01/2013] [To display speciality descr.][End]
					// Modified by Prashant on [23/02/2013][To set spl_code and speciality_descr in xml]
					+" STRG_SERIES.SPL_CODE , "
					+" STRG_SERIES.ROUTE_ID, "
					+" STRG_SERIES.NO_PATIENT_DAY "
					//Added by satya on 03/06/10[WS90SUN031].start
					+", STRG_SERIES.RETAILER_CODE"
					+", STRG_SERIES.RETAILER_NAME"
					+", STRG_SERIES.RETAILER_ADR1"
					+", STRG_SERIES.RETAILER_ADR2"
					+", STRG_SERIES.RETAILER_ADR3"
					+", STRG_SERIES.RETAILER_CITY"
					+", STRG_SERIES.RETAILER_PIN "
					+", STRG_SERIES.RETAILER_TEL1"
					+", STRG_SERIES.RETAILER_TEL2"
					+", STRG_SERIES.RETAILER_MOBNO"
					+", STRG_SERIES.RETAILER_LOCALITY "
					//Added by satya on 03/06/10[WS90SUN031].end
					+", STRG_SERIES.CATEGORY "//Gulzar - 11/01/11
					//Modified by Rupesh on[30/07/2012] [To append required fields only][Start]
					//+", LOCALITY.DESCR AS LOCALITY_DESCR"
					+",SPRS_ROUTE.DESCR AS LOCALITY_DESCR"
					+",SPRS_ROUTE.LOCALITY_CODE AS SPRS_LOCALITY_CODE" 	
					+", STRG_SERIES.SALES_PERS "
					//Modified by Rupesh on[30/07/2012] [To append required fields only][End]
					
					//ADDED BY SACHIN SATRE ON 23-MAR-17 AS PER REUIREMENT [START]
					 +", STRG_SERIES.OCCU_TYPE,  "
					 + "STRG_SERIES.SUB_SPL_CODE,  " 
					 + "STRG_SERIES.RX_MODE, "
					 + " STRG_SERIES.ASSO_TYPE, "
					 + " STRG_SERIES.PATIENT_PROFILE," 
					 + "  STRG_SERIES.AGE_BRACKET,  " 
					//ADDED BY SACHIN SATRE ON 23-MAR-17 AS PER REUIREMENT [END]
				//changed by sachin satre on [05-jun-17] [start]
				 	 + "  STRG_SERIES.QUALIFICATION AS STRG_SER_QUALIFICATION,  "
				 	 + "  STRG_SERIES.MOBILE_NO AS STRG_SER_MOBILE_NO,  " 
				 	+ "  STRG_SERIES.EMAIL_ADDR AS STRG_SER_EMAIL_ADDR ,  " ;
				//changed by sachin satre on [05-jun-17] [start]
				if (copyOpt.trim().equals("1") && divisionOpt.trim().equals("N"))
				{
					getSql = getSql +" 0 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE"
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.SALES_PERS = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( STRG_SERIES.SALES_PERS = '"+salesPersFrom+"' ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' ";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(2,salesPersFrom); //Gulzar - 22/08/08 Req ID : SY89SUN001
				}
				else if (copyOpt.trim().equals("1") && divisionOpt.trim().equals("Y"))
				{
					getSql = getSql+" 1 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "				
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE "
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' ";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo);//Gulzar - 22/08/08 Req ID : SY89SUN001
				}				
				else if (copyOpt.trim().equals("2") && divisionOpt.trim().equals("N"))
				{
					getSql = getSql+" 2 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE "
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY"
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.ITEM_SER = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.SALES_PERS = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( STRG_SERIES.ITEM_SER = '"+divisionTo+"' ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( STRG_SERIES.SALES_PERS = '"+salesPersFrom+"' ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' ";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(2,divisionTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(3,salesPersFrom); //Gulzar - 22/08/08 Req ID : SY89SUN001
				}				
				else if (copyOpt.trim().equals("2") && divisionOpt.trim().equals("Y"))
				{
					getSql = getSql+" 3 AS OPT "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					//+" FROM STRG_CUSTOMER, "
					+" FROM STRG_CUSTOMER, LOCALITY, "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					//+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE "
					+" STRG_SERIES, ITEMSER, SALES_PERS, SPRS_ROUTE, SPECIALITY "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" WHERE ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
					+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND "
					+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) AND "
					+" ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
					+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) AND "
					//Modified by Rupesh on[30/07/2012] [To append required fields only]
					+" (STRG_CUSTOMER.LOCALITY_CODE = LOCALITY.LOCALITY_CODE) AND "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]
					+" ( SPECIALITY.SPL_CODE = STRG_SERIES.SPL_CODE ) AND  "
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					+" ( STRG_SERIES.SC_CODE NOT IN "
					//+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = ?)) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					//+" ( STRG_SERIES.ITEM_SER = ? ) AND " //Gulzar - 22/08/08 Req ID : SY89SUN001
					+" ( SELECT SC_CODE FROM STRG_SERIES WHERE SALES_PERS = '"+salesPersTo+"' )) AND " //Gulzar - 22/08/08
					+" ( STRG_SERIES.ITEM_SER = '"+divisionTo+"' ) AND " //Gulzar - 22/08/08
					+" 	( STRG_CUSTOMER.STATUS = 'A' ) AND "
					+" 	( STRG_SERIES.STATUS = 'Y' ) "
					+" 	AND SPRS_ROUTE.STATUS='Y' ";  
					pstmt = conn.prepareStatement(getSql);   
					//pstmt.setString(1,salesPersTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
					//pstmt.setString(2,divisionTo); //Gulzar - 22/08/08 Req ID : SY89SUN001
				}				
				System.out.println("SQL==>"+getSql);
				writeLog(filePtr,"getSql -->"+getSql,true);
				rs = pstmt.executeQuery();
				int domID = 2;//Gulzar - 31/05/08
				while(rs.next())
				{
					/*-- Commented and Changes below to retun data in xml string format insted of tab separated format - Gulzar - 31/05/08
					retTabSepStrBuff.append((rs.getString("sc_code")==null)?" " :rs.getString("sc_code")).append("\t");					
					retTabSepStrBuff.append((rs.getString("name")==null)?" " :rs.getString("name")).append("\t");
					retTabSepStrBuff.append((rs.getString("qualification")==null)?" " :rs.getString("qualification")).append("\t");
					retTabSepStrBuff.append((rs.getString("city")==null)?" " :rs.getString("city")).append("\t");
					retTabSepStrBuff.append((rs.getString("status")==null)?" " :rs.getString("status")).append("\t");
					retTabSepStrBuff.append((rs.getString("sex")==null)?" " :rs.getString("sex")).append("\t");
					retTabSepStrBuff.append(rs.getTimestamp("added_date")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_city")==null)?" " :rs.getString("res_city")).append("\t");
					retTabSepStrBuff.append((rs.getString("email_addr")==null)?" " :rs.getString("email_addr")).append("\t");
					retTabSepStrBuff.append((rs.getString("item_ser")==null)?" " :rs.getString("item_ser")).append("\t");
					retTabSepStrBuff.append((rs.getString("class_code")==null)?" " :rs.getString("class_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("no_visit")==null)?" " :rs.getString("no_visit")).append("\t");////
					retTabSepStrBuff.append((rs.getString("short_id")==null)?" " :rs.getString("short_id")).append("\t");
					retTabSepStrBuff.append((rs.getString("locality_code")==null)?" " :rs.getString("locality_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("addr1")==null)?" " :rs.getString("addr1")).append("\t");
					retTabSepStrBuff.append((rs.getString("addr2")==null)?" " :rs.getString("addr2")).append("\t");
					retTabSepStrBuff.append((rs.getString("addr3")==null)?" " :rs.getString("addr3")).append("\t");
					retTabSepStrBuff.append((rs.getString("stan_code")==null)?" " :rs.getString("stan_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("state_code")==null)?" " :rs.getString("state_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("pin")==null)?" " :rs.getString("pin")).append("\t");
					retTabSepStrBuff.append((rs.getString("count_code")==null)?" " :rs.getString("count_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("descr")==null)?" " :rs.getString("descr")).append("\t");
					retTabSepStrBuff.append((rs.getString("resaddr1")==null)?" " :rs.getString("resaddr1")).append("\t");
					retTabSepStrBuff.append((rs.getString("resaddr2")==null)?" " :rs.getString("resaddr2")).append("\t");
					retTabSepStrBuff.append((rs.getString("resaddr3")==null)?" " :rs.getString("resaddr3")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_stan_code")==null)?" " :rs.getString("res_stan_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_state_code")==null)?" " :rs.getString("res_state_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_pin")==null)?" " :rs.getString("res_pin")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_count_code")==null)?" " :rs.getString("res_count_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("res_locality_code")==null)?" " :rs.getString("res_locality_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("sp_name")==null)?" " :rs.getString("sp_name")).append("\t");
					retTabSepStrBuff.append((rs.getString("sales_pers__old")==null)?" " :rs.getString("sales_pers__old")).append("\t");
					retTabSepStrBuff.append((rs.getString("reason")==null)?" " :rs.getString("reason")).append("\t");
					retTabSepStrBuff.append(rs.getTimestamp("eff_date")).append("\t");
					retTabSepStrBuff.append((rs.getString("spl_code")==null)?" " :rs.getString("spl_code")).append("\t");
					retTabSepStrBuff.append((rs.getString("route_id")==null)?" " :rs.getString("route_id")).append("\t");
					retTabSepStrBuff.append((rs.getString("no_patient_day")==null)?" " :rs.getString("no_patient_day")).append("\t");
					retTabSepStrBuff.append((rs.getString("opt")==null)?" " :rs.getString("opt")).append("\r\n");
					*/
					//Added - Changes belwo - Gulzar - 31/05/08
					valueXmlString.append("<Detail2 domID='"+domID+"' >\r\n");
					
					
					valueXmlString.append("<attribute updateFlag='N' selected='N' />\r\n");
					valueXmlString.append("<is_selected><![CDATA[").append("N").append("]]></is_selected>\r\n"); //Gulzar - 22/08/08

					//Modified by Rupesh on[30/07/2012] [To append required fields only][Start]
					/*
					valueXmlString.append("<sc_code><![CDATA[").append(checkNull(rs.getString("sc_code"))).append("]]></sc_code>\r\n");
					valueXmlString.append("<name><![CDATA[").append(checkNull(rs.getString("name"))).append("]]></name>\r\n");
					valueXmlString.append("<city><![CDATA[").append(checkNull(rs.getString("city"))).append("]]></city>\r\n");
					valueXmlString.append("<qualification><![CDATA[").append(checkNull(rs.getString("qualification"))).append("]]></qualification>\r\n");
					valueXmlString.append("<reason><![CDATA[").append(checkNull(rs.getString("reason"))).append("]]></reason>\r\n");
					valueXmlString.append("<eff_date><![CDATA[").append(rs.getTimestamp("eff_date")).append("]]></eff_date>\r\n");
					valueXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
					valueXmlString.append("<descr><![CDATA[").append(checkNull(rs.getString("descr"))).append("]]></descr>\r\n");
					valueXmlString.append("<class_code><![CDATA[").append(checkNull(rs.getString("class_code"))).append("]]></class_code>\r\n");
					valueXmlString.append("<short_id><![CDATA[").append(checkNull(rs.getString("short_id"))).append("]]></short_id>\r\n");
					valueXmlString.append("<no_of_visit><![CDATA[").append(rs.getInt("no_visit")).append("]]></no_of_visit>\r\n");
					valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("spl_code"))).append("]]></spl_code>\r\n");
					valueXmlString.append("<addr1><![CDATA[").append(checkNull(rs.getString("addr1"))).append("]]></addr1>\r\n");
					valueXmlString.append("<addr2><![CDATA[").append(checkNull(rs.getString("addr2"))).append("]]></addr2>\r\n");
					valueXmlString.append("<addr3><![CDATA[").append(checkNull(rs.getString("addr3"))).append("]]></addr3>\r\n");
					valueXmlString.append("<locality_code><![CDATA[").append(checkNull(rs.getString("locality_code"))).append("]]></locality_code>\r\n");
					valueXmlString.append("<stan_code><![CDATA[").append(checkNull(rs.getString("stan_code"))).append("]]></stan_code>\r\n");
					valueXmlString.append("<state_code><![CDATA[").append(checkNull(rs.getString("state_code"))).append("]]></state_code>\r\n");
					valueXmlString.append("<pin><![CDATA[").append(checkNull(rs.getString("pin"))).append("]]></pin>\r\n");
					valueXmlString.append("<count_code><![CDATA[").append(checkNull(rs.getString("count_code"))).append("]]></count_code>\r\n");
					valueXmlString.append("<status><![CDATA[").append(checkNull(rs.getString("status"))).append("]]></status>\r\n");
					valueXmlString.append("<sex><![CDATA[").append(checkNull(rs.getString("sex"))).append("]]></sex>\r\n");
					valueXmlString.append("<added_date><![CDATA[").append(checkNull(rs.getString("added_date"))).append("]]></added_date>\r\n"); //Gulzar - 9/19/2008 - Check for null
					valueXmlString.append("<res_city><![CDATA[").append(checkNull(rs.getString("res_city"))).append("]]></res_city>\r\n");
					valueXmlString.append("<email_addr><![CDATA[").append(checkNull(rs.getString("email_addr"))).append("]]></email_addr>\r\n");
					valueXmlString.append("<sales_pers__old><![CDATA[").append(checkNull(rs.getString("sales_pers__old"))).append("]]></sales_pers__old>\r\n");
					valueXmlString.append("<sp_name><![CDATA[").append(checkNull(rs.getString("sp_name"))).append("]]></sp_name>\r\n");
					valueXmlString.append("<opt><![CDATA[").append(checkNull(rs.getString("opt"))).append("]]></opt>\r\n");
					valueXmlString.append("<resaddr1><![CDATA[").append(checkNull(rs.getString("resaddr1"))).append("]]></resaddr1>\r\n");
					valueXmlString.append("<resaddr2><![CDATA[").append(checkNull(rs.getString("resaddr2"))).append("]]></resaddr2>\r\n");
					valueXmlString.append("<resaddr3><![CDATA[").append(checkNull(rs.getString("resaddr3"))).append("]]></resaddr3>\r\n");
					valueXmlString.append("<res_stan_code><![CDATA[").append(checkNull(rs.getString("res_stan_code"))).append("]]></res_stan_code>\r\n");
					valueXmlString.append("<res_state_code><![CDATA[").append(checkNull(rs.getString("res_state_code"))).append("]]></res_state_code>\r\n");
					valueXmlString.append("<res_pin><![CDATA[").append(checkNull(rs.getString("res_pin"))).append("]]></res_pin>\r\n");
					valueXmlString.append("<res_count_code><![CDATA[").append(checkNull(rs.getString("res_count_code"))).append("]]></res_count_code>\r\n");
					valueXmlString.append("<res_locality_code><![CDATA[").append(checkNull(rs.getString("res_locality_code"))).append("]]></res_locality_code>\r\n");
					valueXmlString.append("<route_id><![CDATA[").append(checkNull(rs.getString("route_id"))).append("]]></route_id>\r\n");
					valueXmlString.append("<no_patient_day><![CDATA[").append(rs.getInt("no_patient_day")).append("]]></no_patient_day>\r\n");
					//Added by satya on 03/06/10[WS90SUN031].start
					valueXmlString.append("<retailer_code><![CDATA[").append(checkNull(rs.getString("RETAILER_CODE"))).append("]]></retailer_code>\r\n");
					valueXmlString.append("<retailer_name><![CDATA[").append(checkNull(rs.getString("RETAILER_NAME"))).append("]]></retailer_name>\r\n");
					valueXmlString.append("<retailer_adr1><![CDATA[").append(checkNull(rs.getString("RETAILER_ADR1"))).append("]]></retailer_adr1>\r\n");
					valueXmlString.append("<retailer_adr2><![CDATA[").append(checkNull(rs.getString("RETAILER_ADR2"))).append("]]></retailer_adr2>\r\n");
					valueXmlString.append("<retailer_adr3><![CDATA[").append(checkNull(rs.getString("RETAILER_ADR3"))).append("]]></retailer_adr3>\r\n");
					valueXmlString.append("<retailer_city><![CDATA[").append(checkNull(rs.getString("RETAILER_CITY"))).append("]]></retailer_city>\r\n");
					valueXmlString.append("<retailer_pin><![CDATA[").append(checkNull(rs.getString("RETAILER_PIN"))).append("]]></retailer_pin>\r\n");
					valueXmlString.append("<retailer_tel1><![CDATA[").append(checkNull(rs.getString("RETAILER_TEL1"))).append("]]></retailer_tel1>\r\n");
					valueXmlString.append("<retailer_tel2><![CDATA[").append(checkNull(rs.getString("RETAILER_TEL2"))).append("]]></retailer_tel2>\r\n");
					valueXmlString.append("<retailer_mobno><![CDATA[").append(checkNull(rs.getString("RETAILER_MOBNO"))).append("]]></retailer_mobno>\r\n");
					valueXmlString.append("<retailer_locality><![CDATA[").append(checkNull(rs.getString("RETAILER_LOCALITY"))).append("]]></retailer_locality>\r\n");
					//Added by satya on 03/06/10[WS90SUN031].end
					valueXmlString.append("<category><![CDATA[").append(checkNull(rs.getString("CATEGORY"))).append("]]></category>\r\n");
					*/					
					valueXmlString.append("<sc_code><![CDATA[").append(checkNull(rs.getString("sc_code"))).append("]]></sc_code>\r\n");
					valueXmlString.append("<name><![CDATA[").append(checkNull(rs.getString("name"))).append("]]></name>\r\n");
					valueXmlString.append("<item_ser><![CDATA[").append(checkNull(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
					valueXmlString.append("<locality_descr><![CDATA[").append(checkNull(rs.getString("locality_descr"))).append("]]></locality_descr>\r\n");
					valueXmlString.append("<class_code><![CDATA[").append(checkNull(rs.getString("class_code"))).append("]]></class_code>\r\n");
					
					valueXmlString.append("<no_of_visit><![CDATA[").append(rs.getInt("no_visit")).append("]]></no_of_visit>\r\n");
				
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][Start]	//valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("spl_code"))).append("]]></spl_code>\r\n");
					// Modified by Prashant on [23/02/2013][To set spl_code and speciality_descr in xml][Start]
					//valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("SPECIALITY_DESCR"))).append("]]></spl_code>\r\n");
					valueXmlString.append("<spl_code><![CDATA[").append(checkNull(rs.getString("SPL_CODE"))).append("]]></spl_code>\r\n");
					valueXmlString.append("<speciality_descr><![CDATA[").append(checkNull(rs.getString("SPECIALITY_DESCR"))).append("]]></speciality_descr>\r\n");
					// Modified by Prashant on [23/02/2013][To set spl_code and speciality_descr in xml][End]
					//Modified By Rupesh [12/01/2013] [To display speciality descr.][End]
					
					valueXmlString.append("<opt><![CDATA[").append(checkNull(rs.getString("opt"))).append("]]></opt>\r\n");

					valueXmlString.append("<sales_pers><![CDATA[").append(checkNull(rs.getString("sales_pers"))).append("]]></sales_pers>\r\n");
					valueXmlString.append("<route_id><![CDATA[").append(checkNull(rs.getString("route_id"))).append("]]></route_id>\r\n");

					//Modified by Rupesh on[30/07/2012] [To append required fields only][End]
					//ADDED BY SACHIN SATRE ON [14-MAR-17] [START]
					valueXmlString.append("<occu_type><![CDATA[").append(checkNull(rs.getString("OCCU_TYPE"))).append("]]></occu_type>\r\n");
					valueXmlString.append("<sub_spl_code><![CDATA[").append(checkNull(rs.getString("SUB_SPL_CODE"))).append("]]></sub_spl_code>\r\n");
					valueXmlString.append("<rx_mode><![CDATA[").append(checkNull(rs.getString("RX_MODE"))).append("]]></rx_mode>\r\n");
					valueXmlString.append("<asso_type><![CDATA[").append(checkNull(rs.getString("ASSO_TYPE"))).append("]]></asso_type>\r\n");
					valueXmlString.append("<age_bracket><![CDATA[").append(checkNull(rs.getString("age_bracket"))).append("]]></age_bracket>\r\n");
					valueXmlString.append("<patient_profile><![CDATA[").append(checkNull(rs.getString("PATIENT_PROFILE"))).append("]]></patient_profile>\r\n");
					valueXmlString.append("<sprs_route_locality_code><![CDATA[").append(checkNull(rs.getString("SPRS_LOCALITY_CODE"))).append("]]></sprs_route_locality_code>\r\n");//sprs_locality_code
					//ADDED BY SACHIN SATRE ON [14-MAR-17] [END]
				
					//changed by sachin satre on [05-jun-17] [start]
					valueXmlString.append("<qualification><![CDATA[").append(checkNull(rs.getString("STRG_SER_QUALIFICATION"))).append("]]></qualification>\r\n");
					valueXmlString.append("<mobile_no><![CDATA[").append(checkNull(rs.getString("STRG_SER_MOBILE_NO"))).append("]]></mobile_no>\r\n");
					valueXmlString.append("<email_addr><![CDATA[").append(checkNull(rs.getString("STRG_SER_EMAIL_ADDR"))).append("]]></email_addr>\r\n");
					//changed by sachin satre on [05-jun-17] [END]
					
					//Gulzar - 11/01/11 - WS01SUN038
					valueXmlString.append("</Detail2>\r\n");	
					domID++;
					//End Changes - Gulzar - 31/05/08
				}
				//resultString = retTabSepStrBuff.toString(); //Gulzar - 31/05/08
				valueXmlString.append("</Header0>\r\n"); //Gulzar - 31/05/08
				valueXmlString.append("</group0>\r\n");	//Gulzar - 31/05/08
				valueXmlString.append("</DocumentRoot>\r\n"); //Gulzar - 31/05/08
				resultString = valueXmlString.toString();//Gulzar - 31/05/08
			}
		}	
		catch(Exception e)
		{
			writeLog(filePtr,"Exception in getData-->"+e,true);
			System.out.println("Exception in getData-->"+e.toString());
			 throw new ITMException(e);				
		}
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				writeLog(filePtr,"In Fianally... Exception in getData-->"+e,true);
				System.out.println(e.getMessage());					
			}
		}
		return resultString;	
	} 
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		
		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";
		
		try
		{	
		//	writeLog(filePtr,"xmlString-->"+xmlString,true);// commented by sachin satre on [04-dec-17] 
		//	writeLog(filePtr,"xmlString2-->"+xmlString2,true);// commented by sachin satre on [04-dec-17]
			
			System.out.println("xmlString::::"+xmlString);
			System.out.println("xmlString2::::"+xmlString2);
			if(windowName != null && windowName.trim().length() > 0 )
			{	
				writeLog(filePtr,"windowName-->"+windowName,true);			
			}

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString); 
				System.out.println("headerDom" + headerDom);
				//writeLog(filePtr,"headerDom-->"+headerDom,true);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2); 
				System.out.println("detailDom" + detailDom);
			//	writeLog(filePtr,"detailDom-->"+detailDom,true);
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch (Exception e)
		{			
			System.out.println("Exception :StrgSeriesPsrCopyPrc :process:" + e.getMessage() + ":");
			e.printStackTrace();
			writeLog(filePtr,"Exception in process-->"+e.getMessage(),true);
			retStr = e.getMessage();
		}
		//added by sachin satre on [04-dec-17] request id : W17ISUN002 start 
		if(retStr != null && retStr.trim().length() > 0  )
		{	
			//writeLog(filePtr,"Return from process-->"+retStr,true);
		System.out.println("Return from process-->"+retStr);
		}	
		//added by sachin satre on [04-dec-17] request id :W17ISUN002 end
		return retStr;
	}
	// END OF PROCESS ONE

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");		
		//Start changes by bharath- 13/02/09
		String termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
		//End changes by bharath- 13/02/09
		Connection conn = null;
		//ConnDriver connDriver = new ConnDriver();//Commented by vinayak on [11/07/2016]
		//conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		PreparedStatement pstmtIns1 = null;
		PreparedStatement pstmtIns2 = null;
		PreparedStatement pstmtSel1 = null;
		PreparedStatement pstmtSel2 = null;
		PreparedStatement pstmtInsertStrgStatHist = null;
		Statement stmt = null;
		Statement stmt1 = null;
		String sql = "";
		String childNodeName = "";
		String errCode = "";
		String retString = "";
		String errString = "";
		String currentDate = "";

		String itemSer = "";
		String scCode = "";
		String classCode = "";
		String reason = "";
		String splCode = "";
		String localityCode = "";
		String salesPersFrom = "";
		String salesPersTo = "";
		String divisionOpt = "";
		String copyOpt = "";
		String dscCode = "";
		String effDate = "";
		String status = "";
		String resLocalityCode = "";
		String resRouteId = "";
		String routeId = "";
		String sortSeq = "";
		String getSql = "";
		String isSelected = ""; //Gulzar - 22/08/08 Req ID : SY89SUN001
		String routeidFr = "";
		String itemSerDb = "";
		//Added by satya on 03/06/10[WS90SUN031].start
		String retailerCode = "";
		String retailerName  = "";
		String retailerAdr1 = "";
		String retailerAdr2 = "";
		String retailerAdr3 = "";
		String retailerCity = "";
		String retailerPin  = "";
		String retailerTel1 = "";
		String retailerTel2 = "";
		String retailerMobNo = "";
		String retailerLocality = "";
		//Added by satya on 03/06/10[WS90SUN031].end
		//ADDED BY SACHIN SATRE ON [14-FEB-17] [START]
		String occType ="";
		String subSplCode ="";
		String rxMode ="";
		String assoType ="";
		String ageBracket ="";
		String patientProfile ="";
		String mobNo="";
		String Qualification="";
		String emailId="";
		String custType="";
		//ADDED BY SACHIN SATRE ON [14-FEB-17] [end]
		String category = "";//Variable declare to store category value gulzar - 10/01/11 - WS01SUN038

		double noVisit = 0d;
		double noPatientDay = 0d;

		float totalBuss = 0f;
		float bussToUs = 0f;

		java.util.Date currDate =null;
		java.sql.Timestamp sysDate = null;
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null; 	
		int parentNodeListLength = 0;
		int childNodeListLength = 0;	
		double shortId = 0;
		int cntrInsert = 0;
		int cntrUpdate = 0;
		int noOfRecSelect = 0; //Gulzar - 22/08/08 Req ID : SY89SUN001
		String noVisitStr ="";
		try
		{			
			//conn = connDriver.getConnectDB("DriverITM");//Commented by vinayak on [11/07/2016]
			conn = getConnection();//Added by vinayak on [11/07/2016] to get connection.
			conn.setAutoCommit(false);
			
			/*InitialContext ctx = getInitialContext();
			ITMDBAccessLocal itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup( "ibase/ITMDBAccessEJB/local" );*/
			ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();

			//Added By Gulzar - 21/08/08 Req ID : SY89SUN001
			parentNodeList = detailDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength(); 
			//writeLog(filePtr,"Total No Of Record Selected for Process [parentNodeListLength]-->"+parentNodeListLength,true);//commented by sachin satre on [ 04-dec-17]
			System.out.println("Total No Of Record Selected for Process [parentNodeListLength]:: "+parentNodeListLength);
			if ( parentNodeListLength == 0 )
			{
				retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Data Found For Process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";		
				return retString;
			}
			//End Changes - Gulzar - 21/08/08 Req ID : SY89SUN001

			stmt = conn.createStatement();

			//For logonoff
			logOnOffFlag = "N";
			getSql = "select var_value from finparm where prd_code='999999' and var_name='STRGSERCPY_LOGONOFF'";
			rs = stmt.executeQuery(getSql);
			if (rs.next())
			{
				logOnOffFlag = rs.getString(1);
			}
			rs.close();
			rs = null;
			if (logOnOffFlag == null || logOnOffFlag.trim().length() == 0)
			{
				logOnOffFlag = "N";
			}
			System.out.println("----------------logOnOff:"+logOnOffFlag);
			
			currDate = new java.util.Date(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			currentDate = sdf.format(new java.util.Date());
			sysDate = java.sql.Timestamp.valueOf(genericUtility.getValidDateTimeString(currentDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()));

			salesPersFrom = genericUtility.getColumnValue("sales_pers__from",headerDom);
			salesPersTo = genericUtility.getColumnValue("sales_pers__to",headerDom);
			divisionOpt = genericUtility.getColumnValue("division_opt",headerDom);
			copyOpt = genericUtility.getColumnValue("copy_opt",headerDom);
			System.out.println("divisionOpt==================================>"+divisionOpt);
			System.out.println("copyOpt==================================>"+copyOpt);

			retString = "";

			sql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+ salesPersTo +"' ";
		//writeLog(filePtr,"sql-->"+sql,true);
			System.out.println("SQL form sales_pers :: "+sql);
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				itemSerDb = rs.getString("ITEM_SER");
			}
			rs.close();
			rs = null;
			
			sql = "SELECT MAX(CASE WHEN SHORT_ID IS NULL THEN 0 ELSE SHORT_ID END ) + 1 FROM STRG_SERIES WHERE SALES_PERS = '"+ salesPersTo +"' ";
			//writeLog(filePtr,"sql-->"+sql,true);
			System.out.println("SQL from strg_series :: "+sql);
			rs = stmt.executeQuery(sql);
			if (rs.next())
			{
				shortId = rs.getDouble(1);
			}
			rs.close();
			rs = null;
			System.out.println("shortId :: "+shortId);

			// Modified by Ramchandra [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [Start]
			String [] arrPropValue = null;
			String propValues = "";
			String routeType = "";
			Vector vector = new Vector();
			Boolean isNonCoverageRTypeDefined = false;
			propValues = getAllowedRouteType( salesPersTo, conn );
			if (propValues.trim().length() > 0)
			{
				if(propValues.indexOf(',')>0)
				{
					arrPropValue = propValues.split(",");
				}
				else 
				{
					arrPropValue = new String[1];
					arrPropValue[0] = propValues;
				}
				for(int k=0 ; k<arrPropValue.length ; k++)
				{
					vector.add(arrPropValue[k]);
				}
				System.out.println("[StrgSeriesPsrCopyPrc][process()][Vector::] " +vector);
				isNonCoverageRTypeDefined = true;
			}
			// Modified by Ramchandra [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor ] [End]

			sql = "SELECT TOTAL_BUSINESS, LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE = ? ";
			pstmtSel1 = conn.prepareStatement(sql);

			//Modified by Ramchandra on [28/07/2012] To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] 
			/*sql = "SELECT ROUTE_ID, (CASE WHEN STATUS IS NULL THEN 'N' ELSE STATUS END) AS STATUS "+
				"FROM SPRS_ROUTE WHERE LOCALITY_CODE = ? AND SPRS_CODE = ? ";*/
			sql = "SELECT ROUTE_ID, (CASE WHEN STATUS IS NULL THEN 'N' ELSE STATUS END) AS STATUS, ROUTE_TYPE FROM SPRS_ROUTE WHERE LOCALITY_CODE = ? AND SPRS_CODE = ? ";
			System.out.println("[StrgSeriesPsrCopyPrc][process()][sql::] " +sql);

			pstmtSel2 = conn.prepareStatement(sql);
			sql = "INSERT INTO STRG_SERIES ( "
				+" SC_CODE, "
				+" ITEM_SER, "
				+" SALES_PERS, "
				+" CLASS_CODE, "
				+" CHG_USER, "
				+" CHG_DATE, "
				+" CHG_TERM, "
				+" SHORT_ID , "
				+" REASON,	"
				+" CHG_TYPE, "
				+" EFF_DATE, "
				+" TOTAL_BUSINESS, "
				+" ROUTE_ID, "
				+" STATUS, "
				+" REPLY_STATUS, "
				+" SPL_CODE, "
				+" NO_VISIT, "
				+" NO_PATIENT_DAY, "
				+" SALES_PERS__OLD "
				//Added by satya on 03/06/10[WS90SUN031].start
				+", RETAILER_CODE "
				+", RETAILER_NAME "
				+", RETAILER_ADR1 "
				+", RETAILER_ADR2 "
				+", RETAILER_ADR3 "
				+", RETAILER_CITY "
				+", RETAILER_PIN  "
				+", RETAILER_TEL1 "
				+", RETAILER_TEL2 "
				+", RETAILER_MOBNO "
				+", RETAILER_LOCALITY "
				+", CATEGORY "//the value of this field shoud also copied gulzar - 10/01/11 - WS01SUN038
				//ADDED BY SACHIN SATRE ON [14-MAR-17] [START]
				+", OCCU_TYPE "
				+", SUB_SPL_CODE "
				+", RX_MODE "
				+", ASSO_TYPE "
				+", PATIENT_PROFILE "
				+", AGE_BRACKET "
				//ADDED BY SACHIN SATRE ON [14-MAR-17] [END]
				//ADDED BY SACHIN SATRE ON [05-JUN-17] [START]
				+", QUALIFICATION "  
				+", MOBILE_NO  " 
				+", EMAIL_ADDR "
				+", CUST_TYPE " 
				//ADDED BY SACHIN SATRE ON [05-JUN-17] [END]
				//+" ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";//commented by satya
				+"  ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?  ,?,?,?,?,?,?  ,?,?,?,?) ";
				//Added by satya on 03/06/10[WS90SUN031].end
			System.out.println("SQL :<<S: "+sql);
			pstmtIns1 = conn.prepareStatement(sql);

			sql = "INSERT INTO STRG_SERIES ( "
				+" SC_CODE, "
				+" ITEM_SER, "
				+" SALES_PERS, "
				+" CLASS_CODE, "
				+" NO_VISIT, "
				+" TOTAL_BUSINESS, "
				+" BUSINESS_TO_US, "
				+" SALES_PERS__OLD, "
				+" CHG_USER, "
				+" CHG_DATE, "
				+" CHG_TERM, "
				+" SHORT_ID , "
				+" REASON,	"
				+" CHG_TYPE, "
				+" EFF_DATE, "
				+" SPL_CODE, "
				+" REPLY_STATUS, "
				+" ROUTE_ID, "
				+" SORT_SEQ, "
				+" STATUS, "
				+" NO_PATIENT_DAY "
				//Added by satya on 03/06/10[WS90SUN031].start
				+",RETAILER_CODE"
				+",RETAILER_NAME"
				+",RETAILER_ADR1"
				+",RETAILER_ADR2"
				+",RETAILER_ADR3"
				+",RETAILER_CITY"
				+",RETAILER_PIN "
				+",RETAILER_TEL1"
				+",RETAILER_TEL2"
				+",RETAILER_MOBNO"
				+",RETAILER_LOCALITY"
				+",CATEGORY "//the value of this field shoud also copied gulzar - 10/01/11 - WS01SUN038
				//ADDED BY SACHIN SATRE ON [14-MAR-17] [START]
				+", OCCU_TYPE "
				+", SUB_SPL_CODE "
				+", RX_MODE "
				+", ASSO_TYPE "
				+", PATIENT_PROFILE "
				+", AGE_BRACKET "
				//ADDED BY SACHIN SATRE ON [14-MAR-17] [END]
				//ADDED BY SACHIN SATRE ON [05-JUN-17] [START]
				+", QUALIFICATION "  
				+", MOBILE_NO  " 
				+", EMAIL_ADDR "
				+", CUST_TYPE " 
				//ADDED BY SACHIN SATRE ON [05-JUN-17] [END]
				//+" ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";//commented by satya on 03/06/04
				+" ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?  ,?,?,?,?,?,?  ,?,?,?,?) ";
				//added by satya on 03/06/04[WS90SUN031].end
			System.out.println("SQL :>>: "+sql);
			pstmtIns2 = conn.prepareStatement(sql);
			
			String insertStrgStatHistSql ="INSERT INTO STRG_STATUS_HIST(TRAN_ID, TRAN_DATE, SALES_PERS, SC_CODE, CUST_TYPE, ITEM_SER, ROUTE_ID, "+
					"EFF_FROM , VALID_UPTO, STATUS, CHG_DATE , CHG_USER, CHG_TERM, EDITFLAG) "+
					"VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

			pstmtInsertStrgStatHist = conn.prepareStatement(insertStrgStatHistSql);
			
			int noVisitsIntAll =0;
			for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				cntrInsert = 0;
				int noVisitsInt =0;
				String noVisitStr1 ="";
				parentNode = parentNodeList.item(selectedRow);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				System.out.println("childNodeListLength::: "+ childNodeListLength+"\n");
				//writeLog(filePtr,"childNodeListLength-->"+childNodeListLength,true);
				for (int childRow = 0; childRow < childNodeListLength; childRow++)
				{
					childNode = childNodeList.item(childRow);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equals("sc_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							scCode = childNode.getFirstChild().getNodeValue();
							System.out.println("scCode :: "+scCode);
						}
					}
					if (childNodeName.equals("class_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							classCode = childNode.getFirstChild().getNodeValue();
							System.out.println("classCode :: "+classCode);
						}
					}

					//Modified by Ramchandra on [01/08/2012] [To retrive required fields only from dom][Start]
					/*if (childNodeName.equals("reason"))
					{
						if(childNode.getFirstChild()!=null)
						{
							reason = childNode.getFirstChild().getNodeValue();
							System.out.println("reason :: "+reason);
						}
					}
					if (childNodeName.equals("eff_date"))
					{
						if(childNode.getFirstChild()!=null)
						{
							String tmpDate = childNode.getFirstChild().getNodeValue();
							if (tmpDate.length()>10)
							{
								tmpDate = tmpDate.substring(0,9);
							}
							effDate = genericUtility.getValidDateString(tmpDate,genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat());
							System.out.println("effDate :: "+effDate);
						}
					}*/
					//Modified by Ramchandra on [01/08/2012][To retrive required fields only from dom] [End]

					if (childNodeName.equals("spl_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							splCode = childNode.getFirstChild().getNodeValue();
							System.out.println("splCode :: "+splCode);
						}
					}
					if (childNodeName.equals("no_of_visit"))
					{
						if(childNode.getFirstChild()!=null)
						{
							if ((childNode.getFirstChild().getNodeValue()) == null || (childNode.getFirstChild().getNodeValue()).trim().length() == 0)
							{
								noVisit = 0;
							}
							else
							{
								noVisit = Double.parseDouble(childNode.getFirstChild().getNodeValue());
								noVisitStr1 = childNode.getFirstChild().getNodeValue();
								
							}
							System.out.println("noVisit::"+noVisit);
						}
					}

					//Modified by Ramchadra on [01/08/2012][To Retrive required fields only from dom] [Start]
					/*if (childNodeName.equals("no_patient_day"))
					{
						if(childNode.getFirstChild()!=null)
						{
							if ((childNode.getFirstChild().getNodeValue()) == null || (childNode.getFirstChild().getNodeValue()).trim().length() == 0)
							{
								noPatientDay = 0;
							}
							else
							{
								noPatientDay = Double.parseDouble(childNode.getFirstChild().getNodeValue());
							}
							System.out.println("noPatientDay::"+noPatientDay);
						}
					}*/
					//Modified by Ramchandra on [01/08/2012][To retrive required fields only from dom] [End]

					if (childNodeName.equals("item_ser"))
					{
						if(childNode.getFirstChild()!=null)
						{
							itemSer = childNode.getFirstChild().getNodeValue();
							System.out.println("itemSer::"+itemSer);
						}
					}
					if (childNodeName.equals("route_id"))
					{
						if(childNode.getFirstChild()!=null)
						{
							routeId = childNode.getFirstChild().getNodeValue();
							routeidFr = routeId; //Gulzar - 9/19/2008
							System.out.println("routeId:IN DOM:"+routeId);
						}
					}
					/*if (childNodeName.equals("is_selected"))
					{
						if(childNode.getFirstChild()!=null)
						{
							isSelected = childNode.getFirstChild().getNodeValue();
							System.out.println("isSelected::"+isSelected);
						}
					}*/
					if (childNodeName.equals("is_selected"))
					{
						System.out.println("childNode.getFirstChild():::::"+childNode.getFirstChild());
						if(childNode.getFirstChild()!=null)
						{
							isSelected = childNode.getFirstChild().getNodeValue();
							System.out.println("isSelected::"+isSelected);

							//Modified by Abhishek on [18/11/2013][To set the isSelected value always as true][Start]
							isSelected = "true";
							System.out.println("isSelected::"+isSelected);

							//Modified by Abhishek on [18/11/2013][To set the isSelected value always as true][End]
							
						}
					}
					//ADDED BY SACHIN SATRE [14-MAR-17] [START]
					/*if (childNodeName.equals("occu_type"))
					{
						if(childNode.getFirstChild()!=null)
						{
							occType = childNode.getFirstChild().getNodeValue();
							System.out.println("occu_type::"+occType);
						}
					}
					if (childNodeName.equals("sub_spl_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							subSplCode = childNode.getFirstChild().getNodeValue();
							System.out.println("sub_spl_code::"+subSplCode);
						}
					}
					if (childNodeName.equals("rx_mode"))
					{
						if(childNode.getFirstChild()!=null)
						{
							rxMode = childNode.getFirstChild().getNodeValue();
							System.out.println("rx_mode::"+rxMode);
						}
					}
					if (childNodeName.equals("asso_type"))
					{
						if(childNode.getFirstChild()!=null)
						{
							assoType = childNode.getFirstChild().getNodeValue();
							System.out.println("asso_type::"+assoType);
						}
					}
					if (childNodeName.equals("patient_profile"))
					{
						if(childNode.getFirstChild()!=null)
						{
							patientProfile = childNode.getFirstChild().getNodeValue();
							System.out.println("patient_profile::"+patientProfile);
						}
					}
					if (childNodeName.equals("age_bracket"))
					{
						if(childNode.getFirstChild()!=null)
						{
							ageBracket = childNode.getFirstChild().getNodeValue();
							System.out.println("age_bracket::"+ageBracket);
						}
					}*/
					if (childNodeName.equals("sprs_route_locality_code"))
					{
						if(childNode.getFirstChild()!=null)
						{
							localityCode = childNode.getFirstChild().getNodeValue();
							System.out.println("sprs_route_locality_code::"+localityCode);
						}
					}
					//ADDED BY SACHIN SATRE [14-MAR-17] [END]
					//Modified by Ramchandra on [01/08/2012][To retrive required fields only from dom] [Start]
					/*

					//Added by satya on 03/06/10[WS90SUN031].start
					if (childNodeName.equals("retailer_code"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerCode = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_name"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerName = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_adr1"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerAdr1 = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_adr2"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerAdr2 = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_adr3"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerAdr3 = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_city"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerCity = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_pin"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerPin = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_tel1"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerTel1 = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_tel2"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerTel2 = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_mobno"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerMobNo = childNode.getFirstChild().getNodeValue();
						}
					}
					if (childNodeName.equals("retailer_locality"))
					{
						if (childNode.getFirstChild() != null)
						{
							retailerLocality = childNode.getFirstChild().getNodeValue();
						}
					}
					//Added by satya on 03/06/10[WS90SUN031].end
					//Added gulzar - 10/01/11 - WS01SUN038
					if (childNodeName.equals("category"))
					{
						if (childNode.getFirstChild() != null)
						{
							category = childNode.getFirstChild().getNodeValue();
						}
					}
					//End changes gulzar - 10/01/11 - WS01SUN038
					
					*/					
					//Modified by Ramchandra on [01/08/2012][To Retrive required fields only from dom] [End]

				} //for (int childRow = 0; childRow < childNodeListLength; childRow++)
				//noVisitStr = noVisitStr + noVisitStr1;
				System.out.println("isSelected: beforessr:>>>"+isSelected);
				if ( isSelected != null && isSelected.trim().equalsIgnoreCase("true") )
				{
					if(noVisitStr1 != null && noVisitStr1.trim().length() > 0  )
					{	
						noVisitsInt  = Integer.parseInt(noVisitStr1);
					}	
					noVisitsIntAll = noVisitsIntAll + noVisitsInt;
					noOfRecSelect++;
					shortId++;
					if ( itemSerDb != null && itemSerDb.trim().length() > 0 )
					{
						itemSer = itemSerDb;
					}
					//Modified by Ramchandra on [31/07/2012] [To insert field values in strg series for add psr list and change psr for Doctor ][Start]
					PreparedStatement pstmtSel3 = null;
					ResultSet rs3 = null;
					String sql3 = "";
					sql3 = "SELECT  "
						+" STRG_SERIES.REASON, "
						+" STRG_SERIES.EFF_DATE, "
						+" STRG_SERIES.NO_PATIENT_DAY, "
						+" STRG_SERIES.RETAILER_CODE, "
						+" STRG_SERIES.RETAILER_NAME, "
						+" STRG_SERIES.RETAILER_ADR1, "
						+" STRG_SERIES.RETAILER_ADR2, "
						+" STRG_SERIES.RETAILER_ADR3, "
						+" STRG_SERIES.RETAILER_CITY, "
						+" STRG_SERIES.RETAILER_PIN, "
						+" STRG_SERIES.RETAILER_TEL1, "
						+" STRG_SERIES.RETAILER_TEL2, "
						+" STRG_SERIES.RETAILER_MOBNO, "
						+" STRG_SERIES.RETAILER_LOCALITY, "
						+" STRG_SERIES.CATEGORY, " 
						//ADDED BY SACHIN SATRE ON [14-MAR-17] [START]
						+" STRG_SERIES.OCCU_TYPE, "
						+" STRG_SERIES.SUB_SPL_CODE ,"
						+" STRG_SERIES.RX_MODE, "
						+" STRG_SERIES.ASSO_TYPE ,"
						+" STRG_SERIES.PATIENT_PROFILE, "
						+" STRG_SERIES.AGE_BRACKET "
						//ADDED BY SACHIN SATRE ON [14-MAR-17] [END]
						//changed by sachin satre on [05-jun-17] [start]
					 	+",STRG_SERIES.QUALIFICATION ,  "
					 	+" STRG_SERIES.MOBILE_NO ,  " 
					 	+" STRG_SERIES.EMAIL_ADDR , " 
					 	+" STRG_SERIES.CUST_TYPE  " 
					 	//changed by sachin satre on [05-jun-17] [start]
						+" FROM STRG_CUSTOMER , "
						+" STRG_SERIES, " 
						+" ITEMSER, "
						+" SALES_PERS,  "
						+" SPRS_ROUTE  "
						+" WHERE "
						+" ( STRG_SERIES.SALES_PERS__OLD = SALES_PERS.SALES_PERS (+)) AND "
						+" ( STRG_SERIES.SC_CODE = STRG_CUSTOMER.SC_CODE ) AND " 
						+" ( STRG_SERIES.ITEM_SER = ITEMSER.ITEM_SER ) "
						+" AND  ( STRG_SERIES.SALES_PERS = SPRS_ROUTE.SPRS_CODE) AND "
						+" ( STRG_SERIES.ROUTE_ID = SPRS_ROUTE.ROUTE_ID) "
						+" AND  ( STRG_SERIES.SC_CODE = ? )  "
						+" AND  ( STRG_SERIES.SALES_PERS = ? ) "
						//added by sachin satre on [03-apr-2017] [start]
						+" AND  ( STRG_SERIES.ROUTE_ID = ? ) ";
						//added by sachin satre on [03-apr-2017] [end]
					System.out.println("[StrgSeriesPsrCopy][process()][sql3::] [" + sql3 +"]");
					pstmtSel3 = conn.prepareStatement(sql3);
					pstmtSel3.setString( 1, scCode );
					pstmtSel3.setString( 2, salesPersFrom );
					pstmtSel3.setString( 3, routeId );
					rs3 = pstmtSel3.executeQuery();
					pstmtSel3.clearParameters();
					if(  rs3.next() )
					{
						reason = rs3.getString("REASON");
						effDate = rs3.getString("EFF_DATE");
						noPatientDay = rs3.getDouble("NO_PATIENT_DAY");
						retailerCode = rs3.getString("RETAILER_CODE"); 
						retailerName = rs3.getString("RETAILER_NAME"); 
						retailerAdr1 = rs3.getString("RETAILER_ADR1" ); 
						retailerAdr2 = rs3.getString("RETAILER_ADR2"); 
						retailerAdr3 = rs3.getString("RETAILER_ADR3"); 
						retailerCity = rs3.getString("RETAILER_CITY");
						retailerPin = rs3.getString("RETAILER_PIN"); 
						retailerTel1 = rs3.getString("RETAILER_TEL1"); 
						retailerTel2 = rs3.getString("RETAILER_TEL2"); 
						retailerMobNo = rs3.getString("RETAILER_MOBNO"); 
						retailerLocality = rs3.getString("RETAILER_LOCALITY"); 
						category = rs3.getString("CATEGORY");
						//added by sachin satre [03-apr-2017] [start]
						occType = checkNull(rs3.getString("OCCU_TYPE"));  
						subSplCode = checkNull(rs3.getString("SUB_SPL_CODE"));  
						rxMode= checkNull(rs3.getString("RX_MODE"));  
						assoType = checkNull(rs3.getString("ASSO_TYPE"));  
						patientProfile = checkNull(rs3.getString("PATIENT_PROFILE"));  
						ageBracket =checkNull(rs3.getString("AGE_BRACKET"));  
						//added by sachin satre [03-apr-2017] [end]

						//ADDED BY SACHIN SATRE ON [05-JUN-17] [START]
						Qualification =checkNull(rs3.getString("QUALIFICATION"));
						mobNo =checkNull(rs3.getString("MOBILE_NO"));
						emailId =checkNull(rs3.getString("EMAIL_ADDR"));
						//ADDED BY SACHIN SATRE ON [05-JUN-17] [end]
						custType =checkNull(rs3.getString("CUST_TYPE"));
						
					}
					if (rs3 != null)
					{
						rs3.close();
						rs3 = null;
					}
					if ( pstmtSel3 != null )
					{
						pstmtSel3.close();
						pstmtSel3 = null;
					}
					//Modified by Ramchandra on [31/07/2012] [To insert field values in strg series for add psr list and change psr for Doctor][End]

					if ( copyOpt != null && copyOpt.trim().length() > 0 && copyOpt.trim().equals("1") )
					{
						dscCode = "0";
						System.out.println("inside copy opt 1 add list locality code ::> ["+localityCode+"]");
						pstmtSel1.setString( 1, scCode );
						rs = pstmtSel1.executeQuery();
						pstmtSel1.clearParameters();
						if ( rs.next() )
						{
							totalBuss = rs.getFloat("TOTAL_BUSINESS");
							//localityCode = rs.getString("LOCALITY_CODE");
						}
						rs.close();
						rs = null;
						/*--Gulzar - 14/05/10
						sql = "SELECT TOTAL_BUSINESS FROM STRG_CUSTOMER WHERE SC_CODE = '"+ scCode +"' ";
						writeLog(filePtr,"sql-->"+sql,true);
						System.out.println("SQL from strg_customer :: "+sql);
						rs = stmt.executeQuery(sql);
						totalBuss = 0f;
						if (rs.next())
						{
							totalBuss = rs.getFloat("TOTAL_BUSINESS");
						}
						rs.close();

						sql = "SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE = '"+ scCode +"' ";
						writeLog(filePtr,"sql-->"+sql,true);
						System.out.println("SQL from strg_customer :: "+sql);
						rs = stmt.executeQuery(sql);
						if (rs.next())
						{
							localityCode = rs.getString("LOCALITY_CODE");
						*/
						System.out.println("before executing sprs route id :::>>"+localityCode);
						if ( localityCode != null && localityCode.trim().length() > 0 )
						{
							pstmtSel2.setString( 1, localityCode );
							pstmtSel2.setString( 2, salesPersTo );
							rs = pstmtSel2.executeQuery();
							pstmtSel2.clearParameters();
							if ( !rs.next() )
							{
								retString = itmDBAccessLocal.getErrorString("LOCALITY_CODE","VTLOCCODE",userId);
								break;
							}
							else
							{
								routeId = rs.getString("ROUTE_ID");
								status = rs.getString("STATUS");
								
								//Modified by Ramchandra on [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor]
								routeType = rs.getString("ROUTE_TYPE");
							}
							rs.close();
							rs = null;
							
							/* --Gulzar - 14/05/10
							sql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ localityCode +"' AND "
								+" SPRS_CODE = '"+ salesPersTo +"' ";
							writeLog(filePtr,"sql-->"+sql,true);
							System.out.println("SQL from sprs_route :: "+sql);
							stmt1 = conn.createStatement();
							rs1 = stmt1.executeQuery(sql);
							if ( !rs1.next() )
							{
								retString = itmDBAccessLocal.getErrorString("LOCALITY_CODE","VTLOCCODE",userId);
								break;
							}
							else
							{
								routeId = rs1.getString(1);
							}
							rs1.close();
							stmt1.close();
							
							sql = "SELECT (CASE WHEN STATUS IS NULL THEN 'N' ELSE STATUS END) AS STATUS FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ localityCode +"'	"
								+" AND SPRS_CODE = '"+ salesPersTo +"' ";
							writeLog(filePtr,"sql-->"+sql,true);
							System.out.println("select SQL from status :: "+sql);
							stmt1 = conn.createStatement();
							rs1 = stmt1.executeQuery(sql);
							status = "N";
							if (rs1.next())
							{
								status = rs1.getString("STATUS");
							}
							rs1.close();
							stmt1.close();
							*/
							if ( status != null && status.trim().length() > 0 && !status.equals("Y") )
							{

								//Modified by Ramchandra on [30/07/2012] [To change Message Descripton for deactivated doctor]
								//retString = itmDBAccessLocal.getErrorString("STATUS","VTSTATUS",userId);
								retString = itmDBAccessLocal.getErrorString("STATUS","VPDTSTATUS",userId);
								break;
							}
							
							//Modified by Ramchandra on [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [Start]
							else if (isNonCoverageRTypeDefined)
							{
								if(vector.contains(routeType))
								{
									retString = itmDBAccessLocal.getErrorString("ROUTE_TYPE","VPDTROUTE3",userId);
									break;
								}
							}
							//Modified by Ramchandra on [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [End]

							if (scCode.equals(dscCode))
							{
								sql = "SELECT RES_LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE = '"+ scCode +"' ";
								//writeLog(filePtr,"sql-->"+sql,true);
								System.out.println("select SQL from strg_customer :: "+sql);
								rs = stmt.executeQuery(sql);
								resLocalityCode = "";
								if (rs.next())
								{
									resLocalityCode = rs.getString("RES_LOCALITY_CODE");
								}
								rs.close();
								rs = null;

								sql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ resLocalityCode +"' AND "
									+" SPRS_CODE = '"+ salesPersTo +"' ";
								writeLog(filePtr,"sql-->"+sql,true);
								System.out.println("select SQL from sprs_route :: "+sql);
								rs = stmt.executeQuery(sql);
								resRouteId = "";
								if (rs.next())
								{
									resRouteId = rs.getString("ROUTE_ID");
								}
								rs.close();
								rs = null;
								if ( resRouteId == null || resRouteId.trim().length() == 0 )
								{
									retString = itmDBAccessLocal.getErrorString("ROUTE_ID","VTROUTID",userId);
									break;
								}
								else
								{
									routeId = resRouteId;
								}
							}
							else
							{
								dscCode = scCode;
							}
						}
						else
						{
							retString = itmDBAccessLocal.getErrorString("LOCALITY_CODE","VTLOCCODE",userId);
							break;
						}

						pstmtIns1.setString(1,scCode);
						pstmtIns1.setString(2,itemSer);
						pstmtIns1.setString(3,salesPersTo);
						pstmtIns1.setString(4,classCode);
						pstmtIns1.setString(5,userId);
						pstmtIns1.setTimestamp(6,sysDate);
						pstmtIns1.setString(7,userId);
						pstmtIns1.setDouble(8,shortId);
						pstmtIns1.setString(9,reason);
						pstmtIns1.setString(10,"A");
						pstmtIns1.setTimestamp(11,sysDate);
						pstmtIns1.setFloat(12,totalBuss);
						pstmtIns1.setString(13,routeId);
						pstmtIns1.setString(14,"Y");
						pstmtIns1.setString(15,"0");
						pstmtIns1.setString(16,splCode);
						pstmtIns1.setDouble(17,noVisit);
						pstmtIns1.setDouble(18,noPatientDay);
						pstmtIns1.setString(19,salesPersFrom);
						//added by satya on 03/06/04[WS90SUN031].start
						pstmtIns1.setString(20,retailerCode);
						pstmtIns1.setString(21,retailerName);
						pstmtIns1.setString(22,retailerAdr1);
						pstmtIns1.setString(23,retailerAdr2);
						pstmtIns1.setString(24,retailerAdr3);
						pstmtIns1.setString(25,retailerCity);
						pstmtIns1.setString(26,retailerPin);
						pstmtIns1.setString(27,retailerTel1);
						pstmtIns1.setString(28,retailerTel2);
						pstmtIns1.setString(29,retailerMobNo);
						pstmtIns1.setString(30,retailerLocality);
						//added by satya on 03/06/04[WS90SUN031].end
						pstmtIns1.setString(31,category);//Gulzar - 10/01/11 - WS01SUN038 set the value of category
						//ADDED BY SACHIN SATRE ON [14-MAR-17] [START]
						pstmtIns1.setString(32,occType);
						pstmtIns1.setString(33,subSplCode);
						pstmtIns1.setString(34,rxMode);
						pstmtIns1.setString(35,assoType);
						pstmtIns1.setString(36,patientProfile);
						pstmtIns1.setString(37,ageBracket);
						//ADDED BY SACHIN SATRE ON [14-MAR-17] [END]
						//ADDED BY SACHIN SATRE ON [05-JUN-17] [START]
						pstmtIns1.setString(38,Qualification);
						pstmtIns1.setString(39,mobNo);
						pstmtIns1.setString(40,emailId);
						//ADDED BY SACHIN SATRE ON [05-JUN-17] [end]
						pstmtIns1.setString(41,custType);
						cntrInsert = pstmtIns1.executeUpdate();
						pstmtIns1.clearParameters();

						if (cntrInsert > 0)
						{
							System.out.println("Inserted into STRG_SERIES Successfully [cntrInsert] ::"+cntrInsert);
						}
					}//if ( copyOpt != null && copyOpt.trim().length()>0 && copyOpt.trim().equals("1"))
					else if ( copyOpt != null && copyOpt.trim().length() > 0 && copyOpt.trim().equals("2") )//Change PSR
					{
						dscCode = "0";
						System.out.println("inside copy opt 2 locality code ::> ["+localityCode+"]");
						/*
						sql = "SELECT NVL(MAX(SHORT_ID),0) FROM STRG_SERIES WHERE SALES_PERS = '"+ salesPersTo +"' ";
						writeLog(filePtr,"sql-->"+sql,true);
						System.out.println("SQL from strg_series :: "+sql);
						stmt = conn.createStatement();
						rs = stmt.executeQuery(sql);
						if (rs.next())
						{
							shortId = rs.getDouble(1);
						}
						rs.close();
						stmt.close();
						shortId = shortId + 1;
						*/

						sql = "SELECT TOTAL_BUSINESS, BUSINESS_TO_US, SPL_CODE, SORT_SEQ FROM STRG_SERIES "
							+" WHERE SC_CODE = '"+ scCode +"' AND ITEM_SER = '"+ itemSer +"' AND SALES_PERS = '"+ salesPersFrom +"' ";
						//writeLog(filePtr,"sql-->"+sql,true);
						System.out.println("SQL from strg_series :: "+sql);
						stmt = conn.createStatement();
						rs = stmt.executeQuery(sql);
						if (rs.next())
						{
							totalBuss = rs.getFloat("TOTAL_BUSINESS");
							bussToUs = rs.getFloat("BUSINESS_TO_US");
							splCode = rs.getString("SPL_CODE");
							sortSeq = rs.getString("SORT_SEQ");
						}
						rs.close();
						stmt.close();

						sql = "SELECT LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE = '"+ scCode +"' ";
					//	writeLog(filePtr,"sql-->"+sql,true);
						System.out.println("SQL from strg_customer :: "+sql);
						stmt = conn.createStatement();
						System.out.println("inside copy opt 2 BEFORE GET LOCALITY FROM STRG_CUSTOMERlocality code ::> ["+localityCode+"]");
						rs = stmt.executeQuery(sql);
						if (rs.next())
						{
							//localityCode = rs.getString("LOCALITY_CODE");
							sql = " UPDATE STRG_SERIES SET STATUS = ?, CHG_USER = ? , CHG_DATE = ?, CHG_TERM = ? "
								+" 	WHERE SC_CODE = '"+ scCode +"' AND ITEM_SER = '"+ itemSer +"' AND SALES_PERS = '"+ salesPersFrom +"' ";
							//writeLog(filePtr,"sql-->"+sql,true);
							System.out.println("Update Sql for strg_series :: "+sql);
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,"N");
							pstmt.setString(2,userId);
							pstmt.setTimestamp(3,sysDate);
							pstmt.setString(4,userId);
							cntrUpdate = pstmt.executeUpdate();
							if (cntrUpdate > 0)
							{
								System.out.println("STRG_SERIES table is updated.........:" +cntrUpdate);
							}
							else
							{
								System.out.println("STRG_SERIES table is not updated.........");
							}
							pstmt.close();
							pstmt = null;
							cntrUpdate = 0;
							//Added - Gulzar - 9/19/2008
							int count = 0;
							sql = "SELECT COUNT(1) AS COUNT FROM STRG_SERIES WHERE SALES_PERS = '"+ salesPersFrom +"'  " +
									 "AND ROUTE_ID = '"+routeidFr+"' AND STATUS = 'Y' ";
							System.out.println("Selecte Sql  :: "+sql);
							stmt1 = conn.createStatement();
							rs1 = stmt1.executeQuery(sql);
							if ( rs1.next() )
							{
								count = rs1.getInt("COUNT");
							}
							rs1.close();
							rs1 = null;
							//End Gulzar - 9/19/2008
							if ( count == 0 )
							{
								//Commented and Changes below  Gulzar - 9/19/2008
								//sql = "UPDATE SPRS_ROUTE SET STATUS = ? WHERE SPRS_CODE = '"+ salesPersFrom +"' "
								//	+" AND LOCALITY_CODE = '"+ localityCode +"' ";

								//Start Commented and changes below by bharath to update CHG_DATE,CHG_USER,CHG_TERM- 13/02/09 ()
								//sql = "UPDATE SPRS_ROUTE SET STATUS = ? WHERE SPRS_CODE = '"+ salesPersFrom +"' "
								//	+" AND ROUTE_ID = '"+ routeidFr +"' ";
								sql = "UPDATE SPRS_ROUTE SET STATUS = ?, CHG_USER = ?, CHG_DATE = ? , CHG_TERM = ? WHERE SPRS_CODE = '"+ salesPersFrom +"' "
									+" AND ROUTE_ID = '"+ routeidFr +"' ";
								//End changes by bharath - 13/02/09()
								//End Changes Gulzar - 9/19/2008
								//writeLog(filePtr,"sql-->"+sql,true);
								System.out.println("Update Sql for sprs_route :: "+sql);
								pstmt =  conn.prepareStatement(sql);
								pstmt.setString(1,"N");
								//Start changes by bharath- 13/02/09							
								pstmt.setString(2,userId);
								pstmt.setTimestamp(3,sysDate);
								pstmt.setString(4,termId);
								//End  changes by bharath- 13/02/09							
								cntrUpdate = pstmt.executeUpdate();
								if (cntrUpdate > 0)
								{
									System.out.println("SPRS_ROUTE table is updated.............:" + cntrUpdate);
								}
								else
								{
									System.out.println("SPRS_ROUTE table id nor updated.........");
								}
								pstmt.close();
								pstmt = null;
							}
							cntrUpdate = 0;

							sql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ localityCode +"' "
								+" AND SPRS_CODE = '"+ salesPersTo +"' ";
							//writeLog(filePtr,"sql-->"+sql,true);
							System.out.println("select SQL from sprs_route :: "+sql);
							rs1 = stmt1.executeQuery(sql);
							if (rs1.next())
							{
								routeId = rs1.getString("ROUTE_ID");
							}
							else
							{
								retString = itmDBAccessLocal.getErrorString("ROUTE_ID","VTROUTID",userId);
								break;
							}
							rs1.close();
							rs1 = null;

							// Modified by Ramchandra [30/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor]
							/*sql = "SELECT STATUS FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ localityCode +"'	"
								+" AND SPRS_CODE = '"+ salesPersTo +"' ";*/
							System.out.println("inside copy opt 2 GET ROUTE TYPE AND STATUS IN SPRS_ROUTE locality code ::> ["+localityCode+"]");
							sql = "SELECT STATUS, ROUTE_TYPE  FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ localityCode +"' AND SPRS_CODE = '"+ salesPersTo +"' ";
							//writeLog(filePtr,"sql-->"+sql,true);
							System.out.println("select SQL from status :: "+sql);
							stmt1 = conn.createStatement();
							rs1 = stmt1.executeQuery(sql);
							status = "";
							if (rs1.next())
							{
								status = rs1.getString("STATUS");
								//Modified by Ramchandra on [30/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor]
								routeType = rs1.getString("ROUTE_TYPE");
							}
							rs1.close();
							rs1 = null;

							if (status != null && status.trim().length() > 0 && !status.equals("Y"))
							{

								//Modified by Ramchandra on [30/07/2012] [To change Message Descripton for deactivated doctor]
								//retString = itmDBAccessLocal.getErrorString("STATUS","VTSTATUS",userId);
								retString = itmDBAccessLocal.getErrorString("STATUS","VPDTSTATUS",userId);
								break;
							}

							//Modified by Ramchandra on [30/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [Start]
							else if (isNonCoverageRTypeDefined)
							{
								if(vector.contains(routeType))
								{
									retString = itmDBAccessLocal.getErrorString("ROUTE_TYPE","VPDTROUTE3",userId);
									break;
								}
							}
							//Modified by Ramchandra on [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [End]

							if (scCode.equals(dscCode))
							{
								sql = "SELECT RES_LOCALITY_CODE FROM STRG_CUSTOMER WHERE SC_CODE = '"+ scCode +"' ";
								//writeLog(filePtr,"sql-->"+sql,true);
								System.out.println("select SQL from strg_customer :: "+sql);
								stmt1 = conn.createStatement();
								rs1 = stmt1.executeQuery(sql);
								if (rs1.next())
								{
									resLocalityCode = rs1.getString("RES_LOCALITY_CODE");
								}
								rs1.close();
								rs1 = null;

								sql = "SELECT ROUTE_ID FROM SPRS_ROUTE WHERE LOCALITY_CODE = '"+ resLocalityCode +"' AND "
									+" SPRS_CODE = '"+ salesPersTo +"' ";
								//writeLog(filePtr,"sql-->"+sql,true);
								System.out.println("select SQL from sprs_route :: "+sql);
								rs1 = stmt1.executeQuery(sql);
								resRouteId = "";
								if (rs1.next())
								{
									resRouteId = rs1.getString("ROUTE_ID");
									routeId = resRouteId;
								}
								rs1.close();
								rs1 = null;
								if (resRouteId == null || resRouteId.trim().length() == 0)
								{
									retString = itmDBAccessLocal.getErrorString("ROUTE_ID","VTROUTID",userId);
									break;
								}
								else
								{
									routeId = resRouteId;
								}
							}
							else
							{
								dscCode = scCode;
							}
							if ( stmt1 != null )
							{
								stmt1.close();
								stmt1 = null;
							}
						}
						else
						{
							retString = itmDBAccessLocal.getErrorString("LOCALITY_CODE","VTLOCCODE",userId);
							break;
						}
						rs.close();
						stmt.close();
						if (retString != null && retString.trim().length() > 0)
						{
							break;
						}

						cntrInsert = 0;
						pstmtIns2.setString(1,scCode);
						pstmtIns2.setString(2,itemSer);
						pstmtIns2.setString(3,salesPersTo);
						pstmtIns2.setString(4,classCode);
						pstmtIns2.setDouble(5,noVisit);
						pstmtIns2.setFloat(6,totalBuss);
						pstmtIns2.setFloat(7,bussToUs);
						pstmtIns2.setString(8,salesPersFrom);
						pstmtIns2.setString(9,userId);
						pstmtIns2.setTimestamp(10,sysDate);
						pstmtIns2.setString(11,userId);
						pstmtIns2.setDouble(12,shortId);
						pstmtIns2.setString(13,reason);
						//pstmt.setString(14,"T"); //Gulzar - 9/19/2008
						pstmtIns2.setString(14,"C"); //Gulzar - 9/19/2008
						pstmtIns2.setTimestamp(15,sysDate);
						pstmtIns2.setString(16,splCode);
						pstmtIns2.setString(17,"0");
						pstmtIns2.setString(18,routeId);
						pstmtIns2.setString(19,sortSeq);
						pstmtIns2.setString(20,"Y");
						pstmtIns2.setDouble(21,noPatientDay);
						//Added by satya on 03/06/10[WS90SUN031].start
						pstmtIns2.setString(22,retailerCode);
						pstmtIns2.setString(23,retailerName);
						pstmtIns2.setString(24,retailerAdr1);
						pstmtIns2.setString(25,retailerAdr2);
						pstmtIns2.setString(26,retailerAdr3);
						pstmtIns2.setString(27,retailerCity);
						pstmtIns2.setString(28,retailerPin);
						pstmtIns2.setString(29,retailerTel1);
						pstmtIns2.setString(30,retailerTel2);
						pstmtIns2.setString(31,retailerMobNo);
						pstmtIns2.setString(32,retailerLocality);
						//Added by satya on 03/06/10[WS90SUN031].end
						pstmtIns2.setString(33,category);//Gulzar - 10/01/11 - WS01SUN038 set the value of category
						//ADDED BY SACHIN SATRE ON [14-MAR-17] [START]
						pstmtIns2.setString(34,occType);
						pstmtIns2.setString(35,subSplCode);
						pstmtIns2.setString(36,rxMode);
						pstmtIns2.setString(37,assoType);
						pstmtIns2.setString(38,patientProfile);
						pstmtIns2.setString(39,ageBracket);
						//ADDED BY SACHIN SATRE ON [14-MAR-17] [END]
						//ADDED BY SACHIN SATRE ON [05-JUN-17] [START]
						pstmtIns2.setString(40,Qualification);
						pstmtIns2.setString(41,mobNo);
						pstmtIns2.setString(42,emailId);
						//ADDED BY SACHIN SATRE ON [05-JUN-17] [end]
						pstmtIns2.setString(43,custType);
						cntrInsert = pstmtIns2.executeUpdate();
						pstmtIns2.clearParameters();
						if (cntrInsert > 0)
						{
							System.out.println("Inserted into STRG_SERIES Successfully [cntrInsert] ::"+cntrInsert);
						}
					}//else if (copyOpt != null && copyOpt.trim().length()>0 && copyOpt.trim().equals("2"))
					
					String currDateNew = sdf.format(new java.util.Date());
					currDateNew = genericUtility.getValidDateTimeString( currDateNew, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
					String tranIdStatHist = generateTranID( conn ) ;
					Calendar cal = Calendar.getInstance();
					cal.setTime( sysDate );
					cal.add( Calendar.YEAR , 10 );
					String validUpto = genericUtility.getValidDateTimeString(sdf.format(cal.getTime()), genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());

					pstmtInsertStrgStatHist.setString(1, tranIdStatHist);
					pstmtInsertStrgStatHist.setTimestamp(2, java.sql.Timestamp.valueOf(currDateNew));
					pstmtInsertStrgStatHist.setString(3, salesPersTo);
					pstmtInsertStrgStatHist.setString(4, scCode);
					pstmtInsertStrgStatHist.setString(5, custType);
					pstmtInsertStrgStatHist.setString(6, itemSer);
					pstmtInsertStrgStatHist.setString(7, routeId);
					pstmtInsertStrgStatHist.setTimestamp(8, sysDate);
					pstmtInsertStrgStatHist.setTimestamp(9, java.sql.Timestamp.valueOf(validUpto));
					pstmtInsertStrgStatHist.setString(10, "Y");
					pstmtInsertStrgStatHist.setTimestamp(11, java.sql.Timestamp.valueOf(currDateNew));
					pstmtInsertStrgStatHist.setString(12, "SYSTEM");
					pstmtInsertStrgStatHist.setString(13, "SYSTEM");
					pstmtInsertStrgStatHist.setString(14, "A");

					int strgSerHistInsCount = pstmtInsertStrgStatHist.executeUpdate();
					pstmtInsertStrgStatHist.clearParameters();

					System.out.println("Insert into STRG_STATUS_HIST [strgSerHistInsCount] =["+strgSerHistInsCount+"]");
					
				}//if ( isSelected != null && isSelected.trim().equalsIgnoreCase("true") )
			}//for (int selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			if ( noOfRecSelect > 0 ) 
			{
				//ADDED BY SACHIN SATRE ON [30-NOV-17 ] FOR REQUEST ID : W17ISUN002 [START]
				
				WSFACommon sfaCommon = new WSFACommon();
				HashMap<String,String> docVisitCntHM=  new HashMap<String, String>();
				docVisitCntHM = sfaCommon.getVisitData(salesPersTo, itemSer, conn);
				
				SimpleDateFormat sdfs = new SimpleDateFormat(genericUtility.getApplDateFormat());
				java.util.Date date = Calendar.getInstance().getTime(); 
				String currDates = sdfs.format( date ); 
				System.out.println(" updateWEndDate :: currDate :: ["+currDate+"]"+"date::>>"+date);
				String gradeLevelNo = "";
				ResultSet  rsGetData = null;
				PreparedStatement pstmtGetData = null;
				ResultSet  rsVisit = null;
				PreparedStatement pstmtVisit = null;
				ResultSet  rsCustomer = null;
				PreparedStatement pstmtCustomer = null;
				ResultSet  rsGetDetail = null;
				PreparedStatement pstmtGetDetail = null;
				String sql1 ="";
				int serCnt = 0;
				String empSite= "";
				String minStrgVisit ="";
				String maxStrgVisit ="";
				String minStrgCustomr ="";
				String maxStrgCustomr ="";
				String applVisit ="";
				boolean  isRecExists = false ;
				
				
				System.out.println("docVisitCntHM:>>:"+docVisitCntHM+"]");
				if(!docVisitCntHM.isEmpty())
				//if(isRecExists == true )
				{	
					//sql1=" SELECT SUM(NO_VISIT) AS NO_VISIT FROM STRG_SERIES WHERE SALES_PERS = ? AND ITEM_SER = ? AND STATUS = 'Y' AND SC_CODE <> ? ";
					sql1=" SELECT SUM(NO_VISIT) AS NO_VISIT FROM STRG_SERIES WHERE SALES_PERS = ? AND ITEM_SER = ? AND STATUS = 'Y'";
					pstmtVisit = conn.prepareStatement(sql1);
					pstmtVisit.setString(1, salesPersTo );
					pstmtVisit.setString(2,itemSer);
					//pstmtVisit.setString(3,scCode);
					rsVisit = pstmtVisit.executeQuery();
					System.out.println("After calling  calculating all data is getting");
					int totVstExist = 0 ;
					if( rsVisit.next() )
					{
						totVstExist  = rsVisit.getInt(1);	
					}
					if(rsVisit != null)
					{
						rsVisit.close(); 
						rsVisit = null;
					}
					if(pstmtVisit != null)
					{
						pstmtVisit.close();
						pstmtVisit = null;
					}
					//sql1="SELECT COUNT(*) AS CUSTOMER_COUNT FROM STRG_SERIES WHERE SALES_PERS = ? AND ITEM_SER = ? AND STATUS = 'Y' AND SC_CODE <> ? ";
					sql1="SELECT COUNT(*) AS CUSTOMER_COUNT FROM STRG_SERIES WHERE SALES_PERS = ? AND ITEM_SER = ? AND STATUS = 'Y' ";
					pstmtCustomer = conn.prepareStatement(sql1);
					pstmtCustomer.setString(1, salesPersTo );
					pstmtCustomer.setString(2,itemSer);
					//pstmtCustomer.setString(3,scCode);
					rsCustomer = pstmtCustomer.executeQuery();
					System.out.println(" then sachin After calling  calculating all data is getting");
					int customerCnt = 0 ;
					String strgCustCnt ="";
					if( rsCustomer.next() )
					{
						strgCustCnt  = rsCustomer.getString("CUSTOMER_COUNT");	
						System.out.println("strgCustCnt:::"+strgCustCnt);
					}
					if(strgCustCnt != null && strgCustCnt.trim().length() > 0)
					{	
						customerCnt= Integer.parseInt(strgCustCnt);
						System.out.println("customerCnt:sacaschjh::"+customerCnt);
					}
					if(rsCustomer != null)
					{
						rsCustomer.close(); 
						rsCustomer = null;
					}
					if(pstmtCustomer != null)
					{
						pstmtCustomer.close();
						pstmtCustomer = null;
					}
					int noVis = 0 ;
					if(noVisitStr != null && noVisitStr.trim().length() > 0)
					{	
						noVis= Integer.parseInt(noVisitStr);
					}	
					//int totalVisit = totVstExist + noVisitsIntAll ;
					int totalVisit = totVstExist  ;
					System.out.println("value of customerCnt is::....DFDF......"+customerCnt+":noVisitsIntAll :noOfRecSelect::"+noOfRecSelect+"::noVisitsIntAll::"+noVisitsIntAll);
				//	customerCnt = customerCnt + noOfRecSelect; 
					int maxStrgVisitCnt = 0 ;
					int maxStrgCustomerCnt = 0 ;
					for(Map.Entry<String, String> m:docVisitCntHM.entrySet())
					{
						System.out.println("sdfsdf");
						maxStrgCustomr =(String)m.getKey();
						maxStrgVisit =(String)m.getValue();
						System.out.println("keysdfkeydkdj::key::"+maxStrgCustomr+"::valueMaxVisits:::"+maxStrgVisit);
					}	
					
					if(maxStrgVisit != null && maxStrgVisit.trim().length() > 0)
					{
						maxStrgVisitCnt = Integer.parseInt(maxStrgVisit);
					}
					if(maxStrgCustomr != null && maxStrgCustomr.trim().length() > 0)
					{
						maxStrgCustomerCnt = Integer.parseInt(maxStrgCustomr);
					}
					System.out.println("value of customerCnt is::.........."+customerCnt);
					System.out.println("value of noVisit is:noVisitsIntAll:."+noVisitsIntAll);
					System.out.println("value of  totVstExist is::........."+totVstExist);
					System.out.println("value of minStrgVisit is::........."+minStrgVisit);
					System.out.println("value of maxStrgVisit is::........."+maxStrgVisit);
					System.out.println("value of minStrgCustomr is::......."+minStrgCustomr);
					System.out.println("value of maxStrgCustomr is::......."+maxStrgCustomr);
					System.out.println("value of totalVisit is::..........."+totalVisit);
					System.out.println("value of customerCnt is::..........."+customerCnt);
					
					if( (customerCnt > maxStrgCustomerCnt)  )
					{
						System.out.println("total doctor is greater validation");
						retString = itmDBAccessLocal.getErrorString( "no_visit", "DCVISTEXCD", userId );
						
					}
					else if( (totalVisit > maxStrgVisitCnt)  )
					{
						System.out.println("totalVisit is greater validation");
						retString = itmDBAccessLocal.getErrorString( "no_visit", "NOVISTEXCD", userId );//NOVISTEXCD
						
					}
					
				}
			}	
			//System.out.println("value of totVst is::........."+totVst);
			
			//ADDED BY SACHIN SATRE ON [30-NOV-17 ] FOR REQUEST ID : W17ISUN002 [end]	
			
			
			if ( noOfRecSelect == 0 ) //Added Gulzar - 22/08/08 Req ID : SY89SUN001
			{
				retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"DS000NR\" type=\"E\" column_name=\"\"><message>Process Not Done</message><description>No Data Found For Process, Please select the record for process</description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
			}
			else if (retString != null && retString.trim().length() > 0)
			{
				conn.rollback();
			}
			else
			{
				conn.commit();
				//Added by Ganesh [29/06/2013] [To change message for process][Start]
				//retString = "<?xml version=\"1.0\"?><Root><Errors><error id=\"VPROCESS1\" type=\"E\" column_name=\"\"><message>Process Done Successfully</message><description>Process Done Successfully </description><type>E</type><option>Y</option><time>null</time><alarm>null</alarm><source>null</source><trace></trace><redirect>1</redirect></error></Errors></Root>";
				retString = itmDBAccessLocal.getErrorString( "status", "VPROCESS1", userId );
				//Added by Ganesh [29/06/2013] [To change message for process][End]
			}
		}	
		catch(SQLException se)
		{
			System.out.println("Exception : StrgSeriesPsrCopyPrc : process():" +se.getMessage());
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			writeLog(filePtr,"Exception in process-->"+se,true);
			throw new ITMException(se);
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch(Exception se1){}
			writeLog(filePtr,"Exception in process-->"+e,true);
			System.out.println( e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}  
		finally
		{
			try
			{
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( pstmtSel1 != null )
				{
					pstmtSel1.close();
					pstmtSel1 = null;
				}
				if ( pstmtSel2 != null )
				{
					pstmtSel2.close();
					pstmtSel2 = null;
				}
				if ( pstmtIns1 != null )
				{
					pstmtIns1.close();
					pstmtIns1 = null;
				}
				if ( pstmtIns2 != null )
				{
					pstmtIns2.close();
					pstmtIns2 = null;
				}
				if(pstmtInsertStrgStatHist != null)
				{
					pstmtInsertStrgStatHist.close();
					pstmtInsertStrgStatHist = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch (Exception e)
			{
				writeLog(filePtr,"Exception in process-->"+e,true);
				System.out.println(e.getMessage());
				e.printStackTrace();
			}
		}			
		return retString;
	}
	//Added - Gulzar - 31/05/08 - For checking of null values
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}
	protected InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("ITMException :[StrgSeriesPsrCopyPrc] :getInitialContext :==>");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("Exception :[StrgSeriesPsrCopyPrc] :getInitialContext :==>");
			throw new ITMException(e);
		}
		return ctx;
	}

	//Modified by Ramchandra on [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [Start]
	private String getAllowedRouteType( String loginEmpCode, Connection conn ) throws ITMException
	{
		Statement cstmt = null;
		ResultSet rst = null;
		String propValue = "";
		String propSql = "";
		Statement cstmt1 = null;
		ResultSet rst1 = null;
		String propSql1 = "";
		Boolean isPropFound = false;
		try
		{		
			propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER = (SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = '"+loginEmpCode+"') "  ;
			cstmt = conn.createStatement();
			rst = cstmt.executeQuery(propSql);	
			System.out.println("[StrgSeriesPsrCopy] [getAllowedRouteType()][QUERY::] " +propSql);
			if(rst.next())
			{
				propValue = rst.getString("PROP_VALUE");	
				isPropFound = true;
			}
			System.out.println("propValue:::"+propValue);
			if(isPropFound == false)
			{
				propSql1 = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = 'SPRSALLOWEDROUTETYPE' AND ITEM_SER ='ALL' "  ;
				cstmt1 = conn.createStatement();
				rst1 = cstmt1.executeQuery(propSql1);	
				System.out.println("[StrgSeriesPsrCopy] [getAllowedRouteType()][QUERY@IF::] " +propSql1);
				if(rst1.next())
				{
					propValue = rst1.getString("PROP_VALUE");	
				}
				System.out.println("[StrgSeriesPsrCopy] [getAllowedRouteType()][propValue@IF:::] " +propValue);
			}
			
			if (rst != null)
			{
				rst.close();
				rst = null;
			}
			if ( cstmt != null )
			{
				cstmt.close();
				cstmt = null;
			}
			if (rst1 != null)
			{
				rst1.close();
				rst1 = null;
			}
			if ( cstmt1 != null )
			{
				cstmt1.close();
				cstmt1 = null;
			}
			if (propValue == null)
			{
				propValue = "";
			}

		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rst != null)
				{
					rst.close();
					rst = null;
				}
				if ( cstmt != null )
				{
					cstmt.close();
					cstmt = null;
				}
				if (rst1 != null)
				{
					rst1.close();
					rst1 = null;
				}
				if ( cstmt1 != null )
				{
					cstmt1.close();
					cstmt1 = null;
				}
			}
			catch(Exception e1){}
		}
		return propValue;
	}
	//Modified by Ramchandra on [28/07/2012] [To does not allow if RouteType "M" and "T" in strg series for add psr list and change psr for Doctor] [End]
	private String generateTranID( Connection conn ) throws ITMException
	{
		String uniqueKey = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try
		{

			System.out.println("StrgSerStatusHistBean : Generating Primary Key ...........");
						
			String keyStringQuery = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = 't_strg_series_st' ";
			pstmt = conn.prepareStatement(keyStringQuery);
			rs = pstmt.executeQuery();			
			
			if(rs.next())
			{
				String keyString = rs.getString("KEY_STRING");
				String keyCol = rs.getString("TRAN_ID_COL");
				String tranSer = rs.getString("REF_SER");
				TransIDGenerator tg = new TransIDGenerator("<Root></Root>", "BASE", CommonConstants.DB_NAME);
				//uniqueKey = tg.generateTranSeqID(tranSer, keyCol, "seq10", conn);
				uniqueKey = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);//changed keyString to pass value of keyString.
				
			}
			rs.close();	rs = null;
			pstmt.close();
			pstmt = null;

		}
		catch(Exception exp)
		{
			System.out.println("Exception : StrgSerStatusHistBean :generateTransID :==>\n");
			throw new ITMException(exp);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch (Exception e)
			{
				System.out.println("Exception : StrgSerStatusHistBean :getUniqueKey :finally==>");
				throw new ITMException(e);
			}
		}
		System.out.println("Generated Primary Key :"+uniqueKey);
		return uniqueKey; 
	}
}