//Coding by Vidhya Prabhu on 24/06/09
package ibase.webitm.ejb.wsfa.transactions;

import java.lang.reflect.Array;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Properties;
import java.util.TreeMap;

import javax.naming.InitialContext;

import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
//import ibase.webitm.utility.GenericUtility;//changed by rahul 10-apr-2015
import ibase.utility.E12GenericUtility; //changed by rahul on 10-apr-2015
import ibase.webitm.bean.wsfa.DARCommonBean;
import ibase.webitm.bean.wsfa.OrgStructure;
import ibase.webitm.bean.wsfa.StrgMeetWizardBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wsfa.WSFACommon;

//@javax.ejb.Stateless			commented by Sagar M [22 Nov 2018].
public class CustomerSurveyWizard extends ValidatorEJB 
{
	static int domID = 1;
	protected E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();



	public String checkNull(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	//to check if current dom contains values (for previous action)
	public boolean preDomExists(Document dom, String currentFormNo) throws ITMException
	{
		System.out.println("Inside DAR preDomExists");
		NodeList parentList = null;
		NodeList childList = null;
		Node childNode = null;
		boolean selected = false;

		try
		{
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			System.out.println("Inside DAR preDomExists parentList:"+parentList);
			if ( parentList.item(0) != null )
			{
				childList = parentList.item(0).getChildNodes();
				System.out.println("Inside DAR preDomExists childList:"+childList);
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					System.out.println("Inside DAR preDomExists childNode:"+childNode);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						System.out.println("Column found DAR!!!" + childNode.getNodeName());
						selected = true;
						break;
					}
				}
			}


		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaStrgMeetDCREJB :preDomExists :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("preDomExists in  DAR =["+selected+"] and currentFormNo in DAR =["+currentFormNo+"]");

		return selected;
	}

	//to get previous dom values and set selected attribute to 'y' (for previous action)
	public String getPrevFormValues( Document dom, String currentFormNo, ArrayList temp, String colName) throws ITMException
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			//System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}

	public String valHoliday(String eventdate, String empCode, String userId, ITMDBAccessLocal itmDBAccessLocal, Connection connectionObject,String updateFlag) throws Exception
	{
		String errString = "";
		StrgMeetWizardBean strgMeetWizardBean = new StrgMeetWizardBean();
		eventdate = genericUtility.getValidDateTimeString( eventdate , getApplDateFormat() , getDBDateFormat());
		boolean isHoliday = strgMeetWizardBean.isEmpHoliday(empCode, eventdate, connectionObject);
		if(isHoliday && ! updateFlag.equalsIgnoreCase("E"))
		{
			errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
		}
		return errString;
	}


	public String getSelectedRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;

		try
		{
			detailList = dom.getElementsByTagName("Detail"+formNo);
			//System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			parentNode = detailList.item(rowNo);
			//System.out.println("parentNode....."+parentNode);
			elementAttr = (Element)parentNode;
			childList = parentNode.getChildNodes();
			//System.out.println("childList....."+childList);
			noOfChilds = childList.getLength();

			if ( parentNode != null )
			{
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(colName) )
					{
						if(childNode.getFirstChild()!=null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
							break;
						}
					}
				}
			}

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
		}

		return columnValue;
	}


	public String getDCRId(Connection conn, String salesPers, String dcrDate) throws Exception
	{
		String dcrID = "";
		PreparedStatement pstmtDCRID = null;
		ResultSet rsDCRID = null;
		try
		{
			String activityCode = "";
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			String dcrSql = "SELECT DISTINCT DCR_ID FROM STRG_MEET A, FIELDACTIVITY B WHERE A.EVENT_TYPE = B.ACTIVITY_CODE AND A.EVENT_DATE = ? AND A.SALES_PERS = ? AND B.ACTIVITY_TYPE <>'PR'" ;

			pstmtDCRID = conn.prepareStatement( dcrSql );
			pstmtDCRID.setTimestamp(1, java.sql.Timestamp.valueOf(dcrDate));
			pstmtDCRID.setString(2, salesPers);
			rsDCRID = pstmtDCRID.executeQuery();
			if( rsDCRID.next() )
			{
				dcrID = (rsDCRID.getString("DCR_ID") == null )?"":rsDCRID.getString("DCR_ID");
			}

		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsDCRID != null)
				{
					rsDCRID.close();
					rsDCRID = null;
				}
				if(pstmtDCRID !=null)
				{
					pstmtDCRID.close();
					pstmtDCRID = null;
				}
			}
			catch(Exception e1){}
		}
		//System.out.println("dcrID =["+dcrID+"]");
		return dcrID;
	}

	public String getDSRPlanData(String salesPers,String eventDate,Connection conn) throws ITMException //Chnaged by sachin satre on 11-nov-16
	{
		String returnXmlString="";
		String sprsPlanSql="";
		String planActivity="";
		String planLocality="";
		PreparedStatement sprsPstmt=null;
		ResultSet sprsResultSet= null;
		//Connection conn = null;
		//Commented and Changes Done By Gaurav Singh on 03-Sep-14
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		StringBuffer valueXmlString = new StringBuffer();
		StringBuffer sprsPlanDetail = new StringBuffer();
		int count=0;
		boolean isLocalConn =false;
		try
		{
			if(conn == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB( "DriverITM" );*/
				conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				isLocalConn =true;
			}
			sprsPlanSql=" SELECT A.LOCALITY_CODE, B.ACTIVITY_TYPE  ACTIVITY_TYPE, C.DESCR LOC_DESCR FROM SPRS_PLAN A, FIELDACTIVITY B, LOCALITY C " +
					" WHERE A.PLAN_ACTIVITY = B.ACTIVITY_CODE AND A.LOCALITY_CODE = C.LOCALITY_CODE AND A.SPRS_CODE__PLAN = ? " +
					" AND A.PLAN_DATE = ? ";
			//valueXmlString.append("<table>\r\n");
			sprsPstmt = conn.prepareStatement(sprsPlanSql);
			sprsPstmt.setString(1, salesPers );
			//sprsPstmt.setString(2, salesPers );
			sprsPstmt.setTimestamp( 2, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			sprsResultSet = sprsPstmt.executeQuery();
			while(sprsResultSet.next())
			{
				count++;
				planActivity=sprsResultSet.getString("ACTIVITY_TYPE");
				planLocality=sprsResultSet.getString("LOC_DESCR");
				//System.out.println("planActivity=["+planActivity+"],planLocality=["+planLocality+"]");
				valueXmlString.append("<tr>");
				//System.out.println("\n Count =["+count+"]");
				if(count==1)
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append(planActivity).append("</plan_activity></td>");
				}
				else
				{
					valueXmlString.append("<td class=\"td_leftAlign\"><plan_activity>").append("").append("</plan_activity></td>");
				}
				valueXmlString.append("<td class=\"td_leftAlign\"><plan_locality>").append(planLocality).append("</plan_locality></td>");
				valueXmlString.append("</tr>");
			}
			//sprsPlanDetail.append("<dsr_plan_data>").append(valueXmlString).append("</dsr_plan_data>\r\n");
			sprsPlanDetail.append("<dsr_plan_data>").append("<![CDATA["+valueXmlString+"]]>").append("</dsr_plan_data>\r\n");
			//valueXmlString.append("</table>\r\n");
			sprsResultSet.close();sprsResultSet=null;
			sprsPstmt.close();sprsPstmt=null;
		}
		catch (Exception e)
		{
			System.out.println("Exception :WsfaDSRMobileWizardEJB:getDSRPlanData()\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if(sprsResultSet!=null)
				{
					sprsResultSet.close();
					sprsResultSet=null;
				}
				if(sprsPstmt!=null)
				{
					sprsPstmt.close();
					sprsPstmt=null;
				}
				if(isLocalConn && conn!=null)
				{
					conn.close();
					conn=null;
				}

			}
			catch(Exception fe)
			{
				//System.out.println("Exception :WsfaDSRMobileWizardEJB:getDSRPlanData(): finaly block \n"+fe.getMessage());
				fe.printStackTrace();
			}
		}
		returnXmlString=sprsPlanDetail.toString();
		//System.out.println("returnXmlString=["+returnXmlString+"]");

		return returnXmlString;
	}
	/*public String valHoliday(String eventdate, String sprs, String userId, ITMDBAccessLocal itmDBAccessLocal)
	{
		GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;

		try
		{
			connectionObject = getConnection();
			//Checking Hodiday
			eventdate = genericUtility.getValidDateString( eventdate , getApplDateFormat() , "dd-MMM-yyyy");
			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			//System.out.println(" sql [" + checkSQL + "]" );
			pstmt = connectionObject.prepareStatement(checkSQL);
			pstmt.setString(1,checkNull(eventdate));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				String code = rs.getString( "CODE" );
				//changes done by prathamesh jangam for db2 on 06/7/17
				//checkSQL = "SELECT FN_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					checkSQL = "SELECT DDF_GET_EMP_HOLIDAY(?,?,?,?) HOLDATE FROM DUAL ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					checkSQL = "SELECT FN_GET_EMP_HOLIDAY(CAST(? AS CHAR(10)),CAST(? AS CHAR(6)),CAST(? AS CHAR(6)),CAST(? AS TIMESTAMP)) HOLDATE FROM DUAL ";
				}

				System.out.println("sql [" + checkSQL + "] ");

				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				pstmt = connectionObject.prepareStatement(checkSQL);
				pstmt.setString(1,checkNull(sprs));
				pstmt.setString(2,checkNull(code));
				pstmt.setString(3,checkNull(code));
				pstmt.setString(4,checkNull(eventdate));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					String holDate = rs.getString( 1 );
					//System.out.println(" holDate [" + holDate + "] ");
					if ( holDate != null )
					{
						errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
					}
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				if (connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}*/
	public String checkSequentialReporting(Connection connectionObject, String salesPers, String dcrDate)throws  ITMException
	{
		boolean isError = false;
		PreparedStatement pstmt = null ;
		ResultSet rs = null ;
		String sql = "";
		PreparedStatement pstmtLastDcr = null;//modified by kailash.
		ResultSet rsLastDcr = null;//modified by kailash.
		String errString = "";
		try
		{
			StrgMeetWizardBean strgMeetWizardBean = new StrgMeetWizardBean();
			SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());

			//GenericUtility genericUtility = GenericUtility.getInstance();
			String dcrDateString = dcrDate;
			dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );

			//System.out.println("::::salesPers" + salesPers + "::::dcrDate" + dcrDate);
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			String dateOfJoin = "";
			java.util.Date date = null;
			Object dateObj = null;
			//added by mruanlini sinkar fro check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 on 5-april-2019(start)

			int repContChkDays = 0;
			String checkSQL = " SELECT REP_CONT_CHK_DAYS FROM SALES_PERS WHERE SALES_PERS = ? ";
			pstmt = connectionObject.prepareStatement(checkSQL);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				repContChkDays = rs.getInt("REP_CONT_CHK_DAYS");
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

			//added by mruanlini sinkar fro check sequentail reporting only when salesperson REP_CONT_CHK_DAYS value is 0 on 5-april-2019(end)



			String oldLastDCRDate="";
			String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", connectionObject));
			String actTrandcrDate = "";
			String lastDCRDate = "";
			String sqlLastDcr = "";
			sqlLastDcr = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM STRG_MEET WHERE SALES_PERS = ?  AND  EVENT_DATE <= ? "+
					"AND EVENT_TYPE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;;
			pstmt =  connectionObject.prepareStatement(sqlLastDcr);
			pstmt.setString(1, salesPers);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
			rs = pstmt.executeQuery();

			if(rs.next())
			{

				dateObj =  ((rs.getDate("LAST_DCR_DATE") == null) ?"":rs.getDate("LAST_DCR_DATE"));
				if(dateObj.toString() != null && dateObj.toString().trim().length() > 0)
				{
					date = (Date) dateObj;
					actTrandcrDate = dtFormat.format( date );
				}
				System.out.println("actTrandcrDate =["+actTrandcrDate+"]");
				if("Y".equalsIgnoreCase(oldData) && actTrandcrDate!=null  && actTrandcrDate.trim().length() > 0)
				{

					Object olddateObj = null;
					java.util.Date oldDate = null;
					String oldLastDcr = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE SALES_PERS = ?  AND  WORK_DATE <= ? "+
							"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;;
					pstmtLastDcr =  connectionObject.prepareStatement(oldLastDcr);
					pstmtLastDcr.setString(1, salesPers);
					pstmtLastDcr.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
					rsLastDcr = pstmtLastDcr.executeQuery();

					if(rsLastDcr.next())
					{

						olddateObj =  ((rsLastDcr.getDate("LAST_DCR_DATE") == null) ?"":rsLastDcr.getDate("LAST_DCR_DATE"));
						if(olddateObj.toString() != null && olddateObj.toString().trim().length() > 0)
						{
							oldDate = (Date) olddateObj;
							oldLastDCRDate = dtFormat.format( oldDate );
						}
					}
					if (rsLastDcr!= null)
					{
						rsLastDcr.close();
						rsLastDcr = null;
					}
					if(pstmtLastDcr!=null)
					{
						pstmtLastDcr.close();
						pstmtLastDcr = null;
					}

					SimpleDateFormat dbFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
					java.util.Date drMainDate = null;
					java.util.Date actTranDate = null;
					if (oldLastDCRDate != null && oldLastDCRDate.trim().length() > 0)
					{
						drMainDate = sdfFormat.parse(oldLastDCRDate);
					}
					if (actTrandcrDate != null && actTrandcrDate.trim().length() > 0)
					{
						actTranDate = sdfFormat.parse(actTrandcrDate);
					}

					if (drMainDate != null && actTranDate != null )
					{
						if(drMainDate.after(actTranDate))
						{
							lastDCRDate = oldLastDCRDate;
						}
						else
						{
							lastDCRDate = actTrandcrDate;
						}
					}
				}
				else if("Y".equalsIgnoreCase(oldData) && actTrandcrDate.trim().length() == 0)
				{
					Object olddateObj = null;
					java.util.Date oldDate = null;
					String oldLastDcr = "SELECT MAX(WORK_DATE) LAST_DCR_DATE FROM DR_MAIN WHERE SALES_PERS = ?  AND  WORK_DATE <= ? "+
							"AND ACTIVITY_CODE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE != 'PR')"; // added by condition rupali on 14/03/17 for separate pr menu;;
					pstmtLastDcr =  connectionObject.prepareStatement(oldLastDcr);
					pstmtLastDcr.setString(1, salesPers);
					pstmtLastDcr.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
					rsLastDcr = pstmtLastDcr.executeQuery();

					if(rsLastDcr.next())
					{

						olddateObj =  ((rsLastDcr.getDate("LAST_DCR_DATE") == null) ?"":rsLastDcr.getDate("LAST_DCR_DATE"));
						if(olddateObj.toString() != null && olddateObj.toString().trim().length() > 0)
						{
							oldDate = (Date) olddateObj;
							lastDCRDate = dtFormat.format( oldDate );
						}
					}
					if (rsLastDcr!= null)
					{
						rsLastDcr.close();
						rsLastDcr = null;
					}
					if(pstmtLastDcr!=null)
					{
						pstmtLastDcr.close();
						pstmtLastDcr = null;
					}
				}
				else if(!"Y".equalsIgnoreCase(oldData) && actTrandcrDate!=null  && actTrandcrDate.trim().length() > 0)
				{
					lastDCRDate=actTrandcrDate;
				}
				System.out.println("lastDCRDate["+lastDCRDate+"]");

				if(lastDCRDate == null || lastDCRDate.trim().length()==0 || lastDCRDate == "" )
				{
					String sqlDateJoin = "";
					sqlDateJoin = "SELECT DATE_JOIN  FROM EMPLOYEE WHERE EMP_CODE = ? ";
					PreparedStatement pstmtDateJoin = null;
					ResultSet rsDateJoin = null;
					pstmtDateJoin =  connectionObject.prepareStatement(sqlDateJoin);
					pstmtDateJoin.setString(1, salesPers);
					rsDateJoin = pstmtDateJoin.executeQuery();

					java.util.Date dateJoin = null;

					if(rsDateJoin.next())
					{
						dateObj =  ((rsDateJoin.getDate("DATE_JOIN") == null) ?"":rsDateJoin.getDate("DATE_JOIN"));
						if(dateObj.toString()!=null && dateObj.toString().trim().length() > 0)
						{
							date = (Date)dateObj;
							dateJoin = date;
							dateOfJoin = dtFormat.format( date );
						}
						//System.out.println("dateOfJoin =["+dateOfJoin+"]");
					}
					if (rsDateJoin!= null)
					{
						rsDateJoin.close();
						rsDateJoin = null;
					}
					if(pstmtDateJoin!=null)
					{
						pstmtDateJoin.close();
						pstmtDateJoin = null;
					}

					//Changed by Gulzar on 31/08/13 : START
					String applStartDCRDateProp = "";
					java.util.Date applStartDCRDate = null;
					//String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DCR'";
					String propSql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME='APPL_START_DAR'";
					PreparedStatement pstmtProp = connectionObject.prepareStatement(propSql);

					ResultSet rsProp = pstmtProp.executeQuery();

					if(rsProp.next())
					{
						applStartDCRDateProp = rsProp.getString("PROP_VALUE");
					}
					//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
					if (rsProp!= null)
					{
						rsProp.close();
						rsProp = null;
					}
					if(pstmtProp!=null)
					{
						pstmtProp.close();
						pstmtProp = null;
					}
					//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
					java.util.Date searchDateFrom = dateJoin;

					if(applStartDCRDateProp != null && applStartDCRDateProp.trim().length() > 0)
					{
						try
						{
							/*// added by rupali on 09/11/17 for slving date parsing issue while entering first dcr [start]
							SimpleDateFormat inputFormat=new SimpleDateFormat("dd/MM/yyyy");
							Date eventDate=null;
							eventDate = inputFormat.parse(applStartDCRDateProp);
						    DateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy");
						    applStartDCRDateProp=sdf.format(eventDate);
						    // added by rupali on 09/11/17 for slving date parsing issue while entering first dcr [end]
							 */							applStartDCRDate = sdfFormat.parse(applStartDCRDateProp);

							 if(applStartDCRDate.after(dateJoin))
							 {
								 searchDateFrom = applStartDCRDate;
							 }
						}
						catch(Exception ex)
						{
							errString = getErrorString("event_date","INVDATEFMT","");
							return errString;
						}
					}

					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());

					java.util.Calendar cal = java.util.Calendar.getInstance();

					ArrayList<String> dateArr1 = new ArrayList<String>();

					Date eventDate1 = sdfFormat.parse(dcrDateString);
					cal.setTime( getDateObject( sdfFormat.format( eventDate1 ) ) );
					cal.add( cal.DATE, -1 );
					//sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());//Gulzar on 31/08/13
					String dcrDateString1 = sdfFormat.format(cal.getTime());
					Date eventDate2 = sdfFormat.parse(dcrDateString1);

					if(searchDateFrom.before(eventDate2))
					{
						int diffInDays = (int) Math.round((eventDate2.getTime()-searchDateFrom.getTime()) / (1000 * 60 * 60 * 24) );
						//System.out.println("::::diffInDays" + diffInDays + "::::eventDate1" + eventDate1 +"::::searchDateFrom" + searchDateFrom);
						cal.setTime( getDateObject( sdfFormat.format( searchDateFrom ) ) );

						for(int i=0;i< diffInDays;i++)
						{
							boolean flag1 = false;

							cal.add( cal.DATE, 1 );
							sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String newDcrDate = sdf.format(cal.getTime());
							String newDcrDateString = genericUtility.getValidDateTimeString( newDcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							//Commented by Mrunalini sinkar to make common boolean method of holiday(start)
							//flag1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
							flag1 = strgMeetWizardBean.isEmpHoliday(salesPers, newDcrDateString, connectionObject);
							//Commented by Mrunalini sinkar to make common boolean method of holiday(end)
							if(flag1 == false)
							{
								dateArr1.add(newDcrDate);
							}
						}

						//if(dateArr1 != null && dateArr1.size() > 0)// commented by mrunalini sinkar to add repContChkDays condition
						if(dateArr1 != null && dateArr1.size() > 0 && repContChkDays==0)
						{
							StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
							errString = getErrorString("event_date", "PENDDCR", salesPers);
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errStringXml.append("</Errors> </Root> \r\n");

							errString =errStringXml.toString();

							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
							String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) + dateArr1.toString();  ;
							String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
							String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

							errString = "";
							StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
							valueXmlErrorString.append("<error id=\"PENDDCR\" type=\"E\" column_name=\"event_date\">");
							valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
							valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
							valueXmlErrorString.append("<type>E</type>\r\n");
							valueXmlErrorString.append("<option></option>\r\n");
							valueXmlErrorString.append("<time></time>\r\n");
							valueXmlErrorString.append("<alarm></alarm>\r\n");
							valueXmlErrorString.append("<source></source>\r\n");
							valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
							valueXmlErrorString.append("<redirect>1</redirect>\r\n");
							valueXmlErrorString.append("</error>\r\n");
							valueXmlErrorString.append("</Errors>\r\n");
							valueXmlErrorString.append("</Header>\r\n");
							valueXmlErrorString.append( "</Root>\r\n" );
							//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
							errString =valueXmlErrorString.toString();
							return errString;
						}
					}
					//vishal
					if(rsProp != null)
					{
						rsProp.close(); rsProp = null;
					}
					if(pstmtProp != null)
					{
						pstmtProp.close(); pstmtProp = null;
					}

				}
				else
				{
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
					java.util.Calendar cal = java.util.Calendar.getInstance();



					ArrayList<String> dateArr = new ArrayList<String>();
					Date lastDCRDate1 = sdfFormat.parse(lastDCRDate);

					Date eventDate1 = sdfFormat.parse(dcrDateString);
					cal.setTime( getDateObject( sdfFormat.format( eventDate1 ) ) );
					cal.add( cal.DATE, -1 );
					sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					String dcrDateString1 = sdf.format(cal.getTime());
					Date eventDate2 = sdfFormat.parse(dcrDateString1);
					//System.out.println("eventDate2 =["+eventDate2+"]");

					if(lastDCRDate1.before(eventDate2))
					{
						int diffInDays = (int) Math.round((eventDate2.getTime()-lastDCRDate1.getTime()) / (1000 * 60 * 60 * 24) );
						//System.out.println("::::diffInDays" + diffInDays + "::::eventDate1" + eventDate1 +"::::lastDCRDate1" + lastDCRDate1);
						cal.setTime( getDateObject( sdfFormat.format( lastDCRDate1 ) ) );

						for(int i=0;i< diffInDays;i++)
						{
							boolean flagDCR1 = false;
							cal.add( cal.DATE, 1 );
							sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
							String newDcrDate = sdf.format(cal.getTime());
							String newDcrDateString = genericUtility.getValidDateTimeString( newDcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							//Commented by Mrunalini sinkar to make common boolean method of holiday(start)
							//flagDCR1 = validateHoliday( newDcrDateString ,salesPers, salesPers, connectionObject);
							flagDCR1 = strgMeetWizardBean.isEmpHoliday(salesPers, newDcrDateString, connectionObject);
							//Commented by Mrunalini sinkar to make common boolean method of holiday(end)

							if(flagDCR1 == false)
							{
								dateArr.add(newDcrDate);
							}
						}

						//if(dateArr != null && dateArr.size() > 0)// commented by mrunalini sinkar to add repContChkDays condition
						if(dateArr != null && dateArr.size() > 0 && repContChkDays == 0)
						{

							StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");
							errString = getErrorString("event_date", "PENDDCR", salesPers);
							String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
							bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
							errStringXml.append(bifurErrString);
							errStringXml.append("</Errors> </Root> \r\n");

							errString =errStringXml.toString();

							String msgDescr = errString.substring(errString.indexOf("<description>")+("<description>").length(),errString.indexOf("</description>"));
							String messageValue = msgDescr.substring(msgDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),msgDescr.indexOf("]")) + dateArr.toString();  ;
							String messageDescr = errString.substring(errString.indexOf("<message>")+("<message>").length(),errString.indexOf("</message>"));
							String message = messageDescr.substring(messageDescr.indexOf("<![CDATA[")+("<![CDATA[").length(),messageDescr.indexOf("]"));

							errString = "";
							StringBuffer valueXmlErrorString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
							valueXmlErrorString.append("<error id=\"PENDDCR\" type=\"E\" column_name=\"event_date\">");
							valueXmlErrorString.append("<message><![CDATA[").append(message).append("]]></message>\r\n");
							valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
							valueXmlErrorString.append("<type>E</type>\r\n");
							valueXmlErrorString.append("<option></option>\r\n");
							valueXmlErrorString.append("<time></time>\r\n");
							valueXmlErrorString.append("<alarm></alarm>\r\n");
							valueXmlErrorString.append("<source></source>\r\n");
							valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
							valueXmlErrorString.append("<redirect>1</redirect>\r\n");
							valueXmlErrorString.append("</error>\r\n");
							valueXmlErrorString.append("</Errors>\r\n");
							valueXmlErrorString.append("</Header>\r\n");
							valueXmlErrorString.append( "</Root>\r\n" );
							//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
							errString =valueXmlErrorString.toString();
							return errString;
						}
					}
				}
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			//System.out.println("Exception in findValue ");
			e.printStackTrace();
			throw new ITMException(e);
		}
		//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
		finally
		{
			try
			{
				if (rsLastDcr!= null)
				{
					rsLastDcr.close();
					rsLastDcr = null;
				}
				if(pstmtLastDcr!=null)
				{
					pstmtLastDcr.close();
					pstmtLastDcr = null;
				}
				//Added by Bhagyashri T  for dirty connection live[11/01/22][Start]
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//Added by Bhagyashri T  for dirty connection live[11/01/22][End]
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
		//System.out.println("checkSequentialReporting >> errString =[" + errString +"]");
		return errString;
	}
	/*private boolean validateHoliday(String eventdate, String sprs, String userId, Connection connectionObject) throws ITMException
	{
		//System.out.println("@@@@@@@@@@@@@@@@@@@valHoliday@@@@@@@@@@@@");
		//GenericUtility genericUtility = GenericUtility.getInstance();

		String errString = "";
		String columnValue = "";
		String checkSQL = "";
		String childNodeName = "";

		PreparedStatement pstmtPeriod = null;
		ResultSet rsPeriod = null ;

		boolean isHoliday = false;

		try
		{

			checkSQL = "SELECT CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
			//System.out.println(" sql [" + checkSQL + "]" );
			pstmtPeriod = connectionObject.prepareStatement(checkSQL);
			pstmtPeriod.setTimestamp(1, java.sql.Timestamp.valueOf(eventdate));
			rsPeriod = pstmtPeriod.executeQuery();

			if(rsPeriod.next())
			{
				String code = rsPeriod.getString( "CODE" );
				String holDate = getEmpHoliday (sprs ,code ,code ,eventdate, connectionObject);
				if ( holDate != null )
				{
					isHoliday = true;
				}
				else
				{
					isHoliday =  false;
				}
			}
			else
			{
				isHoliday =  false;
			}

			if (rsPeriod != null)
			{
				rsPeriod.close();
				rsPeriod = null;
			}
			if(pstmtPeriod !=null)
			{
				pstmtPeriod.close();
				pstmtPeriod = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if (rsPeriod != null)
				{
					rsPeriod.close();
					rsPeriod = null;
				}
				if(pstmtPeriod !=null)
				{
					pstmtPeriod.close();
					pstmtPeriod = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return isHoliday;
	}*/

	/*private String getEmpHoliday (String empCode , String prdCodeFr , String prdCodeTo , String date, Connection conn) throws Exception
	{
		String holDate = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String holtblno = getHoltblno(empCode,date, conn);

			String Sql = " SELECT HOL_DATE AS A_HOL_DATE FROM HOLIDAY WHERE HOL_TBLNO = ? AND HOL_DATE = ? ";
			pstmt = conn.prepareStatement(Sql);
			pstmt.setString(1, holtblno);
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(date));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				holDate = rs.getString("A_HOL_DATE");
			}
			//added by mrunalini sinkar (start)
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//adde by mrunalini sinkar (end)
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("holDate =["+holDate+"]");
		return holDate;
	}*/

	public String getHoltblno (String emplCode, String eventDate, Connection conn ) throws Exception
	{
		int count = 0;
		int cnt = 0;
		String sql = null;
		String sqlCnt = null;
		String holTblNo = null;
		String sqlTbl = null;
		String sqlTblNo = null;
		PreparedStatement pstmtCount = null;
		ResultSet rsCount = null;
		PreparedStatement pstmtCnt = null;
		ResultSet rsCnt = null;
		PreparedStatement pstmtSet = null;
		ResultSet rsSet = null;
		PreparedStatement pstmtTbl = null;
		ResultSet rsTbl = null;
		PreparedStatement pstmtTblno = null;
		ResultSet rsTblno = null;

		try
		{
			sql = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED = 'Y'";
			pstmtCount = conn.prepareStatement(sql);
			pstmtCount.setString(1, emplCode);
			rsCount = pstmtCount.executeQuery();

			if(rsCount.next())
			{
				count = rsCount.getInt("COUNT");
			}
			//added by mrunalini sinkar (start)
			if (rsCount != null)
			{
				rsCount.close();
				rsCount = null;
			}
			if(pstmtCount !=null)
			{
				pstmtCount.close();
				pstmtCount = null;
			}
			//adde by mrunalini sinkar (end)
			//System.out.println("EMP_EMPLOY_EVENTS count =["+count+"]");
			if(count > 0 )
			{
				String sql1 = " SELECT COUNT(*) AS COUNT FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND EFF_DATE = (SELECT MAX(EFF_DATE) FROM EMP_EMPLOY_EVENTS WHERE EMP_CODE = ? AND CONFIRMED =  'Y'AND EFF_DATE <= ?) AND CONFIRMED = 'Y'";
				pstmtCnt = conn.prepareStatement(sql1);
				pstmtCnt.setString(1, emplCode);
				pstmtCnt.setString(2, emplCode);
				pstmtCnt.setTimestamp(3, java.sql.Timestamp.valueOf(eventDate));

				rsCnt = pstmtCnt.executeQuery();

				if(rsCnt.next())
				{
					cnt = rsCnt.getInt("COUNT");
				}
				//System.out.println("EMP_EMPLOY_EVENTS cnt =["+cnt+"]");
				//added by mrunalini sinkar (start)
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				//adde by mrunalini sinkar (end)
				if(cnt > 0 )
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__TO AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MAX(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MAX(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE <= ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				else
				{
					sqlCnt = " SELECT AA.HOL_TBLNO__FR AS HOL_TBLNO FROM EMP_EMPLOY_EVENTS AA WHERE AA.EMP_CODE = ? AND AA.CONFIRMED = 'Y' AND AA.TRAN_ID = ( SELECT MIN(BB.TRAN_ID) FROM EMP_EMPLOY_EVENTS BB WHERE BB.EMP_CODE = AA.EMP_CODE AND BB.EFF_DATE = ( SELECT MIN(CC.EFF_DATE) FROM EMP_EMPLOY_EVENTS CC WHERE CC.EMP_CODE = AA.EMP_CODE AND CC.EFF_DATE > ? AND CC.CONFIRMED = 'Y' ) AND BB.CONFIRMED = 'Y')";
				}
				pstmtSet = conn.prepareStatement(sqlCnt);
				pstmtSet.setString(1, emplCode);
				pstmtSet.setTimestamp(2, java.sql.Timestamp.valueOf(eventDate));
				rsSet = pstmtSet.executeQuery();
				if(rsSet.next())
				{
					holTblNo = rsSet.getString("HOL_TBLNO");
				}
				//added by mrunalini sinkar (start)
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				//adde by mrunalini sinkar (end)
			}

			if(holTblNo == null || (holTblNo).trim().length() == 0  )
			{
				String workSite = "";
				sqlTbl = "SELECT HOL_TBLNO, WORK_SITE FROM EMPLOYEE WHERE EMP_CODE = ? ";
				pstmtTbl = conn.prepareStatement(sqlTbl);
				pstmtTbl.setString(1, emplCode);
				rsTbl = pstmtTbl.executeQuery();
				if(rsTbl.next())
				{
					holTblNo = rsTbl.getString("HOL_TBLNO");
					workSite = rsTbl.getString("WORK_SITE");
				}
				//added by mrunalini sinkar (start)
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				//adde by mrunalini sinkar (end)
				if(holTblNo == null || (holTblNo).trim().length() == 0  )
				{
					sqlTblNo = "SELECT HOL_TBLNO FROM SITE WHERE SITE_CODE = ? ";
					pstmtTblno = conn.prepareStatement(sqlTblNo);
					pstmtTblno.setString(1, workSite);
					rsTblno = pstmtTblno.executeQuery();

					if(rsTblno.next())
					{
						holTblNo = rsTblno.getString("HOL_TBLNO");
					}
					//added by mrunalini sinkar (start)
					if (rsTblno != null)
					{
						rsTblno.close();
						rsTblno = null;
					}
					if(pstmtTblno !=null)
					{
						pstmtTblno.close();
						pstmtTblno = null;
					}
					//adde by mrunalini sinkar (end)
				}
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCount != null)
				{
					rsCount.close();
					rsCount = null;
				}
				if(pstmtCount !=null)
				{
					pstmtCount.close();
					pstmtCount = null;
				}
				if (rsCnt != null)
				{
					rsCnt.close();
					rsCnt = null;
				}
				if(pstmtCnt !=null)
				{
					pstmtCnt.close();
					pstmtCnt = null;
				}
				if (rsSet != null)
				{
					rsSet.close();
					rsSet = null;
				}
				if(pstmtSet !=null)
				{
					pstmtSet.close();
					pstmtSet = null;
				}
				if (rsTbl != null)
				{
					rsTbl.close();
					rsTbl = null;
				}
				if(pstmtTbl !=null)
				{
					pstmtTbl.close();
					pstmtTbl = null;
				}
				if (rsTblno != null)
				{
					rsTblno.close();
					rsTblno = null;
				}
				if(pstmtTblno !=null)
				{
					pstmtTblno.close();
					pstmtTblno = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("holTblNo =["+holTblNo+"]");
		return holTblNo;
	}
	//Addded by Gaurav Singh on 02-Jun-2015 for Request Id [W15BMIT002].End

	// Changed by Rahul on 19-May-2016 [START] to check value of IS_PLAN_COMPULSARY from SFAPARM table
	public String getSfaParmValue(String userId,String paramName,Connection connectionObject) throws ITMException//Chnaged by sachin satre on 11-nov-16
	{
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;//Added by kailash.
		ResultSet rs1 = null;//Added by kailash.
		String empSite="";
		String itemSer="";
		String paramValue="";
		PreparedStatement allPstmt = null;
		ResultSet allRs = null;
		boolean isLocalConn =false;
		try
		{
			//chnged by sachin satre on [11-nov-16] to get connectioni
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB( "DriverValidator" );*/
				connectionObject = getConnection();//chnged by sachin satre on [11-nov-16] to get connectioni
				isLocalConn =true;
			}
			//chnged by sachin satre on [11-nov-16] to get connection
			String sql = "SELECT SITE_CODE__DEF FROM USERS WHERE CODE = ? ";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				empSite  = checkNull(rs.getString("SITE_CODE__DEF"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("value of empSite is::........."+empSite);

			String getSalesPerData = " SELECT SALES_PERS.ITEM_SER,ITEMSER.DESCR FROM ITEMSER LEFT OUTER JOIN SALES_PERS ON ITEMSER.ITEM_SER = SALES_PERS.ITEM_SER "+
					" WHERE  SALES_PERS.SALES_PERS = ? ";

			pstmt = connectionObject.prepareStatement(getSalesPerData);
			pstmt.setString(1, userId);

			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				itemSer  = checkNull(rs.getString("ITEM_SER"));
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			sql=" SELECT PARM_VALUE  "+
					" FROM SFAPARM  "+
					" WHERE ORG_UNIT =?  "+
					" AND ACTIVE='Y'  "+
					" AND PARM_NAME= ? ";

			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, empSite+"_"+itemSer);
			pstmt.setString(2, paramName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				paramValue  = checkNull(rs.getString(1));
			}
			else
			{
				//System.out.println("inside else");
				pstmt1 = connectionObject.prepareStatement(sql);
				pstmt1.setString(1, itemSer);
				pstmt1.setString(2, paramName);
				rs1 = pstmt1.executeQuery();
				if (rs1.next())
				{
					paramValue  = checkNull(rs1.getString(1));
				}
				//added by mrunalni sinkar on 10-aug-2018(start)
				else
				{
					allPstmt = connectionObject.prepareStatement(sql);
					allPstmt.setString(1, "ALL");
					allPstmt.setString(2, paramName);
					allRs = allPstmt.executeQuery();
					if(allRs.next())
					{
						paramValue  = checkNull( allRs.getString(1) );
					}
				}
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				//added by mrunalni sinkar on 10-aug-2018(end)
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[Start]
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				//Added by kailash on 05-04-18 for closing resultset and prepare stmt[End]
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if ( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}

			//System.out.println("value of isPlan is::........."+paramValue);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if ( allRs != null )
				{
					allRs.close();
					allRs = null;
				}
				if ( allPstmt != null )
				{
					allPstmt.close();
					allPstmt = null;
				}
				if ( rs1 != null )
				{
					rs1.close();
					rs1 = null;
				}
				if ( pstmt1 != null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on [11-nov-16] to get connectioni
			}
			catch (SQLException e) {
				e.printStackTrace();
			}
		}
		return paramValue;
	}
	// Changed by Rahul on 19-May-2016 [END] to check value of IS_PLAN_COMPULSARY from SFAPARM table
	//Added by Gulzar on 07-Oct-2016 for getting call note types [START]
	/*public String getCallNoteTypes( String xmlString, String xtraParams) throws Exception
		{
			System.out.println("in getCallNoteTypes");
			String listType = "";
			PreparedStatement pstmtNoteType = null;
			ResultSet rsNoteType = null;
			Connection conn = null;

			String noteType = "";
			String descr = "";
			String shDescr = "";
			String colorCode = "";
			JSONObject jsonObj = new JSONObject();
			String jSonKey="";

			try
			{
				JSONObject jsonNoteTypeObj = new JSONObject();
				E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
				Document dom=genericUtility.parseString(xmlString);
				System.out.println("Dom >>>:: "+dom);
				System.out.println("xmlString>>>::"+xmlString);
				jSonKey=genericUtility.getColumnValue("scope_object",dom);
				System.out.println("jSonKey>>>::"+jSonKey);
				if(jSonKey==null && jSonKey.trim().length()==0)
				{
					jSonKey="JSON";
				}

				ConnDriver connDriver = new ConnDriver();
				conn = connDriver.getConnectDB( "DriverITM" );
				conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
				String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ";
				pstmtNoteType = conn.prepareStatement(noteTypeSql);
				rsNoteType = pstmtNoteType.executeQuery();
				while(rsNoteType.next())
				{
					noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
					descr = checkNull(rsNoteType.getString("DESCR"));
					shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
					colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));

					jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);

				}
				System.out.println("jSonKey>>>::"+jSonKey);
				jsonObj.put(jSonKey, jsonNoteTypeObj);

				System.out.println("jsonConvertedData ::"+jsonObj.toString());
			}
			catch(Exception e)
			{
				System.out.println("Exception in getcallnotetype ::"+e.getMessage());
				throw e;
			}
			finally
			{
				try
				{
					if(rsNoteType != null)
					{
						rsNoteType.close();
						rsNoteType = null;
					}
					if(pstmtNoteType != null)
					{
						pstmtNoteType.close();
						pstmtNoteType = null;
					}
					if(conn != null)
					{
						conn.close();
						conn = null;
					}
				}
				catch(Exception e)
				{

				}
			}
			return jsonObj.toString();
		}*/
	//Added by Gulzar on 07-Oct-2016 for getting call note types [END]

	public String getPrevFormVal( Document dom, String currentFormNo, ArrayList temp, String colName ) throws ITMException
	{
		//GenericUtility genericUtility = GenericUtility.getInstance();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		try
		{
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"] \n dom["+genericUtility.serializeDom(dom)+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentlistlength["+parentNodeListLength+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						//	System.out.println("childNode.getNodeName()["+childNode.getNodeName()+"]columnValue["+columnValue+"]temp["+temp+"] ");
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains(columnValue))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								//Changes By Prajyot On 22-11-2011
								//[ For Items Details to maintain the default domID it is necessary to discard the new domID generation ]
								//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
								elementAttr.setAttribute( "selected" , "Y" );
								domID++;
							}
							Node importedNode = chgPreDom.importNode( parentNode, true );
							chgPreDom.getDocumentElement().appendChild( importedNode );
							break;
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :SavexWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	public String getCallNoteTypes( String xmlString, String xtraParams) throws ITMException
	{
		//System.out.println("in getCallNoteTypes");
		String listType = "";
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		Connection conn = null;
		String noteType = "";
		String descr = "";
		String shDescr = "";
		String colorCode = "";
		JSONObject jsonObj = new JSONObject();
		String jSonKey="";
		try
		{
			JSONObject jsonNoteTypeObj = new JSONObject();
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			Document dom=genericUtility.parseString(xmlString);
			//System.out.println("Dom >>>:: "+dom);
			//System.out.println("xmlString>>>::"+xmlString);
			jSonKey=genericUtility.getColumnValue("scope_object",dom);
			//System.out.println("jSonKey>>>::"+jSonKey);
			if(jSonKey==null && jSonKey.trim().length()==0)
			{
				jSonKey="JSON";
			}
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB( "DriverITM" );*/
			conn = getConnection();//chnged by sachin satre on [11-nov-16] to get connection
			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE, COLOR_CODE FROM CALL_NOTE_TYPE ";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();
			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));
				colorCode = checkNull(rsNoteType.getString("COLOR_CODE"));
				jsonNoteTypeObj.put(noteType, shDescr+","+colorCode);
			}
			//added by mrunalini sinkar on 9-april-2018(start)
			if(rsNoteType != null)
			{
				rsNoteType.close();
				rsNoteType = null;
			}
			if(pstmtNoteType != null)
			{
				pstmtNoteType.close();
				pstmtNoteType = null;
			}
			//added by mrunalini sinkar on 9-april-2018(end)
			//System.out.println("jSonKey>>>::"+jSonKey);
			jsonObj.put(jSonKey, jsonNoteTypeObj);
			//System.out.println("jsonConvertedData ::"+jsonObj.toString());
		}
		catch(Exception e)
		{
			System.out.println("Exception in getcallnotetype ::"+e.getMessage());
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018
		}
		finally
		{
			try
			{
				if(rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType != null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return jsonObj.toString();
	}
	public String getPrevFormLocValues( Document dom, String currentFormNo, ArrayList temp, String colName, String modeReport, String stockistTable,Connection conn) throws ITMException
	{
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;
		String updateFlag = "";

		try
		{

			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			String objName = checkNull(getObjNameFromDom(dom, "objName",Integer.parseInt(currentFormNo)));
			String locFormNo = checkNull(getFormNo(objName, "place", conn));
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				boolean isFound = false;
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					childNodeName =  childNode.getNodeName();

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						{
							elementAttr = (Element)parentNode;
							if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
							{
								isFound = true;
								elementAttr.setAttribute( "selected", "Y" );
								domID++;
							}
							/*Node importedNode = chgPreDom.importNode(parentNode  , true );
							chgPreDom.getDocumentElement().appendChild( importedNode );*/
							break;
						}
					}
					//added by Mrunalini Sinkar To Solve Locality Issue On 31-07-2017(start)
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						//if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
							//System.out.println("update flag is:"+updateFlag);
						}
					}
				}
				//added by Mrunalini Sinkar To Solve Locality Issue On 31-07-2017(end)
				//System.out.println( "parentNode - ["+ genericUtility.serializeDom( parentNode ) +"]" );

				if( isFound && "E".equalsIgnoreCase(modeReport) )
				{
					String cchgDomStr = genericUtility.serializeDom(parentNode);
					/*if(cchgDomStr.indexOf("<dr_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<dr_visit>", "<dr_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<chem_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<chem_visit>", "<chem_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<stockist_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<stockist_visit>", "<stockist_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<other_visit>") != -1 && !updateFlag.equalsIgnoreCase("A"))
					{
						cchgDomStr = cchgDomStr.replaceAll("<other_visit>", "<other_visit protect='1'>");
					}*/

					Document chgParentDom = genericUtility.parseString(cchgDomStr);
					Node selNode = chgParentDom.getElementsByTagName("Detail"+currentFormNo).item(0);
					Node importedNode = chgPreDom.importNode( selNode, true );
					chgPreDom.getDocumentElement().appendChild( importedNode );
				}
				else if( isFound && !"E".equalsIgnoreCase(modeReport) )
				{
					String locCode = getSelectedRowValue(dom ,locFormNo ,"locality_code",prntCtr);
					String sprsCode = getSelectedRowValue(dom ,""+2 ,"sales_pers",prntCtr);
					String isDrExist = "";
					String isNCWExist = "";
					String isChemExist = "";
					String isStockExist = "";
					if(locCode != null && locCode.trim().length()>0)
					{
						isDrExist = checkCustExist(sprsCode, locCode, "D",stockistTable, conn);
						isChemExist = checkCustExist(sprsCode, locCode, "C",stockistTable, conn);
						isStockExist = checkCustExist(sprsCode, locCode, "S",stockistTable, conn);
						isNCWExist = checkCustExist(sprsCode, locCode, "O",stockistTable, conn);
					}
					//System.out.println("isDrExist 123["+isDrExist+"]isNCWExist123["+isNCWExist);
					//System.out.println("locality["+locCode+"]isNCWAva");
					//System.out.println("Inside drotherif");
					String cchgDomStr = genericUtility.serializeDom(parentNode);
					if(cchgDomStr.indexOf("<dr_visit>") != -1 && isDrExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside drvisit");
						cchgDomStr = cchgDomStr.replace("<dr_visit>", "<dr_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<chem_visit>") != -1 && isChemExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside chem_visit");
						cchgDomStr = cchgDomStr.replace("<chem_visit>", "<chem_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<stockist_visit>") != -1 && isStockExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside stockist_visit");
						cchgDomStr = cchgDomStr.replace("<stockist_visit>", "<stockist_visit protect='1'>");
					}
					if(cchgDomStr.indexOf("<other_visit>") != -1 && isNCWExist.equalsIgnoreCase("N"))
					{
						//System.out.println("Inside other_visit");
						cchgDomStr = cchgDomStr.replace("<other_visit>", "<other_visit protect='1'>");
					}
					Document chgParentDom = genericUtility.parseString(cchgDomStr);
					Node selNode = chgParentDom.getElementsByTagName("Detail"+currentFormNo).item(0);
					//System.out.println("Chgpredom value:- "+genericUtility.serializeDom( chgPreDom )+"Node value is:---"+genericUtility.serializeDom( chgParentDom ));
					Node importedNode = chgPreDom.importNode( selNode, true );
					chgPreDom.getDocumentElement().appendChild( importedNode );
				}
			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return returnPrevStr;

	}
	//TODO
	//Commented and added by kailash on 28-09-18[start]
	//public String getPrevFormCustValues( Document dom, String currentFormNo, ArrayList temp, String colName,Connection conn) throws ITMException
	public String getPrevFormCustValues( Document dom, String currentFormNo, ArrayList temp, String colName,String unlistCustType,Connection conn) throws ITMException
	//Commented and added by kailash on 28-09-18[end]
	{
		//changed by Rahul Barve on 10-Apr-2015
		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		String returnPrevStr = "";
		Document chgPreDom = null;

		HashMap locVisitMap = new HashMap();
		String objName = checkNull(getObjNameFromDom(dom, "objName",Integer.parseInt(currentFormNo)));
		String locFormNo = checkNull(getFormNo(objName, "place", conn));
		String retailFormNo = checkNull(getFormNo(objName, "retailer", conn));
		String docFormNo = checkNull(getFormNo(objName, "doctor", conn));
		//Added by Mrunalini Sinkar on 08-may-2017 to show stockist form detail on previous(start)
		String stockistFormNo = checkNull(getFormNo(objName, "stockist", conn));
		String ncwFormNo = checkNull(getFormNo(objName, "ncw", conn));
		//Added by Mrunalini Sinkar on 08-may-2017 to show stockist form detail on previous(end)

		try
		{
			//String drVisit = checkNull(genericUtility.getColumnValue("dr_visit", dom, "3"));
			//String othVisit = checkNull(genericUtility.getColumnValue("other_visit", dom, "3"));

			///////////////////
			System.out.println("inside getPrevFormValues() DAR........");
			parentList = dom.getElementsByTagName("Detail"+locFormNo+"");
			int parentNodeListLength1 = parentList.getLength();
			System.out.println("currentFormNo DAR["+currentFormNo+"]");
			for (int prntCtr = 0; prntCtr < parentNodeListLength1; prntCtr++ )
			{
				ArrayList custVisitList = new ArrayList();
				String localityCode = "";
				String drVisit = "";
				String ncwVisit = "";
				String chemVisit = "";
				String stockVisit = "";
				String chileNodeName = "";
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);

					chileNodeName = childNode.getNodeName();

					if ( "locality_code".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							localityCode = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "dr_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							drVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "chem_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							chemVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "stockist_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							stockVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}
					else if ( "other_visit".equalsIgnoreCase(chileNodeName))
					{
						if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
						{
							ncwVisit = childNode.getFirstChild().getNodeValue().trim();
						}

					}

				}
				custVisitList.add(0, drVisit);
				custVisitList.add(1, ncwVisit);
				custVisitList.add(2, chemVisit);
				custVisitList.add(3, stockVisit);
				custVisitList.add(4, unlistCustType);//added by kailash on 27-09-18.
				locVisitMap.put(localityCode, custVisitList);


			}
			////////////////

			//System.out.println("locVisitMap ::"+locVisitMap);

			String CheckUpdateFlag = "";
			String locColName = "", locColValue = "";
			chgPreDom = genericUtility.parseString("<Root/>");
			//System.out.println("currentFormNo ["+currentFormNo+"]");
			parentList = dom.getElementsByTagName("Detail" + currentFormNo);
			int parentNodeListLength = parentList.getLength();
			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				for (int ctr = 0; ctr < childList.getLength(); ctr++)
				{
					childNode = childList.item(ctr);
					if(childNode.getNodeName().equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							CheckUpdateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}

					if((childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() != null))
					{
						columnValue = childNode.getFirstChild().getNodeValue().trim();

						//if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'"))
						if ( childNode.getNodeName().equalsIgnoreCase(colName) && temp.contains("'"+columnValue+"'") && !"D".equalsIgnoreCase(CheckUpdateFlag))
						{
							ArrayList visitList = (ArrayList)locVisitMap.get(columnValue);
							//Add the condition stockist and ncw to show stockist form detail on previous Mrunalini Sinkar on 08-may-2017
							if(visitList != null && ("Y".equalsIgnoreCase((String)visitList.get(0)) && docFormNo.trim().equalsIgnoreCase(currentFormNo)) || ("Y".equalsIgnoreCase((String)visitList.get(1)) && ncwFormNo.trim().equalsIgnoreCase(currentFormNo) ) || ("Y".equalsIgnoreCase((String)visitList.get(2)) && retailFormNo.equalsIgnoreCase(currentFormNo) ) || ("Y".equalsIgnoreCase((String)visitList.get(3)) && stockistFormNo.trim().equalsIgnoreCase(currentFormNo) )
									|| ("UNLISTED-DOCTOR".equalsIgnoreCase((String)visitList.get(4)) && docFormNo.trim().equalsIgnoreCase(currentFormNo))
									|| (("UNLISTED-RETAILER".equalsIgnoreCase((String)visitList.get(4)) || "UNLISTED-CHEMIST".equalsIgnoreCase((String)visitList.get(4))) && retailFormNo.trim().equalsIgnoreCase(currentFormNo))
									|| ("UNLISTED-STOCKIST".equalsIgnoreCase((String)visitList.get(4)) && stockistFormNo.trim().equalsIgnoreCase(currentFormNo))
									|| ("UNLISTED-OTHER".equalsIgnoreCase((String)visitList.get(4)) && ncwFormNo.trim().equalsIgnoreCase(currentFormNo)))
							{
								elementAttr = (Element)parentNode;
								if ( parentNode.getAttributes().getNamedItem( "domID" ) != null )
								{
									//elementAttr.setAttribute( "domID" , Integer.toString(domID) );
									elementAttr.setAttribute( "selected" , "Y" );
									domID++;
								}
								Node importedNode = chgPreDom.importNode( parentNode, true );
								chgPreDom.getDocumentElement().appendChild( importedNode );
								break;
							}
						}

					}
				}

			}
			if(currentFormNo.equals("1"))
			{
				domID = 1;
			}
			returnPrevStr = genericUtility.serializeDom(chgPreDom);
			if(returnPrevStr.indexOf("Detail"+currentFormNo) != -1)
			{
				returnPrevStr = returnPrevStr.substring(returnPrevStr.indexOf(">") + 1, returnPrevStr.lastIndexOf("</"));
			}
			returnPrevStr = returnPrevStr.indexOf("Detail"+currentFormNo) != -1 ? returnPrevStr : "";
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :WsfaZuviusDsrMobileWizardEJB :getPrevFormValues :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("returnPrevStr DAR ["+returnPrevStr+"]");
		return returnPrevStr;

	}
	private String checkCustExist(String sprsCode, String locCode, String scType,String stockistTable,Connection connectionObject) throws ITMException
	{
		String custPresent = "Y";
		try
		{
			String selectSql = "";
			int count = 0;
			PreparedStatement pstmt = null;
			ResultSet rSet = null;

			if(scType.equalsIgnoreCase("S") && stockistTable.equalsIgnoreCase("SPRS_STOCKIST"))
			{
				selectSql = "select count(1) as count from sprs_stockist ss,customer cust where cust.locality_Code = ? and ss.sprs_code = ? and ss.cust_code = cust.cust_code and cust.cust_type = ? and ss.status = 'Y'";
			}
			else if(!scType.equalsIgnoreCase("O"))
			{
				selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type = ? and ss.status = 'Y'";
			}
			else if(scType.equalsIgnoreCase("O"))
			{
				selectSql = "select count(1) as count from strg_series ss,strg_customer sc where sc.locality_Code = ? and ss.sales_pers= ? and ss.sc_code = sc.sc_code and sc.cust_type not in ('D','S','C') and ss.status = 'Y'";
			}
			//System.out.println("selectSql ["+selectSql+"]");

			pstmt = connectionObject.prepareStatement(selectSql);
			pstmt.setString(1,locCode);
			pstmt.setString(2,sprsCode);
			if(!scType.trim().equalsIgnoreCase("O"))
			{
				pstmt.setString(3,scType);
			}
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				count = rSet.getInt("count");
			}
			if (rSet!= null)
			{
				rSet.close();
				rSet = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			//System.out.println("count ["+count+"]");

			if (count <= 0)
			{
				custPresent = "N";
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return custPresent;
	}
	private String checkCustExistInPlan(String sprsCode,String trvDate, String locCode, String scType,Connection connectionObject) throws ITMException
	{
		String custPresent = "N";
		try
		{
			String selectSql = "";
			int count = 0;
			PreparedStatement pstmt = null;
			ResultSet rSet = null;
			if(trvDate!=null && trvDate.length() > 0) //changes by shraddha M for null pointer exception[12-oct-2020] start
			{
				if(!scType.equalsIgnoreCase("O"))
				{
					selectSql = "SELECT  COUNT(1) COUNT FROM SPRS_PLAN_CUST CUST,SPRS_PLAN_HDR HDR WHERE HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ? AND LOCALITY_CODE = ? AND SC_TYPE = ? AND HDR.PLAN_ID = CUST.PLAN_ID";

				}
				else if(scType.equalsIgnoreCase("O"))
				{
					selectSql = "SELECT  COUNT(1) COUNT FROM SPRS_PLAN_CUST CUST,SPRS_PLAN_HDR HDR WHERE HDR.PLAN_DATE= ? AND HDR.SPRS_CODE__PLAN= ? AND LOCALITY_CODE = ? AND SC_TYPE NOT IN ('D','S','C') AND HDR.PLAN_ID = CUST.PLAN_ID";

				}
				//System.out.println("selectSql ["+selectSql+"]");

				pstmt = connectionObject.prepareStatement(selectSql);
				pstmt.setTimestamp( 1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( trvDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
				pstmt.setString(2,sprsCode);
				pstmt.setString(3,locCode);
				if(!scType.trim().equalsIgnoreCase("O"))
				{
					pstmt.setString(4,scType);
				}
				rSet = pstmt.executeQuery();
				if(rSet.next())
				{
					count = rSet.getInt("COUNT");
				}
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				//System.out.println("count 454["+count+"]");

				if (count > 0)
				{
					custPresent = "Y";
				}
			} //changes by shraddha M for  null pointer exception[12-oct-2020] end
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		return custPresent;
	}
	public String wfValSalesPersAct(Document dom, Document dom2, String currentFormNo, String userId,Connection connectionObject) throws ITMException //chnged by sachin satre on [9-nov-16] to get connection
	{
		NodeList parentList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		String errString = "";
		String errStringNew = "";
		String checkSQL = "";
		String childNodeName = "";
		String columnValue = "";

		PreparedStatement pstmt = null;
		ResultSet rSet = null ;

		ITMDBAccessEJB itmDBAccessLocal = null;// modified by kailash.
		boolean isLocalConn=false;
		int noOfChilds = 0;
		try
		{

			if(connectionObject == null)
			{
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn=true;
			}

			String updateFlag = "";
			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[Start]
			//itmDBAccessLocal = (ITMDBAccessLocal)ctx.lookup("ibase/ITMDBAccessEJB/local");
			itmDBAccessLocal = new ITMDBAccessEJB();
			//Commented and modified by kailash on 20-07-18 as per gulzar sir[End]

			parentList = dom.getElementsByTagName("Detail"+ currentFormNo);
			int parentNodeListLength = parentList.getLength();
			//System.out.println("parentNodeListLength["+parentNodeListLength+"]");

			for (int prntCtr = 0; prntCtr < parentNodeListLength; prntCtr++ )
			{
				parentNode = parentList.item(prntCtr);
				childList = parentNode.getChildNodes();
				noOfChilds = childList.getLength();
				for (int ctr = 0; ctr < noOfChilds; ctr++)
				{
					childNode = childList.item(ctr);
					if( childNode.getNodeType() != Node.ELEMENT_NODE )
					{
						continue;
					}

					if ( childNode != null && childNode.getFirstChild() != null )
					{
						columnValue = childNode.getFirstChild().getNodeValue();
					}
					childNodeName = childNode.getNodeName();
					//System.out.println("childNodeName =["+childNodeName+"]");
					if(childNodeName.equalsIgnoreCase("attribute"))
					{
						if(childNode.getAttributes().getNamedItem("updateFlag") != null)
						{
							updateFlag = checkNull(childNode.getAttributes().getNamedItem("updateFlag").getNodeValue());
						}
					}
					if(childNodeName.equalsIgnoreCase("event_date"))
					{
						if((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null) ||
								( childNode.getFirstChild().getNodeValue() != null && "null".equalsIgnoreCase(childNode.getFirstChild().getNodeValue())))
						{
							errString = itmDBAccessLocal.getErrorString("event_date","NULLEVTCOD",userId);
							break;
						}
						else //to validate future date and holidays
						{
							SimpleDateFormat sdfFormat = new SimpleDateFormat(getApplDateFormat());
							java.util.Date eventDate = sdfFormat.parse( childNode.getFirstChild().getNodeValue());
							String evtdat=childNode.getFirstChild().getNodeValue();
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] Start
							if (!sdfFormat.format(eventDate).equals(evtdat))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "INVDTFRMT", userId );
								break;
							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | date validation for 00/00/00] End

							/*if ( ( eventDate.compareTo( getDateObject( sdfFormat.format( new Date() ) ) ) ) > 0 )
							{
								errString = itmDBAccessLocal.getErrorString( "event_date", "FUTUREVENT", userId );
								break;
							}*/


							String salesPers = genericUtility.getColumnValue( "sales_pers" , dom );

							//changed for not allow to edit the DCR once confirmed - Gulzar
							String dcrDate = genericUtility.getColumnValue( "event_date" , dom );

							String confirmed = "";
							dcrDate = genericUtility.getValidDateTimeString( dcrDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
							String selectSql = "SELECT CONFIRMED FROM STRG_MEET WHERE SALES_PERS = ? AND EVENT_DATE = ?"+
									"AND EVENT_TYPE NOT IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE ='PR')"; // added by condition rupali on 14/03/17 for separate pr menu
							PreparedStatement pstmtSel = connectionObject.prepareStatement(selectSql);
							pstmtSel.setString(1, salesPers);
							pstmtSel.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
							ResultSet rsSelect = pstmtSel.executeQuery();
							if(rsSelect.next())
							{
								confirmed = (rsSelect.getString("CONFIRMED") == null) ?"":rsSelect.getString("CONFIRMED").trim();
							}
							rsSelect.close(); rsSelect = null;
							pstmtSel.close(); pstmtSel = null;
							if("Y".equalsIgnoreCase(confirmed))
							{
								errString = itmDBAccessLocal.getErrorString( "event_date" , "DCRCONFD" , userId );
								break;
							}


							int allowDays = 0;
							String propName = "MAX_ALLOW_PRD_MEET";//ADDED BY DIPAK FOR DB2
							//checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME ='MAX_ALLOW_PRD_MEET'";//Commented By Dipak FOR DB2
							checkSQL = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? ";//ADDED By Dipak FOR DB2
							pstmt = connectionObject.prepareStatement(checkSQL);
							pstmt.setString(1, propName);//ADDED By Dipak FOR DB2
							rSet = pstmt.executeQuery();//ADDED By Dipak FOR DB2
							if( rSet.next() )
							{
								allowDays = rSet.getInt("PROP_VALUE");
								//System.out.println("allowDays Exist In Properties are ["+allowDays+"]");
								java.util.Calendar cal = java.util.Calendar.getInstance();
								java.util.Date currDate = new java.util.Date();
								cal.setTime( currDate );
								cal.add( cal.DATE, -allowDays );
								if( eventDate.before( cal.getTime() ) )
								{
									errString = itmDBAccessLocal.getErrorString( "event_date" , "XCIDMITLMT" , userId );
									break;
								}
							}
							if (rSet!= null)
							{
								rSet.close();
								rSet = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}

							//for checking Holiday
							String eventdate = childNode.getFirstChild().getNodeValue();

							//changed by kailash pal on 04/04/17:start
							String activityCode = checkNull(genericUtility.getColumnValue( "activity_code" , dom ));
							String activityType = checkNull(genericUtility.getColumnValue( "activity_type" , dom ));
							//System.out.println("before activityCode"+ activityCode);
							//System.out.println("before activity"+ activityType);
							if(activityCode==null || activityCode.length()==0)
							{
								errString = itmDBAccessLocal.getErrorString("activity_code","NULLACTCOD",userId);
								break;
							}

							if(activityType==null || activityType.length()==0)
							{
								String sql= "select activity_type from fieldactivity where activity_code= ?";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}

							}
							if( salesPers != null && evtdat != null )
							{
								//added by Rupali on 23/05/17 for defining sfaparam value for sequential reporting[start]
								//commented by mrunalini sinkar 21-feb-18 for sequntial dar adding org unit(start)
								/*String parmValue = "";
								SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
								String currDate = dtFormat.format(new java.util.Date());
								String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='SEQUENTIAL_DAR' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
								PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
								pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
								ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
								if (rsSfaParm.next())
								{
									parmValue = checkNull(rsSfaParm.getString("PARM_VALUE"));
								}
								if(rsSfaParm != null)
								{
									rsSfaParm.close();
									rsSfaParm = null;
								}
								if(pstmtSfaParm != null)
								{
									pstmtSfaParm.close();
									pstmtSfaParm = null;
								}*/
								//commented by mrunalini sinkar 21-feb-18 for sequntial dar adding org unit(end)

								String parmValue = getSfaParmValue(userId,"SEQUENTIAL_DAR",connectionObject); // added by mrunalini sinkar on 21-Feb-2018(start)
								//System.out.println("In 1 If parmValue is :"+ parmValue);
								//added by Rupali on 23/05/17 for defining sfaparam value for sequential reporting[end]
								if(parmValue.equalsIgnoreCase("Y"))
								{
									//	System.out.println("In 2 If parmValue is :"+ parmValue);
									errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
									if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
									{
										errString = errStringNew;
										break;
									}
								}
								int actCount = 0;
								String sql= "select activity_type,count(*) as count from fieldactivity where activity_code= ? group by activity_type";
								pstmt = connectionObject.prepareStatement(sql);
								pstmt.setString(1, activityCode);
								rSet = pstmt.executeQuery();
								if( rSet.next() )
								{
									activityType= checkNull(rSet.getString("ACTIVITY_TYPE"));
									actCount = rSet.getInt("count");
									//System.out.println("In If"+ activityType);
								}
								if (rSet!= null)
								{
									rSet.close();
									rSet = null;
								}
								if(pstmt!=null)
								{
									pstmt.close();
									pstmt = null;
								}
								// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [start]
								//commenetd & Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(start)
								/*String parmVal = "";
								String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='VALIDATE_UNCONFIRM_DCR' AND ACTIVE='Y' ";
								PreparedStatement pstmtSfaParm = connectionObject.prepareStatement(sfaParmSql);
								ResultSet rsSfaParm = pstmtSfaParm.executeQuery();
								if (rsSfaParm.next())
								{
									parmVal = checkNull(rsSfaParm.getString("PARM_VALUE"));
								}
								if(rsSfaParm != null)
								{
									rsSfaParm.close();
									rsSfaParm = null;
								}
								if(pstmtSfaParm != null)
								{
									pstmtSfaParm.close();
									pstmtSfaParm = null;
								}*/
								int maxUnconfAllow=0;
								String parmVal = getSfaParmValue(userId, "UNCONF_DAR", connectionObject);
								System.out.println("UNCONF_DAR IS["+parmVal+"]");
								if (parmVal.trim().length() > 0)
								{
									try
									{
										maxUnconfAllow = Integer.parseInt(parmVal.trim());
									}
									catch (NumberFormatException ne)
									{
										maxUnconfAllow = 0;
									}
								}
								System.out.println("maxUnconfAllow IS["+maxUnconfAllow+"]");

								//commenetd & Added by mrunalini sinkar for adding Sun Changes on 1-april-2019(end)
								//if(parmVal.equalsIgnoreCase("Y"))
								if(maxUnconfAllow > 0)
								{
									String oldData=checkNull(getSfaParmValue(salesPers, "OLD_METIS_DAR_DATA", connectionObject));

									String unConfDcrDates="";
									int count=0;
									int MeetCount=0;
									String selectConfirmSql = "SELECT DISTINCT EVENT_DATE FROM STRG_MEET  WHERE SALES_PERS = ? " +
											" AND (CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END ) <> 'Y'" +
											" AND  EVENT_DATE < ? ORDER BY EVENT_DATE ";
									PreparedStatement pstmtSelect = connectionObject.prepareStatement(selectConfirmSql);
									pstmtSelect.setString(1, salesPers);
									pstmtSelect.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
									ResultSet resultSelect = pstmtSelect.executeQuery();
									while(resultSelect.next())
									{
										MeetCount++;
										String unConfDcrDate = (resultSelect.getString("EVENT_DATE")) == null ?"":resultSelect.getString("EVENT_DATE").trim();
										unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
										unConfDcrDates += unConfDcrDate+",";

									}
									resultSelect.close(); resultSelect = null;
									pstmtSelect.close(); pstmtSelect = null;
									System.out.println( "Event Dates >>> ["+unConfDcrDates+"] count["+count+"]");
									//if(count >=3)
									if(MeetCount==0 && "Y".equalsIgnoreCase(oldData))
									{
										int drCount=0;
										String oldConfirmSql = "SELECT DISTINCT WORK_DATE FROM DR_MAIN  WHERE SALES_PERS = ? " +
												" AND (CASE WHEN CONFIRMATION_FLAG IS NULL THEN 'N' ELSE CONFIRMATION_FLAG END ) <> 'Y'" +
												" AND  WORK_DATE < ? ORDER BY WORK_DATE ";
										PreparedStatement pstmtOld = connectionObject.prepareStatement(oldConfirmSql);
										pstmtOld.setString(1, salesPers);
										pstmtOld.setTimestamp(2, java.sql.Timestamp.valueOf(dcrDate));
										ResultSet resultSelectOld = pstmtOld.executeQuery();
										while(resultSelectOld.next())
										{
											drCount++;
											String unConfDcrDate = (resultSelectOld.getString("WORK_DATE")) == null ?"":resultSelectOld.getString("WORK_DATE").trim();
											unConfDcrDate = genericUtility.getValidDateString( unConfDcrDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
											unConfDcrDates += unConfDcrDate+",";

										}
										resultSelectOld.close(); resultSelectOld = null;
										pstmtOld.close(); pstmtOld = null;
										count=drCount;
									}
									else
									{
										count=MeetCount;
									}
									if(count >= maxUnconfAllow)
									{
										String message=getMsgDescr("DCRUNCONFD",connectionObject);
										errString = "";
										String messageValue ="\r\n"+message+"\n"+unConfDcrDates;
										StringBuffer valueXmlErrorString = new StringBuffer( "<?xmlversion=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<Errors>\r\n" );
										valueXmlErrorString.append("<error id=\"DCRUNCONFD\" type=\"E\" >");
										valueXmlErrorString.append("<message><![CDATA[").append("").append("]]></message>\r\n");
										valueXmlErrorString.append("<description><![CDATA[").append(messageValue).append("]]></description>\r\n");
										valueXmlErrorString.append("<type>E</type>\r\n");
										valueXmlErrorString.append("<option></option>\r\n");
										valueXmlErrorString.append("<time></time>\r\n");
										valueXmlErrorString.append("<alarm></alarm>\r\n");
										valueXmlErrorString.append("<source></source>\r\n");
										valueXmlErrorString.append("<trace>Error : NO DATA</trace>\r\n");
										valueXmlErrorString.append("<redirect>1</redirect>\r\n");
										valueXmlErrorString.append("</error>\r\n");
										valueXmlErrorString.append("</Errors>\r\n");
										valueXmlErrorString.append("</Header>\r\n");
										valueXmlErrorString.append( "</Root>\r\n" );
										//System.out.println( "\n****valueXmlErrorString :" + valueXmlErrorString.toString() + ":********" );
										errString =valueXmlErrorString.toString();
										return errString;
									}
								}
								// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [end]
								if(!updateFlag.equalsIgnoreCase("E"))
								{
									errString = valHoliday( evtdat, salesPers, userId, itmDBAccessLocal, connectionObject,"");
								}
								if(errString != null && errString.length()>0 && (errString.indexOf("ERRORS")!=-1 || errString.indexOf("Errors")!=-1))
								{
									//System.out.println("CAME HERE");
									//System.out.println("activity"+ activityType);
									if(actCount == 0)
									{
										errString = itmDBAccessLocal.getErrorString( "activity_code", "ACTNOTFND", userId );
										break;
									}
									if(activityType !=null && activityType.length() > 0 && "LEAVE".equalsIgnoreCase(activityType))
									{
										//System.out.println("Checking leave not allowed");
										errString = itmDBAccessLocal.getErrorString("activity_code","LVENOTALOW",userId);
										break;
									}
									// added by rupali on 28/04/17 for validating wrong activity on holiday[start]
									/*else if(activityType == null && activityType.length() < 0)
									{
										errString = itmDBAccessLocal.getErrorString( "activity_code", "ACTNOTFND", userId );
										break;
									}*/
									// added by rupali on 28/04/17 for validating wrong activity on holiday[end]
									else
									{
										//System.out.println("Checking leave not allowed--- in else");
										if(!updateFlag.equalsIgnoreCase("E"))
										{
											errString = itmDBAccessLocal.getErrorString("event_date","HOLIDAY",userId);
										}
									}

									//System.out.println("Holiday!");
									break;

								}

							}
							//changed by kailash on 04/04/17:End

							//commented by kailash on 04/04/17:Start
							/*if( salesPers != null && eventdate != null )
							{
								// Changed by Rahul on 26-june-2015 [Start] for Sequential Reporting message on Holiday.
								errStringNew = checkSequentialReporting(connectionObject, salesPers, evtdat);
								if(errStringNew != null && errStringNew.indexOf("<Errors>") != -1)
								{
									//System.out.println("Sequential.......:");
									errString = errStringNew;
									break;
								}
								// Changed by Rahul on 26-june-2015 [End] for Sequential Reporting message on Holiday.
								errString = valHoliday( eventdate, salesPers, userId, itmDBAccessLocal, connectionObject );
								if(errString != null && errString.length()>0 && errString.indexOf("Errors")!=-1)
								{
									//System.out.println("Holiday.......:");
									break;

								}

							}
							//Changed By Vidhya on 09/12/09[WS89NOV647 | validation order change] end*/
							//commented by kailash on 04/04/17:End

						}

					}
				}
				if(errString.indexOf("<Errors>")!=-1)
				{
					break;
				}
			}
		}
		catch(Exception e)
		{
			System.out.println ( "Exception :WsfaZuviusDsrWizardEJB :wfValData():" + e.getMessage() + ":" );
			//Commented and added by Dipak 05/11/12
			//errString = generateErrorString(genericUtility.createErrorString(e));
			throw new ITMException(e);
			//End changes by Dipak 05/11/12
		}
		finally
		{
			try
			{
				if (rSet!= null)
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}

				//chnged by sachin satre on 9-nov-16 [] to get connection from parameter [start]
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
				//chnged by sachin satre on 9-nov-16 [] to get connection from parameter [start]
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return errString;
	}

	public String getExistingPitchForDoctor( String salePersCode, String wrkDate, String scCode, String objNameDefault, String callOutcome, String currentFormNo, String formName,Connection connectionObject ) throws ITMException
	{
		//System.out.println("In side getExistingPitchForDoctor.......");
		ResultSet rs = null;
		//Connection connectionObject = null;
		PreparedStatement pstmt = null;
		int domID = 1;
		StringBuffer valueXmlString = new StringBuffer();
		String wrkDateInDbFmt = "", sdQuery = "", pitchDetData ="";
		ResultSet rs1 = null;
		PreparedStatement pstmt1 = null;

		//GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//connectionObject = connDriver.getConnectDB( "DriverValidator" );
			DateFormat dtFormat = new SimpleDateFormat(getApplDateFormat());
			java.util.Date date = Calendar.getInstance().getTime();
			String currDate = dtFormat.format( date );

			//System.out.println("getExistingPitchForDoctor callOutcome ::["+callOutcome+"]");
			HashMap callOutMap = new HashMap();
			if(callOutcome.contains(",") && callOutcome != null )
			{
				///callOutMap = getExistingCallOutcome( salePersCode,  wrkDate,  scCode, currentFormNo , connectionObject);
				//System.out.println("callOutMap ::==="+callOutMap);
			}
			else
			{
				//System.out.println("callOutcome ::===["+callOutcome+"]");
			}

			////pitchDetData = getCallOutcomePitch(callOutcome, connectionObject);
			//System.out.println("pitchDetData ::["+pitchDetData+"]");

			if ( wrkDate != null )
			{
				//COMMENTED BY PRATHAMESH JANGAM FOR DB2
				//wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat() , "dd-MMM-yyyy");
				//wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat(),getDBDateFormat());
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					//System.out.println("inside oracle");
					wrkDateInDbFmt = genericUtility.getValidDateString( wrkDate , getApplDateFormat() , "dd-MMM-yyyy");
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					//System.out.println("inside db2");
					wrkDateInDbFmt =  genericUtility.getValidDateTimeString( wrkDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() );
				}

				//System.out.println("wrkDateInDbFmt:::::>>>>["+wrkDateInDbFmt+"]");
			}
			//System.out.println(" PITCH :: scCode = ["+scCode+"]");
			if(scCode.contains(","))
			{
				//					sdQuery = " SELECT SB.*, ITEM.DESCR FROM STRG_BRAND_PITCH SB, ITEM ITEM WHERE SB.ITEM_CODE = ITEM.ITEM_CODE " +
				//							  " AND SALES_PERS = '"+salePersCode+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE IN ("+getFormattedStringBuff(scCode)+") ";

				sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.SALES_PERS = '"+salePersCode+"' AND SB.WORK_DATE = '"+wrkDateInDbFmt+"' AND SB.SC_CODE IN ("+scCode+") ";
			}
			else
			{
				//					sdQuery = " SELECT SB.*, ITEM.DESCR FROM STRG_BRAND_PITCH SB, ITEM ITEM WHERE SB.ITEM_CODE = ITEM.ITEM_CODE AND SALES_PERS = '"+salePersCode+"' AND WORK_DATE = '"+wrkDateInDbFmt+"' AND SC_CODE='"+scCode+"' ";

				sdQuery = " SELECT SB.* FROM STRG_BRAND_PITCH SB WHERE SB.SALES_PERS = '"+salePersCode+"' AND SB.WORK_DATE = '"+wrkDateInDbFmt+"' AND SB.SC_CODE= "+scCode+"";
			}
			//System.out.println(" PITCH :: SavexWizardSQL[ ---- >] "+sdQuery);
			pstmt = connectionObject.prepareStatement(sdQuery);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				//String item = checkNull(rs.getString("DESCR"));
				String brand = checkNull(rs.getString("BRAND_DESCR"));
				String brandCode = checkNull(rs.getString("BRAND_CODE"));
				String pitchDet = checkNull(rs.getString("PITCH_DETAIL"));
				String custCode = checkNull( rs.getString("SC_CODE") );
				//Added by Mrunalini Sinkar for fortune
				String pitchDetDescr ="";
								String pitchDetSql = "SELECT FLD_VALUE AS PITCH_DETAIL, DESCR AS PITCH_DETAIL_DESCR FROM GENCODES WHERE FLD_NAME = 'PITCH_DETAIL' AND MOD_NAME = 'W_WSFA_FORTUNE' "
						+ "AND ACTIVE = 'Y' AND FLD_VALUE=?";
				pstmt1 = connectionObject.prepareStatement(pitchDetSql);
				pstmt1.setString(1,pitchDet);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					pitchDetDescr = checkNull(rs1.getString("PITCH_DETAIL_DESCR"));
					System.out.println("PITCH_DETAIL_DESCR is::::::::"+pitchDetDescr);

				}
				if (rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if (pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}

				String callOutExt  = "";
				if( callOutMap.get( custCode.trim() ) != null )
				{
					callOutExt = ( String ) callOutMap.get( custCode.trim() );
					//System.out.println("callOutExt ::::["+callOutExt+"]");
					///pitchDetDescr = getPitchDescr(callOutExt, pitchDet);
					//System.out.println(" pitchDetDescr ::::["+pitchDetDescr+"]");
				}

				//String pitchDetDescr = getPitchDescr(callOutcome, pitchDet);
				//System.out.println("item["+item+"]");
				valueXmlString.append( "<Detail"+currentFormNo+" dbID='' domID='"+ domID +"' objContext='"+currentFormNo+"' objName='"+objNameDefault+"' selected='Y' formName='"+formName+"'>\r\n" );
				//Changed By Bhushan on 06-10-16
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				//valueXmlString.append("<attribute pkNames='' status='N' updateFlag='A' selected='Y' />\r\n");

				valueXmlString.append( "<work_date><![CDATA[" ).append(wrkDate).append( "]]></work_date>\r\n" );
				valueXmlString.append( "<sales_pers><![CDATA[").append(checkNull(salePersCode)).append("]]></sales_pers>\n");
				//valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( scCode ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<sc_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></sc_code>\r\n");
				valueXmlString.append( "<strg_code><![CDATA[").append( checkNull( rs.getString("SC_CODE") ) ).append("]]></strg_code>\r\n");

				valueXmlString.append( "<brand_code><![CDATA[").append(checkNull(rs.getString("BRAND_CODE"))).append("]]></brand_code>\n");
				valueXmlString.append( "<pitch_detail><![CDATA[").append(checkNull(rs.getString("PITCH_DETAIL"))).append("]]></pitch_detail>\r\n" );
				valueXmlString.append( "<pitch_feedback><![CDATA[]]></pitch_feedback>\r\n" );
				valueXmlString.append( "<pres_pattern><![CDATA[]]></pres_pattern>\r\n" );
				valueXmlString.append( "<remarks><![CDATA[]]></remarks>\r\n" );
				valueXmlString.append( "<line_no><![CDATA["+domID+"]]></line_no>\r\n" );

				valueXmlString.append( "<pitch_sequence><![CDATA[").append(checkNull(rs.getString("PITCH_SEQUENCE"))).append("]]></pitch_sequence>\n");

				valueXmlString.append( "<item_code><![CDATA[").append(checkNull(rs.getString("ITEM_CODE"))).append("]]></item_code>\n");
				//valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append(item).append("]]></item_descr>\n");
				valueXmlString.append( "<item_descr protect =\"1\"><![CDATA[").append("").append("]]></item_descr>\n");
				valueXmlString.append( "<brand_descr protect =\"1\"><![CDATA[").append(brand).append("]]></brand_descr>\n");
				valueXmlString.append( "<brand_type><![CDATA[]]></brand_type>\r\n" );
				valueXmlString.append( "<cur_val><![CDATA[]]></cur_val>\r\n" );
				valueXmlString.append( "<cur_nos><![CDATA[]]></cur_nos>\r\n" );
				valueXmlString.append( "<source><![CDATA[]]></source>\r\n" );
				valueXmlString.append( "<pitch_detail_data><![CDATA[" ).append( pitchDetData ).append( "]]></pitch_detail_data>\r\n" );
				//Added By Bhushan on 17-11-16
				valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull(rs.getString("TRAN_ID")) ).append( "]]></tran_id>\r\n" );
				valueXmlString.append( "<dcr_id><![CDATA[" ).append( checkNull(rs.getString("DCR_ID")) ).append( "]]></dcr_id>\r\n" );
				valueXmlString.append( "<call_outcome_data><![CDATA[" ).append(callOutcome).append( "]]></call_outcome_data>\r\n" );
				valueXmlString.append( "<call_outcome><![CDATA[" ).append(callOutExt).append( "]]></call_outcome>\r\n" );
				valueXmlString.append( "<pitch_detail_descr><![CDATA[" ).append( pitchDetDescr ).append( "]]></pitch_detail_descr>\r\n" );
				valueXmlString.append( "<sc_code_pitch><![CDATA[" ).append( checkNull( rs.getString("SC_CODE") ) ).append( "]]></sc_code_pitch>\r\n" );
				valueXmlString.append( "</Detail"+currentFormNo+">\r\n" );
				domID++;
			}
			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :SavexWizardEJB :getExistingPitchForDoctor :" + e.getMessage() + ":" );
			//valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if (rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

			}
			catch(Exception e)
			{
				System.out.println( "Exception :SavexWizardEJB :getExistingPitchForDoctor :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();

	}


	public String getFormattedStringBuff( String data )
	{
		StringBuffer dataString = new StringBuffer();
		try
		{
			String[] dataArr = null;

			if ( data.indexOf(",") == -1 )
			{
				dataString.append( "'"+data+"'" );
			}
			else
			{
				dataArr = data.split(",");
				for (int i=0; i < dataArr.length; i++ )
				{
					if ( i == 0 )
					{
						dataString.append( "'"+dataArr[i]+"'" );
					}
					else
					{
						dataString.append( "," );
						dataString.append( "'"+dataArr[i]+"'" );
					}
				}
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		return dataString.toString();
	}







	public String getObjNameFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String objName = "";
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				if( currDetail.getAttributes().getNamedItem(attribute) != null )
				{
					objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
					break;
				}
			}
			if( (objName == null || objName.trim().length() == 0) && currFormNo != 1 )
			{
				detailList = dom.getElementsByTagName("Detail1");
				detailListLength = detailList.getLength();
				for (int ctr = 0;ctr < detailListLength;ctr++)
				{
					currDetail = detailList.item(ctr);
					if( currDetail.getAttributes().getNamedItem(attribute) != null )
					{
						objName = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
						break;
					}
				}
			}
			if(objName == null || objName.trim().length() == 0)
			{
				NodeList objNameList = dom.getElementsByTagName("objName");
				if(objNameList != null && objNameList.getLength() > 0)
				{
					Node objNameNode = objNameList.item(0);
					if(objNameNode != null && objNameNode.getFirstChild() != null)
					{
						objName = checkNull(objNameNode.getFirstChild().getNodeValue());
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception Inside getObjNameFromDom ::["+e.getMessage()+"]");
			e.printStackTrace();
		}
		return objName;
	}
	public String getFormNo(String objName, String formName, Connection connectionObject) throws ITMException
	{
		Statement stmt = null;
		ResultSet rs = null;
		String formNo = "";
		try
		{
			String sql = "SELECT FORM_NO FROM OBJ_FORMS WHERE WIN_NAME = '"+"w_"+objName+"'AND FORM_NAME = '"+formName+"'";
			stmt = connectionObject.createStatement();
			rs = stmt.executeQuery(sql);
			if( rs.next() )
			{
				formNo = checkNull(rs.getString("FORM_NO"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( stmt !=null )
			{
				stmt.close();
				stmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( stmt !=null )
				{
					stmt.close();
					stmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return formNo;
	}

	public HashMap getSubForms(String formNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		PreparedStatement pStmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String formType = "";
		HashMap<String, String> SubFormMap = new LinkedHashMap<String,String>();
		try
		{
			String winName = "w_"+objName;
			String sql = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ?";
			pStmt = conn.prepareStatement(sql);
			pStmt.setString(1, winName);
			pStmt.setString(2, formNo);
			rs = pStmt.executeQuery();
			if( rs.next() )
			{
				formType = checkNull(rs.getString("FORM_TYPE"));
			}
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pStmt !=null )
			{
				pStmt.close();
				pStmt = null;
			}
			String[] nextArr = formType.split(":",3);
			String  nextForm= nextArr[2];
			//System.out.println("nextForm val is :-"+nextForm);
			int nextFormNo = 0;
			int currFormNo = 0;
			if( nextForm != null && nextForm.trim().length() > 0 )
			{
				nextFormNo = Integer.parseInt( nextForm );
			}
			if( formNo != null && formNo.trim().length() > 0 )
			{
				currFormNo = Integer.parseInt( formNo );
			}
			String formNameSql = "SELECT FORM_NO,FORM_NAME FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ? ";
			pStmtInner = conn.prepareStatement(formNameSql);

			for(int i = (currFormNo+1) ; i< nextFormNo; i++)
			{
				pStmtInner.setString(1, winName);
				pStmtInner.setInt(2, i);

				rsInner = pStmtInner.executeQuery();

				if(rsInner.next())
				{
					String _formNo = checkNull(rsInner.getString("FORM_NO"));
					String _formName = checkNull(rsInner.getString("FORM_NAME"));
					SubFormMap.put( _formName,_formNo);
				}
				pStmtInner.clearParameters();
				if( rsInner !=null )
				{
					rsInner.close();
					rsInner = null;
				}
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}
				if( pStmtInner !=null )
				{
					pStmtInner.close();
					pStmtInner = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return SubFormMap;
	}
	public String getParentformNo(String subFormNo, String objName, Connection conn) throws ITMException
	{
		PreparedStatement pStmt = null;
		ResultSet rs = null;
		int subFormNum = 0;
		String formNumber = "";
		String formType = "";
		boolean isMainForm = false;
		//System.out.println("subFormNosubFormNo"+subFormNo+"objName"+objName);
		try
		{
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field
			String sql="";
			String winName = "w_"+objName;
			if(conn == null)
			{
				conn = getConnection();
			}
			if( subFormNo != null && subFormNo.trim().length() > 0 )
			{
				subFormNum = Integer.parseInt( subFormNo );
			}
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				 sql  = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND TO_NUMBER(FORM_NO) = ? ";

			}
			else
			{
				 sql  = "SELECT FORM_NO,FORM_TYPE FROM OBJ_FORMS WHERE WIN_NAME = ? AND FORM_NO = ? ";

			}
			pStmt = conn.prepareStatement(sql);

			for(int j = subFormNum; j>=1; j--)
			{
				pStmt.setString(1, winName);
				pStmt.setString(2, ""+j);

				rs = pStmt.executeQuery();
				if(rs.next())
				{
					formNumber = checkNull(rs.getString("FORM_NO"));
					formType = checkNull(rs.getString("FORM_TYPE"));
					//System.out.println("Value for sub form["+j+"] is [formtype ["+formType+"] form no is ["+formNumber+"]");
					if(formType.indexOf("MP")>=0)
					{
						isMainForm = true;
					}
				}
				pStmt.clearParameters();
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if(isMainForm)
				{
					break;
				}
			}


		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pStmt !=null )
				{
					pStmt.close();
					pStmt = null;
				}

			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("formNumaver val:- "+formNumber);
		return formNumber;
	}

	public String getSplDescr(String strgCode,String sprsCode,Connection connectionObject) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
		ResultSet rs1 = null;

		String splCode = "";
		String spclDescr = "";
		try
		{

			String sql  = "SELECT SPL_CODE FROM STRG_SERIES WHERE SC_CODE  = ? AND SALES_PERS = ?";
			pstmt = connectionObject.prepareStatement(sql);
			pstmt.setString(1, strgCode);
			pstmt.setString(2, sprsCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				splCode = checkNull(rs.getString("SPL_CODE"));
			}
			//System.out.println("splCode splCode val:- "+splCode);
			if( rs !=null )
			{
				rs.close();
				rs = null;
			}
			if( pstmt !=null )
			{
				pstmt.close();
				pstmt = null;
			}

			if (splCode.length() > 0)
			{
				String sql1  = "SELECT DESCR FROM SPECIALITY WHERE SPL_CODE = ?";
				pstmt1 = connectionObject.prepareStatement(sql1);
				pstmt1.setString(1, splCode);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					spclDescr = checkNull(rs1.getString("DESCR"));
				}
				//System.out.println("spclDescr spclDescr val:- "+spclDescr);
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by mrunalini sinkar on 11-04-2018

		}
		finally
		{
			try
			{
				if( rs !=null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt !=null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( rs1 !=null )
				{
					rs1.close();
					rs1 = null;
				}
				if( pstmt1 !=null )
				{
					pstmt1.close();
					pstmt1 = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		//System.out.println("spclDescr val:- "+spclDescr);
		return spclDescr;
	}
	public String getPitchTranId(Connection conn)throws ITMException
	{
		String tranId ="";
		PreparedStatement pstmtNextSeq = null;
		ResultSet rsNextSeq = null;
		//CHANGES DONE IN SQL FOR DB2 GETTIN ISSUE BY PRATHAMESH JANGAM ON 04/7/17
		String dbName =CommonConstants.DB_NAME;
		String getNextSeqSql= null;

		try
		{
			String nextSeq = "";
			String tempScCode = "0000000000";
			//changes done by prathamesh jangam for db2 in sql
			if(dbName.equalsIgnoreCase("DB2"))
			{
				getNextSeqSql = "select next value for SEQ_TRAN_ID AS NEXT_SEQ from DUAL";
			}
			else if(dbName.equalsIgnoreCase("ORACLE"))
			{
				getNextSeqSql = "SELECT SEQ_TRAN_ID.NEXTVAL AS NEXT_SEQ FROM DUAL";
			}

			pstmtNextSeq = conn.prepareStatement(getNextSeqSql);
			rsNextSeq = pstmtNextSeq.executeQuery();
			if(rsNextSeq.next())
			{
				nextSeq = rsNextSeq.getString("NEXT_SEQ");
			}
			tempScCode = tempScCode + nextSeq;
			tranId = tempScCode.substring(tempScCode.length()-10);
		}
		catch(Exception e)
		{
			//System.out.println("Exception getPitchTranId()::: "+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNextSeq != null)
				{
					rsNextSeq.close();
					rsNextSeq = null;
				}
				if (pstmtNextSeq != null)
				{
					pstmtNextSeq.close();
					pstmtNextSeq = null;
				}

			}
			catch(Exception e)
			{
				//System.out.println("Exception getPitchTranId() "+ e.getMessage());
			}
		}
		return tranId;
	}
	private ArrayList getDomIdListFromDom( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String domID = "";
		ArrayList allSelectedDomIdList = new ArrayList();
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				currDetail = detailList.item(ctr);
				domID = currDetail.getAttributes().getNamedItem(attribute).getNodeValue();
				int intDomID = Integer.parseInt(domID);
				//System.out.println("DomiD value is := "+domID);
				allSelectedDomIdList.add(intDomID);

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		//System.out.println("allSelected Donm id on previous DAR:- "+allSelectedDomIdList);
		return allSelectedDomIdList;
	}
	public String geteventTime()
	{
		Date date = new Date();
		String strDateFormat = "hh:mm a";
		DateFormat dateFormat = new SimpleDateFormat(strDateFormat);
		String formattedDate= dateFormat.format(date);
		//System.out.println("Current time of the day using Date - 12 hour format: " + formattedDate);
		return formattedDate;
	}

	public String getPriorVisits( String sprsCode, String strgCode, String eventDate, String tranId, Connection conn) throws ITMException //added by rupali on 06/03/17
	{

		//System.out.println("Inside getPriorVisits::::::::::::::::::"+eventDate);
		String visitDates = "";
		String sql="";
		PreparedStatement pstmtPriorVisit = null;
		ResultSet rsPriorVisit = null;
		PreparedStatement pstmt1 = null;
		PreparedStatement pstmtSfaParm = null;
		ResultSet rs1 = null;
		ResultSet rsSfaParm = null;
		int priorDate = 0;
		String parmValue = "";
		String scName = "";
		String newDate=null;
		String address = "";
		String addr1 = "";
		String addr2 = "";
		String addr3 = "";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		int maxDate = 0;
		//Connection conn =null;
		StringBuffer sb = new StringBuffer();
		System.out.println("eventDate:::>>>:["+eventDate+"]");
		String currDcrDate = eventDate;//Added by vinayak on [28/07/16]
		boolean isLocalConn =false;
		String formatDate = "";
		StringBuffer valueXmlString = new StringBuffer("<Root>\r\n");
		try
		{
			//chnged by sachin satre on 9-nov-16 start
			if(conn == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					conn = connDriver.getConnectDB("DriverITM");*/
				conn =getConnection();//chnged by sachin satre on 9-nov-16
				isLocalConn =true;
			}
			//chnged by sachin satre on 9-nov-16 end
			int visitDtCnt = 0;
			SimpleDateFormat dtFormat = new SimpleDateFormat(genericUtility.getDBDateTimeFormat());
			String currDate = dtFormat.format(new java.util.Date());
			String reportTime=getSfaParmValue(sprsCode,"REPORT_TIME",conn); // added by mrunalini sinkar on 2-jul-2018(start)
			// added by rupali on 19/03/18 for showing data in dashboard link [start]
			if(tranId != null && tranId.trim().length() != 0)
			{
				String tranIdSql = "SELECT STRG_CODE, EVENT_DATE FROM STRG_MEET WHERE TRAN_ID = ?";
				pstmt1 = conn.prepareStatement(tranIdSql);
				pstmt1.setString(1,tranId);
				rs1=pstmt1.executeQuery();
				if(rs1.next())
				{
					strgCode = checkNull(rs1.getString("STRG_CODE"));
					eventDate = checkNull(rs1.getString("EVENT_DATE"));
					eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() );
					System.out.println("eventDate is:::>>>:["+eventDate+"] strgCode:::>>>:["+strgCode+"]");
				}
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				currDcrDate = eventDate;
			}
			// added by rupali on 19/03/18 for showing data in dashboard link [end]
			String strgSql = "SELECT SC.SC_CODE CODE, UPPER(SC.FIRST_NAME)||' '||UPPER(SC.LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER SC WHERE SC.SC_CODE = ? ";
			pstmt1 = conn.prepareStatement(strgSql);
			pstmt1.setString(1,strgCode);
			rs1=pstmt1.executeQuery();

			if(rs1.next())
			{
				scName = checkNull(rs1.getString("SC_NAME"));
			}
			System.out.println("scName =["+scName+"]");
			if(rs1 != null)
			{
				rs1.close();
				rs1 = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}

			String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME='STRG_PRIOR_VISITS' AND ? BETWEEN EFF_FROM AND VALID_UPTO AND ACTIVE='Y' ";
			pstmtSfaParm = conn.prepareStatement(sfaParmSql);
			pstmtSfaParm.setTimestamp(1, java.sql.Timestamp.valueOf(currDate));
			rsSfaParm = pstmtSfaParm.executeQuery();
			if (rsSfaParm.next())
			{
				parmValue = checkNull(rsSfaParm.getString("parm_value"));
			}
			if(rsSfaParm != null)
			{
				rsSfaParm.close();
				rsSfaParm = null;
			}
			if(pstmtSfaParm != null)
			{
				pstmtSfaParm.close();
				pstmtSfaParm = null;
			}
			System.out.println("parmValue[STRG_PRIOR_VISITS] =["+parmValue+"]");
			if(parmValue.length() > 0)
			{
				try
				{
					priorDate = Integer.parseInt(parmValue);
				}
				catch(NumberFormatException nfe )
				{
					priorDate = 0;
				}
			}
			/*if(currDcrDate.length()>0)
				{
					   //create SimpleDateFormat object with source string date format
				      SimpleDateFormat sdfSource = new SimpleDateFormat(genericUtility.getApplDateFormat());

				      Date date = sdfSource.parse(currDcrDate);
				      SimpleDateFormat sdfDestination = new SimpleDateFormat("MM-yy");
				      formatDate = sdfDestination.format(date);
				      formatDate = "%"+ formatDate;
				}*/
			//added by kailash on 29/03/17:start -for taking current month prior_visit
			if(currDcrDate != null && currDcrDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				//create SimpleDateFormat object with source string date format
				SimpleDateFormat sdfSource = new SimpleDateFormat(genericUtility.getApplDateFormat());
				java.util.Date date1 = sdfSource.parse(currDcrDate);
				Calendar cal = Calendar.getInstance();
				cal.setTime(date1);
				int dateVal = cal.get(Calendar.DATE);
				System.out.println("dateVal =["+dateVal+"]");
				cal.set(Calendar.DATE, 1);
				dateVal = cal.get(Calendar.DATE);
				System.out.println("dateVal =["+dateVal+"]");

				newDate = sdfSource.format(cal.getTime());
				System.out.println("newDate =["+newDate+"]");

			}
			//added by kailash on 29/03/17:end
			HashMap callNoteTypeMap = getCallNoteTypeMap(conn);

			if(eventDate != null && eventDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				eventDate = genericUtility.getValidDateTimeString( eventDate , getApplDateFormat() , getDBDateFormat());
			}
			//added by kailash on 29/03/2017 start
			if(newDate != null && newDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				newDate = genericUtility.getValidDateTimeString( newDate , getApplDateFormat() , getDBDateFormat());
			}
			//added by kailash on 29/03/2017 end

			//Commented by vinayak on [28/07/16] [changeed sql to show calloutcome][start]
			/*String priorVisitSql = " select  to_char(sm.event_date,'dd/mm/yyyy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark from strg_meet sm,fieldactivity fa "+
					  " where sm.event_type = fa.activity_code and fa.activity_type not in ('LEAVE','NFW') and sm.strg_code = ? "+
					  " and sm.sales_pers = ? "+
					  " and sm.event_date <  ? order by sm.event_date desc ";*/
			//Commented by vinayak on [28/07/16] [changed sql to show calloutcome][end]

			//Commented by rupali on  15/03/17 changeed sql to show address of customer[start]
			//Added by vinayak on [28/07/16] [changeed sql to show calloutcome][start]
			/* String priorVisitSql = " select  to_char(sm.event_date,'dd-Mon-yy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime from strg_meet sm,fieldactivity fa "+
				  " where sm.event_type = fa.activity_code and fa.activity_type not in ('LEAVE','NFW') and sm.strg_code = '"+strgCode+"' "+
				  " and sm.sales_pers = '"+sprsCode+"' "+
				  " and sm.event_date <  ? order by sm.event_date desc "; */
			//Added by vinayak on [28/07/16] [changeed sql to show calloutcome][end]
			//Commented by rupali on  15/03/17 changeed sql to show address of customer[start]

			//added by Rupali on 15/03/17 for adding address column in prior visit [start]
			String priorVisitSql="";
			if(eventDate != null && eventDate.trim().length()>0) // changes made by rupali on 25/07/18 for showing prior visits on customer and series master
			{
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select  to_char(sm.event_date,'dd-Mon-yy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.sales_pers = '"+sprsCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" and sm.event_date <  ? and sm.event_date >= ? order by sm.event_date desc ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select translate(char(date(event_date ),EUR),'/','.') AS VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.sales_pers = '"+sprsCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" and sm.event_date <  ? and sm.event_date >= ? order by sm.event_date desc ";
				}
				//added by kailash on 29/03/17 for taking current month date[end]
				//added by Rupali on 15/03/17 for adding address column in prior visit [end]

				System.out.println("priorVisitSql+++"+priorVisitSql);
				pstmtPriorVisit = conn.prepareStatement(priorVisitSql);
				//pstmtPriorVisit.setString(1,strgCode);
				//pstmtPriorVisit.setString(2,sprsCode);
				pstmtPriorVisit.setTimestamp(1,java.sql.Timestamp.valueOf(eventDate));
				//added by kailash on 29/03/17 start -for adding current month date into prepare statement
				pstmtPriorVisit.setTimestamp(2,java.sql.Timestamp.valueOf(newDate));
				//added by kailash on 29/03/17 end
			}
			// added by rupali on 25/07/18 for showing prior visits on customer and series master [start]
			else
			{
				if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select  to_char(sm.event_date,'dd-Mon-yy') as VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" order by sm.event_date desc ";
				}
				else if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
				{
					priorVisitSql = " select translate(char(date(event_date ),EUR),'/','.') AS VisitDates,sm.meet_summ as callNotes,sm.remarks as remark,sm.call_outcome as callOutCome,sm.event_time_start as eventTime,sc.addr1 as addr1,sc.addr2 addr2,sc.addr3 addr3 from strg_meet sm,fieldactivity fa,strg_customer sc "+
							" where sm.event_type = fa.activity_code and fa.activity_type in ('FW') and sm.strg_code = '"+strgCode+"' "+
							" and sm.strg_code = sc.sc_code"+
							" order by sm.event_date desc ";
				}
				System.out.println("priorVisitSql+++"+priorVisitSql);
				pstmtPriorVisit = conn.prepareStatement(priorVisitSql);
			}
			// added by rupali on 25/07/18 for showing prior visits on customer and series master [end]
			rsPriorVisit = pstmtPriorVisit.executeQuery();
			System.out.println("After Query");
			while (rsPriorVisit.next())
			{
				System.out.println("inside while loop.... ::");
				visitDtCnt++;

				String VisitDates = checkNull(rsPriorVisit.getString("VisitDates"));
				String callNotes = checkNull(rsPriorVisit.getString("callNotes"));
				String docRemark =  checkNull(rsPriorVisit.getString("remark")); //Added by vinayak to add remark column in prior visit on [03/05/2016]
				String callOutCome =  checkNull(rsPriorVisit.getString("callOutCome"));//Added by vinayak on [28/07/16]
				String eventTime =  checkNull(rsPriorVisit.getString("eventTime"));
				//added by Rupali on 15/03/17 for adding address column in prior visit [start]
				addr1 = checkNull(rsPriorVisit.getString("addr1"));
				addr2 = checkNull(rsPriorVisit.getString("addr2"));
				addr3 = checkNull(rsPriorVisit.getString("addr3"));
				address = addr1 +", "+addr2 +", "+addr3;
				//added by Rupali on 15/03/17 for adding address column in prior visit [end]
				if(callNotes.length() > 0)
				{
					String callNotesArr[] = callNotes.split(",");

					for(int i = 0; i < callNotesArr.length; i++)
					{
						String singleNotes = callNotesArr[i];

						if(singleNotes != null && singleNotes.trim().length() > 0)
						{
							String singleNoteArr[] = singleNotes.split(":");

							String noteType = "";
							String callNote = "";
							if(singleNoteArr.length >= 2)
							{
								noteType = checkNull(singleNoteArr[1]);
								callNote =checkNull(singleNoteArr[2]);
							}
							valueXmlString.append("<prior_visit >\r\n");
							if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
							{
								System.out.println("inside db2");
								SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
								Date date = sdf.parse(VisitDates);
								sdf = new SimpleDateFormat("dd-MMM-yy");
								String visitEventDate=sdf.format(date);
								System.out.println("visitEventDate is"+visitEventDate);
								valueXmlString.append("<event_date><![CDATA[").append(visitEventDate).append("]]></event_date>\r\n");
							}
							else if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
							{
								valueXmlString.append("<event_date><![CDATA[").append(VisitDates).append("]]></event_date>\r\n");
							}
							valueXmlString.append("<call_notes><![CDATA[" ).append(checkNull(callNote)).append( "]]></call_notes>\r\n" );
							valueXmlString.append("<remarks><![CDATA[").append(checkNull(docRemark)).append("]]></remarks>\r\n");//Added by vinayak to add remark column in prior visit on [03/05/2016]
							valueXmlString.append("<note_type><![CDATA[").append(checkNull((String)callNoteTypeMap.get(noteType))).append("]]></note_type>\r\n");
							valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
							valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
							valueXmlString.append("<call_outcome><![CDATA[").append(checkNull(callOutCome)).append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
							valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
							valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(eventTime)).append("]]></event_time_start>\r\n");
							valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
							valueXmlString.append("<report_time><![CDATA[").append(checkNull(reportTime)).append("]]></report_time>\r\n"); // added by mrunalini sinkar on 02-july-2018
							valueXmlString.append("</prior_visit>\r\n");
						}
					}

				}
				else
				{
					System.out.println("inside else loop.... ::");
					valueXmlString.append("<prior_visit >\r\n");
					if("DB2".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						System.out.println("inside db2");
						SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
						Date date = sdf.parse(VisitDates);
						sdf = new SimpleDateFormat("dd-MMM-yy");
						String visitEventDate=sdf.format(date);
						System.out.println("visitEventDate is"+visitEventDate);
						valueXmlString.append("<event_date><![CDATA[").append(visitEventDate).append("]]></event_date>\r\n");
					}
					else if("ORACLE".equalsIgnoreCase(CommonConstants.DB_NAME))
					{
						valueXmlString.append("<event_date><![CDATA[").append(VisitDates).append("]]></event_date>\r\n");
					}
					valueXmlString.append("<call_notes><![CDATA[" ).append("").append( "]]></call_notes>\r\n" );
					valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");//Added by vinayak to add remark column in prior visit on [03/05/2016]
					valueXmlString.append("<note_type><![CDATA[").append("").append("]]></note_type>\r\n");
					valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
					valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
					valueXmlString.append("<call_outcome><![CDATA[").append(checkNull(callOutCome)).append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
					valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
					valueXmlString.append("<event_time_start><![CDATA[").append(checkNull(eventTime)).append("]]></event_time_start>\r\n");
					valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
					valueXmlString.append("<report_time><![CDATA[").append(checkNull(reportTime)).append("]]></report_time>\r\n"); // added by mrunalini sinkar on 02-july-2018
					valueXmlString.append("</prior_visit>\r\n");

				}

				if(priorDate > 0 && visitDtCnt == priorDate)
				{
					break;
				}

			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if( rsPriorVisit !=null )
			{
				rsPriorVisit.close();
				rsPriorVisit = null;
			}
			if( pstmtPriorVisit !=null )
			{
				pstmtPriorVisit.close();
				pstmtPriorVisit = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
			if(visitDtCnt == 0)
			{
				String addressSql = "select addr1,addr2,addr3 from strg_customer where sc_code = ?";
				pstmt1 = conn.prepareStatement(addressSql);
				pstmt1.setString(1,strgCode);
				rs1=pstmt1.executeQuery();
				if(rs1.next())
				{
					addr1 = checkNull(rs1.getString("addr1"));
					addr2 = checkNull(rs1.getString("addr2"));
					addr3 = checkNull(rs1.getString("addr3"));
				}
				address = addr1 +", "+addr2 +", "+addr3;
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				System.out.println("outside while loop.... ::");
				valueXmlString.append("<prior_visit >\r\n");
				valueXmlString.append("<event_date><![CDATA[").append("").append("]]></event_date>\r\n");
				valueXmlString.append("<call_notes><![CDATA[" ).append("").append( "]]></call_notes>\r\n" );
				valueXmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");//Added by vinayak to add remark column in prior visit on [03/05/2016]
				valueXmlString.append("<note_type><![CDATA[").append("").append("]]></note_type>\r\n");
				valueXmlString.append("<strg_code><![CDATA[").append(checkNull(strgCode)).append("]]></strg_code>\r\n");
				valueXmlString.append("<strg_name><![CDATA[").append(checkNull(scName)).append("]]></strg_name>\r\n");
				valueXmlString.append("<call_outcome><![CDATA[").append("").append("]]></call_outcome>\r\n");//Added by vinayak on [28/07/16] to get call outcome
				valueXmlString.append("<dcr_date><![CDATA[").append(checkNull(currDcrDate)).append("]]></dcr_date>\r\n");//Added by vinayak on [28/07/16]
				valueXmlString.append("<event_time_start><![CDATA[").append("").append("]]></event_time_start>\r\n");
				valueXmlString.append("<address><![CDATA[").append(checkNull(address)).append("]]></address>\r\n"); //added by Rupali on 15/03/17 for adding address column in prior visit
				valueXmlString.append("</prior_visit>\r\n");
			}

		}

		catch(Exception e)
		{
			//System.out.println("Exception:----");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs1 != null)
				{
					rs1.close();
					rs1 = null;
				}
				if(pstmt1 != null)
				{
					pstmt1.close();
					pstmt1 = null;
				}
				if(rsPriorVisit != null)
				{
					rsPriorVisit.close();
					rsPriorVisit = null;
				}
				if(pstmtPriorVisit != null)
				{
					pstmtPriorVisit.close();
					pstmtPriorVisit = null;
				}
				if(isLocalConn && conn != null && ! conn.isClosed() )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{

			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();

	}

	private HashMap getCallNoteTypeMap (Connection conn ) throws ITMException  //added by rupali on 06/03/17
	{
		PreparedStatement pstmtNoteType = null;
		ResultSet rsNoteType = null;
		HashMap callNoteTypeMap = new HashMap();
		String noteType = "";
		String descr = "";
		String shDescr = "";

		try
		{

			String noteTypeSql = "SELECT NOTE_TYPE, DESCR, SH_DESCR, REQ_FOLL_UP, TASK_TYPE FROM CALL_NOTE_TYPE ";
			pstmtNoteType = conn.prepareStatement(noteTypeSql);
			rsNoteType = pstmtNoteType.executeQuery();

			while(rsNoteType.next())
			{
				noteType = checkNull(rsNoteType.getString("NOTE_TYPE"));
				descr = checkNull(rsNoteType.getString("DESCR"));
				shDescr = checkNull(rsNoteType.getString("SH_DESCR"));

				callNoteTypeMap.put(noteType, shDescr);

			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [Start]
			if (rsNoteType != null)
			{
				rsNoteType.close();
				rsNoteType = null;
			}
			if(pstmtNoteType !=null)
			{
				pstmtNoteType.close();
				pstmtNoteType = null;
			}
			//Added by Hariom for dirty connection close - 11-Feb-2021 [End]
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsNoteType != null)
				{
					rsNoteType.close();
					rsNoteType = null;
				}
				if(pstmtNoteType !=null)
				{
					pstmtNoteType.close();
					pstmtNoteType = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		System.out.println("callNoteTypeMap ::"+callNoteTypeMap);
		return callNoteTypeMap;
	}








	public String getMsgDescr(String messageCode,Connection connectionObject)throws ITMException
	{
		//System.out.println(">>>>>>>>>>getMsgDescr()<<<<<<<<<<<<");
		String returnString="";
		String msgDescr="";
		boolean isLocalConn =false;
		try
		{
			//Connection connectionObject = null;
			PreparedStatement pstmtSelect = null;
			ResultSet resultSelect = null ;
			if(connectionObject == null)
			{
				/*ConnDriver connDriver = new ConnDriver();
					connectionObject = connDriver.getConnectDB("DriverValidator");*/
				connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, messageCode);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				msgDescr = (resultSelect.getString("MSG_DESCR") == null)?"":resultSelect.getString("MSG_DESCR").trim();
			}
			returnString=msgDescr;
			resultSelect.close();
			resultSelect=null;
			pstmtSelect.close();
			pstmtSelect=null;

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return returnString;
	}
	// added by rupali on 10/11/17 for not allowing to enter DAR if 3 DCR are pending to confirm [end]
	public String getEmpCode(String userId,Connection connectionObject)throws ITMException
	{
		String empCode="";
		String entityCode="";
		boolean isLocalConn =false;
		PreparedStatement pstmtSelect = null;
		ResultSet resultSelect = null ;
		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn =true;
			}
			String selectMsgDescrSql = "SELECT EMP_CODE,ENTITY_CODE FROM USERS WHERE CODE= ? ";
			pstmtSelect = connectionObject.prepareStatement(selectMsgDescrSql);
			pstmtSelect.setString(1, userId);
			resultSelect = pstmtSelect.executeQuery();
			if(resultSelect.next())
			{
				empCode = checkNull(resultSelect.getString("EMP_CODE"));
				entityCode = checkNull(resultSelect.getString("ENTITY_CODE"));
			}
			if(empCode == null || empCode.trim().length() == 0)
			{
				empCode = entityCode;
			}

		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetWizardEJB:getMsgDescr():==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(resultSelect != null)
				{
					resultSelect.close();
					resultSelect = null;
				}
				if(pstmtSelect != null)
				{
					pstmtSelect.close();
					pstmtSelect = null;
				}
				if(isLocalConn && connectionObject != null)
				{
					connectionObject.close();
					connectionObject=null;
				}
			}
			catch (Exception e)
			{
				e.getMessage();
			}
		}
		return empCode;
	}

	public String getExistingSurveyDetail( String salePersCode, String eventDate, String custList,String formNo,String formName,Connection connectionObject  ) throws ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int domID=1;
		String surveyQuery="";
		String resultType = "";
		String result = "";
		StringBuffer valueXmlString = new StringBuffer();

		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isLocalConn = false;

		try
		{
			if(connectionObject == null)
			{
				connectionObject = getConnection();
				isLocalConn = true;
			}
			if ( eventDate != null )
			{
				eventDate = genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ;
			}

			String dcrID = "";
			String selectQuery = "SELECT MAX(DCR_ID) DCR_ID FROM STRG_MEET WHERE EVENT_DATE =? AND SALES_PERS = ?";
			pstmt = connectionObject.prepareStatement( selectQuery );
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf(eventDate));
			pstmt.setString(2, salePersCode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				dcrID = checkNull(rs.getString("DCR_ID"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			int lineNo = 0;
			surveyQuery="SELECT SSR.LINE_NO,SSR.STRG_CODE,SSR.SURVEY_CODE,SSR.CONTEXT,SSR.RESULT, SM.DESCR AS SURVEY_DESCR, SM.RESULT_TYPE RESULT_TYPE, SM.SURVEY_METADATA SURVEY_METADATA  "
					+" ,SSR.DOC_ID_2 ,SG.SH_DESCR AS SH_DESCR"//Added by kailash on 11-12-18 for attachment provision in edit mode.
					+" FROM STRG_SURV_RES SSR, SURVEY_MASTER SM,SURVEY_GROUP SG"
					+" WHERE SSR.SURVEY_CODE = SM.SURVEY_CODE AND SM.SURVEY_GROUP = SG.SURVEY_GROUP "
					+" AND SSR.DCR_ID = ? AND STRG_CODE IN("+custList+") order by SG.SH_DESCR,SM.DESCR";

			pstmt = connectionObject.prepareStatement(surveyQuery);
			pstmt.setString(1, dcrID);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				lineNo = rs.getInt("LINE_NO");
				String surveyMetadata = checkNull(rs.getString("SURVEY_METADATA"));
				resultType = checkNull(rs.getString("RESULT_TYPE"));
				result = checkNull(rs.getString("RESULT"));

				System.out.println(" Survey :: resultType :: =["+resultType+"], result :: =["+result+"], surveyMetadata :: =["+surveyMetadata+"]");

				valueXmlString.append("<Detail"+formNo+" domID='"+domID+"' selected = 'Y' formName='"+formName+"'>\r\n" );
				valueXmlString.append("<attribute pkNames='' status='O' updateFlag='E' selected='Y' />\r\n");
				valueXmlString.append("<survey_code><![CDATA[").append(checkNull(rs.getString("SURVEY_CODE"))).append("]]></survey_code>\n");
				valueXmlString.append("<survey_descr><![CDATA[").append(checkNull(rs.getString("SURVEY_DESCR"))).append("]]></survey_descr>\n");
				valueXmlString.append("<context><![CDATA[").append(checkNull(rs.getString("CONTEXT"))).append("]]></context>\n");
				valueXmlString.append("<strg_code><![CDATA[").append( checkNull(rs.getString("STRG_CODE")) ).append("]]></strg_code>\r\n");
				valueXmlString.append("<result><![CDATA[").append(result).append("]]></result>\r\n");
				valueXmlString.append("<result_type><![CDATA[").append(resultType).append("]]></result_type>\r\n");
				valueXmlString.append("<meta_data><![CDATA[").append(checkNull(rs.getString("SURVEY_METADATA"))).append("]]></meta_data>\r\n");
				valueXmlString.append("<survey_group_descr><![CDATA[").append(checkNull(rs.getString("SH_DESCR"))).append("]]></survey_group_descr>\r\n");
				if("N".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '1'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0'><![CDATA[").append("").append("]]></result4>\r\n");//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("L".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '1'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("D".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '1'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("T".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				else if("A".equalsIgnoreCase(resultType))
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '1'><![CDATA[").append(result).append("]]></result5>\r\n");
				}
				else
				{
					valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
					valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
					valueXmlString.append("<result3 visible = '1'><![CDATA[").append(result).append("]]></result3>\r\n");
					valueXmlString.append("<result4 visible = '0'><![CDATA[").append("").append("]]></result4>\r\n");
					valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
				}
				valueXmlString.append("<line_no><![CDATA[").append( lineNo).append("]]></line_no>\r\n");
				valueXmlString.append("<dcr_id><![CDATA[").append(dcrID).append("]]></dcr_id>\r\n");
				valueXmlString.append("<doc_id_2><![CDATA[").append(checkNull(rs.getString("DOC_ID_2"))).append("]]></doc_id_2>\r\n");//Added by kailash on 11-12-18.
				valueXmlString.append( "</Detail"+formNo+">\r\n" );
				domID++;
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getExistingSurveyDetail(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( isLocalConn && connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
				}
				connectionObject = null;
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :defaultDataWiz :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return valueXmlString.toString();
	}

	public String getSurveyList(Document dom, String sprsCode, String strgCode, String selectedItem, String eventDate, String formNo,String formName,String surveyTemplate ) throws ITMException
	{
		String sql = "";
		StringBuffer valueXmlString = new StringBuffer();
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		PreparedStatement landingRatePstmt=null;
		PreparedStatement pstmtScName=null;
		ResultSet rs = null;
		ResultSet rsScName = null;
		ResultSet lRateResSet= null;
		double landingRate = 0d;
		String landingRateSQL="";
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		boolean isMasterPitchFound = false;

		//String scName = "";
		String itemSer = "";
		int domId = 1;

		String lineNoStr = "";
		try
		{
			valueXmlString.append( "<Root>\r\n" );
			connectionObject = getConnection();

			System.out.println(" selectedItem ["+selectedItem+"]");
			HashMap surveyMap = new HashMap();
			HashMap surveyLineNoMap = new HashMap();
			HashMap surveydocId = new HashMap();//Added by kailash .

			String dcrID = getDCRId(connectionObject,sprsCode, eventDate);
			System.out.println(" dcrID :: " + dcrID);

			//Added by Gaurav Singh on 09-Dec-2015 [ Start | As per Ajinkya requirement ]
			String scName="";
			String localityDescr="";

			String scNameSql = "SELECT UPPER(FIRST_NAME)||' '||UPPER(LAST_NAME) AS SC_NAME FROM STRG_CUSTOMER_RETAIL WHERE SC_CODE = ?";
			pstmtScName = connectionObject.prepareStatement(scNameSql);
			pstmtScName.setString(1, strgCode);
			rsScName = pstmtScName.executeQuery();
			if(rsScName.next())
			{
				scName = (rsScName.getString("SC_NAME") == null) ?"":rsScName.getString("SC_NAME").trim();
			}
			if(rsScName != null)
			{
				rsScName.close(); rsScName = null;
			}
			if(pstmtScName != null)
			{
				pstmtScName.close(); pstmtScName = null;
			}
			/*valueXmlString.append("<freeform>" );
			valueXmlString.append("<chemist_name name='chemist_name' displaylabel='Chemist Name :' type='input' protect='1'><![CDATA[").append(checkNull(scName)).append("]]></chemist_name>\n");
			valueXmlString.append("<beat name='beat' displaylabel='Beat :' type='input' protect='1'><![CDATA[").append(checkNull(localityDescr)).append("]]></beat>\n");
			valueXmlString.append("<dcr_date name='dcr_date' displaylabel='DCR Date :' type='date' protect='1'><![CDATA[").append(checkNull(eventDate)).append("]]></dcr_date>\n");
			//valueXmlString.append("<preferred_stockist name='preferred_stockist' displaylabel='Preferred Stockist :' type='input' protect='0' pophelp='true'><![CDATA[").append("").append("]]></preferred_stockist>\n");
			valueXmlString.append("</freeform>" );*/

			//Added by Gaurav Singh on 09-Dec-2015 [ End | As per Ajinkya requirement ]


			if ( selectedItem != null && selectedItem.trim().length() > 0 )
			{
				NodeList itemNodeList = ( genericUtility.parseString( selectedItem ) ).getElementsByTagName("Detail"+formNo+"");

				int nodeListLen = itemNodeList.getLength();
				System.out.println("nodeListLen is::::::"+nodeListLen);
				for ( int i=0; i < nodeListLen ; i++ )
				{
					NodeList innerNodeList = itemNodeList.item( i ).getChildNodes();
					int innerNodeListLen = innerNodeList.getLength();
					String surveyCode = "";
					String result = "";
					String docId = "";//Added by kailash on 11-12-18.
					String surveyDescr = "";
					String columnValue = "";
					String docId2 = "";

					for ( int j = 0; j < innerNodeListLen; j++ )
					{
						Node currNode = innerNodeList.item( j );
						System.out.println("COLUMNAME ["+ currNode.getNodeName()+"] COLUMKN VALUE["+currNode.getFirstChild()+"] ");
						if ( "survey_code".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild() != null)
							{
								surveyCode = currNode.getFirstChild().getNodeValue().trim() ;
							}
						}
						else if ( "result".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild()!= null )
							{
								result = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						else if ( "line_no".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild()!= null )
							{
								lineNoStr = currNode.getFirstChild().getNodeValue().trim();
							}
						}
						//Added by kailash on 11-12-18 [start]
						/*else if ( "doc_id".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild()!= null )
							{
								docId = currNode.getFirstChild().getNodeValue().trim();
							}
						}*/
						//Added by kailash on 11-12-18 [end]
						else if ( "doc_id_2".equals( currNode.getNodeName() ) )
						{
							if(currNode.getFirstChild()!= null )
							{
								docId2 = currNode.getFirstChild().getNodeValue().trim();
							}
						}
					}
					System.out.println("surveyCode["+surveyCode+"] surveyDescr["+surveyDescr+"] docId["+docId+"]" );
					//itemMap.put( surveyCode, surveyDescr+"~"+result);
					surveyMap.put( surveyCode, result);
					surveyLineNoMap.put( surveyCode, lineNoStr);
					//surveydocId.put( surveyCode, docId);//Added by kailash.
					surveydocId.put( surveyCode, docId2);

					//System.out.println(" surveyMap ["+surveyMap+"]surveydocId["+surveydocId.toString()+"]");
				}
			}

			String itemSerSql = "SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS = ?";
			PreparedStatement pstmtItemSer =  connectionObject.prepareStatement(itemSerSql);
			pstmtItemSer.setString(1,sprsCode);
			ResultSet rsItemSer = pstmtItemSer.executeQuery();
			if ( rsItemSer.next())
			{
				itemSer = rsItemSer.getString("ITEM_SER");
			}
			rsItemSer.close();rsItemSer = null;
			pstmtItemSer.close();pstmtItemSer = null;

			System.out.println("itemSer =["+itemSer+"]");

			String surveyCode = "";
			String surveyDescr = "";
			String dynamicSql = "";
			String resultType = "";
			String sfaParmVal = "";
			String surveyMetadata = "";
			String resultFormat = "";
			String showAttachment="";
			String surveyMandatory ="",surveyTempl="",defaultVal="";
			//Added by Pooja S on 29-JULY-2020 [Survey Grouping realted implementation]
			String surveyGrpDescr="";

			int lineNo = 1;
			int lineNoNew = 1;
			lineNoStr = "";
			int maxLineNo = 0;
			int num = 1;

			String maxLineSql = "SELECT MAX(CASE WHEN LINE_NO IS NULL THEN 1 ELSE LINE_NO END) AS MAX_LINE_NO FROM STRG_SURV_RES WHERE DCR_ID = ?";
			PreparedStatement pstmtLineNo = connectionObject.prepareStatement(maxLineSql);
			pstmtLineNo.setString(1, dcrID);

			ResultSet rsLineNo = pstmtLineNo.executeQuery();
			if(rsLineNo.next())
			{
				maxLineNo = rsLineNo.getInt("MAX_LINE_NO");

				lineNoNew = maxLineNo;
			}
			if(rsLineNo != null)
			{
				rsLineNo.close(); rsLineNo = null;
			}
			if(pstmtLineNo != null)
			{
				pstmtLineNo.close(); pstmtLineNo = null;
			}
			System.out.println("getSurveyList >> maxLineNo =["+maxLineNo+"]");

			//Commented and changed by Gulzar on 12/03/16 : START
			/*String surveySql = "SELECT B.SEQ_NO SEQ_NO, B.SURVEY_CODE SURVEY_CODE, C.DESCR AS SURVEY_DESCR, C.DYNAMIC_SQL DYNAMIC_SQL, C.RESULT_TYPE "+
						" FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C "+
						" WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL "+
						" AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE WHERE ITEM_SER = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO ) "+
						" AND B.SURVEY_CODE = C.SURVEY_CODE AND C.ACTIVE='Y'"+
						" ORDER BY SEQ_NO ";*/
			//Changed by Pooja S on 29-JULY-2020 [Survey Grouping realted implementation]
			String surveySql = "SELECT B.SEQ_NO SEQ_NO, B.SURVEY_CODE SURVEY_CODE, C.DESCR AS SURVEY_DESCR, C.DYNAMIC_SQL DYNAMIC_SQL, C.RESULT_TYPE,A.SURVEY_TEMPL,C.DEFAULT_VAL "+
					", C.RESULT_FORMAT RESULT_FORMAT, C.RESULT_RANGE_MIN RESULT_RANGE_MIN, C.RESULT_RANGE_MAX RESULT_RANGE_MAX, "+
					" C.SURVEY_METADATA SURVEY_METADATA, C.SURVEY_GROUP SURVEY_GROUP, G.DESCR SURVEY_GRP_DESCR,G.SH_DESCR AS SH_DESCR,C.ATTACH_OPT, C.MANDATORY " +
					" FROM SURVEY_TEMPLATE A, SURVEY_TEMPL_DET B, SURVEY_MASTER C, SURVEY_GROUP G "+
					" WHERE A.SURVEY_TEMPL = B.SURVEY_TEMPL AND C.SURVEY_GROUP = G.SURVEY_GROUP "+
					" AND A.SURVEY_TEMPL IN(SELECT SURVEY_TEMPL FROM SURVEY_TEMPLATE WHERE SURVEY_TEMPL = ? AND ? BETWEEN EFF_FROM AND VALID_UPTO AND CONFIRMED ='Y') "+
					" AND B.SURVEY_CODE = C.SURVEY_CODE AND C.ACTIVE='Y'"+
					" ORDER BY C.SURVEY_CODE, SEQ_NO ";

			/*String sfaParmSql = "SELECT PARM_VALUE FROM SFAPARM WHERE PARM_NAME ='CHC_SURVEY' AND ORG_UNIT ='SUNOTC'";
			PreparedStatement pstmtParm = connectionObject.prepareStatement(sfaParmSql);
			ResultSet rsParm = pstmtParm.executeQuery();
			if(rsParm.next())
			{
				sfaParmVal = checkNull(rsParm.getString("PARM_VALUE"));
			}*/
			if(surveyTemplate!=null && surveyTemplate.trim().length()>0)
			{
				sfaParmVal=surveyTemplate;
			}
			else
			{
				sfaParmVal  = getSfaParmValue(sprsCode,"CHC_SURVEY",connectionObject);
			}
			System.out.println("sfaParmVal =["+sfaParmVal+"]");
			//Commented and changed by Gulzar on 12/03/16 : END
			PreparedStatement pstmtSurvey =  connectionObject.prepareStatement(surveySql);
			//Gulzar on 12/03/16
			//pstmtSurvey.setString(1,itemSer);
			pstmtSurvey.setString(1,sfaParmVal);
			pstmtSurvey.setTimestamp(2,java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ));
			ResultSet rsSurvey = pstmtSurvey.executeQuery();

			while ( rsSurvey.next() )
			{
				surveyCode = checkNull(rsSurvey.getString("SURVEY_CODE"));
				surveyDescr = checkNull(rsSurvey.getString("SURVEY_DESCR"));
				dynamicSql = checkNull(rsSurvey.getString("DYNAMIC_SQL"));
				resultType = checkNull(rsSurvey.getString("RESULT_TYPE"));
				surveyMetadata = checkNull(rsSurvey.getString("SURVEY_METADATA"));
				resultFormat = checkNull(rsSurvey.getString("RESULT_FORMAT"));
				showAttachment = checkNull(rsSurvey.getString("ATTACH_OPT"));
				surveyMandatory = checkNull(rsSurvey.getString("MANDATORY"));
				surveyTempl = checkNull(rsSurvey.getString("SURVEY_TEMPL"));
				defaultVal =checkNull(rsSurvey.getString("DEFAULT_VAL"));
				//Added by Pooja S on 29-JULY-2020 [Survey Grouping realted implementation]
				surveyGrpDescr =checkNull(rsSurvey.getString("SH_DESCR"));

				String documentId = ""; //Added by kailash.
				if ( dynamicSql.trim().length() > 0 )
				{
					String surveyContext = "";
					String surveyCtxDescr = "";
					String surveyCtxShDescr = "";
					//String rate = "";

					PreparedStatement pstmtTemp =  connectionObject.prepareStatement(dynamicSql);

					if(dynamicSql.indexOf("?") != -1)
					{
						pstmtTemp.setString(1, sprsCode);
					}
					ResultSet rsTemp = pstmtTemp.executeQuery();

					while ( rsTemp.next() )
					{
						surveyContext = checkNull(rsTemp.getString("context"));
						surveyCtxDescr = checkNull(rsTemp.getString("context_descr"));
						surveyCtxShDescr = checkNull(rsTemp.getString("context_sh_descr"));

						String result =defaultVal;
						if ( surveyMap.get( surveyCode.trim() ) != null )
						{
							String data = ( String ) surveyMap.get( surveyCode.trim() );
							//valueXmlString.append("<Detail8 domID='"+domId+"' selected = 'Y'>\r\n" );
							valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
							//valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
							valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");

							lineNoStr = (String)surveyLineNoMap.get(surveyCode.trim() );
							if(lineNoStr != null && lineNoStr.trim().length() > 0)
							{
								lineNo = Integer.parseInt( lineNoStr );
							}
							valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
							valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
						}
						else
						{
							lineNoNew++;
							//valueXmlString.append("<Detail8 domID='"+domId+"' selected = 'N'>\r\n" );
							valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
							valueXmlString.append( "<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
							valueXmlString.append("<line_no><![CDATA["+lineNoNew+"]]></line_no>\r\n");
							valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\r\n");
						}

						//valueXmlString.append("<Detail5 domID='"+domId+"' selected = 'Y'>\r\n" );
						valueXmlString.append("<survey_code><![CDATA[").append(surveyCode).append("]]></survey_code>\r\n");
						valueXmlString.append("<survey_descr><![CDATA[").append(surveyDescr).append("]]></survey_descr>\r\n");
						valueXmlString.append("<meta_data><![CDATA[").append(surveyMetadata).append("]]></meta_data>\r\n");

						//valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
						valueXmlString.append("<context><![CDATA[").append(surveyContext).append("]]></context>\r\n");
						valueXmlString.append("<context_descr><![CDATA[").append(surveyCtxShDescr).append("]]></context_descr>\r\n");
						valueXmlString.append("<result_type><![CDATA[").append(resultType).append("]]></result_type>\r\n");
						valueXmlString.append("<result_format><![CDATA[").append(resultFormat).append("]]></result_format>\r\n");    //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						valueXmlString.append("<result><![CDATA[").append(result).append("]]></result>\r\n");
						//Added by Pooja S on 29-JULY-2020 [Survey Grouping realted implementation]
						valueXmlString.append("<survey_group_descr><![CDATA[").append(surveyGrpDescr).append("]]></survey_group_descr>\r\n");
						if("N".equalsIgnoreCase(resultType))
						{
							valueXmlString.append("<result1 visible = '1'><![CDATA[").append(result).append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '0'><![CDATA[").append(result).append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");    //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
							//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
							valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
						}
						//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form] START
						else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
						{
							valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '1' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");
							//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
							valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
						}
						//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]end
						else if("L".equalsIgnoreCase(resultType))
						{
							valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '1'><![CDATA[").append(result).append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '0'><![CDATA[").append(result).append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
							//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
							valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
						}
						else if("T".equalsIgnoreCase(resultType))
						{
							valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '1'><![CDATA[").append(result).append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
							//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
							valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
						}
						else if("D".equalsIgnoreCase(resultType))
						{
							valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '1'><![CDATA[").append("").append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
							//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
							valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
						}
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm Start
						else if("A".equalsIgnoreCase(resultType))
						{
							valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
							valueXmlString.append("<result5 visible = '1'><![CDATA[").append(result).append("]]></result5>\r\n");
						}
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm End
						else
						{
							valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
							valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
							valueXmlString.append("<result3 visible = '1'><![CDATA[").append(result).append("]]></result3>\r\n");
							valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");  //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
							//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
							valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
						}
						valueXmlString.append("<dcr_id><![CDATA[").append(dcrID).append("]]></dcr_id>\r\n");
						valueXmlString.append("<attach_opt><![CDATA[").append(showAttachment).append("]]></attach_opt>\r\n");
						valueXmlString.append("<survey_mandatory><![CDATA[").append(surveyMandatory).append("]]></survey_mandatory>\r\n");
						valueXmlString.append("<survey_templ><![CDATA[").append(surveyTempl).append("]]></survey_templ>\r\n");

						if("1".equalsIgnoreCase(showAttachment) || "2".equalsIgnoreCase(showAttachment))// added by mrunalini sinkar  for attachmen mandatory
						{
							documentId = (String)surveydocId.get(surveyCode.trim() );
							System.out.println("documentId["+documentId+"]");
							valueXmlString.append("<doc_id_2 visible = '1'><![CDATA[").append(checkNull(documentId)).append("]]></doc_id_2>\r\n");//Added by kailash 10-12-18.
						}
						else
						{
							documentId = (String)surveydocId.get(surveyCode.trim() );
							System.out.println("documentId["+documentId+"]");
							valueXmlString.append("<doc_id_2 visible = '0'><![CDATA[").append(checkNull(documentId)).append("]]></doc_id_2>\r\n");//Added by kailash 10-12-18.

						}

						valueXmlString.append( "</Detail"+formNo+">\r\n" );

						num++;
					}
					rsTemp.close();rsTemp = null;
					pstmtTemp.close();pstmtTemp = null;
				}
				else
				{
					System.out.println("domId before is:::::::::"+num);
					String result =defaultVal;
					if ( surveyMap != null && surveyMap.containsKey(surveyCode))
					{
						result = (String)surveyMap.get(surveyCode.trim());
						System.out.println(" SurveyList :: result :: =["+result+"]");
						//valueXmlString.append("<Detail8 domID='"+domId+"' selected = 'Y'>\r\n" );
						valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'Y' formName='"+formName+"'>\r\n" );
						//valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<attribute selected=\"Y\" updateFlag=\"E\" status=\"O\" pkNames=\"\"/>\r\n");
						valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");

						lineNoStr = (String)surveyLineNoMap.get(surveyCode.trim() );
						if(lineNoStr != null && lineNoStr.trim().length() > 0)
						{
							lineNo = Integer.parseInt( lineNoStr );
						}
						valueXmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>\r\n");
						valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					}
					else
					{
						lineNoNew++;
						//valueXmlString.append("<Detail8 domID='"+domId+"' selected = 'N'>\r\n" );
						valueXmlString.append("<Detail"+formNo+" domID='"+num+"' selected = 'N' formName='"+formName+"'>\r\n" );
						valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>\r\n");
						//valueXmlString.append("<selectbox><![CDATA[").append( "true" ).append("]]></selectbox>\n");
						valueXmlString.append("<line_no><![CDATA["+lineNoNew+"]]></line_no>\r\n");
						valueXmlString.append("<strg_code><![CDATA[").append("").append("]]></strg_code>\r\n");

						//Added by Pooja on 15/06/2020 [to set defaultvalue as result if defined] START
						defaultVal = checkNull(defaultVal);
						if( "L".equalsIgnoreCase(resultType) && defaultVal.length() == 0 )
						{
							result = "N";
						}
						//Added by Pooja on 15/06/2020 [to set defaultvalue as result if defined] END
					}
					//System.out.println(" SurveyList :: result_after :: =["+result+"]");
					valueXmlString.append("<survey_code><![CDATA[").append(surveyCode).append("]]></survey_code>\r\n");
					valueXmlString.append("<survey_descr><![CDATA[").append(surveyDescr).append("]]></survey_descr>\r\n");
					//valueXmlString.append("<strg_code><![CDATA[").append(strgCode).append("]]></strg_code>\r\n");
					valueXmlString.append("<context><![CDATA[").append(surveyCode).append("]]></context>\r\n");
					valueXmlString.append("<context_descr><![CDATA[").append("").append("]]></context_descr>\r\n");
					valueXmlString.append("<result_type><![CDATA[").append(resultType).append("]]></result_type>\r\n");
					valueXmlString.append("<result_format><![CDATA[").append(resultFormat).append("]]></result_format>\r\n");   //Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
					valueXmlString.append("<result><![CDATA[").append(result).append("]]></result>\r\n");
					valueXmlString.append("<meta_data><![CDATA[").append(surveyMetadata).append("]]></meta_data>\r\n");
					//Added by Pooja S on 29-JULY-2020 [Survey Grouping realted implementation]
					valueXmlString.append("<survey_group_descr><![CDATA[").append(surveyGrpDescr).append("]]></survey_group_descr>\r\n");
					if("N".equalsIgnoreCase(resultType))
					{
						valueXmlString.append("<result1 visible = '1'><![CDATA[").append(result).append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
						valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]START
					else if("L".equalsIgnoreCase(resultType) && "D".equalsIgnoreCase(resultFormat))
					{
						valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '1' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
						valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
					}
					//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]END
					else if("L".equalsIgnoreCase(resultType))
					{
						valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '1'><![CDATA[").append(result).append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
						valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
					}
					else if("T".equalsIgnoreCase(resultType))
					{
						valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '1'><![CDATA[").append(result).append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
						valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
					}
					else if("D".equalsIgnoreCase(resultType))
					{
						valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '1'><![CDATA[").append(result).append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
						valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
					}
					//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm Start
					else if("A".equalsIgnoreCase(resultType))
					{
						valueXmlString.append("<result1 visible = '0'><![CDATA[").append("").append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '0'><![CDATA[").append("").append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '0'><![CDATA[").append("").append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						valueXmlString.append("<result5 visible = '1'><![CDATA[").append(result).append("]]></result5>\r\n");
					}
					//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm End
					else
					{
						valueXmlString.append("<result1 visible = '0'><![CDATA[").append(result).append("]]></result1>\r\n");
						valueXmlString.append("<result2 visible = '0'><![CDATA[").append(result).append("]]></result2>\r\n");
						valueXmlString.append("<result3 visible = '1'><![CDATA[").append(result).append("]]></result3>\r\n");
						valueXmlString.append("<result4 visible = '0' ddlblist='"+surveyMetadata+"'><![CDATA[").append("").append("]]></result4>\r\n");	//Added by Sagar m.on 26-dec-2018[To dropdown with predefined value in SURVEY master and same to in SURVEY form]
						//Added by Pooja S on [10-FEB-2020] MI Activity related changes for suborm
						valueXmlString.append("<result5 visible = '0'><![CDATA[").append("").append("]]></result5>\r\n");
					}
					valueXmlString.append("<dcr_id><![CDATA[").append(dcrID).append("]]></dcr_id>\r\n");
					valueXmlString.append("<attach_opt><![CDATA[").append(showAttachment).append("]]></attach_opt>\r\n");
					valueXmlString.append("<survey_mandatory><![CDATA[").append(surveyMandatory).append("]]></survey_mandatory>\r\n");
					valueXmlString.append("<survey_templ><![CDATA[").append(surveyTempl).append("]]></survey_templ>\r\n");

					if("1".equalsIgnoreCase(showAttachment) || "2".equalsIgnoreCase(showAttachment))// added by mrunalini sinkar  for attachmen mandatory
					{
						documentId = (String)surveydocId.get(surveyCode.trim() );
						System.out.println("documentId16955["+documentId+"]");
						valueXmlString.append("<doc_id_2 visible = '1'><![CDATA[").append(checkNull(documentId)).append("]]></doc_id_2>\r\n");//Added by kailash 10-12-18.

					}
					else
					{
						documentId = (String)surveydocId.get(surveyCode.trim() );
						System.out.println("documentId16955["+documentId+"]");
						valueXmlString.append("<doc_id_2 visible = '0'><![CDATA[").append(checkNull(documentId)).append("]]></doc_id_2>\r\n");//Added by kailash 10-12-18.

					}
					//valueXmlString.append( "</Detail8>\r\n" );
					valueXmlString.append( "</Detail"+formNo+">\r\n" );

					num++;
					System.out.println("domId after is:::::::::"+num);
				}
			}
			if(rsSurvey != null)
			{
				rsSurvey.close(); rsSurvey = null;
			}
			if(pstmtSurvey != null)
			{
				pstmtSurvey.close(); pstmtSurvey = null;
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println( "Exception : StrgMeetOTCGwtWizardComp :getSurveyList(String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if(rsScName != null)
				{
					rsScName.close(); rsScName = null;
				}
				if(pstmtScName != null)
				{
					pstmtScName.close(); pstmtScName = null;
				}
				if( connectionObject != null && ! connectionObject.isClosed() )
				{
					connectionObject.close();
					connectionObject = null;
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :StrgMeetOTCGwtWizardComp :getSurveyList(String) :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}



	public String getDcrGroup(String strgType,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String dcrGroup="";
		try
		{
			String sql="SELECT DCR_GROUP FROM STRG_CUST_TYPE WHERE TYPE=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, strgType);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				dcrGroup = checkNull(rs.getString("DCR_GROUP"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return dcrGroup;
	}

	
	public String getCustTypeDesc(String strgType,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String custDescr ="";
		try
		{
			String sql="SELECT G.FLD_VALUE AS FLD_VALUE FROM GENCODES G,STRG_CUST_TYPE SCT WHERE SCT.TYPE = ? " +
					"AND SUBSTR(G.Fld_Value,INSTR(G.FLD_VALUE,'-')+1,LENGTH(G.FLD_VALUE))=Sct.Sh_Descr AND MOD_NAME='W_STRG_MEET_DCR_REALTIME_WIZ'";
			pstmt= conn.prepareStatement(sql);
			pstmt.setString(1,strgType);
			rs=pstmt.executeQuery();
			if(rs.next())
			{
				custDescr = checkNull(rs.getString("FLD_VALUE"));

			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		System.out.println("custDescr is["+custDescr+"]");
		return custDescr;
	}


	public String getItemSer(String salesPers,Connection conn)
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String itemSer="";
		try
		{
			String sql="SELECT ITEM_SER FROM SALES_PERS WHERE SALES_PERS=?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				itemSer = checkNull(rs.getString("ITEM_SER"));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			try
			{
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}

		}
		return itemSer;
	}

	public String[] getEventStartEndTime( Connection connectionObject, String userId, String eventDate ) throws ITMException
	{
		System.out.println("getEventStartEndTime......Called event_date=["+eventDate+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String  []eventTime = new String[2];
		E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		String hours="";
		String startTime="";
		String hour = "";
		String minute = "";
		String interval ="";
		String sql ="";
		String timeTo = "";
		String timeFrom = "";
		try
		{
			sql = "SELECT TRIM(PROP_VALUE) AS MEET_START_TIME FROM PROPERTIES WHERE PROP_NAME ='MEET_START_TIME'";
			System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
			pstmt = connectionObject.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				startTime = checkNull(rs.getString( "MEET_START_TIME" ));
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}

			if(startTime.length() > 0)
			{
				String format = "AM";
				timeFrom = startTime+" "+format;
				//eventTime[0] = timeFrom;
				//String timeTo = "";
				sql = "SELECT TRIM(PROP_VALUE) AS MEET_INTERVAL FROM PROPERTIES WHERE PROP_NAME ='MEET_INTERVAL'";
				System.out.println( " [StrgMeetWizEJB]sql [" + sql + "]" );
				pstmt = connectionObject.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					interval = checkNull(rs.getString( "MEET_INTERVAL" ));
				}
				if (rs!= null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt = null;
				}
				int position=startTime.indexOf(':');
				hour = startTime.substring(0,position).trim();
				minute = startTime.substring( position+1 , startTime.length() ).trim();
				int hr=Integer.parseInt(hour);
				int min=Integer.parseInt(minute);

				int minIntrvl=Integer.parseInt(interval);
				minIntrvl = min + minIntrvl;
				if(hr == 11 && minIntrvl >= 60)
				{
					if("AM".equals(format))
					{
						format = "PM";
					}
					else if("PM".equals(format))
					{
						format = "AM";
					}
				}
				int intr =0;
				if( interval.length()>0 )
				{
					intr = Integer.parseInt( interval );
					min = min+intr;
					if( min>59 )
					{
						while( min > 59 )
						{
							hr=hr+1;
							min=min-60;
							if(hr == 11 && min >= 60)
							{
								if("AM".equals(format))
								{
									format = "PM";
								}
								else if("PM".equals(format))
								{
									format = "AM";
								}
							}
						}
						if( min==0 )
						{
							if( hr < 10 )
							{
								hours = "0"+hr;
							}
							else
							{
								hours = String.valueOf( hr );
							}
							timeTo = hours+":00"+" "+format;
						}
						else
						{
							if( hr < 10 )
							{
								hours="0"+hr;
							}
							else
							{
								hours=String.valueOf( hr );
							}
							if(min<10)
							{
								timeTo = hours+":0"+min+" "+format;
							}
							else
							{
								timeTo = hours+":"+min+" "+format;
							}
						}
					}
					else
					{

						if( hr < 10 )
						{
							hours="0"+hr;
						}
						else
						{
							hours=String.valueOf( hr );
						}
						timeTo = hours+":"+min+" "+format;
					}
					//eventTime[1] = timeTo;
				}
			}
			eventTime[0] = timeFrom;
			eventTime[1] = timeTo;
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :getEventStartEndTime :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return eventTime ;
	}
	//Added by kailash on 07-02-19 [end]
	// added by rupali on 03/05/18 for single screen mgr reporting [start]
	public String getMGREmployee(String empCode,Connection con) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeMGR = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT A.EMP_CODE AS EMP_CODE FROM EMPLOYEE A, GRADE B " + "WHERE A.EMP_CODE = ? " + "AND A.GRADE = B.GRADE_CODE " + "AND B.GRADE_TYPE = 'M' ";

			pstmt = con.prepareStatement(selectSql);
			pstmt.setString(1, empCode);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				empCodeMGR = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		} catch (Exception e)
		{
			throw new ITMException(e);
		} finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			}
			catch (Exception e1){}

		}
		return empCodeMGR;
	}
	// added by rupali on 03/05/18 for single screen mgr reporting [end]




	public String getEmpNameDesign(String empCode,Connection conn) throws ITMException
	{
		String name=null;
		String employeCode = null;
		String designCode = null;
		try
		{
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			String dbName =CommonConstants.DB_NAME; 
			String nameSql="";
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				nameSql = "SELECT UPPER(EMP_FNAME) ||' ' ||UPPER(EMP_MNAME) ||' '|| UPPER(EMP_LNAME) AS EMP_NAME,EMP_CODE, DESIGN_CODE from employee 	WHERE EMP_CODE= ? ";

			}
			else
			{
				nameSql = "SELECT CONCAT(IFNULL(EMP_FNAME,''),' ',IFNULL(EMP_MNAME,''),' ',IFNULL(EMP_LNAME,''))AS EMP_NAME, EMP_CODE,DESIGN_CODE from employee  WHERE EMP_CODE= ? ";

			}
			pstmt = conn.prepareStatement(nameSql);

			pstmt.setString(1,empCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				name = checkNull(rs.getString("EMP_NAME"));
				employeCode = checkNull(rs.getString("EMP_CODE"));
				designCode = checkNull(rs.getString("DESIGN_CODE"));
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return name +"("+designCode+")";
	}


	public ArrayList getTemplateSurvey(Connection conn, String userId) throws ITMException  //added by rupali on 06/03/17
	{
		PreparedStatement pstmtCustType = null;
		ResultSet rsCustType = null;
		HashMap callNoteTypeMap = new HashMap();
		String noteType = "";
		String descr = "";
		String shDescr = "";
		ArrayList custTypeList = new ArrayList();

		try
		{
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field
			String custTypeSql ="";
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				custTypeSql = "SELECT DISTINCT(TYPE) AS TYPE FROM STRG_CUST_TYPE WHERE ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE = ?) " +
						"IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL) AND SURVEY_TEMPL IS NOT NULL ";
				pstmtCustType = conn.prepareStatement(custTypeSql);
				pstmtCustType.setString(1, userId);
				rsCustType = pstmtCustType.executeQuery();
				while(rsCustType.next())
				{
					custTypeList.add(checkNull(rsCustType.getString("TYPE")));
				}
				if(rsCustType != null)
				{
					rsCustType.close();
					rsCustType = null;
				}
				if(pstmtCustType != null)
				{
					pstmtCustType.close();
					pstmtCustType = null;
				}
				
			}
			else
			{
				custTypeSql = "SELECT DISTINCT(TYPE) AS TYPE FROM STRG_CUST_TYPE";
				pstmtCustType = conn.prepareStatement(custTypeSql);
				rsCustType = pstmtCustType.executeQuery();
				while(rsCustType.next())
				{
					custTypeList.add(checkNull(rsCustType.getString("TYPE")));
				}
				if(rsCustType != null)
				{
					rsCustType.close();
					rsCustType = null;
				}
				if(pstmtCustType != null)
				{
					pstmtCustType.close();
					pstmtCustType = null;
				}
			}

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rsCustType != null)
				{
					rsCustType.close();
					rsCustType = null;
				}
				if(pstmtCustType !=null)
				{
					pstmtCustType.close();
					pstmtCustType = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}
		return custTypeList;
	}

	public String getTemplateIdForUnlisted(String salesPers,String type,Connection connectionObject)
	{
		String template="";

		try
		{
			String sfaParmVal  = checkNull(getSfaParmValue(salesPers,"CHC_SURVEY",connectionObject));

			System.out.println("sfaParmVal =["+sfaParmVal+"]");
			String dbName =CommonConstants.DB_NAME; //added by rupali on 15/09/17 for worked with field
			String custTypeSql ="";
			if(dbName.equalsIgnoreCase("ORACLE"))
			{
				custTypeSql = "SELECT DISTINCT(CASE WHEN SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SURVEY_TEMPL END) AS SURVEY_TEMPL FROM STRG_CUST_TYPE WHERE ENTERPRISE IS NULL OR (SELECT ENTERPRISE FROM USERS WHERE CODE = ?) " +
						"IN (SELECT REGEXP_SUBSTR(ENTERPRISE,'[^,]+', 1, LEVEL) FROM DUAL CONNECT BY REGEXP_SUBSTR(ENTERPRISE, '[^,]+', 1, LEVEL) IS NOT NULL) AND SURVEY_TEMPL IS NOT NULL AND TYPE=? ";

			}
			else
			{
				custTypeSql = "SELECT DISTINCT(CASE WHEN SURVEY_TEMPL IS NULL THEN '"+sfaParmVal+"' ELSE SURVEY_TEMPL END) AS SURVEY_TEMPL FROM STRG_CUST_TYPE";
				
			}
			PreparedStatement pstmtSel = connectionObject.prepareStatement(custTypeSql);
			pstmtSel.setString(1, salesPers);
			pstmtSel.setString(2, type);

			ResultSet rsCustType = pstmtSel.executeQuery();
			if(rsCustType.next())
			{
				template= checkNull(rsCustType.getString("SURVEY_TEMPL"));
			}
			if(rsCustType != null)
			{
				rsCustType.close();
				rsCustType = null;
			}
			if(pstmtSel != null)
			{
				pstmtSel.close();
				pstmtSel = null;
			}
			if(template==null || template.trim().length()==0)
			{
				template = "'"+checkNull(getSfaParmValue(salesPers,"CHC_SURVEY",connectionObject))+"'";
			}
			System.out.println("surveyTemplate is:["+template+"]");
		}
		catch(Exception e)
		{
			e.printStackTrace();

		}
		return template;
	}
	public String getHOEmployee( String empCode, Connection conn ) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String empCodeHO = "";
		String selectSql = "";
		try
		{
			selectSql = "SELECT EMP_CODE FROM USERS A, USER_RIGHTS B " +
					"WHERE A.EMP_CODE = ? " +
					"AND A.PROFILE_ID = B.PROFILE_ID " +
					"AND B.APPLICATION = 'MRO' " +
					"AND B.MENU_ROW = 1 " +
					"AND B.MENU_COL = 1 " +
					"AND B.MENU_SUBCOL = 1 " +
					"AND B.LEVEL_4 = 1 " +
					"AND B.LEVEL_5 = 1 " +
					"AND B.MENU_NAME = 'MR Online Application' ";

			pstmt = conn.prepareStatement(selectSql);
			pstmt.setString( 1, empCode );
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				empCodeHO = checkNull(rs.getString("EMP_CODE"));
			}
			rs.close();
		}
		catch ( Exception e )
		{
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e1){}
		}
		return empCodeHO;
	}

	public String fetchPropertyValue( String propName, String itemSer, Connection connectionObject)
	{
		String sql = "";
		String propVal = "";
		PreparedStatement pstmt = null;
		ResultSet rSet = null ;
		Boolean itemSerFound = false;

		try
		{
			if (itemSer == null || itemSer.trim().length() == 0)
			{
				itemSer = "ALL";
			}
			sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? AND ITEM_SER = ?";
			pstmt =  connectionObject.prepareStatement( sql );
			pstmt.setString(1, checkNull(propName));
			pstmt.setString(2, itemSer);
			rSet = pstmt.executeQuery();
			if(rSet.next())
			{
				propVal = checkNull(rSet.getString("PROP_VALUE"));
				itemSerFound = true;
			}

			if (rSet != null)
			{
				rSet.close();
				rSet = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if (!itemSerFound)
			{
				sql = "SELECT PROP_VALUE FROM PROPERTIES WHERE PROP_NAME = ? AND ITEM_SER = 'ALL'";
				pstmt =  connectionObject.prepareStatement( sql );
				pstmt.setString(1, checkNull(propName));
				rSet = pstmt.executeQuery();
				if(rSet.next())
				{
					propVal = checkNull(rSet.getString("PROP_VALUE"));
				}

				if (rSet != null)
				{
					rSet.close();
					rSet = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
		}

		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rSet !=null )
				{
					rSet.close();
					rSet = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt= null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return propVal;

	}
	public java.util.Date getNextDate( java.util.Date currEventDate ) throws ITMException
	{
		java.util.Date uDate1 = null;
		java.util.Date nextEventDate = null;
		try
		{
			Calendar calObject = Calendar.getInstance();
			calObject.setTime( currEventDate );
			calObject.add( calObject.DATE, 1 );
			uDate1 = calObject.getTime();
			nextEventDate = new java.util.Date( uDate1.getTime() );
			calObject = null;
		}
		catch( Exception e )
		{
			throw new ITMException(e);
		}
		return nextEventDate;
	}


	public String getSelectedYesRowValue(Document dom,String formNo, String colName, int rowNo) throws ITMException
	{
		NodeList detailList = null;
		NodeList childList = null;
		Node parentNode = null;
		Node childNode = null;
		Element elementAttr = null;
		String childNodeName = "";
		String columnValue = "";
		int	detailListLength = 0;
		int noOfChilds = 0;
		try
		{
			E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

			detailList = dom.getElementsByTagName("Detail"+formNo);
			//System.out.println("detailList....."+detailList);
			detailListLength = detailList.getLength();
			if(detailListLength > 0)
			{
				parentNode = detailList.item(rowNo);
				//System.out.println("parentNode....."+parentNode);
				elementAttr = (Element)parentNode;
				childList = parentNode.getChildNodes();
				//System.out.println("childList....."+childList);
				noOfChilds = childList.getLength();
				if ( parentNode != null )
				{
					String selectedFlag = "";
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{
						childNode = childList.item(ctr);
						childNodeName = childNode.getNodeName();

						if(childNode.getNodeName().equalsIgnoreCase("attribute"))
						{
							if(childNode.getAttributes().getNamedItem("selected") != null)
							{

								selectedFlag = childNode.getAttributes().getNamedItem("selected").getNodeValue();
							}
						}
						else if(!childNode.getNodeName().equalsIgnoreCase("attribute") && childNode.getNodeName().equalsIgnoreCase("ORIG_ATTRIBUTE_NODE"))
						{
							String nodeValue = childNode.getFirstChild().getNodeValue();
							if(nodeValue.contains(" selected=\"Y\""))
							{
								selectedFlag="Y";
							}
						}
						if(childNodeName.equals(colName) && "Y".equalsIgnoreCase(selectedFlag))
						{
							if(childNode.getFirstChild()!=null )
							{
								columnValue = childNode.getFirstChild().getNodeValue();
								break;
							}

						}
					}
				}
			}


			

			if(columnValue == null)
				columnValue = "";

		}
		catch( Exception exp )
		{
			exp.printStackTrace();
			throw new ITMException(exp);
		}

		return columnValue;
	}
	public String getMaxDisplayDCRDate(String salesPers,String eventDate,Connection connectionObject)
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String lastDCRDate = "";

		try
		{
			sql = "SELECT MAX(EVENT_DATE) LAST_DCR_DATE FROM STRG_MEET WHERE EVENT_DATE <> ? AND SALES_PERS = ? "+
					"AND EVENT_TYPE IN (SELECT ACTIVITY_CODE FROM FIELDACTIVITY WHERE ACTIVITY_TYPE !='PR')";
			pstmt =  connectionObject.prepareStatement(sql);
			pstmt.setTimestamp(1, java.sql.Timestamp.valueOf( genericUtility.getValidDateTimeString( eventDate, genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat() ) ) );
			pstmt.setString(2, salesPers);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				lastDCRDate = checkNull(rs.getString("LAST_DCR_DATE"));
				System.out.println("lastDisplayDCRDate =["+lastDCRDate+"]");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();

		}
		return lastDCRDate;
	}
	public String getSubmissionDisplayDate(Connection connectionObject)
	{
		System.out.println("Inside getSubmissionDisplayDate");

		String subDispDate="";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			String Sql="SELECT  TO_CHAR(SYSDATE, 'DD-MM-YYYY HH12:MI A.M.') AS SUBMISSION_DATE FROM DUAL";
			pstmt =  connectionObject.prepareStatement(Sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				subDispDate = checkNull(rs.getString("SUBMISSION_DATE"));
				System.out.println("subDispDate is =["+subDispDate+"]");
			}
			if (rs!= null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();

		}
		return subDispDate;
	}


	public boolean validateEndTime( String startTimeStr, String endTimeStr )
	{
		int startTime =0;
		int lastTime =0;
		boolean retFlag = true;
		try
		{
			startTime =  convertToMinute(startTimeStr.substring(0,5));
			lastTime = convertToMinute(endTimeStr.substring(0,5));
			System.out.println("startTime["+startTime+"]lastTime["+lastTime+"");
			if (startTime > 0 && lastTime > 0)
			{
				if (startTimeStr.substring(6,8).equals("PM"))
				{
					if (startTime < 720)
					{
						startTime = startTime + 720;
					}
				}

				if (endTimeStr.substring(6,8).equals("PM"))
				{
					if (lastTime < 720)
					{
						lastTime = lastTime + 720;
					}
				}
				if (startTime > lastTime )
				{
					retFlag = false;
				}

			}


		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
		}
		return retFlag;
	}
	public int convertToMinute(String timeStr)
	{
		String p1 = "";
		String p2 = "";
		String p3 = "";
		int convertedMin = -1;

		try
		{
			if (timeStr != null && timeStr.trim().length() == 5)
			{
				timeStr = timeStr.trim();
				p1 = timeStr.substring(0 , 2); // 2digit hours
				p2 = timeStr.substring(2 , 3); // :
				p3 = timeStr.substring(3 , 5); // 2digit min
				int ip1 = Integer.parseInt(p1);
				int ip3 = Integer.parseInt(p3);
				convertedMin = (ip1*60) + ip3;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			//throw new ITMException(e);
		}
		finally
		{
		}
		return convertedMin;
	}




	private ArrayList getDomIdListFromDom2( Document dom, String attribute , int currFormNo) throws ITMException
	{
		String domID = "";
		ArrayList allSelectedDomIdList = new ArrayList();
		try
		{
			NodeList detailList = null;
			Node currDetail = null,reqDetail = null;
			int	detailListLength = 0;

			detailList = dom.getElementsByTagName("Detail" + currFormNo);
			detailListLength = detailList.getLength();
			for (int ctr = 0;ctr < detailListLength;ctr++)
			{
				int intDomID=0;
				currDetail = detailList.item(ctr);
				domID = checkNull(currDetail.getAttributes().getNamedItem("domID").getNodeValue());
				//System.out.println("domID======== := "+domID);
				String intDomID2=domID.split(":")[0];
				//System.out.println("intDomID2======== := "+intDomID2);

				intDomID = Integer.parseInt(intDomID2);
				//System.out.println("intDomID value is := "+intDomID);
				allSelectedDomIdList.add(intDomID);

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		System.out.println("allSelected Donm id on previous DAR:- "+allSelectedDomIdList);
		return allSelectedDomIdList;
	}

	public  String getFormatedId(ArrayList<String> activityCode)
	{
		String salesPerson = "";

		if(activityCode != null && activityCode.size() != 0)
		{
			for(int i=0;i<activityCode.size();i++)
			{
				salesPerson= salesPerson+ "'".concat(activityCode.get(i).concat("',"));					

			}
			salesPerson = E12GenericUtility.checkNull(salesPerson.substring(0,salesPerson.length()-1));
		}
		else
		{
			salesPerson ="'X'";
		}
		return salesPerson;
	}
	
	public ArrayList<String> getHolidayList(String fromDate,String toDate,String holTblNo,String userId,Connection conn)//userId added by mrunalini sinkar for change_holiday(start)
	{
		ArrayList<String> holiList = new ArrayList<String>();
		PreparedStatement pstmt=null;
		ResultSet rs=null;
		PreparedStatement changePstmt=null;
		ResultSet changeRs=null;
		try
		{
			DateFormat applFormat = new SimpleDateFormat(getApplDateFormat());
			SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());//Added By mrunalini sinkar

			String holSql="SELECT HOL_DATE FROM HOLIDAY WHERE HOL_TBLNO = ? AND HOL_DATE BETWEEN ? AND ? ";
			pstmt =  conn.prepareStatement(holSql);
			pstmt.setString(1, checkNull(holTblNo));
			pstmt.setTimestamp(2, java.sql.Timestamp.valueOf(fromDate));
			pstmt.setTimestamp(3, java.sql.Timestamp.valueOf(toDate));
			rs=pstmt.executeQuery();
			while(rs.next())
			{
				String holDateTo="";
				String holidayDate="";
				//Date holDate=rs.getDate("HOL_DATE");
				String holDate=checkNull(rs.getString("HOL_DATE"));
				if(holDate != null && holDate.trim().length()>0)
				{


					String chnageSql="SELECT B.HOL_DATE_TO FROM CHANGE_HOLIDAY B, HOLIDAY H " +
							"WHERE  H.HOL_TBLNO = B.HOL_TBLNO AND B.HOL_DATE_FOR= H.HOL_DATE " +
							"AND B.HOL_TBLNO=? AND B.EMP_CODE=? AND H.HOL_DATE=? ";
					changePstmt = conn.prepareStatement(chnageSql);
					changePstmt.setString(1, holTblNo);
					changePstmt.setString(2, userId);
					changePstmt.setTimestamp(3, java.sql.Timestamp.valueOf(holDate));
					changeRs = changePstmt.executeQuery();
					if(changeRs.next())
					{
						holDateTo = checkNull(changeRs.getString("HOL_DATE_TO"));
					}
					//Added by Mrunalini Sinkar for change_holiday changes in DAR & Monthly Plan(17/12/2019 : start)
					if (changeRs != null)
					{
						changeRs.close();
						changeRs = null;
					}
					if(changePstmt !=null)
					{
						changePstmt.close();
						changePstmt = null;
					}
					if(holDateTo!=null && holDateTo.trim().length()>0)
					{
						holidayDate=checkNull(genericUtility.getValidDateString( holDateTo, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() ));
					}
					else
					{
						holidayDate=checkNull(genericUtility.getValidDateString( holDate, genericUtility.getDBDateFormat(),genericUtility.getApplDateFormat() ));
					}
					holiList.add(holidayDate);

				}
				//Added by Mrunalini Sinkar for change_holiday changes in DAR & Monthly Plan(17/12/2019 : end)
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(Exception e)
		{
			System.out.println("exception holiday Date is["+e+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if (changeRs != null)
				{
					changeRs.close();
					changeRs = null;
				}
				if(changePstmt !=null)
				{
					changePstmt.close();
					changePstmt = null;
				}
			}
			catch (Exception e1){}
		}
		System.out.println("holiList is:["+holiList+"]");
		return holiList;
	}


}