/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb.sys;

import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.UserEnterpriseEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import org.w3c.dom.Document;

public class SchemaGenProcess
extends ProcessEJB {
    protected static String database = CommonConstants.DB_NAME;
    @Resource
    private SessionContext cSessionContext;

    public String process() throws RemoteException, ITMException {
        return "";
    }

    public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException, ITMException {
        Document dom = null;
        Document dom2 = null;
        String errString = "";
        GenericUtility genericUtility = GenericUtility.getInstance();
        try {
            if (xmlString != null && xmlString.trim().length() != 0) {
                dom = genericUtility.parseString(xmlString);
                System.out.println("dom SchemaGenProcess [" + xmlString + "]");
            }
            if (xmlString2 != null && xmlString2.trim().length() != 0) {
                dom2 = genericUtility.parseString(xmlString2);
                System.out.println("dom2 SchemaGenProcess [" + xmlString2 + "]");
            }
            errString = this.process(dom, dom2, windowName, xtraParams);
        }
        catch (Exception e) {
            errString = genericUtility.createErrorString(e);
        }
        return errString;
    }

    public String process(Document dom, Document dom2, String windowName, String xtraParams) throws RemoteException, ITMException {
        String returnString = "";
        String loginCode = "";
        Connection conn = null;
        Statement pStmt = null;
        Statement pstmt = null;
        ResultSet rs = null;
        boolean isError = false;
        Statement pstmtSprsPlace = null;
        GenericUtility genericUtility = GenericUtility.getInstance();
        try {
            String dbDumpName = "";
            ConnDriver connDriver = new ConnDriver();
            conn = this.getConnection();
            ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
            loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
            String chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
            String schemaType = genericUtility.getColumnValue("schema_type", dom2);
            String schemaNo = genericUtility.getColumnValue("schema_no", dom2);
            System.out.println("schemaType::::::" + schemaType);
            System.out.println("schemaNo::::::" + schemaNo);
            System.out.println("loginCode::::::" + loginCode);
            String userId = loginCode;
            if (schemaNo == null || schemaNo.trim().length() == 0) {
                String string = returnString = itmDBAccessEJB.getErrorString("", "NOOFSCHEMA", "", "", conn);
                return string;
            }
            try {
                String udfStr1 = "";
                String sql = "SELECT UDF_STR1, UDF_STR2 FROM GENCODES WHERE FLD_NAME = ? AND MOD_NAME = ? ";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, "APP_NAME");
                pstmt.setString(2, "W_REGISTRATION");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    udfStr1 = rs.getString("UDF_STR1");
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                dbDumpName = udfStr1;
                UserEnterpriseEJB userEnterpriseEJB = new UserEnterpriseEJB();
                int noOfSchema = 0;
                if (schemaNo != null && schemaNo.length() != 0) {
                    noOfSchema = Integer.parseInt(schemaNo);
                }
                String enterprise = "";
                System.out.println("dbDumpName::::::" + dbDumpName);
                System.out.println("enterprise::::::" + enterprise);
                System.out.println("noOfSchema::::::" + noOfSchema);
                int i = 0;
                while (i < noOfSchema) {
                    enterprise = SchemaGenProcess.generateEnterprise(userId, chgTerm, conn);
                    String returnValue = this.schemaCreation(enterprise, dbDumpName, conn);
                    System.out.println("returnValue::::::" + returnValue);
                    ++i;
                }
                returnString = itmDBAccessEJB.getErrorString("", "VPITPROC9", "", "", conn);
            }
            catch (Exception e) {
                isError = true;
                System.out.println("Error ");
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (pStmt != null) {
                    pStmt.close();
                    pStmt = null;
                }
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
                if (conn != null) {
                    if (pstmtSprsPlace != null) {
                        pstmtSprsPlace.close();
                        pstmtSprsPlace = null;
                    }
                    if (!isError) {
                        conn.commit();
                    } else {
                        conn.rollback();
                    }
                    conn.close();
                    conn = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        return returnString;
    }

    private String checkNull(String input) {
        if (input == null) {
            input = "";
        }
        return input;
    }

    public String schemaCreation(String enterprise, String dbDumpName, Connection conn) throws RemoteException, ITMException {
        String transDB = enterprise;
        String dbDumpNameNew = dbDumpName;
        try {
            String sql = "{call SYSTEM.SCHEMA_IMPORT (?,?)}";
            CallableStatement cstmt = conn.prepareCall(sql);
            cstmt.setString(1, transDB);
            cstmt.setString(2, dbDumpNameNew);
            boolean NUM = cstmt.execute();
            BaseLogger.log((String)"2", null, null, (Object)("RGP::SYSTEM.SCHEMA_IMPORT Procedure execute succesfully " + NUM));
            cstmt.close();
        }
        catch (Exception e) {
            System.out.println("Error ");
            e.printStackTrace();
            throw new ITMException(e);
        }
        return "";
    }

    private static String generateEnterprise(String userId, String chgTerm, Connection conn) throws Exception {
        Statement pstmt = null;
        ResultSet rs = null;
        BaseLogger.log((String)"3", null, null, (Object)"UserRegistration::In function generateEnterprise");
        String enterprise = "";
        int entpCnt = 0;
        try {
            try {
                BaseLogger.log((String)"3", null, null, (Object)("userId ::: " + userId));
                java.sql.Date currentDate = new java.sql.Date(new Date().getTime());
                System.out.println("currentDate :" + currentDate);
                UserEnterpriseEJB userEnterpriseEJB = new UserEnterpriseEJB();
                enterprise = userEnterpriseEJB.generateEnterpriseCode(userId, "E");
                BaseLogger.log((String)"3", null, null, (Object)("enterprise ::: " + enterprise));
                String enterpriseQuery = "select count(*) from ENTERPRISE where ENTERPRISE = ?";
                pstmt = conn.prepareStatement(enterpriseQuery);
                pstmt.setString(1, enterprise);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    entpCnt = rs.getInt(1);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                BaseLogger.log((String)"3", null, null, (Object)("entpCnt: " + entpCnt));
                if (entpCnt <= 0) {
                    String empCode = userId;
                    BaseLogger.log((String)"3", null, null, (Object)"Inserting into Enterprise");
                    enterpriseQuery = "Insert into ENTERPRISE (ENTERPRISE,ENTERPRISE_DESCR,ADD_DATE,ADD_USER,ADD_TERM,CHG_DATE,CHG_USER,CHG_TERM,ENT_TYPE,SMTP_FALLBACK,ACT_STATUS) values (?,?,?,?,?,?,?,?,?,?,?)";
                    pstmt = conn.prepareStatement(enterpriseQuery);
                    pstmt.setString(1, enterprise);
                    pstmt.setString(2, enterprise);
                    pstmt.setDate(3, currentDate);
                    pstmt.setString(4, empCode);
                    pstmt.setString(5, chgTerm);
                    pstmt.setDate(6, currentDate);
                    pstmt.setString(7, empCode);
                    pstmt.setString(8, chgTerm);
                    pstmt.setString(9, "0");
                    pstmt.setString(10, "Y");
                    pstmt.setString(11, "I");
                    pstmt.executeQuery();
                    if (pstmt != null) {
                        pstmt.close();
                        pstmt = null;
                    }
                }
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        finally {
            if (pstmt != null) {
                pstmt.close();
                pstmt = null;
            }
        }
        return enterprise;
    }
}

