
/********************************************************
	Title : HolidayEJB
	Date  : 19/09/2008
	Author: Rajesh Patidar

 ********************************************************/
package ibase.webitm.ejb.wsfa.masters;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
//@javax.ejb.Stateless		commented by Sagar M [22 Nov 2018].

public class WsfaHoliday extends ValidatorEJB implements WsfaHolidayRemote,WsfaHolidayLocal//implements SessionBean
{/*
	public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println("Calling ejbCreate().........");
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate()
	{
	}
	public void ejbPassivate()
	{
	}*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	private String checkNull( String input )
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}


	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		String errString = null;
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : HolidayEJB : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0;
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		Connection connectionObject = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "" ;
		String userId = "";
		int currentFormNo=0;
		int childNodeListLength;
		//ConnDriver connDriver = new ConnDriver();
		String descr="";
		try
		{
			/*connectionObject = connDriver.getConnectDB("DriverITM");
			connDriver = null;*/
			connectionObject = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println("******[HolidayEJB][wfValData][formNo]["+currentFormNo+"]");
			switch(currentFormNo)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName.equalsIgnoreCase("hol_tblno"))
					{
						descr = getColumnValue("hol_tblno",dom);
						if(descr == null || descr.trim().length() == 0)
						{
							errCode = "WDHoliday";
							errString = getErrorString("hol_tblno",errCode,userId);
							break;
						}
					}//End Of hol_tblno
					else if (childNodeName.equalsIgnoreCase("descr"))
					{
						descr = getColumnValue("descr",dom);
						if(descr == null || descr.trim().length() == 0)
						{
							errCode = "WDCDESC";
							errString = getErrorString("descr",errCode,userId);
							break;
						}
					}//End Of descr
					else if (childNodeName.equalsIgnoreCase("hol_date") && editFlag != null && editFlag.equalsIgnoreCase("A"))
					{
						String hDate = getColumnValue("hol_date",dom);
						if(hDate == null || hDate.trim().length() == 0)
						{
							errCode = "WLHOLYDATE";
							errString = getErrorString("hol_date",errCode,userId);
							break;
						}
						else
						{
							String hTabNo = getColumnValue("hol_tblno",dom);
							String chaHDfor = genericUtility.getValidDateTimeString(hDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
							sql = " SELECT HOL_TBLNO FROM HOLIDAY WHERE HOL_TBLNO=? AND HOL_DATE=?" ;
							pstmt = connectionObject.prepareStatement(sql);
							pstmt.setString( 1,hTabNo );
							pstmt.setTimestamp( 2,java.sql.Timestamp.valueOf( chaHDfor ) );
							System.out.println("sql ["+sql+" ]");
							rs = pstmt.executeQuery();
							if( rs.next() )
							{
								errString = getErrorString("hol_date","HODATEEXIT",userId);
								break;
							}
						}
					}//End Of hDate
				}//end for
			} //END switch
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(connectionObject!=null)
				{
					if(pstmt != null )pstmt.close();
					if(rs != null )rs.close();
					rs = null;
					pstmt =null;
					connectionObject.close();
				}
				connectionObject = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
			System.out.println("[HolidayEJB] Connection is Closed");
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}//END OF VALIDATION


	// method for item change
	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			dom2 = parseString(xmlString2);
			valueXmlString = itemChanged(dom, dom1,dom2, objContext, currentColumn, editFlag, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [JvVal][itemChanged( String, String )] :==>\n" + e.getMessage());
		}
		return valueXmlString;
	}

	// method for item change
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		String holTblNo = "";
		String holDate = "";
		String days = "";
		String sql = "";

		int currentFormNo = 0;

		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null ;
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		//ConnDriver connDriver = new ConnDriver();
		System.out.println("****************** ItemChange Called ***********" );
		try
		{
			/*conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			conn.setAutoCommit(false);
			//connDriver = null;
			System.out.println("******************Inside ItemChange***********" );
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?> <Root> <header> <editFlag>");
			valueXmlString.append(editFlag).append("</editFlag> </header>");
			switch(currentFormNo)
			{
			case 1 :
				valueXmlString.append("<Detail1>");

				if(currentColumn.trim().equalsIgnoreCase("hol_date"))
				{
					holTblNo = genericUtility.getColumnValue("hol_tblno", dom);
					holDate = genericUtility.getColumnValue("hol_date", dom);
					System.out.println("holDate=["+holDate+"]");
					System.out.println("holTblNo=["+holTblNo+"]");

					sql = "select DAY_NAME(hol_date) AS days from HOLIDAY where HOL_DATE= ? ";

					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,holDate);
					//pstmt.setString(2,holTblNo);

					rs = pstmt.executeQuery();
					if(rs.next())
					{
						days =  checkNull(rs.getString("days"));
						System.out.println("days=["+days+"]");

					}
					valueXmlString.append("<days>").append("<![CDATA[" +  days + "]]>").append("</days>");

				}
				valueXmlString.append("</Detail1>");
				break;

			}
			valueXmlString.append("</Root>");
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					if(pstmt != null)
						pstmt.close();
					if(rs != null)
						rs.close();
					rs = null;
					pstmt = null;
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
		}
		return valueXmlString.toString();
	}































}// END OF MAIN CLASS


// select HOL_TBLNO, DAY_NAME(hol_date) AS days from HOLIDAY where HOL_DATE='04 JUL 2012' and  HOL_TBLNO ='?' ;