/*
  Name : WsfaEmpUsrSp
  Purpose : Franco requires a common screen for user, sales person and employee master in WSFA.
            Migration of Employee Master from EJB2 to EJB3 .
  Developed By : Shahu Mali
  Date : 22-MAR-13
 */

package ibase.webitm.ejb.wsfa.masters;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.StringTokenizer;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

//@Stateless			commented by Sagar M [22 Nov 2018].
public class WsfaEmpUsrSp extends ValidatorEJB implements WsfaEmpUsrSpLocal,WsfaEmpUsrSpRemote
{

	public String wfValData()throws RemoteException, ITMException
	{
		return "";
	}
	public String itemChanged()throws RemoteException, ITMException
	{
		return "";
	}
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("***********************Validation Start WsfaEmpUsrSp**************************");
		try
		{
			System.out.println("xmlString:::"+xmlString);
			dom = parseString(xmlString);
			dom1 = parseString(xmlString1);
			if (xmlString2.trim().length() > 0 )
			{
				dom2 = parseString("<Root>" + xmlString2+ "</Root>");
			}
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : EmpComplete : wfValData(String xmlString) : ==>\n"+e.getMessage());
		}
		return (errString);
	}
	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,currentFormNo =0,childNodeListLength =0,cnt =0;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

		String childNodeName = null,childNodeValue = null;
		String errString = "";
		String errCode = "";
		Connection conn = null;
		//Statement stmt = null;//Commented By Shahu Mali on 04-10-13
		PreparedStatement pstmt = null,pstmt1 = null;
		ResultSet rs = null,rs1 = null;
		String sql = "";
		String userId = "";
		String loginSite = "",cctrCodeSal ="",env ="";
		// added empMname by Satya on 30/04/2010 [WS89FRA008].START
		String contactCode="",empMname="",empFname = "",empCodeLink ="",cadre_code = "",empLname = "";
		// added empMname by Satya on 30/04/2010 [WS89FRA008].END
		String relieveDateStr ="",deptCode ="",cadreCode ="",gradeCode ="";
		String designCode ="",empSite ="",workSite ="",bankCode ="", stanCode ="";
		String empCode ="",paySite ="",ddPayableBank ="",payMode="",projCode= "";
		String accCodeSal = "",reportTo ="", nationality = "", contactState = "",curState = "",perState="";
		String siteCodePayment ="",stanCodeHq ="",bankAcct = "",reportToAdmin ="";
		String patternCode ="",workShift ="",gratuityDateStr ="",dateJoinStr ="",status ="";
		// added by Satya on 30/04/2010 [WS89FRA008].START
		String birthDateStr = "";
		String delayPeriod="", profileId="", salesPerson="", active="", autoConfirm="";
		// added  by Satya on 30/04/2010 [WS89FRA008].END

		java.util.Date dateJoin = null, gratuityDate = null;

		// added by Satya on 03/05/2010 [WS89FRA008].START
		java.util.Date birthDate=null,joinDate=null;
		String wrongLoginCnt="";
		// added by Satya on 03/05/2010 [WS89FRA008].END
		java.util.Date today = null;
		java.util.Date startDate =null;
		String createUser = "";
		String createsalespers = "";
		String  lastPasswordChgDateStr="";
		String custCode=null;
		String itemType=null,sampleDate=null,designDate=null;
		String passFeqS = null,name = null;
		String lsValidUpto = null, lsAccessType = null;
		String code = null;
		int passFeq=0;
		String columnValue = null;

		try
		{
			/*ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			//stmt = conn.createStatement();//Commented By Shahu Mali on 04-10-13
			ArrayList<String> errList = new ArrayList<String>();
			ArrayList<String> errFields = new ArrayList<String>();
			userId = getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			System.out.println(" ***********Validation for  EmpComplete Detail  "+currentFormNo);
			switch(currentFormNo)
			{
			case 1 :
				System.out.println("Validation for Detail 1 EmpComplete..........");
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++)
				{

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNode.getFirstChild()!= null)
					{
						childNodeValue = childNode.getFirstChild().getNodeValue();
					}
					if(childNodeName.equalsIgnoreCase("emp_code"))
					{
						empCode = genericUtility.getColumnValue("emp_code", dom);
						System.out.println("Employee Code ["+empCode+"]");
						cnt =  isValueExist("EMP_USER_SPRS","emp_code",empCode, conn);
						if("A".equalsIgnoreCase(editFlag))
						{
							if(empCode == null || empCode.trim().length() == 0 || "null".equalsIgnoreCase(empCode) )
							{
								System.out.println(" Validaion - NULEMPCODE - Employee is null" );
								errString =  getErrorString("emp_code","NULEMPCODE",userId);
								break ;
							}
							if(cnt > 0)
							{
								System.out.println(" Validaion - VMDUPLE - Employee is Already Present" );
								errCode = "VMDUPLE";
								errString =  getErrorString("emp_code",errCode,userId);
								break ;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("emp_lname"))
					{
						empLname = genericUtility.getColumnValue("emp_lname", dom);
						System.out.println("Employee Last Name ["+empLname+"]");
						if(empLname == null || empLname.trim().length() == 0)
						{
							System.out.println(" Validaion - VEEMP3 - emp_lname is Null" );
							errCode = "VEEMP3";
							errString =  getErrorString("emp_lname",errCode,userId);
							break ;
						}
					}

					if(childNodeName.equalsIgnoreCase("emp_mname"))
					{
						empMname = genericUtility.getColumnValue("emp_mname", dom);
						System.out.println("Employee Middle Name ["+empMname+"]");
						if(empMname == null || empMname.trim().length() == 0)
						{
							System.out.println(" Validaion - VEEMP41 - emp_mname cannot be Null" );
							errCode = "VEEMP41";
							errString =  getErrorString("emp_mname",errCode,userId);
							break ;
						}
					}
					if(childNodeName.equalsIgnoreCase("emp_fname"))
					{
						empFname = genericUtility.getColumnValue("emp_fname", dom);
						System.out.println("Employee First Name ["+empFname+"]");
						if(empFname == null || empFname.trim().length() == 0)
						{
							System.out.println(" Validaion - VEEMP4 - emp_fname is Null" );
							errCode = "VEEMP4";
							errString =  getErrorString("emp_fname",errCode,userId);
							break ;
						}
					}
					if(childNodeName.equalsIgnoreCase("emp_site"))
					{
						String siteCode = genericUtility.getColumnValue("emp_site", dom);
						cnt =  isValueExist("site","site_code",siteCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMSITE1 - Employee Site not present" );
							errCode = "VMSITE1";
							errString =  getErrorString("emp_site",errCode,userId);
							break ;
						}
					}
					if(childNodeName.equalsIgnoreCase("pay_site"))
					{
						String siteCode = genericUtility.getColumnValue("pay_site", dom);
						cnt =  isValueExist("site","site_code",siteCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMSITE1 - Pay Site not present" );
							errCode = "VMSITE1";
							errString =  getErrorString("pay_site",errCode,userId);
							break ;
						}
					}
					if(childNodeName.equalsIgnoreCase("work_site"))
					{
						String siteCode = genericUtility.getColumnValue("work_site", dom);
						cnt =  isValueExist("site","site_code",siteCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMSITE1 - Work Site not present" );
							errCode = "VMSITE1";
							errString =  getErrorString("work_site",errCode,userId);
							break ;
						}
					}
					if(childNodeName.equalsIgnoreCase("dept_code"))
					{
						deptCode = genericUtility.getColumnValue("dept_code", dom);
						System.out.println("Department Code ["+deptCode+"]");
						if(deptCode == null || deptCode.trim().length() == 0)
						{
							System.out.println(" Validaion -For Null Dept Code is Null" );
							errCode = "INVALIDCOD";
							errString =  getErrorString("dept_code",errCode,userId);
							break ;
						}
						cnt =  isValueExist("department","dept_code",deptCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMDEP1 - Dept Does not exits" );
							errCode = "VMDEP1";
							errString =  getErrorString("dept_code",errCode,userId);
							break ;
						}
						else
						{
							status  = getFieldValue("status", "department", "dept_code", deptCode, conn);
							if("I".equalsIgnoreCase(status))
							{
								System.out.println(" Validaion - VTDPINAC - " );
								errCode = "VTDPINAC";
								errString =  getErrorString("dept_code",errCode,userId);
								break ;
							}

						}
					}
					if(childNodeName.equalsIgnoreCase("cadre"))
					{
						cadreCode = checkNull(genericUtility.getColumnValue("cadre", dom));
						System.out.println("Carde Code ["+cadreCode+"]");
						if(cadreCode == null || cadreCode.trim().length() == 0)
						{
							System.out.println(" Validaion -For Null Dept Code is Null" );
							errCode = "NULLCADRE";
							errString =  getErrorString("cadre",errCode,userId);
							break ;
						}
						cnt =  isValueExist("cadre","cadre_code",cadreCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMCAD1 - cadre_code not present" );
							errCode = "VMCAD1";
							errString =  getErrorString("cadre",errCode,userId);
							break ;
						}

					}
					if(childNodeName.equalsIgnoreCase("grade"))
					{
						gradeCode = genericUtility.getColumnValue("grade", dom);
						if(gradeCode == null || gradeCode.trim().length() == 0)
						{
							System.out.println(" Validaion -For Null grade" );
							errCode = "NULLGRADE";
							errString =  getErrorString("grade",errCode,userId);
							break ;
						}
						cnt =  isValueExist("grade","grade_code",gradeCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMGRA1 - grade_code not present" );
							errCode = "VMGRA1";
							errString =  getErrorString("grade",errCode,userId);
							break ;
						}
					}
					if(childNodeName.equalsIgnoreCase("design_code"))
					{
						designCode = checkNull(genericUtility.getColumnValue("design_code", dom));
						if(designCode == null || designCode.trim().length() == 0)
						{
							System.out.println(" Validaion -For Null designCode" );
							errCode = "NULLDESIGN";
							errString =  getErrorString("design_code",errCode,userId);
							break ;
						}
						cnt =  isValueExist("designation","design_code",designCode, conn);
						if(cnt == 0)
						{
							System.out.println(" Validaion - VMDESIGN - design_code not present" );
							errCode = "VMDESIGN";
							errString =  getErrorString("design_code",errCode,userId);
							break ;
						}
						else
						{
							status  = checkNull(getFieldValue("status", "designation", "design_code", designCode, conn));
							if("I".equalsIgnoreCase(status) || "N".equalsIgnoreCase(status))
							{
								System.out.println(" Validaion - VTDGINAC -"  );
								errCode = "VTDGINAC";
								errString =  getErrorString("design_code",errCode,userId);
								break ;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("report_to"))
					{
						System.out.println(" Validaion   for field "+childNodeName);
						reportTo = genericUtility.getColumnValue("report_to", dom);
						empCode = genericUtility.getColumnValue("emp_code", dom);
						if(reportTo != null && reportTo.trim().length() > 0)
						{
							cnt =  isValueExist("employee","emp_code",reportTo, conn);
							if(cnt == 0)
							{
								errCode = "VTEMPCODE";
								errString =  getErrorString("report_to",errCode,userId);
								break ;
							}
							else
							{
								status  = getFieldValue("status", "employee", "emp_code", reportTo, conn);
								if("S".equalsIgnoreCase(status))
								{
									errCode = "VMEMP2";
									errString =  getErrorString("report_to",errCode,userId);
									break ;
								}
								else
								{
									if(empCode.equalsIgnoreCase(reportTo))
									{
										errCode = "VMEMP4";
										errString =  getErrorString("report_to",errCode,userId);
										break ;
									}
								}
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("cur_state"))
					{
						curState = genericUtility.getColumnValue("cur_state", dom);
						if(curState != null && curState.trim().length() > 0)
						{
							cnt =  isValueExist("state","state_code",curState, conn);
							if(cnt == 0)
							{
								errCode = "BLSTATE";
								errString =  getErrorString("cur_state",errCode,userId);
								break ;
							}
						}
						else
						{
							errCode = "VESTATCD1";
							errString =  getErrorString("cur_state",errCode,userId);
							break ;
						}
					}

					if(childNodeName.equalsIgnoreCase("date_join"))
					{
						dateJoinStr = genericUtility.getColumnValue("date_join", dom);
						if(dateJoinStr == null || dateJoinStr.trim().length() == 0)
						{
							errCode = "VMJOIN";
							errString =  getErrorString("date_join",errCode,userId);
							break ;
						}
						else
						{
							joinDate = genericUtility.getDateObject(dateJoinStr);//to be checked as it may throw ParseException
							birthDateStr = genericUtility.getColumnValue("birth_date", dom);
							if(birthDateStr != null && birthDateStr.trim().length() > 0)
							{
								birthDate = genericUtility.getDateObject(birthDateStr);//to be checked as it may throw ParseException
								int compDates = joinDate.compareTo(birthDate);
								if(compDates <= 0 )
								{
									errCode  = "VMJOIN1";
									errString = getErrorString("date_join",errCode,userId);
									break;
								}
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("birth_date"))
					{
						birthDateStr=genericUtility.getColumnValue("birth_date", dom);
						if(birthDateStr == null || birthDateStr.trim().length() == 0)
						{
							errCode   = "VEEMP42";
							errString = getErrorString("birth_date",errCode,userId);
							break;
						}

					}
					if(childNodeName.equalsIgnoreCase("stan_code__hq"))
					{
						stanCodeHq = genericUtility.getColumnValue("stan_code__hq", dom);
						if(stanCodeHq != null && stanCodeHq.trim().length() > 0)
						{
							cnt =  isValueExist("station","stan_code",stanCodeHq, conn);
							if(cnt == 0)
							{
								errCode = "VESTACD1";
								errString =  getErrorString("stan_code__hq",errCode,userId);
								break ;
							}
						}
					}
					if(childNodeName.equalsIgnoreCase("emp_type"))
					{
						String modName = "W_WSFA_EMP_USR_SP";
						String fldName = "EMP_TYPE";
						String empType = genericUtility.getColumnValue("emp_type", dom);
						if(empType == null ||  empType.trim().length() == 0)
						{
							errCode = "VEEMPTY";
							errString =  getErrorString("emp_type",errCode,userId);
							break ;
						}
						else
						{
							sql="SELECT COUNT(1) AS CNT  FROM GENCODES WHERE FLD_NAME= '"+fldName+"' AND MOD_NAME= '"+modName+"' AND FLD_VALUE='"+empType+"'";
							System.out.println("[UserEJB] SQL=>"+sql);
							pstmt = conn.prepareStatement(sql);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt("CNT");
							}
							rs.close();
							pstmt.close();
							if(cnt==0)
							{
								errCode = "INVAEMPTYP";
								errString =  getErrorString("emp_type",errCode,userId);
								break ;
							}

						}
					}
					if(childNodeName.equalsIgnoreCase("hol_tblno"))
					{
						String holtblno = genericUtility.getColumnValue("hol_tblno", dom);
						if(holtblno != null && holtblno.trim().length() > 0)
						{
							cnt =  isValueExist("holiday","hol_tblno",holtblno, conn);
							if(cnt == 0)
							{
								errCode = "VEHOLTBNO";
								errString =  getErrorString("hol_tblno",errCode,userId);
								break ;
							}
						}
						else
						{
							errCode = "VEHOLTBNO";
							errString =  getErrorString("hol_tblno",errCode,userId);
							break ;
						}
					}
					//--------------------------user----------------------------------------------------------

					createUser = genericUtility.getColumnValue("create_user", dom);
					if(createUser != null && createUser.equalsIgnoreCase("Y"))
					{
						if (childNodeName.equalsIgnoreCase("user_code"))
						{
							System.out.println(" << : INSIDE ADD CASE : >> ");
							code = getColumnValue("user_code",dom);
							code = code==null?"":code.trim();
							if(code.length() == 0)
							{
								System.out.println(" code can't be empty or null");
								errString = getErrorString("user_code","VEUSRCODE",userId);
								break;
							}
							else
							{
								empCode = genericUtility.getColumnValue("emp_code", dom);
								int cnt1 =  isValueExist("EMP_USER_SPRS","user_code",code, conn);
								sql="SELECT COUNT(1) AS CNT FROM USERS WHERE CODE = '"+code+"'";
								System.out.println("[UserEJB] SQL=>"+sql);
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("CNT");
								}
								rs.close();
								pstmt.close();
								System.out.println("[UserEJB] CNT=>"+cnt);

								String userCode="";
								sql="SELECT USER_CODE FROM EMP_USER_SPRS WHERE EMP_CODE = '"+empCode+"'";
								System.out.println("[UserEJB] SQL=>"+sql);
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									userCode = rs.getString("USER_CODE");
								}
								rs.close();
								pstmt.close();
								System.out.println("[userCode]=>"+"["+userCode+"]");

								if("A".equalsIgnoreCase(editFlag) && cnt > 0)
								{
									System.out.println("[UserEJB ADD] code can not duplicated(VECDDLP)");
									errString = getErrorString("user_code","VEUSRCDDUP",userId);
									break;
								}
								else if("E".equalsIgnoreCase(editFlag) && (!userCode.equals(code)) && cnt > 0)
								{
									System.out.println("[UserEJB  EDIT] code can not duplicated(VECDDLP)");
									errString = getErrorString("user_code","VEUSRCDDUP",userId);
									break;
								}
							}
						}
						else if (childNodeName.equalsIgnoreCase("name"))
						{
							name = getColumnValue("name",dom);
							name = name==null?"":name.trim();
							if(name.length() == 0)
							{
								errString = getErrorString("name","VEUSREMPT",userId);
								break;
							}
						}
						else if (childNodeName.equalsIgnoreCase("user_pwd"))
						{
							name = getColumnValue("user_pwd",dom);
							name = name==null?"":name.trim();
							if(name.length() == 0)
							{
								errString = getErrorString("user_pwd","VEUSRPWD",userId);
								break;
							}
						}
						else if (childNodeName.equalsIgnoreCase("emp_code"))
						{
							System.out.println("EMP CODE can't be empty or null()");
							String emp_code = getColumnValue("emp_code",dom);
							emp_code = emp_code==null?"":emp_code.trim();
							if(emp_code.length() == 0)
							{

								errString = getErrorString("emp_code","EMPCODE",userId);
								break;
							}
						}
						else if (childNodeName.equalsIgnoreCase("passwd_freq"))
						{
							passFeqS = getColumnValue("passwd_freq",dom);
							passFeq = Integer.parseInt(passFeqS==null?"0":passFeqS.trim());

							if(passFeq > 60 || passFeq==0)
							{
								System.out.println("[UserEJB] Password frequency should not exceed 60 days and cannot be expty");
								errString = getErrorString("passwd_freq","VTPASSFRQ",userId);
								break;
							}
						}
						if(childNodeName.equalsIgnoreCase("delay_prd"))
						{
							delayPeriod=genericUtility.getColumnValue("delay_prd",dom);
							if(delayPeriod == null || delayPeriod.trim().length() == 0)
							{
								errCode   = "VEEMP43";
								errString = getErrorString("delay_prd",errCode,userId);
								break ;
							}
							else
							{
								int delayPrd = Integer.parseInt(delayPeriod) ;
								if(delayPrd<0)
								{
									errCode   = "VEEMP43" ;
									errString = getErrorString("delay_prd",errCode,userId);
									break ;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("last_pwd_chgdate"))
						{
							lastPasswordChgDateStr=genericUtility.getColumnValue("last_pwd_chgdate", dom);
							if(birthDateStr == null || birthDateStr.trim().length() == 0)
							{
								errCode   = "NULLASTPWD";
								errString = getErrorString("last_pwd_chgdate",errCode,userId);
								break;
							}

						}
						if(childNodeName.equalsIgnoreCase("profile_id"))
						{
							profileId=genericUtility.getColumnValue("profile_id",dom);
							if(profileId == null || profileId.trim().length() == 0)
							{
								errCode="VEEMP44";
								errString=getErrorString("profile_id",errCode,userId);
								break;
							}
						}
						if(childNodeName.equalsIgnoreCase("wrong_login_cnt"))
						{
							wrongLoginCnt = genericUtility.getColumnValue("wrong_login_cnt" , dom);
							if(wrongLoginCnt == null || wrongLoginCnt.trim().length() == 0)
							{
								errCode   = "VEEMP53";
								errString = getErrorString("wrong_login_cnt",errCode,userId) ;
								break ;
							}
							else
							{
								int wrongLoginCount = Integer.parseInt(wrongLoginCnt);
								if(wrongLoginCount < 0)
								{
									errCode = "VEEMP53" ;
									errString =getErrorString("wrong_login_cnt",errCode,userId);
									break ;
								}
							}
						}
					}

					//-----------------------------------sales person---------------------------------------
					createsalespers = genericUtility.getColumnValue("create_sales_pers", dom);
					System.out.println("createsalespers====>"+createsalespers);
					if(createsalespers != null && createsalespers.equalsIgnoreCase("Y"))
					{
						if (childNodeName.equalsIgnoreCase("sales_pers"))
						{
							salesPerson = getColumnValue("sales_pers",dom);
							salesPerson = salesPerson==null?"":salesPerson.trim();
							System.out.println("INSIDE SALES PERSON CODE "+salesPerson);
							if(salesPerson.length() == 0)
							{
								System.out.println("  SALES PERSON CAN'T BE NULL OR EMPTY");
								errString = getErrorString("sales_pers","VEEMP45",userId);
								break;
							}
							else
							{
								System.out.println(" << : SALES PERSON INSIDE  ADD CASE : >> ");
								empCode = genericUtility.getColumnValue("emp_code", dom);
								int cnt1 =  isValueExist("EMP_USER_SPRS","sales_pers",salesPerson, conn);
								sql="SELECT COUNT(1) AS CNT FROM SALES_PERS WHERE SALES_PERS = '"+salesPerson+"'";
								System.out.println("[SALES PERSON] SQL=>"+sql);
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("CNT");
								}
								rs.close();
								pstmt.close();
								System.out.println("[SALES PERSON] CNT=>"+cnt);

								String salesPersCode="";
								sql="SELECT SALES_PERS FROM EMP_USER_SPRS WHERE EMP_CODE = '"+empCode+"'";
								System.out.println("[UserEJB] SQL=>"+sql);
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									salesPersCode = rs.getString("SALES_PERS");
								}
								rs.close();
								pstmt.close();
								System.out.println("[salesPersCode]=>"+"["+salesPersCode+"]");
								if("A".equalsIgnoreCase(editFlag)  && cnt > 0 )
								{
									System.out.println(" Sales Person Cannot Duplicate (DUPSALESPR) ADD");
									errString = getErrorString("sales_pers","DUPSALESPR",userId);
									break;
								}
								else if("E".equalsIgnoreCase(editFlag)&& (!salesPersCode.equals(salesPerson))  && cnt > 0)
								{
									System.out.println(" Sales Person Cannot Duplicate (DUPSALESPR) EDIT");
									errString = getErrorString("sales_pers","DUPSALESPR",userId);
									break;
								}

							}
						}

						if (childNodeName.equalsIgnoreCase("item_ser"))
						{
							columnValue = getColumnValue(childNodeName.toLowerCase(),dom);
							if(columnValue != null && columnValue.trim().length() > 0 )
							{
								sql=" SELECT COUNT(1) AS COUNTER FROM ITEMSER WHERE ITEM_SER = '" + columnValue.trim() + "'";
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();

								if(rs.next())
								{
									cnt = rs.getInt("COUNTER");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if(cnt==0)
								{
									System.out.println("Invalid " + childNodeName.toLowerCase() + " entered [" + columnValue + "]");
									errString = getErrorString(childNodeName.toLowerCase(),"VTITEMSER1",userId);
									break;
								}
							}
						}
						if(childNodeName.equalsIgnoreCase("sp_type"))
						{
							String salesPersType=genericUtility.getColumnValue("sp_type",dom);
							String modName = "W_WSFA_EMP_USR_SP";
							String fldName = "SP_TYPE";
							if(salesPersType == null || salesPersType.trim().length() == 0)
							{
								errCode="SPTYPENULL";
								errString=getErrorString("sp_type",errCode,userId);
								break;
							}
							else
							{
								sql="SELECT COUNT(1) AS CNT  FROM GENCODES WHERE FLD_NAME= '"+fldName+"' AND MOD_NAME= '"+modName+"' AND FLD_VALUE='"+salesPersType+"'";
								System.out.println("[UserEJB] SQL=>"+sql);
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt("CNT");
								}
								rs.close();
								pstmt.close();
								if(cnt==0)
								{
									errCode = "INVASALPTY";
									errString =  getErrorString("sp_type",errCode,userId);
									break ;
								}

							}

						}
						if(childNodeName . equalsIgnoreCase("active"))
						{
							active=genericUtility.getColumnValue("active" , dom);
							if(active == null || active.trim().length() == 0)
							{
								errCode="VEEMP46";
								errString=getErrorString("active",errCode,userId);
								System.out.println("active cannot be null or empty");
								break ;
							}
							else
							{
								boolean isYOrN = active.trim().equalsIgnoreCase("y") || active.trim().equalsIgnoreCase("N");
								if( !isYOrN)
								{
									errCode   = "VEEMP46";
									errString = getErrorString("active",errCode,userId);
									System.out.println("active cannot have value other than y and N");
									break;
								}
							}
						}

						if(childNodeName . equalsIgnoreCase("auto_conf"))
						{
							autoConfirm = genericUtility.getColumnValue("auto_conf" , dom);
							if(autoConfirm == null || autoConfirm.trim().length() == 0)
							{
								errCode="VEEMP48";
								errString = getErrorString("auto_conf", errCode, userId);
								break;
							}
							else
							{
								boolean isYOrN = autoConfirm.trim().equalsIgnoreCase("y") || autoConfirm.trim().equalsIgnoreCase("N");
								if( !isYOrN)
								{
									errCode   = "VEEMP48";
									errString = getErrorString("auto_conf",errCode,userId);
									break;
								}
							}
						}
					}
				}

				break;


			}//END SWITCH
		}//END TRY
		catch(Exception e)
		{
			System.out.println("Exception ::"+e);
			e.printStackTrace();
			errString=e.getMessage();
			throw new ITMException(e); //added by Kailash on 11-04-2018
		}
		finally
		{
			try
			{
				if(conn!=null)
				{
					conn.close();
				}
				conn = null;
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}
			System.out.println(" EmpComplete Validation End and Connection is Closed");
		}
		System.out.println("ErrString ::"+errString);
		return errString;
	}//END OF VALIDATION

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String valueXmlString = "";
		try
		{
			dom = parseString(xmlString);
			System.out.println("xmlString" + xmlString);
			dom1 = parseString(xmlString1);
			if(xmlString2.trim().length() > 0 )
			{
				dom2 = parseString(xmlString2);
			}
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [EmpComplete][itemChanged(String,String)] :==>\n"+e.getMessage());
		}
		return valueXmlString;
	}

	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int ctr=0,k=0,childNodeListLength=0;
		String columnValue = null;
		String childNodeName = null;
		String errString = "";
		String errCode = "";
		String designCode="",descr="",reportToAdmin="";
		String contactCode = "" , name = "" ;
		String gradeCode ="",cadreCode="",designation="",joinedAs="",sex="";
		String curAdd1="",perAdd1="",curAdd2="",perAdd2="",curAdd3="",perAdd3="";
		String curPin="",perPin="",curState="",perState="",curCity="",perCity="",state="";
		String empCode="",probationFlag="",confirmedFlag="",trainingPrdStr="",probationPrdStr="";
		String dateJoin="",dateStr="";
		String paySite="",workSite="",gratuityDateStr="";
		String curTel1 ="",perTel1="",perTel="",contactCity="";
		Timestamp dateJoinTs =null,date =null,probationDate =null;
		int trainingPrd=0,probationPrd=0;
		Connection conn = null;
		//Statement stmt = null;//Commented By Shahu Mali on 04-10-13
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String userId = "",loginSite="";
		String mcode = "",empLname = "",empFname = "",query ="";
		String dateJoinStr ="",probationDateStr="";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		UtilMethods utilMethods = UtilMethods.getInstance();
		try
		{
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			/*ConnDriver conndriver = new ConnDriver();
			conn = conndriver.getConnectDB("DriverITM");*/
			conn = getConnection();//chnged by sachin satre on [9-nov-16] to get connection
			loginSite = getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if(objContext != null && objContext.trim().length() > 0)
				k = Integer.parseInt(objContext);
			System.out.println("FORM NO:::" + k);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			System.out.println("****************ITEMCHANGE FOR CASE"+k+"*******************");
			switch(k)
			{
			case 1 :
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				ctr = 0;
				String createSalesPers = genericUtility.getColumnValue("create_sales_pers", dom);
				String createUser = genericUtility.getColumnValue("create_user", dom);

				valueXmlString.append("<Detail1>");
				childNodeListLength = childNodeList.getLength();
				do
				{
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if(childNodeName.equals(currentColumn))
					{
						if (childNode.getFirstChild() != null)
						{
							columnValue=childNode.getFirstChild().getNodeValue().trim();
						}
					}
					ctr++;
				}
				while(ctr < childNodeListLength  && !childNodeName.equals(currentColumn));
				if(currentColumn.trim().equalsIgnoreCase("itm_default"))
				{
					if(createSalesPers != null && createSalesPers.equalsIgnoreCase("N"))
					{
						valueXmlString.append(getIntialSalespers());
					}
					if(createUser != null && createUser.equalsIgnoreCase("N"))
					{
						valueXmlString.append(getIntialuser());
					}
					valueXmlString.append("<emp_site>").append("<![CDATA[]]>").append("</emp_site>");
					valueXmlString.append("<work_site>").append("<![CDATA[]]>").append("</work_site>");
					valueXmlString.append("<pay_site>").append("<![CDATA[]]>").append("</pay_site>");
					java.util.Calendar dateCreated = java.util.Calendar.getInstance();
					java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
					String sysDate = df.format(dateCreated.getTime());
					valueXmlString.append("<last_pwd_chgdate protect = \"1\">").append("<![CDATA[" + sysDate + "]]>").append("</last_pwd_chgdate>");
				}
				if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
				{
					String salesPers = genericUtility.getColumnValue("sales_pers", dom);
					String userCode = genericUtility.getColumnValue("user_code", dom);


					if(createSalesPers != null && createSalesPers.equalsIgnoreCase("N"))
					{
						valueXmlString.append(getIntialSalespers());
					}
					else
					{
						valueXmlString.append("<create_sales_pers protect = \"1\">").append("<![CDATA[Y]]>").append("</create_sales_pers>");
						valueXmlString.append("<sales_pers protect = \"1\">").append("<![CDATA["+salesPers+"]]>").append("</sales_pers>");


					}
					if(createUser != null && createUser.equalsIgnoreCase("N"))
					{
						valueXmlString.append(getIntialuser());
					}
					else
					{
						valueXmlString.append("<create_user protect = \"1\">").append("<![CDATA[Y]]>").append("</create_user>");
						valueXmlString.append("<user_code protect = \"1\">").append("<![CDATA["+userCode+"]]>").append("</user_code>");
					}


				}
				if(currentColumn.trim().equalsIgnoreCase("emp_code"))
				{
					empCode = genericUtility.getColumnValue("emp_code", dom);
					valueXmlString.append(getEmpDetails(empCode,conn));
					int noofUser = isValueExist("users","emp_code",empCode,conn);
					if(noofUser == 1)
					{
						valueXmlString.append("<create_user protect = \"1\">").append("<![CDATA[Y]]>").append("</create_user>");
						valueXmlString.append(getUserDetails(empCode,"emp_code",conn));
					}
					else
					{
						valueXmlString.append("<create_user protect = \"0\">").append("<![CDATA[N]]>").append("</create_user>");
						valueXmlString.append(getIntialuser());
					}
					int noofSalespers = isValueExist("sales_pers","emp_code",empCode,conn);
					if(noofSalespers == 1)
					{
						valueXmlString.append("<create_sales_pers protect = \"1\">").append("<![CDATA[Y]]>").append("</create_sales_pers>");
						valueXmlString.append(getSalesPersDetails(empCode,"emp_code" ,conn));
					}
					else
					{
						valueXmlString.append("<create_sales_pers protect = \"0\">").append("<![CDATA[N]]>").append("</create_sales_pers>");
						valueXmlString.append(getIntialSalespers());
					}

				}

				if(currentColumn.trim().equalsIgnoreCase("design_code"))
				{
					designCode = genericUtility.getColumnValue("design_code", dom);
					descr = getFieldValue("designation", "designation", "design_code", designCode, conn);
					descr = descr == null ? "" : descr;
					valueXmlString.append("<designation>").append("<![CDATA["+descr+"]]>").append("</designation>");
				}
				if(currentColumn.trim().equalsIgnoreCase("contact_code"))
				{
					String lname ="",mname="",fname="";
					int index=0;
					contactCode = genericUtility.getColumnValue("contact_code", dom);
					query =" Select name  from contact  where contact_code = '"+contactCode+"' " ;
					pstmt = conn.prepareStatement(query);
					rs = pstmt.executeQuery();
					System.out.println("Query Executed " + query+ "\n\n******************");
					if(rs.next())
					{
						name = rs.getString("name");
					}
					rs.close();
					pstmt.close();
					System.out.println("name............................"+name);
					empCode = genericUtility.getColumnValue("emp_code", dom);
					if(empCode == null)
					{
						valueXmlString.append("<emp_code>").append("<![CDATA[" + contactCode + "]]>").append("</emp_code>");
					}
					StringTokenizer st = new StringTokenizer(name);
					while (st.hasMoreTokens())
					{
						index++;
						if(index == 1)fname = st.nextToken();
						if(index == 2)mname = st.nextToken();
						if(index == 3)lname = st.nextToken();
					}

					valueXmlString.append("<emp_fname>").append("<![CDATA[" + fname + "]]>").append("</emp_fname>");
					valueXmlString.append("<emp_mname>").append("<![CDATA[" + mname + "]]>").append("</emp_mname>");
					valueXmlString.append("<emp_lname>").append("<![CDATA[" + lname + "]]>").append("</emp_lname>");
				}
				if(currentColumn.trim().equalsIgnoreCase("grade_code"))
				{
					gradeCode = genericUtility.getColumnValue("grade_code", dom);
					cadreCode = genericUtility.getColumnValue("cadre_code", dom);
					if(cadreCode == null)
					{
						cadreCode = getFieldValue("cadre_code", "grade", "grade_code", gradeCode, conn);
						cadreCode = cadreCode == null ? "" : cadreCode;
						valueXmlString.append("<cadre_code>").append("<![CDATA["+cadreCode+"]]>").append("</cadre_code>");
					}
				}
				if(currentColumn.trim().equalsIgnoreCase("designation"))
				{
					designation = genericUtility.getColumnValue("designation", dom);
					joinedAs = genericUtility.getColumnValue("joined_as", dom);
					if(joinedAs == null)
					{
						joinedAs = designation ;

						valueXmlString.append("<joined_as>").append("<![CDATA["+joinedAs+"]]>").append("</joined_as>");
					}
				}
				if(currentColumn.trim().equalsIgnoreCase("sex"))
				{
					sex = genericUtility.getColumnValue("sex", dom);
					if("M".equalsIgnoreCase(sex))
					{
						valueXmlString.append("<name_prefix>").append("<![CDATA["+"Mr"+"]]>").append("</name_prefix>");
					}
					else
					{
						valueXmlString.append("<name_prefix>").append("<![CDATA["+"Ms"+"]]>").append("</name_prefix>");
					}
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_add1"))
				{
					curAdd1 = genericUtility.getColumnValue("cur_add1", dom);
					perAdd1 = genericUtility.getColumnValue("per_add1", dom);
					if(perAdd1 == null || perAdd1.trim().length() ==0)
					{
						perAdd1 = curAdd1;
					}
					valueXmlString.append("<per_add1>").append("<![CDATA[" + perAdd1 + "]]>").append("</per_add1>");
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_add2"))
				{
					curAdd2 = genericUtility.getColumnValue("cur_add2", dom);
					perAdd2 = genericUtility.getColumnValue("per_add2", dom);
					if(perAdd2 == null || perAdd2.trim().length() ==0)
					{
						perAdd2 = curAdd2;
					}
					valueXmlString.append("<per_add2>").append("<![CDATA[" + perAdd2 + "]]>").append("</per_add2>");
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_add3"))
				{

					curAdd3 = genericUtility.getColumnValue("cur_add3", dom);
					perAdd3 = genericUtility.getColumnValue("per_add3", dom);
					if(perAdd3 == null || perAdd3.trim().length() ==0)
					{
						perAdd3 = curAdd3;
					}
					valueXmlString.append("<per_add3>").append("<![CDATA[" + perAdd3 + "]]>").append("</per_add3>");
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_city"))
				{
					curCity = genericUtility.getColumnValue("cur_city", dom);
					perCity = genericUtility.getColumnValue("per_city", dom);
					state = getFieldValue("state_code", "station", "descr", curCity, conn);
					if(perCity == null || perCity.trim().length() ==0)
					{
						perCity = curCity;
					}
					valueXmlString.append("<per_city>").append("<![CDATA[" + perCity + "]]>").append("</per_city>");
					valueXmlString.append("<per_state>").append("<![CDATA[" + state + "]]>").append("</per_state>");
					valueXmlString.append("<cur_state>").append("<![CDATA[" + state + "]]>").append("</cur_state>");
					if(state.trim().length() > 0)
					{
						valueXmlString.append("<cur_state protect = \"1\"></cur_state>");
					}
					else
					{
						valueXmlString.append("<cur_state protect = \"0\"></cur_state>");
					}
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_state"))
				{
					curState = genericUtility.getColumnValue("cur_state", dom);
					perState = genericUtility.getColumnValue("per_state", dom);
					if(perState == null || perState.trim().length() ==0)
					{
						perState = curState;
					}
					valueXmlString.append("<per_state>").append("<![CDATA[" + perState + "]]>").append("</per_state>");
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_pin"))
				{
					curPin = genericUtility.getColumnValue("cur_pin", dom);
					perPin = genericUtility.getColumnValue("per_pin", dom);
					if(perPin == null || perPin.trim().length() ==0)
					{
						perPin = curPin;
					}
					valueXmlString.append("<per_state>").append("<![CDATA[" + perPin + "]]>").append("</per_state>");
				}
				if(currentColumn.trim().equalsIgnoreCase("cur_tel1"))
				{
					curTel1 = genericUtility.getColumnValue("cur_tel1", dom);
					perTel = genericUtility.getColumnValue("per_tel", dom);
					if(perTel == null || perTel.trim().length() ==0)
					{
						perTel = curTel1;
					}
					valueXmlString.append("<per_tel>").append("<![CDATA[" + perTel + "]]>").append("</per_tel>");
				}
				if(currentColumn.trim().equalsIgnoreCase("contact_city"))
				{
					contactCity = genericUtility.getColumnValue("contact_city", dom);
					state = getFieldValue("state_code", "station", "descr", contactCity, conn);
					valueXmlString.append("<contact_state>").append("<![CDATA[" + state + "]]>").append("</contact_state>");
				}
				if(currentColumn.trim().equalsIgnoreCase("date_join"))
				{

					dateJoinStr = genericUtility.getColumnValue("date_join", dom);
					trainingPrdStr = genericUtility.getColumnValue("training_prd", dom);
					valueXmlString.append("<gratuity_date>").append("<![CDATA[" + gratuityDateStr + "]]>").append("</gratuity_date>");
					trainingPrdStr =trainingPrdStr == null ? "0" :trainingPrdStr;
					trainingPrd = Integer.parseInt(trainingPrdStr);
					dateJoinStr= genericUtility.getValidDateString(dateJoinStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) ;
					dateJoinTs = java.sql.Timestamp.valueOf( dateJoinStr+ " 00:00:00.0");
					if(trainingPrd == 0)
					{
						date =  dateJoinTs;
					}
					else
					{
						date = utilMethods.AddMonths(dateJoinTs,trainingPrd);
					}
					dateStr  = getAppDateFormat(date);
					valueXmlString.append("<probation_date>").append("<![CDATA[" + dateStr + "]]>").append("</probation_date>");
					probationPrdStr = genericUtility.getColumnValue("probation_prd", dom);
					probationDateStr = genericUtility.getColumnValue("probation_date", dom);

					probationPrdStr =probationPrdStr == null ? "0" :probationPrdStr;
					probationPrd = Integer.parseInt(probationPrdStr);
					if(probationDateStr != null)
					{
						probationDateStr= genericUtility.getValidDateString(probationDateStr,genericUtility.getApplDateFormat(),genericUtility.getDBDateFormat()) ;
						probationDate = java.sql.Timestamp.valueOf( probationDateStr+ " 00:00:00.0");
					}
					if(probationPrd == 0)
					{
						date = probationDate;
					}
					else
					{
						date = utilMethods.AddMonths(probationDate,probationPrd);
					}
					dateStr  = getAppDateFormat(date);
					valueXmlString.append("<date_conf>").append("<![CDATA[" + dateStr + "]]>").append("</date_conf>");
					if(trainingPrd == 0)
					{
						probationFlag  = "Y";
					}
					else
					{
						probationFlag  = "N";
					}
					if(probationPrd == 0 &&  trainingPrd == 0 )
					{
						confirmedFlag ="Y";
					}
					else
					{
						confirmedFlag ="N";
					}
					valueXmlString.append("<probation>").append("<![CDATA[" + probationFlag + "]]>").append("</probation>");
					valueXmlString.append("<confirmed>").append("<![CDATA[" + confirmedFlag + "]]>").append("</confirmed>");

				}
				if(currentColumn.trim().equalsIgnoreCase("emp_site"))
				{
					mcode = genericUtility.getColumnValue("emp_site", dom);
					paySite = genericUtility.getColumnValue("pay_site", dom);
					if(paySite == null  || paySite.length() ==0 )
					{
						paySite = mcode;
						valueXmlString.append("<pay_site>").append("<![CDATA[" + paySite + "]]>").append("</pay_site>");
					}
					workSite = genericUtility.getColumnValue("work_site", dom);
					if(workSite == null  || workSite.length() ==0 )
					{
						workSite = mcode;
						valueXmlString.append("<work_site>").append("<![CDATA[" + workSite + "]]>").append("</work_site>");
					}
				}
				if(currentColumn.trim().equalsIgnoreCase("pay_mode"))
				{
					mcode = genericUtility.getColumnValue("pay_mode", dom);
					mcode = mcode.trim();
					if("C".equalsIgnoreCase(mcode))
					{
						valueXmlString.append("<bank_code>").append("<![CDATA[" + "" + "]]>").append("</bank_code>");
						valueXmlString.append("<bank_acct>").append("<![CDATA[" + "" + "]]>").append("</bank_acct>");
					}
					else if(! ("D".equalsIgnoreCase(mcode) ) )
					{
						valueXmlString.append("<dd_payable_bank>").append("<![CDATA[" + "" + "]]>").append("</dd_payable_bank>");
					}
				}

				if(currentColumn.trim().equalsIgnoreCase("create_user"))
				{
					if(createUser != null && createUser.equalsIgnoreCase("Y"))
					{
						valueXmlString.append("<user_code protect = \"0\">").append("<![CDATA[]]>").append("</user_code>");
						valueXmlString.append("<login_first protect = \"0\">").append("<![CDATA[1]]>").append("</login_first>");
						valueXmlString.append("<passwd_freq protect = \"0\">").append("<![CDATA[0]]>").append("</passwd_freq>");
						valueXmlString.append("<usr_lev protect = \"0\">").append("<![CDATA[0]]>").append("</usr_lev>");
						valueXmlString.append("<delay_prd protect = \"0\">").append("<![CDATA[]]>").append("</delay_prd>");
						valueXmlString.append("<profile_id protect = \"0\">").append("<![CDATA[]]>").append("</profile_id>");
						valueXmlString.append("<user_type protect = \"0\">").append("<![CDATA[P]]>").append("</user_type>");
						valueXmlString.append("<ascertain_attendance protect = \"0\">").append("<![CDATA[N]]>").append("</ascertain_attendance>");
						valueXmlString.append("<wrong_login_cnt protect = \"0\">").append("<![CDATA[]]>").append("</wrong_login_cnt>");
						valueXmlString.append("<acct_lock protect = \"0\">").append("<![CDATA[N]]>").append("</acct_lock>");
						valueXmlString.append("<profile_id__disp protect = \"0\">").append("<![CDATA[]]>").append("</profile_id__disp>");
						valueXmlString.append("<user_pwd protect = \"0\">").append("<![CDATA[]]>").append("</user_pwd>");
					}
					else
					{
						valueXmlString.append("<user_code protect = \"1\">").append("<![CDATA[]]>").append("</user_code>");
						valueXmlString.append("<login_first protect = \"1\">").append("<![CDATA[]]>").append("</login_first>");
						valueXmlString.append("<passwd_freq protect = \"1\">").append("<![CDATA[]]>").append("</passwd_freq>");
						valueXmlString.append("<usr_lev protect = \"1\">").append("<![CDATA[]]>").append("</usr_lev>");
						valueXmlString.append("<delay_prd protect = \"1\">").append("<![CDATA[]]>").append("</delay_prd>");
						valueXmlString.append("<profile_id protect = \"1\">").append("<![CDATA[]]>").append("</profile_id>");
						valueXmlString.append("<user_type protect = \"1\">").append("<![CDATA[]]>").append("</user_type>");
						valueXmlString.append("<ascertain_attendance protect = \"1\">").append("<![CDATA[]]>").append("</ascertain_attendance>");
						valueXmlString.append("<wrong_login_cnt protect = \"1\">").append("<![CDATA[]]>").append("</wrong_login_cnt>");
						valueXmlString.append("<acct_lock protect = \"1\">").append("<![CDATA[N]]>").append("</acct_lock>");
						valueXmlString.append("<profile_id__disp protect = \"1\">").append("<![CDATA[]]>").append("</profile_id__disp>");
						valueXmlString.append("<user_pwd protect = \"1\">").append("<![CDATA[]]>").append("</user_pwd>");

					}
				}
				if(currentColumn.trim().equalsIgnoreCase("create_sales_pers"))
				{
					if(createSalesPers != null && createSalesPers.equalsIgnoreCase("Y"))
					{
						valueXmlString.append("<sales_pers protect = \"0\">").append("<![CDATA[]]>").append("</sales_pers>");
						valueXmlString.append("<sp_type protect = \"0\">").append("<![CDATA[1]]>").append("</sp_type>");
						valueXmlString.append("<item_ser protect = \"0\">").append("<![CDATA[0]]>").append("</item_ser>");
						valueXmlString.append("<lock_status protect = \"0\">").append("<![CDATA[0]]>").append("</lock_status>");
						valueXmlString.append("<active protect = \"0\">").append("<![CDATA[]]>").append("</active>");
						valueXmlString.append("<auto_conf protect = \"0\">").append("<![CDATA[]]>").append("</auto_conf>");

					}
					else
					{
						valueXmlString.append("<sales_pers protect = \"1\">").append("<![CDATA[]]>").append("</sales_pers>");
						valueXmlString.append("<sp_type protect = \"1\">").append("<![CDATA[1]]>").append("</sp_type>");
						valueXmlString.append("<item_ser protect = \"1\">").append("<![CDATA[0]]>").append("</item_ser>");
						valueXmlString.append("<lock_status protect = \"1\">").append("<![CDATA[0]]>").append("</lock_status>");
						valueXmlString.append("<active protect = \"1\">").append("<![CDATA[]]>").append("</active>");
						valueXmlString.append("<auto_conf protect = \"1\">").append("<![CDATA[]]>").append("</auto_conf>");

					}



				}
				valueXmlString.append("</Detail1>");
				System.out.println("itemchange string :::" +valueXmlString);
				break;
			}// switch end
			valueXmlString.append("</Root>");
		}// try end
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::" + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
					conn.close();
				conn = null;
			}
			catch(Exception e1)
			{
				e1.printStackTrace();
			}

		}
		System.out.println("[EmpComplete] Connection is Closed");
		System.out.println("valueXmlString:::::" + valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String getAppDateFormat(Timestamp timestamp)
	{
		String s = "";
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
		try
		{
			java.util.Date date = null;
			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(timestamp).toString();
		}
		catch(Exception exception)
		{
			System.out.println("Exception in [EmpComplete] getCurrdateAppFormat " + exception.getMessage());
		}
		return s;
	}
	private String getFieldValue(String column,String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String value = null;
		String sql = null;

		sql = " select "+column+" from "+tableName+" where "+columnName+" = '" + columnValue + "' ";
		try
		{
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
			if(rs.next())
			{
				value = rs.getString(1) != null ? rs.getString(1) : " ";
			}
			else
			{
				value = " ";
			}
			rs.close();
			pstmt.close();
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception getFieldValue::" + exception.getMessage());
			throw new ITMException(exception); //added by Kailash on 11-04-2018.
		}
		return value;
	}

	private int isValueExist(String tableName, String columnName, String columnValue,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = null;
		int cnt = 0 ;
		sql = " select count(1) as count from "+tableName+" where "+columnName+" = '" + checkNull(columnValue) + "' ";
		try
		{
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			System.out.println("\n\n\n Query Executed " + sql+ "\n\n******************");
			if(rs.next())
			{
				cnt = rs.getInt("count");
			}
			rs.close();
			pstmt.close();
			System.out.println(" [isValueExist] cnt--------------"+cnt);
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception ::" + exception.getMessage());
			throw new ITMException(exception); //added by Kailash on 11-04-2018.
		}
		return cnt;
	}
	private java.util.Date getRelativeDate(java.util.Date date, int n )
	{
		try
		{
			Calendar  cal = Calendar.getInstance();
			cal.setTime(date);
			cal.add(cal.DATE, n);
			date =  cal.getTime();
			System.out.println("********Relative Date " + date+"************************** ");
		}
		catch(Exception exception)
		{
			exception.printStackTrace();
			System.out.println("Exception ::" + exception.getMessage());
		}
		return date ;
	}
	public String getEnv(String prdCode, String varName,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		String retValue = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			sql = "SELECT VAR_VALUE FROM PAYRPARM "
				+ "WHERE PRD_CODE = '" + prdCode + "' AND VAR_NAME = '" + varName + "'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				retValue = rs.getString(1);
			}
			else
			{
				retValue = "NULLFOUND";
			}
			rs.close();
			pstmt.close();
		}
		catch (SQLException se)
		{
			System.out.println("Exception : :getEnvFin:" + se.getMessage() + ":");
			se.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("Exception : :getEnvFin:" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		return retValue;
	}

	private String getEmpDetails(String empCode,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer("");
		//changed by Rahul Barve on 3-sep-2014
		//GenericUtility genericUtility = GenericUtility.getInstance();
		 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();

		try
		{
			sql = "SELECT EMP_FNAME,EMP_MNAME,EMP_LNAME,NAME_PREFIX,DEPT_CODE,DESIGN_CODE, "
				+"DESIGNATION,GRADE,CADRE,REPORT_TO,SEX,BIRTH_DATE,"
				+"SHORT_NAME,CUR_ADD1,CUR_ADD2,CUR_ADD3,CUR_CITY,CUR_STATE, "
				+"CUR_PIN,CUR_TEL1,CUR_TEL2,CUR_TEL3,MOBILE_NO,EMAIL_ID_OFF, "
				+"EMAIL_ID_PER,EMP_TYPE,HOL_TBLNO,DATE_JOIN,EMP_SITE,STAN_CODE__HQ "
				+" FROM EMPLOYEE WHERE EMP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, empCode);
			System.out.println("Employee code :" + empCode);
			System.out.println("Employee Details Query:" +  sql);

			rs = pstmt.executeQuery();
			if( rs.next())
			{
				valueXmlString.append("<emp_fname><![CDATA[").append(checkNull(rs.getString("EMP_FNAME"))).append("]]></emp_fname>\r\n");
				valueXmlString.append("<emp_mname><![CDATA[").append(checkNull(rs.getString("EMP_MNAME"))).append("]]></emp_mname>\r\n");
				valueXmlString.append("<emp_lname><![CDATA[").append(checkNull(rs.getString("EMP_LNAME"))).append("]]></emp_lname>\r\n");
				valueXmlString.append("<name_prefix><![CDATA[").append(checkNull(rs.getString("NAME_PREFIX"))).append("]]></name_prefix>\r\n");
				valueXmlString.append("<dept_code><![CDATA[").append(checkNull(rs.getString("DEPT_CODE"))).append("]]></dept_code>\r\n");
				valueXmlString.append("<design_code><![CDATA[").append(checkNull(rs.getString("DESIGN_CODE"))).append("]]></design_code>\r\n");
				valueXmlString.append("<designation><![CDATA[").append(checkNull(rs.getString("DESIGNATION"))).append("]]></designation>\r\n");
				valueXmlString.append("<grade><![CDATA[").append(checkNull(rs.getString("GRADE"))).append("]]></grade>\r\n");
				valueXmlString.append("<cadre><![CDATA[").append(checkNull(rs.getString("CADRE"))).append("]]></cadre>\r\n");
				valueXmlString.append("<report_to><![CDATA[").append(checkNull(rs.getString("REPORT_TO"))).append("]]></report_to>\r\n");
				valueXmlString.append("<sex><![CDATA[").append(checkNull(rs.getString("SEX"))).append("]]></sex>\r\n");
				String birthDate = ( checkNull( rs.getString("BIRTH_DATE") ) );
				if(birthDate != "")birthDate = genericUtility.getValidDateString(birthDate, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
				valueXmlString.append("<birth_date><![CDATA[").append( birthDate ).append("]]></birth_date>\r\n");
				valueXmlString.append("<short_name><![CDATA[").append(checkNull(rs.getString("SHORT_NAME"))).append("]]></short_name>\r\n");
				valueXmlString.append("<cur_add1><![CDATA[").append(checkNull(rs.getString("CUR_ADD1"))).append("]]></cur_add1>\r\n");
				valueXmlString.append("<cur_add2><![CDATA[").append(checkNull(rs.getString("CUR_ADD2"))).append("]]></cur_add2>\r\n");
				valueXmlString.append("<cur_add3><![CDATA[").append(checkNull(rs.getString("CUR_ADD3"))).append("]]></cur_add3>\r\n");
				valueXmlString.append("<mobile_no><![CDATA[").append(checkNull(rs.getString("MOBILE_NO"))).append("]]></mobile_no>\r\n");
				valueXmlString.append("<email_id_off><![CDATA[").append(checkNull(rs.getString("EMAIL_ID_OFF"))).append("]]></email_id_off>\r\n");
				valueXmlString.append("<email_id_per><![CDATA[").append(checkNull(rs.getString("EMAIL_ID_PER"))).append("]]></email_id_per>\r\n");
				valueXmlString.append("<emp_type><![CDATA[").append(checkNull(rs.getString("EMP_TYPE"))).append("]]></emp_type>\r\n");
				valueXmlString.append("<hol_tblno><![CDATA[").append(checkNull(rs.getString("HOL_TBLNO"))).append("]]></hol_tblno>\r\n");
				String dateJoin = ( checkNull( rs.getString("date_join") ) );
				if(dateJoin != "")dateJoin = genericUtility.getValidDateString(dateJoin, genericUtility.getDBDateFormat(), genericUtility.getApplDateFormat());
				valueXmlString.append("<date_join><![CDATA[").append(dateJoin).append("]]></date_join>\r\n");
				valueXmlString.append("<emp_site><![CDATA[").append(checkNull(rs.getString("EMP_SITE"))).append("]]></emp_site>\r\n");
				valueXmlString.append("<stan_code__hq><![CDATA[").append(checkNull(rs.getString("STAN_CODE__HQ"))).append("]]></stan_code__hq>\r\n");
				System.out.println("Employee Details :" +  valueXmlString.toString());

			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(pstmt != null)
					pstmt.close();
				if(rs != null)
					rs.close();
			}
			catch(Exception e)
			{
				e.printStackTrace();

			}
		}

		return valueXmlString.toString();
	}

	private String getUserDetails(String columnValue,String ColumnName,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer("");
		try
		{
			//changed by Rahul Barve on 3-sep-2014
			//GenericUtility genericUtility = GenericUtility.getInstance();
			 E12GenericUtility genericUtility = new ibase.utility.E12GenericUtility();
			//Changed SQL satatement and added case expression by Satya on 03/05/10 [WS89FRA008].start
			/*
				sql = "Select code,pass_wd,usr_lev,delay_prd,user_type,passwd_freq,"
				      +"last_pwd_chgdate,ascertain_attendance,acct_lock,login_first,"
					  +"wrong_login_cnt,profile_id__res,"
					  +"profile_id__disp From users where " + ColumnName + " = ?";
			 */
			sql = "Select code,pass_wd, case when usr_lev is null then 0 else usr_lev end as usr_lev,"
				+"case when delay_prd is null then 0 else delay_prd end as delay_prd,"
				+"user_type,"
				+"case when passwd_freq is null then 0 else passwd_freq end as passwd_freq,"
				+"last_pwd_chgdate,ascertain_attendance,acct_lock,login_first,"
				+"case when wrong_login_cnt is null then 0 else wrong_login_cnt end as wrong_login_cnt,"
				+"profile_id__res,"
				+"profile_id__disp,profile_id From users where " + ColumnName + " = ?";

			//Changed SQL satatement and added case expression by Satya on 03/05/10 [WS89FRA008].END
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, columnValue);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				valueXmlString.append("<user_code protect = \"1\"><![CDATA[").append(checkNull(rs.getString("code"))).append("]]></user_code>\r\n");
				// Remarked and changed bellow by Piyush on 27/04/2010 [WS89FRA008]
				//valueXmlString.append("<user_pwd protect = \"0\"><![CDATA[").append(checkNull(rs.getString("pass_wd"))).append("]]></user_pwd>\r\n");
				valueXmlString.append("<user_pwd protect = \"0\"><![CDATA[").append("").append("]]></user_pwd>\r\n");
				valueXmlString.append("<usr_lev protect = \"0\"><![CDATA[").append(rs.getInt("usr_lev")).append("]]></usr_lev>\r\n");
				valueXmlString.append("<delay_prd protect = \"0\"><![CDATA[").append(rs.getInt("delay_prd")).append("]]></delay_prd>\r\n");
				valueXmlString.append("<user_type protect = \"0\"><![CDATA[").append(checkNull(rs.getString("user_type"))).append("]]></user_type>\r\n");
				valueXmlString.append("<passwd_freq protect = \"0\"><![CDATA[").append(rs.getInt("passwd_freq")).append("]]></passwd_freq>\r\n");
				// Added by Piyush on 29/04/2010 [WS89FRA008].Start
				java.util.Calendar dateCreated = java.util.Calendar.getInstance();
				java.text.DateFormat df = new java.text.SimpleDateFormat(genericUtility.getApplDateFormat());
				String sysDate = df.format(dateCreated.getTime());
				valueXmlString.append("<last_pwd_chgdate protect = \"1\">").append("<![CDATA[").append(sysDate).append("]]>").append("</last_pwd_chgdate>");
				// Added by Piyush on 29/04/2010 [WS89FRA008].End

				//valueXmlString.append("<last_pwd_chgdate protect = \"1\"><![CDATA[").append(checkNull(rs.getString("last_pwd_chgdate"))).append("]]></last_pwd_chgdate>\r\n");
				valueXmlString.append("<ascertain_attendance protect = \"0\"><![CDATA[").append(checkNull(rs.getString("ascertain_attendance"))).append("]]></ascertain_attendance>\r\n");
				valueXmlString.append("<acct_lock protect = \"0\"><![CDATA[").append(checkNull(rs.getString("acct_lock"))).append("]]></acct_lock>\r\n");
				valueXmlString.append("<login_first protect = \"0\"><![CDATA[").append(checkNull(rs.getString("login_first"))).append("]]></login_first>\r\n");
				valueXmlString.append("<wrong_login_cnt protect = \"0\"><![CDATA[").append(rs.getInt("wrong_login_cnt")).append("]]></wrong_login_cnt>\r\n");
				valueXmlString.append("<profile_id__res protect = \"0\"><![CDATA[").append(checkNull(rs.getString("profile_id__res"))).append("]]></profile_id__res>\r\n");
				valueXmlString.append("<profile_id__disp protect = \"0\"><![CDATA[").append(checkNull(rs.getString("profile_id__disp"))).append("]]></profile_id__disp>\r\n");
				valueXmlString.append("<profile_id protect = \"0\"><![CDATA[").append(checkNull(rs.getString("profile_id"))).append("]]></profile_id>\r\n");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(pstmt != null)
					pstmt.close();
				if(rs != null)
					rs.close();
			}
			catch(Exception e)
			{
				e.printStackTrace();

			}
		}

		return valueXmlString.toString();

	}


	private String getSalesPersDetails(String columnValue,String ColumnName,Connection conn) throws ITMException // throws added by kailash on 11-04-18.
	{
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer valueXmlString = new StringBuffer("");
		try
		{
			sql = "Select sales_pers,sp_type,item_ser,lock_status,active,"
				+"auto_conf From sales_pers where " + ColumnName + " = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString( 1, columnValue);
			rs = pstmt.executeQuery();
			if( rs.next())
			{
				valueXmlString.append("<sales_pers protect = \"1\"><![CDATA[").append(checkNull(rs.getString("sales_pers"))).append("]]></sales_pers>\r\n");
				valueXmlString.append("<sp_type protect = \"0\"><![CDATA[").append(checkNull(rs.getString("sp_type"))).append("]]></sp_type>\r\n");
				valueXmlString.append("<item_ser protect = \"0\"><![CDATA[").append(checkNull(rs.getString("item_ser"))).append("]]></item_ser>\r\n");
				valueXmlString.append("<lock_status protect = \"0\"><![CDATA[").append(checkNull(rs.getString("lock_status"))).append("]]></lock_status>\r\n");
				valueXmlString.append("<active protect = \"0\"><![CDATA[").append(checkNull(rs.getString("active"))).append("]]></active>\r\n");
				valueXmlString.append("<auto_conf protect = \"0\"><![CDATA[").append(checkNull(rs.getString("auto_conf"))).append("]]></auto_conf>\r\n");
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e); //added by Kailash on 11-04-2018.
		}
		finally
		{
			try
			{
				if(pstmt != null)
					pstmt.close();
				if(rs != null)
					rs.close();
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}

		return  valueXmlString.toString();

	}
	//Method To get default value of sales person for create_sales_pers = 'N'
	private String getIntialSalespers()
	{
		StringBuffer valueXmlString = new StringBuffer();
		valueXmlString.append("<sales_pers protect = \"1\">").append("<![CDATA[]]>").append("</sales_pers>");
		valueXmlString.append("<sp_type protect = \"1\">").append("<![CDATA[]]>").append("</sp_type>");
		valueXmlString.append("<item_ser protect = \"1\">").append("<![CDATA[]]>").append("</item_ser>");
		valueXmlString.append("<lock_status protect = \"1\">").append("<![CDATA[N]]>").append("</lock_status>");
		valueXmlString.append("<active protect = \"1\">").append("<![CDATA[Y]]>").append("</active>");
		valueXmlString.append("<auto_conf protect = \"1\">").append("<![CDATA[N]]>").append("</auto_conf>");
		return valueXmlString.toString();
	}

	//Method To get default value of user for create_user = 'N'
	private String getIntialuser()
	{
		StringBuffer valueXmlString = new StringBuffer();
		valueXmlString.append("<user_code protect = \"1\">").append("<![CDATA[]]>").append("</user_code>");
		valueXmlString.append("<login_first protect = \"1\">").append("<![CDATA[]]>").append("</login_first>");
		valueXmlString.append("<passwd_freq protect = \"1\">").append("<![CDATA[0]]>").append("</passwd_freq>");
		valueXmlString.append("<usr_lev protect = \"1\">").append("<![CDATA[0]]>").append("</usr_lev>");
		valueXmlString.append("<delay_prd protect = \"1\">").append("<![CDATA[0]]>").append("</delay_prd>");
		valueXmlString.append("<profile_id protect = \"1\">").append("<![CDATA[]]>").append("</profile_id>");
		valueXmlString.append("<user_type protect = \"1\">").append("<![CDATA[]]>").append("</user_type>");
		valueXmlString.append("<ascertain_attendance protect = \"1\">").append("<![CDATA[]]>").append("</ascertain_attendance>");
		valueXmlString.append("<wrong_login_cnt protect = \"1\">").append("<![CDATA[0]]>").append("</wrong_login_cnt>");
		valueXmlString.append("<acct_lock protect = \"1\">").append("<![CDATA[]]>").append("</acct_lock>");
		valueXmlString.append("<profile_id__disp protect = \"1\">").append("<![CDATA[]]>").append("</profile_id__disp>");
		valueXmlString.append("<user_pwd protect = \"1\">").append("<![CDATA[]]>").append("</user_pwd>");
		valueXmlString.append("<profile_id protect = \"1\">").append("<![CDATA[]]>").append("</profile_id>");
		return valueXmlString.toString();
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}
}

