/*
 * Decompiled with CFR 0.152.
 */
package ibase.webitm.ejb;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseLogger;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessEJB;
import ibase.webitm.ejb.EventManagerEJB;
import ibase.webitm.ejb.EventManagerLocal;
import ibase.webitm.ejb.ITMXformLocal;
import ibase.webitm.ejb.ITMXformRemote;
import ibase.webitm.utility.DWFactory;
import ibase.webitm.utility.DWObject;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.ReCalculateTax;
import ibase.webitm.utility.XMLBuilder;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.PostActivate;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class ITMXformEJB
implements ITMXformRemote,
ITMXformLocal {
    protected UserInfoBean userInfo = null;
    protected String objContext = "1";
    protected String pageContext;
    protected String editFlag;
    protected String localEditFlag;
    protected String wrkflwProcInstId = null;
    protected String qtyCol = null;
    protected int noOfForms = -1;
    protected String argFieldValues;
    protected String argFieldNames = null;
    protected String argFieldTypes = null;
    protected String headerPKFieldNames = null;
    protected String headerPKFieldValues = null;
    protected String objName;
    protected String viewDomId = "-1";
    protected String headerDomId = "1";
    protected String detailDomId = "-1";
    protected String taxDomId = "-1";
    protected String saveLevel = "";
    protected String rateCol = null;
    protected boolean isTaxChanged = false;
    protected ArrayList taxList = null;
    boolean isCurrentDetailValidated = true;
    transient Node currTaxNode = null;
    protected TreeMap changedDataMap = null;
    transient HashMap headerInfoMap;
    protected String overWriteDefault = "";
    protected transient Document detailDom = null;
    private transient Node currRecordNode = null;
    boolean isRecordValidated = true;
    protected String requestParamStr = null;
    protected String focussedColumn = "";
    protected String currentEventContext = "";
    protected transient Document headerListDom = null;
    final String COLUMN_SEPARATOR = ":";
    final String XTRA_PARAMS_SEPARATOR = "~~";
    protected int recCtr = -1;
    protected boolean isAuditTrailOn = false;
    protected HashMap auditDataMap = null;
    private String user_country = "US";
    private String user_lang = "en";
    transient InitialContext initialContext = null;
    @Resource
    private SessionContext cSessionContext;

    public ITMXformEJB() {
        BaseLogger.log("1", this.userInfo, null, "XfromEJB Created...");
        try {
            this.setInitialContext();
            BaseLogger.log("3", this.userInfo, null, "XfromEJB Created...");
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
    }

    @PostConstruct
    public void ejbCreate() {
        BaseLogger.log("2", this.userInfo, null, "XfromEJB Created...");
        try {
            this.setInitialContext();
            BaseLogger.log("3", this.userInfo, null, "XfromEJB Created...");
            if (CommonConstants.TOMCAT_HOME == null || CommonConstants.TOMCAT_HOME.trim().length() == 0) {
                CommonConstants.setIBASEHOME();
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :ejbCreate :==>" + e);
            e.printStackTrace();
        }
    }

    @Remove
    public void ejbRemove() {
    }

    @PostActivate
    public void ejbActivate() {
        try {
            this.setInitialContext();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :ejbActivate :==>\n" + e);
        }
    }

    public void ejbPassivate() {
    }

    private void setInitialContext() throws ITMException {
        try {
            AppConnectParm appConnect = new AppConnectParm();
            this.initialContext = new InitialContext(appConnect.getProperty());
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException :XfromEJB :setInitialContext :");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :setInitialContext :");
            throw new ITMException(e);
        }
    }

    @Override
    public void setUserInfo(String userInfoStr, String tempDetailXMLStr) throws RemoteException {
        try {
            this.userInfo = new UserInfoBean(userInfoStr);
            if (tempDetailXMLStr != null && tempDetailXMLStr.length() > 0) {
                this.detailDom = this.parseString(tempDetailXMLStr);
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :setUserInfo :==>" + e);
            e.printStackTrace();
        }
    }

    @Override
    public String getPopHelpFields(String objName, UserInfoBean userInfo) throws RemoteException, Exception {
        BaseLogger.log("2", userInfo, null, "[XfromEJB]Getting the PopHelp Field for objName:[" + objName + "]");
        Connection mConnection = null;
        Statement stmt = null;
        String responseStr = null;
        try {
            try {
                StringBuffer tempStringBuff = new StringBuffer();
                String query = "SELECT FIELD_NAME FROM POPHELP WHERE MOD_NAME = 'W_" + objName.toUpperCase() + "'";
                BaseLogger.log("3", userInfo, null, "Query:: [ " + query + " ]");
                ConnDriver mConnDriver = new ConnDriver();
                mConnection = mConnDriver.getConnectDB(userInfo.getTransDB());
                stmt = mConnection.createStatement();
                ResultSet rset = stmt.executeQuery(query);
                ResultSetMetaData rsmd = rset.getMetaData();
                while (rset.next()) {
                    int noOfColumns = rsmd.getColumnCount();
                    int ctr = 1;
                    while (ctr <= noOfColumns) {
                        String colName = rsmd.getColumnName(ctr);
                        if (rset.getString(colName) != null && !rset.getString(colName).equalsIgnoreCase("null") && rset.getString(colName).length() > 0) {
                            tempStringBuff.append(String.valueOf(rset.getString(colName).trim()) + ":");
                        }
                        ++ctr;
                    }
                }
                responseStr = tempStringBuff.toString();
                if (responseStr != null && responseStr.length() > 0) {
                    responseStr = responseStr.substring(0, responseStr.lastIndexOf(":"));
                } else {
                    BaseLogger.log("3", userInfo, null, "No entry for objName [" + objName + "] in Pophelp ");
                }
                stmt.close();
                stmt = null;
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :ITMXformEJB :GETPOPHELPFIELD :==>" + e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            try {
                if (mConnection != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    mConnection.close();
                    mConnection = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception :ITMXformEJB :GETPOPHELPFIELD :\n" + e.getMessage());
                throw new ITMException(e);
            }
        }
        BaseLogger.log("2", userInfo, null, "[XfromEJB]Returning the POPHELPFIELD :" + responseStr);
        return responseStr;
    }

    @Override
    public String getDetailXMLDomString(String objName, String objContext, String editFlag, String pkValues, String argFieldValues, UserInfoBean userInfo) throws RemoteException, ITMException {
        String detailXMLStr = null;
        this.objName = objName;
        boolean isHeaderFocusChanged = true;
        DBAccessEJB dbAccess = null;
        try {
            try {
                dbAccess = new DBAccessEJB();
                ArrayList objFormsDetailList = dbAccess.getObjFormsDetailList(objName, userInfo);
                this.noOfForms = objFormsDetailList.size();
                this.pageContext = "2";
                this.objContext = editFlag.equalsIgnoreCase("A") ? objContext : "1";
                if (Integer.parseInt(this.objContext.trim()) == 1) {
                    if (editFlag != null && editFlag.length() > 0) {
                        this.editFlag = editFlag;
                        this.localEditFlag = editFlag;
                    }
                } else if (editFlag != null && editFlag.length() > 0) {
                    this.localEditFlag = editFlag;
                }
                if (Integer.parseInt(this.objContext.trim()) == 1) {
                    if (this.editFlag.equalsIgnoreCase("A")) {
                        this.setArgFieldValues(argFieldValues);
                        this.headerPKFieldValues = null;
                    }
                    this.createDetailDom(userInfo);
                    detailXMLStr = this.serializeDom(this.detailDom);
                    BaseLogger.log("3", userInfo, null, "Creation of detail dom detailXMLStr [ " + detailXMLStr + " ]");
                } else {
                    if (this.localEditFlag.equalsIgnoreCase("A")) {
                        this.addChildAddDom(userInfo);
                    }
                    this.currRecordNode = this.searchNode(this.detailDom, this.objContext, this.detailDomId);
                    detailXMLStr = this.getNormalizedString(this.serializeDom(this.currRecordNode));
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", userInfo, null, "Exception :XfromEJB :getXMLDataForDetail :==>\n" + e);
                e.printStackTrace();
                throw new ITMException(e);
            }
        }
        finally {
            if (dbAccess != null) {
                dbAccess.remove();
                dbAccess = null;
            }
        }
        BaseLogger.log("2", userInfo, null, "\t\tXXXXXXXEdit XML StartXXXXXXXXX");
        return detailXMLStr;
    }

    private void createDetailDom(UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "[ITMXFORMEJB]In createDetailDom  . . . . . . ");
        String tempDetailXMLStr = null;
        if (this.editFlag.equalsIgnoreCase("A")) {
            tempDetailXMLStr = this.getBlankDomForAdd(this.objName, "1", this.pageContext, this.taxList, this.userInfo.toString());
        }
        this.detailDom = null;
        this.currRecordNode = null;
        this.currTaxNode = null;
        this.detailDom = this.parseString(tempDetailXMLStr);
        if (!this.editFlag.equalsIgnoreCase("V")) {
            this.updateNewDom(null, userInfo);
        }
        BaseLogger.log("2", userInfo, null, "[ITMXFORMEJB]createDetailDom  completed. . . . . . . . . " + tempDetailXMLStr);
    }

    private void addChildAddDom(UserInfoBean userInfo) throws Exception {
        BaseLogger.log("2", userInfo, null, "[ITMXFORMEJB]In addChildAddDom  . . . . . . ");
        Object childAddDom = null;
        String childDomStr = this.getBlankDomForAdd(this.objName, this.objContext, this.pageContext, this.taxList, this.userInfo.toString());
        this.currRecordNode = null;
        this.currTaxNode = null;
        this.appendToDom(this.detailDom, this.parseString(childDomStr), this.objContext);
        this.updateNewDom("A", userInfo);
        this.isCurrentDetailValidated = false;
        BaseLogger.log("2", userInfo, null, "[ITMXFORMEJB]addChildAddDom  completed . . . . . . ");
    }

    private void appendToDom(Document tempParentDom, Document tempChildDom, String childObjContext) throws ITMException {
        try {
            NodeList oriHeaderList = tempParentDom.getElementsByTagName("Header0");
            Node node = oriHeaderList.item(0);
            NodeList newDetailList = tempChildDom.getElementsByTagName("Detail" + childObjContext);
            int len = newDetailList.getLength();
            int j = 0;
            while (j < len) {
                Node nDetail = newDetailList.item(j);
                Node importedNode = tempParentDom.importNode(nDetail, true);
                oriHeaderList.item(0).appendChild(importedNode);
                ++j;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : appendToDom :" + e);
            throw new ITMException(e);
        }
    }

    private void updateNewDom(String editFlag, UserInfoBean userInfoBean) throws Exception {
        DBAccessEJB dbAccess = null;
        editFlag = editFlag == null ? this.localEditFlag : editFlag;
        NodeList detailList = null;
        int detailListLength = -1;
        try {
            try {
                this.userInfo = userInfoBean;
                dbAccess = new DBAccessEJB();
                ArrayList itemChangeList = dbAccess.getItemChangeElementList(this.objName, this.objContext, this.userInfo);
                if (editFlag.equalsIgnoreCase("A")) {
                    detailList = this.searchNodes(this.detailDom, this.objContext);
                    detailListLength = detailList.getLength();
                    Node lastDetailNode = detailList.item(detailListLength - 1);
                    BaseLogger.log("3", this.userInfo, null, "detailListLength :" + detailListLength);
                    this.assignNewDomID(detailList, lastDetailNode, detailListLength);
                    if (Integer.parseInt(this.objContext) > 1) {
                        this.assignPKFieldValues(lastDetailNode);
                    }
                    this.assignArgValues(lastDetailNode, itemChangeList);
                    this.assignNewLineNo(detailList, detailListLength);
                }
                this.assignITMDefaultValues(editFlag, itemChangeList);
                if (Integer.parseInt(this.objContext) == 1 && editFlag.equalsIgnoreCase("A")) {
                    this.assignDefaultValues(this.userInfo.getUserType(), this.userInfo.getEntityCode(), itemChangeList, userInfoBean);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :ITMXformEJB :updateNewDom :==>\n" + e.getMessage());
                e.printStackTrace();
                if (dbAccess != null) {
                    dbAccess.remove();
                    dbAccess = null;
                }
            }
        }
        finally {
            if (dbAccess != null) {
                dbAccess.remove();
                dbAccess = null;
            }
        }
    }

    private void assignNewDomID(NodeList detailList, Node detailNode, int detailListLength) throws Exception {
        int maxDomID = 0;
        int currDomID = -1;
        Node currDetailNode = null;
        Object currDetailChildNodeList = null;
        int detailCtr = 0;
        while (detailCtr < detailListLength) {
            currDetailNode = detailList.item(detailCtr);
            String currDomIDStr = currDetailNode.getAttributes().getNamedItem("domID").getNodeValue();
            BaseLogger.log("3", this.userInfo, null, "currDomIDStr :" + currDomIDStr);
            if (currDomIDStr != null && !currDomIDStr.equals("")) {
                currDomID = Integer.parseInt(currDomIDStr.trim());
            }
            if (currDomID > maxDomID) {
                maxDomID = currDomID;
            }
            ++detailCtr;
        }
        if (Integer.parseInt(this.objContext) > 1) {
            this.detailDomId = String.valueOf(maxDomID + 1);
        }
        detailNode.getAttributes().getNamedItem("domID").setNodeValue(String.valueOf(maxDomID + 1));
        BaseLogger.log("2", this.userInfo, null, "Assigned new Dom id :[" + String.valueOf(maxDomID + 1) + "]");
    }

    private void assignPKFieldValues(Node detailNode) throws Exception {
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]this.headerPKFieldValues :" + this.headerPKFieldValues);
        if (this.headerPKFieldValues != null && this.headerPKFieldValues.length() > 0) {
            NodeList currDetailChildNodeList = detailNode.getChildNodes();
            int noOfDetailChildren = currDetailChildNodeList.getLength();
            StringTokenizer pkNameTokens = new StringTokenizer(this.headerPKFieldNames, ":");
            StringTokenizer pkValueTokens = new StringTokenizer(this.headerPKFieldValues, ":");
            block0: while (pkNameTokens.hasMoreTokens()) {
                String currPKName = pkNameTokens.nextToken();
                String currPKValue = pkValueTokens.nextToken();
                int detailChildCtr = 0;
                while (detailChildCtr < noOfDetailChildren) {
                    Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
                    if (detailChildNode.getNodeName().equalsIgnoreCase(currPKName)) {
                        CDATASection cDataSection = detailChildNode.getOwnerDocument().createCDATASection(currPKValue);
                        if (detailChildNode.getFirstChild() != null) {
                            detailChildNode.replaceChild(cDataSection, detailChildNode.getFirstChild());
                            continue block0;
                        }
                        detailChildNode.appendChild(cDataSection);
                        continue block0;
                    }
                    ++detailChildCtr;
                }
            }
        }
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]Assigned header pk field values....");
    }

    private void assignArgValues(Node detailNode, ArrayList itemChangeList) throws Exception {
        if (this.argFieldValues != null && this.argFieldValues.length() > 0) {
            NodeList currDetailChildNodeList = detailNode.getChildNodes();
            int noOfDetailChildren = currDetailChildNodeList.getLength();
            StringTokenizer argNameTokens = new StringTokenizer(this.argFieldNames, ":");
            StringTokenizer argValueTokens = new StringTokenizer(this.argFieldValues, ":");
            StringTokenizer argTypeTokens = new StringTokenizer(this.argFieldTypes, ":");
            block0: while (argNameTokens.hasMoreTokens()) {
                String currArgName = argNameTokens.nextToken();
                String currArgValue = argValueTokens.nextToken();
                String currArgType = argTypeTokens.nextToken();
                if (currArgName == null || currArgName.length() <= 0) continue;
                int detailChildCtr = 0;
                while (detailChildCtr < noOfDetailChildren) {
                    Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
                    if (detailChildNode.getNodeName().equalsIgnoreCase(currArgName)) {
                        CDATASection cDataSection = detailChildNode.getOwnerDocument().createCDATASection(currArgValue);
                        if (detailChildNode.getFirstChild() != null) {
                            detailChildNode.replaceChild(cDataSection, detailChildNode.getFirstChild());
                        } else {
                            detailChildNode.appendChild(cDataSection);
                        }
                        if (!itemChangeList.contains(currArgName)) continue block0;
                        String tempString = "";
                        tempString = "<?xml version='1.0' encoding='" + CommonConstants.ENCODING + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<focusedColumn><![CDATA[" + currArgName + "]]></focusedColumn>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "<Detail>" + "<" + currArgName + ">" + currArgValue + "</" + currArgName + ">" + "</Detail>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + currArgName;
                        this.applyItemChange(tempString);
                        continue block0;
                    }
                    ++detailChildCtr;
                }
            }
        }
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]Assigned arg field values....");
    }

    public String applyItemChange(String xmlStr) throws RemoteException, ITMException {
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]In applyItemChange. . . . . . . with xmlStr :[" + xmlStr + "]");
        String returnValue = "";
        EventManagerLocal eventManager = null;
        try {
            try {
                String[] inputArr = new String[]{"INPUT_STR", xmlStr};
                this.debug("ItemChange", inputArr, "1");
                this.updateHeaderInfoMap(xmlStr);
                if (this.currRecordNode == null) {
                    this.currRecordNode = this.searchNode(this.detailDom, this.objContext, Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId);
                }
                this.changedDataMap = new TreeMap();
                Document changedStrDom = this.parseString(xmlStr);
                if (((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) {
                    this.handleItemChange(xmlStr);
                    this.changedDataMap.clear();
                    BaseLogger.log("3", this.userInfo, null, "[ITMXFORMEJB] reCalculating tax  ...........");
                    returnValue = this.recalculateTax();
                } else {
                    this.handleItemChange(xmlStr);
                    this.changedDataMap.clear();
                    this.overWriteDefault = "0";
                    this.focussedColumn = (String)this.headerInfoMap.get("focusedColumn");
                    this.currentEventContext = String.valueOf(this.objContext) + ":" + this.focussedColumn;
                    if (this.focussedColumn != null && this.focussedColumn.length() > 0) {
                        eventManager = new EventManagerEJB();
                        eventManager.setUserInfo(this.userInfo);
                        returnValue = eventManager.executeSystemEvent(this.objName, "post_item_change", this.currentEventContext, this.parseString(xmlStr), this.detailDom, this.getXtraParams(), Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId);
                    }
                    if (returnValue != null && returnValue.length() > 0) {
                        Document returnDom;
                        NodeList wsReturnHeaderList;
                        int wsReturnHeaderListLen;
                        if (returnValue.indexOf("<Errors>") == -1) {
                            this.handleItemChange(returnValue);
                            returnValue = this.getChangedXMLString();
                        }
                        if ((wsReturnHeaderListLen = (wsReturnHeaderList = (returnDom = this.parseString(returnValue = returnValue != null && returnValue.length() > 0 ? returnValue : xmlStr)).getElementsByTagName("header").item(0) == null ? returnDom.getElementsByTagName("Header") : returnDom.getElementsByTagName("header")).getLength()) > 0) {
                            int ctr = 0;
                            while (ctr < wsReturnHeaderListLen) {
                                NodeList headerNodeList = changedStrDom.getElementsByTagName("header");
                                int headerNodeListLen = headerNodeList.getLength();
                                int i = 0;
                                while (i < headerNodeListLen) {
                                    Node currHeader = headerNodeList.item(i);
                                    Node updatedNode = returnDom.importNode(currHeader, true);
                                    returnDom.getDocumentElement().replaceChild(updatedNode, wsReturnHeaderList.item(ctr));
                                    ++i;
                                }
                                ++ctr;
                            }
                        } else {
                            NodeList headerNodeList = changedStrDom.getElementsByTagName("header");
                            int headerNodeListLen = headerNodeList.getLength();
                            int j = 0;
                            while (j < headerNodeListLen) {
                                Node currHeader = headerNodeList.item(j);
                                Node importedNode = returnDom.importNode(currHeader, true);
                                returnDom.getDocumentElement().appendChild(importedNode);
                                ++j;
                            }
                        }
                        returnValue = this.serializeDom(returnDom);
                    }
                    if (!((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) {
                        this.isRecordValidated = false;
                    }
                }
                this.changedDataMap.clear();
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception :MasterStatefulException :applyItemChange :==>\n" + e.getMessage());
                e.printStackTrace();
                this.debug("ItemChange :Exception", null, e.getMessage());
                throw new ITMException(e);
            }
        }
        finally {
            this.debug("ItemChange", null, returnValue);
            if (eventManager != null) {
                eventManager.remove();
                eventManager = null;
            }
        }
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]applyItemChange  completed . . . . . . ");
        return returnValue;
    }

    private void assignNewLineNo(NodeList detailList, int detailListLength) throws Exception {
        String lineNoStr = "";
        int maxLineNo = 0;
        int currLineNo = -1;
        Node currDetailNode = null;
        NodeList currDetailChildNodeList = null;
        int detailCtr = 0;
        while (detailCtr < detailListLength - 1) {
            currDetailNode = detailList.item(detailCtr);
            currDetailChildNodeList = currDetailNode.getChildNodes();
            int noOfDetailChildren = currDetailChildNodeList.getLength();
            int detailChildCtr = 0;
            while (detailChildCtr < noOfDetailChildren) {
                Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
                if (detailChildNode.getNodeName().equalsIgnoreCase("LINE_NO") && detailChildNode.getFirstChild() != null) {
                    String currLineNoStr = detailChildNode.getFirstChild().getNodeValue();
                    if (currLineNoStr != null) {
                        currLineNo = Integer.parseInt(currLineNoStr.trim());
                    }
                    if (currLineNo > maxLineNo) {
                        maxLineNo = currLineNo;
                        break;
                    }
                }
                ++detailChildCtr;
            }
            ++detailCtr;
        }
        currDetailNode = detailList.item(detailListLength - 1);
        currDetailChildNodeList = currDetailNode.getChildNodes();
        int noOfDetailChildren = currDetailChildNodeList.getLength();
        int detailChildCtr = 0;
        while (detailChildCtr < noOfDetailChildren) {
            Node detailChildNode = currDetailChildNodeList.item(detailChildCtr);
            if (detailChildNode.getNodeName().equalsIgnoreCase("LINE_NO")) {
                lineNoStr = String.valueOf(maxLineNo + 1);
                DWObject dwObj = this.getDWObject(this.objName, Integer.parseInt(this.objContext));
                HashMap colLogNameTypeMap = dwObj.getColLogNameTypeMap();
                HashMap colLogNameSizeMap = dwObj.getColLogNameSizeMap();
                if (((String)colLogNameTypeMap.get("line_no")).equalsIgnoreCase("char")) {
                    int size = (Integer)colLogNameSizeMap.get("line_no");
                    while (lineNoStr.length() != size) {
                        lineNoStr = " " + lineNoStr;
                    }
                }
                CDATASection cDataSection = currDetailNode.getOwnerDocument().createCDATASection(lineNoStr);
                if (detailChildNode.getFirstChild() != null) {
                    detailChildNode.replaceChild(cDataSection, detailChildNode.getFirstChild());
                    break;
                }
                detailChildNode.appendChild(cDataSection);
                break;
            }
            ++detailChildCtr;
        }
        BaseLogger.log("2", this.userInfo, null, "Assigned new line no :[" + lineNoStr + "]");
    }

    private void assignDefaultValues(String userType, String entityCode, ArrayList itemChangeList, UserInfoBean userInfo) throws Exception {
        Connection con = null;
        Statement stmt = null;
        String transDB = "";
        try {
            try {
                ConnDriver conDriver = null;
                conDriver = new ConnDriver();
                transDB = userInfo.getTransDB();
                con = conDriver.getConnectDB(transDB);
                String sql = "SELECT SITE_ACC_COL,SALES_PERS_ACC_COL,CUST_ACC_COL,SUPP_ACC_COL,ITEM_SER_ACC_COL,EMP_ACC_COL FROM TRANSETUP WHERE TRAN_WINDOW='w_" + this.objName + "'";
                stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                String site_acc_col = null;
                String sales_pers_acc_col = null;
                String cust_acc_col = null;
                String supp_acc_col = null;
                String item_ser_acc_col = null;
                String emp_acc_col = null;
                if (rs.next()) {
                    site_acc_col = rs.getString("SITE_ACC_COL");
                    sales_pers_acc_col = rs.getString("SALES_PERS_ACC_COL");
                    cust_acc_col = rs.getString("CUST_ACC_COL");
                    supp_acc_col = rs.getString("SUPP_ACC_COL");
                    item_ser_acc_col = rs.getString("ITEM_SER_ACC_COL");
                    emp_acc_col = rs.getString("EMP_ACC_COL");
                }
                stmt.close();
                stmt = null;
                boolean isColAssigned = false;
                if (this.userInfo.getUserLevel() != null && Integer.parseInt(this.userInfo.getUserLevel()) > 1) {
                    isColAssigned = true;
                }
                String tempString = "<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>";
                String applString = "";
                if (site_acc_col != null && site_acc_col.length() > 0) {
                    applString = String.valueOf(tempString) + "<focusedColumn><![CDATA[" + site_acc_col.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + site_acc_col.toLowerCase() + (isColAssigned ? " protect='1'>" : ">") + this.userInfo.getSiteCode() + "</" + site_acc_col.toLowerCase() + ">" + "</Detail>" + "</Root>";
                    this.currentEventContext = String.valueOf(this.objContext) + ":" + site_acc_col.toLowerCase();
                    this.applyItemChange(applString);
                }
                if (this.userInfo.getUserType() != null) {
                    if (this.userInfo.getUserType().trim().equalsIgnoreCase("P") && sales_pers_acc_col != null && sales_pers_acc_col.length() > 0) {
                        applString = String.valueOf(tempString) + "<focusedColumn><![CDATA[" + sales_pers_acc_col.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + sales_pers_acc_col.toLowerCase() + (isColAssigned ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + sales_pers_acc_col.toLowerCase() + ">" + "</Detail>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + sales_pers_acc_col.toLowerCase();
                        this.applyItemChange(applString);
                    } else if (this.userInfo.getUserType().trim().equalsIgnoreCase("C") && cust_acc_col != null && cust_acc_col.length() > 0) {
                        applString = String.valueOf(tempString) + "<focusedColumn><![CDATA[" + cust_acc_col.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + cust_acc_col.toLowerCase() + (isColAssigned ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + cust_acc_col.toLowerCase() + ">" + "</Detail>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + cust_acc_col.toLowerCase();
                        this.applyItemChange(applString);
                    } else if (this.userInfo.getUserType().trim().equalsIgnoreCase("S") && supp_acc_col != null && supp_acc_col.length() > 0) {
                        applString = String.valueOf(tempString) + "<focusedColumn><![CDATA[" + supp_acc_col.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + supp_acc_col.toLowerCase() + (isColAssigned ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + supp_acc_col.toLowerCase() + ">" + "</Detail>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + supp_acc_col.toLowerCase();
                        this.applyItemChange(applString);
                    } else if (this.userInfo.getUserType().trim().equalsIgnoreCase("E") && emp_acc_col != null && emp_acc_col.length() > 0) {
                        applString = String.valueOf(tempString) + "<focusedColumn><![CDATA[" + emp_acc_col.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + emp_acc_col.toLowerCase() + (isColAssigned ? " protect='1'>" : ">") + this.userInfo.getEntityCode() + "</" + emp_acc_col.toLowerCase() + ">" + "</Detail>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + emp_acc_col.toLowerCase();
                        this.applyItemChange(applString);
                    } else if (item_ser_acc_col != null && item_ser_acc_col.length() > 0) {
                        applString = String.valueOf(tempString) + "<focusedColumn><![CDATA[" + item_ser_acc_col.toLowerCase() + "]]></focusedColumn>" + "</header>" + "<Detail>" + "<" + item_ser_acc_col.toLowerCase() + (isColAssigned ? " protect='1'>" : ">") + this.userInfo.getItemSer() + "</" + item_ser_acc_col.toLowerCase() + ">" + "</Detail>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + item_ser_acc_col.toLowerCase();
                        this.applyItemChange(applString);
                    }
                }
                BaseLogger.log("3", userInfo, null, "[ITMXFORMEJB]Assigned default values....");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            try {
                if (con != null) {
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                    con.close();
                    con = null;
                }
            }
            catch (Exception e) {
                System.err.println("Exception: ITMXFORMEJB: assignDefaultValues :finally" + e);
                throw e;
            }
        }
    }

    private void assignITMDefaultValues(String editFlag, ArrayList itemChangeList) throws Exception {
        try {
            if (this.requestParamStr != null) {
                StringTokenizer requestParamST = null;
                String elementName = "";
                String elementValue = "";
                if (!this.requestParamStr.equals("")) {
                    requestParamST = new StringTokenizer(this.requestParamStr, "~");
                    while (requestParamST.hasMoreTokens()) {
                        String currentPair = requestParamST.nextToken();
                        elementName = currentPair.substring(0, currentPair.indexOf("="));
                        elementName = elementName.toLowerCase();
                        elementValue = currentPair.substring(currentPair.indexOf("=") + 1);
                        this.setValueOnDom(this.objContext, elementName, elementValue);
                        String tempString = "";
                        tempString = "<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<focusedColumn><![CDATA[" + elementName + "]]></focusedColumn>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "</Root>";
                        this.currentEventContext = String.valueOf(this.objContext) + ":" + elementName;
                        this.applyItemChange(tempString);
                    }
                }
            }
            String fieldName = "";
            if (editFlag.equalsIgnoreCase("A")) {
                fieldName = "itm_default";
            } else if (editFlag.equalsIgnoreCase("E")) {
                fieldName = "itm_defaultedit";
            }
            if (itemChangeList.contains(fieldName)) {
                String tempString = "";
                tempString = "<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?>" + "<Root>" + "<header>" + "<objName><![CDATA[" + this.objName + "]]></objName>" + "<pageContext><![CDATA[" + this.pageContext + "]]></pageContext>" + "<objContext><![CDATA[" + this.objContext + "]]></objContext>" + "<editFlag><![CDATA[" + this.localEditFlag + "]]></editFlag>" + "<focusedColumn><![CDATA[" + fieldName + "]]></focusedColumn>" + "<keyValue><![CDATA[" + (Integer.parseInt(this.objContext.trim()) == 1 ? this.headerDomId : this.detailDomId) + "]]></keyValue>" + "<saveLevel><![CDATA[0]]></saveLevel>" + "<forcedSave><![CDATA[false]]></forcedSave>" + "</header>" + "</Root>";
                this.currentEventContext = String.valueOf(this.objContext) + ":" + fieldName;
                this.applyItemChange(tempString);
            }
            BaseLogger.log("3", this.userInfo, null, "[ITMXFORMEJB]Assigned itm default values....");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private Document parseString(String xmlString) throws ITMException {
        Document dom = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setIgnoringComments(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, this.userInfo.getCharEnc());
            BaseLogger.log("3", this.userInfo, null, "userInfo.getCharEnc() [" + this.userInfo.getCharEnc() + "]");
            ByteArrayInputStream baos = new ByteArrayInputStream(xmlString.getBytes(this.userInfo.getCharEnc()));
            dom = db.parse(baos);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : parseString :" + e);
            throw new ITMException(e);
        }
        return dom;
    }

    private Node searchNode(Document dom, String objContext, String nodeID) throws ITMException {
        Node detailNode = null;
        try {
            objContext = objContext == null || objContext.length() == 0 ? "1" : objContext;
            nodeID = nodeID == null || nodeID.length() == 0 ? "1" : nodeID;
            BaseLogger.log("3", this.userInfo, null, "searchNode : objContext :" + objContext + "nodeID :" + nodeID + ": dom :" + dom);
            NodeList detailList = dom.getElementsByTagName("Detail" + objContext);
            int detListLength = detailList.getLength();
            int ctr = 0;
            while (ctr < detListLength) {
                Node curDetail = detailList.item(ctr);
                if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(nodeID)) {
                    detailNode = curDetail;
                    break;
                }
                ++ctr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : searchNode :" + e);
            throw new ITMException(e);
        }
        return detailNode;
    }

    private String serializeDom(Node dom) throws ITMException {
        String retString = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            if (dom.getNodeType() == 1) {
                serializer.setOutputProperty("omit-xml-declaration", "yes");
            }
            serializer.setOutputProperty("encoding", this.userInfo.getCharEnc());
            serializer.transform(new DOMSource(dom), new StreamResult(out));
            retString = out.toString();
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : serializeDom :" + e);
            throw new ITMException(e);
        }
        return retString;
    }

    private String getNormalizedString(String nodeString) throws ITMException {
        StringBuffer tempStringBuff = new StringBuffer();
        try {
            tempStringBuff.append("<DocumentRoot>");
            tempStringBuff.append("<description>Datawindow Root</description>");
            tempStringBuff.append("<group0>");
            tempStringBuff.append("<description>Group0 description</description>");
            tempStringBuff.append("<Header0>");
            tempStringBuff.append("<description>Header0 members</description>");
            tempStringBuff.append(nodeString);
            tempStringBuff.append("</Header0>");
            tempStringBuff.append("</group0>");
            tempStringBuff.append("</DocumentRoot>");
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
        return tempStringBuff.toString();
    }

    private NodeList searchNodes(Document dom, String objContext) throws ITMException {
        NodeList detailList = null;
        try {
            objContext = objContext == null ? "1" : objContext;
            detailList = dom.getElementsByTagName("Detail" + objContext);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : searchNodes :" + e);
            throw new ITMException(e);
        }
        return detailList;
    }

    private void updateHeaderInfoMap(String xmlStr) throws Exception {
        BaseLogger.log("2", this.userInfo, null, "updateHeaderInfoMap : xmlStr :" + xmlStr);
        HashMap<String, Object> lHeaderInfoMap = null;
        Document xmlStrDoc = null;
        String saveLevel = "";
        String focussedColumn = "";
        String objName = "";
        String editFlag = "";
        String objContext = "";
        String keyValue = "";
        String pkValues = "";
        String action = "";
        String forcedSave = "";
        String clientSideElemName = "";
        String taxInFocus = "false";
        lHeaderInfoMap = new HashMap<String, Object>();
        if (xmlStr != null && !xmlStr.equalsIgnoreCase("-1")) {
            xmlStrDoc = this.parseString(xmlStr);
            if (xmlStrDoc.getElementsByTagName("saveLevel").item(0) != null && xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild() != null) {
                this.saveLevel = xmlStrDoc.getElementsByTagName("saveLevel").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("saveLevel", this.saveLevel);
            }
            if (xmlStrDoc.getElementsByTagName("forcedSave").item(0) != null && xmlStrDoc.getElementsByTagName("forcedSave").item(0).getFirstChild() != null) {
                forcedSave = xmlStrDoc.getElementsByTagName("forcedSave").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("forcedSave", forcedSave);
            }
            if (xmlStrDoc.getElementsByTagName("focusedColumn").item(0) != null && xmlStrDoc.getElementsByTagName("focusedColumn").item(0).getFirstChild() != null) {
                focussedColumn = xmlStrDoc.getElementsByTagName("focusedColumn").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("focusedColumn", focussedColumn);
            }
            if (xmlStrDoc.getElementsByTagName("objName").item(0) != null && xmlStrDoc.getElementsByTagName("objName").item(0).getFirstChild() != null) {
                objName = xmlStrDoc.getElementsByTagName("objName").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("objName", objName);
                if (this.objName == null) {
                    this.objName = objName;
                }
            }
            if (xmlStrDoc.getElementsByTagName("editFlag").item(0) != null && xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild() != null) {
                editFlag = xmlStrDoc.getElementsByTagName("editFlag").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("editFlag", editFlag);
                this.localEditFlag = editFlag;
            }
            if (xmlStrDoc.getElementsByTagName("objContext").item(0) != null && xmlStrDoc.getElementsByTagName("objContext").item(0).getFirstChild() != null) {
                objContext = xmlStrDoc.getElementsByTagName("objContext").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("objContext", objContext);
            }
            if (xmlStrDoc.getElementsByTagName("keyValue").item(0) != null && xmlStrDoc.getElementsByTagName("keyValue").item(0).getFirstChild() != null) {
                keyValue = xmlStrDoc.getElementsByTagName("keyValue").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("keyValue", Integer.parseInt(objContext.trim()) == 1 ? this.headerDomId : keyValue);
            }
            if (xmlStrDoc.getElementsByTagName("pkValues").item(0) != null && xmlStrDoc.getElementsByTagName("pkValues").item(0).getFirstChild() != null) {
                pkValues = xmlStrDoc.getElementsByTagName("pkValues").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("pkValues", pkValues);
            }
            if (xmlStrDoc.getElementsByTagName("action").item(0) != null && xmlStrDoc.getElementsByTagName("action").item(0).getFirstChild() != null) {
                action = xmlStrDoc.getElementsByTagName("action").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("action", action);
            }
            if (xmlStrDoc.getElementsByTagName("elementName").item(0) != null) {
                if (xmlStrDoc.getElementsByTagName("elementName").item(0).getFirstChild() != null) {
                    clientSideElemName = xmlStrDoc.getElementsByTagName("elementName").item(0).getFirstChild().getNodeValue().trim();
                    lHeaderInfoMap.put("elementName", clientSideElemName);
                }
            } else {
                lHeaderInfoMap.put("elementName", clientSideElemName);
            }
            if (xmlStrDoc.getElementsByTagName("taxInFocus").item(0) != null) {
                if (xmlStrDoc.getElementsByTagName("taxInFocus").item(0).getFirstChild() != null) {
                    taxInFocus = xmlStrDoc.getElementsByTagName("taxInFocus").item(0).getFirstChild().getNodeValue().trim();
                    lHeaderInfoMap.put("taxInFocus", Boolean.valueOf(taxInFocus));
                }
            } else {
                lHeaderInfoMap.put("taxInFocus", Boolean.valueOf(taxInFocus));
            }
            if (xmlStrDoc.getElementsByTagName("taxKeyValue").item(0) != null && xmlStrDoc.getElementsByTagName("taxKeyValue").item(0).getFirstChild() != null) {
                this.taxDomId = xmlStrDoc.getElementsByTagName("taxKeyValue").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("taxKeyValue", this.taxDomId);
            }
            if (xmlStrDoc.getElementsByTagName("transKeyValue").item(0) != null && xmlStrDoc.getElementsByTagName("transKeyValue").item(0).getFirstChild() != null) {
                this.headerPKFieldValues = xmlStrDoc.getElementsByTagName("transKeyValue").item(0).getFirstChild().getNodeValue().trim();
            }
            if (xmlStrDoc.getElementsByTagName("wrkflwProcInstId").item(0) != null && xmlStrDoc.getElementsByTagName("wrkflwProcInstId").item(0).getFirstChild() != null) {
                this.wrkflwProcInstId = xmlStrDoc.getElementsByTagName("wrkflwProcInstId").item(0).getFirstChild().getNodeValue().trim();
                BaseLogger.log("3", this.userInfo, null, "this.wrkflwProcInstId [" + this.wrkflwProcInstId + "]");
            }
            if (xmlStrDoc.getElementsByTagName("isModeInteractive").item(0) != null && xmlStrDoc.getElementsByTagName("isModeInteractive").item(0).getFirstChild() != null) {
                String isModeInteractive = xmlStrDoc.getElementsByTagName("isModeInteractive").item(0).getFirstChild().getNodeValue().trim();
                lHeaderInfoMap.put("isModeInteractive", Boolean.valueOf(isModeInteractive));
            }
        }
        if (Integer.parseInt(objContext.trim()) == 1) {
            this.editFlag = this.localEditFlag;
        }
        if (!this.detailDomId.equals(keyValue) || !this.objContext.equals(objContext)) {
            this.currRecordNode = null;
            this.currTaxNode = null;
        }
        this.detailDomId = keyValue;
        this.objContext = objContext;
        this.headerInfoMap = lHeaderInfoMap;
    }

    private String handleItemChange(String xmlStr) throws ITMException {
        block12: {
            BaseLogger.log("9", this.userInfo, null, "handleItemChange called for xmlStr :\n :" + xmlStr);
            try {
                Document xmlStrDoc = null;
                if (xmlStr == null || xmlStr.equals("-1")) break block12;
                xmlStrDoc = this.parseString(xmlStr);
                this.focussedColumn = (String)this.headerInfoMap.get("focusedColumn");
                this.saveLevel = (String)this.headerInfoMap.get("saveLevel");
                String xmlStrObjContext = (String)this.headerInfoMap.get("objContext");
                DWObject dwObject = this.getDWObject(this.objName, Integer.parseInt(xmlStrObjContext.trim()));
                Hashtable dbTypes = dwObject.getUpdateableLogNameColType();
                Node domDetailNode = null;
                BaseLogger.log("3", this.userInfo, null, "Creating domDetailDom for objContext :[" + this.objContext + "] this.headerDomId :[" + this.headerDomId + "] this.detailDomId :[" + this.detailDomId + "]");
                if (xmlStrDoc.getElementsByTagName("Root").item(0) == null) break block12;
                Node rootNode = xmlStrDoc.getElementsByTagName("Root").item(0);
                NodeList xmlStrDetailList = rootNode.getChildNodes();
                int xmlStrDetailListLength = xmlStrDetailList.getLength();
                int i = 0;
                while (i < xmlStrDetailListLength) {
                    Node currXMLStrDetail = xmlStrDetailList.item(i);
                    String tagName = currXMLStrDetail.getNodeName();
                    String formNo = null;
                    String domIdStr = null;
                    BaseLogger.log("3", this.userInfo, null, "tagName [" + tagName + "]");
                    if (tagName.startsWith("Detail")) {
                        String string = formNo = tagName.length() > "Detail".length() ? tagName.substring("Detail".length()) : this.objContext;
                        if (!xmlStrObjContext.trim().equals(formNo)) {
                            dwObject = this.getDWObject(this.objName, Integer.parseInt(formNo));
                            dbTypes = dwObject.getUpdateableLogNameColType();
                        }
                        String string2 = domIdStr = formNo != null && formNo.equalsIgnoreCase("1") ? "1" : null;
                        if (currXMLStrDetail.getAttributes().getNamedItem("domID") != null) {
                            domIdStr = currXMLStrDetail.getAttributes().getNamedItem("domID").getNodeValue();
                        }
                        BaseLogger.log("3", this.userInfo, null, "Searching corresponding data to which changes to be appied domIdStr :[" + domIdStr + "]");
                        BaseLogger.log("3", this.userInfo, null, "is tax in focus :[" + (Boolean)this.headerInfoMap.get("taxInFocus") + "]");
                        if (((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) {
                            String string3 = domIdStr = domIdStr != null && domIdStr.length() > 0 ? domIdStr : (String)this.headerInfoMap.get("taxKeyValue");
                            if (this.currTaxNode == null) {
                                this.currTaxNode = this.getCurrTaxNode();
                            }
                            NodeList taxNodeList = this.currTaxNode.getChildNodes();
                            int taxDomIdCtr = 0;
                            int j = 0;
                            while (j < taxNodeList.getLength()) {
                                Node currTaxNode = taxNodeList.item(j);
                                if (currTaxNode.getNodeType() == 1 && domIdStr.equalsIgnoreCase("" + ++taxDomIdCtr)) {
                                    domDetailNode = currTaxNode;
                                    break;
                                }
                                ++j;
                            }
                        } else {
                            domIdStr = domIdStr != null && domIdStr.length() > 0 ? domIdStr : (String)this.headerInfoMap.get("keyValue");
                            domDetailNode = this.searchNode(this.detailDom, formNo, domIdStr);
                        }
                        this.applyDataToXML(currXMLStrDetail, domDetailNode, dbTypes);
                    }
                    ++i;
                }
                if (this.localEditFlag.equalsIgnoreCase("D")) {
                    domDetailNode = this.searchNode(this.detailDom, this.objContext, (String)this.headerInfoMap.get("keyValue"));
                    this.applyDataToXML(xmlStrDoc, domDetailNode, dbTypes);
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : handleItemChange :" + e);
                throw new ITMException(e);
            }
        }
        return xmlStr;
    }

    private String recalculateTax() throws ITMException {
        String taxChangeStr = "";
        try {
            ReCalculateTax reCalTax = new ReCalculateTax();
            if (this.currTaxNode == null) {
                this.currTaxNode = this.getCurrTaxNode(this.objContext, this.detailDomId);
            }
            reCalTax.setTaxTranDom(this.currRecordNode, this.currTaxNode, this.objContext, this.detailDomId);
            E12GenericUtility e12GenericUtility = new E12GenericUtility();
            DBAccessEJB dbAccess = new DBAccessEJB();
            HashMap objDetailMap = dbAccess.getObjDetailMap(this.objName, this.userInfo);
            String refSer = "";
            String tranDateCol = "";
            if (objDetailMap != null) {
                refSer = objDetailMap.get("REF_SER") != null ? (String)objDetailMap.get("REF_SER") : null;
                tranDateCol = objDetailMap.get("TRAN_DATE_COL") != null ? (String)objDetailMap.get("TRAN_DATE_COL") : "";
            }
            Node currNode = e12GenericUtility.searchNode(this.detailDom, "1", "1");
            String taxDate = this.getValueOfField(currNode, tranDateCol);
            taxChangeStr = reCalTax.reCalculate(this.rateCol, this.qtyCol, this.userInfo, this.getValueOfField(e12GenericUtility.searchNode(this.detailDom, "1", "1"), "curr_code"), refSer, taxDate);
            this.isTaxChanged = true;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : recalculateTax :" + e);
            throw new ITMException(e);
        }
        return taxChangeStr;
    }

    private Node getCurrTaxNode() throws Exception {
        Node taxNode = null;
        try {
            NodeList currRecordChildList = this.currRecordNode.getChildNodes();
            int childListLength = currRecordChildList.getLength();
            int i = 0;
            while (i < childListLength) {
                if (currRecordChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                    taxNode = currRecordChildList.item(i);
                }
                ++i;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception:ITMXFORMEJB: getCurrTaxNode:" + e);
            throw new ITMException(e);
        }
        return taxNode;
    }

    private String getAllTaxesXMLString(String objContext, String domID) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]Getting all taxes string for objContext :" + objContext + ":");
        StringBuffer taxXmlBuff = new StringBuffer();
        String taxesXmlString = "";
        try {
            NodeList detailList = this.detailDom.getElementsByTagName("Detail" + objContext);
            int i = 0;
            while (i < detailList.getLength()) {
                Node currDetail = detailList.item(i);
                if (currDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(domID)) {
                    NodeList currDetailList = currDetail.getChildNodes();
                    int j = 0;
                    while (j < currDetailList.getLength()) {
                        Node currChild = currDetailList.item(j);
                        if (currChild.getNodeName().equalsIgnoreCase("Taxes")) {
                            taxXmlBuff.append(this.serializeDom(currChild)).append("\n");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            taxesXmlString = taxXmlBuff.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMXFORMEJB :getAllTaxesString :==>" + e);
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "changed all taxesXmlString.length() :[" + taxesXmlString.length() + "]");
        return taxesXmlString;
    }

    private Node getCurrTaxNode(String objContext, String domID) throws Exception {
        Node taxNode = null;
        try {
            BaseLogger.log("3", this.userInfo, null, "ITMXFORMEJB : getCurrTaxNode : objContext :" + objContext + ": domID :" + domID + ":");
            Node currNode = this.searchNode(this.detailDom, objContext, domID);
            if (currNode != null) {
                NodeList currRecordChildList = currNode.getChildNodes();
                int childListLength = currRecordChildList.getLength();
                int i = 0;
                while (i < childListLength) {
                    if (currRecordChildList.item(i).getNodeName().equalsIgnoreCase("Taxes")) {
                        taxNode = currRecordChildList.item(i);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception:ITMXFORMEJB: getCurrTaxNode(String objContext, String domID):" + e);
            throw new ITMException(e);
        }
        return taxNode;
    }

    private String getChangedXMLString() throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "Building Changed XML String for ChaNge Data Map size :[" + this.changedDataMap.size() + "]");
        String retString = "";
        try {
            StringBuffer changedXMLStrBuff = new StringBuffer("<?xml version='1.0' encoding='" + this.userInfo.getCharEnc() + "'?><Root>\n");
            if (this.changedDataMap.size() > 0) {
                Set keySet = this.changedDataMap.keySet();
                Iterator iterator = keySet.iterator();
                Object objContext = null;
                Object domID = null;
                boolean i = true;
                ArrayList allList = new ArrayList(this.noOfForms);
                int ctr = 0;
                while (ctr < this.noOfForms) {
                    allList.add(null);
                    ++ctr;
                }
                while (iterator.hasNext()) {
                    StringBuffer currRecordColBuffer;
                    String id = (String)iterator.next();
                    String currObjContext = id.substring(0, id.indexOf("_"));
                    int domIdLen = id.indexOf("_", id.indexOf("_") + 1);
                    String currDomID = id.substring(id.indexOf("_") + 1, domIdLen);
                    String tagName = id.substring(domIdLen + 1);
                    Node curDetChild = (Node)this.changedDataMap.get(id);
                    ArrayList<StringBuffer> currFormList = (ArrayList<StringBuffer>)allList.get(Integer.parseInt(currObjContext) - 1);
                    if (currFormList == null) {
                        currFormList = new ArrayList<StringBuffer>();
                        allList.set(Integer.parseInt(currObjContext) - 1, currFormList);
                    }
                    int currFormListSize = currFormList.size();
                    if (Integer.parseInt(currDomID) > currFormListSize) {
                        while (currFormListSize < Integer.parseInt(currDomID)) {
                            currFormList.add(null);
                            ++currFormListSize;
                        }
                    }
                    if ((currRecordColBuffer = (StringBuffer)currFormList.get(Integer.parseInt(currDomID) - 1)) == null) {
                        currRecordColBuffer = new StringBuffer();
                    }
                    currFormList.set(Integer.parseInt(currDomID) - 1, currRecordColBuffer.append(this.serializeDom(curDetChild)));
                }
                int formCtr = 0;
                while (formCtr < this.noOfForms) {
                    ArrayList currFormList = (ArrayList)allList.get(formCtr);
                    if (currFormList != null) {
                        int noOfRecs = currFormList.size();
                        int recCtr = 0;
                        while (recCtr < noOfRecs) {
                            if (currFormList.get(recCtr) != null) {
                                changedXMLStrBuff.append("<Detail" + (formCtr + 1) + "  domID='" + (recCtr + 1) + "'>");
                                changedXMLStrBuff.append(currFormList.get(recCtr).toString());
                                if (this.isTaxChanged && formCtr + 1 == Integer.parseInt(this.objContext) && recCtr + 1 == Integer.parseInt(this.detailDomId)) {
                                    changedXMLStrBuff.append(this.getAllTaxesXMLString(this.objContext, this.detailDomId));
                                    this.isTaxChanged = false;
                                }
                                changedXMLStrBuff.append("</Detail" + (formCtr + 1) + ">");
                            }
                            ++recCtr;
                        }
                    }
                    ++formCtr;
                }
            }
            if (this.isTaxChanged) {
                changedXMLStrBuff.append("<Detail" + this.objContext + "  domID='" + this.detailDomId + "'>");
                changedXMLStrBuff.append(this.getAllTaxesXMLString(this.objContext, this.detailDomId));
                changedXMLStrBuff.append("</Detail" + this.objContext + ">");
            }
            changedXMLStrBuff.append("</Root>\n");
            retString = changedXMLStrBuff.toString();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMXFORMEJB : getChangedXMLString :" + e);
            throw new ITMException(e);
        }
        return retString;
    }

    private DWObject getDWObject(String objName, int formNo) throws ITMException {
        DWObject dwObject = null;
        try {
            String metaDataFileName = String.valueOf(objName) + "2" + formNo;
            DWFactory dws = new DWFactory();
            dwObject = dws.getDataWindow(metaDataFileName);
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : getDWObject :" + e);
            throw new ITMException(e);
        }
        return dwObject;
    }

    private void setValueOnDom(String objContext, String elementName, String elementValue) throws ITMException {
        try {
            BaseLogger.log("3", this.userInfo, null, "Setting value for obj context :[" + objContext + "] element name :[" + elementName + "] value :[" + elementValue + "]");
            if (objContext == null || objContext != null && objContext.length() > 0) {
                objContext = "1";
            }
            NodeList detailList = this.detailDom.getElementsByTagName("Detail" + objContext);
            int noOfDetails = detailList.getLength();
            int detCtr = 0;
            while (detCtr < noOfDetails) {
                Node detailNode = detailList.item(detCtr);
                NodeList detailChildList = detailNode.getChildNodes();
                int noOfDetailChild = detailChildList.getLength();
                int detChildCtr = 0;
                while (detChildCtr < noOfDetailChild) {
                    Node colNameNode = detailChildList.item(detChildCtr);
                    String nodeName = colNameNode.getNodeName();
                    if (colNameNode.getNodeType() == 1 && nodeName != null && nodeName.equals(elementName)) {
                        Node colValueNode = colNameNode.getFirstChild();
                        if (colValueNode != null && colValueNode.getNodeValue() != null) {
                            colValueNode.setNodeValue(elementValue);
                        } else {
                            CDATASection cDataSection = this.detailDom.createCDATASection(elementValue);
                            colNameNode.appendChild(cDataSection);
                        }
                    }
                    ++detChildCtr;
                }
                ++detCtr;
            }
        }
        catch (Exception e) {
            throw new ITMException(e);
        }
    }

    private void setFocus() throws Exception {
        Document dom = null;
        String localDomId = "1";
        if (this.objContext.equalsIgnoreCase("1")) {
            dom = this.headerListDom;
            localDomId = this.viewDomId;
        } else {
            dom = this.detailDom;
            localDomId = this.detailDomId;
        }
        NodeList detailList = this.searchNodes(dom, this.objContext);
        int detListLength = detailList.getLength();
        int oCtr = 0;
        while (oCtr < detListLength) {
            Node curChild;
            int iCtr;
            int detChildListLength;
            NodeList detailChildList;
            Node curDetail = detailList.item(oCtr);
            if (curDetail.getAttributes().getNamedItem("domID").getNodeValue().equalsIgnoreCase(localDomId)) {
                detailChildList = curDetail.getChildNodes();
                detChildListLength = detailChildList.getLength();
                iCtr = 0;
                while (iCtr < detChildListLength) {
                    curChild = detailChildList.item(iCtr);
                    if (curChild.getNodeName().equalsIgnoreCase("attribute") && curChild.getAttributes().getNamedItem("selected") != null) {
                        curChild.getAttributes().getNamedItem("selected").setNodeValue("Y");
                        break;
                    }
                    ++iCtr;
                }
            } else {
                detailChildList = curDetail.getChildNodes();
                detChildListLength = detailChildList.getLength();
                iCtr = 0;
                while (iCtr < detChildListLength) {
                    curChild = detailChildList.item(iCtr);
                    if (curChild.getNodeName().equalsIgnoreCase("attribute") && curChild.getAttributes().getNamedItem("selected") != null) {
                        curChild.getAttributes().getNamedItem("selected").setNodeValue("N");
                        break;
                    }
                    ++iCtr;
                }
            }
            ++oCtr;
        }
    }

    private void debug(String action, String[] inputStrArr, String responseStr) {
        BufferedWriter logFileWriter = null;
        try {
            if (!"9".equals(CommonConstants.USER_LOG)) {
                return;
            }
            try {
                String logFileName = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "log" + File.separator + this.userInfo.getLoginCode();
                logFileWriter = new BufferedWriter(new FileWriter(logFileName, true));
                if ("1".equals(responseStr)) {
                    logFileWriter.newLine();
                    logFileWriter.write("===================[Start--" + action + "---Start]===================");
                    logFileWriter.newLine();
                    if (this.detailDom != null) {
                        logFileWriter.write("[" + new Date() + "]Detail dom before action :\n[\n" + this.serializeDom(this.detailDom) + "\n]\n");
                    }
                    logFileWriter.newLine();
                    int argCtr = 0;
                    while (argCtr < inputStrArr.length) {
                        logFileWriter.write("[" + new Date() + "]" + action + "[arg name] :[arg value] :[" + inputStrArr[argCtr] + "] :[" + inputStrArr[argCtr + 1] + "]");
                        logFileWriter.newLine();
                        argCtr += 2;
                    }
                } else {
                    logFileWriter.write("[" + new Date() + "]Response to action :[" + action + "] :[" + responseStr + "]");
                    logFileWriter.newLine();
                    if (this.detailDom != null) {
                        logFileWriter.write("[" + new Date() + "]Detail dom after action :\n[\n" + this.serializeDom(this.detailDom) + "\n]\n");
                    }
                    logFileWriter.newLine();
                    logFileWriter.write("===================[End--" + action + "--End]===================");
                    logFileWriter.newLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (logFileWriter != null) {
                    logFileWriter.flush();
                    logFileWriter.close();
                    logFileWriter = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                logFileWriter = null;
            }
        }
    }

    private String getXtraParams() throws Exception {
        StringBuffer xtraParamsBuff = new StringBuffer();
        xtraParamsBuff.append("loginCode=" + this.userInfo.getLoginCode());
        xtraParamsBuff.append("~~").append("loginEmpCode=" + this.userInfo.getEmpCode());
        xtraParamsBuff.append("~~").append("loginSiteCode=" + this.userInfo.getSiteCode());
        xtraParamsBuff.append("~~").append("entityCode=" + this.userInfo.getEntityCode());
        xtraParamsBuff.append("~~").append("profileId=" + this.userInfo.getProfileId());
        xtraParamsBuff.append("~~").append("userType=" + this.userInfo.getUserType());
        xtraParamsBuff.append("~~").append("runMode=I");
        xtraParamsBuff.append("~~").append("user_lang=" + this.user_lang);
        xtraParamsBuff.append("~~").append("user_country=" + this.user_country);
        xtraParamsBuff.append("~~").append("charEnc=" + this.userInfo.getCharEnc());
        xtraParamsBuff.append("~~").append("termId=" + this.userInfo.getRemoteHost());
        String chgTerm = this.userInfo.getRemoteHostName();
        if (chgTerm != null && chgTerm.length() > 15) {
            chgTerm = chgTerm.substring(0, 15);
        } else if (chgTerm == null || chgTerm.length() == 0) {
            chgTerm = this.userInfo.getRemoteHost();
        }
        xtraParamsBuff.append("~~").append("chgTerm=" + chgTerm);
        NodeList detailList = this.searchNodes(this.detailDom, this.objContext);
        int detailListLength = detailList != null ? detailList.getLength() : 0;
        String currDomId = this.objContext.equals("1") ? this.headerDomId : this.detailDomId;
        int focussedRow = -1;
        int detailCnt = 0;
        int i = 0;
        while (i < detailListLength) {
            Node detailNode = detailList.item(i);
            String updateFlag = "";
            NodeList colNodeList = detailNode.getChildNodes();
            int colCnt = colNodeList.getLength();
            int colCtr = 0;
            while (colCtr < colCnt) {
                Node colNode = colNodeList.item(colCtr);
                if (colNode.getNodeName().equalsIgnoreCase("attribute")) {
                    updateFlag = colNode.getAttributes().getNamedItem("updateFlag").getNodeValue();
                    break;
                }
                ++colCtr;
            }
            if (!updateFlag.equalsIgnoreCase("D")) {
                ++detailCnt;
                String domId = detailNode.getAttributes().getNamedItem("domID").getNodeValue();
                if (domId.equals(currDomId)) {
                    focussedRow = detailCnt;
                }
            }
            ++i;
        }
        xtraParamsBuff.append("~~").append("detCnt=" + detailCnt);
        xtraParamsBuff.append("~~").append("focusRow=" + focussedRow);
        if (this.argFieldValues != null && this.argFieldValues.length() > 0) {
            StringTokenizer argNameTokens = new StringTokenizer(this.argFieldNames, ":");
            StringTokenizer argValueTokens = new StringTokenizer(this.argFieldValues, ":");
            while (argNameTokens.hasMoreTokens()) {
                String currArgName = argNameTokens.nextToken();
                String currArgValue = argValueTokens.nextToken();
                if (xtraParamsBuff.toString().indexOf("~~" + currArgName + "=") != -1) continue;
                xtraParamsBuff.append("~~").append(String.valueOf(currArgName) + "=" + currArgValue);
            }
        }
        xtraParamsBuff.append("~~").append("REC_CTR=" + this.recCtr);
        xtraParamsBuff.append("~~").append("saveLevel=" + this.saveLevel);
        BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]XTRA_PARAMS :" + xtraParamsBuff.toString());
        return xtraParamsBuff.toString();
    }

    private String applyDataToXML(Node clientDetailNode, Node domDetailNode, Hashtable dbTypes) throws ITMException {
        String retXMLString;
        block40: {
            BaseLogger.log("2", this.userInfo, null, "[ITMXFORMEJB]Applying Data To Xml ...........");
            retXMLString = "";
            try {
                String domUnitTagName;
                Node curDomDetChild;
                String xmlStrEditFlag = this.localEditFlag;
                boolean isExists = false;
                NodeList domDetailChildList = domDetailNode.getChildNodes();
                int domDetailChildListLength = domDetailChildList.getLength();
                String currDomIDStr = (Boolean)this.headerInfoMap.get("taxInFocus") != false ? this.detailDomId : domDetailNode.getAttributes().getNamedItem("domID").getNodeValue();
                String currObjCtxStr = (Boolean)this.headerInfoMap.get("taxInFocus") != false ? this.objContext : domDetailNode.getAttributes().getNamedItem("objContext").getNodeValue();
                NodeList clientDetailChildList = clientDetailNode.getChildNodes();
                int clientDetailChildListLength = clientDetailChildList.getLength();
                int iCtr = 0;
                while (iCtr < clientDetailChildListLength) {
                    if (clientDetailChildList.item(iCtr).getNodeType() == 1) {
                        String clientDetailUnitTagName = clientDetailChildList.item(iCtr).getNodeName();
                        String clientDetailUnitTagValue = "";
                        Node newNode = clientDetailChildList.item(iCtr).getFirstChild();
                        String dataType = (String)dbTypes.get(clientDetailUnitTagName);
                        BaseLogger.log("3", this.userInfo, null, "dataType" + dataType);
                        if (newNode != null) {
                            clientDetailUnitTagValue = dataType != null && dataType.length() > 0 ? (dataType.toUpperCase().indexOf("XMLTYPE") != -1 ? this.serializeDom(newNode) : newNode.getNodeValue()) : newNode.getNodeValue();
                        }
                        NamedNodeMap attributeMap = clientDetailChildList.item(iCtr).getAttributes();
                        int oCtr = 0;
                        while (oCtr < domDetailChildListLength) {
                            Node curDomDetChild2 = domDetailChildList.item(oCtr);
                            NamedNodeMap currDomAttrMap = curDomDetChild2.getAttributes();
                            String domUnitTagName2 = curDomDetChild2.getNodeName();
                            if (clientDetailUnitTagName.equals(domUnitTagName2)) {
                                CDATASection cDataSection = null;
                                if (dataType != null) {
                                    E12GenericUtility e12GenericUtility = new E12GenericUtility();
                                    String displayDateVal = null;
                                    String displayDataFormat = null;
                                    String validApplDateVal = null;
                                    if (dataType.toUpperCase().indexOf("DATETIME") != -1 || dataType.toUpperCase().indexOf("TIMESTAMP") != -1) {
                                        displayDateVal = clientDetailUnitTagValue;
                                        displayDataFormat = this.getDispDateFormat();
                                        String displayDataTimeFormat = e12GenericUtility.getDispDateTimeFormat();
                                        validApplDateVal = displayDateVal != null && displayDateVal.length() > 0 ? e12GenericUtility.getValidDateTimeString(displayDateVal, e12GenericUtility.getApplDateTimeFormat()) : "";
                                        cDataSection = this.detailDom.createCDATASection(validApplDateVal);
                                    } else if (dataType.toUpperCase().indexOf("DATE") != -1) {
                                        displayDateVal = clientDetailUnitTagValue;
                                        displayDataFormat = this.getDispDateFormat();
                                        validApplDateVal = displayDateVal != null && displayDateVal.length() > 0 ? e12GenericUtility.getValidDateString(displayDateVal, e12GenericUtility.getApplDateFormat()) : "";
                                        cDataSection = this.detailDom.createCDATASection(validApplDateVal);
                                    } else if (dataType.toUpperCase().indexOf("TIME") != -1) {
                                        displayDateVal = clientDetailUnitTagValue;
                                        displayDataFormat = e12GenericUtility.getDisplayTimeFormat();
                                        validApplDateVal = displayDateVal != null && displayDateVal.length() > 0 ? e12GenericUtility.getValidDateString(displayDateVal, displayDataFormat, "hh:mm:ss") : "";
                                        cDataSection = this.detailDom.createCDATASection(validApplDateVal);
                                    } else if (dataType.toUpperCase().indexOf("XMLTYPE") == -1) {
                                        cDataSection = this.detailDom.createCDATASection(clientDetailUnitTagValue);
                                    }
                                } else {
                                    cDataSection = this.detailDom.createCDATASection(clientDetailUnitTagValue);
                                }
                                int currDomAttrMapLength = currDomAttrMap.getLength();
                                int attrCnt = 0;
                                while (attrCnt < attributeMap.getLength()) {
                                    Node eachAttribute = attributeMap.item(attrCnt);
                                    String attributeName = eachAttribute.getNodeName().trim();
                                    String attributeValue = eachAttribute.getNodeValue().trim();
                                    boolean isAttrFound = false;
                                    int currAttrCnt = 0;
                                    while (currAttrCnt < currDomAttrMapLength) {
                                        Node currDetAttr = currDomAttrMap.item(currAttrCnt);
                                        String currAttrName = currDetAttr.getNodeName().trim();
                                        if (attributeName.equals(currAttrName)) {
                                            isAttrFound = true;
                                            currDetAttr.setNodeValue(attributeValue);
                                        }
                                        ++currAttrCnt;
                                    }
                                    if (!isAttrFound) {
                                        ((Element)curDomDetChild2).setAttribute(attributeName, attributeValue);
                                    }
                                    ++attrCnt;
                                }
                                if (domDetailChildList.item(oCtr).getFirstChild() != null) {
                                    if (domDetailChildList.item(oCtr).getFirstChild().getNodeValue() != null) {
                                        BaseLogger.log("3", this.userInfo, null, "Values \t:" + domDetailChildList.item(oCtr).getFirstChild().getNodeValue() + ": BY :" + clientDetailUnitTagValue);
                                    } else {
                                        BaseLogger.log("3", this.userInfo, null, "Values \t:" + this.serializeDom(domDetailChildList.item(oCtr).getFirstChild()) + ": BY :" + clientDetailUnitTagValue);
                                    }
                                } else {
                                    BaseLogger.log("3", this.userInfo, null, "Values \t:: BY :" + clientDetailUnitTagValue);
                                }
                                Node colValueNode = curDomDetChild2.getFirstChild();
                                if (colValueNode != null) {
                                    if (colValueNode.getNodeValue() != null) {
                                        colValueNode.setNodeValue(clientDetailUnitTagValue);
                                    } else if (dataType != null && dataType.length() > 0 && dataType.toUpperCase().indexOf("XMLTYPE") != -1) {
                                        curDomDetChild2.replaceChild(curDomDetChild2.getOwnerDocument().importNode(newNode, true), curDomDetChild2.getFirstChild());
                                    }
                                } else {
                                    curDomDetChild2.appendChild(cDataSection);
                                }
                                BaseLogger.log("3", this.userInfo, null, "REPLACED.........");
                                String key = String.valueOf(currObjCtxStr) + "_" + currDomIDStr + "_" + clientDetailUnitTagName;
                                if (!this.changedDataMap.containsKey(key)) {
                                    BaseLogger.log("3", this.userInfo, null, "key :" + key);
                                    this.changedDataMap.put(key, curDomDetChild2);
                                }
                                if (!this.isAuditTrailOn) break;
                                TreeMap currFormMap = this.auditDataMap.get(currObjCtxStr) != null ? (TreeMap)this.auditDataMap.get(currObjCtxStr) : new TreeMap();
                                String tempKey = String.valueOf(currDomIDStr) + "_" + clientDetailUnitTagName;
                                currFormMap.put(tempKey, clientDetailUnitTagValue);
                                this.auditDataMap.put(currObjCtxStr, currFormMap);
                                BaseLogger.log("3", this.userInfo, null, "auditDataMap [" + this.auditDataMap + "]");
                                break;
                            }
                            ++oCtr;
                        }
                    }
                    ++iCtr;
                }
                int oCtr = 0;
                while (oCtr < domDetailChildListLength) {
                    curDomDetChild = domDetailChildList.item(oCtr);
                    domUnitTagName = curDomDetChild.getNodeName();
                    String statusInDom = null;
                    if (domUnitTagName.equalsIgnoreCase("attribute")) {
                        if (curDomDetChild.getAttributes().getNamedItem("status") != null && (statusInDom = curDomDetChild.getAttributes().getNamedItem("status").getNodeValue()).equalsIgnoreCase("O")) {
                            isExists = true;
                        }
                        if (curDomDetChild.getAttributes().getNamedItem("updateFlag") == null || curDomDetChild.getAttributes().getNamedItem("updateFlag").getNodeValue().equals("D")) break;
                        if (isExists) {
                            if (xmlStrEditFlag.equalsIgnoreCase("D")) {
                                if (this.objContext.equals(currObjCtxStr) && this.headerInfoMap.get("keyValue").equals(currDomIDStr)) {
                                    curDomDetChild.getAttributes().getNamedItem("updateFlag").setNodeValue(xmlStrEditFlag);
                                    if (!this.isAuditTrailOn) break;
                                    this.updateAuditDataMap(currObjCtxStr, currDomIDStr, domDetailNode);
                                    break;
                                }
                                curDomDetChild.getAttributes().getNamedItem("updateFlag").setNodeValue("E");
                                break;
                            }
                            curDomDetChild.getAttributes().getNamedItem("updateFlag").setNodeValue("E");
                            break;
                        }
                        if (!xmlStrEditFlag.equalsIgnoreCase("D") || !this.objContext.equals(currObjCtxStr) || !this.headerInfoMap.get("keyValue").equals(currDomIDStr)) break;
                        BaseLogger.log("3", this.userInfo, null, "Deleting newly added record from DOM........");
                        this.detailDom.getElementsByTagName("Header0").item(0).removeChild(domDetailNode);
                        break;
                    }
                    ++oCtr;
                }
                BaseLogger.log("3", this.userInfo, null, "Is Tax in Focus :[" + (Boolean)this.headerInfoMap.get("taxInFocus") + "]");
                BaseLogger.log("3", this.userInfo, null, "[currentRecordId==focussedRowId][" + currDomIDStr + "==" + this.headerInfoMap.get("keyValue") + "]");
                if (!((Boolean)this.headerInfoMap.get("taxInFocus")).booleanValue()) break block40;
                oCtr = 0;
                while (oCtr < domDetailChildListLength) {
                    if (this.objContext.equals(currObjCtxStr) && this.headerInfoMap.get("keyValue").equals(currDomIDStr) && (domUnitTagName = (curDomDetChild = domDetailChildList.item(oCtr)).getNodeName()).equalsIgnoreCase("chg_stat")) {
                        BaseLogger.log("3", this.userInfo, null, "Updating chg_stat as FROZEN for the edited Tax Record....");
                        if (curDomDetChild.getFirstChild() != null) {
                            curDomDetChild.getFirstChild().setNodeValue("F");
                        } else {
                            CDATASection cDataSection = this.detailDom.createCDATASection("F");
                            curDomDetChild.appendChild(cDataSection);
                        }
                        BaseLogger.log("3", this.userInfo, null, "Updated chg_stat as FROZEN....");
                        break;
                    }
                    ++oCtr;
                }
            }
            catch (Exception e) {
                BaseLogger.log("0", this.userInfo, null, "Exception : ITMXFORMEJB : applyDataToXML :" + e);
                throw new ITMException(e);
            }
        }
        return retXMLString;
    }

    private String getDispDateFormat() throws ITMException, Exception {
        String dateFormatStr = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml");
            NodeList nlDateFormat = doc.getElementsByTagName("DISP_DATE_FORMAT");
            Node ndDateFormat = nlDateFormat.item(0);
            dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :ITMXFORMEJB :getDispDateFormat :==>\n" + e);
            throw new ITMException(e);
        }
        return dateFormatStr;
    }

    private void updateAuditDataMap(String currObjCtxStr, String currDomIDStr, Node domDetailNode) {
        try {
            NodeList domDetailNodeList = domDetailNode.getChildNodes();
            int detailNodesLen = domDetailNodeList.getLength();
            int i = 0;
            while (i < detailNodesLen) {
                Node currNode = domDetailNodeList.item(i);
                String nodeName = currNode.getNodeName();
                String nodeValue = currNode.getNodeValue();
                if (!"attribute".equals(nodeName)) {
                    String tempKey = String.valueOf(currDomIDStr) + "_" + nodeName;
                    if (this.auditDataMap.get(currObjCtxStr) != null) {
                        BaseLogger.log("3", this.userInfo, null, "auditDataMap old objContext [" + currObjCtxStr + "] for key [" + tempKey + "] Value [" + nodeValue + "]");
                        ((TreeMap)this.auditDataMap.get(currObjCtxStr)).put(tempKey, nodeValue);
                    } else {
                        BaseLogger.log("3", this.userInfo, null, "auditDataMap new objContext [" + currObjCtxStr + "] for key [" + tempKey + "] Value [" + nodeValue + "]");
                        TreeMap<String, String> tempMap = new TreeMap<String, String>();
                        tempMap.put(tempKey, nodeValue);
                        this.auditDataMap.put(currObjCtxStr, tempMap);
                    }
                }
                ++i;
            }
            BaseLogger.log("3", this.userInfo, null, "After updateAuditDataMap auditDataMap [" + this.auditDataMap + "]");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setArgFieldValues(String argFieldValues) throws RemoteException, ITMException {
        try {
            String argFieldValuesNew = "";
            if (argFieldValues != null && argFieldValues.length() > 0) {
                BaseLogger.log("3", this.userInfo, null, "[XfromEJB]this.argFieldTypes :" + this.argFieldTypes);
                StringTokenizer argValueTokens = new StringTokenizer(argFieldValues, ":");
                StringTokenizer argTypeTokens = new StringTokenizer(this.argFieldTypes, ":");
                while (argTypeTokens.hasMoreTokens() && argValueTokens.hasMoreTokens()) {
                    String currArgType = argTypeTokens.nextToken();
                    String currArgValue = argValueTokens.nextToken();
                    argFieldValuesNew = currArgType.equalsIgnoreCase("DATETIME") || currArgType.equalsIgnoreCase("DATE") ? String.valueOf(argFieldValuesNew) + (currArgValue != null && currArgValue.length() > 0 ? this.getValidDateString(currArgValue, this.getDispDateFormat(), this.getApplDateFormat()) : currArgValue) : String.valueOf(argFieldValuesNew) + currArgValue;
                    argFieldValuesNew = String.valueOf(argFieldValuesNew) + ":";
                }
                BaseLogger.log("3", this.userInfo, null, "[XfromEJB]argFieldValuesNew :" + argFieldValuesNew);
                this.argFieldValues = argFieldValuesNew;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :argFieldValues :==>");
            e.printStackTrace();
            throw new ITMException(e);
        }
    }

    private String getValidDateString(String dateStr, String sourceDateFormat, String targetDateFormat) throws ITMException {
        BaseLogger.log("2", this.userInfo, null, "[XfromEJB]Converting dateStr :[" + dateStr + "] From format :[" + sourceDateFormat + "] To Format :[" + targetDateFormat + "]");
        Date date = null;
        String retDateStr = "";
        try {
            if (!sourceDateFormat.equalsIgnoreCase(targetDateFormat)) {
                if (sourceDateFormat.indexOf("/") != -1) {
                    dateStr.replace('/', '-');
                } else if (sourceDateFormat.indexOf(".") != -1) {
                    dateStr.replace('.', '-');
                }
                date = new SimpleDateFormat(sourceDateFormat).parse(dateStr);
                SimpleDateFormat sdfOutput = new SimpleDateFormat(targetDateFormat);
                retDateStr = sdfOutput.format((Object)date);
            } else {
                retDateStr = dateStr;
            }
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :XfromEJB :getValidDateString :==>" + e.getMessage());
            throw new ITMException(e);
        }
        BaseLogger.log("2", this.userInfo, null, "[XfromEJB]Converted Datestr :[" + retDateStr + "]");
        return retDateStr;
    }

    private String getApplDateFormat() throws ITMException, Exception {
        String dateFormatStr = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(String.valueOf(CommonConstants.APPLICATION_CONTEXT) + File.separator + "setting" + File.separator + "DateFormat.xml");
            NodeList nlDateFormat = doc.getElementsByTagName("APPL_DATE_FORMAT");
            Node ndDateFormat = nlDateFormat.item(0);
            dateFormatStr = ndDateFormat.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception :DB2XMLGenerator :getApplDateFormat :==>\n" + e);
            throw new ITMException(e);
        }
        return dateFormatStr;
    }

    public String getBlankDomForAdd(String objName, String objContext, String pageContext, ArrayList taxList, String userInfoStr) throws RemoteException, ITMException {
        String blankDomStr = "";
        Object blankDom = null;
        try {
            XMLBuilder xmlBuilder = new XMLBuilder();
            if (userInfoStr != null && userInfoStr.length() > 0) {
                this.userInfo = new UserInfoBean(userInfoStr);
            }
            String defaultPathForMetadataXML = "";
            BaseLogger.log("3", this.userInfo, null, "Creating xml from bin metadata");
            defaultPathForMetadataXML = String.valueOf(CommonConstants.JBOSSHOME) + File.separator + "server" + File.separator + "default" + File.separator + "deploy" + File.separator + "ibase.ear" + File.separator + "metadata" + File.separator;
            String standardNameForXML = String.valueOf(objName) + pageContext + objContext + ".xml";
            blankDomStr = xmlBuilder.getDomForAdd(objName, objContext, String.valueOf(defaultPathForMetadataXML) + standardNameForXML, this.userInfo);
        }
        catch (ITMException itme) {
            BaseLogger.log("0", this.userInfo, null, "ITMException: ITMXFORMEJB: getBlankDomForAdd: ==>\n");
            throw itme;
        }
        catch (Exception e) {
            BaseLogger.log("0", this.userInfo, null, "Exception: ITMXFORMEJB: getBlankDomForAdd: ==>\n" + e);
            e.printStackTrace();
            throw new ITMException(e);
        }
        return blankDomStr;
    }

    private String getValueOfField(Node node, String currFieldName) throws Exception {
        String currFieldValue = null;
        NodeList childNodeList = node.getChildNodes();
        int noOfChilds = childNodeList.getLength();
        int ctr = 0;
        while (ctr < noOfChilds) {
            Node currChild = childNodeList.item(ctr);
            if (currChild.getNodeName().equalsIgnoreCase(currFieldName) && currChild.getFirstChild() != null) {
                currFieldValue = currChild.getFirstChild().getNodeValue();
                break;
            }
            ++ctr;
        }
        return currFieldValue;
    }
}

